0 REM---------------------------------------------------------------
1 REM UNIT TEST FOR KERNAL API:
2 REM   MEMORY_FILL
3 REM   MEMORY_COPY
4 REM   MEMORY_CRC
5 REM   MEMORY_DECOMPRESS
6 REM---------------------------------------------------------------
7 REM (C)2019 Michael Steil, License: 2-clause BSD

10 REM INITIALIZE $8000-$8FFF WITH 0
20 POKE2,$00:POKE3,$80:POKE4,$00:POKE5,$10:POKE780,0:SYS$FEE4

100 REM *** 1: FILL $8001-$8100 (FULL PAGE)
110 POKE2,$01:POKE3,$80:POKE4,$00:POKE5,$01:POKE780,1:SYS$FEE4
120 FORI=$8001TO$8100:IFPEEK(I)<>1THENPRINT"FAIL 1A AT";I:END
130 NEXT
140 IFPEEK($8000)ORPEEK($8101)THENPRINT"FAIL 1B":END

200 REM *** 2: FILL $81F0-$827F (PARTIAL PAGE)
210 POKE2,$F0:POKE3,$81:POKE4,$90:POKE5,$00:POKE780,2:SYS$FEE4
220 FORI=$81F0TO$827F:IFPEEK(I)<>2THENPRINT"FAIL 2A AT";I:END
230 NEXT
240 IFPEEK($81EF)ORPEEK($8280)THENPRINT"FAIL 2B":END

300 REM *** 3: FILL $82F0-$840F (FULL AND PARTIAL PAGE)
310 POKE2,$F0:POKE3,$82:POKE4,$20:POKE5,$01:POKE780,3:SYS$FEE4
320 FORI=$82F0TO$840F:IFPEEK(I)<>3THENPRINT"FAIL 3A AT";I:END
330 NEXT
340 IFPEEK($82EF)ORPEEK($8410)THENPRINT"FAIL 3B":END

400 REM *** CRC16 OF $8500-$85D9
410 FORI=0TO217:READA:POKE$8500+I,A:NEXT : REM UNCOMPRESSED DATA
420 POKE2,$00:POKE3,$85:POKE4,$DA:POKE5,$00:SYS$FEEA
430 IFPEEK(6)<>$BBORPEEK(7)<>$E1THENPRINT"FAIL 4":END

500 REM *** 5: DECOMPRESS $8600-$86B3 TO $8700
510 FORI=0TO179:READA:POKE$8600+I,A:NEXT : REM COMPRESSED DATA
520 POKE2,$00:POKE3,$86:POKE4,0:POKE5,$87:SYS$FEED
530 FORI=0TO217:IFPEEK($8500+I)<>PEEK($8700+I)THENPRINT"FAIL 5":END
540 NEXT

600 REM *** 6: COPY NON-OVERLAPPING
605 REM REFERENCE DATA
610 POKE2,$00:POKE3,$C0:POKE4,$00:POKE5,$90:POKE6,$00:POKE7,$08:SYS$FEE7
615 REM COPY
620 POKE2,$C0:POKE3,$90:POKE4,$00:POKE5,$98:POKE6,$10:POKE7,$01:SYS$FEE7
630 FORI=0TO$10F:IFPEEK($90C0+I)<>PEEK($9800+I)THENPRINT"FAIL 6 AT";I:END
640 NEXT

700 REM *** 7: COPY OVERLAPPING (UP)
705 REM REFERENCE DATA
710 POKE2,$00:POKE3,$C0:POKE4,$00:POKE5,$90:POKE6,$00:POKE7,$08:SYS$FEE7
715 REM COPY OF REFERENCE DATA
720 POKE2,$00:POKE3,$90:POKE4,$00:POKE5,$98:POKE6,$00:POKE7,$07:SYS$FEE7
725 REM OVERLAPPING COPY
730 POKE2,$C0:POKE3,$98:POKE4,$B0:POKE5,$98:POKE6,$40:POKE7,$01:SYS$FEE7
740 FORI=0TO$13F:IFPEEK($90C0+I)<>PEEK($98B0+I)THENPRINT"FAIL 7 AT";I:END
750 NEXT

800 REM *** 8: COPY OVERLAPPING (DOWN)
805 REM REFERENCE DATA
810 POKE2,$00:POKE3,$C0:POKE4,$00:POKE5,$90:POKE6,$00:POKE7,$08:SYS$FEE7
815 REM COPY OF REFERENCE DATA
820 POKE2,$00:POKE3,$90:POKE4,$00:POKE5,$98:POKE6,$00:POKE7,$07:SYS$FEE7
825 REM OVERLAPPING COPY
830 POKE2,$B0:POKE3,$98:POKE4,$C0:POKE5,$98:POKE6,$40:POKE7,$01:SYS$FEE7
840 FORI=0TO$13F:IFPEEK($90B0+I)<>PEEK($98C0+I)THENPRINT"FAIL 8 AT";I:END
850 NEXT

900 REM *** 9: VRAM: COPY USING DATA0
910 POKE$9F25,0:POKE$9F20,0:POKE$9F21,0:POKE$9F22,16
920 POKE2,$00:POKE3,$C0:POKE4,$23:POKE5,$9F:POKE6,$00:POKE7,$08:SYS$FEE7
930 FORI=0TO$7FF:IFVPEEK(0,I)<>PEEK($C000+I)THENPRINT"FAIL 9 AT";I:END
940 NEXT

1000 REM *** 10: VRAM: MEMORY FILL TO CLEAR DATA USING DATA0
1010 POKE$9F25,0:POKE$9F20,0:POKE$9F21,0:POKE$9F22,16
1020 POKE2,$23:POKE3,$9F:POKE4,$00:POKE5,$08:POKE780,0:SYS$FEE4
1030 FORI=0TO$7FF:IFVPEEK(0,I)<>0THENPRINT"FAIL 10 AT";I:END

9999 PRINT"PASS"

10000 REM UNCOMPRESSED DATA
10010 DATA$54,$68,$65,$20,$43,$6F,$6D,$6D,$6F,$64,$6F,$72,$65,$20,$36,$34
10020 DATA$2C,$20,$61,$6C,$73,$6F,$20,$6B,$6E,$6F,$77,$6E,$20,$61,$73,$20
10030 DATA$74,$68,$65,$20,$43,$36,$34,$20,$6F,$72,$20,$74,$68,$65,$20,$43
10040 DATA$42,$4D,$20,$36,$34,$2C,$20,$69,$73,$20,$61,$6E,$20,$38,$2D,$62
10050 DATA$69,$74,$20,$68,$6F,$6D,$65,$20,$63,$6F,$6D,$70,$75,$74,$65,$72
10060 DATA$20,$69,$6E,$74,$72,$6F,$64,$75,$63,$65,$64,$20,$69,$6E,$20,$4A
10070 DATA$61,$6E,$75,$61,$72,$79,$20,$31,$39,$38,$32,$20,$62,$79,$20,$43
10080 DATA$6F,$6D,$6D,$6F,$64,$6F,$72,$65,$20,$49,$6E,$74,$65,$72,$6E,$61
10090 DATA$74,$69,$6F,$6E,$61,$6C,$20,$28,$66,$69,$72,$73,$74,$20,$73,$68
10100 DATA$6F,$77,$6E,$20,$61,$74,$20,$74,$68,$65,$20,$43,$6F,$6E,$73,$75
10110 DATA$6D,$65,$72,$20,$45,$6C,$65,$63,$74,$72,$6F,$6E,$69,$63,$73,$20
10120 DATA$53,$68,$6F,$77,$2C,$20,$69,$6E,$20,$4C,$61,$73,$20,$56,$65,$67
10130 DATA$61,$73,$2C,$20,$4A,$61,$6E,$75,$61,$72,$79,$20,$37,$E2,$80,$93
10140 DATA$31,$30,$2C,$20,$31,$39,$38,$32,$29,$2E

11000 REM COMPRESSED DATA
11010 DATA$38,$9B,$54,$68,$65,$20,$43,$6F,$6D,$6D,$6F,$64,$6F,$72,$18,$BA
11020 DATA$36,$34,$2C,$20,$61,$6C,$73,$6F,$20,$6B,$6E,$6F,$77,$6E,$3A,$00
11030 DATA$73,$20,$74,$00,$41,$28,$20,$04,$A1,$53,$42,$4D,$DB,$10,$69,$73
11040 DATA$20,$06,$58,$38,$2D,$62,$69,$74,$20,$68,$6F,$6D,$BC,$E8,$63,$19
11050 DATA$DA,$70,$75,$74,$65,$72,$20,$69,$6E,$74,$72,$6F,$64,$75,$63,$65
11060 DATA$64,$5F,$D2,$20,$4A,$61,$6E,$75,$61,$72,$79,$20,$31,$39,$38,$32
11070 DATA$20,$62,$79,$95,$51,$49,$6E,$D2,$58,$B3,$6E,$61,$74,$69,$6F,$6E
11080 DATA$61,$6C,$20,$28,$66,$69,$72,$73,$B5,$53,$73,$68,$89,$EC,$74,$20
11090 DATA$59,$01,$73,$75,$6D,$AD,$59,$45,$6C,$65,$63,$AB,$59,$30,$6E,$69
11100 DATA$63,$73,$20,$53,$DE,$4A,$2C,$A6,$49,$4C,$63,$38,$56,$65,$67,$D0
11110 DATA$4F,$2C,$9B,$5B,$40,$37,$E2,$80,$93,$31,$30,$2C,$93,$5F,$29,$2E
11120 DATA$0A,$00,$F0,$E8

RUN
