/*
 *	chatter.c - write to several files at once
 *	AYM 2002-03-23
 */


#include <errno.h>
#include <stdarg.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>


typedef struct
{
  const char *pathname;
  FILE *fp;
  size_t pos;
} file_t;


static const char *chatter[] =
{
  "please ", "could ", "you ", "stop ", "the ", "noise ",
  "I'm ", "trying ", "to ", "get ", "some ", "rest\n",
  "from ", "all ", "the ", "unborn ", "chicken ", "voices ",
  "in ", "my ", "head\n"
};


static void err (const char *fmt, ...);


int main (int argc, char *argv[])
{
  size_t nfiles;
  file_t *files = NULL;

  if (argc < 2)
  {
    err ("usage: chatter file ...");
    exit (1);
  }

  nfiles = argc - 1;
  files = malloc (nfiles * sizeof *files);
  if (files == NULL)
  {
    err ("%s", strerror (ENOMEM));
    exit (1);
  }
  {
    size_t f;
    for (f = 0; f < nfiles; f++)
    {
      files[f].pathname = argv[f + 1];
      files[f].fp       = fopen (files[f].pathname, "w");
      files[f].pos      = 0;
      if (files[f].fp == NULL)
      {
	err ("%s: %s", files[f].pathname, strerror (errno));
	exit (1);
      }
    }
  }

  {
    unsigned long c; 

    for (c = 0; ; c++)
    {
      size_t f;

      for (f = 0; f < nfiles; f++)
      {
	if (f == 0 || (c & ((2 << f) - 1)) == 0)
	{
	  fputs (chatter[rand () % sizeof chatter / sizeof *chatter],
	      files[f].fp);
	  fflush (files[f].fp);
	}
      }
      {
	struct timeval tv;

	tv.tv_sec = 0;
	tv.tv_usec = 50000;
	select (0, 0, 0, 0, &tv);
      }
    }
  }
}


static void err (const char *fmt, ...)
{
  va_list argp;

  fputs ("chatter: ", stderr);
  va_start (argp, fmt);
  vfprintf (stderr, fmt, argp);
  va_end (argp);
  fputc ('\n', stderr);
}

