/*=============================================================================
author        :Walter Schreppers
filename      :treenode.h
description   :A node in an n-ary tree
bugreport(log):/
=============================================================================*/

#ifndef TREENODE_H
#define TREENODE_H

#include <string>
#include <list>

#include "number.h"
#include "nodetypes.h"

//using namespace std;

//BUGS: prevSibling and nextSibling sometimes segfault and are not optimal, in short, don't use em! :)


class TreeNode:public list<TreeNode*> {

  public:
  
    //constructors/destructor
    //=======================
    TreeNode();
    TreeNode(TreeNode*); //give parent

    TreeNode(NodeType);
    TreeNode(NodeType,int,int); //row and col
    
    
    virtual ~TreeNode();
  
    //public members
    //==============
    void init();
    void setParent(TreeNode* p);
    TreeNode* getParent(){return parent;}
    
    virtual void show(int indent=0);
    void showTree(TreeNode* node, int indent=0) const;
    
    void appendChild(TreeNode*);
    void appendSibling(TreeNode*); //works only if it has parent set!
    
    TreeNode* firstChild();
    TreeNode* secondChild();
    TreeNode* thirdChild();
    TreeNode* fourthChild();
    TreeNode* fifthChild();
    
    TreeNode* lastChild();    
    TreeNode* nextSibling();   
    TreeNode* prevSibling();
    
    NodeType getType();
    void setType(NodeType t);

    int getRow(){ return fRow; }
    int getCol(){ return fCol; }

    TreeNode::iterator lookup(); //gives location in parent list as iterator (used by prevSibling and nextSibling)
    bool hasChildren(){ return size()!=0; }

    TreeNode& operator=(const TreeNode&);

    string value;
    double const_value;
    unsigned int address;
  
  protected:
    TreeNode* parent;
    
        
  private:

    //private members
    //===============
    void destroy(TreeNode*);

    //private locals
    //==============
    NodeType fType;
    int fRow, fCol; //for runtime error messages.
    
};

#endif



