/*
 * Copyright (c) 2003 pancake <pancake@phreaker.net>
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * This file is included in WiStumbler2 package.
 *
 * $Id: userconf.c,v 1.0 2004/05/01 15:54:29 pancake Exp $
 */
#include "main.h"

int
parsebool(char *str,int *ret)
{
	char *truestr[]={"yes","1","YES","on"};
	char *falsestr[]={"no","0","NO","off"};
	int i;

	for(i=0;i<4;i++)
		if (!strcmp(str,truestr[i]))
			{ *ret=1; break; }
	if (i==4)
	for(i=0;i<4;i++)
		if (!strcmp(str,falsestr[i]))
			{ *ret=0; break; }
	if (i==4)
		{
		fprintf(stderr,
		"Invalid boolean argument '%s'.\n",str);
		return 1;
		}
	return 0;
}

bool
user_conf_save()
{
	FILE *fd;
	char *home;
	
	home = getenv("HOME");
	if (home) chdir(home);
	fd = fopen(DEFAULT_CFGFILE,"w");
	if (fd)
	{
		fprintf(fd,"popup=%s\n",
			(App.signalmeter)?"YES":"NO");
		fprintf(fd,"speaker=%s\n",
			(Cfg.beep_enable)?"YES":"NO");
		fprintf(fd,"console=%s\n",
			(App.usex)?"YES":"NO");
		fprintf(fd,"gps=%s\n",
			(Cfg.gps)?"YES":"NO");
		fprintf(fd,"gpsdev=%s\n",Cfg.gpsdev);
					
		fclose(fd);
		return true;
	} else {
		wistumbler_gui_error(
		"Cannot write changes to ~/" DEFAULT_CFGFILE );
	}

	return false;
}

void
user_conf_load(bool reload)
{
	FILE *fd;
	int i,endof;
	char buf[1024],*p;
	char one[1024],two[1024];
	char *home=getenv("HOME");
	if (home) chdir(home);

	if (reload)
			endof=1;
	else
			endof=2;

	for (i=0;i<endof;i++)
	{
	if (i==0) 
		fd=fopen(DEFAULT_CFGFILE,"r");
	else
		fd=fopen(HOME_CFGFILE,"r");

	if (!fd&&i==0) {
		fd=fopen(ETC_CFGFILE,"r");
	}

	if (fd)
	{
	while(!feof(fd))
	{
	one[0]=0;two[0]=0;buf[0]=0;
	fgets(buf,1024,fd);
	if ((p=strchr(buf,'=')))
		p[0]=' ';
	sscanf(buf,"%s %s",one,two);
	if (one[0]=='#') continue;
	if (one[0]&&two[0])
	   {
		if (!strcmp(one,"iface")) {
			if (Cfg.iface) free(Cfg.iface);
			if (!strcmp(two,"auto")) Cfg.iface=0;
			else Cfg.iface=strdup(two);
		} else if (!strcmp(one,"gpsdev")) {
			if (Cfg.gpsdev) free(Cfg.gpsdev);
			Cfg.gpsdev=strdup(two);
		} else if (!strcmp(one,"gps")) {
			parsebool(two,&Cfg.gps);
		} else if (!strcmp(one,"delay")) {
				Cfg.scan_delay=atoi(two);
		} else if (!strcmp(one,"logsfile")) {
			if (Cfg.logsfile) free(Cfg.logsfile);
				Cfg.logsfile=strdup(two);
		} else if (!strcmp(one,"console")) {
			if (reload==false) // only load this on first load
			parsebool(two,&App.usex);
		} else if (!strcmp(one,"speaker")) {
			parsebool(two,&Cfg.beep_enable);
		} else if (!strcmp(one,"sniffer")) {
			parsebool(two,&Cfg.snif_enable);
		} else if (!strcmp(one,"popup")) {
			parsebool(two,&App.signalmeter);
		} else {
			fprintf(stderr,"Unknown directive: '%s'.\n",one);
			fclose(fd);
			return;
		}
	   }
	}
	fclose(fd);
	}
	} // for (i..

	if (!Cfg.logsfile)
		Cfg.logsfile=strdup(DEFAULT_LOGSFILE);

}

void set_default_cfg()
{
#if USE_GTK
	App.usex=1;
#else
	App.working=1; /* Sure? */
	App.usex=false;
#endif
	App.kismet=false;
	App.kismetsock=-1;
	App.with_iface=true;
	App.gui_init=false;
	Cfg.scan_delay=2;
	Cfg.snif_enable=true;
	Cfg.beep_delay=2;
	Cfg.beep_enable=true;
	Cfg.iface=0; // autodetect by default

	Cfg.gps=false;
	Cfg.gpsdev=strdup("/dev/dty00");
	//Cfg.logsfile;
	App.signalmeter=false;
	Cfg.sniff=true;
}
