/*
 * Copyright (c) 2002 pancake <pancake@phreaker.net>
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * This file is included in WiStumbler2 package.
 *
 * $Id: stumbler.h,v 1.0 2003/11/15 17:54:29 pancake Exp $
 */

#ifndef _INCLUDE_STUMBLER_H_
#define _INCLUDE_STUMBLER_H_

#include "main.h"
#include <sys/param.h>
#if !NOTHREADS
#include <pthread.h>
#endif

#if USE_GTK
#include <gtk/gtk.h>
#else
#define TRUE 1
#define FALSE 0
#endif

#include <stdio.h>
//#include <sys/param.h>
#ifdef __FreeBSD__
//#include <net/if_var.h>
#include <net80211/ieee80211.h>
#include <net/ethernet.h>
#include <dev/wi/if_wavelan_ieee.h>
#elif defined(__OpenBSD__)
#include "cdefs.h"
#include <sys/socket.h>
#include <netinet/in.h>
#include <net/if_arp.h>
#include <net/if.h>
#include <netinet/if_ether.h>
#include <net/if_ieee80211.h>
#include <dev/ic/if_wi_ieee.h>
#else
#if __NetBSD_Version__ > 106220000
#include <net/if.h>
#include <net80211/ieee80211.h>
#else
#include <net/if_ieee80211.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <net/route.h>
#include <net/if.h>
#endif
#include <dev/ic/wi_ieee.h>
#endif

#include "gpscontrol.h" // TODO add main.h!!

struct access_point {
   struct wi_apinfo wi_apinfo;
   long first;
   long last;
   int cur_receive;
   struct dir dir;
};

/* end of import */
extern int wi_polling();
extern int wi_init(char *);
extern int wi_finish(char *);
extern int wi_apscan(char *);
extern void print_aps(FILE *);

extern int wi_exit(int);
extern void print_clist(int);
struct _app {
#if USE_GTK
    GtkWidget *window;
    GtkWidget *clist;
    GtkWidget *label;
#endif
	/* mutex flags */
	bool working;
	bool init;
	bool usex;
	bool gui_init;
	bool kismet;
	int kismetsock;
	int gui;
	bool debug;
	bool signalmeter;
	bool devok;
	bool with_iface;
};
struct _cfg {
	int scan_delay;
	int beep_delay;
	int beep_enable;
	bool snif_enable;
	char *logsfile;
	char *iface;
	bool gps;
	char *gpsdev;
	bool sniff;
};

#endif
extern int gui_polling(int);
extern int wi_exit(int);
extern char *autoget_wifi();
extern void wistumbler_gui_error(char *);
extern int wistumbler_gui_error_polling(void *);
