/*
 * Copyright (c) 2002 Isao SEKI <iseki@gongon.com>
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * This file is included in WiStunbler package.
 *
 * $Id: main.c,v 1.5 2004/03/09 15:54:29 pancake Exp $
 */


#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#if USE_GTK
#include <gtk/gtk.h>
#include "guimenu.h"
#endif
#include "main.h"
#include "stumbler.h"
#include "gpscontrol.h"
#include "speaker.h"
#include "kismet.h"

struct _app App;
struct _cfg Cfg;

void show_usage(char *argv0)
{
	fprintf(stderr,
		"usage: %s"
		" [-f logsFile] [-g gpsDev ] [-tdxbkh] [ interface ]"
		"\n",
#if defined(__OpenBSD__)
		argv0);
#else
		getprogname());
#endif
}

int main(argc, argv)
	int argc;
	char *argv[];
{
	int i, c;
	int timer0;
	int timer1;
	pthread_t th1=0, /* th_polling */
		  th2=0, /* dev_init */
		  th3=0; /* kismet_srv */

	set_default_cfg();
	user_conf_load(false);

	/* cmdline iface selection */
	if (argc > 1 && argv[1][0] != '-')
	{
		Cfg.iface = argv[1];
		optind++;
	}

	while ((c = getopt(argc, argv, "bsxtdf:g:hi:k")) != -1) 
	{
		switch (c) 
		{
		case 'd':
			App.debug = true;
			break;
		case 'b':
			beep_enable = false;
			break;
		case 'x':
			App.usex = false;
			break;
		case 'f':
			Cfg.logsfile = optarg;
			break;
		case 'g':
			Cfg.gps = true;
			Cfg.gpsdev = optarg;
			break;
		case 't':
			App.signalmeter = true;
			break;
		case 'i':
			Cfg.iface = optarg;
			break;
		case 'k':
			App.kismet = true;
			break;
		case 's':
			Cfg.snif_enable = false;
			break;
		case 'h':
		default:
			show_usage(argv[0]);
			exit (1);
			break;
		}
	}

	argc -= optind;
	argv += optind;

	/* Load configuration file */
	App.init=0; /* not yet init */

	/* UGLY ORIGINAL CODE MUST BE PATCHED ( TODO ) */
	for (i = 0; i <= MAX_APS; i++) 
		access_points[i] = NULL;

	//if (usex)
	pthread_create (&th1,NULL, (void*)&th_polling,(void *)0);
	pthread_create (&th2,NULL, (void*)&dev_init,  (void *)0);
	if (App.kismet)
	pthread_create (&th3,NULL, (void*)&kismet_srv,(void *)0);

#if USE_GTK
	if (App.usex)
	{
		if ( gtk_init_check(&argc,&argv) == FALSE )
		{
			printf("Cannot run the Xwindow system...going to console\n");
			App.usex=0;

		} else {

			gtk_set_locale();
			gtk_init(&argc, &argv);   /* init gtk   */
			gtk_rc_add_default_file("~/.gtkrc-2.0");
			gtk_rc_add_default_file("~/.gtkrc");
			gtk_rc_reparse_all();

			window_setup();

			if (Cfg.snif_enable)	
			sniffer_start();

			// Gtk Events Timeouts
			timer0 = g_timeout_add
				(500,(GSourceFunc)gui_polling,(gpointer)0); 	

			timer1 = g_timeout_add
				(500,(GSourceFunc)wistumbler_gui_error_polling,(gpointer)0);

			// Main Gtk Loop
			gtk_main();

		} /* if/else X(gtk_init_check) */

	} else {

		while(1)
		{
			sleep(1);
			gui_polling(0);
		}
	}
#else
	while(1)
	{
		sleep(1);
		gui_polling(0);
	}
#endif

	App.working=1; /* pthread_cancel could be faster :? TODO */

	printf("Finishing threads..."); fflush(stdout);

	pthread_join(th1,NULL);
	printf("."); fflush(stdout);

	pthread_join(th2,NULL);
	printf("."); fflush(stdout);

	if(App.kismet)
	{
		pthread_join(th3, NULL);
		printf("."); fflush(stdout);
	}

	sniffer_stop();
	wi_exit(0);
	printf("."); fflush(stdout);

	return(0);
}
