/*
 * This software is in public domain.
 * 20h
 */

#include "main.h"
#include <sys/socket.h>
#include <netinet/in.h>

int
bind_inet(unsigned short port)
{
	struct sockaddr_in l;
	int ret;

	ret = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
	if(ret < 0)
		return -1;

	l.sin_family = AF_INET;
	l.sin_addr.s_addr = htons(INADDR_ANY);
	l.sin_port = htons(port);

	if(bind(ret, (struct sockaddr *)&l, sizeof(l)) < 0)
	{
		close(ret);
		return -1;
	}

	listen(ret, 50);
	return ret;
}

int
kismet_srv()
{
	int srv, l, cli;
	struct sockaddr_in cl;

	srv = bind_inet(2501);
	l = sizeof(cl);
	while(srv)
	{
		cli = accept(srv, (struct sockaddr *)&cl, &l);
		if(cli > 0)
			App.kismetsock = cli;
	}

	return -1;
}

