/* 
 * This code is mainly ripped from Bill Paul's great wiconfig.c
 * addons by iMil <imil@gcu.info>, leSAINT and alf
 */

/*
 * Copyright (c) 2004
 *      iMil <imil@gcu.info>.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by iMil.
 * 4. Neither the name of the author nor the names of any co-contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY iMil AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL iMil OR THE VOICES IN HIS HEAD
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: showi.c,v 1.5 2004/07/12 14:40:41 imil Exp $
 */


#include <sys/types.h>
#include <sys/cdefs.h>
#include <sys/param.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <sys/socket.h>

#include <net/if.h>

#ifdef __FreeBSD__
#include <net/if_var.h>
#include <net/ethernet.h>
#include <dev/wi/if_wavelan_ieee.h>
#else

#include <netinet/in.h>
#include <netinet/if_ether.h>

#ifdef __NetBSD__
#include <net80211/ieee80211.h>
#include <net80211/ieee80211_ioctl.h>
#include <dev/ic/wi_ieee.h>
#endif
#ifdef __OpenBSD__
#include <net/if_ieee80211.h>
#include <dev/ic/if_wi_ieee.h>
#endif

#endif

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include <unistd.h>

#include "common.h"
#include "showi.h"

struct wi_table {
	int wi_type;
	int wi_code;
#define	WI_NONE			0x00
#define	WI_STRING		0x01
#define	WI_BOOL			0x02
#define	WI_WORDS		0x03
#define	WI_HEXBYTES		0x04
#define	WI_KEYSTRUCT		0x05
#define	WI_BITS			0x06
#define	WI_VENDOR		0x07
	char *wi_label;			/* label used to print info */
	int wi_opt;			/* option character to set this */
	char *wi_desc;
	char *wi_optval;
};

/* already define in wireg.h XXX */
#define	WI_APRATE_0		0x00	/* NONE */
#define WI_APRATE_1		0x0A	/* 1 Mbps */
#define WI_APRATE_2		0x14	/* 2 Mbps */
#define WI_APRATE_5		0x37	/* 5.5 Mbps */
#define WI_APRATE_11		0x6E	/* 11 Mbps */

#ifdef __OpenBSD__
#define le16toh(x) letoh16(x)
#endif
#ifdef __FreeBSD__
#define le16toh(x) (x)
#endif

static struct wi_table wi_table[] = {
	{ WI_RID_SERIALNO, WI_STRING, "NIC serial number:\t\t\t" },
	{ WI_RID_NODENAME, WI_STRING, "Station name:\t\t\t\t",
	    's', "station name" },
	{ WI_RID_OWN_SSID, WI_STRING, "SSID for IBSS creation:\t\t\t" },
	{ WI_RID_CURRENT_SSID, WI_STRING, "Current netname (SSID):\t\t\t" },
	{ WI_RID_DESIRED_SSID, WI_STRING, "Desired netname (SSID):\t\t\t" },
	{ WI_RID_CURRENT_BSSID, WI_HEXBYTES, "Current BSSID:\t\t\t\t" },
	{ WI_RID_CHANNEL_LIST, WI_BITS, "Channel list:\t\t\t\t" },
	{ WI_RID_OWN_CHNL, WI_WORDS, "IBSS channel:\t\t\t\t" },
	{ WI_RID_CURRENT_CHAN, WI_WORDS, "Current channel:\t\t\t" },
	{ WI_RID_COMMS_QUALITY, WI_WORDS, "Comms quality/signal/noise:\t\t" },
	{ WI_RID_PROMISC, WI_BOOL, "Promiscuous mode:\t\t\t" },
	{ WI_RID_PORTTYPE, WI_WORDS, "Port type:\t\t\t\t" },
	{ WI_RID_MAC_NODE, WI_HEXBYTES, "MAC address:\t\t\t\t",
	    'm', "MAC address" },
	{ WI_RID_TX_RATE, WI_WORDS, "TX rate (selection):\t\t\t" },
	{ WI_RID_CUR_TX_RATE, WI_WORDS, "TX rate (actual speed):\t\t\t"},
	{ WI_RID_CUR_BEACON_INT, WI_WORDS, "Beacon Interval (current) [msec]:\t"},
	{ WI_RID_MAX_DATALEN, WI_WORDS, "Maximum data length:\t\t\t",
	    'd', "maximum data length" },
	{ WI_RID_RTS_THRESH, WI_WORDS, "RTS/CTS handshake threshold:\t\t",
	    'r', "RTS threshold" },
	{ WI_RID_FRAG_THRESH, WI_WORDS, "fragmentation threshold:\t\t",
	    'g', "fragmentation threshold" },
	{ WI_RID_DBM_ADJUST, WI_WORDS, "RSSI -> dBm adjustment:\t\t\t" },
	{ WI_RID_CREATE_IBSS, WI_BOOL, "Create IBSS:\t\t\t\t" },
	{ WI_RID_MICROWAVE_OVEN, WI_WORDS, "Microwave oven robustness:\t\t",
	    'M', "microwave oven robustness enabled" },
	{ WI_RID_ROAMING_MODE, WI_WORDS, "Roaming mode(1:firm,3:disable):\t\t",
	    'R', "roaming mode" },
	{ WI_RID_SYSTEM_SCALE, WI_WORDS, "Access point density:\t\t\t",
	    'a', "system scale" },
	{ WI_RID_PM_ENABLED, WI_WORDS, "Power Mgmt (1=on, 0=off):\t\t" },
	{ WI_RID_MAX_SLEEP, WI_WORDS, "Max sleep time (msec):\t\t\t" },
 	{ WI_RID_STA_IDENTITY, WI_VENDOR, "Vendor info:\t\t\t\t" },
	{ 0, WI_NONE }
};

/* I keep this just in case we wan't to play with crypt

static struct wi_table wi_crypt_table[] = {
	{ WI_RID_ENCRYPTION, WI_BOOL, "WEP encryption:\t\t\t\t" },
	{ WI_RID_CNFAUTHMODE, WI_WORDS, "Authentication type \n(1=OpenSys, 2=Shared Key):\t\t",
	    'A', "authentication type" },
        { WI_RID_TX_CRYPT_KEY, WI_WORDS, "TX encryption key:\t\t\t" },
        { WI_RID_DEFLT_CRYPT_KEYS, WI_KEYSTRUCT, "Encryption keys:\t\t\t" },
	{ 0, WI_NONE }
};
*/

/* this is stolen from FreeBSD's wicontrol*/
static int
_wi_getval(const char *iface, struct wi_req *wreq)
{
        struct ifreq            ifr;
        int                     s;
        int                     retval;

        bzero((char *)&ifr, sizeof(ifr));

        strlcpy(ifr.ifr_name, iface, sizeof(ifr.ifr_name));
        ifr.ifr_data = (caddr_t)wreq;

        s = socket(AF_INET, SOCK_DGRAM, 0);
        if (s == -1)
                err(1, "socket");
        retval = ioctl(s, SIOCGWAVELAN, &ifr);
        close(s);

        return (retval);
}

static int
wi_getval(const char *iface, struct wi_req *wreq)
{
        if (_wi_getval(iface, wreq) == -1) {
                if (errno != EINPROGRESS && errno != EINVAL)
                        err(1, "SIOCGWAVELAN");
                return (-1);
        }
        return (0);
}

/* and.. err.. this is mine :) */

void
get_wi_infos(char *iface, struct wi_infos *wi)
{
	struct wi_req wreq;
	struct wi_table	*w;
	int i;

	w = wi_table;

	for (i = 0; w[i].wi_code != WI_NONE; i++) {
		bzero((char *)&wreq, sizeof(wreq));
		wreq.wi_len = WI_MAX_DATALEN;
		wreq.wi_type = w[i].wi_type;
		wi_getval(iface, &wreq);

		if (wreq.wi_type == WI_RID_COMMS_QUALITY) {		
			wi->quality = le16toh(wreq.wi_val[0]);
			wi->signal = le16toh(wreq.wi_val[1]);
			wi->noise = le16toh(wreq.wi_val[2]);
		}
		if (wreq.wi_type == WI_RID_WEP_AVAIL) {
			wi->crypt = le16toh(wreq.wi_val[0]);
		}
		if (wreq.wi_type == WI_RID_FRAG_THRESH) {
			wi->frag = le16toh(wreq.wi_val[0]);
		}
		if (wreq.wi_type == WI_RID_CUR_BEACON_INT) {
			wi->mbeacon = le16toh(wreq.wi_val[0]);
		}
		if (wreq.wi_type == WI_RID_CURRENT_CHAN) {
			wi->curchan = le16toh(wreq.wi_val[0]);
		}
		if (wreq.wi_type == WI_RID_CUR_TX_RATE) {
			wi->curtxrate = le16toh(wreq.wi_val[0]);
		}
		if (wreq.wi_type == WI_RID_CURRENT_SSID) {
			wi->curssidlen = le16toh(wreq.wi_val[0]);
			strncpy(wi->curssid, (char *)&wreq.wi_val[1], 
				wi->curssidlen);
			wi->curssid[wi->curssidlen] = '\0';
		}

	}
}
