#
# Copyright (c) 1997 Loughborough University
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. All advertising materials mentioning features or use of this software
#    must display the following acknowledgement:
#      This product includes software developed by the LUTCHI Research
#      Centre at Loughborough University.
# 4. Neither the name of the University nor of the Centre may be used
#    to endorse or promote products derived from this software without
#    specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE UNIVERSITY OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#


#################################################################
#
# File dialog routines.
#
# Julian Highfield, March 1997.
#
#################################################################

proc FilePosition {nw nh} {

	set list [split [wm geometry .] x+]

	set scrh [winfo screenheight .]
	set scrw [winfo screenwidth  .]

	set w [lindex $list 0]
	set h [lindex $list 1]
	set x [lindex $list 2]
	set y [lindex $list 3]

	set midx [expr $x + [expr $w / 2]]
	set midy [expr $y + [expr $h / 2]]

	set rx [expr $midx - $nw]
	set ry [expr $midy - $nh]

#	Make sure it fits on the screen!
	if {[expr $rx + $nw] > $scrw} { set rx [expr $scrw - $nw] }
	if {[expr $ry + $nh] > $scrh} { set ry [expr $scrh - $nh] }
	if {$rx < 10} { set rx 10 }
	if {$ry < 10} { set ry 10 }

	return +$rx+$ry
}

proc FileSelection {l} {
	set name ""
	catch {
		set s [$l curselection]
		set name ""
		if ([llength $s]==1) {
			set name [$l get $s]
		}

		return $name
	}

	return $name
}

proc FileDisplay {path} {

	global GFileDir GFilePattern

	set GFileDir $path

	FileDirectory .file.a.mb $path
	FileList .file.b.list $path $GFilePattern
}

proc FileDirectory {m path} {

	$m.menu delete 0 last

	if {$path == "/"} {
		set p [list {}]
	} else {
		set p [split $path /]
	}
	set ix /
	set fp ""
	foreach i $p {
		if {$i == ""} {
			$m.menu add command -label / \
				-command "FileDisplay /"
			set ix /
		} else {
			set fp [join [list $fp $i] /]
			$m.menu add command -label $i \
				-command "FileDisplay $fp"
			set ix $i
		}
	}

	$m configure -text $ix
}

proc FileList {l path rexp} {

	$l delete 0 end

	$l insert end ../

	set f {}
	catch {set f [dir $path]}
	foreach i $f {

		if {[file isdirectory $path/$i]} {
			$l insert end [join [list $i /] {}]
		}

		if {[file isfile $path/$i] == 1} {
			if [string match $rexp $i] {
				$l insert end $i
			}
		}
	}
}

proc FileOpen {title path pattern} {

	global GFileDir GFileName GFilePattern

	set GFileDir $path
	set GFileName ""
	set GFilePattern $pattern

	toplevel .file -borderwidth 5p
	wm geometry .file [FilePosition 150 200]
	wm title .file $title
	wm transient .file .

	frame .file.a
	frame .file.b
	frame .file.c
	frame .file.d
	pack .file.a -side top -fill x -pady 5p
	pack .file.b -side top -fill x -pady 5p
	pack .file.c -side top -fill x -pady 5p
	pack .file.d -side bottom -fill x -pady 5p

	# The Open and Cancel buttons.
	button .file.d.cancel -text Cancel \
		-command {destroy .file; return ""}
	button .file.d.open -text Open \
		-command {}
	pack .file.d.cancel -side left
	pack .file.d.open -side right

	# The pattern matcher.
	label .file.c.label -text {File pattern:}
	entry .file.c.pattern
	.file.c.pattern insert end $pattern
	pack .file.c.label -side left
	pack .file.c.pattern -side right

	# The listbox and scrollbar.
	scrollbar .file.b.scroll -command {.file.b.list yview}
	listbox .file.b.list \
		-yscrollcommand {.file.b.scroll set}
	pack .file.b.scroll -side left -fill y
	pack .file.b.list -side right -fill x -expand 1
	FileList .file.b.list $path $pattern

	# The directory list.
	menubutton .file.a.mb -text / \
		-menu .file.a.mb.menu -relief raised
	pack .file.a.mb -side top
	menu .file.a.mb.menu -tearoff 0
	FileDirectory .file.a.mb $path

	# Bindings.
	bind .file.b.list <Double-Button-1> {
		set name [FileSelection .file.b.list]
		if {$name == ""} {return}
		if {[file isfile $GFileDir/$name]} {
			set GFileName $name
		}
		if {[file isdirectory $GFileDir/$name]} {

			if {$name == "../"} {
				set GFileDir [file dirname $GFileDir]
			} else {
				set nlen [string length $name]
				set name [string range $name 0 [expr $nlen - 2]]
				set GFileDir $GFileDir/$name
			}
			FileDirectory .file.a.mb $GFileDir
			FileList .file.b.list $GFileDir $GFilePattern
		}
	}
	.file.d.open configure -command  {
		set name [FileSelection .file.b.list]
		if {$name == ""} {return}
		if {[file isfile $GFileDir/$name]} {
			set GFileName $name
		}
		if {[file isdirectory $GFileDir/$name]} {

			if {$name == "../"} {
				set GFileDir [file dirname $GFileDir]
			} else {
				set nlen [string length $name]
				set name [string range $name 0 [expr $nlen - 2]]
				set GFileDir $GFileDir/$name
			}
			FileDirectory .file.a.mb $GFileDir
			FileList .file.b.list $GFileDir $GFilePattern
		}
	}
	bind .file.c.pattern <KeyPress-Return> {
		set GFilePattern [.file.c.pattern get]
		FileList .file.b.list $GFileDir $GFilePattern
	}

	# Wait for a file to be selected.
	tkwait variable GFileName

	# Tidy up.
	destroy .file	

	return $GFileDir/$GFileName
}

proc FileSave {title path pattern} {

	global GFileDir GFileName GFilePattern

	set GFileDir $path
	set GFileName ""
	set GFilePattern $pattern

	toplevel .file -borderwidth 5p
	wm geometry .file [FilePosition 150 200]
	wm title .file $title
	wm transient .file .

	frame .file.a
	frame .file.b
	frame .file.c
	frame .file.d
	pack .file.a -side top -fill x -pady 5p
	pack .file.b -side top -fill x -pady 5p
	pack .file.c -side top -fill x -pady 5p
	pack .file.d -side bottom -fill x -pady 5p

	# The Save and Cancel buttons.
	button .file.d.cancel -text Cancel \
		-command {destroy .file; return ""}
	button .file.d.save -text Save \
		-command {}
	pack .file.d.cancel -side left
	pack .file.d.save -side right

	# The file name.
	entry .file.c.name
	pack .file.c.name -side bottom -fill x

	# The pattern matcher.
	label .file.c.label -text {File pattern:}
	entry .file.c.pattern
	.file.c.pattern insert end $pattern
	pack .file.c.label -side left
	pack .file.c.pattern -side right

	# The listbox and scrollbar.
	scrollbar .file.b.scroll -command {.file.b.list yview}
	listbox .file.b.list \
		-yscrollcommand {.file.b.scroll set}
	pack .file.b.scroll -side left -fill y
	pack .file.b.list -side right -fill x -expand 1
	FileList .file.b.list $path $pattern

	# The directory list.
	menubutton .file.a.mb -text / \
		-menu .file.a.mb.menu -relief raised
	pack .file.a.mb -side top
	menu .file.a.mb.menu -tearoff 0
	FileDirectory .file.a.mb $path

	# Bindings.
	bind .file.b.list <Double-Button-1> {
		set name [FileSelection .file.b.list]
		if {$name != ""} {
			if {[file isfile $GFileDir/$name]} {
				set GFileName $name
			}
			if {[file isdirectory $GFileDir/$name]} {

				if {$name == "../"} {
					set GFileDir [file dirname $GFileDir]
				} else {
					set nlen [string length $name]
					set name [string range $name 0 [expr $nlen - 2]]
					set GFileDir $GFileDir/$name
				}
				FileDirectory .file.a.mb $GFileDir
				FileList .file.b.list $GFileDir $GFilePattern
			}
		}
	}
	bind .file.b.list <ButtonRelease-1> {
		set name [FileSelection .file.b.list]
		if {$name != ""} {
			if {[file isfile $GFileDir/$name]} {
				.file.c.name delete 0 end
				.file.c.name insert end $name
			}
		}
	}
	.file.d.save configure -command  {
		set name [.file.c.name get]
		if {$name != ""} {
			if {[file exists $GFileDir/$name]} {
				if {[file isfile $GFileDir/$name]} {
					set GFileName $name
				}
				if {[file isdirectory $GFileDir/$name]} {

					if {$name == "../"} {
						set GFileDir [file dirname $GFileDir]
					} else {
						set nlen [string length $name]
						set name [string range $name 0 [expr $nlen - 2]]
						set GFileDir $GFileDir/$name
					}
					FileDirectory .file.a.mb $GFileDir
					FileList .file.b.list $GFileDir $GFilePattern
				}
			} else {
				set GFileName $name
			}
		}
	}
	bind .file.c.pattern <KeyPress-Return> {
		set GFilePattern [.file.c.pattern get]
		FileList .file.b.list $GFileDir $GFilePattern
	}
	bind .file.c.name <KeyPress-Return> {
		set name [.file.c.name get]
		if {$name != ""} {
			if {[file exists $GFileDir/$name]} {
				if {[file isfile $GFileDir/$name]} {
					set GFileName $name
				}
				if {[file isdirectory $GFileDir/$name]} {
					FileList .file.b.list $GFileDir $GFilePattern
				}
			} else {
				set GFileName $name
			}
		}
	}

	# Wait for a file to be selected.
	tkwait variable GFileName

	# Check for overwrites...

	# Tidy up.
	destroy .file

	return $GFileDir/$GFileName
}


