/*
 * Copyright (c) 1997 Loughborough University
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the LUTCHI Research
 *      Centre at Loughborough University.
 * 4. Neither the name of the University nor of the Centre may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE UNIVERSITY AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE UNIVERSITY OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */


/*
 *  File: proto.h
 *
 *  Description: Whiteboard function prototypes.
 *
 *  J.C.Highfield, 3/97.
 *
 */

#ifndef PROTO_H
#define PROTO_H

#ifdef WIN32
struct timezone {

	int tz_minuteswest;

	int tz_dsttime;

};


/* XXX winsock.h should have these !! */

#define IN_CLASSD(i)	(((long)(i) & 0xf0000000) == 0xe0000000)

#define	IN_CLASSD_NET		((u_long)0xf0000000)/* These aren't really    */

#define	IN_CLASSD_NSHIFT	28		    /* net and host fields,but*/

#define	IN_CLASSD_HOST		((u_long)0x0fffffff)/* routing needn't know.  */

#define	IN_MULTICAST(i)		IN_CLASSD(i)

#endif
/*           */
/*  main.c   */
/*           */

void usage          (void);
void moreusage      (void);
int  main           (int argc, char **argv);
void ResizeProc     (ClientData clientData, XEvent *eventPtr);
void DoResize       (void);

/*           */
/*  comms.c  */
/*           */

uint32  this_ip      (void);
uint32  time_stamp   (void);
char   *ascii_source (char *newname);

int NetInitReceive  (struct sockaddr_in *address);
int NetInitTransmit (struct sockaddr_in *address);
int NetFetch (int sock, struct sockaddr_in *address,
                                  char *buf, int buflen);

int NetSend             (char *message, int messlen);
int NetDump             (char *buf, int mesglen);
int NetParseSession     (char *buf, int mesglen);
int NetParseAskPage     (char *buf, int mesglen);
int NetParse            (char *buf, int mesglen);

int ParseDrawRect    (struct pk_draw_msg *DrawMsg, int mesglen, char *tag);
int ParseDrawLine    (struct pk_draw_msg *DrawMsg, int mesglen, char *tag);
int ParseDrawOval    (struct pk_draw_msg *DrawMsg, int mesglen, char *tag);
int ParseDrawPS      (struct pk_draw_msg *DrawMsg, int mesglen, char *tag);
int ParseDrawChr     (struct pk_draw_msg *DrawMsg, int mesglen, char *tag);
int ParseDrawNewPage (struct pk_draw_msg *DrawMsg, int mesglen, char *tag);

int ParseDrawMsg     (struct pk_draw_msg *, int mesglen);

int Draw (ClientData clientData, 
            Tcl_Interp *tcl, int argc, char *argv[]);
int SendPS (ClientData clientData, 
            Tcl_Interp *tcl, int argc, char *argv[]);
int UnDelete (ClientData clientData, 
            Tcl_Interp *tcl, int argc, char *argv[]);


uint32 size_command  (void *cmd);
struct pk_session  *build_session      (uint32 *size_ptr);
struct pk_req_draw *build_draw_request (uint32 page_num, 
                                        uint32 page_ip,
                                        uint32 writer_ip, 
                                        uint32 first_cmd, 
                                        uint32 last_cmd,
                                        uint32 *size_ptr);
struct pk_ask_page *build_ask_page    (uint32 page_num, 
                                       uint32 page_ip,
                                       uint32 *size_ptr);
struct pk_page_rpt *build_page_report (uint32 page_num, 
                                        uint32 page_ip,
                                       uint32 page_index,
                                        uint32 *size_ptr);
struct pk_rpy_draw *build_reply_draw  (uint32 page_ip, 
                      uint32 page_num, uint32 drawer_ip, 
                      uint32 first_cmd, uint32 last_cmd,
                                       uint32 *size_ptr);

int PageCanvasSize	(ClientData clientData, Tcl_Interp *tcl, 
                              int argc, char *argv[]);
void PageToCanvasXY	 (float *x, float *y);
void PageToCanvasW	 (float *w);
void CanvasToPageXY	 (float *x, float *y);
void CanvasToPageW	 (float *w);



/*           */
/*  db.c     */
/*           */

int  DelayCalc    (int ttl, int senders);
void QueueAppend  (struct mqueue *element);
void QueueRemove  (struct mqueue *element);
int  QueueAddTo   (void *dummy, uint32 size, int type);
void CheckQueues  (void);
struct mqueue *QueueCheckRepair  (struct pk_rpy_draw *DrawRpy1);
struct mqueue *QueueCheckRequest (struct pk_req_draw *DrawReq1);
struct mqueue *QueueCheckReport  (struct pk_page_rpt *PageRpt1);
struct mqueue *QueueCheckAskPage (struct pk_ask_page *AskPage1);


int  SenderAdd    (uint32 sender_ip, uint32 sent,
                   uint32 seen, uint32 pktype, char *name);
int  SenderActive (uint32 period);


struct pk_draw_msg *MessageCopy (struct pk_draw_msg *message);
struct page *PageMake     (uint32 page_num, 
                                  uint32 page_ip,
                                      struct page *prev, 
                                      struct page *next);
struct writer *WriterMake (uint32 page_ip, struct writer *prev, 
                                            struct writer *next);
struct action *ActionFind (uint32 page_num, uint32 page_ip,
                           uint32 drawer_ip, uint32 seq_no);
struct action *ActionMake (struct pk_draw_msg *message, 
                                      struct action *prev, 
                                      struct action *next);
struct page *PageFind     (uint32 page_num, 
                                    uint32 page_ip);
struct page *PageAdd      (uint32 page_num, 
                                    uint32 page_ip);
struct writer *WriterFind (int page_num, uint32 page_ip, 
                                    uint32 writer_ip);
struct writer *WriterAdd  (int page_num, uint32 page_ip,
                                    uint32 writer_ip);
struct action *ActionAdd  (struct pk_draw_msg *message);
uint32 SeqNumMax   (uint32 page_num, uint32 page_ip, uint32 writer_ip);
uint32 PageIP      (uint32 page);
int SessionUpdate         (struct pk_session *session);

void         PageScrollSet (struct page *pptr);
struct page *PageCurrent   (void);
void         PageSet       (uint32 page_num, uint32 page_ip);
uint32       PageNumMax    (void);
void         PageNumMaxSet (uint32 page_num);
uint32       PageIndex     (uint32 page_num, uint32 page_ip);
uint32       PageIndexSet  (uint32 page_num);
struct page *PageIndexFind (uint32 index);
uint32       PageCount     (void);

int PageSetTcl   (ClientData clientData,
		    Tcl_Interp *tcl, int argc, char *argv[]);
int PageNew      (ClientData clientData,
		    Tcl_Interp *tcl, int argc, char *argv[]);
int PageDraw     (struct page *pptr, int update);
int CheckCurrent (void);
int CheckPages   (void);
int WbDump   (ClientData clientData, Tcl_Interp *tcl, 
                              int argc, char *argv[]);
int WbReload (ClientData clientData, Tcl_Interp *tcl, 
                              int argc, char *argv[]);
int Sender (ClientData clientData, Tcl_Interp *tcl, 
                              int argc, char *argv[]);

int SetSend (ClientData clientData, Tcl_Interp *tcl, 
                              int argc, char *argv[]);
#endif
