#!/usr/bin/perl -w

my $version = "0.02dev";

# Copyright (c) 2000 by Axel Beckert <abe@deuxchevaux.org>
#
#  This program is free software; you can redistribute it and/or
#  modify it under the terms of the GNU General Public License
#  as published by the Free Software Foundation; either version 2
#  of the License, or (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# You can reach the author by snail-mail at the following address:
#
#  Axel Beckert
#  Saarbrcker Strae 267a
#  66125 Saarbrcken, Germany

BEGIN { push(@INC, "/home/axel/bin"); } 
# Modify the line above to match your include path!

use wApua::WBMP2XBM;

foreach (@ARGV) {
    my $wbmpfile = $_;
    my $filebasename = $_;
    $filebasename =~ s/\.wbmp$//i;
    my $xbmfile = $filebasename.".xbm";
	
    open(WBMP,$wbmpfile) or die "Can't open $_ for reading";

    my $wbmp = "";
    while (<WBMP>) {
	$wbmp .= $_;
    }

    my $wbmpObj = new wApua::WBMP2XBM($wbmp,$filebasename);
    die "An error occured during conversion"
	unless $wbmpObj->xbm;

    print STDERR "wbmp2xbm.pl $version (C) 2000 Axel Beckert\n";
    print STDERR "Image dimension: ".$wbmpObj->dimension."\n";

    open(XBM,">$xbmfile") or die "Can't write to $xbmfile";
    print XBM $wbmpObj->xbm;

    close XBM;
    close WBMP;	
}
