/* $Id: funcm.c,v 1.1.1.1 2000/05/07 20:26:20 mauhuur Exp $ */

/*
 * $Log: funcm.c,v $
 * Revision 1.1.1.1  2000/05/07 20:26:20  mauhuur
 * Initial import
 *
 *
 */

#include <stdio.h>
#include <math.h>
#include "l_defs.h"

%%L_Log,log;
{
 LIST Ret,tt;
 double x;
 tt=onesymeval(l->t.l,tab);
 x=GetDouble((ATOM)tt);
 Ret=(LIST)MakeDAtom(log(x));Ret->g=0;
 aatl1(tt);
 return Ret;
}

%%L_Exp,exp;
{
 LIST Ret,tt;
 double x;
 tt=onesymeval(l->t.l,tab);
 x=GetDouble((ATOM)tt);
 Ret=(LIST)MakeDAtom(exp(x));Ret->g=0;
 aatl1(tt);
 return Ret;
}


%%L_Sqrt,sqrt;
{
 LIST Ret,tt;
 double x;
 tt=onesymeval(l->t.l,tab);
 x=GetDouble((ATOM)tt);
 Ret=(LIST)MakeDAtom(sqrt(x));Ret->g=0;
 aatl1(tt);
 return Ret;
}

%%L_Sin,sin;
{
 LIST Ret,tt;
 double x;
 tt=onesymeval(l->t.l,tab);
 x=GetDouble((ATOM)tt);
 Ret=(LIST)MakeDAtom(sin(x));Ret->g=0;
 aatl1(tt);
 return Ret;
}

%%L_Cos,cos;
{
 LIST Ret,tt;
 double x;
 tt=onesymeval(l->t.l,tab);
 x=GetDouble((ATOM)tt);
 Ret=(LIST)MakeDAtom(cos(x));Ret->g=0;
 aatl1(tt);
 return Ret;
}

%%L_Tg,tg;
{
 LIST Ret,tt;
 double x;
 tt=onesymeval(l->t.l,tab);
 x=GetDouble((ATOM)tt);
 Ret=(LIST)MakeDAtom(tan(x));Ret->g=0;
 aatl1(tt);
 return Ret;
}


%%L_Ctg,ctg;
{
 LIST Ret,tt;
 double x;
 tt=onesymeval(l->t.l,tab);
 x=GetDouble((ATOM)tt);
 Ret=(LIST)MakeDAtom(1.0/tan(x));Ret->g=0;
 aatl1(tt);
 return Ret;
}

%%L_Lg10,lg10;
{
 LIST Ret,tt;
 double x;
 tt=onesymeval(l->t.l,tab);
 x=GetDouble((ATOM)tt);
 Ret=(LIST)MakeDAtom(log10(x));Ret->g=0;
 aatl1(tt);
 return Ret;
}

%%L_Sign,sign;
{
 LIST Ret,tt;
 double x;
 tt=onesymeval(l->t.l,tab);
 x=GetDouble((ATOM)tt);
 Ret=(LIST)MakeDAtom((x>=0.0)?1.0:(-1.0));Ret->g=0;
 aatl1(tt);
 return Ret;
}

%%L_Intn,intn;
{
 LIST Ret,tt;
 double xd;
 int xx1;
 tt=onesymeval(l->t.l,tab);
 xd=GetDouble((ATOM)tt);
 if(xd>0.0) xx1=(int)xd+0; else if((double)((int)xd)!=xd) xx1=((int)xd)-1;
  else xx1=(int)xd+0;
 Ret=(LIST)MakeDAtom((double)xx1);Ret->g=0;
 aatl1(tt);
 return Ret;
}

%%L_Loga,loga;
{
 LIST Ret,tt,tt1;
 double x,y;
 tt=onesymeval(l->t.l,tab);
 tt1=onesymeval(l->t.l->t.l,tab);
 x=GetDouble((ATOM)tt);
 y=GetDouble((ATOM)tt1);

 Ret=(LIST)MakeDAtom(log(y)/log(x));Ret->g=0;
 aatl1(tt);
 aatl1(tt1);
 return Ret;
}

%%L_P10,p10;
{
 LIST Ret,tt;
 double y;int x;
 tt=onesymeval(l->t.l,tab);
 x=(int)GetDouble((ATOM)tt);y=1.0;
 if(x<0) while(x<0) {y/=10.0;x++;} else while(x>0) {y*=10.0;x--;}
 Ret=(LIST)MakeDAtom(y);Ret->g=0;
 aatl1(tt);
 return Ret;
}

%%L_Plus,+;
{
 LIST Ret,tt,tt1;
 double x,y;
 tt=onesymeval(l->t.l,tab);
 tt1=onesymeval(l->t.l->t.l,tab);
 x=GetDouble((ATOM)tt);y=GetDouble((ATOM)tt1);
 aatl1(tt);
 aatl1(tt1);
 Ret=(LIST)MakeDAtom(x+y);Ret->g=0;
 return Ret;
}

%%L_Mod,%;
{
 LIST Ret,tt,tt1;
 int x,y;
 tt=onesymeval(l->t.l,tab);
 tt1=onesymeval(l->t.l->t.l,tab);
 x=(int)GetDouble((ATOM)tt);y=(int)GetDouble((ATOM)tt1);
 aatl1(tt);
 aatl1(tt1);
 Ret=(LIST)MakeDAtom((double)(x%y));Ret->g=0;
 return Ret;
}

%%L_Minus,-;
{
 LIST Ret,tt,tt1;
 double x,y;
 tt=onesymeval(l->t.l,tab);
 tt1=onesymeval(l->t.l->t.l,tab);
 x=GetDouble((ATOM)tt);y=GetDouble((ATOM)tt1);
 aatl1(tt);
 aatl1(tt1);
 Ret=(LIST)MakeDAtom(x-y);Ret->g=0;
 return Ret;
}

%%L_Mult,*;
{
 LIST Ret,tt,tt1;
 double x,y;
 tt=onesymeval(l->t.l,tab);
 tt1=onesymeval(l->t.l->t.l,tab);
 x=GetDouble((ATOM)tt);y=GetDouble((ATOM)tt1);
 aatl1(tt);
 aatl1(tt1);
 Ret=(LIST)MakeDAtom(x*y);Ret->g=0;
 return Ret;
}

%%L_Div,/;
{
 LIST Ret,tt,tt1;
 double x,y;
 tt=onesymeval(l->t.l,tab);
 tt1=onesymeval(l->t.l->t.l,tab);
 x=GetDouble((ATOM)tt);y=GetDouble((ATOM)tt1);
 aatl1(tt);
 aatl1(tt1);
 Ret=(LIST)MakeDAtom(x/y);Ret->g=0;
 return Ret;
}

%%L_Int,int;
{
 LIST Ret,tt;
 double x,y;
 int z;
 tt=onesymeval(l->t.l,tab);
 x=GetDouble((ATOM)tt);
 aatl1(tt);
 z=(int)x+0;y=(double)z;
 Ret=(LIST)MakeDAtom(y);Ret->g=0;
 return Ret;
}


int DefMFuns()
{
#undef DEFFUN
#define DEFFUN(a,b) deffun(ReturnGlobal(),a,b)

%F

#undef DEFFUN
 return 0;
}

