/*
 * sym-prim.c -- Implementation of Scheme's primitive symbol procedures
 *
 * (C) m.b (Matthias Blume); Jun 1992, HUB; Jan 1993 PU/CS
 *         Humboldt-University of Berlin
 *         Princeton University, Dept. of Computer Science
 *
 * $Id: sym-prim.c,v 2.13 1994/11/12 22:25:11 blume Exp $
 */

# include "rcs.h"
RCSID ("$Id: sym-prim.c,v 2.13 1994/11/12 22:25:11 blume Exp $")

# include <stdlib.h>
# include <string.h>

# include "storage.h"
# include "Cont.h"
# include "Symbol.h"
# include "String.h"
# include "Boolean.h"
# include "type.h"
# include "except.h"
# include "tmpstring.h"

# include "builtins.tab"

/*ARGSUSED*/
unsigned ScmPrimitiveSymbolP (unsigned argcnt)
{
  void *tmp = PEEK ();

  SET_TOP (ScmTypeOf (tmp) == ScmType (Symbol) ? &ScmTrue : &ScmFalse);
  return 0;
}

/*ARGSUSED*/
unsigned ScmPrimitiveSymbolToString (unsigned argcnt)
{
  void *sym = PEEK ();
  ScmString *string;
  unsigned len;

  if (ScmTypeOf (sym) != ScmType (Symbol))
    badarg ("symbol->string", sym);
  len = ((ScmSymbol *) sym)->length;
  SCM_VNEW (string, String, len, char);
  string->length = len;
  sym = PEEK ();
  memcpy (string->array, ((ScmSymbol *) sym)->array, len);
  SET_TOP (string);
  return 0;
}

/*ARGSUSED*/
unsigned ScmPrimitiveStringToSymbol (unsigned argcnt)
{
  void *tmp = PEEK ();
  ScmSymbol *sym;
  ScmString *string;
  char *buf;

  if (ScmTypeOf (tmp) != ScmType (String))
    badarg ("string->symbol", tmp);
  string = tmp;
  buf = tmpstring (string->array, string->length);
  sym = ScmMakeSymbol (buf, string->length);
  SET_TOP (sym);
  return 0;
}
