/*
 * rcs.h -- Definition of RCSID
 *
 * (C) m.b (Matthias Blume); Nov 1994, PU/CS
 *         Princeton University, Dept. of Computer Science
 *
 * $Id: rcs.h,v 1.1 1994/11/05 04:02:48 blume Exp $
 */

# ifndef RCS_H_
# define RCS_H_

# if defined (__GNUC__)

/*
 * This is an insane trick to make gcc believe that we actually use
 * both rcsid and rcshack somewhere...
 */

# define RCSID(id) static const char rcsid [] = id; \
static int rcshack = sizeof rcsid + sizeof rcshack;

# else

/*
 * The sane way of doing what we are really trying to do...
 */

# define RCSID(id) static const char rcsid [] = id;

# endif

# endif
