/*
 * numops.h -- Prototypes for numeric functions
 *
 * (C) m.b (Matthias Blume); HUB; Mar 1993 PU/CS
 *         Princeton University, Dept. of Computer Science
 *
 * $Id: numops.h,v 2.4 1994/09/01 20:11:37 blume Exp $
 */

# ifndef NUMOPS_H_
# define NUMOPS_H_

# include "storext.h"

extern int bin_pred_error (void *, void *, const char *);
extern int bin_pred_false (void *, void *, const char *);

extern int sint_sint_eq (void *, void *, const char *);
extern int sint_sint_cmp (void *, void *, const char *);
extern int sint_int_cmp (void *, void *, const char *);
extern int sint_fract_cmp (void *, void *, const char *);
extern int sint_real_eq (void *, void *, const char *);
extern int sint_real_cmp (void *, void *, const char *);

extern int int_sint_cmp (void *, void *, const char *);
extern int int_int_eq (void *, void *, const char *);
extern int int_int_cmp (void *, void *, const char *);
extern int int_fract_cmp (void *, void *, const char *);
extern int int_real_eq (void *, void *, const char *);
extern int int_real_cmp (void *, void *, const char *);

extern int fract_sint_cmp (void *, void *, const char *);
extern int fract_int_cmp (void *, void *, const char *);
extern int fract_fract_eq (void *, void *, const char *);
extern int fract_fract_cmp (void *, void *, const char *);
extern int fract_real_eq (void *, void *, const char *);
extern int fract_real_cmp (void *, void *, const char *);

extern int real_sint_eq (void *, void *, const char *);
extern int real_sint_cmp (void *, void *, const char *);
extern int real_int_eq (void *, void *, const char *);
extern int real_int_cmp (void *, void *, const char *);
extern int real_fract_eq (void *, void *, const char *);
extern int real_fract_cmp (void *, void *, const char *);
extern int real_real_eq (void *, void *, const char *);
extern int real_real_cmp (void *, void *, const char *);

extern int cplx_cplx_eq (void *, void *, const char *);


extern void *bin_op_error (void *, void *, const char *);

extern void *sint_sint_add (void *, void *, const char *);
extern void *sint_sint_sub (void *, void *, const char *);
extern void *sint_sint_mul (void *, void *, const char *);
extern void *sint_sint_div (void *, void *, const char *);

extern void *sint_int_add (void *, void *, const char *);
extern void *sint_int_sub (void *, void *, const char *);
extern void *sint_int_mul (void *, void *, const char *);
extern void *sint_int_div (void *, void *, const char *);

extern void *sint_fract_add (void *, void *, const char *);
extern void *sint_fract_sub (void *, void *, const char *);
extern void *sint_fract_mul (void *, void *, const char *);
extern void *sint_fract_div (void *, void *, const char *);

extern void *int_sint_add (void *, void *, const char *);
extern void *int_sint_sub (void *, void *, const char *);
extern void *int_sint_mul (void *, void *, const char *);
extern void *int_sint_div (void *, void *, const char *);

extern void *int_int_add (void *, void *, const char *);
extern void *int_int_sub (void *, void *, const char *);
extern void *int_int_mul (void *, void *, const char *);
extern void *int_int_div (void *, void *, const char *);

extern void *int_fract_add (void *, void *, const char *);
extern void *int_fract_sub (void *, void *, const char *);
extern void *int_fract_mul (void *, void *, const char *);
extern void *int_fract_div (void *, void *, const char *);

extern void *fract_sint_add (void *, void *, const char *);
extern void *fract_sint_sub (void *, void *, const char *);
extern void *fract_sint_mul (void *, void *, const char *);
extern void *fract_sint_div (void *, void *, const char *);

extern void *fract_int_add (void *, void *, const char *);
extern void *fract_int_sub (void *, void *, const char *);
extern void *fract_int_mul (void *, void *, const char *);
extern void *fract_int_div (void *, void *, const char *);

extern void *fract_fract_add (void *, void *, const char *);
extern void *fract_fract_sub (void *, void *, const char *);
extern void *fract_fract_mul (void *, void *, const char *);
extern void *fract_fract_div (void *, void *, const char *);

extern void *real_real_add (void *, void *, const char *);
extern void *real_real_sub (void *, void *, const char *);
extern void *real_real_mul (void *, void *, const char *);
extern void *real_real_div (void *, void *, const char *);

extern void *real_cplx_add (void *, void *, const char *);
extern void *real_cplx_sub (void *, void *, const char *);
extern void *real_cplx_mul (void *, void *, const char *);
extern void *real_cplx_div (void *, void *, const char *);

extern void *cplx_real_add (void *, void *, const char *);
extern void *cplx_real_sub (void *, void *, const char *);
extern void *cplx_real_mul (void *, void *, const char *);
extern void *cplx_real_div (void *, void *, const char *);

extern void *cplx_cplx_add (void *, void *, const char *);
extern void *cplx_cplx_sub (void *, void *, const char *);
extern void *cplx_cplx_mul (void *, void *, const char *);
extern void *cplx_cplx_div (void *, void *, const char *);


extern int u_pred_error (void *, const char *);
extern int u_pred_false (void *, const char *);
extern int u_pred_true (void *, const char *);

extern int sint_zero (void *, const char *);
extern int sint_positive (void *, const char *);
extern int sint_negative (void *, const char *);

extern int int_positive (void *, const char *);
extern int int_negative (void *, const char *);

extern int fract_positive (void *, const char *);
extern int fract_negative (void *, const char *);

extern int real_zero (void *, const char *);
extern int real_positive (void *, const char *);
extern int real_negative (void *, const char *);
extern int real_is_int (void *, const char *);


extern void *u_op_error (void *, const char *);
extern void *u_op_zero (void *, const char *);
extern void *u_op_id (void *, const char *);

extern void *no_cplx_angle (void *, const char *);

extern void *sint_abs (void *, const char *);
extern void *sint_negate (void *, const char *);
extern void *sint_inverse (void *, const char *);
extern void *sint_to_real (void *, const char *);

extern void *int_abs (void *, const char *);
extern void *int_negate (void *, const char *);
extern void *int_inverse (void *, const char *);
extern void *int_one (void *, const char *);
extern void *int_to_real (void *, const char *);

extern void *fract_abs (void *, const char *);
extern void *fract_negate (void *, const char *);
extern void *fract_inverse (void *, const char *);
extern void *fract_numerator (void *, const char *);
extern void *fract_denominator (void *, const char *);
extern void *fract_floor (void *, const char *);
extern void *fract_ceiling (void *, const char *);
extern void *fract_truncate (void *, const char *);
extern void *fract_round (void *, const char *);
extern void *fract_to_real (void *, const char *);

extern void *real_abs (void *, const char *);
extern void *real_negate (void *, const char *);
extern void *real_inverse (void *, const char *);
extern void *real_numerator (void *, const char *);
extern void *real_denominator (void *, const char *);
extern void *real_floor (void *, const char *);
extern void *real_ceiling (void *, const char *);
extern void *real_truncate (void *, const char *);
extern void *real_round (void *, const char *);
extern void *real_exp (void *, const char *);
extern void *real_log (void *, const char *);
extern void *real_sin (void *, const char *);
extern void *real_cos (void *, const char *);
extern void *real_tan (void *, const char *);
extern void *real_asin (void *, const char *);
extern void *real_acos (void *, const char *);
extern void *real_atan (void *, const char *);
extern void *real_sqrt (void *, const char *);
extern void *real_to_fract (void *, const char *);

extern void *cplx_negate (void *, const char *);
extern void *cplx_inverse (void *, const char *);
extern void *cplx_exp (void *, const char *);
extern void *cplx_log (void *, const char *);
extern void *cplx_sin (void *, const char *);
extern void *cplx_cos (void *, const char *);
extern void *cplx_tan (void *, const char *);
extern void *cplx_asin (void *, const char *);
extern void *cplx_acos (void *, const char *);
extern void *cplx_atan (void *, const char *);
extern void *cplx_sqrt (void *, const char *);
extern void *cplx_magnitude (void *, const char *);
extern void *cplx_angle (void *, const char *);
extern void *cplx_real_part (void *, const char *);
extern void *cplx_imag_part (void *, const char *);

extern void qr_error (void *, void *, void **, void **, const char *);
extern void sint_sint_qr (void *, void *, void **, void **, const char *);
extern void sint_int_qr (void *, void *, void **, void **, const char *);
extern void int_sint_qr (void *, void *, void **, void **, const char *);
extern void int_int_qr (void *, void *, void **, void **, const char *);
extern void real_real_qr (void *, void *, void **, void **, const char *);

extern void *exact_zero (void);
extern void *inexact_zero (void);

# endif
