/*
 * mkpvtab.c -- Create primv.tab file from builtins.tab
 *
 * (C) m.b (Matthias Blume); Oct 1994
 *         Princeton University, Dept. of Computer Science
 *
 * $Id: mkpvtab.c,v 1.6 1994/11/12 22:22:56 blume Exp $
 */

# include "rcs.h"
RCSID ("$Id: mkpvtab.c,v 1.6 1994/11/12 22:22:56 blume Exp $")

# include <stdio.h>
# include <stdlib.h>
# include <string.h>

enum {

# define BUILTIN(f,n,a,d) f ## _idx,
# define BUILTIN_CONT(f,c,n,a,d) f ## _idx,
# include "builtins.tab"
# undef BUILTIN
# undef BUILTIN_CONT

  N_PRIMITIVES
};

static struct p_info {
  char *name;
  char *domain;
  int index;
} table [] = {

# define BUILTIN(f,n,a,d)		{ n, #d, f ## _idx },
# define BUILTIN_CONT(f,c,n,a,d)	{ n, #d, f ## _idx },
# include "builtins.tab"
# undef BUILTIN
# undef BUILTIN_CONT

};

int main (void)
{
  int i;

  fputs ("(\n", stdout);
  for (i = 0; i < sizeof table / sizeof table [0]; i++) {
    struct p_info *p = table + i;
    if (strcmp (p->domain, "none") != 0)
      printf ("(%s %s %d)\n", p->domain, p->name, p->index);
  }
  fputs (")\n", stdout);
  return EXIT_SUCCESS;
}
