(define (soft-functor)

  (module soft-sig ()

    (use raw-system-sig)

    (define (call-with-input-file file proc)
      (let* ((port (open-input-file file))
	     (result (proc port)))
	(close-port port)
	result))

    (define (call-with-output-file file proc)
      (let* ((port (open-output-file file))
	     (result (proc port)))
	(close-port port)
	result))

    (define (with-input-from-file file thunk)
      (let* ((port (open-input-file file))
	     (result (with-input-from-port port thunk)))
	(close-port port)
	result))

    (define (with-output-to-file file thunk)
      (let* ((port (open-output-file file))
	     (result (with-output-to-port port thunk)))
	(close-port port)
	result))

    (define (gcd2 x y)
      (if (zero? y) x (gcd2 y (remainder x y))))

    (define (gcd . l)
      (define (loop l r)
	(if (null? l)
	    r
	    (loop (cdr l) (gcd2 (car l) r))))
      (if (null? l)
	  0
	  (abs (loop (cdr l) (car l)))))

    (define (lcm . l)
      (define (loop l x)
	(if (null? l)
	    x
	    (if (zero? (car l))
		0
		(loop (cdr l)
		      (* x
			 (/ (car l)
			    (gcd2 x (car l))))))))
      (if (null? l)
	  1
	  (if (zero? (car l))
	      0
	      (abs (loop (cdr l) (car l))))))

    (define (rationalize a e)
      ;; Courtesy of Alan Bawden.
      (define (loop x y)
	(if (integer? x)
	    x
	    (let ((fx (floor x))
		  (fy (floor y)))
	      (if (= fx fy)
		  (+ fx
		     (/ (loop (/ (- y fy)) (/ (- x fx)))))
		  (+ fx 1)))))
      (define (x<y x y)
	(cond ((positive? x)
	       (loop x y))
	      ((negative? y)
	       (- (loop (- y) (- x))))
	      ((and (exact? x) (exact? y)) 0)
	      (else 0.)))
      (define (simplest-rational x y)
	(cond ((< x y) (x<y x y))
	      ((< y x) (x<y y x))
	      (else x)))
      (simplest-rational (- a e) (+ a e)))

    (define (expt x y)
      (define (e-expt x y)
	(cond ((zero? y) 1)
	      ((= y 1) x)
	      (else
	       (let ((z (e-expt x (quotient y 2))))
		 (if (odd? y)
		     (* z z x)
		     (* z z))))))
      (if (and (exact? x) (exact? y) (integer? y))
	  (if (negative? y)
	      (/ (e-expt x (- y)))
	      (e-expt x y))
	  (exp (* y (log x)))))

    (define (modulo x y)
      (let ((r (remainder x y)))
	(if (eqv? (negative? r) (negative? y))
	    r
	    (+ r y))))

    (define close-input-port close-port)
    (define close-output-port close-port)
    (define exit quit)

    ;; preparing the export...

    (define-syntax mapping
      (syntax-rules ()
	((_ n ...) (list (cons 'n n) ...))))

    (define soft-builtin-mapping
      (mapping
       call-with-input-file call-with-output-file
       with-input-from-file with-output-to-file
       gcd lcm rationalize expt modulo
       close-input-port close-output-port exit))

    (define (name->value n)
      (cond ((assq n soft-builtin-mapping) => cdr)
	    (else (error
		   (string-append
		    (symbol->string n)
		    ": no such soft built-in")))))

    (define soft-builtin-names
      `(call-with-input-file call-with-output-file
        with-input-from-file with-output-to-file
	gcd lcm rationalize expt modulo
	close-input-port close-output-port exit))))
