(define (set-functor key-of smaller?)

  (module set-sig (key-of smaller?)

    (use scheme-sig)

;;; set operations:
;;; sets are represented as ordered lists
;;;  (keys in ascending order)

    ;; union
    (define (set+ s1 s2)
      (define (recur key first rest other)
	(if (pair? other)
	    (let* ((other-first (car other))
		   (other-key (key-of other-first))
		   (other-rest (cdr other)))
	      (cond ((smaller? key other-key)
		     (cons first
			   (recur other-key other-first other-rest rest)))
		    ((smaller? other-key key)
		     (cons other-first (recur key first rest other-rest)))
		    (else (recur key first rest other-rest))))
	    (cons first rest)))
      (if (pair? s1)
	  (let* ((first (car s1))
		 (key (key-of first)))
	    (recur key first (cdr s1) s2))
	  s2))

    ;; intersection
    (define (set* s1 s2)
      (define (recur s1 s2)
	(if (not (and (pair? s1) (pair? s2)))
	    '()
	    (let* ((f1 (car s1))
		   (k1 (key-of f1))
		   (k2 (key-of (car s2))))
	      (cond ((smaller? k1 k2) (recur (cdr s1) s2))
		    ((smaller? k2 k1) (recur s1 (cdr s2)))
		    (else (cons f1 (recur (cdr s1) (cdr s2))))))))
      (recur s1 s2))

    ;; difference
    (define (set- s1 s2)
      (define (recur s1 s2)
	(cond ((not (pair? s2)) s1)
	      ((not (pair? s1)) '())
	      (else
	       (let* ((f1 (car s1))
		      (k1 (key-of f1))
		      (k2 (key-of (car s2))))
		 (cond ((smaller? k1 k2) (cons f1 (recur (cdr s1) s2)))
		       ((smaller? k2 k1) (recur s1 (cdr s2)))
		       (else (recur (cdr s1) (cdr s2))))))))
      (recur s1 s2))

    ;; membership
    (define (set-in? e s)
      (let ((k (key-of e)))
	(define (loop s)
	  (if (pair? s)
	      (let ((sk (key-of (car s))))
		(cond ((smaller? k sk) #f)
		      ((smaller? sk k) (loop (cdr s)))
		      (else #t)))
	      #f))
	(loop s)))

    ;; add one element
    (define (set+1 e s)
      (let ((k (key-of e)))
	(define (recur s)
	  (if (pair? s)
	      (let* ((f (car s))
		     (sk (key-of f)))
		(cond ((smaller? k sk) (cons e s))
		      ((smaller? sk k) (cons f (recur (cdr s))))
		      (else s)))
	      (list e)))
	(recur s)))

    ;; construct set from list (sorting)
    (define (list->set l)

      (define (split-and-sort key item l r)
	(define (loop l l< l>=)
	  (cond ((not (pair? l)) (sort l< (cons item (sort l>= r))))
		((smaller? (key-of (car l)) key)
		 (loop (cdr l) (cons (car l) l<) l>=))
		(else
		 (loop (cdr l) l< (cons (car l) l>=)))))
	(loop l '() '()))

      (define (sort l r)
	(if (pair? l)
	    (let ((item (car l)))
	      (split-and-sort (key-of item) item (cdr l) r))
	    r))

      (sort l '()))))
