(define (rts-functor)

  (module rts-sig ()

    (use system-sig)

    (define (make-rts toplevel soft-name->value)

      ;; providing the infinite family of car/cdr-combinations

      (define cadrs '())

      (define (construct-cadr l)
	(let* ((str (string-append
		     "c"
		     (list->string
		      (reverse
		       (map (lambda (x) (if (eq? x 'car) #\a #\d)) l)))
		     "r"))
	       (code `("dummy" 1 #f #(rts)
			      ((,str 1 #f #(x) () 2 0 ,@(map list l) (exit)))
			      3 0
			      (take-false) (lambda 0) (exit))))
	  (run-asm code)))

      (define (get-integrable i)
	(cond ((symbol? i) (soft-name->value i))
	      ((assoc i cadrs) => cdr)
	      (else
	       (let ((n (construct-cadr i)))
		 (set! cadrs (cons (cons i n) cadrs))
		 n))))

      ;; the register-module/fetch-module silliness (should go away soon)

      (define module-list '())

      (define (register-module m i)
	(cond ((assv i module-list)
	       =>
	       (lambda (a)
		 (with-output-to-port
		     (standard-port 2)
		   (lambda ()
		     (display "!+ Warning: re-definition of module slot ")
		     (write i)
		     (newline)))
		 (set-cdr! a m)
		 m))
	      (else
	       (set! module-list (cons (cons i m) module-list))
	       m)))

      (define (fetch-module i)
	(cond ((assv i module-list) => cdr)
	      (else (error (string-append
			    "fetch-module failed: slot "
			    (number->string i)
			    " is empty")))))

      (define (run-time-system cmd)

	(define (dispatch sy arg)
	  (case sy
	    ((get-integrable) (get-integrable arg))
	    ((register-module) register-module)
	    ((fetch-module) fetch-module)
	    (else (error
		   (string-append
		    "command `"
		    (symbol->string sy)
		    "' not implemented in run-time system")))))

	(if (and (pair? cmd)
		 (symbol? (car cmd)))
	    (dispatch (car cmd) (cdr cmd))
	    (toplevel cmd)))

      run-time-system)))
