;; Old Log: macro.scm,v
;; Revision 1.16  1994/09/16  18:02:23  blume
;; - ELSE and friends are SPECIAL now
;; - treatment of ELSE in CASE fixed
;;
;; Revision 1.15  1994/09/16  02:15:17  blume
;; - unary USE clause
;; - bug in compile-module
;; - bug in definitions-in
;; - bug in global imports (e.g. (use '() scheme-sig))
;;
;; Revision 1.14  1994/09/16  01:09:11  blume
;; - syntax-error
;; - call-with-values
;; - bug in collect (for BEGIN form)
;; - module syntax changed (retentions)
;;
;; Revision 1.13  1994/09/15  01:29:00  blume
;; any renamed into consists (to avoid conflict with type name)
;;
;; Revision 1.12  1994/09/14  16:33:39  blume
;; bug in treatment of global imports fixed.
;; second parameter for MODULE instruction is a vector
;;
;; Revision 1.11  1994/09/13  20:08:23  blume
;; arguments of register-module instruction swapped
;;
;; Revision 1.10  1994/09/13  00:10:28  blume
;; get-properties and set-properties! eliminated
;;
;; Revision 1.9  1994/09/12  23:52:36  blume
;; assignments to variables which have been included as CONSTANT now
;; flagged as an error
;;
;; Revision 1.8  1994/09/12  18:57:16  blume
;; global import implemented
;;
;; Revision 1.7  1994/09/12  01:02:34  blume
;; inclusion of (non-value-declaring) signatures into signatures implemented
;;
;; Revision 1.6  1994/09/09  18:49:06  blume
;; re-export mechanism implemented
;;
;; Revision 1.5  1994/09/09  16:58:27  blume
;; seems to work better now, top-level use (the denotation use) not
;; implemented yet
;;
;; Revision 1.4  1994/09/09  02:27:10  blume
;; half-working, modex7 is strange...
;;
;; Revision 1.3  1994/09/08  18:41:56  blume
;; module, define-type, and use implemented (treatment of global env is still
;; unsatisfactory)
;;
;; Revision 1.2  1994/09/06  20:13:03  blume
;; the first cut
;; (everything except MODULE is in place, no typechecking,
;; probably plenty of bugs)
;;

(define (macro-functor lgi-mod error-mod aux-mod tfgen-mod
		       names-mod envs-mod)

  (module macro-sig ()

    (use scheme-sig)
    (use ee-sig)
    (use den-sig)
    (use lgi-mod lgi-sig)
    (use error-mod error-sig)
    (use tfgen-mod tfgen-sig)
    (use aux-mod aux-sig)
    (use names-mod names-sig)
    (use envs-mod envs-sig)

;;; Macro expander and syntax check...
;;; (the macro expander is modelled after Jonathan Rees' paper
;;; ``The Scheme of Things: Implementing lexically scoped macros'')

;;; The output language: <type>:<body>
;;;
;;; constant:		quote:<constant>
;;; global variable:	global:<symbol>
;;; integrable:		integrable:<symbol>
;;; local variable:	local:(<unique-id> <orig-symbol> <update flag>)
;;; global assignment:	set!:(<global> <expr>)
;;; local assignment:	set!:(<local> <expr>)
;;; branch:		if:(<expr> <expr> <expr>)
;;; application:	app:(<expr> <expr> ...)
;;; letrec-form:	letrec:(((<local> <expr>) ...) <expr>)
;;; lambda-form:	lambda:("fname" (<local> ...) <expr>)
;;; vlambda-form:	vlambda:("fname" (<local> ...) <local> <expr>)
;;; delay-form:		delay:("fname" <expr>)
;;;
;;; set of definitions (only legal as outmost construct):
;;;  definitions:(<imports> <values> <macros> <types>)
;;;    <imports> ::= <env> -> <env>
;;;    <values>  ::= ((<name> . <stuff>) ...)
;;;    <macros>  ::= ((<name> . <stuff>) ...)
;;;    <types>   ::= ((<name> . <stuff>) ...)
;;;
;;; temporarily we have macro-transformers (they should go away... not legal
;;;  in final output):
;;;  transformer:(<literals> ...):<procedure>
;;;  (literals are carried as ee-info)

    ;; some integrable stuff
    (define i-ref (integrable 'ref))
    (define i-deref (integrable 'deref))
    (define i-assign (integrable 'assign))
    (define i-fetch-constant (integrable 'fetch-constant))
    (define i-fetch-read-only (integrable 'fetch-read-only))
    (define i-fetch-variable (integrable 'fetch-variable))
    (define i-verify (integrable 'verify))
    (define i-module (integrable 'module))
    (define i-register-module (integrable 'register-module))
    (define i-fetch-module (integrable 'fetch-module))

    (define i-memv (integrable 'memv))
    (define i-eqv? (integrable 'eqv?))

    ;; the ``empty'' env delta
    (define empty-delta identity)

    ;; list of top-level imports (processed by ``process-imports'')
    (define top-level-il '())

    ;; next available module slot (for global inclusions)
    (define next-module-slot 0)

    ;; list of established global inclusions
    (define existing-global-imports '())

    ;; attach symbol's name to end of fname:
    (define (new-fname fname name)
      (string-append fname "." (symbol->string (unwrap-name name))))

    (define (gen-local name)
      (new-local (unwrap-name name)))

    (define (gen-local-constant name)
      (new-local-constant (unwrap-name name)))

    (define (literal? x)
      (or (number? x) (string? x) (char? x) (boolean? x)))

    ;; lookup an expression's denotation
    (define (lookup exp env fname)
      (cond ((name? exp) (env exp))
	    ((not (pair? exp)) (constant exp))
	    (else
	     (let ((h (lookup (car exp) env fname)))
	       (if (qualifier? h)
		   (if (and (pair? (cdr exp))
			    (null? (cddr exp)))
		       (lookup (cadr exp) (qualifier-env h) fname)
		       ((syntax-error fname)
			"bad use of module qualifier in: " exp))
		   (expression exp))))))

    ;; sequence of expressions
    (define (compile-sequence seq env fname)
      (map (lambda (x) (compile x env fname)) seq))

    ;; function application
    (define (compile-application head tail env fname)
      (ee 'app (cons head (compile-sequence tail env fname))))

    ;; x must be a name!
    (define ((enforce-name! fname kind) x)
      (if (not (name? x))
	  ((syntax-error fname) (string-append "bad " kind ": ") x)))

    ;; the main function...
    (define (compile exp env fname)

      (define (complain what)
	((syntax-error fname)
	 (string-append "bad use of " what ": ") exp))

      (let ((den (lookup exp env fname)))
	(cond
	 ((or (local? den) (global? den) (integrable? den)) den)
	 ((constant? den)
	  (if (literal? exp)
	      (ee 'quote exp)
	      ((syntax-error fname) "invalid expression: " exp)))
	 ((expression? den)
	  (let* ((head (car exp))
		 (den (lookup head env fname)))
	    (cond
	     ((or (local? den)
		  (global? den)
		  (integrable? den))
	      (compile-application den (cdr exp) env fname))
	     ((or (expression? den) (reference? den))
	      (compile-application
	       (compile head env fname) (cdr exp) env fname))
	     ((special? den)
	      (compile-special-form den exp env fname))
	     ((macro? den)
	      (compile-macro-application
	       den exp env
	       (string-append fname ".[" (macro-name den) "]")))
	     ((import? den)
	      (let ((len (length exp)))
		(case len
		  ((2)
		   (let ((imp ((import-connector den) #f (cadr exp))))
		     (ee 'definitions (list imp '() '() '()))))
		  ((3 4)
		   (let ((imp
			  ((import-connector den) (cadr exp) (caddr exp))))
		     (if (= len 3)
			 (ee 'definitions (list imp '() '() '()))
			 (let* ((n (cadddr exp))
				(ign
				 (if (not (name? n))
				     ((syntax-error fname)
				      "bad qualified import: " exp)))
				(imp1 (lambda (env)
					(let ((i-den
					       (qualifier (imp empty-env))))
					  (lambda (name)
					    (if (equal? name n)
						i-den
						(env name)))))))
			   (ee 'definitions (list imp1 '() '() '()))))))
		  (else ((syntax-error fname) "bad import: " exp)))))
	     ((constant? den)
	      ((syntax-error fname)
	       "call to non-procedure " (ee-body den) " in: " exp))
	     ((undefined? den)
	      ((syntax-error fname)
	       "no definition for: " (undefined-name den) " in: " exp))
	     ((type? den)
	      ((syntax-error fname) "type name in operator position: " exp))
	     ((aux-keyword? den)
	      ((syntax-error fname)
	       "auxiliary keyword in operator position: "
	       exp))
	     ((qualifier? den) (bug "macro: unresolved qualifier"))
	     (else
	      (display "DEN: ") (write den) (newline)
	      (bug "macro: bad denotation (1)")))))
	 ((reference? den)
	  (ee 'app
	      (list i-deref (reference-var den))))
	 ((or (special? den)
	      (import? den))
	  (complain "syntactic keyword"))
	 ((macro? den) (complain "macro"))
	 ((type? den) (complain "type name"))
	 ((qualifier? den) (complain "module qualifier"))
	 ((aux-keyword? den) (complain "auxiliary keyword"))
	 ((undefined? den)
	  ((syntax-error fname)
	   "no definition for: " (undefined-name den)))
	 (else (display "DEN: ") (write den) (newline)
	       (bug "macro: bad denotation (2)")))))

    ;; taken from Rees' paper...
    (define (compile-macro-application mac exp env-of-use fname)
      (let* ((uid (generate-unique-uid))
	     (env-for-expansion (bind-aliases uid mac env-of-use))
	     (new-exp
	      (transcribe mac exp env-of-use uid env-for-expansion fname)))
	(compile new-exp env-for-expansion fname)))

    ;; still from Rees' paper...
    (define (transcribe mac exp env-of-use uid env-for-expansion fname)
      (let ((rename
	     (lambda (name)
	       (generate name uid)))
	    (compare
	     (comparison-procedure env-for-expansion fname)))
	((macro-transcribeer mac) exp rename compare (syntax-error fname))))

    ;; last one from the paper...
    (define (bind-aliases uid mac env-of-use)
      (let ((env-of-definition (macro-env-of-definition mac)))
	(lambda (name)
	  (if (and (generated? name)
		   (= (generated-uid name) uid))
	      (env-of-definition (generated-name name))
	      (env-of-use name)))))

    ;; make a procedure to compare names (free-identifier=?)
    (define (comparison-procedure env fname)
      (lambda (n1 n2)
	(equal? (lookup n1 env fname) (lookup n2 env fname))))

    ;; no duplicates (free)
    (define (enforce-free-uniqueness! l env fname construct)
      (let ((cmp (comparison-procedure env fname)))
	(do ((l1 l (cdr l1)))
	    ((not (pair? l1)))
	  (do ((l2 (cdr l1) (cdr l2)))
	      ((not (pair? l2)))
	    (if (cmp (car l1) (car l2))
		((syntax-error fname)
		 (string-append "duplicate name in " construct)))))))

    ;; no duplicates (bound, i.e. weaker)
    (define (enforce-bound-uniqueness! l fname construct)
      (do ((l1 l (cdr l1)))
	  ((not (pair? l1)))
	(do ((l2 (cdr l1) (cdr l2)))
	    ((not (pair? l2)))
	  (if (equal? (car l1) (car l2))
	      ((syntax-error fname)
	       (string-append "duplicate name in " construct))))))

    ;; unroll sequence
    (define (unroll-sequence l)
      (define (loop cur rest)
	(if (pair? rest)
	    (ee 'letrec
		(list (list (list (new-local 'begin) cur))
		      (loop (car rest) (cdr rest))))
	    cur))
      (loop (car l) (cdr l)))

    ;; special forms
    (define (compile-special-form den exp env fname)
      (case (special-symbol den)
	((set!)
	 (let* ((b (cdr exp))
		(ign (if (not (= (length b) 2))
			 ((syntax-error fname) "bad set! expression: " exp)))
		(target (lookup (car b) env fname))
		(val (compile (caddr exp) env fname)))
	   (cond ((local? target)
		  (if (local-constant? target)
		      ((syntax-error fname)
		       "target of assignment is a constant: " exp))
		  (local-update! target)
		  (ee 'set! (list target val)))
		 ((global? target)
		  (ee 'set! (list target val)))
		 ((reference? target)
		  (if (reference-ro? target)
		      ((syntax-error fname)
		       "cannot assign to read-only variable: " exp)
		      (ee 'app
			  (list i-assign
				(reference-var target)
				val))))
		 (else ((syntax-error fname)
			"target for set! expression is not a variable: "
			exp)))))
	((lambda)
	 (if (< (length exp) 3)
	     ((syntax-error fname) "bad lambda expression: " exp))
	 (let ((vl (cadr exp))
	       (body (cddr exp)))

	   (define (split-vl vl)
	     (define (loop vl r)
	       (cond ((name? vl) (cons (reverse r) vl))
		     ((pair? vl) (loop (cdr vl) (cons (car vl) r)))
		     ((null? vl) (cons (reverse r) #f))
		     (else ((syntax-error fname)
			    "bad argument list in: " exp))))
	     (loop vl '()))

	   (let* ((svl (split-vl vl))
		  (nvl (car svl))
		  (rv (cdr svl)))
	     (if rv
		 (begin
		   (for-each (enforce-name! fname "lambda binding")
			     (cons rv nvl))
		   (enforce-bound-uniqueness! (cons rv nvl) fname "lambda")
		   (let* ((ngsl (map gen-local nvl))
			  (rgs (gen-local rv))
			  (al (cons (cons rv rgs) (map cons nvl ngsl)))
			  (n-env (lambda (name)
				   (cond ((assoc name al) => cdr)
					 (else (env name)))))
			  (n-body (compile-body body n-env exp fname)))
		     (ee 'vlambda (list fname ngsl rgs n-body))))
		 (begin
		   (for-each (enforce-name! fname "lambda binding") nvl)
		   (enforce-bound-uniqueness! nvl fname "lambda")
		   (let* ((ngsl (map gen-local nvl))
			  (al (map cons nvl ngsl))
			  (n-env (lambda (name)
				   (cond ((assoc name al) => cdr)
					 (else (env name)))))
			  (n-body (compile-body body n-env exp fname)))
		     (ee 'lambda (list fname ngsl n-body))))))))
	((if)
	 (let* ((seq (compile-sequence (cdr exp) env fname))
		(len (length seq)))
	   (case len
	     ((2) (ee 'if (list (car seq) (cadr seq) (ee 'quote #f))))
	     ((3) (ee 'if seq))
	     (else
	      ((syntax-error fname) "bad if expression: " exp)))))
	((quote)
	 (if (not (= (length exp) 2))
	     ((syntax-error fname) "bad quotation: " exp))
	 (ee 'quote (remove-wrappers (cadr exp))))
	((letrec)
	 (if (< (length exp) 3)
	     ((syntax-error fname) "bad letrec expression: " exp))
	 (let ((bl (cadr exp))
	       (body (cddr exp)))
	   (for-each (lambda (b)
		       (if (not (= (length b) 2))
			   ((syntax-error fname)
			    "bad binding " b " in expression: " exp))
		       ((enforce-name! fname "letrec variable") (car b)))
		     bl)
	   (let* ((nl (map car bl))
		  (ign (enforce-bound-uniqueness! nl fname "letrec"))
		  (gsl (map gen-local nl))
		  (al (map cons nl gsl))
		  (n-env (lambda (name)
			   (cond ((assoc name al) => cdr)
				 (else (env name)))))
		  (il (map (lambda (b)
			     (compile (cadr b) n-env
				      (new-fname fname (car b))))
			   bl))
		  (n-body (compile-body body n-env exp
					(string-append fname ".LETREC"))))
	     (ee 'letrec
		 (list (map list gsl il)
		       n-body)))))
	((delay)
	 (if (not (= (length exp) 2))
	     ((syntax-error fname) "bad delay expression: " exp))
	 (ee 'delay (list fname
			  (compile
			   (cadr exp) env
			   (string-append fname ".DELAY")))))
	((primitive-transformer)
	 (if (< (length exp) 5)
	     ((syntax-error fname)
	      "bad primitive-transformer expression: " exp))
	 (let ((literals (cadr exp))
	       (captures (caddr exp))
	       (args (cadddr exp))
		 (body (cddddr exp)))

	   ;; make a new environment, which doesn't allow access to
	   ;; local variables...
	   (define (prohibit-locals-in env)
	     (lambda (name)
	       (let ((den (lookup name env fname)))
		 (if (local? den)
		     ((syntax-error fname)
		      "reference from macro transformer to: "
		      (local-symbol den)))
		 den)))

	   (for-each (enforce-name! fname "literal") literals)
	   (for-each (enforce-name! fname "captured name") captures)
	   (for-each (enforce-name! fname "argument") args)
	   (if (not (= (length args)
		       (+ (length literals) (length captures) 3)))
	       ((syntax-error fname)
		"bad # of arguments in primitive-transformer expression: "
		exp))
	   (let* ((rexp (cons secret-name-for-lambda (cons args body)))
		  (texp (compile rexp
				 (prohibit-locals-in env)
				 (string-append fname ".TRANSFORMER")))
		  (tfun (exp->procedure texp)))
	     (info-ee 'transformer
		      literals
		      (lambda (exp rename compare se)
			(apply tfun exp compare se
			       (append (map rename literals)
				       (map (implicit-name (car exp))
					    captures))))))))
	((let-syntax letrec-syntax)
	 (if (< (length exp) 3)
	     ((syntax-error fname) "bad let/letrec-syntax expression: " exp))
	 (let ((dl (cadr exp))
	       (body (cddr exp))
	       (is-let-syntax (eq? (special-symbol den) 'let-syntax)))
	   (for-each
	    (lambda (d)
	      (if (not (and (= (length d) 2)
			    (name? (car d))))
		  ((syntax-error fname)
		   "bad clause in let/letrec-syntax expression: " exp)))
	    dl)
	   (enforce-bound-uniqueness! (map car dl) fname
				      (if is-let-syntax "let-syntax"
					  "letrec-syntax"))
	   (let* ((al (map (lambda (d)
			     (let* ((n (car d))
				    (m (cadr d))
				    (tf (compile m env (new-fname fname n))))
			       (if (not (eq? (ee-type tf) 'transformer))
				   ((syntax-error fname)
				    "bad macro transformer: " m))
			       (cons n tf)))
			   dl))
		  (augmented-env
		   (supply-aux-keyword-bindings (map cdr al) env))
		  (n-env (lambda (name)
			   (cond ((assoc name al) => cdr)
				 (else (augmented-env name)))))
		  (env-of-definition
		   (if is-let-syntax augmented-env n-env)))
	     (for-each (lambda (a)
			 (set-cdr! a (macro (ee-body (cdr a))
				       env-of-definition
				       (new-fname fname (car a)))))
		       al)
	     (compile-body body n-env exp
			   (string-append
			    fname
			    (if is-let-syntax
				".LET-SYNTAX"
				".LETREC-SYNTAX"))))))
	((begin)
	 (if (< (length exp) 2)
	     ((syntax-error fname) "empty begin expression: " exp))
	 (let ((all (compile-sequence (cdr exp) env fname)))
	   (define (mix)
	     ((syntax-error fname)
	      "definitions and expressions appear together in: " exp))
	   (define (collect l)
	     (if (pair? (cdr l))
		 (let ((h (car l))
		       (t (collect (cdr l))))
		   (cond ((eq? (ee-type h) 'definitions)
			  (if (eq? (ee-type t) 'definitions)
			      (let ((hb (ee-body h))
				    (tb (ee-body t)))
				(ee 'definitions
				    (list (compose (car tb) (car hb))
					  (append (cadr hb) (cadr tb))
					  (append (caddr hb) (caddr tb))
					  (append (cadddr hb) (cadddr tb)))))
			      (mix)))
			 ((eq? (ee-type t) 'definitions) (mix))
			 (else
			  (ee 'letrec
			      (list (list (list (new-local 'begin) h))
				    t)))))
		 (car l)))
	   (collect all)))
	((define)
	 (letrec ((complain (lambda ()
			      ((syntax-error fname) "bad definition: " exp)))
		  (shuffle
		   (lambda (lhs rhs)
		     (cond ((name? lhs)
			    (if (not (= (length rhs) 1))
				(complain))
			    (ee 'definitions
				(list empty-delta
				      (list (cons lhs (car rhs)))
				      '() '())))
			   ((pair? lhs)
			    (shuffle
			     (car lhs)
			     (list (cons secret-name-for-lambda
					 (cons (cdr lhs)
					       rhs)))))
			   (else (complain))))))
	   (if (< (length exp) 3)
	       (complain))
	   (shuffle (cadr exp) (cddr exp))))
	((define-syntax)
	 (if (not (and (= (length exp) 3)
		       (name? (cadr exp))))
	     ((syntax-error fname) "bad syntax definition: " exp))
	 (ee 'definitions
	     (list empty-delta
		   '()
		   (list (cons (cadr exp) (caddr exp)))
		   '())))
	((case)
	 (letrec ((complain
		   (lambda ()
		     ((syntax-error fname) "bad case expression: " exp))))

	   (define (else? x)
	     (equal? (lookup x env fname) (lookup 'else env fname)))

	   (let ((tmpvar (new-local 'case)))

	     (define (construct set t e)

	       (define (c op const)
		 (ee 'if
		     (list (ee 'app
			       (list op tmpvar (ee 'quote const)))
			   t e)))

	       (if (pair? (cdr set))
		   (c i-memv (remove-wrappers set))
		   (c i-eqv? (remove-wrappers (car set)))))

	     (define (recur clauses)
	       (if (not (pair? clauses))
		   (complain))
	       (let* ((current (car clauses))
		      (other-clauses (cdr clauses))
		      (more-clauses (pair? other-clauses)))
		 (if (< (length current) 2)
		     (complain))
		 (let* ((set (car current))
			(seq (compile-sequence (cdr current) env fname))
			(seq-exp (if (pair? (cdr seq))
				     (unroll-sequence seq)
				     (car seq))))
		   (cond ((else? set)
			  (if more-clauses (complain))
			  seq-exp)
			 ((not (pair? set)) (complain))
			 (else
			  (construct set seq-exp
				     (if more-clauses
					 (recur other-clauses)
					 (ee 'quote '#f))))))))

	     (if (< (length exp) 3)
		 (complain))

	     (ee 'letrec
		 (list (list (list tmpvar (compile (cadr exp) env fname)))
		       (recur (cddr exp)))))))

	((define-type)
	 (if (not (and (= (length exp) 3)
		       (name? (cadr exp))))
	     ((syntax-error fname) "bad type definition: " exp))
	 (ee 'definitions (list empty-delta '() '()
				(list (cons (cadr exp) (caddr exp))))))
	((module) (compile-module exp env fname))
	(else
	 (bug "macro: bad syntactic keyword"))))

    (define (aux-keywords-in tlf)
      (do ((l tlf (cdr l))
	   (accu '()
		 (append
		  (filter (ee-info (car l))
			  (lambda (n) (not (member n accu))))
		  accu)))
	  ((not (pair? l)) accu)))

    (define (supply-aux-keyword-bindings tfl env)
      (let* ((not-defined-by-env? (lambda (n) (undefined? (env n))))
	     (kwl (filter (aux-keywords-in tfl) not-defined-by-env?))
	     (al (map (lambda (n) (cons n (aux-keyword n))) kwl)))
	(lambda (name)
	  (cond ((assoc name al) => cdr)
		(else (env name))))))

    (define (sigexp->env-delta exp env fname enforce-ro memoize k)

      (let* ((sig-ty (get-sgn-type exp env fname))
	     (sig (type-def sig-ty)))

	(if (built-in-sgn? sig)
	    (let ((delta (built-in-sgn-env-delta sig)))
	      (k delta delta '()))
	    (let* ((exports (sgn-exports sig))
		   (types (sgn-types sig))
		   (values (sgn-values sig))
		   (macros (sgn-macros sig))
		   (builtin-delta (sgn-builtin sig))

		   (aux-kw-al
		    (map (lambda (n)
			   (cons n (aux-keyword n)))
			 (aux-keywords-in (map cdr macros))))

		   (val
		    (map (lambda (v)
			   (cons
			    (car v)
			    (lambda ()
			      (let ((vgs (gen-local-constant (car v))))
				(case (cadr v)
				  ((constant) vgs)
				  ((variable) (reference vgs #f #f))
				  ((read-only) (reference vgs enforce-ro #t))
				  (else
				   (bug "macro: strange value tag")))))))
			 values))
		   (mal (map (lambda (m) (cons (car m) '())) macros))

		   (augment-env
		    (lambda (env)
		      (let ((env (builtin-delta
				  (lambda (name)
				    (cond ((assoc name aux-kw-al) => cdr)
					  (else (env name)))))))
			(lambda (name)
			  (cond ((assoc name types) => cdr)
				((assoc name val)
				 =>
				 (lambda (a) (memoize name (cdr a))))
				((assoc name mal) => cdr)
				(else (env name)))))))

		   (macro-env
		    (augment-env (lambda (name) (undefined name))))

		   ;; fill in the macro transformers
		   (ign
		    (for-each
		     (lambda (ma m)
		       (set-cdr!
			ma
			(macro (ee-body (cdr m))
			  macro-env (symbol->string (car m)))))
		     mal macros)))

	      (k augment-env
		 (lambda (env)
		   (let ((aenv (augment-env env)))
		     (lambda (name)
		       (if (not (member name exports))
			   (env name)
			   (aenv name)))))
		 (map car values))))))

    ;; build memoizing lookup
    (define (memoize l)
      (lambda (name thunk)
	(cond ((assoc name (cdr l)) => cdr)
	      (else
	       (let ((t (thunk)))
		 (set-cdr! l (cons (cons name t) (cdr l)))
		 t)))))

    ;; build dummy memoizer
    (define (dummy-memoizer)
      (memoize (cons '() '())))

    (define (make-inner-import-loop tmp)

      (define (fetch sym)
	(ee 'app
	    (list i-fetch-constant
		  tmp (ee 'quote sym))))

      (define (fetch-ref sym ro)
	(ee 'app
	    (list (if ro i-fetch-read-only i-fetch-variable)
		  tmp (ee 'quote sym))))

      (define (inner a)

	(if (reference? (cdr a))
	    (list (reference-var (cdr a))
		  (fetch-ref
		   (unwrap-name (car a))
		   (reference-dro? (cdr a))))
	    (list (cdr a) (fetch (unwrap-name (car a))))))

      inner)

    ;; build letrec-initialization list from imports (il)
    (define (process-imports il env fname)

      (define (outer l)
	(if (pair? l)
	    (let ((tmp (new-local 'import)))
	      (if (pair? (cdar l))
		  (append
		   (list (list tmp (compile (caar l) env fname))
			 (list (new-local 'ignore)
			       (ee 'app
				   (list i-verify
					 tmp
					 (ee 'quote 'signature)))))
					; ************************************
		   (map (make-inner-import-loop tmp) (cdar l))
		   (outer (cdr l)))
		  (cons (list tmp (compile (caar l) env fname))
			(outer (cdr l)))))
	    '()))

      (outer il))

    (define (check-proper-module exp env fname)
      (let ((den (lookup exp env fname)))
	(if (not (or (global? den)
		     (local? den)
		     (reference? den)
		     (expression? den)))
	    ((syntax-error fname)
	     "improper module expression: " exp))))

    ;; compile a ``module'' expression
    (define (compile-module exp env fname)

      (if (< (length exp) 4)
	  ((syntax-error fname) "bad module: " exp))

      (let ((retain-l (caddr exp)))

	(for-each (enforce-name! fname "retained name") retain-l)
	(enforce-free-uniqueness! retain-l env fname "retention")

	(sigexp->env-delta
	 (cadr exp) env fname #f
	 (dummy-memoizer)
	 (lambda (full filtered required)

	   (let ((il '()))		; ((exp (name . den) ...) ...)

	     (define (conn exp sigexp)
	       (let ((l (cons exp '())))
		 (set! il (cons l il))
		 (sigexp->env-delta
		  sigexp env fname #t
		  (memoize l)
		  (lambda (ign1 imp-filtered required)
		    (if (pair? required)
			(check-proper-module exp env fname))
		    imp-filtered))))

	     (let* ((u ((implicit-name (car exp)) 'use))
		    (env0 (lambda (name)
			    (cond ((equal? name u) (import conn))
				  ((member name retain-l) (env name))
				  (else (empty-env name)))))
		    (n-env (full env0))
		    (definition-in-full (delta-checker full)))

	       (define (finish body imp vdefs sdefs tdefs)

		 (define (check-not-defined what)
		   (lambda (a)
		     (if (definition-in-full (car a))
			 ((syntax-error fname)
			  (string-append
			   what " already defined in signature: ")
			  (car a)))))

		 (for-each (check-not-defined "type") tdefs)
		 (for-each (check-not-defined "macro") sdefs)

		 (let* ((env1 (car (process-type-definitions
				    tdefs (imp env0) fname)))
			(m-env (full env1))
			(vnl (map car vdefs))
			(snl (map car sdefs))
			(ign (enforce-bound-uniqueness!
			      (append vnl snl) fname "definition"))
			(vgsl (map (lambda (n)
				     (cond
				      ((definition-in-full n)
				       =>
				       (lambda (d)
					 (cond
					  ((or (local? d) (reference? d)) d)
					  (else
					   ((syntax-error fname)
					    "decl/def mismatch for: " n)))))
				      (else (gen-local n))))
				   vnl))
			(val (map cons vnl vgsl))
			(stl (map (lambda (x)
				    (compile (cdr x) m-env
					     (new-fname fname (car x))))
				  sdefs))
			(sal (map (lambda (n tf)
				    (if (not (eq? (ee-type tf) 'transformer))
					((syntax-error fname)
					 "bad transformer in: " exp))
				    (cons n (ee-body tf)))
				  snl stl))
			(augmented-env
			 (supply-aux-keyword-bindings stl m-env))
			(n-m-env (lambda (name)
				   (cond ((assoc name val) => cdr)
					 ((assoc name sal) => cdr)
					 (else (augmented-env name))))))

		   (for-each (lambda (a)
			       (set-cdr! a (macro (cdr a) n-m-env
						  (new-fname
						   fname (car a)))))
			     sal)

		   (let* ((req-ndef
			   (filter required
				   (lambda (r)
				     (not (contains (lambda (a)
						      (equal? (car a) r))
						    val)))))
			  (req-ndef-initl
			   (map (lambda (r-nd)
				  (let ((iden (env1 r-nd))
					(oden (definition-in-full r-nd)))
				    (cond
				     ((undefined? iden)
				      ((syntax-error fname)
				       "module must define: " r-nd))
				     ((not (or (local? iden)
					       (integrable? iden)
					       (reference? iden)))
				      ((syntax-error fname)
				       "not imported as a variable: " r-nd))
				     ((local? oden)
				      (cond
				       ((or (local? iden)
					    (integrable? iden))
					(list oden iden))
				       (else
					((syntax-error fname)
					 "cannot export " r-nd
					 " as constant"))))
				     ((not (reference? oden))
				      (bug "macro: req-ndef-initl"))
				     ((reference-dro? oden)
				      (if (or (local? iden)
					      (integrable? iden))
					  (list
					   (reference-var oden)
					   (ee 'app (list i-ref iden)))
					  (list oden iden)))
				     ((not (and (reference? iden)
						(reference-ro? iden)))
				      ((syntax-error fname)
				       "cannot re-export " r-nd
				       " as variable"))
				     (else (list (reference-var oden)
						 (reference-var iden))))))
				req-ndef))

			  (exdl (map n-env required))
			  (vars (map (lambda (d)
				       (if (reference? d)
					   (reference-var d)
					   d))
				     exdl))
			  (exl (map (lambda (r d)
				      (cons (unwrap-name r)
					    (if (not (reference? d))
						'()
						(reference-dro? d))))
				    required exdl))
			  (mp (ee 'app
				  `(,i-module
				    ,(ee 'quote 'signature) ; later
				    ,(ee 'quote (list->vector exl))
				    ,@vars)))

			  (seq (if (pair? body)
				   (append (compile-sequence
					    body n-m-env fname)
					   (list mp))
				   (list mp)))
			  (seq (if (pair? (cdr seq))
				   (unroll-sequence seq)
				   (car seq)))

			  (initl
			   (append
			    (process-imports il env fname)
			    req-ndef-initl
			    (map
			     (lambda (n gs vd)
			       (let ((fname (new-fname fname n)))
				 (if (reference? gs)
				     (list (reference-var gs)
					   (ee 'app
					       (list i-ref
						     (compile
						      (cdr vd)
						      n-m-env fname))))
				     (list gs (compile (cdr vd)
						       n-m-env fname)))))
			     vnl vgsl vdefs))))

		     (if (pair? initl)
			 (ee 'letrec (list initl seq))
			 seq))))

	       (let loop
		   ((body (cdddr exp))
		    (d-env n-env)
		    (imp empty-delta)
		    (vdefs '())
		    (sdefs '())
		    (tdefs '()))
		 (cond ((not (pair? body))
			(finish '() imp vdefs sdefs tdefs))
		       ((definitions-in (car body) d-env fname)
			=>
			(lambda (d)
			  (let ((b (ee-body d)))
			    (loop (cdr body)
				  ((car b) d-env)
				  (compose (car b) imp)
				  (append vdefs (cadr b))
				  (append sdefs (caddr b))
				  (append tdefs (cadddr b))))))
		       (else
			(finish body imp vdefs sdefs tdefs))))))))))

    ;; return definitions or #f (efficient!)
    (define (definitions-in exp env fname)
      (and (pair? exp)
	   (let ((den (lookup (car exp) env fname)))
	     (cond ((special? den)
		    (case (special-symbol den)
		      ((define define-syntax define-type)
		       (compile exp env fname))
		      ((begin)
		       (if (< (length exp) 2)
			   ((syntax-error fname)
			    "empty begin expression: " exp)
			   (let loop
			       ((l (cdr exp))
				(imp empty-delta)
				(vl '())
				(sl '())
				(tl '()))
			     (cond ((not (pair? l))
				    (ee 'definitions (list imp vl sl tl)))
				   ((definitions-in (car l) env fname)
				    =>
				    (lambda (d)
				      (let ((b (ee-body d)))
					(loop (cdr l)
					      (compose (car b) imp)
					      (append vl (cadr b))
					      (append sl (caddr b))
					      (append tl (cadddr b))))))
				   (else #f)))))
		      (else #f)))
		   ((import? den) (compile exp env fname))
		   (else
		    (and (macro? den)
			 (let* ((uid (generate-unique-uid))
				(env-for-expan (bind-aliases uid den env))
				(new-exp
				 (transcribe den exp env uid
					     env-for-expan fname)))
			   (definitions-in
			     new-exp env-for-expan fname))))))))

    (define (get-type exp env tenv fname kind)
      ;; exp - type expression
      ;; env - environment for comparison
      ;; tenv - type's environment
      ;; (later this will have to be done differently)
      (let ((den (lookup exp env fname)))
	(cond ((type? den) den)
	      ((expression? den)
	       (make-type exp env tenv fname))
	      (else ((syntax-error fname)
		     (string-append "bad " kind ": ")
		     exp)))))

    (define (get-sgn-type exp env fname)
      (let ((ty (get-type exp env env fname "signature")))
	(if (or (sgn? (type-def ty))
		(built-in-sgn? (type-def ty)))
	    ty
	    ((syntax-error fname) "not a signature: " exp))))

    (define (make-type exp env tenv fname)
      (let ((cmp (comparison-procedure env fname)))
	(type
	 (cond ((cmp (car exp) 'signature)
		(make-sgn exp env tenv fname))
	       ((cmp (car exp) 'any)
		(let ((nl (cdr exp)))
		  (for-each (enforce-name! fname "exported name") nl)
		  (sgn
		   nl '()
		   (map (lambda (n) (list n 'read-only any-type)) nl)
		   '() empty-delta)))
	       (else
		(no-sgn exp)))
	 tenv)))

    (define (make-sgn exp env tenv fname)

      (if (< (length exp) 3)
	  ((syntax-error fname) "bad signature: " exp))
      (let ((cmp (comparison-procedure env fname))
	    (el (cadr exp)))

	(define (importedsigexp->env-delta sig-exp base-env-delta)
	  (sigexp->env-delta
	   sig-exp env fname #f
	   (dummy-memoizer)
	   (lambda (ign filtered required)
	     (if (not (null? required))
		 ((syntax-error fname)
		  "signature " sig-exp
		  ", imported by " exp ", declares values")
		 (compose filtered base-env-delta)))))

	(let loop ((l (cddr exp))
		   (dl '())
		   (imp-delta empty-delta))
	  (if (not (pair? l))
	      (let* ((defined-in-imp-delta?
		       (delta-checker imp-delta))
		     (exists?
		      (lambda (e)
			(or (contains (lambda (x) (equal? (cadr x) e)) dl)
			    (defined-in-imp-delta? e))))
		     (dnl (map cadr dl)))

		(for-each (enforce-name! fname "exported name") el)

		(for-each (enforce-name! fname "declared name") dnl)

		;; enforce strong form of uniqueness: disregard UIDs
		;; (I don't know if this is the right model)
		(enforce-bound-uniqueness! (map unwrap-name dl)
					   fname "declaration")

		(for-each (lambda (e)
			    (if (not (exists? e))
				((syntax-error fname)
				 "exported name is not defined: "
				 e)))
			  el)

		(let loop
		    ((l dl)
		     (tl '())
		     (sl '())
		     (vl '()))
		  (if (pair? l)
		      (cond ((cmp (caar l) 'define-type)
			     (loop (cdr l) (cons (car l) tl) sl vl))
			    ((cmp (caar l) 'define-syntax)
			     (loop (cdr l) tl (cons (car l) sl) vl))
			    (else
			     (loop (cdr l) tl sl (cons (car l) vl))))
		      (let* ((p (process-type-definitions
				 (map (lambda (td)
					(cons (cadr td) (caddr td)))
				      tl)
				 env fname))
			     (n-env (car p))
			     (al (cdr p)))

			(define (declare dcl)

			  (define (value tag)
			    (list (cadr dcl) tag
				  (get-type (caddr dcl)
					    n-env n-env fname "type")))

			  (let ((tag (car dcl)))
			    (cond ((cmp tag 'constant) (value 'constant))
				  ((cmp tag 'variable) (value 'variable))
				  ((cmp tag 'read-only) (value 'read-only))
				  (else
				   ((syntax-error fname)
				    "bad declaration: " dcl)))))

			(define (defsyn def)
			  (let* ((n (cadr def))
				 (m (caddr def))
				 (tf (compile m env (new-fname fname n))))
			    (if (not (eq? (ee-type tf) 'transformer))
				((syntax-error fname)
				 "bad macro transformer: " m))
			    (cons n tf)))

			(sgn
			 el al
			 (map declare vl)
			 (map defsyn sl)
			 imp-delta)))))

	      (let* ((x (car l))
		     (xlen (length x)))
		(cond ((= xlen 2)
		       (if (cmp (car x) 'use)
			   (loop (cdr l) dl
				 (importedsigexp->env-delta
				  (cadr x) imp-delta))
			   ((syntax-error fname)
			    "bad use clause in signature: " x)))
		      ((= xlen 3)
		       (loop (cdr l) (cons x dl) imp-delta))
		      (else
		       ((syntax-error fname) "bad declaration: " x))))))))

    (define (process-type-definitions tdefs env fname)

      (enforce-bound-uniqueness! (map car tdefs) fname "type definition")

      (let* ((al (map (lambda (tdef) (cons (car tdef) '())) tdefs))
	     (n-env (lambda (name)
		      (cond ((assoc name al) => cdr)
			    (else (env name))))))
	(for-each (lambda (a tdef)
		    (set-cdr!
		     a
		     (get-type (cdr tdef) env n-env fname "type")))
		  al tdefs)
	(cons n-env al)))

    ;; compile a ``body'' (as in lambda/letrec/...)
    (define (compile-body body env orig-exp fname)
      (define (loop body imp vdefs sdefs tdefs)
	(cond ((not (pair? body))
	       ((syntax-error fname)
		"body of expression: " orig-exp " is empty"))
	      ((definitions-in (car body) env fname)
	       =>
	       (lambda (d)
		 (let ((b (ee-body d)))
		   (loop (cdr body)
			 (compose (car b) imp)
			 (append vdefs (cadr b))
			 (append sdefs (caddr b))
			 (append tdefs (cadddr b))))))
	      (else
	       (let* ((env (car (process-type-definitions
				 tdefs (imp env) fname)))
		      (vnl (map car vdefs)) ; v-names
		      (snl (map car sdefs)) ; s-names
		      (ign (enforce-bound-uniqueness!
			    (append vnl snl)
			    fname "internal definitions"))
		      (vgsl (map gen-local vnl)) ; v-gensyms
		      (val (map cons vnl vgsl)) ; v-alist
		      (stl (map (lambda (x)
				  (compile (cdr x) env
					   (new-fname fname (car x))))
				sdefs))	; transformers
		      (sal
		       (map (lambda (n tf)
			      (if (not (eq? (ee-type tf) 'transformer))
				  ((syntax-error fname)
				   "bad transformer in: " orig-exp))
			      (cons n (ee-body tf)))
			    snl stl))
		      (n-env
		       (supply-aux-keyword-bindings
			stl
			(lambda (name)
			  (cond ((assoc name val) => cdr)
				((assoc name sal) => cdr)
				(else (env name)))))))
		 (for-each (lambda (a)
			     (set-cdr! a (macro (cdr a) n-env
						(new-fname fname (car a)))))
			   sal)
		 (let* ((seq (compile-sequence body n-env fname))
			(inner-body
			 (if (pair? (cdr seq))
			     (unroll-sequence seq)
			     (car seq))))
		   (if (pair? vdefs)
		       (ee 'letrec
			   (list
			    (map
			     (lambda (n gs vd)
			       (list gs (compile (cdr vd)
						 n-env
						 (new-fname fname n))))
			     vnl vgsl vdefs)
			    inner-body))
		       inner-body))))))
      (loop body empty-delta '() '() '()))

    (define (handle-definitions imp vdefs sdefs tdefs)

      (define (def->name def) (unwrap-name (car def)))

      (enforce-bound-uniqueness!
       (map car (append vdefs sdefs tdefs)) "Top" "toplevel definitions")

      ;; at this point TOP-LEVEL-IL contains exactly those inclusions
      ;; which will affect the top-level

      (let* ((vl (map def->name vdefs))
	     (il top-level-il)
	     (ign (set! top-level-il '()))
	     (tliseq
	      (map (lambda (i)
		     (let ((x (ee 'app
				  (list
				   i-register-module
				   (compile (car i) toplevel-env "Top")
				   (ee 'quote next-module-slot)))))
		       (set-car! i next-module-slot)
		       (set! next-module-slot (+ next-module-slot 1))
		       x))
		   il)))

	(set! existing-global-imports (append il existing-global-imports))

	;; imports cannot be removed ***************************************
	(global-import! imp)

	(for-each (lambda (v)
		    (register-global-definition! v (global v)))
		  vl)

	(for-each (lambda (tdef)
		    (register-global-definition!
		     (def->name tdef)
		     (get-type
		      (cdr tdef) toplevel-env toplevel-env
		      "Top" "type")))
		  tdefs)

	(for-each (lambda (sdef)
		    (let* ((n (def->name sdef))
			   (fname (symbol->string n))
			   (m (cdr sdef))
			   (tf (compile m toplevel-env fname)))
		      (if (not (eq? (ee-type tf) 'transformer))
			  ((syntax-error fname) "bad macro transformer: " m))
		      (register-global-definition!
		       n (macro (ee-body tf) toplevel-env fname))))
		  sdefs)
	(let* ((qexp (ee 'quote
			 (remove-wrappers
			  (append (map car vdefs)
				  (map car sdefs)
				  (map car tdefs)))))
	       (vseq
		(map (lambda (vdef v)
		       (ee 'set!
			   (list (global v)
				 (compile (cdr vdef)
					  toplevel-env
					  (symbol->string v)))))
		     vdefs vl))
	       (b (if (pair? vseq)
		      (unroll-sequence (append vseq (list qexp)))
		      qexp))
	       (initl (append (process-global-import-accesses)
			      (process-imports
			       top-level-il toplevel-env "Top")))
	       (b (if (pair? initl) (ee 'letrec (list initl b)) b)))

	  (if (pair? tliseq)
	      (unroll-sequence
	       (append tliseq (list b)))
	      b))))

    (define (process-global-import-accesses)
      (define (outer l)
	(cond ((not (pair? l)) '())
	      ((not (pair? (cdar l))) (outer (cdr l)))
	      (else
	       (let ((tmp (new-local 'global-import)))
		 (cons
		  (list tmp (ee 'app
				(list i-fetch-module
				      (ee 'quote (caar l)))))
		  (append (map (make-inner-import-loop tmp) (cdar l))
			  (outer (cdr l))))))))
      (outer existing-global-imports))

    ;; do the expansion
    (define (expand exp)
      (reset-uid!)
      (reset-local-id-counter!)
      (set! top-level-il '())
      (for-each (lambda (i)
		  (set-cdr! i '()))
		existing-global-imports)

      (let* ((e (compile exp toplevel-env "Top")))
	(if (eq? (ee-type e) 'definitions)
	    (let ((b (ee-body e)))
	      (handle-definitions
	       (car b) (cadr b) (caddr b) (cadddr b)))
	    (let* ((gi (process-global-import-accesses))
		   (initl (if (null? top-level-il)
			      gi
			      (append gi
				      (process-imports
				       top-level-il
				       toplevel-env "Top")))))
	      (if (null? initl)
		  e
		  (ee 'letrec (list initl e)))))))

    (register-toplevel-import-connector!
     (lambda (exp sigexp)
       (let ((l (cons exp '())))
	 (sigexp->env-delta
	  sigexp toplevel-env "Top" #t
	  (memoize l)
	  (lambda (ign1 imp-filtered required)
	    (if (pair? required)
		(begin
		  (check-proper-module exp toplevel-env "Top")
		  (set! top-level-il (cons l top-level-il))))
	    imp-filtered)))))))
