(define (ltrc-functor varset-mod fv-mod aux-mod optutil-mod eff-mod
		      lgi-mod scc-mod error-mod)

  (module ltrc-sig ()

    (use scheme-sig)
    (use ee-sig)
    (use varset-mod varset-sig)
    (use fv-mod fv-sig)
    (use aux-mod aux-sig)
    (use optutil-mod optutil-sig)
    (use eff-mod eff-sig)
    (use lgi-mod lgi-sig)
    (use scc-mod scc-sig)
    (use error-mod error-sig)

    ;; letrec decomposition (scc-based)
    (define (decompose-letrecs exp)

      (define (new-node scc)
	(vector 0 '() '() scc #f '()))
      (define (node-n-succ n) (vector-ref n 0))
      (define (node-n-succ-inc! n)
	(vector-set! n 0 (+ (vector-ref n 0) 1)))
      (define (node-n-succ-dec!-zero? n)
	(let ((x (- (vector-ref n 0) 1)))
	  (vector-set! n 0 x)
	  (zero? x)))
      (define (node-prec n) (vector-ref n 1))
      (define (node-prec! n prec) (vector-set! n 1 prec))
      (define (node-fv n) (vector-ref n 2))
      (define (node-fv! n fv) (vector-set! n 2 fv))
      (define (node-scc n) (vector-ref n 3))
      (define (node-rec? n) (vector-ref n 4))
      (define (node-rec! n) (vector-set! n 4 #t))
      (define (node-bl n) (vector-ref n 5))
      (define (node-bl! n bl) (vector-set! n 5 bl))

      (define (construct exp node avail fv)
	(do ((l (node-prec node) (cdr l))
	     (a avail
		(if (node-n-succ-dec!-zero? (car l))
		    (cons (car l) a)
		    a)))
	    ((not (pair? l))
	     (let ((t (if (node-rec? node) 'letrec 'let))
		   (bl (node-bl node)))
	       (decide (info-ee t fv (list bl exp)) a fv)))))

      (define (decide exp avail fv)

	(define (calc-fv node)
	  (varset- (varset+ (node-fv node) fv)
		   (node-scc node)))

	(cond ((not (pair? avail)) exp)
	      ((not (pair? (cdr avail)))
	       (construct exp (car avail) '() (calc-fv (car avail))))
	      (else
	       (letrec
		   ((greedy
		     (lambda (cur cur-fv n-cur-fv other rest)
		       (if (not (pair? other))
			   (construct exp cur rest cur-fv)
			   (let* ((next (car other))
				  (next-fv (calc-fv next))
				  (n-next-fv (length next-fv)))
			     (if (< n-next-fv n-cur-fv)
				 (greedy next next-fv n-next-fv (cdr other)
					 (cons cur rest))
				 (greedy cur cur-fv n-cur-fv (cdr other)
					 (cons next rest))))))))
		 (let* ((cur (car avail))
			(cur-fv (calc-fv cur))
			(n-cur-fv (length cur-fv)))
		   (greedy cur cur-fv n-cur-fv (cdr avail) '()))))))
	  
      (define (decompose exp al es ds vs bl)
	;; exp -- expression to be decomposed
	;; al  -- association under construction
	;; es  -- set of variables associated with effects
	;; ds  -- set of variables depending on effects
	;; vs  -- set of all letrec-variables
	;; bl  -- list of all bindings

	(if (eq? (ee-type exp) 'letrec)
	    (let* ((body (ee-body exp))
		   (mbl (map (bindgen traverse) (car body)))
		   (vs (varset+ vs (list->varset (map car mbl))))
		   (new-es-bl (filter mbl (bindapp could-have-effect?)))
		   (new-ds-bl (filter mbl (bindapp could-depend-on-effect?)))
		   (new-es (list->varset (map car new-es-bl)))
		   (new-ds (list->varset (map car new-ds-bl)))
		   (eds (varset+ es ds)))
	      (decompose
	       (cadr body)
	       (append
		(map (lambda (b)
		       (let ((v (car b))
			     (base (varset* (fv-info (cadr b)) vs)))
			 (cons v
			       (cond ((varset-in? v new-es)
				      (varset+ base eds))
				     ((varset-in? v new-ds)
				      (varset+ base es))
				     (else base)))))
		     mbl)
		al)
	       (varset+ es new-es)
	       (varset+ ds new-ds)
	       vs
	       (append mbl bl)))
	    (let* ((rootvar (new-local 'dummy))
		   (exp (traverse exp))
		   (root (cons rootvar
			       (varset+ (varset* (fv-info exp) vs)
					es)))
		   (al (cons root al))
		   (bl (cons (list rootvar exp) bl))
		   (n->oen (lambda (n) (cdr (assq n al))))
		   (top-ord (scc-top rootvar n->oen eq?)))
	      (if (not (and (= (length (car top-ord)) 1)
			    (eq? (caar top-ord) rootvar)))
		  (bug "scc-top"))
	      (let ((node-list
		     (map (lambda (scc)
			    (let ((node (new-node (list->varset scc))))
			      (for-each (lambda (v)
					  (local-flag! v node))
					scc)
			      node))
			  top-ord)))

		(define (add-nodes new old cur)
		  (define (loop new old)
		    (cond ((not (pair? new)) old)
			  ((eq? (car new) cur)
			   (node-rec! cur)
			   (loop (cdr new) old))
			  ((memq (car new) old)
			   (loop (cdr new) old))
			  (else (loop (cdr new) (cons (car new) old)))))
		  (loop new old))

		(for-each
		 (lambda (node)
		   (let* ((scc (node-scc node))
			  (nbl (map (lambda (v) (assq v bl)) scc)))
		     (node-fv! node
			       (varset++
				(map (bindapp fv-info) nbl)))
		     (node-bl! node nbl)
		     (do ((vl scc (cdr vl))
			  (prec '()
				(add-nodes
				 (map (lambda (x) (local-flag x))
				      (cdr (assq (car vl) al)))
				 prec node)))
			 ((not (pair? vl))
			  (node-prec! node prec)
			  (for-each node-n-succ-inc! prec)))))
		 node-list)

		(let ((node (car node-list)))
		  (do ((l (node-prec node) (cdr l))
		       (a '() (if (node-n-succ-dec!-zero? (car l))
				  (cons (car l) a)
				  a)))
		      ((not (pair? l))
		       (decide exp a (fv-info exp)))))))))

      (define (traverse exp)
	(if (eq? (ee-type exp) 'letrec)
	    (decompose exp '() '() '() '() '())
	    (let ((r (generic traverse exp)))
	      (if (not (memq (ee-type exp) '(local global quote integrable)))
		  (ee-info! r (cheap-freevar r)))
	      r)))

      (traverse exp))))
