/*
 * Corout.c -- Implementation of Scheme Coroutines
 *
 * (C) m.b (Matthias Blume); HUB; Sep 1993 PU/CS
 *         Princeton University, Dept. of Computer Science
 *
 * $Id: Corout.c,v 2.7 1994/11/12 22:13:55 blume Exp $
 */

# include "rcs.h"
RCSID ("$Id: Corout.c,v 2.7 1994/11/12 22:13:55 blume Exp $")

# include <stdio.h>

# include "storext.h"
# include "Corout.h"
# include "Cont.h"
# include "Code.h"
# include "speccont.h"
# include "identifier.h"

# include "type.h"

static void iterator (void *vcr, MEM_visitor proc, void *cd)
{
  (*proc) ((void *)&((ScmCorout *)vcr)->state, cd);
}

static void display (void *vcr, putc_proc pp, void *cd)
{
  char buf [64];

  if (vcr == ScmMainCorout)
    putc_string ("#<Main-Coroutine", pp, cd);
  else {
    sprintf (buf, "#<Coroutine %p", vcr);
    putc_string (buf, pp, cd);
  }
  if (vcr == ScmCurrentCorout)
    putc_string (" (active)", pp, cd);
  (* pp) ('>', cd);
}

ScmCorout *ScmMainCorout = NULL;
ScmCorout *ScmCurrentCorout = NULL;
ScmCont *ScmCC_save = NULL;
void *cr_proc_save = NULL;

static void module_init (void)
{
  MEM_root_var (ScmMainCorout);
  MEM_root_var (ScmCurrentCorout);
  MEM_root_var (ScmCC_save);
  MEM_root_var (cr_proc_save);
}

void ScmInitCoroutines (void)
{
  SCM_NEW (ScmMainCorout, Corout);
  ScmCurrentCorout = ScmMainCorout;
  ScmMainCorout->state = NULL;
}

ScmCorout *ScmNewCorout (void *cr_proc)
{
  ScmCorout *res;

  ScmCC_save = ScmCC;
  cr_proc_save = cr_proc;
  ScmCC = NULL;
  ScmPushCContinuation (8, SCM_VM_TRAP_CONT, NULL); /* sentinel */
  /* coroutine exit sentinel: */
  ScmPushCContinuation (64, SCM_VM_COROUTINE_CONT, NULL);
  /* register special continuation type */
  PUSH (NULL);			/* will be filled in by cr-transfer */
  ScmPrepareProcedureCall (cr_proc_save, 1);
  SCM_NEW (res, Corout);
  res->state = ScmCC;
  ScmCC = ScmCC_save;
  ScmCC_save = NULL;
  cr_proc_save = NULL;
  return res;
}

MEM_VECTOR (Corout,
	    MEM_UNITS (sizeof (ScmCorout)), MEM_NULL_measure,
	    iterator, MEM_NULL_dumper, MEM_NULL_excavator, MEM_NULL_revisor,
	    module_init, MEM_NULL_task, MEM_NULL_task,
	    EXT (SCM_NO_NUMBER,
		 cannot_cvt_real, display, display, NULL_eq, NULL_eq));
