/*
 * Character.c -- Implementation of Scheme Characters
 *
 * (C) m.b (Matthias Blume); Mar 1992, HUB; Jan 1993 PU/CS
 *         Humboldt-University of Berlin
 *         Princeton University, Dept. of Computer Science
 *
 * $Id: Character.c,v 2.6 1994/11/12 22:14:10 blume Exp $
 */

# include "rcs.h"
RCSID ("$Id: Character.c,v 2.6 1994/11/12 22:14:10 blume Exp $")

# include <stdio.h>
# include <ctype.h>

# include "storext.h"
# include "Character.h"
# include "type.h"
# include "identifier.h"
# include "except.h"

static void dumper (void *vchar, FILE *file)
{
  putc ((ScmCharacter *)vchar - ScmCharacter_array, file);
}

static void *excavator (FILE *file)
{
  int c;
  if ((c = getc (file)) == EOF)
    fatal ("bad dump file format (Character)");
  else
    return (void *) (ScmCharacter_array + (unsigned char)c);
  /*NOTREACHED*/
}

static void write_this (void *vchar, putc_proc pp, void *cd)
{
  int c = (ScmCharacter *) vchar - ScmCharacter_array;
  char buf[64];
  char *p;

  switch (c) {
  case ' ':	p = "#\\Space";		break;
  case '\n':	p = "#\\Newline";	break;
  case '\t':	p = "#\\Tab";		break;
  case '\r':	p = "#\\Return";	break;
  case '\b':	p = "#\\Backspace";	break;
  case '\a':	p = "#\\Alarm";		break;
  case '\v':	p = "#\\VTab";		break;
  case '\\':	p = "#\\BackSlash";	break;
  case '\033':	p = "#\\Escape";	break;
  default:	sprintf (buf, isprint (c) ? "#\\%c" : "#\\o%o", c);
		p = buf;
		break;
  }
  putc_string (p, pp, cd);
}

static void display (void *vchar, putc_proc pp, void *cd)
{
  (* pp) ((ScmCharacter *) vchar - ScmCharacter_array, cd);
}

MEM_VECTOR (Character,
	    0, MEM_NULL_measure,
	    MEM_NULL_iterator, dumper, excavator, MEM_NULL_revisor,
	    MEM_NULL_task, MEM_NULL_task, MEM_NULL_task,
	    EXT (SCM_NO_NUMBER,
		 cannot_cvt_real, display, write_this, NULL_eq, NULL_eq));

ScmCharacter ScmCharacter_array [] = {

# define C001 {ScmType(Character)},

# define C004 C001 C001 C001 C001
# define C016 C004 C004 C004 C004
# define C064 C016 C016 C016 C016
# define C256 C064 C064 C064 C064

C256

#undef C256
#undef C064
#undef C016
#undef C004
#undef C001

};
