/*
  swf.h
*/

#ifndef _SWF_H

#include <stdio.h>

typedef struct _SWFWriter SWFWriter;

extern void SWFWriter_write_bytes(SWFWriter* writer, unsigned char* s, unsigned long len);
extern void SWFWriter_write_ui8(SWFWriter* writer, unsigned char x);
extern void SWFWriter_write_si8(SWFWriter* writer, signed char x);
extern void SWFWriter_write_ui16(SWFWriter* writer, unsigned int x);
extern void SWFWriter_write_ub16(SWFWriter* writer, unsigned int x);
extern void SWFWriter_write_si16(SWFWriter* writer, signed int x);
extern void SWFWriter_write_ui32(SWFWriter* writer, unsigned int x);
extern void SWFWriter_write_si32(SWFWriter* writer, signed int x);

extern void SWFWriter_write_rgb(SWFWriter* writer, int r, int g, int b);
extern void SWFWriter_write_rgba(SWFWriter* writer, int r, int g, int b, int a);
extern void SWFWriter_write_cstring(SWFWriter* writer, unsigned char* s);
extern void SWFWriter_write_rect(SWFWriter* writer, int xmin, int ymin, int xmax, int ymax);
extern void SWFWriter_write_matrix(SWFWriter* writer, 
				   int scale, float scalex, float scaley,
				   int rot, float rot0, float rot1,
				   int transx, int transy);
extern void SWFWriter_write_style_solid_fill(SWFWriter* writer, 
					     int r, int g, int b, int a);
extern void SWFWriter_write_style_clipped_bitmap_fill(SWFWriter* writer,
						      int bitmapid, int dx, int dy);
extern void SWFWriter_write_rectshape(SWFWriter* writer, 
				      int x, int y, int w, int h);

extern void SWFWriter_start_tag(SWFWriter* writer, int tag);
extern void SWFWriter_end_tag(SWFWriter* writer);
extern int SWFWriter_new_objid(SWFWriter* writer);
extern SWFWriter* SWFWriter_open(FILE* fp, int swf_version, 
				 int width, int height,
				 float framerate, int compression);
extern void SWFWriter_initialize(SWFWriter* writer);
extern void SWFWriter_next_frame(SWFWriter* writer);
extern unsigned long SWFWriter_close(SWFWriter* writer);

extern int SWFWriter_define_rect_shape_rgb(SWFWriter* writer,
					   int r, int g, int b,
					   int w, int h);
extern int SWFWriter_define_rect_shape_bitmap(SWFWriter* writer, 
					      unsigned char* buf, unsigned long len,
					      int w, int h);
extern void SWFWriter_place_object(SWFWriter* writer, 
				   int cid, int depth, int x, int y);
extern void SWFWriter_remove_object(SWFWriter* writer, int depth);

#endif /* _SWF_H */
