/* @(#)expand.c	1.6 */

#include <config.h>

#include <stdio.h>
#include <string.h>
#include <errno.h>

#include <utf.h>
#include <utftools.h>

static char sccsid[] = "@(#)expand.c	1.6";

static char usage[] = "expand [-v] [-t tabs] [--] [file ...]";

static int tabs;

static void	expandfile(char *);
static int	expandline(FILE *);

int
main(int argc, char **argv)
{
	int c;
	
	errorname = "expand";
	
	tabs = 8;
	
	opterr = 0;
	while ((c = getopt(argc, argv, "vt:")) != -1) {
		switch (c) {
		case 'v':
			fprintf(stderr, "%s\n", sccsid);
			exit(0);
		case 't':
			errno = 0;
			tabs = strtoix(optarg, 10);
			if (errno == ERANGE || errno == EDOM || tabs < 0)
				fatal("-t option must specify a decimal integer greater than zero");
			break;
		default:
			fprintf(stderr, "usage: %s\n", usage);
			exit(1);
		}
	}

	if (argv[optind] == 0) {
		expandfile("-");
	} else {
		while (argv[optind] != 0) {
			expandfile(argv[optind]);
			++optind;
		}
	}
	
	exit(0);
}

static void
expandfile(char *fname)
{
	FILE *fp;

	if (strcmp(fname, "-") == 0)
		fp = stdin;
	else {
		fp = fopen(fname, "r");
		if (fp == 0)
			fatal("unable to open %s", fname);
	}

	while (expandline(fp) != EOF)
		;

	if (strcmp(fname, "-") != 0)
		fclose(fp);
}

static int
expandline(FILE *fp)
{
	int r;
	int col;

	col = 0;
	r = fgetr(fp);
	while (r != EOF && r != '\n') {
		if (r == '\t') {
			do
				fputr(' ', stdout);
			while (++col % tabs != 0);
		} else {
			fputr(r, stdout);
			++col;
		}
		r = fgetr(fp);
	}

	if (r == '\n')
		fputr('\n', stdout);

	return r;
}
