#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include <MyInputArea.hpp>

CMyInputArea::CMyInputArea (int nTty0, CMyConfig *pMyConfig, 
                            CUniKey *pCMyVideo0)
{
    pTheConfig = pMyConfig;
    pCMyVideo = pCMyVideo0;
    pCMyVideo->GetVideoInfo (&MyVideoInfo);
    SelMaxLen = MyVideoInfo.pixel_width/MyVideoInfo.font_width - 2;
    szMethod = NULL;
    x1 = 0; x2 = SelMaxLen;
    y1 = y2 = MyVideoInfo.pixel_height/MyVideoInfo.font_height - 1;
    fgcolor = INPUT_FGCOLOR;
    bgcolor = INPUT_BGCOLOR;
    markcolor = MARK_FGCOLOR;
    which = 0;
    nTty = nTty0;
//    ChineseInput_X = 8;
    ShowFirstStartMsg ();
}

CMyInputArea::~CMyInputArea ()
{
    if (szMethod != NULL)
        free (szMethod);
}

void CMyInputArea::ShowSysMenu ()
{
    char *p = pTheConfig->szSysMenu;
    ClearInputArea ();
    WriteColorTextToInputArea (p);
}

/* Display Help Item */
void CMyInputArea::ShowHelpItem (int n)
{
    n = n % pTheConfig->TotalHelp;
    char *p = pTheConfig->pszHelp[n];
    ClearInputArea ();
    WriteColorTextToInputArea (p);
}

/* Different Language Code support */
void CMyInputArea::SetNewLanguageCode (char *szNewCode)
{
    pTheConfig->ChangeLanguageCode (szNewCode);
}

void CMyInputArea::DisplaySelection (char *szStr)
{
    strcpy (SelectionBuffer, szStr);
}

void CMyInputArea::ClearSelection ()
{
    strcpy (SelectionBuffer, "");
}

void CMyInputArea::DisplayInput (char *szStr)
{
    strcpy (InputBuffer, szStr);
}

void CMyInputArea::ClearInput ()
{
    strcpy (InputBuffer, "");
}

void CMyInputArea::ClearInputArea ()
{
    pCMyVideo->InputAreaClear (0, y1, SelMaxLen + 2, y2, fgcolor);
    // INPUT_FGCOLOR); //bgcolor);
/*  for (int y = y1; y <= y2; y++)
        pCMyVideo->InputAreaClear (x1, y1, x2, y2, bgcolor);
 */
}

void CMyInputArea::WriteToInputArea (char *szStr)
{
    ClearInputArea ();
    pCMyVideo->InputAreaOutput (x1, szStr, INPUT_FGCOLOR,INPUT_BGCOLOR);
}

void CMyInputArea::WriteColorTextToInputArea (char *szStr)
{
    ClearInputArea ();
    pCMyVideo->InputAreaOutput (x1, szStr, INPUT_FGCOLOR,INPUT_BGCOLOR);
/*
    char *buf, *p;
    int j, nBegin = 0;
 
    buf = (char *) malloc (strlen (szStr) + 1);  
    if (buf == NULL)
    {
        printf ("no enough memory to run ....\n");
        exit (-1);
    }

    p = szStr;
    do
    {
        for (j = 0; *p; p++, j++)
        {
            if ((isalnum (*p) || *p == ' ' || *p == '.' || *p == '\t'))
                break;
            buf[j] = *p;
        }
        buf[j] = '\0';

        pCMyVideo->InputAreaOutput(nBegin, buf, INPUT_FGCOLOR,INPUT_BGCOLOR);

        nBegin += strlen (buf) + 1;
        if (*p == '\t')
        {
             p ++;
             nBegin += 4;
        }

        for (j = 0; *p; p++, j++)
        {
            if (!(isalnum (*p) || *p == ' ' || *p == '.' ) || *p == '\t')
                buf[j] = *p;
        }
        buf[j] = '\0';

        pCMyVideo->InputAreaOutput(nBegin, buf, MARK_FGCOLOR,INPUT_BGCOLOR);

        nBegin += strlen (buf) + 1;
        if (*p == '\t')
        {
             p ++;
             nBegin += 4;
        }
    }
    while (*p);
    free (buf);
*/
}

void CMyInputArea::RefreshInputArea (int which, int IsFullSymbol)
{
   char buf[256];
   char *p;
   ClearInputArea ();
   if (which == 3)
   {
       if (IsFullSymbol == 1)
           sprintf (buf, "%s%s%s", 
               pTheConfig->szFullSymbolLeftMark,
               pTheConfig->szFullChar,
               pTheConfig->szFullSymbolRightMark);
       else
           sprintf (buf, "%s%s%s", 
               pTheConfig->szSingleSymbolLeftMark,
               pTheConfig->szFullChar,
               pTheConfig->szSingleSymbolRightMark);
       pCMyVideo->InputAreaOutput (x1, buf, INPUT_FGCOLOR,INPUT_BGCOLOR);
   }
   else if (which == 0)
   {
       sprintf(buf, " [%s] ", pTheConfig->szSingleChar);
       pCMyVideo->InputAreaOutput (x1, buf, INPUT_FGCOLOR,INPUT_BGCOLOR);

       if (IsFullSymbol == 1)
           p = pTheConfig->szFullSymbol;
       else
           p = pTheConfig->szSingleSymbol;
       sprintf(buf, "[%s]", p);
       pCMyVideo->InputAreaOutput (x1 + 8, buf, INPUT_FGCOLOR,INPUT_BGCOLOR);

       sprintf(buf, "%s", pTheConfig->szVersionInfo);
       pCMyVideo->InputAreaOutput (
                   (x2 - x1 - strlen (buf))/2, buf,
                   TITLE_FGCOLOR, INPUT_BGCOLOR);
       sprintf(buf, "[tty%d] %s", nTty, pTheConfig->szLanguageCode);
       pCMyVideo->InputAreaOutput (
                    x2 - x1 - strlen (buf) -1 ,
                    buf, INPUT_FGCOLOR, INPUT_BGCOLOR);
   }
   else if (which == 1)
   {
       if (IsFullSymbol == 1)
           sprintf (OutputBuffer, "%s%s%s %s %s",
                pTheConfig->szFullSymbolLeftMark,
                szMethod,
                pTheConfig->szFullSymbolRightMark,
                InputBuffer, SelectionBuffer);
       else
           sprintf (OutputBuffer, "%s%s%s %s %s", 
               pTheConfig->szSingleSymbolLeftMark,
               szMethod,
               pTheConfig->szSingleSymbolRightMark,
               InputBuffer, SelectionBuffer);
       /* ʾѡִ */
       pCMyVideo->InputAreaOutput (x1, OutputBuffer, fgcolor, bgcolor);
    }
}

void CMyInputArea::SetNewMethod (char *szNewMethod)
{
    szMethod = strdup (szNewMethod);
}

char * CMyInputArea::GetNewMethod ()
{
    return szMethod;
}

void CMyInputArea::ShowFirstStartMsg ()
{
    ClearInputArea ();
    pCMyVideo->InputAreaOutput(0, pTheConfig->szFirstMessage,
                               INPUT_FGCOLOR,INPUT_BGCOLOR);
/*
    char *pMsg1 = " <Unicon Ļ 2.0>";
    char *pMsg2 = " ";
    char *pMsg3 = "Ctrl+F1";
    char *pMsg4 = " ";
    char *pMsg5 = "     ";
    char *pMsg6 = "Shift";
    char *pMsg7 = " = лӢ";
    int nBegin;
    ClearInputArea ();
    pCMyVideo->InputAreaOutput(1, pMsg1, INPUT_FGCOLOR,INPUT_BGCOLOR);
    nBegin = SelMaxLen - (strlen (pMsg2) + strlen (pMsg3) +
                          strlen (pMsg4) + strlen (pMsg5) +
                          strlen (pMsg6) + strlen (pMsg7));
    pCMyVideo->InputAreaOutput(nBegin, pMsg2, INPUT_FGCOLOR,INPUT_BGCOLOR);
    nBegin += strlen (pMsg2);
    pCMyVideo->InputAreaOutput(nBegin, pMsg3, MARK_FGCOLOR,INPUT_BGCOLOR);
    nBegin += strlen (pMsg3);
    pCMyVideo->InputAreaOutput(nBegin, pMsg4, INPUT_FGCOLOR,INPUT_BGCOLOR);
    nBegin += strlen (pMsg4);
    pCMyVideo->InputAreaOutput(nBegin, pMsg5, INPUT_FGCOLOR,INPUT_BGCOLOR);
    nBegin += strlen (pMsg5);
    pCMyVideo->InputAreaOutput(nBegin, pMsg6, MARK_FGCOLOR,INPUT_BGCOLOR);
    nBegin += strlen (pMsg6);
    pCMyVideo->InputAreaOutput(nBegin, pMsg7, INPUT_FGCOLOR,INPUT_BGCOLOR);
*/
}

void CMyInputArea::SetSelectDisplay (char *szStr)
{
    strcpy (SelectionBuffer, szStr);
}

void CMyInputArea::SetInputDisplay (char *szStr)
{
    strcpy (InputBuffer, szStr);
}
 
