#ifndef __MEMFILE_HPP__
#define __MEMFILE_HPP__

#include <stdio.h>
#include <stdlib.h>

typedef char * PSTR;
class TLC_CMemFile
{
private:
   char *buf;
   long max;
   long pos;
   long len;
   bool bAllocate;
public:    
    TLC_CMemFile (char *buf, u_long len, u_long max);
    TLC_CMemFile (u_long max);
    ~TLC_CMemFile ();
    int fseek (long offset, int whence);
    long ftell ();
    size_t fread (void *ptr, size_t size, size_t nmemb);
    size_t  fwrite (void  *ptr,  size_t  size, size_t nmemb);
    void rewind ();
    /* buf operation */
    char *pGetBuf ();
    char *pGetCurrentPos ();
    u_long GetBufLen ();
    u_long GetMax ();
    void SetBufLen (int n);    

    /* operator overload */
    friend TLC_CMemFile & operator >> (TLC_CMemFile &in, long &b);
    friend TLC_CMemFile & operator >> (TLC_CMemFile &in, short &b);
    friend TLC_CMemFile & operator >> (TLC_CMemFile &in, char &b);
    friend TLC_CMemFile & operator >> (TLC_CMemFile &in, PSTR &p);
    friend TLC_CMemFile & operator << (TLC_CMemFile &in, long b);
    friend TLC_CMemFile & operator << (TLC_CMemFile &in, short b);
    friend TLC_CMemFile & operator << (TLC_CMemFile &in, char b);
    friend TLC_CMemFile & operator << (TLC_CMemFile &in, PSTR p);
};

#endif

