/*
 * ufdbglobals.c - URLfilterDB
 *
 * ufdbGuard is copyrighted (C) 2005-2022 by URLfilterDB with all rights reserved.
 *
 * Parts of ufdbGuard are based on squidGuard.
 * This module is NOT based on squidGuard.
 * 
 * RCS $Id: ufdbglobals.c,v 1.32 2022/12/26 23:18:53 root Exp root $
 */

#undef _FORTIFY_SOURCE

#define UFDB_MALLOC_DEBUG     	 0



#include "ufdb.h"
#include "ufdblib.h"

#include <string.h>

#ifdef __cplusplus
extern "C" {
#endif


/* align the following data to start on a new cache line */
UFDB_GCC_ALIGN_CL
UFDB_SHARED struct ufdbGV ufdbNewGV;
UFDB_GCC_ALIGN_CL
UFDB_SHARED struct ufdbGV ufdbOldGV;
UFDB_GCC_ALIGN_CL
UFDB_SHARED struct ufdbGV ufdbGV = {
   .logDirectory = DEFAULT_LOGDIR,
   .progname = "program"
};

UFDB_SHARED FILE * ufdbGlobalLogfile = NULL;

// the following API counters are heavily used
UFDB_GCC_ALIGN_CL
UFDB_SHARED volatile unsigned long UFDB_API_num_url_lookups = 0;	// very hot variable
UFDB_SHARED volatile unsigned long UFDB_API_upload_seqno = 0;
UFDB_GCC_ALIGN_CL
UFDB_SHARED volatile unsigned long UFDB_API_num_url_matches = 0;	// very hot variable
UFDB_SHARED volatile unsigned long UFDB_API_num_url_localnet = 0;
UFDB_SHARED volatile unsigned long UFDB_API_num_protocol_matches = 0;
UFDB_GCC_ALIGN_CL
UFDB_SHARED volatile unsigned long UFDB_API_num_https = 0;		// very hot API - cold BIND
UFDB_SHARED volatile unsigned long UFDB_API_num_bumps = 0;
UFDB_SHARED volatile unsigned long UFDB_API_num_threads = 0;
UFDB_SHARED volatile unsigned long UFDB_API_num_views = 0;
UFDB_SHARED volatile unsigned long UFDB_API_num_nxdomain = 0;           // medium cold
UFDB_GCC_ALIGN_CL
UFDB_SHARED volatile unsigned long UFDB_API_num_errors = 0;             // medium cold
UFDB_GCC_ALIGN_CL
UFDB_SHARED volatile unsigned long UFDB_API_num_uncategorised_URL = 0;  // medium cold
UFDB_SHARED volatile unsigned long UFDB_API_num_nodot_URL = 0;
UFDB_SHARED volatile unsigned long UFDB_API_num_safesearch = 0;
UFDB_SHARED volatile unsigned long UFDB_API_num_regexp_matches = 0;


void UFDBinitializeGV( struct ufdbGV * gv )
{
   gv->status = UFDB_API_STATUS_VIRGIN;
   gv->databaseStatus = UFDB_API_STATUS_DATABASE_OK;
   gv->terminating = 0;
   gv->reconfig = UFDB_RECONFIGR_NONE;
   gv->nWorkers = UFDB_MIN_THREADS;
   gv->debug = 0;			/* TO-DO: or keep volatile ??? */
   gv->serialno = 1;
   gv->upload_seq_no = 1;
   gv->nfree = 0;
   gv->nmalloc = 0;
   gv->nrealloc = 0;
   gv->debugCoreDump = 0;
   gv->crashOnFatal = 0;
   gv->useSyslog = 0;
   gv->logAllRequests = 0;
   gv->logPass = 0;
   gv->logBlock = 0;
   gv->fastRefresh = 0;
   gv->safeSearch = 1;
   gv->skipSafeCategory = 0;
   gv->peek = 0;

   gv->stripDomainFromUsername = 0;
   gv->debugRedirect = 0;
   gv->uploadStats = 1;
   gv->YoutubeEdufilter = 0;
   gv->allowGoogleHTTPSusingIP = 0;
   gv->fatalError = 0;
   gv->memoryAllocationErrors = 0;

   gv->sourceList = NULL;

   gv->tunnelCounter = 0;

   gv->databaseCreationTime = 0;
   gv->databaseLoadTime = 0;
   gv->dateOfCheckedDB[0] = '\0';
   strcpy( gv->licenseStatus, "unknown" );
   strcpy( gv->redirectHttps, UFDB_DEFAULT_HTTPS_REDIRECTION_URL );
   strcpy( gv->redirectBumpedHttps, UFDB_DEFAULT_BUMPED_HTTPS_REDIRECTION_URL );

   gv->configFile = DEFAULT_CONFIGFILE;

   gv->debugSkype = 0;
   gv->debugGtalk = 0;
   gv->debugYahooMsg = 0;
   gv->debugAim = 0;
   gv->debugFBchat = 0;
   gv->debugCitrixOnline = 0;
   gv->debugHttpd = 0;
   gv->debugRegexp = 0;

   gv->silentLogMessage = 0;
   gv->expressionOptimisation = 1;
   gv->refreshUserlistInterval = UFDB_DEFAULT_REFRESH_USERLIST;
   gv->refreshIPlistInterval = UFDB_DEFAULT_REFRESH_IPLIST;
   gv->lastIPcounterResetDate = 0;
   gv->refreshDomainlistInterval = UFDB_DEFAULT_REFRESH_DOMAINLIST;
   gv->debugExternalScripts = 0;
   strcpy( gv->userName, UFDB_USER );

   gv->pidFilename = NULL;
   gv->emailServer = NULL;
   gv->myHostname = NULL;
   gv->adminEmail = NULL;
   gv->senderEmail = NULL;
   gv->externalStatusCommand = NULL;
   gv->YoutubeEdufilterID = NULL;

   gv->URLlookupDelayDBreload = 0;
   gv->URLlookupResultDBreload = UFDB_ALLOW;
   gv->URLlookupResultFatalError = UFDB_ALLOW;
   gv->analyseUncategorisedURLs = 1;
   gv->logUncategorisedURLs = 0;
   gv->portNum = UFDB_DAEMON_PORT;
   gv->showURLdetails = 0;
   gv->logURLdetails = 0;
   gv->uploadCrashReports = 1;
   gv->madviseHugePages = 0;
   gv->lookupReverseIP = 0;
   gv->useAlsoIPv6onWan = 1;
   gv->tunnelCheckMethod = UFDB_API_HTTPS_CHECK_OFF;

   gv->SquidVersion = NULL;
   gv->SquidHelperProtocol = UFDB_SQUID_HELPER_PROTOCOL2;
   gv->SquidUsesActiveBumping = 0;
   gv->parseURLparameters = 1;
   gv->httpsWithHostname = 0;
   gv->httpsOfficialCertificate = 0;
   gv->httpsEnforceContentPeek = 0;
   gv->SkypeOverHttps = 0;
   gv->GtalkOverHttps = 0;
   gv->YahooMsgOverHttps = 0;
   gv->AimOverHttps = 0;
   gv->FBchatOverHttps = 0;
   gv->CitrixOnlineOverHttps = 0;
   gv->AnydeskOverHttps = 0;
   gv->TeamviewerOverHttps = 0;
   gv->httpsNoSSLv2 = 1;
   gv->httpsNoSSLv3 = 1;
   gv->httpsNoTLSv1_0 = 1;
   gv->unknownProtocolOverHttps = 1;

   gv->httpdPort = 0;
   gv->maxLogfiles = 8;
   gv->maxLogfileSize = 200 * 1024 * 1024;	/* 200 MB */

   strcpy( gv->databaseDirectory, DEFAULT_DBHOME );
   strcpy( gv->logDirectory, DEFAULT_LOGDIR );
   strcpy( gv->uploadFileDirectory, DEFAULT_UPLOADDIR );
   strcpy( gv->administrator, "your system administrator or helpdesk" );
   strcpy( gv->interface, "all" );
   strcpy( gv->CAcertsFile, "" );
   strcpy( gv->CAcertsDir, "" );
   strcpy( gv->fatalErrorRedirect, "http://cgibin.urlfilterdb.com/cgi-bin/URLblocked.cgi?category=fatal-error" );
   strcpy( gv->loadingDatabaseRedirect, "http://cgibin.urlfilterdb.com/cgi-bin/URLblocked.cgi?" 
		"category=loading-database" );
   strcpy( gv->httpdInterface, "all" );
   strcpy( gv->httpdImagesDirectory, "." );

   gv->checkedExpressions = NULL;
   memset( (void*) &gv->checkedDB, 0, sizeof(gv->checkedDB) );

   // gv->lastSetting = NULL;
   // gv->setting = NULL;

   gv->lastSource = NULL;

   gv->lastCat = NULL;
   gv->catList = NULL;

   gv->lastRewrite = NULL;
   gv->rewrite = NULL;
   gv->lastRewriteRegExec = NULL;

   gv->lastTime = NULL;
   gv->timeList = NULL;

   // gv->errorLog = NULL;
   // gv->logFile = NULL;
   // gv->lastLogFileStat = NULL;
   // gv->logFileStat = NULL;

   gv->lastTimeElement = NULL;
   gv->timeElement = NULL;

   gv->lastAcl = NULL;
   gv->defaultAcl = NULL;
   gv->aclList = NULL;
   gv->lastAclCategory = NULL;

   gv->lastRegExpDest = NULL;

   gv->tod.tv_sec = 0;
   gv->tod.tv_usec = 0;
   strcpy( gv->progname, "program" );
   gv->Argv = NULL;
   gv->Envp = NULL;
   gv->debugTimeDelta = 0;
   gv->pid = 0;
   gv->failsafe_mode = 0;
   gv->sig_hup = 0;
   gv->sig_other = 0;
   gv->httpsConnectionCacheSize = UFDB_DEF_HTTPS_CONN_CACHE_SIZE;
   gv->configLogged = 0;

   strcpy( gv->unixSocketName, DEFAULT_SOCKETDIR "/commands" );

   gv->numLookupsInProgress = 0;
   gv->num_dbcats = 0;
}


void UFDBresetGV( struct ufdbGV * gv )
{
   if (gv == NULL)
      { ; }
}


void UFDBcopyGV( struct ufdbGV * newgv, struct ufdbGV * oldgv )
{
   *newgv = *oldgv;
   newgv->serialno++;

   newgv->databaseStatus = UFDB_API_STATUS_DATABASE_OK;
   newgv->showURLdetails = 0;
   newgv->analyseUncategorisedURLs = 1;
   newgv->fatalError = 0;

   newgv->pidFilename = NULL;
   newgv->emailServer = NULL;
   newgv->myHostname = NULL;
   newgv->adminEmail = NULL;
   newgv->senderEmail = NULL;
   newgv->externalStatusCommand = NULL;
   newgv->YoutubeEdufilterID = NULL;
   newgv->SquidVersion = NULL;

   newgv->checkedDB.mem = NULL;
   newgv->checkedDB.table.tag = NULL;
   newgv->checkedDB.table.nNextLevels = 0;
   newgv->checkedDB.table.nextLevel = NULL;
   newgv->checkedDB.index = NULL;
   newgv->checkedExpressions = NULL;

   newgv->lastSource = NULL;
   newgv->sourceList = NULL;

   newgv->lastRewrite = NULL;
   newgv->rewrite = NULL;
   newgv->lastRewriteRegExec = NULL;
   newgv->lastRegExpDest = NULL;

   newgv->lastTime = NULL;
   newgv->timeList = NULL;
   newgv->lastTimeElement = NULL;
   newgv->timeElement = NULL;

   newgv->lastCat = NULL;
   newgv->catList = NULL;

   newgv->lastAcl = NULL;
   newgv->defaultAcl = NULL;
   newgv->lastAclCategory = NULL;
   newgv->aclList = NULL;

   newgv->configLogged = 0;

   newgv->nfree = 0;
   newgv->nmalloc = 0;
   newgv->nrealloc = 0;

   newgv->num_dbcats = 0;
   // UFDBresetGVcounters( newgv );
}

#ifdef __cplusplus
}
#endif

