//
// dpufdb.h  -  Nubewell Data-Path and ufdbGuard API integration
//
// RCS $Id: dpufdb.h,v 1.2 2020/06/10 17:30:10 root Exp root $

#ifndef UFDB_DPUFDB_H_INCLUDED
#define UFDB_DPUFDB_H_INCLUDED

#ifdef __cplusplus
extern "C" {
#endif

// The ufdbGuard API can send informational messages, error messages and fatal error messages.
// The DP takes care that these messages are stored and monitored appropriately.
// The message has a maximum size of 4 KiB.
// The API expects that this function returns with little to no delay.
void DPufdbLogMessage( const char * message, int32_t length );

// The ufdbGuard API produces statistics and uncategorised URLs which must be uploaded
// to the servers of URLfilterDB.  See the ufdbGuard API Reference Manual for more information.
// The message is sent to the Control-Path which takes care of the uploading.
// DPufdbSaveStatsAndURLs() returns 0 when the message is sent or a negative error code.
// The message has a maximum size of 32 MiB.
int32_t DPufdbSaveStatsAndURLs( const char * message, int32_t length );

// URL database tables are loaded into memory with DPufdbLoadFile().
// The DP will take care of loading the file into a memory region that is allocated with npos_malloc()
// and hence can be deallocated with npos_free() later.
// DPufdbLoadFile() returns a pointer to the allocated memory and stores the length of the file in *length.
// In case of an error, NULL is returned and *length contains an error code.
// The filename is usually something like "/usr/local/ufdb-api/blacklists/<CATEGORY>/domains.ufdb" or
// "/usr/local/ufdb-api/blacklists/<CATEGORY>/expressions".
// The theoretical maximum file size is 16 GiB but typically in 2020 the maximum size is 300 MiB.
void * DPufdbLoadFile( const char * filename, int64_t * length );

#ifdef __cplusplus
}
#endif

#endif

