/* 
 * dpmalloc.h - malloc/free interface between ufdbGuard API and Data-Path.
 */

/**
 * @brief Wrapper function for memory allocation requests.
 * @param[in] size number of byte the requested memory shall hold.
 * @return Pointer to memory of at least size bytes or NULL for error or out-of-memory.
 */
typedef void *(*ufdb_malloc_t)( uint32_t size );

/**
 * @brief Wrapper function for requests to free allocated memory. 
 * @param[in] ptr pointer to the memory area that should be freed
 */
typedef void (*ufdb_free_t)( void * ptr );

typedef struct ufdb_config_s {
    ufdb_malloc_t ufdb_alloc; /*!< Function pointer to a memory allocation function, default: NULL.
                                       Must be set by the application. */
    ufdb_free_t ufdb_free;    /*!< Function pointer to a memory free function, default: NULL.
                                       Must be set by the application. */
} ufdb_config_t;


/**
 * UFDBmallocInit() copies the function pointers and use those function pointers for 
 * doing malloc.  The ufdbGuard API will use the function pointers for malloc/free.
 *
 * During application initialisation, the application initialises the ufdbGuard API library
 * by first initializing the malloc/free interface with UFDBmallocInit() and second by calling
 * UFDBapiInit(). See the ufdbGuard API Reference Manual for more information about UFDBapiInit().
 */
void UFDBmallocInit( ufdb_config_t * config );

