/*
Copyright (C) 2003, Nik Reiman - nik@aboleo.net

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/****
  UBS help function.  Prints known commands, and information about other UBS commands.  This is only useful from the UBS shell.
****/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <sys/types.h>
#include <errno.h>

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include "ubs-main.h"

#define MAXHELP 32

/*+
  UBS help function

  int cmd_help Returns OK on success, FAIL if the help configuration file cannot be opened.

  int cmdc Number of arguments

  char **cmdv Argument vector
+*/
int cmd_help(int cmdc, char **cmdv) {
 char *help_arr[MAXHELP];
 int i, num_cmds = 0;
 ubs_table help;

 ubs_table_init(&help);

 // do all commands
 if(cmdc == 1) {
  for(i = 0; i < MAXHELP; i++) {
   help_arr[i] = (char *)calloc(STRBUF, sizeof(char));
  }

  if(read_config("etc/help.conf", "help", &help)) {
   return FAIL;
  }

  num_cmds = split_line(help_arr, ubs_table_data(&help, "commands"), STRBUF);
  printf("Known commands:\n");
  for(i = 0; i < num_cmds; i++) {
   if(!read_config("etc/help.conf", help_arr[i], &help)) {
    printf("  %s: %s\n", help_arr[i], ubs_table_data(&help, "desc"));
   }
  }
  printf("For more information about a command, type 'help command'\n");
 }
 // a command was specified
 else {
  sub_help_cmd(cmdv[1]);
 }

 return OK;
}

/*+
  sub_help_cmd Returns OK on success, FAIL on any type of error

  char *command The name of the command to give help on
+*/
int sub_help_cmd(char *command) {
 char *help_arr[MAXHELP], buf[MAXHELP];
 int i, num_flags = 0;
 ubs_table help;

 ubs_table_init(&help);

 for(i = 0; i < MAXHELP; i++) {
  help_arr[i] = (char *)calloc(STRBUF, sizeof(char));
 }

 if(!read_config("etc/help.conf", command, &help)) {
  printf("%s: %s\n", command, ubs_table_data(&help, "desc"));
  printf("%s\n", ubs_table_data(&help, "detail"));

  snprintf(buf, STRBUF, "%sflags", command);
  if(ubs_table_exists(&help, "flags")) {
   num_flags = split_line(help_arr, ubs_table_data(&help, "flags"), STRBUF);
   if(!read_config("etc/help.conf", buf, &help)) {
    printf("Known flags:\n");
    for(i = 0; i < num_flags; i++) {
     printf("  -%s: %s\n", help_arr[i], ubs_table_data(&help, help_arr[i]));
    }
   }
   else {
    printf("Error: Can't parse commands in configuration file");
    return FAIL;
   }
  }
  else {
   printf("Error: Can't parse commands in configuration file");
   return FAIL;
  }
 }
 else {
  printf("Error: Can't parse help configuration file");
  return FAIL;
 }

 return OK;
}
