/*
Copyright (C) 2003, Nik Reiman - nik@aboleo.net

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/****
  Displays information about known events, as detailed in the ubs.conf file.
****/

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <sys/types.h>
#include <errno.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#include "ubs-main.h"
#include "ubs-event.h"

/*+
  Displays information about known events in the ubs-event process.

  int cmd_events Returns OK on success

  int cmdc Number of arguments

  char **cmdv Argument vector
+*/
int cmd_events(int cmdc, char **cmdv) {
 char ch;
 int format = ENGLISH, i;

 while((ch = getopt(cmdc, cmdv, "hwces")) != -1) {
  switch(ch) {
   case 'e':
    format = ENGLISH;
    break;
   case 'c':
    format = CSV;
    break;
   case 'w':
    format = HTML;
    break;
   case 's':
    format = SILENT;
    break;
   case 'h':
    sub_help_cmd("events");
    return OK;
    break;
   default:
    sub_help_cmd("events");
    return OK;
    break;
  }
 }

 cmdc -= optind;
 cmdv += optind;

 for(i = 0; i < atoi(ubs_table_data(&EVENT, "numevents")); i++) {
  sub_dump_event(i, format);
 }

 return OK;
}

/*+
  sub_dump_event Returns OK for success

  int event_num The event index in the ALLEVENTS array

  int format The output mode
+*/
int sub_dump_event(int event_num, int format) {
 if(format == ENGLISH) {
  printf("Event ID: %d\n", event_num);
  printf("  Event Name: %s\n", ALLEVENTS[event_num].name);
  printf("  Logfile: %s\n", ALLEVENTS[event_num].logfile);
  printf("  Time: %02d:%02d\n", ALLEVENTS[event_num].hrs, ALLEVENTS[event_num].mins);
 }
 else if(format == CSV) {
  printf("%s,%s,%02d:%02d\n", ALLEVENTS[event_num].name, ALLEVENTS[event_num].logfile, ALLEVENTS[event_num].hrs, ALLEVENTS[event_num].mins);
 }
 else if(format == HTML) {
  printf("<tr><td>%s</td><td>%s</td><td>%02d:%02d</td></tr>\n", ALLEVENTS[event_num].name, ALLEVENTS[event_num].logfile, ALLEVENTS[event_num].hrs, ALLEVENTS[event_num].mins);
 }
 
 return OK;
}
