#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 1396
#define LARGE_STATE_COUNT 120
#define SYMBOL_COUNT 208
#define ALIAS_COUNT 2
#define TOKEN_COUNT 104
#define EXTERNAL_TOKEN_COUNT 12
#define FIELD_COUNT 18
#define MAX_ALIAS_SEQUENCE_LENGTH 9
#define PRODUCTION_ID_COUNT 72

enum {
  sym__identifier = 1,
  sym_comment = 2,
  sym_true = 3,
  sym_false = 4,
  sym_null = 5,
  sym_underscore = 6,
  sym_static_keyword = 7,
  anon_sym_remote = 8,
  anon_sym_master = 9,
  anon_sym_puppet = 10,
  anon_sym_remotesync = 11,
  anon_sym_mastersync = 12,
  anon_sym_puppetsync = 13,
  sym_escape_sequence = 14,
  sym_float = 15,
  sym_integer = 16,
  anon_sym_AMP = 17,
  sym_node_path = 18,
  sym_get_node = 19,
  anon_sym_SEMI = 20,
  anon_sym_AT = 21,
  anon_sym_COLON_EQ = 22,
  anon_sym_COLON = 23,
  anon_sym_EQ = 24,
  anon_sym_set = 25,
  anon_sym_get = 26,
  anon_sym_COMMA = 27,
  anon_sym_setget = 28,
  anon_sym_var = 29,
  anon_sym_export = 30,
  anon_sym_onready = 31,
  anon_sym_const = 32,
  anon_sym_return = 33,
  anon_sym_pass = 34,
  anon_sym_break = 35,
  sym_breakpoint_statement = 36,
  anon_sym_continue = 37,
  sym_tool_statement = 38,
  anon_sym_signal = 39,
  anon_sym_class_name = 40,
  anon_sym_DOT = 41,
  anon_sym_extends = 42,
  anon_sym_if = 43,
  anon_sym_elif = 44,
  anon_sym_else = 45,
  anon_sym_for = 46,
  anon_sym_in = 47,
  anon_sym_while = 48,
  anon_sym_class = 49,
  anon_sym_enum = 50,
  anon_sym_LBRACE = 51,
  anon_sym_RBRACE = 52,
  anon_sym_match = 53,
  sym_pattern_open_ending = 54,
  anon_sym_LBRACK = 55,
  anon_sym_RBRACK = 56,
  anon_sym_and = 57,
  anon_sym_AMP_AMP = 58,
  anon_sym_or = 59,
  anon_sym_PIPE_PIPE = 60,
  anon_sym_PLUS = 61,
  anon_sym_DASH = 62,
  anon_sym_STAR = 63,
  anon_sym_SLASH = 64,
  anon_sym_PERCENT = 65,
  anon_sym_PIPE = 66,
  anon_sym_CARET = 67,
  anon_sym_LT_LT = 68,
  anon_sym_GT_GT = 69,
  anon_sym_is = 70,
  anon_sym_as = 71,
  anon_sym_not = 72,
  anon_sym_BANG = 73,
  anon_sym_TILDE = 74,
  anon_sym_LT = 75,
  anon_sym_LT_EQ = 76,
  anon_sym_EQ_EQ = 77,
  anon_sym_BANG_EQ = 78,
  anon_sym_GT_EQ = 79,
  anon_sym_GT = 80,
  anon_sym_LPAREN = 81,
  anon_sym_RPAREN = 82,
  anon_sym_await = 83,
  anon_sym_PLUS_EQ = 84,
  anon_sym_DASH_EQ = 85,
  anon_sym_STAR_EQ = 86,
  anon_sym_SLASH_EQ = 87,
  anon_sym_PERCENT_EQ = 88,
  anon_sym_GT_GT_EQ = 89,
  anon_sym_LT_LT_EQ = 90,
  anon_sym_AMP_EQ = 91,
  anon_sym_CARET_EQ = 92,
  anon_sym_PIPE_EQ = 93,
  anon_sym_DASH_GT = 94,
  anon_sym_func = 95,
  anon_sym__init = 96,
  sym__newline = 97,
  sym__indent = 98,
  sym__dedent = 99,
  sym__string_start = 100,
  sym__string_content = 101,
  sym__string_end = 102,
  sym__body_end = 103,
  sym_source = 104,
  sym_identifier = 105,
  sym_name = 106,
  sym_type = 107,
  sym_remote_keyword = 108,
  sym_string = 109,
  sym_string_name = 110,
  sym__statement = 111,
  sym_body = 112,
  sym__simple_statements = 113,
  sym_expression_statement = 114,
  sym_annotation = 115,
  aux_sym__annotations = 116,
  sym_annotations = 117,
  sym_inferred_type = 118,
  sym__variable_assignment = 119,
  sym__variable_inferred_type_assignment = 120,
  sym__variable_typed_assignment = 121,
  sym__variable_typed_definition = 122,
  sym_set_body = 123,
  sym_get_body = 124,
  sym__set_assign = 125,
  sym__get_assign = 126,
  sym__setget_body = 127,
  sym_setter = 128,
  sym_getter = 129,
  sym_setget = 130,
  sym__variable_statement = 131,
  sym_variable_statement = 132,
  sym_export_variable_statement = 133,
  sym_onready_variable_statement = 134,
  sym_const_statement = 135,
  sym_return_statement = 136,
  sym_pass_statement = 137,
  sym_break_statement = 138,
  sym_continue_statement = 139,
  sym_signal_statement = 140,
  sym_class_name_statement = 141,
  sym_dotted_type = 142,
  sym_extends_statement = 143,
  sym_if_statement = 144,
  sym_elif_clause = 145,
  sym_else_clause = 146,
  sym_for_statement = 147,
  sym_while_statement = 148,
  sym_class_definition = 149,
  sym_enum_definition = 150,
  sym_enumerator_list = 151,
  sym__enumerator_expression = 152,
  sym_enumerator = 153,
  sym_match_statement = 154,
  sym_match_body = 155,
  sym_pattern_section = 156,
  sym__pattern = 157,
  sym_pattern_binding = 158,
  sym_pattern_array = 159,
  sym_pattern_dictionary = 160,
  sym_pattern_pair = 161,
  sym__expression = 162,
  sym__primary_expression = 163,
  sym__rhs_expression = 164,
  sym__attribute_expression = 165,
  sym_binary_operator = 166,
  sym_unary_operator = 167,
  sym_comparison_operator = 168,
  sym_subscript = 169,
  sym_attribute_call = 170,
  sym_attribute_subscript = 171,
  sym_attribute = 172,
  sym_conditional_expression = 173,
  sym_parenthesized_expression = 174,
  sym_await_expression = 175,
  sym_assignment = 176,
  sym_augmented_assignment = 177,
  sym_pair = 178,
  sym_dictionary = 179,
  sym_array = 180,
  sym_typed_parameter = 181,
  sym_default_parameter = 182,
  sym_typed_default_parameter = 183,
  sym__parameters = 184,
  sym_parameters = 185,
  sym__return_type = 186,
  sym_function_definition = 187,
  sym_lambda = 188,
  sym_constructor_definition = 189,
  sym_arguments = 190,
  sym_base_call = 191,
  sym_call = 192,
  aux_sym_source_repeat1 = 193,
  aux_sym_string_repeat1 = 194,
  aux_sym__simple_statements_repeat1 = 195,
  aux_sym_dotted_type_repeat1 = 196,
  aux_sym_if_statement_repeat1 = 197,
  aux_sym_enumerator_list_repeat1 = 198,
  aux_sym_match_body_repeat1 = 199,
  aux_sym_pattern_section_repeat1 = 200,
  aux_sym_pattern_array_repeat1 = 201,
  aux_sym_pattern_dictionary_repeat1 = 202,
  aux_sym_comparison_operator_repeat1 = 203,
  aux_sym_attribute_repeat1 = 204,
  aux_sym_dictionary_repeat1 = 205,
  aux_sym_array_repeat1 = 206,
  aux_sym_parameters_repeat1 = 207,
  anon_alias_sym_body = 208,
  anon_alias_sym_value = 209,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym__identifier] = "_identifier",
  [sym_comment] = "comment",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_null] = "null",
  [sym_underscore] = "underscore",
  [sym_static_keyword] = "static_keyword",
  [anon_sym_remote] = "remote",
  [anon_sym_master] = "master",
  [anon_sym_puppet] = "puppet",
  [anon_sym_remotesync] = "remotesync",
  [anon_sym_mastersync] = "mastersync",
  [anon_sym_puppetsync] = "puppetsync",
  [sym_escape_sequence] = "escape_sequence",
  [sym_float] = "float",
  [sym_integer] = "integer",
  [anon_sym_AMP] = "&",
  [sym_node_path] = "node_path",
  [sym_get_node] = "get_node",
  [anon_sym_SEMI] = ";",
  [anon_sym_AT] = "@",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_COLON] = ":",
  [anon_sym_EQ] = "=",
  [anon_sym_set] = "set",
  [anon_sym_get] = "get",
  [anon_sym_COMMA] = ",",
  [anon_sym_setget] = "setget",
  [anon_sym_var] = "var",
  [anon_sym_export] = "export",
  [anon_sym_onready] = "onready",
  [anon_sym_const] = "const",
  [anon_sym_return] = "return",
  [anon_sym_pass] = "pass",
  [anon_sym_break] = "break",
  [sym_breakpoint_statement] = "breakpoint_statement",
  [anon_sym_continue] = "continue",
  [sym_tool_statement] = "tool_statement",
  [anon_sym_signal] = "signal",
  [anon_sym_class_name] = "class_name",
  [anon_sym_DOT] = ".",
  [anon_sym_extends] = "extends",
  [anon_sym_if] = "if",
  [anon_sym_elif] = "elif",
  [anon_sym_else] = "else",
  [anon_sym_for] = "for",
  [anon_sym_in] = "in",
  [anon_sym_while] = "while",
  [anon_sym_class] = "class",
  [anon_sym_enum] = "enum",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_match] = "match",
  [sym_pattern_open_ending] = "pattern_open_ending",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_and] = "and",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_or] = "or",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_STAR] = "*",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_PIPE] = "|",
  [anon_sym_CARET] = "^",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_is] = "is",
  [anon_sym_as] = "as",
  [anon_sym_not] = "not",
  [anon_sym_BANG] = "!",
  [anon_sym_TILDE] = "~",
  [anon_sym_LT] = "<",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_GT] = ">",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_await] = "await",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_func] = "func",
  [anon_sym__init] = "_init",
  [sym__newline] = "_newline",
  [sym__indent] = "_indent",
  [sym__dedent] = "_dedent",
  [sym__string_start] = "\"",
  [sym__string_content] = "_string_content",
  [sym__string_end] = "\"",
  [sym__body_end] = "_body_end",
  [sym_source] = "source",
  [sym_identifier] = "identifier",
  [sym_name] = "name",
  [sym_type] = "type",
  [sym_remote_keyword] = "remote_keyword",
  [sym_string] = "string",
  [sym_string_name] = "string_name",
  [sym__statement] = "_statement",
  [sym_body] = "body",
  [sym__simple_statements] = "_simple_statements",
  [sym_expression_statement] = "expression_statement",
  [sym_annotation] = "annotation",
  [aux_sym__annotations] = "_annotations",
  [sym_annotations] = "annotations",
  [sym_inferred_type] = "inferred_type",
  [sym__variable_assignment] = "_variable_assignment",
  [sym__variable_inferred_type_assignment] = "_variable_inferred_type_assignment",
  [sym__variable_typed_assignment] = "_variable_typed_assignment",
  [sym__variable_typed_definition] = "_variable_typed_definition",
  [sym_set_body] = "set_body",
  [sym_get_body] = "get_body",
  [sym__set_assign] = "_set_assign",
  [sym__get_assign] = "_get_assign",
  [sym__setget_body] = "_setget_body",
  [sym_setter] = "setter",
  [sym_getter] = "getter",
  [sym_setget] = "setget",
  [sym__variable_statement] = "_variable_statement",
  [sym_variable_statement] = "variable_statement",
  [sym_export_variable_statement] = "export_variable_statement",
  [sym_onready_variable_statement] = "onready_variable_statement",
  [sym_const_statement] = "const_statement",
  [sym_return_statement] = "return_statement",
  [sym_pass_statement] = "pass_statement",
  [sym_break_statement] = "break_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_signal_statement] = "signal_statement",
  [sym_class_name_statement] = "class_name_statement",
  [sym_dotted_type] = "dotted_type",
  [sym_extends_statement] = "extends_statement",
  [sym_if_statement] = "if_statement",
  [sym_elif_clause] = "elif_clause",
  [sym_else_clause] = "else_clause",
  [sym_for_statement] = "for_statement",
  [sym_while_statement] = "while_statement",
  [sym_class_definition] = "class_definition",
  [sym_enum_definition] = "enum_definition",
  [sym_enumerator_list] = "enumerator_list",
  [sym__enumerator_expression] = "_enumerator_expression",
  [sym_enumerator] = "enumerator",
  [sym_match_statement] = "match_statement",
  [sym_match_body] = "match_body",
  [sym_pattern_section] = "pattern_section",
  [sym__pattern] = "_pattern",
  [sym_pattern_binding] = "pattern_binding",
  [sym_pattern_array] = "pattern_array",
  [sym_pattern_dictionary] = "pattern_dictionary",
  [sym_pattern_pair] = "pattern_pair",
  [sym__expression] = "_expression",
  [sym__primary_expression] = "_primary_expression",
  [sym__rhs_expression] = "_rhs_expression",
  [sym__attribute_expression] = "_attribute_expression",
  [sym_binary_operator] = "binary_operator",
  [sym_unary_operator] = "unary_operator",
  [sym_comparison_operator] = "comparison_operator",
  [sym_subscript] = "subscript",
  [sym_attribute_call] = "attribute_call",
  [sym_attribute_subscript] = "attribute_subscript",
  [sym_attribute] = "attribute",
  [sym_conditional_expression] = "conditional_expression",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_await_expression] = "await_expression",
  [sym_assignment] = "assignment",
  [sym_augmented_assignment] = "augmented_assignment",
  [sym_pair] = "pair",
  [sym_dictionary] = "dictionary",
  [sym_array] = "array",
  [sym_typed_parameter] = "typed_parameter",
  [sym_default_parameter] = "default_parameter",
  [sym_typed_default_parameter] = "typed_default_parameter",
  [sym__parameters] = "_parameters",
  [sym_parameters] = "parameters",
  [sym__return_type] = "_return_type",
  [sym_function_definition] = "function_definition",
  [sym_lambda] = "lambda",
  [sym_constructor_definition] = "constructor_definition",
  [sym_arguments] = "arguments",
  [sym_base_call] = "base_call",
  [sym_call] = "call",
  [aux_sym_source_repeat1] = "source_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym__simple_statements_repeat1] = "_simple_statements_repeat1",
  [aux_sym_dotted_type_repeat1] = "dotted_type_repeat1",
  [aux_sym_if_statement_repeat1] = "if_statement_repeat1",
  [aux_sym_enumerator_list_repeat1] = "enumerator_list_repeat1",
  [aux_sym_match_body_repeat1] = "match_body_repeat1",
  [aux_sym_pattern_section_repeat1] = "pattern_section_repeat1",
  [aux_sym_pattern_array_repeat1] = "pattern_array_repeat1",
  [aux_sym_pattern_dictionary_repeat1] = "pattern_dictionary_repeat1",
  [aux_sym_comparison_operator_repeat1] = "comparison_operator_repeat1",
  [aux_sym_attribute_repeat1] = "attribute_repeat1",
  [aux_sym_dictionary_repeat1] = "dictionary_repeat1",
  [aux_sym_array_repeat1] = "array_repeat1",
  [aux_sym_parameters_repeat1] = "parameters_repeat1",
  [anon_alias_sym_body] = "body",
  [anon_alias_sym_value] = "value",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym__identifier] = sym__identifier,
  [sym_comment] = sym_comment,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_null] = sym_null,
  [sym_underscore] = sym_underscore,
  [sym_static_keyword] = sym_static_keyword,
  [anon_sym_remote] = anon_sym_remote,
  [anon_sym_master] = anon_sym_master,
  [anon_sym_puppet] = anon_sym_puppet,
  [anon_sym_remotesync] = anon_sym_remotesync,
  [anon_sym_mastersync] = anon_sym_mastersync,
  [anon_sym_puppetsync] = anon_sym_puppetsync,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_float] = sym_float,
  [sym_integer] = sym_integer,
  [anon_sym_AMP] = anon_sym_AMP,
  [sym_node_path] = sym_node_path,
  [sym_get_node] = sym_get_node,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_AT] = anon_sym_AT,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_set] = anon_sym_set,
  [anon_sym_get] = anon_sym_get,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_setget] = anon_sym_setget,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_export] = anon_sym_export,
  [anon_sym_onready] = anon_sym_onready,
  [anon_sym_const] = anon_sym_const,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_pass] = anon_sym_pass,
  [anon_sym_break] = anon_sym_break,
  [sym_breakpoint_statement] = sym_breakpoint_statement,
  [anon_sym_continue] = anon_sym_continue,
  [sym_tool_statement] = sym_tool_statement,
  [anon_sym_signal] = anon_sym_signal,
  [anon_sym_class_name] = anon_sym_class_name,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_extends] = anon_sym_extends,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_elif] = anon_sym_elif,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_in] = anon_sym_in,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_match] = anon_sym_match,
  [sym_pattern_open_ending] = sym_pattern_open_ending,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_is] = anon_sym_is,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_not] = anon_sym_not,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_await] = anon_sym_await,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_func] = anon_sym_func,
  [anon_sym__init] = anon_sym__init,
  [sym__newline] = sym__newline,
  [sym__indent] = sym__indent,
  [sym__dedent] = sym__dedent,
  [sym__string_start] = sym__string_start,
  [sym__string_content] = sym__string_content,
  [sym__string_end] = sym__string_start,
  [sym__body_end] = sym__body_end,
  [sym_source] = sym_source,
  [sym_identifier] = sym_identifier,
  [sym_name] = sym_name,
  [sym_type] = sym_type,
  [sym_remote_keyword] = sym_remote_keyword,
  [sym_string] = sym_string,
  [sym_string_name] = sym_string_name,
  [sym__statement] = sym__statement,
  [sym_body] = sym_body,
  [sym__simple_statements] = sym__simple_statements,
  [sym_expression_statement] = sym_expression_statement,
  [sym_annotation] = sym_annotation,
  [aux_sym__annotations] = aux_sym__annotations,
  [sym_annotations] = sym_annotations,
  [sym_inferred_type] = sym_inferred_type,
  [sym__variable_assignment] = sym__variable_assignment,
  [sym__variable_inferred_type_assignment] = sym__variable_inferred_type_assignment,
  [sym__variable_typed_assignment] = sym__variable_typed_assignment,
  [sym__variable_typed_definition] = sym__variable_typed_definition,
  [sym_set_body] = sym_set_body,
  [sym_get_body] = sym_get_body,
  [sym__set_assign] = sym__set_assign,
  [sym__get_assign] = sym__get_assign,
  [sym__setget_body] = sym__setget_body,
  [sym_setter] = sym_setter,
  [sym_getter] = sym_getter,
  [sym_setget] = sym_setget,
  [sym__variable_statement] = sym__variable_statement,
  [sym_variable_statement] = sym_variable_statement,
  [sym_export_variable_statement] = sym_export_variable_statement,
  [sym_onready_variable_statement] = sym_onready_variable_statement,
  [sym_const_statement] = sym_const_statement,
  [sym_return_statement] = sym_return_statement,
  [sym_pass_statement] = sym_pass_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_signal_statement] = sym_signal_statement,
  [sym_class_name_statement] = sym_class_name_statement,
  [sym_dotted_type] = sym_dotted_type,
  [sym_extends_statement] = sym_extends_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_elif_clause] = sym_elif_clause,
  [sym_else_clause] = sym_else_clause,
  [sym_for_statement] = sym_for_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_class_definition] = sym_class_definition,
  [sym_enum_definition] = sym_enum_definition,
  [sym_enumerator_list] = sym_enumerator_list,
  [sym__enumerator_expression] = sym__enumerator_expression,
  [sym_enumerator] = sym_enumerator,
  [sym_match_statement] = sym_match_statement,
  [sym_match_body] = sym_match_body,
  [sym_pattern_section] = sym_pattern_section,
  [sym__pattern] = sym__pattern,
  [sym_pattern_binding] = sym_pattern_binding,
  [sym_pattern_array] = sym_pattern_array,
  [sym_pattern_dictionary] = sym_pattern_dictionary,
  [sym_pattern_pair] = sym_pattern_pair,
  [sym__expression] = sym__expression,
  [sym__primary_expression] = sym__primary_expression,
  [sym__rhs_expression] = sym__rhs_expression,
  [sym__attribute_expression] = sym__attribute_expression,
  [sym_binary_operator] = sym_binary_operator,
  [sym_unary_operator] = sym_unary_operator,
  [sym_comparison_operator] = sym_comparison_operator,
  [sym_subscript] = sym_subscript,
  [sym_attribute_call] = sym_attribute_call,
  [sym_attribute_subscript] = sym_attribute_subscript,
  [sym_attribute] = sym_attribute,
  [sym_conditional_expression] = sym_conditional_expression,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_await_expression] = sym_await_expression,
  [sym_assignment] = sym_assignment,
  [sym_augmented_assignment] = sym_augmented_assignment,
  [sym_pair] = sym_pair,
  [sym_dictionary] = sym_dictionary,
  [sym_array] = sym_array,
  [sym_typed_parameter] = sym_typed_parameter,
  [sym_default_parameter] = sym_default_parameter,
  [sym_typed_default_parameter] = sym_typed_default_parameter,
  [sym__parameters] = sym__parameters,
  [sym_parameters] = sym_parameters,
  [sym__return_type] = sym__return_type,
  [sym_function_definition] = sym_function_definition,
  [sym_lambda] = sym_lambda,
  [sym_constructor_definition] = sym_constructor_definition,
  [sym_arguments] = sym_arguments,
  [sym_base_call] = sym_base_call,
  [sym_call] = sym_call,
  [aux_sym_source_repeat1] = aux_sym_source_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym__simple_statements_repeat1] = aux_sym__simple_statements_repeat1,
  [aux_sym_dotted_type_repeat1] = aux_sym_dotted_type_repeat1,
  [aux_sym_if_statement_repeat1] = aux_sym_if_statement_repeat1,
  [aux_sym_enumerator_list_repeat1] = aux_sym_enumerator_list_repeat1,
  [aux_sym_match_body_repeat1] = aux_sym_match_body_repeat1,
  [aux_sym_pattern_section_repeat1] = aux_sym_pattern_section_repeat1,
  [aux_sym_pattern_array_repeat1] = aux_sym_pattern_array_repeat1,
  [aux_sym_pattern_dictionary_repeat1] = aux_sym_pattern_dictionary_repeat1,
  [aux_sym_comparison_operator_repeat1] = aux_sym_comparison_operator_repeat1,
  [aux_sym_attribute_repeat1] = aux_sym_attribute_repeat1,
  [aux_sym_dictionary_repeat1] = aux_sym_dictionary_repeat1,
  [aux_sym_array_repeat1] = aux_sym_array_repeat1,
  [aux_sym_parameters_repeat1] = aux_sym_parameters_repeat1,
  [anon_alias_sym_body] = anon_alias_sym_body,
  [anon_alias_sym_value] = anon_alias_sym_value,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym__identifier] = {
    .visible = false,
    .named = true,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_null] = {
    .visible = true,
    .named = true,
  },
  [sym_underscore] = {
    .visible = true,
    .named = true,
  },
  [sym_static_keyword] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_remote] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_master] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_puppet] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_remotesync] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mastersync] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_puppetsync] = {
    .visible = true,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [sym_node_path] = {
    .visible = true,
    .named = true,
  },
  [sym_get_node] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_set] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_get] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_setget] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_export] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_onready] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_pass] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [sym_breakpoint_statement] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [sym_tool_statement] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_signal] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class_name] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extends] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_elif] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_in] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_match] = {
    .visible = true,
    .named = false,
  },
  [sym_pattern_open_ending] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_is] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_await] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_func] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__init] = {
    .visible = true,
    .named = false,
  },
  [sym__newline] = {
    .visible = false,
    .named = true,
  },
  [sym__indent] = {
    .visible = false,
    .named = true,
  },
  [sym__dedent] = {
    .visible = false,
    .named = true,
  },
  [sym__string_start] = {
    .visible = true,
    .named = false,
  },
  [sym__string_content] = {
    .visible = false,
    .named = true,
  },
  [sym__string_end] = {
    .visible = true,
    .named = false,
  },
  [sym__body_end] = {
    .visible = false,
    .named = true,
  },
  [sym_source] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_name] = {
    .visible = true,
    .named = true,
  },
  [sym_type] = {
    .visible = true,
    .named = true,
  },
  [sym_remote_keyword] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_string_name] = {
    .visible = true,
    .named = true,
  },
  [sym__statement] = {
    .visible = false,
    .named = true,
  },
  [sym_body] = {
    .visible = true,
    .named = true,
  },
  [sym__simple_statements] = {
    .visible = false,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_annotation] = {
    .visible = true,
    .named = true,
  },
  [aux_sym__annotations] = {
    .visible = false,
    .named = false,
  },
  [sym_annotations] = {
    .visible = true,
    .named = true,
  },
  [sym_inferred_type] = {
    .visible = true,
    .named = true,
  },
  [sym__variable_assignment] = {
    .visible = false,
    .named = true,
  },
  [sym__variable_inferred_type_assignment] = {
    .visible = false,
    .named = true,
  },
  [sym__variable_typed_assignment] = {
    .visible = false,
    .named = true,
  },
  [sym__variable_typed_definition] = {
    .visible = false,
    .named = true,
  },
  [sym_set_body] = {
    .visible = true,
    .named = true,
  },
  [sym_get_body] = {
    .visible = true,
    .named = true,
  },
  [sym__set_assign] = {
    .visible = false,
    .named = true,
  },
  [sym__get_assign] = {
    .visible = false,
    .named = true,
  },
  [sym__setget_body] = {
    .visible = false,
    .named = true,
  },
  [sym_setter] = {
    .visible = true,
    .named = true,
  },
  [sym_getter] = {
    .visible = true,
    .named = true,
  },
  [sym_setget] = {
    .visible = true,
    .named = true,
  },
  [sym__variable_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_variable_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_export_variable_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_onready_variable_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_const_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_pass_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_signal_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_class_name_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_dotted_type] = {
    .visible = true,
    .named = true,
  },
  [sym_extends_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_elif_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_else_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_class_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_enumerator_list] = {
    .visible = true,
    .named = true,
  },
  [sym__enumerator_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_enumerator] = {
    .visible = true,
    .named = true,
  },
  [sym_match_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_match_body] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern_section] = {
    .visible = true,
    .named = true,
  },
  [sym__pattern] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_pattern_binding] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern_array] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern_dictionary] = {
    .visible = true,
    .named = true,
  },
  [sym_pattern_pair] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__primary_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym__rhs_expression] = {
    .visible = false,
    .named = true,
  },
  [sym__attribute_expression] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_binary_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_comparison_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_subscript] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_call] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute_subscript] = {
    .visible = true,
    .named = true,
  },
  [sym_attribute] = {
    .visible = true,
    .named = true,
  },
  [sym_conditional_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_await_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_augmented_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_pair] = {
    .visible = true,
    .named = true,
  },
  [sym_dictionary] = {
    .visible = true,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym_typed_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_default_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_typed_default_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym__parameters] = {
    .visible = false,
    .named = true,
    .supertype = true,
  },
  [sym_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym__return_type] = {
    .visible = false,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_lambda] = {
    .visible = true,
    .named = true,
  },
  [sym_constructor_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_base_call] = {
    .visible = true,
    .named = true,
  },
  [sym_call] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__simple_statements_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dotted_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enumerator_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_match_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pattern_section_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pattern_array_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_pattern_dictionary_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_comparison_operator_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_attribute_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_dictionary_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_array_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [anon_alias_sym_body] = {
    .visible = true,
    .named = false,
  },
  [anon_alias_sym_value] = {
    .visible = true,
    .named = false,
  },
};

enum {
  field_alternative = 1,
  field_body = 2,
  field_condition = 3,
  field_constructor_arguments = 4,
  field_export_arguments = 5,
  field_extends = 6,
  field_get = 7,
  field_icon_path = 8,
  field_key = 9,
  field_left = 10,
  field_name = 11,
  field_parameters = 12,
  field_return_type = 13,
  field_right = 14,
  field_set = 15,
  field_setget = 16,
  field_type = 17,
  field_value = 18,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alternative] = "alternative",
  [field_body] = "body",
  [field_condition] = "condition",
  [field_constructor_arguments] = "constructor_arguments",
  [field_export_arguments] = "export_arguments",
  [field_extends] = "extends",
  [field_get] = "get",
  [field_icon_path] = "icon_path",
  [field_key] = "key",
  [field_left] = "left",
  [field_name] = "name",
  [field_parameters] = "parameters",
  [field_return_type] = "return_type",
  [field_right] = "right",
  [field_set] = "set",
  [field_setget] = "setget",
  [field_type] = "type",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 4},
  [3] = {.index = 4, .length = 1},
  [4] = {.index = 5, .length = 4},
  [5] = {.index = 9, .length = 1},
  [6] = {.index = 10, .length = 2},
  [7] = {.index = 12, .length = 3},
  [8] = {.index = 15, .length = 2},
  [9] = {.index = 17, .length = 2},
  [10] = {.index = 19, .length = 2},
  [11] = {.index = 21, .length = 4},
  [12] = {.index = 25, .length = 5},
  [13] = {.index = 30, .length = 1},
  [14] = {.index = 31, .length = 2},
  [15] = {.index = 33, .length = 1},
  [16] = {.index = 34, .length = 2},
  [17] = {.index = 36, .length = 1},
  [18] = {.index = 37, .length = 1},
  [19] = {.index = 38, .length = 2},
  [20] = {.index = 40, .length = 3},
  [21] = {.index = 43, .length = 4},
  [22] = {.index = 47, .length = 5},
  [23] = {.index = 52, .length = 1},
  [24] = {.index = 53, .length = 2},
  [25] = {.index = 55, .length = 2},
  [26] = {.index = 57, .length = 2},
  [27] = {.index = 59, .length = 2},
  [28] = {.index = 61, .length = 2},
  [29] = {.index = 63, .length = 1},
  [30] = {.index = 64, .length = 2},
  [31] = {.index = 66, .length = 3},
  [32] = {.index = 69, .length = 2},
  [33] = {.index = 71, .length = 2},
  [34] = {.index = 73, .length = 1},
  [35] = {.index = 74, .length = 3},
  [36] = {.index = 77, .length = 3},
  [37] = {.index = 80, .length = 3},
  [38] = {.index = 83, .length = 1},
  [39] = {.index = 84, .length = 1},
  [40] = {.index = 85, .length = 3},
  [41] = {.index = 88, .length = 3},
  [42] = {.index = 91, .length = 3},
  [43] = {.index = 94, .length = 4},
  [44] = {.index = 98, .length = 3},
  [45] = {.index = 101, .length = 3},
  [46] = {.index = 104, .length = 2},
  [47] = {.index = 106, .length = 1},
  [48] = {.index = 107, .length = 1},
  [49] = {.index = 108, .length = 2},
  [50] = {.index = 110, .length = 1},
  [51] = {.index = 111, .length = 4},
  [52] = {.index = 115, .length = 2},
  [53] = {.index = 117, .length = 3},
  [54] = {.index = 120, .length = 4},
  [55] = {.index = 124, .length = 4},
  [56] = {.index = 128, .length = 3},
  [57] = {.index = 131, .length = 3},
  [59] = {.index = 134, .length = 2},
  [60] = {.index = 136, .length = 2},
  [61] = {.index = 138, .length = 1},
  [62] = {.index = 139, .length = 1},
  [63] = {.index = 140, .length = 2},
  [64] = {.index = 142, .length = 3},
  [65] = {.index = 145, .length = 3},
  [66] = {.index = 148, .length = 4},
  [68] = {.index = 152, .length = 2},
  [69] = {.index = 154, .length = 2},
  [70] = {.index = 156, .length = 1},
  [71] = {.index = 157, .length = 4},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 0, .inherited = true},
    {field_setget, 0, .inherited = true},
    {field_type, 0, .inherited = true},
    {field_value, 0, .inherited = true},
  [4] =
    {field_name, 1},
  [5] =
    {field_name, 1, .inherited = true},
    {field_setget, 1, .inherited = true},
    {field_type, 1, .inherited = true},
    {field_value, 1, .inherited = true},
  [9] =
    {field_body, 1},
  [10] =
    {field_name, 1},
    {field_value, 2, .inherited = true},
  [12] =
    {field_name, 1},
    {field_type, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [15] =
    {field_type, 0, .inherited = true},
    {field_value, 0, .inherited = true},
  [17] =
    {field_get, 0, .inherited = true},
    {field_set, 0, .inherited = true},
  [19] =
    {field_name, 1},
    {field_setget, 2},
  [21] =
    {field_name, 2, .inherited = true},
    {field_setget, 2, .inherited = true},
    {field_type, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [25] =
    {field_export_arguments, 1},
    {field_name, 2, .inherited = true},
    {field_setget, 2, .inherited = true},
    {field_type, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [30] =
    {field_left, 0},
  [31] =
    {field_body, 2},
    {field_name, 1},
  [33] =
    {field_name, 2},
  [34] =
    {field_left, 0},
    {field_right, 2},
  [36] =
    {field_type, 1},
  [37] =
    {field_value, 1},
  [38] =
    {field_type, 0},
    {field_value, 1},
  [40] =
    {field_name, 1},
    {field_setget, 3},
    {field_value, 2, .inherited = true},
  [43] =
    {field_name, 1},
    {field_setget, 3},
    {field_type, 2, .inherited = true},
    {field_value, 2, .inherited = true},
  [47] =
    {field_export_arguments, 1},
    {field_name, 3, .inherited = true},
    {field_setget, 3, .inherited = true},
    {field_type, 3, .inherited = true},
    {field_value, 3, .inherited = true},
  [52] =
    {field_icon_path, 3},
  [53] =
    {field_body, 3},
    {field_condition, 1},
  [55] =
    {field_body, 3},
    {field_name, 1},
  [57] =
    {field_key, 0},
    {field_value, 2},
  [59] =
    {field_body, 3},
    {field_value, 1},
  [61] =
    {field_body, 3},
    {field_parameters, 1},
  [63] =
    {field_return_type, 1},
  [64] =
    {field_name, 2},
    {field_value, 3, .inherited = true},
  [66] =
    {field_name, 2},
    {field_type, 3, .inherited = true},
    {field_value, 3, .inherited = true},
  [69] =
    {field_name, 2},
    {field_setget, 3},
  [71] =
    {field_body, 4},
    {field_parameters, 2},
  [73] =
    {field_alternative, 0},
  [74] =
    {field_alternative, 4},
    {field_body, 3},
    {field_condition, 1},
  [77] =
    {field_alternative, 4, .inherited = true},
    {field_body, 3},
    {field_condition, 1},
  [80] =
    {field_body, 4},
    {field_extends, 2},
    {field_name, 1},
  [83] =
    {field_type, 2},
  [84] =
    {field_value, 2},
  [85] =
    {field_body, 4},
    {field_name, 1},
    {field_parameters, 2},
  [88] =
    {field_body, 4},
    {field_parameters, 1},
    {field_return_type, 2, .inherited = true},
  [91] =
    {field_name, 2},
    {field_setget, 4},
    {field_value, 3, .inherited = true},
  [94] =
    {field_name, 2},
    {field_setget, 4},
    {field_type, 3, .inherited = true},
    {field_value, 3, .inherited = true},
  [98] =
    {field_body, 5},
    {field_name, 2},
    {field_parameters, 3},
  [101] =
    {field_body, 5},
    {field_parameters, 2},
    {field_return_type, 3, .inherited = true},
  [104] =
    {field_body, 5},
    {field_parameters, 3},
  [106] =
    {field_set, 2},
  [107] =
    {field_get, 2},
  [108] =
    {field_type, 1},
    {field_value, 3},
  [110] =
    {field_return_type, 2, .inherited = true},
  [111] =
    {field_alternative, 4, .inherited = true},
    {field_alternative, 5},
    {field_body, 3},
    {field_condition, 1},
  [115] =
    {field_alternative, 0, .inherited = true},
    {field_alternative, 1, .inherited = true},
  [117] =
    {field_body, 5},
    {field_left, 1},
    {field_right, 3},
  [120] =
    {field_body, 5},
    {field_name, 1},
    {field_parameters, 2},
    {field_return_type, 3, .inherited = true},
  [124] =
    {field_body, 6},
    {field_name, 2},
    {field_parameters, 3},
    {field_return_type, 4, .inherited = true},
  [128] =
    {field_body, 6},
    {field_name, 3},
    {field_parameters, 4},
  [131] =
    {field_body, 6},
    {field_parameters, 3},
    {field_return_type, 4, .inherited = true},
  [134] =
    {field_get, 3},
    {field_set, 2},
  [136] =
    {field_get, 2},
    {field_set, 3},
  [138] =
    {field_return_type, 3, .inherited = true},
  [139] =
    {field_body, 2},
  [140] =
    {field_type, 2},
    {field_value, 4},
  [142] =
    {field_body, 6},
    {field_constructor_arguments, 4},
    {field_parameters, 2},
  [145] =
    {field_body, 6},
    {field_parameters, 2},
    {field_return_type, 4},
  [148] =
    {field_body, 7},
    {field_name, 3},
    {field_parameters, 4},
    {field_return_type, 5, .inherited = true},
  [152] =
    {field_get, 4, .inherited = true},
    {field_set, 2, .inherited = true},
  [154] =
    {field_get, 2, .inherited = true},
    {field_set, 4, .inherited = true},
  [156] =
    {field_body, 3},
  [157] =
    {field_body, 8},
    {field_constructor_arguments, 4},
    {field_parameters, 2},
    {field_return_type, 6},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [2] = {
    [1] = anon_alias_sym_value,
  },
  [58] = {
    [2] = anon_alias_sym_body,
  },
  [67] = {
    [3] = anon_alias_sym_body,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym_string, 2,
    sym_string,
    anon_alias_sym_value,
  sym_body, 2,
    sym_body,
    anon_alias_sym_body,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 2,
  [4] = 2,
  [5] = 5,
  [6] = 2,
  [7] = 5,
  [8] = 2,
  [9] = 5,
  [10] = 5,
  [11] = 5,
  [12] = 5,
  [13] = 2,
  [14] = 2,
  [15] = 5,
  [16] = 16,
  [17] = 5,
  [18] = 2,
  [19] = 2,
  [20] = 5,
  [21] = 5,
  [22] = 2,
  [23] = 23,
  [24] = 16,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 32,
  [34] = 34,
  [35] = 35,
  [36] = 36,
  [37] = 29,
  [38] = 38,
  [39] = 39,
  [40] = 40,
  [41] = 41,
  [42] = 42,
  [43] = 42,
  [44] = 44,
  [45] = 39,
  [46] = 46,
  [47] = 47,
  [48] = 26,
  [49] = 25,
  [50] = 36,
  [51] = 46,
  [52] = 52,
  [53] = 34,
  [54] = 54,
  [55] = 30,
  [56] = 30,
  [57] = 57,
  [58] = 36,
  [59] = 35,
  [60] = 60,
  [61] = 60,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 65,
  [66] = 25,
  [67] = 64,
  [68] = 36,
  [69] = 69,
  [70] = 69,
  [71] = 71,
  [72] = 71,
  [73] = 36,
  [74] = 25,
  [75] = 26,
  [76] = 76,
  [77] = 76,
  [78] = 65,
  [79] = 30,
  [80] = 47,
  [81] = 54,
  [82] = 28,
  [83] = 62,
  [84] = 30,
  [85] = 85,
  [86] = 38,
  [87] = 63,
  [88] = 26,
  [89] = 52,
  [90] = 26,
  [91] = 36,
  [92] = 27,
  [93] = 25,
  [94] = 26,
  [95] = 85,
  [96] = 40,
  [97] = 30,
  [98] = 25,
  [99] = 99,
  [100] = 99,
  [101] = 101,
  [102] = 99,
  [103] = 101,
  [104] = 99,
  [105] = 99,
  [106] = 101,
  [107] = 101,
  [108] = 99,
  [109] = 101,
  [110] = 99,
  [111] = 101,
  [112] = 101,
  [113] = 101,
  [114] = 101,
  [115] = 99,
  [116] = 99,
  [117] = 99,
  [118] = 101,
  [119] = 119,
  [120] = 120,
  [121] = 121,
  [122] = 122,
  [123] = 120,
  [124] = 121,
  [125] = 122,
  [126] = 126,
  [127] = 127,
  [128] = 128,
  [129] = 129,
  [130] = 130,
  [131] = 131,
  [132] = 132,
  [133] = 133,
  [134] = 132,
  [135] = 130,
  [136] = 133,
  [137] = 127,
  [138] = 131,
  [139] = 126,
  [140] = 129,
  [141] = 128,
  [142] = 142,
  [143] = 143,
  [144] = 144,
  [145] = 145,
  [146] = 146,
  [147] = 147,
  [148] = 148,
  [149] = 149,
  [150] = 150,
  [151] = 151,
  [152] = 152,
  [153] = 153,
  [154] = 154,
  [155] = 155,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 159,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 166,
  [167] = 167,
  [168] = 168,
  [169] = 169,
  [170] = 170,
  [171] = 171,
  [172] = 165,
  [173] = 162,
  [174] = 158,
  [175] = 163,
  [176] = 159,
  [177] = 164,
  [178] = 155,
  [179] = 166,
  [180] = 157,
  [181] = 170,
  [182] = 154,
  [183] = 142,
  [184] = 160,
  [185] = 143,
  [186] = 156,
  [187] = 168,
  [188] = 146,
  [189] = 161,
  [190] = 169,
  [191] = 145,
  [192] = 144,
  [193] = 153,
  [194] = 148,
  [195] = 171,
  [196] = 149,
  [197] = 167,
  [198] = 150,
  [199] = 151,
  [200] = 152,
  [201] = 147,
  [202] = 202,
  [203] = 203,
  [204] = 204,
  [205] = 205,
  [206] = 206,
  [207] = 207,
  [208] = 208,
  [209] = 209,
  [210] = 210,
  [211] = 211,
  [212] = 212,
  [213] = 213,
  [214] = 214,
  [215] = 215,
  [216] = 216,
  [217] = 217,
  [218] = 218,
  [219] = 216,
  [220] = 220,
  [221] = 221,
  [222] = 222,
  [223] = 223,
  [224] = 224,
  [225] = 225,
  [226] = 226,
  [227] = 227,
  [228] = 228,
  [229] = 227,
  [230] = 230,
  [231] = 231,
  [232] = 232,
  [233] = 233,
  [234] = 234,
  [235] = 227,
  [236] = 225,
  [237] = 237,
  [238] = 238,
  [239] = 239,
  [240] = 240,
  [241] = 226,
  [242] = 225,
  [243] = 226,
  [244] = 225,
  [245] = 245,
  [246] = 227,
  [247] = 247,
  [248] = 248,
  [249] = 249,
  [250] = 250,
  [251] = 251,
  [252] = 225,
  [253] = 225,
  [254] = 254,
  [255] = 226,
  [256] = 256,
  [257] = 226,
  [258] = 258,
  [259] = 227,
  [260] = 227,
  [261] = 226,
  [262] = 262,
  [263] = 225,
  [264] = 264,
  [265] = 226,
  [266] = 227,
  [267] = 267,
  [268] = 268,
  [269] = 269,
  [270] = 269,
  [271] = 271,
  [272] = 267,
  [273] = 273,
  [274] = 274,
  [275] = 275,
  [276] = 268,
  [277] = 274,
  [278] = 273,
  [279] = 269,
  [280] = 273,
  [281] = 273,
  [282] = 268,
  [283] = 273,
  [284] = 267,
  [285] = 267,
  [286] = 271,
  [287] = 267,
  [288] = 269,
  [289] = 274,
  [290] = 271,
  [291] = 274,
  [292] = 271,
  [293] = 269,
  [294] = 268,
  [295] = 268,
  [296] = 271,
  [297] = 271,
  [298] = 267,
  [299] = 273,
  [300] = 274,
  [301] = 274,
  [302] = 268,
  [303] = 267,
  [304] = 271,
  [305] = 269,
  [306] = 273,
  [307] = 274,
  [308] = 269,
  [309] = 268,
  [310] = 310,
  [311] = 310,
  [312] = 312,
  [313] = 313,
  [314] = 313,
  [315] = 315,
  [316] = 316,
  [317] = 317,
  [318] = 313,
  [319] = 319,
  [320] = 320,
  [321] = 313,
  [322] = 313,
  [323] = 313,
  [324] = 324,
  [325] = 316,
  [326] = 310,
  [327] = 327,
  [328] = 313,
  [329] = 329,
  [330] = 204,
  [331] = 202,
  [332] = 332,
  [333] = 206,
  [334] = 203,
  [335] = 335,
  [336] = 335,
  [337] = 337,
  [338] = 338,
  [339] = 337,
  [340] = 338,
  [341] = 341,
  [342] = 338,
  [343] = 337,
  [344] = 344,
  [345] = 338,
  [346] = 337,
  [347] = 347,
  [348] = 338,
  [349] = 349,
  [350] = 341,
  [351] = 351,
  [352] = 338,
  [353] = 353,
  [354] = 338,
  [355] = 344,
  [356] = 349,
  [357] = 335,
  [358] = 344,
  [359] = 337,
  [360] = 337,
  [361] = 335,
  [362] = 344,
  [363] = 347,
  [364] = 344,
  [365] = 335,
  [366] = 344,
  [367] = 335,
  [368] = 335,
  [369] = 344,
  [370] = 337,
  [371] = 353,
  [372] = 351,
  [373] = 373,
  [374] = 374,
  [375] = 375,
  [376] = 376,
  [377] = 376,
  [378] = 376,
  [379] = 376,
  [380] = 376,
  [381] = 376,
  [382] = 374,
  [383] = 375,
  [384] = 384,
  [385] = 385,
  [386] = 386,
  [387] = 387,
  [388] = 388,
  [389] = 389,
  [390] = 390,
  [391] = 391,
  [392] = 392,
  [393] = 393,
  [394] = 376,
  [395] = 374,
  [396] = 375,
  [397] = 384,
  [398] = 385,
  [399] = 386,
  [400] = 387,
  [401] = 388,
  [402] = 389,
  [403] = 390,
  [404] = 391,
  [405] = 392,
  [406] = 393,
  [407] = 393,
  [408] = 375,
  [409] = 384,
  [410] = 393,
  [411] = 385,
  [412] = 392,
  [413] = 391,
  [414] = 390,
  [415] = 389,
  [416] = 388,
  [417] = 387,
  [418] = 386,
  [419] = 385,
  [420] = 384,
  [421] = 393,
  [422] = 386,
  [423] = 387,
  [424] = 374,
  [425] = 393,
  [426] = 388,
  [427] = 392,
  [428] = 391,
  [429] = 390,
  [430] = 389,
  [431] = 388,
  [432] = 387,
  [433] = 386,
  [434] = 385,
  [435] = 384,
  [436] = 375,
  [437] = 374,
  [438] = 389,
  [439] = 390,
  [440] = 391,
  [441] = 392,
  [442] = 391,
  [443] = 390,
  [444] = 389,
  [445] = 388,
  [446] = 387,
  [447] = 386,
  [448] = 205,
  [449] = 385,
  [450] = 384,
  [451] = 374,
  [452] = 375,
  [453] = 393,
  [454] = 392,
  [455] = 392,
  [456] = 391,
  [457] = 390,
  [458] = 389,
  [459] = 388,
  [460] = 387,
  [461] = 386,
  [462] = 385,
  [463] = 384,
  [464] = 375,
  [465] = 374,
  [466] = 205,
  [467] = 217,
  [468] = 215,
  [469] = 223,
  [470] = 223,
  [471] = 216,
  [472] = 215,
  [473] = 222,
  [474] = 214,
  [475] = 213,
  [476] = 207,
  [477] = 210,
  [478] = 209,
  [479] = 208,
  [480] = 220,
  [481] = 212,
  [482] = 221,
  [483] = 218,
  [484] = 222,
  [485] = 205,
  [486] = 216,
  [487] = 216,
  [488] = 215,
  [489] = 223,
  [490] = 216,
  [491] = 217,
  [492] = 222,
  [493] = 218,
  [494] = 221,
  [495] = 212,
  [496] = 220,
  [497] = 208,
  [498] = 209,
  [499] = 214,
  [500] = 210,
  [501] = 207,
  [502] = 217,
  [503] = 213,
  [504] = 214,
  [505] = 213,
  [506] = 207,
  [507] = 210,
  [508] = 209,
  [509] = 208,
  [510] = 220,
  [511] = 212,
  [512] = 214,
  [513] = 217,
  [514] = 221,
  [515] = 213,
  [516] = 218,
  [517] = 216,
  [518] = 207,
  [519] = 210,
  [520] = 209,
  [521] = 208,
  [522] = 220,
  [523] = 212,
  [524] = 221,
  [525] = 218,
  [526] = 222,
  [527] = 216,
  [528] = 223,
  [529] = 215,
  [530] = 216,
  [531] = 216,
  [532] = 213,
  [533] = 230,
  [534] = 237,
  [535] = 240,
  [536] = 228,
  [537] = 233,
  [538] = 224,
  [539] = 258,
  [540] = 239,
  [541] = 238,
  [542] = 228,
  [543] = 239,
  [544] = 238,
  [545] = 248,
  [546] = 546,
  [547] = 216,
  [548] = 251,
  [549] = 256,
  [550] = 222,
  [551] = 204,
  [552] = 264,
  [553] = 218,
  [554] = 221,
  [555] = 212,
  [556] = 220,
  [557] = 262,
  [558] = 208,
  [559] = 209,
  [560] = 245,
  [561] = 210,
  [562] = 207,
  [563] = 213,
  [564] = 214,
  [565] = 216,
  [566] = 217,
  [567] = 254,
  [568] = 249,
  [569] = 216,
  [570] = 247,
  [571] = 237,
  [572] = 230,
  [573] = 233,
  [574] = 216,
  [575] = 234,
  [576] = 206,
  [577] = 245,
  [578] = 262,
  [579] = 202,
  [580] = 258,
  [581] = 224,
  [582] = 256,
  [583] = 250,
  [584] = 203,
  [585] = 232,
  [586] = 248,
  [587] = 231,
  [588] = 231,
  [589] = 234,
  [590] = 230,
  [591] = 247,
  [592] = 249,
  [593] = 254,
  [594] = 264,
  [595] = 204,
  [596] = 251,
  [597] = 251,
  [598] = 248,
  [599] = 232,
  [600] = 264,
  [601] = 203,
  [602] = 223,
  [603] = 228,
  [604] = 240,
  [605] = 239,
  [606] = 238,
  [607] = 237,
  [608] = 250,
  [609] = 205,
  [610] = 233,
  [611] = 231,
  [612] = 233,
  [613] = 237,
  [614] = 256,
  [615] = 224,
  [616] = 238,
  [617] = 239,
  [618] = 258,
  [619] = 215,
  [620] = 202,
  [621] = 262,
  [622] = 240,
  [623] = 228,
  [624] = 250,
  [625] = 245,
  [626] = 206,
  [627] = 234,
  [628] = 222,
  [629] = 234,
  [630] = 215,
  [631] = 206,
  [632] = 218,
  [633] = 223,
  [634] = 221,
  [635] = 245,
  [636] = 262,
  [637] = 248,
  [638] = 202,
  [639] = 212,
  [640] = 258,
  [641] = 251,
  [642] = 204,
  [643] = 220,
  [644] = 264,
  [645] = 254,
  [646] = 249,
  [647] = 208,
  [648] = 247,
  [649] = 232,
  [650] = 230,
  [651] = 224,
  [652] = 209,
  [653] = 240,
  [654] = 210,
  [655] = 247,
  [656] = 249,
  [657] = 254,
  [658] = 207,
  [659] = 231,
  [660] = 256,
  [661] = 214,
  [662] = 232,
  [663] = 250,
  [664] = 217,
  [665] = 203,
  [666] = 224,
  [667] = 205,
  [668] = 230,
  [669] = 234,
  [670] = 254,
  [671] = 264,
  [672] = 206,
  [673] = 245,
  [674] = 204,
  [675] = 262,
  [676] = 251,
  [677] = 202,
  [678] = 231,
  [679] = 248,
  [680] = 258,
  [681] = 232,
  [682] = 203,
  [683] = 228,
  [684] = 240,
  [685] = 239,
  [686] = 238,
  [687] = 250,
  [688] = 237,
  [689] = 256,
  [690] = 224,
  [691] = 233,
  [692] = 249,
  [693] = 249,
  [694] = 203,
  [695] = 205,
  [696] = 233,
  [697] = 262,
  [698] = 245,
  [699] = 237,
  [700] = 206,
  [701] = 234,
  [702] = 238,
  [703] = 239,
  [704] = 258,
  [705] = 256,
  [706] = 250,
  [707] = 240,
  [708] = 228,
  [709] = 202,
  [710] = 247,
  [711] = 232,
  [712] = 231,
  [713] = 230,
  [714] = 247,
  [715] = 251,
  [716] = 254,
  [717] = 264,
  [718] = 204,
  [719] = 248,
  [720] = 720,
  [721] = 721,
  [722] = 722,
  [723] = 723,
  [724] = 724,
  [725] = 725,
  [726] = 726,
  [727] = 727,
  [728] = 726,
  [729] = 726,
  [730] = 726,
  [731] = 726,
  [732] = 725,
  [733] = 726,
  [734] = 726,
  [735] = 735,
  [736] = 736,
  [737] = 737,
  [738] = 738,
  [739] = 737,
  [740] = 738,
  [741] = 738,
  [742] = 742,
  [743] = 743,
  [744] = 744,
  [745] = 745,
  [746] = 746,
  [747] = 747,
  [748] = 748,
  [749] = 749,
  [750] = 750,
  [751] = 751,
  [752] = 752,
  [753] = 720,
  [754] = 720,
  [755] = 131,
  [756] = 132,
  [757] = 130,
  [758] = 721,
  [759] = 128,
  [760] = 720,
  [761] = 761,
  [762] = 720,
  [763] = 721,
  [764] = 129,
  [765] = 133,
  [766] = 721,
  [767] = 767,
  [768] = 721,
  [769] = 720,
  [770] = 721,
  [771] = 721,
  [772] = 720,
  [773] = 773,
  [774] = 773,
  [775] = 773,
  [776] = 776,
  [777] = 777,
  [778] = 778,
  [779] = 773,
  [780] = 773,
  [781] = 773,
  [782] = 773,
  [783] = 773,
  [784] = 773,
  [785] = 773,
  [786] = 786,
  [787] = 787,
  [788] = 788,
  [789] = 789,
  [790] = 790,
  [791] = 789,
  [792] = 792,
  [793] = 793,
  [794] = 794,
  [795] = 795,
  [796] = 792,
  [797] = 787,
  [798] = 798,
  [799] = 799,
  [800] = 800,
  [801] = 790,
  [802] = 802,
  [803] = 803,
  [804] = 804,
  [805] = 805,
  [806] = 806,
  [807] = 807,
  [808] = 808,
  [809] = 809,
  [810] = 810,
  [811] = 811,
  [812] = 812,
  [813] = 776,
  [814] = 814,
  [815] = 815,
  [816] = 816,
  [817] = 812,
  [818] = 818,
  [819] = 819,
  [820] = 820,
  [821] = 821,
  [822] = 822,
  [823] = 128,
  [824] = 778,
  [825] = 825,
  [826] = 133,
  [827] = 132,
  [828] = 777,
  [829] = 129,
  [830] = 830,
  [831] = 821,
  [832] = 815,
  [833] = 833,
  [834] = 834,
  [835] = 131,
  [836] = 836,
  [837] = 837,
  [838] = 838,
  [839] = 130,
  [840] = 840,
  [841] = 841,
  [842] = 842,
  [843] = 843,
  [844] = 844,
  [845] = 845,
  [846] = 840,
  [847] = 847,
  [848] = 843,
  [849] = 849,
  [850] = 843,
  [851] = 851,
  [852] = 852,
  [853] = 853,
  [854] = 854,
  [855] = 855,
  [856] = 843,
  [857] = 842,
  [858] = 844,
  [859] = 847,
  [860] = 849,
  [861] = 842,
  [862] = 840,
  [863] = 843,
  [864] = 840,
  [865] = 842,
  [866] = 844,
  [867] = 840,
  [868] = 868,
  [869] = 847,
  [870] = 868,
  [871] = 841,
  [872] = 842,
  [873] = 844,
  [874] = 844,
  [875] = 842,
  [876] = 840,
  [877] = 877,
  [878] = 847,
  [879] = 841,
  [880] = 841,
  [881] = 855,
  [882] = 882,
  [883] = 841,
  [884] = 847,
  [885] = 840,
  [886] = 844,
  [887] = 842,
  [888] = 841,
  [889] = 843,
  [890] = 890,
  [891] = 842,
  [892] = 840,
  [893] = 847,
  [894] = 894,
  [895] = 844,
  [896] = 841,
  [897] = 853,
  [898] = 776,
  [899] = 840,
  [900] = 842,
  [901] = 847,
  [902] = 844,
  [903] = 842,
  [904] = 904,
  [905] = 851,
  [906] = 906,
  [907] = 840,
  [908] = 847,
  [909] = 909,
  [910] = 830,
  [911] = 911,
  [912] = 912,
  [913] = 913,
  [914] = 743,
  [915] = 915,
  [916] = 916,
  [917] = 917,
  [918] = 918,
  [919] = 816,
  [920] = 920,
  [921] = 921,
  [922] = 743,
  [923] = 793,
  [924] = 924,
  [925] = 925,
  [926] = 810,
  [927] = 927,
  [928] = 744,
  [929] = 929,
  [930] = 930,
  [931] = 931,
  [932] = 744,
  [933] = 933,
  [934] = 934,
  [935] = 935,
  [936] = 936,
  [937] = 937,
  [938] = 938,
  [939] = 743,
  [940] = 915,
  [941] = 941,
  [942] = 942,
  [943] = 917,
  [944] = 944,
  [945] = 918,
  [946] = 918,
  [947] = 947,
  [948] = 948,
  [949] = 917,
  [950] = 950,
  [951] = 951,
  [952] = 952,
  [953] = 953,
  [954] = 937,
  [955] = 955,
  [956] = 956,
  [957] = 957,
  [958] = 933,
  [959] = 935,
  [960] = 960,
  [961] = 938,
  [962] = 962,
  [963] = 915,
  [964] = 917,
  [965] = 918,
  [966] = 966,
  [967] = 967,
  [968] = 968,
  [969] = 807,
  [970] = 970,
  [971] = 971,
  [972] = 130,
  [973] = 973,
  [974] = 974,
  [975] = 938,
  [976] = 976,
  [977] = 977,
  [978] = 978,
  [979] = 933,
  [980] = 129,
  [981] = 935,
  [982] = 982,
  [983] = 746,
  [984] = 984,
  [985] = 131,
  [986] = 986,
  [987] = 987,
  [988] = 933,
  [989] = 132,
  [990] = 933,
  [991] = 935,
  [992] = 128,
  [993] = 133,
  [994] = 994,
  [995] = 938,
  [996] = 996,
  [997] = 997,
  [998] = 951,
  [999] = 915,
  [1000] = 917,
  [1001] = 918,
  [1002] = 1002,
  [1003] = 1003,
  [1004] = 1004,
  [1005] = 1005,
  [1006] = 744,
  [1007] = 937,
  [1008] = 1008,
  [1009] = 1009,
  [1010] = 925,
  [1011] = 1011,
  [1012] = 1012,
  [1013] = 1013,
  [1014] = 1014,
  [1015] = 1015,
  [1016] = 1016,
  [1017] = 1017,
  [1018] = 810,
  [1019] = 1019,
  [1020] = 1020,
  [1021] = 1021,
  [1022] = 746,
  [1023] = 931,
  [1024] = 934,
  [1025] = 942,
  [1026] = 1026,
  [1027] = 936,
  [1028] = 962,
  [1029] = 960,
  [1030] = 918,
  [1031] = 917,
  [1032] = 952,
  [1033] = 793,
  [1034] = 915,
  [1035] = 746,
  [1036] = 1036,
  [1037] = 1037,
  [1038] = 1038,
  [1039] = 938,
  [1040] = 1040,
  [1041] = 935,
  [1042] = 1040,
  [1043] = 1038,
  [1044] = 1036,
  [1045] = 1009,
  [1046] = 987,
  [1047] = 929,
  [1048] = 913,
  [1049] = 933,
  [1050] = 970,
  [1051] = 935,
  [1052] = 951,
  [1053] = 956,
  [1054] = 938,
  [1055] = 819,
  [1056] = 1002,
  [1057] = 1057,
  [1058] = 1037,
  [1059] = 1059,
  [1060] = 911,
  [1061] = 746,
  [1062] = 937,
  [1063] = 1063,
  [1064] = 984,
  [1065] = 1057,
  [1066] = 960,
  [1067] = 962,
  [1068] = 942,
  [1069] = 931,
  [1070] = 951,
  [1071] = 1071,
  [1072] = 1072,
  [1073] = 937,
  [1074] = 982,
  [1075] = 1075,
  [1076] = 743,
  [1077] = 951,
  [1078] = 937,
  [1079] = 918,
  [1080] = 917,
  [1081] = 915,
  [1082] = 1082,
  [1083] = 951,
  [1084] = 938,
  [1085] = 935,
  [1086] = 1086,
  [1087] = 933,
  [1088] = 810,
  [1089] = 1089,
  [1090] = 1090,
  [1091] = 1091,
  [1092] = 744,
  [1093] = 915,
  [1094] = 1094,
  [1095] = 1095,
  [1096] = 1096,
  [1097] = 1097,
  [1098] = 129,
  [1099] = 1099,
  [1100] = 1100,
  [1101] = 132,
  [1102] = 1102,
  [1103] = 1103,
  [1104] = 1104,
  [1105] = 1105,
  [1106] = 1106,
  [1107] = 1107,
  [1108] = 1097,
  [1109] = 1109,
  [1110] = 1110,
  [1111] = 1110,
  [1112] = 894,
  [1113] = 1113,
  [1114] = 1114,
  [1115] = 1115,
  [1116] = 1110,
  [1117] = 1110,
  [1118] = 1104,
  [1119] = 1109,
  [1120] = 810,
  [1121] = 1110,
  [1122] = 1122,
  [1123] = 1123,
  [1124] = 1124,
  [1125] = 1125,
  [1126] = 1110,
  [1127] = 1114,
  [1128] = 1128,
  [1129] = 1129,
  [1130] = 1107,
  [1131] = 746,
  [1132] = 1132,
  [1133] = 129,
  [1134] = 1103,
  [1135] = 1135,
  [1136] = 1136,
  [1137] = 1097,
  [1138] = 1104,
  [1139] = 1139,
  [1140] = 1140,
  [1141] = 1109,
  [1142] = 1140,
  [1143] = 1143,
  [1144] = 1144,
  [1145] = 1103,
  [1146] = 1140,
  [1147] = 128,
  [1148] = 1148,
  [1149] = 1149,
  [1150] = 1097,
  [1151] = 1151,
  [1152] = 1152,
  [1153] = 130,
  [1154] = 133,
  [1155] = 128,
  [1156] = 132,
  [1157] = 131,
  [1158] = 129,
  [1159] = 130,
  [1160] = 1104,
  [1161] = 1109,
  [1162] = 251,
  [1163] = 1163,
  [1164] = 238,
  [1165] = 1165,
  [1166] = 205,
  [1167] = 1167,
  [1168] = 1168,
  [1169] = 1129,
  [1170] = 1170,
  [1171] = 1171,
  [1172] = 1172,
  [1173] = 1173,
  [1174] = 1170,
  [1175] = 1140,
  [1176] = 1176,
  [1177] = 1177,
  [1178] = 1151,
  [1179] = 1179,
  [1180] = 1103,
  [1181] = 1181,
  [1182] = 133,
  [1183] = 1179,
  [1184] = 1184,
  [1185] = 1097,
  [1186] = 1186,
  [1187] = 1187,
  [1188] = 1129,
  [1189] = 1123,
  [1190] = 1163,
  [1191] = 1191,
  [1192] = 1122,
  [1193] = 1193,
  [1194] = 1129,
  [1195] = 1104,
  [1196] = 1109,
  [1197] = 1197,
  [1198] = 1198,
  [1199] = 1199,
  [1200] = 1200,
  [1201] = 1128,
  [1202] = 1106,
  [1203] = 1203,
  [1204] = 1204,
  [1205] = 1205,
  [1206] = 133,
  [1207] = 1163,
  [1208] = 1125,
  [1209] = 743,
  [1210] = 1140,
  [1211] = 128,
  [1212] = 1212,
  [1213] = 1213,
  [1214] = 1214,
  [1215] = 1103,
  [1216] = 1216,
  [1217] = 1129,
  [1218] = 1163,
  [1219] = 1163,
  [1220] = 1097,
  [1221] = 810,
  [1222] = 1222,
  [1223] = 776,
  [1224] = 1216,
  [1225] = 744,
  [1226] = 1136,
  [1227] = 1102,
  [1228] = 1222,
  [1229] = 1229,
  [1230] = 1104,
  [1231] = 1109,
  [1232] = 132,
  [1233] = 1199,
  [1234] = 1234,
  [1235] = 1135,
  [1236] = 1236,
  [1237] = 1163,
  [1238] = 818,
  [1239] = 131,
  [1240] = 825,
  [1241] = 131,
  [1242] = 1181,
  [1243] = 822,
  [1244] = 746,
  [1245] = 1140,
  [1246] = 1140,
  [1247] = 834,
  [1248] = 1113,
  [1249] = 1144,
  [1250] = 1103,
  [1251] = 1167,
  [1252] = 1107,
  [1253] = 130,
  [1254] = 834,
  [1255] = 1097,
  [1256] = 1172,
  [1257] = 906,
  [1258] = 1148,
  [1259] = 1129,
  [1260] = 1149,
  [1261] = 1261,
  [1262] = 1199,
  [1263] = 1176,
  [1264] = 1264,
  [1265] = 1104,
  [1266] = 1109,
  [1267] = 822,
  [1268] = 825,
  [1269] = 1229,
  [1270] = 1165,
  [1271] = 818,
  [1272] = 1272,
  [1273] = 834,
  [1274] = 1229,
  [1275] = 1203,
  [1276] = 1167,
  [1277] = 1129,
  [1278] = 1103,
  [1279] = 1279,
  [1280] = 1204,
  [1281] = 1213,
  [1282] = 1222,
  [1283] = 1115,
  [1284] = 1284,
  [1285] = 743,
  [1286] = 822,
  [1287] = 1103,
  [1288] = 825,
  [1289] = 1289,
  [1290] = 1234,
  [1291] = 1172,
  [1292] = 1103,
  [1293] = 1170,
  [1294] = 744,
  [1295] = 1103,
  [1296] = 1236,
  [1297] = 1179,
  [1298] = 818,
  [1299] = 1099,
  [1300] = 1300,
  [1301] = 1103,
  [1302] = 1103,
  [1303] = 1103,
  [1304] = 1103,
  [1305] = 1163,
  [1306] = 1216,
  [1307] = 1307,
  [1308] = 132,
  [1309] = 131,
  [1310] = 1310,
  [1311] = 1311,
  [1312] = 1312,
  [1313] = 129,
  [1314] = 1314,
  [1315] = 1315,
  [1316] = 128,
  [1317] = 1317,
  [1318] = 1016,
  [1319] = 131,
  [1320] = 1320,
  [1321] = 818,
  [1322] = 130,
  [1323] = 904,
  [1324] = 1324,
  [1325] = 129,
  [1326] = 904,
  [1327] = 1327,
  [1328] = 950,
  [1329] = 1314,
  [1330] = 133,
  [1331] = 1331,
  [1332] = 1332,
  [1333] = 1333,
  [1334] = 1324,
  [1335] = 1016,
  [1336] = 1327,
  [1337] = 1337,
  [1338] = 1324,
  [1339] = 132,
  [1340] = 1314,
  [1341] = 1341,
  [1342] = 1342,
  [1343] = 1343,
  [1344] = 818,
  [1345] = 1345,
  [1346] = 130,
  [1347] = 1324,
  [1348] = 1327,
  [1349] = 1314,
  [1350] = 1350,
  [1351] = 834,
  [1352] = 1352,
  [1353] = 1353,
  [1354] = 1345,
  [1355] = 1355,
  [1356] = 1324,
  [1357] = 1352,
  [1358] = 1314,
  [1359] = 1359,
  [1360] = 1327,
  [1361] = 1361,
  [1362] = 1362,
  [1363] = 1363,
  [1364] = 128,
  [1365] = 1324,
  [1366] = 133,
  [1367] = 1314,
  [1368] = 1368,
  [1369] = 1327,
  [1370] = 825,
  [1371] = 822,
  [1372] = 1372,
  [1373] = 1373,
  [1374] = 834,
  [1375] = 1327,
  [1376] = 1376,
  [1377] = 1312,
  [1378] = 822,
  [1379] = 1310,
  [1380] = 1380,
  [1381] = 1333,
  [1382] = 1372,
  [1383] = 1331,
  [1384] = 825,
  [1385] = 1355,
  [1386] = 1386,
  [1387] = 1311,
  [1388] = 1380,
  [1389] = 1327,
  [1390] = 927,
  [1391] = 1391,
  [1392] = 1307,
  [1393] = 1386,
  [1394] = 1391,
  [1395] = 1376,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(52);
      if (lookahead == '!') ADVANCE(114);
      if (lookahead == '#') ADVANCE(54);
      if (lookahead == '%') ADVANCE(103);
      if (lookahead == '&') ADVANCE(70);
      if (lookahead == '(') ADVANCE(124);
      if (lookahead == ')') ADVANCE(125);
      if (lookahead == '*') ADVANCE(99);
      if (lookahead == '+') ADVANCE(94);
      if (lookahead == ',') ADVANCE(83);
      if (lookahead == '-') ADVANCE(96);
      if (lookahead == '.') ADVANCE(85);
      if (lookahead == '/') ADVANCE(101);
      if (lookahead == '0') ADVANCE(64);
      if (lookahead == ':') ADVANCE(80);
      if (lookahead == ';') ADVANCE(75);
      if (lookahead == '<') ADVANCE(116);
      if (lookahead == '=') ADVANCE(82);
      if (lookahead == '>') ADVANCE(122);
      if (lookahead == '@') ADVANCE(77);
      if (lookahead == '[') ADVANCE(89);
      if (lookahead == '\\') SKIP(48)
      if (lookahead == ']') ADVANCE(90);
      if (lookahead == '^') ADVANCE(107);
      if (lookahead == '{') ADVANCE(86);
      if (lookahead == '|') ADVANCE(104);
      if (lookahead == '}') ADVANCE(87);
      if (lookahead == '~') ADVANCE(115);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(0)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(63);
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(53);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(8)
      END_STATE();
    case 2:
      if (lookahead == '\n') SKIP(8)
      if (lookahead == '\r') SKIP(1)
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(9)
      END_STATE();
    case 4:
      if (lookahead == '\n') SKIP(9)
      if (lookahead == '\r') SKIP(3)
      END_STATE();
    case 5:
      if (lookahead == '\n') ADVANCE(57);
      if (lookahead == '\r') ADVANCE(56);
      if (lookahead == 'U') ADVANCE(58);
      if (lookahead == 'o') ADVANCE(38);
      if (lookahead == 'u') ADVANCE(44);
      if (lookahead == 'x') ADVANCE(42);
      if (lookahead != 0) ADVANCE(55);
      END_STATE();
    case 6:
      if (lookahead == '\n') SKIP(15)
      END_STATE();
    case 7:
      if (lookahead == '\n') SKIP(15)
      if (lookahead == '\r') SKIP(6)
      END_STATE();
    case 8:
      if (lookahead == '!') ADVANCE(20);
      if (lookahead == '#') ADVANCE(54);
      if (lookahead == '%') ADVANCE(103);
      if (lookahead == '&') ADVANCE(70);
      if (lookahead == '(') ADVANCE(124);
      if (lookahead == ')') ADVANCE(125);
      if (lookahead == '*') ADVANCE(99);
      if (lookahead == '+') ADVANCE(94);
      if (lookahead == ',') ADVANCE(83);
      if (lookahead == '-') ADVANCE(95);
      if (lookahead == '.') ADVANCE(84);
      if (lookahead == '/') ADVANCE(101);
      if (lookahead == ':') ADVANCE(79);
      if (lookahead == ';') ADVANCE(75);
      if (lookahead == '<') ADVANCE(116);
      if (lookahead == '=') ADVANCE(82);
      if (lookahead == '>') ADVANCE(122);
      if (lookahead == '@') ADVANCE(76);
      if (lookahead == '[') ADVANCE(89);
      if (lookahead == '\\') SKIP(2)
      if (lookahead == ']') ADVANCE(90);
      if (lookahead == '^') ADVANCE(108);
      if (lookahead == '|') ADVANCE(104);
      if (lookahead == '}') ADVANCE(87);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(8)
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(53);
      END_STATE();
    case 9:
      if (lookahead == '!') ADVANCE(20);
      if (lookahead == '#') ADVANCE(54);
      if (lookahead == '%') ADVANCE(102);
      if (lookahead == '&') ADVANCE(69);
      if (lookahead == '(') ADVANCE(124);
      if (lookahead == '*') ADVANCE(98);
      if (lookahead == '+') ADVANCE(93);
      if (lookahead == '-') ADVANCE(97);
      if (lookahead == '.') ADVANCE(84);
      if (lookahead == '/') ADVANCE(100);
      if (lookahead == ':') ADVANCE(79);
      if (lookahead == '<') ADVANCE(117);
      if (lookahead == '=') ADVANCE(23);
      if (lookahead == '>') ADVANCE(123);
      if (lookahead == '@') ADVANCE(76);
      if (lookahead == '[') ADVANCE(89);
      if (lookahead == '\\') SKIP(4)
      if (lookahead == '^') ADVANCE(106);
      if (lookahead == '|') ADVANCE(105);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(9)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(53);
      END_STATE();
    case 10:
      if (lookahead == '"') ADVANCE(11);
      if (lookahead == '\'') ADVANCE(17);
      if (lookahead == '=') ADVANCE(134);
      END_STATE();
    case 11:
      if (lookahead == '"') ADVANCE(72);
      if (lookahead == ' ' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(11);
      END_STATE();
    case 12:
      if (lookahead == '"') ADVANCE(73);
      if (lookahead == ' ' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(12);
      END_STATE();
    case 13:
      if (lookahead == '"') ADVANCE(12);
      if (lookahead == '\'') ADVANCE(18);
      if (lookahead == '=') ADVANCE(130);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(74);
      END_STATE();
    case 14:
      if (lookahead == '"') ADVANCE(12);
      if (lookahead == '\'') ADVANCE(18);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(74);
      END_STATE();
    case 15:
      if (lookahead == '#') ADVANCE(54);
      if (lookahead == '-') ADVANCE(27);
      if (lookahead == '.') ADVANCE(84);
      if (lookahead == ':') ADVANCE(79);
      if (lookahead == '\\') SKIP(7)
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(15)
      END_STATE();
    case 16:
      if (lookahead == '#') ADVANCE(54);
      if (lookahead == '\\') ADVANCE(5);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(16)
      END_STATE();
    case 17:
      if (lookahead == '\'') ADVANCE(72);
      if (lookahead == ' ' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(17);
      END_STATE();
    case 18:
      if (lookahead == '\'') ADVANCE(73);
      if (lookahead == ' ' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(18);
      END_STATE();
    case 19:
      if (lookahead == '<') ADVANCE(25);
      END_STATE();
    case 20:
      if (lookahead == '=') ADVANCE(120);
      END_STATE();
    case 21:
      if (lookahead == '=') ADVANCE(128);
      END_STATE();
    case 22:
      if (lookahead == '=') ADVANCE(129);
      END_STATE();
    case 23:
      if (lookahead == '=') ADVANCE(119);
      END_STATE();
    case 24:
      if (lookahead == '=') ADVANCE(135);
      END_STATE();
    case 25:
      if (lookahead == '=') ADVANCE(132);
      END_STATE();
    case 26:
      if (lookahead == '=') ADVANCE(131);
      END_STATE();
    case 27:
      if (lookahead == '>') ADVANCE(136);
      END_STATE();
    case 28:
      if (lookahead == '>') ADVANCE(26);
      END_STATE();
    case 29:
      if (lookahead == '_') ADVANCE(33);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(66);
      END_STATE();
    case 30:
      if (lookahead == '_') ADVANCE(34);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(67);
      END_STATE();
    case 31:
      if (lookahead == '_') ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(68);
      END_STATE();
    case 32:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(35);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(60);
      END_STATE();
    case 33:
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(66);
      END_STATE();
    case 34:
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(67);
      END_STATE();
    case 35:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(60);
      END_STATE();
    case 36:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(55);
      END_STATE();
    case 37:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(36);
      END_STATE();
    case 38:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(37);
      END_STATE();
    case 39:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(68);
      END_STATE();
    case 40:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(55);
      END_STATE();
    case 41:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(44);
      END_STATE();
    case 42:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(40);
      END_STATE();
    case 43:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(42);
      END_STATE();
    case 44:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(43);
      END_STATE();
    case 45:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(41);
      END_STATE();
    case 46:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(45);
      END_STATE();
    case 47:
      if (eof) ADVANCE(52);
      if (lookahead == '\n') SKIP(0)
      END_STATE();
    case 48:
      if (eof) ADVANCE(52);
      if (lookahead == '\n') SKIP(0)
      if (lookahead == '\r') SKIP(47)
      END_STATE();
    case 49:
      if (eof) ADVANCE(52);
      if (lookahead == '\n') SKIP(51)
      END_STATE();
    case 50:
      if (eof) ADVANCE(52);
      if (lookahead == '\n') SKIP(51)
      if (lookahead == '\r') SKIP(49)
      END_STATE();
    case 51:
      if (eof) ADVANCE(52);
      if (lookahead == '!') ADVANCE(113);
      if (lookahead == '#') ADVANCE(54);
      if (lookahead == '$') ADVANCE(14);
      if (lookahead == '%') ADVANCE(13);
      if (lookahead == '&') ADVANCE(71);
      if (lookahead == '(') ADVANCE(124);
      if (lookahead == ')') ADVANCE(125);
      if (lookahead == '*') ADVANCE(21);
      if (lookahead == '+') ADVANCE(94);
      if (lookahead == ',') ADVANCE(83);
      if (lookahead == '-') ADVANCE(95);
      if (lookahead == '.') ADVANCE(85);
      if (lookahead == '/') ADVANCE(22);
      if (lookahead == '0') ADVANCE(64);
      if (lookahead == ':') ADVANCE(79);
      if (lookahead == ';') ADVANCE(75);
      if (lookahead == '<') ADVANCE(19);
      if (lookahead == '=') ADVANCE(81);
      if (lookahead == '>') ADVANCE(28);
      if (lookahead == '@') ADVANCE(77);
      if (lookahead == '[') ADVANCE(89);
      if (lookahead == '\\') SKIP(50)
      if (lookahead == ']') ADVANCE(90);
      if (lookahead == '^') ADVANCE(10);
      if (lookahead == '{') ADVANCE(86);
      if (lookahead == '|') ADVANCE(24);
      if (lookahead == '}') ADVANCE(87);
      if (lookahead == '~') ADVANCE(115);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(51)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(63);
      if (('A' <= lookahead && lookahead <= '_') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(53);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(sym__identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(53);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(54);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\n') ADVANCE(57);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\\') ADVANCE(5);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(46);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == '_') ADVANCE(61);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(32);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(59);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == '_') ADVANCE(62);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(60);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(32);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(59);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(sym_float);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(60);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(61);
      if (lookahead == '_') ADVANCE(65);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(32);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(61);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(29);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(30);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(31);
      if (lookahead == '_') ADVANCE(65);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(32);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(61);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(32);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '_') ADVANCE(33);
      if (lookahead == '0' ||
          lookahead == '1') ADVANCE(66);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '_') ADVANCE(34);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(67);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '_') ADVANCE(39);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(68);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(91);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(91);
      if (lookahead == '=') ADVANCE(133);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '=') ADVANCE(133);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(sym_node_path);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(sym_get_node);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(sym_get_node);
      if (('/' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(74);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_AT);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_AT);
      if (lookahead == '"') ADVANCE(11);
      if (lookahead == '\'') ADVANCE(17);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '=') ADVANCE(78);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(119);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(88);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(59);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(sym_pattern_open_ending);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '=') ADVANCE(126);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(127);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(127);
      if (lookahead == '>') ADVANCE(136);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '>') ADVANCE(136);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '=') ADVANCE(128);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '=') ADVANCE(129);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(130);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(135);
      if (lookahead == '|') ADVANCE(92);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(92);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '"') ADVANCE(11);
      if (lookahead == '\'') ADVANCE(17);
      if (lookahead == '=') ADVANCE(134);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(134);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(132);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(131);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(120);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(110);
      if (lookahead == '=') ADVANCE(118);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(109);
      if (lookahead == '=') ADVANCE(118);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(121);
      if (lookahead == '>') ADVANCE(112);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(121);
      if (lookahead == '>') ADVANCE(111);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == '\\') SKIP(1)
      if (lookahead == '_') ADVANCE(2);
      if (lookahead == 'a') ADVANCE(3);
      if (lookahead == 'b') ADVANCE(4);
      if (lookahead == 'c') ADVANCE(5);
      if (lookahead == 'e') ADVANCE(6);
      if (lookahead == 'f') ADVANCE(7);
      if (lookahead == 'g') ADVANCE(8);
      if (lookahead == 'i') ADVANCE(9);
      if (lookahead == 'm') ADVANCE(10);
      if (lookahead == 'n') ADVANCE(11);
      if (lookahead == 'o') ADVANCE(12);
      if (lookahead == 'p') ADVANCE(13);
      if (lookahead == 'r') ADVANCE(14);
      if (lookahead == 's') ADVANCE(15);
      if (lookahead == 't') ADVANCE(16);
      if (lookahead == 'v') ADVANCE(17);
      if (lookahead == 'w') ADVANCE(18);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ' ||
          lookahead == 8203 ||
          lookahead == 8288 ||
          lookahead == 65279) SKIP(0)
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(0)
      if (lookahead == '\r') SKIP(19)
      END_STATE();
    case 2:
      ACCEPT_TOKEN(sym_underscore);
      if (lookahead == 'i') ADVANCE(20);
      END_STATE();
    case 3:
      if (lookahead == 'n') ADVANCE(21);
      if (lookahead == 's') ADVANCE(22);
      if (lookahead == 'w') ADVANCE(23);
      END_STATE();
    case 4:
      if (lookahead == 'r') ADVANCE(24);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(25);
      if (lookahead == 'o') ADVANCE(26);
      END_STATE();
    case 6:
      if (lookahead == 'l') ADVANCE(27);
      if (lookahead == 'n') ADVANCE(28);
      if (lookahead == 'x') ADVANCE(29);
      END_STATE();
    case 7:
      if (lookahead == 'a') ADVANCE(30);
      if (lookahead == 'o') ADVANCE(31);
      if (lookahead == 'u') ADVANCE(32);
      END_STATE();
    case 8:
      if (lookahead == 'e') ADVANCE(33);
      END_STATE();
    case 9:
      if (lookahead == 'f') ADVANCE(34);
      if (lookahead == 'n') ADVANCE(35);
      if (lookahead == 's') ADVANCE(36);
      END_STATE();
    case 10:
      if (lookahead == 'a') ADVANCE(37);
      END_STATE();
    case 11:
      if (lookahead == 'o') ADVANCE(38);
      if (lookahead == 'u') ADVANCE(39);
      END_STATE();
    case 12:
      if (lookahead == 'n') ADVANCE(40);
      if (lookahead == 'r') ADVANCE(41);
      END_STATE();
    case 13:
      if (lookahead == 'a') ADVANCE(42);
      if (lookahead == 'u') ADVANCE(43);
      END_STATE();
    case 14:
      if (lookahead == 'e') ADVANCE(44);
      END_STATE();
    case 15:
      if (lookahead == 'e') ADVANCE(45);
      if (lookahead == 'i') ADVANCE(46);
      if (lookahead == 't') ADVANCE(47);
      END_STATE();
    case 16:
      if (lookahead == 'o') ADVANCE(48);
      if (lookahead == 'r') ADVANCE(49);
      END_STATE();
    case 17:
      if (lookahead == 'a') ADVANCE(50);
      END_STATE();
    case 18:
      if (lookahead == 'h') ADVANCE(51);
      END_STATE();
    case 19:
      if (lookahead == '\n') SKIP(0)
      END_STATE();
    case 20:
      if (lookahead == 'n') ADVANCE(52);
      END_STATE();
    case 21:
      if (lookahead == 'd') ADVANCE(53);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(anon_sym_as);
      END_STATE();
    case 23:
      if (lookahead == 'a') ADVANCE(54);
      END_STATE();
    case 24:
      if (lookahead == 'e') ADVANCE(55);
      END_STATE();
    case 25:
      if (lookahead == 'a') ADVANCE(56);
      END_STATE();
    case 26:
      if (lookahead == 'n') ADVANCE(57);
      END_STATE();
    case 27:
      if (lookahead == 'i') ADVANCE(58);
      if (lookahead == 's') ADVANCE(59);
      END_STATE();
    case 28:
      if (lookahead == 'u') ADVANCE(60);
      END_STATE();
    case 29:
      if (lookahead == 'p') ADVANCE(61);
      if (lookahead == 't') ADVANCE(62);
      END_STATE();
    case 30:
      if (lookahead == 'l') ADVANCE(63);
      END_STATE();
    case 31:
      if (lookahead == 'r') ADVANCE(64);
      END_STATE();
    case 32:
      if (lookahead == 'n') ADVANCE(65);
      END_STATE();
    case 33:
      if (lookahead == 't') ADVANCE(66);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_in);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_is);
      END_STATE();
    case 37:
      if (lookahead == 's') ADVANCE(67);
      if (lookahead == 't') ADVANCE(68);
      END_STATE();
    case 38:
      if (lookahead == 't') ADVANCE(69);
      END_STATE();
    case 39:
      if (lookahead == 'l') ADVANCE(70);
      END_STATE();
    case 40:
      if (lookahead == 'r') ADVANCE(71);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(anon_sym_or);
      END_STATE();
    case 42:
      if (lookahead == 's') ADVANCE(72);
      END_STATE();
    case 43:
      if (lookahead == 'p') ADVANCE(73);
      END_STATE();
    case 44:
      if (lookahead == 'm') ADVANCE(74);
      if (lookahead == 't') ADVANCE(75);
      END_STATE();
    case 45:
      if (lookahead == 't') ADVANCE(76);
      END_STATE();
    case 46:
      if (lookahead == 'g') ADVANCE(77);
      END_STATE();
    case 47:
      if (lookahead == 'a') ADVANCE(78);
      END_STATE();
    case 48:
      if (lookahead == 'o') ADVANCE(79);
      END_STATE();
    case 49:
      if (lookahead == 'u') ADVANCE(80);
      END_STATE();
    case 50:
      if (lookahead == 'r') ADVANCE(81);
      END_STATE();
    case 51:
      if (lookahead == 'i') ADVANCE(82);
      END_STATE();
    case 52:
      if (lookahead == 'i') ADVANCE(83);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 54:
      if (lookahead == 'i') ADVANCE(84);
      END_STATE();
    case 55:
      if (lookahead == 'a') ADVANCE(85);
      END_STATE();
    case 56:
      if (lookahead == 's') ADVANCE(86);
      END_STATE();
    case 57:
      if (lookahead == 's') ADVANCE(87);
      if (lookahead == 't') ADVANCE(88);
      END_STATE();
    case 58:
      if (lookahead == 'f') ADVANCE(89);
      END_STATE();
    case 59:
      if (lookahead == 'e') ADVANCE(90);
      END_STATE();
    case 60:
      if (lookahead == 'm') ADVANCE(91);
      END_STATE();
    case 61:
      if (lookahead == 'o') ADVANCE(92);
      END_STATE();
    case 62:
      if (lookahead == 'e') ADVANCE(93);
      END_STATE();
    case 63:
      if (lookahead == 's') ADVANCE(94);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 65:
      if (lookahead == 'c') ADVANCE(95);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_get);
      END_STATE();
    case 67:
      if (lookahead == 't') ADVANCE(96);
      END_STATE();
    case 68:
      if (lookahead == 'c') ADVANCE(97);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_not);
      END_STATE();
    case 70:
      if (lookahead == 'l') ADVANCE(98);
      END_STATE();
    case 71:
      if (lookahead == 'e') ADVANCE(99);
      END_STATE();
    case 72:
      if (lookahead == 's') ADVANCE(100);
      END_STATE();
    case 73:
      if (lookahead == 'p') ADVANCE(101);
      END_STATE();
    case 74:
      if (lookahead == 'o') ADVANCE(102);
      END_STATE();
    case 75:
      if (lookahead == 'u') ADVANCE(103);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_set);
      if (lookahead == 'g') ADVANCE(104);
      END_STATE();
    case 77:
      if (lookahead == 'n') ADVANCE(105);
      END_STATE();
    case 78:
      if (lookahead == 't') ADVANCE(106);
      END_STATE();
    case 79:
      if (lookahead == 'l') ADVANCE(107);
      END_STATE();
    case 80:
      if (lookahead == 'e') ADVANCE(108);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_var);
      END_STATE();
    case 82:
      if (lookahead == 'l') ADVANCE(109);
      END_STATE();
    case 83:
      if (lookahead == 't') ADVANCE(110);
      END_STATE();
    case 84:
      if (lookahead == 't') ADVANCE(111);
      END_STATE();
    case 85:
      if (lookahead == 'k') ADVANCE(112);
      END_STATE();
    case 86:
      if (lookahead == 's') ADVANCE(113);
      END_STATE();
    case 87:
      if (lookahead == 't') ADVANCE(114);
      END_STATE();
    case 88:
      if (lookahead == 'i') ADVANCE(115);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_elif);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 92:
      if (lookahead == 'r') ADVANCE(116);
      END_STATE();
    case 93:
      if (lookahead == 'n') ADVANCE(117);
      END_STATE();
    case 94:
      if (lookahead == 'e') ADVANCE(118);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_func);
      END_STATE();
    case 96:
      if (lookahead == 'e') ADVANCE(119);
      END_STATE();
    case 97:
      if (lookahead == 'h') ADVANCE(120);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(sym_null);
      END_STATE();
    case 99:
      if (lookahead == 'a') ADVANCE(121);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_pass);
      END_STATE();
    case 101:
      if (lookahead == 'e') ADVANCE(122);
      END_STATE();
    case 102:
      if (lookahead == 't') ADVANCE(123);
      END_STATE();
    case 103:
      if (lookahead == 'r') ADVANCE(124);
      END_STATE();
    case 104:
      if (lookahead == 'e') ADVANCE(125);
      END_STATE();
    case 105:
      if (lookahead == 'a') ADVANCE(126);
      END_STATE();
    case 106:
      if (lookahead == 'i') ADVANCE(127);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(sym_tool_statement);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(sym_true);
      END_STATE();
    case 109:
      if (lookahead == 'e') ADVANCE(128);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym__init);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_await);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_break);
      if (lookahead == 'p') ADVANCE(129);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_class);
      if (lookahead == '_') ADVANCE(130);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 115:
      if (lookahead == 'n') ADVANCE(131);
      END_STATE();
    case 116:
      if (lookahead == 't') ADVANCE(132);
      END_STATE();
    case 117:
      if (lookahead == 'd') ADVANCE(133);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(sym_false);
      END_STATE();
    case 119:
      if (lookahead == 'r') ADVANCE(134);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_match);
      END_STATE();
    case 121:
      if (lookahead == 'd') ADVANCE(135);
      END_STATE();
    case 122:
      if (lookahead == 't') ADVANCE(136);
      END_STATE();
    case 123:
      if (lookahead == 'e') ADVANCE(137);
      END_STATE();
    case 124:
      if (lookahead == 'n') ADVANCE(138);
      END_STATE();
    case 125:
      if (lookahead == 't') ADVANCE(139);
      END_STATE();
    case 126:
      if (lookahead == 'l') ADVANCE(140);
      END_STATE();
    case 127:
      if (lookahead == 'c') ADVANCE(141);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 129:
      if (lookahead == 'o') ADVANCE(142);
      END_STATE();
    case 130:
      if (lookahead == 'n') ADVANCE(143);
      END_STATE();
    case 131:
      if (lookahead == 'u') ADVANCE(144);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_export);
      END_STATE();
    case 133:
      if (lookahead == 's') ADVANCE(145);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_master);
      if (lookahead == 's') ADVANCE(146);
      END_STATE();
    case 135:
      if (lookahead == 'y') ADVANCE(147);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_puppet);
      if (lookahead == 's') ADVANCE(148);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_remote);
      if (lookahead == 's') ADVANCE(149);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_setget);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_signal);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(sym_static_keyword);
      END_STATE();
    case 142:
      if (lookahead == 'i') ADVANCE(150);
      END_STATE();
    case 143:
      if (lookahead == 'a') ADVANCE(151);
      END_STATE();
    case 144:
      if (lookahead == 'e') ADVANCE(152);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_extends);
      END_STATE();
    case 146:
      if (lookahead == 'y') ADVANCE(153);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_onready);
      END_STATE();
    case 148:
      if (lookahead == 'y') ADVANCE(154);
      END_STATE();
    case 149:
      if (lookahead == 'y') ADVANCE(155);
      END_STATE();
    case 150:
      if (lookahead == 'n') ADVANCE(156);
      END_STATE();
    case 151:
      if (lookahead == 'm') ADVANCE(157);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 153:
      if (lookahead == 'n') ADVANCE(158);
      END_STATE();
    case 154:
      if (lookahead == 'n') ADVANCE(159);
      END_STATE();
    case 155:
      if (lookahead == 'n') ADVANCE(160);
      END_STATE();
    case 156:
      if (lookahead == 't') ADVANCE(161);
      END_STATE();
    case 157:
      if (lookahead == 'e') ADVANCE(162);
      END_STATE();
    case 158:
      if (lookahead == 'c') ADVANCE(163);
      END_STATE();
    case 159:
      if (lookahead == 'c') ADVANCE(164);
      END_STATE();
    case 160:
      if (lookahead == 'c') ADVANCE(165);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(sym_breakpoint_statement);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(anon_sym_class_name);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_mastersync);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_puppetsync);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(anon_sym_remotesync);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 51, .external_lex_state = 2},
  [2] = {.lex_state = 51, .external_lex_state = 3},
  [3] = {.lex_state = 51, .external_lex_state = 3},
  [4] = {.lex_state = 51, .external_lex_state = 3},
  [5] = {.lex_state = 51, .external_lex_state = 3},
  [6] = {.lex_state = 51, .external_lex_state = 3},
  [7] = {.lex_state = 51, .external_lex_state = 3},
  [8] = {.lex_state = 51, .external_lex_state = 3},
  [9] = {.lex_state = 51, .external_lex_state = 3},
  [10] = {.lex_state = 51, .external_lex_state = 3},
  [11] = {.lex_state = 51, .external_lex_state = 3},
  [12] = {.lex_state = 51, .external_lex_state = 3},
  [13] = {.lex_state = 51, .external_lex_state = 3},
  [14] = {.lex_state = 51, .external_lex_state = 3},
  [15] = {.lex_state = 51, .external_lex_state = 3},
  [16] = {.lex_state = 51, .external_lex_state = 3},
  [17] = {.lex_state = 51, .external_lex_state = 3},
  [18] = {.lex_state = 51, .external_lex_state = 3},
  [19] = {.lex_state = 51, .external_lex_state = 3},
  [20] = {.lex_state = 51, .external_lex_state = 3},
  [21] = {.lex_state = 51, .external_lex_state = 3},
  [22] = {.lex_state = 51, .external_lex_state = 3},
  [23] = {.lex_state = 51, .external_lex_state = 2},
  [24] = {.lex_state = 51, .external_lex_state = 2},
  [25] = {.lex_state = 51, .external_lex_state = 4},
  [26] = {.lex_state = 51, .external_lex_state = 4},
  [27] = {.lex_state = 51, .external_lex_state = 4},
  [28] = {.lex_state = 51, .external_lex_state = 4},
  [29] = {.lex_state = 51, .external_lex_state = 4},
  [30] = {.lex_state = 51, .external_lex_state = 4},
  [31] = {.lex_state = 51, .external_lex_state = 4},
  [32] = {.lex_state = 51, .external_lex_state = 4},
  [33] = {.lex_state = 51, .external_lex_state = 4},
  [34] = {.lex_state = 51, .external_lex_state = 4},
  [35] = {.lex_state = 51, .external_lex_state = 4},
  [36] = {.lex_state = 51, .external_lex_state = 4},
  [37] = {.lex_state = 51, .external_lex_state = 4},
  [38] = {.lex_state = 51, .external_lex_state = 4},
  [39] = {.lex_state = 51, .external_lex_state = 4},
  [40] = {.lex_state = 51, .external_lex_state = 4},
  [41] = {.lex_state = 51, .external_lex_state = 4},
  [42] = {.lex_state = 51, .external_lex_state = 4},
  [43] = {.lex_state = 51, .external_lex_state = 4},
  [44] = {.lex_state = 51, .external_lex_state = 4},
  [45] = {.lex_state = 51, .external_lex_state = 4},
  [46] = {.lex_state = 51, .external_lex_state = 4},
  [47] = {.lex_state = 51, .external_lex_state = 4},
  [48] = {.lex_state = 51, .external_lex_state = 4},
  [49] = {.lex_state = 51, .external_lex_state = 4},
  [50] = {.lex_state = 51, .external_lex_state = 4},
  [51] = {.lex_state = 51, .external_lex_state = 4},
  [52] = {.lex_state = 51, .external_lex_state = 4},
  [53] = {.lex_state = 51, .external_lex_state = 4},
  [54] = {.lex_state = 51, .external_lex_state = 4},
  [55] = {.lex_state = 51, .external_lex_state = 4},
  [56] = {.lex_state = 51, .external_lex_state = 4},
  [57] = {.lex_state = 51, .external_lex_state = 4},
  [58] = {.lex_state = 51, .external_lex_state = 4},
  [59] = {.lex_state = 51, .external_lex_state = 4},
  [60] = {.lex_state = 51, .external_lex_state = 4},
  [61] = {.lex_state = 51, .external_lex_state = 4},
  [62] = {.lex_state = 51, .external_lex_state = 4},
  [63] = {.lex_state = 51, .external_lex_state = 4},
  [64] = {.lex_state = 51, .external_lex_state = 4},
  [65] = {.lex_state = 51, .external_lex_state = 4},
  [66] = {.lex_state = 51, .external_lex_state = 4},
  [67] = {.lex_state = 51, .external_lex_state = 4},
  [68] = {.lex_state = 51, .external_lex_state = 4},
  [69] = {.lex_state = 51, .external_lex_state = 4},
  [70] = {.lex_state = 51, .external_lex_state = 4},
  [71] = {.lex_state = 51, .external_lex_state = 4},
  [72] = {.lex_state = 51, .external_lex_state = 4},
  [73] = {.lex_state = 51, .external_lex_state = 4},
  [74] = {.lex_state = 51, .external_lex_state = 4},
  [75] = {.lex_state = 51, .external_lex_state = 4},
  [76] = {.lex_state = 51, .external_lex_state = 4},
  [77] = {.lex_state = 51, .external_lex_state = 4},
  [78] = {.lex_state = 51, .external_lex_state = 4},
  [79] = {.lex_state = 51, .external_lex_state = 4},
  [80] = {.lex_state = 51, .external_lex_state = 4},
  [81] = {.lex_state = 51, .external_lex_state = 4},
  [82] = {.lex_state = 51, .external_lex_state = 4},
  [83] = {.lex_state = 51, .external_lex_state = 4},
  [84] = {.lex_state = 51, .external_lex_state = 4},
  [85] = {.lex_state = 51, .external_lex_state = 4},
  [86] = {.lex_state = 51, .external_lex_state = 4},
  [87] = {.lex_state = 51, .external_lex_state = 4},
  [88] = {.lex_state = 51, .external_lex_state = 4},
  [89] = {.lex_state = 51, .external_lex_state = 4},
  [90] = {.lex_state = 51, .external_lex_state = 4},
  [91] = {.lex_state = 51, .external_lex_state = 4},
  [92] = {.lex_state = 51, .external_lex_state = 4},
  [93] = {.lex_state = 51, .external_lex_state = 4},
  [94] = {.lex_state = 51, .external_lex_state = 4},
  [95] = {.lex_state = 51, .external_lex_state = 4},
  [96] = {.lex_state = 51, .external_lex_state = 4},
  [97] = {.lex_state = 51, .external_lex_state = 4},
  [98] = {.lex_state = 51, .external_lex_state = 4},
  [99] = {.lex_state = 51, .external_lex_state = 5},
  [100] = {.lex_state = 51, .external_lex_state = 5},
  [101] = {.lex_state = 51, .external_lex_state = 5},
  [102] = {.lex_state = 51, .external_lex_state = 5},
  [103] = {.lex_state = 51, .external_lex_state = 5},
  [104] = {.lex_state = 51, .external_lex_state = 5},
  [105] = {.lex_state = 51, .external_lex_state = 5},
  [106] = {.lex_state = 51, .external_lex_state = 5},
  [107] = {.lex_state = 51, .external_lex_state = 5},
  [108] = {.lex_state = 51, .external_lex_state = 5},
  [109] = {.lex_state = 51, .external_lex_state = 5},
  [110] = {.lex_state = 51, .external_lex_state = 5},
  [111] = {.lex_state = 51, .external_lex_state = 5},
  [112] = {.lex_state = 51, .external_lex_state = 5},
  [113] = {.lex_state = 51, .external_lex_state = 5},
  [114] = {.lex_state = 51, .external_lex_state = 5},
  [115] = {.lex_state = 51, .external_lex_state = 5},
  [116] = {.lex_state = 51, .external_lex_state = 5},
  [117] = {.lex_state = 51, .external_lex_state = 5},
  [118] = {.lex_state = 51, .external_lex_state = 5},
  [119] = {.lex_state = 51, .external_lex_state = 2},
  [120] = {.lex_state = 51, .external_lex_state = 3},
  [121] = {.lex_state = 51, .external_lex_state = 3},
  [122] = {.lex_state = 51, .external_lex_state = 3},
  [123] = {.lex_state = 51, .external_lex_state = 2},
  [124] = {.lex_state = 51, .external_lex_state = 2},
  [125] = {.lex_state = 51, .external_lex_state = 2},
  [126] = {.lex_state = 51, .external_lex_state = 3},
  [127] = {.lex_state = 51, .external_lex_state = 3},
  [128] = {.lex_state = 51, .external_lex_state = 3},
  [129] = {.lex_state = 51, .external_lex_state = 3},
  [130] = {.lex_state = 51, .external_lex_state = 3},
  [131] = {.lex_state = 51, .external_lex_state = 3},
  [132] = {.lex_state = 51, .external_lex_state = 3},
  [133] = {.lex_state = 51, .external_lex_state = 3},
  [134] = {.lex_state = 51, .external_lex_state = 2},
  [135] = {.lex_state = 51, .external_lex_state = 2},
  [136] = {.lex_state = 51, .external_lex_state = 2},
  [137] = {.lex_state = 51, .external_lex_state = 2},
  [138] = {.lex_state = 51, .external_lex_state = 2},
  [139] = {.lex_state = 51, .external_lex_state = 2},
  [140] = {.lex_state = 51, .external_lex_state = 2},
  [141] = {.lex_state = 51, .external_lex_state = 2},
  [142] = {.lex_state = 51, .external_lex_state = 3},
  [143] = {.lex_state = 51, .external_lex_state = 3},
  [144] = {.lex_state = 51, .external_lex_state = 3},
  [145] = {.lex_state = 51, .external_lex_state = 3},
  [146] = {.lex_state = 51, .external_lex_state = 3},
  [147] = {.lex_state = 51, .external_lex_state = 3},
  [148] = {.lex_state = 51, .external_lex_state = 3},
  [149] = {.lex_state = 51, .external_lex_state = 3},
  [150] = {.lex_state = 51, .external_lex_state = 3},
  [151] = {.lex_state = 51, .external_lex_state = 3},
  [152] = {.lex_state = 51, .external_lex_state = 3},
  [153] = {.lex_state = 51, .external_lex_state = 3},
  [154] = {.lex_state = 51, .external_lex_state = 3},
  [155] = {.lex_state = 51, .external_lex_state = 3},
  [156] = {.lex_state = 51, .external_lex_state = 3},
  [157] = {.lex_state = 51, .external_lex_state = 3},
  [158] = {.lex_state = 51, .external_lex_state = 3},
  [159] = {.lex_state = 51, .external_lex_state = 3},
  [160] = {.lex_state = 51, .external_lex_state = 3},
  [161] = {.lex_state = 51, .external_lex_state = 3},
  [162] = {.lex_state = 51, .external_lex_state = 3},
  [163] = {.lex_state = 51, .external_lex_state = 3},
  [164] = {.lex_state = 51, .external_lex_state = 3},
  [165] = {.lex_state = 51, .external_lex_state = 3},
  [166] = {.lex_state = 51, .external_lex_state = 3},
  [167] = {.lex_state = 51, .external_lex_state = 3},
  [168] = {.lex_state = 51, .external_lex_state = 3},
  [169] = {.lex_state = 51, .external_lex_state = 3},
  [170] = {.lex_state = 51, .external_lex_state = 3},
  [171] = {.lex_state = 51, .external_lex_state = 3},
  [172] = {.lex_state = 51, .external_lex_state = 2},
  [173] = {.lex_state = 51, .external_lex_state = 2},
  [174] = {.lex_state = 51, .external_lex_state = 2},
  [175] = {.lex_state = 51, .external_lex_state = 2},
  [176] = {.lex_state = 51, .external_lex_state = 2},
  [177] = {.lex_state = 51, .external_lex_state = 2},
  [178] = {.lex_state = 51, .external_lex_state = 2},
  [179] = {.lex_state = 51, .external_lex_state = 2},
  [180] = {.lex_state = 51, .external_lex_state = 2},
  [181] = {.lex_state = 51, .external_lex_state = 2},
  [182] = {.lex_state = 51, .external_lex_state = 2},
  [183] = {.lex_state = 51, .external_lex_state = 2},
  [184] = {.lex_state = 51, .external_lex_state = 2},
  [185] = {.lex_state = 51, .external_lex_state = 2},
  [186] = {.lex_state = 51, .external_lex_state = 2},
  [187] = {.lex_state = 51, .external_lex_state = 2},
  [188] = {.lex_state = 51, .external_lex_state = 2},
  [189] = {.lex_state = 51, .external_lex_state = 2},
  [190] = {.lex_state = 51, .external_lex_state = 2},
  [191] = {.lex_state = 51, .external_lex_state = 2},
  [192] = {.lex_state = 51, .external_lex_state = 2},
  [193] = {.lex_state = 51, .external_lex_state = 2},
  [194] = {.lex_state = 51, .external_lex_state = 2},
  [195] = {.lex_state = 51, .external_lex_state = 2},
  [196] = {.lex_state = 51, .external_lex_state = 2},
  [197] = {.lex_state = 51, .external_lex_state = 2},
  [198] = {.lex_state = 51, .external_lex_state = 2},
  [199] = {.lex_state = 51, .external_lex_state = 2},
  [200] = {.lex_state = 51, .external_lex_state = 2},
  [201] = {.lex_state = 51, .external_lex_state = 2},
  [202] = {.lex_state = 8, .external_lex_state = 6},
  [203] = {.lex_state = 8, .external_lex_state = 6},
  [204] = {.lex_state = 8, .external_lex_state = 6},
  [205] = {.lex_state = 8, .external_lex_state = 6},
  [206] = {.lex_state = 8, .external_lex_state = 6},
  [207] = {.lex_state = 8, .external_lex_state = 6},
  [208] = {.lex_state = 8, .external_lex_state = 6},
  [209] = {.lex_state = 8, .external_lex_state = 6},
  [210] = {.lex_state = 8, .external_lex_state = 6},
  [211] = {.lex_state = 51, .external_lex_state = 5},
  [212] = {.lex_state = 8, .external_lex_state = 6},
  [213] = {.lex_state = 8, .external_lex_state = 6},
  [214] = {.lex_state = 8, .external_lex_state = 6},
  [215] = {.lex_state = 8, .external_lex_state = 6},
  [216] = {.lex_state = 8, .external_lex_state = 6},
  [217] = {.lex_state = 8, .external_lex_state = 6},
  [218] = {.lex_state = 8, .external_lex_state = 6},
  [219] = {.lex_state = 8, .external_lex_state = 6},
  [220] = {.lex_state = 8, .external_lex_state = 6},
  [221] = {.lex_state = 8, .external_lex_state = 6},
  [222] = {.lex_state = 8, .external_lex_state = 6},
  [223] = {.lex_state = 8, .external_lex_state = 6},
  [224] = {.lex_state = 8, .external_lex_state = 6},
  [225] = {.lex_state = 51, .external_lex_state = 7},
  [226] = {.lex_state = 51, .external_lex_state = 7},
  [227] = {.lex_state = 51, .external_lex_state = 7},
  [228] = {.lex_state = 8, .external_lex_state = 6},
  [229] = {.lex_state = 51, .external_lex_state = 7},
  [230] = {.lex_state = 8, .external_lex_state = 6},
  [231] = {.lex_state = 8, .external_lex_state = 6},
  [232] = {.lex_state = 8, .external_lex_state = 6},
  [233] = {.lex_state = 8, .external_lex_state = 6},
  [234] = {.lex_state = 8, .external_lex_state = 6},
  [235] = {.lex_state = 51, .external_lex_state = 7},
  [236] = {.lex_state = 51, .external_lex_state = 7},
  [237] = {.lex_state = 8, .external_lex_state = 6},
  [238] = {.lex_state = 8, .external_lex_state = 6},
  [239] = {.lex_state = 8, .external_lex_state = 6},
  [240] = {.lex_state = 8, .external_lex_state = 6},
  [241] = {.lex_state = 51, .external_lex_state = 7},
  [242] = {.lex_state = 51, .external_lex_state = 7},
  [243] = {.lex_state = 51, .external_lex_state = 7},
  [244] = {.lex_state = 51, .external_lex_state = 7},
  [245] = {.lex_state = 8, .external_lex_state = 6},
  [246] = {.lex_state = 51, .external_lex_state = 7},
  [247] = {.lex_state = 8, .external_lex_state = 6},
  [248] = {.lex_state = 8, .external_lex_state = 6},
  [249] = {.lex_state = 8, .external_lex_state = 6},
  [250] = {.lex_state = 8, .external_lex_state = 6},
  [251] = {.lex_state = 8, .external_lex_state = 6},
  [252] = {.lex_state = 51, .external_lex_state = 7},
  [253] = {.lex_state = 51, .external_lex_state = 7},
  [254] = {.lex_state = 8, .external_lex_state = 6},
  [255] = {.lex_state = 51, .external_lex_state = 7},
  [256] = {.lex_state = 8, .external_lex_state = 6},
  [257] = {.lex_state = 51, .external_lex_state = 7},
  [258] = {.lex_state = 8, .external_lex_state = 6},
  [259] = {.lex_state = 51, .external_lex_state = 7},
  [260] = {.lex_state = 51, .external_lex_state = 7},
  [261] = {.lex_state = 51, .external_lex_state = 7},
  [262] = {.lex_state = 8, .external_lex_state = 6},
  [263] = {.lex_state = 51, .external_lex_state = 7},
  [264] = {.lex_state = 8, .external_lex_state = 6},
  [265] = {.lex_state = 51, .external_lex_state = 7},
  [266] = {.lex_state = 51, .external_lex_state = 7},
  [267] = {.lex_state = 51, .external_lex_state = 8},
  [268] = {.lex_state = 51, .external_lex_state = 9},
  [269] = {.lex_state = 51, .external_lex_state = 8},
  [270] = {.lex_state = 51, .external_lex_state = 8},
  [271] = {.lex_state = 51, .external_lex_state = 9},
  [272] = {.lex_state = 51, .external_lex_state = 8},
  [273] = {.lex_state = 51, .external_lex_state = 8},
  [274] = {.lex_state = 51, .external_lex_state = 9},
  [275] = {.lex_state = 51, .external_lex_state = 2},
  [276] = {.lex_state = 51, .external_lex_state = 9},
  [277] = {.lex_state = 51, .external_lex_state = 9},
  [278] = {.lex_state = 51, .external_lex_state = 8},
  [279] = {.lex_state = 51, .external_lex_state = 8},
  [280] = {.lex_state = 51, .external_lex_state = 8},
  [281] = {.lex_state = 51, .external_lex_state = 8},
  [282] = {.lex_state = 51, .external_lex_state = 9},
  [283] = {.lex_state = 51, .external_lex_state = 8},
  [284] = {.lex_state = 51, .external_lex_state = 8},
  [285] = {.lex_state = 51, .external_lex_state = 8},
  [286] = {.lex_state = 51, .external_lex_state = 9},
  [287] = {.lex_state = 51, .external_lex_state = 8},
  [288] = {.lex_state = 51, .external_lex_state = 8},
  [289] = {.lex_state = 51, .external_lex_state = 9},
  [290] = {.lex_state = 51, .external_lex_state = 9},
  [291] = {.lex_state = 51, .external_lex_state = 9},
  [292] = {.lex_state = 51, .external_lex_state = 9},
  [293] = {.lex_state = 51, .external_lex_state = 8},
  [294] = {.lex_state = 51, .external_lex_state = 9},
  [295] = {.lex_state = 51, .external_lex_state = 9},
  [296] = {.lex_state = 51, .external_lex_state = 9},
  [297] = {.lex_state = 51, .external_lex_state = 9},
  [298] = {.lex_state = 51, .external_lex_state = 8},
  [299] = {.lex_state = 51, .external_lex_state = 8},
  [300] = {.lex_state = 51, .external_lex_state = 9},
  [301] = {.lex_state = 51, .external_lex_state = 9},
  [302] = {.lex_state = 51, .external_lex_state = 9},
  [303] = {.lex_state = 51, .external_lex_state = 8},
  [304] = {.lex_state = 51, .external_lex_state = 9},
  [305] = {.lex_state = 51, .external_lex_state = 8},
  [306] = {.lex_state = 51, .external_lex_state = 8},
  [307] = {.lex_state = 51, .external_lex_state = 9},
  [308] = {.lex_state = 51, .external_lex_state = 8},
  [309] = {.lex_state = 51, .external_lex_state = 9},
  [310] = {.lex_state = 51, .external_lex_state = 7},
  [311] = {.lex_state = 51, .external_lex_state = 7},
  [312] = {.lex_state = 51, .external_lex_state = 2},
  [313] = {.lex_state = 51, .external_lex_state = 2},
  [314] = {.lex_state = 51, .external_lex_state = 2},
  [315] = {.lex_state = 51, .external_lex_state = 2},
  [316] = {.lex_state = 51, .external_lex_state = 2},
  [317] = {.lex_state = 51, .external_lex_state = 2},
  [318] = {.lex_state = 51, .external_lex_state = 2},
  [319] = {.lex_state = 51, .external_lex_state = 2},
  [320] = {.lex_state = 51, .external_lex_state = 2},
  [321] = {.lex_state = 51, .external_lex_state = 2},
  [322] = {.lex_state = 51, .external_lex_state = 2},
  [323] = {.lex_state = 51, .external_lex_state = 2},
  [324] = {.lex_state = 51, .external_lex_state = 2},
  [325] = {.lex_state = 51, .external_lex_state = 2},
  [326] = {.lex_state = 51, .external_lex_state = 7},
  [327] = {.lex_state = 51, .external_lex_state = 2},
  [328] = {.lex_state = 51, .external_lex_state = 2},
  [329] = {.lex_state = 51, .external_lex_state = 2},
  [330] = {.lex_state = 9, .external_lex_state = 10},
  [331] = {.lex_state = 9, .external_lex_state = 10},
  [332] = {.lex_state = 51, .external_lex_state = 2},
  [333] = {.lex_state = 9, .external_lex_state = 10},
  [334] = {.lex_state = 9, .external_lex_state = 10},
  [335] = {.lex_state = 51, .external_lex_state = 2},
  [336] = {.lex_state = 51, .external_lex_state = 2},
  [337] = {.lex_state = 51, .external_lex_state = 2},
  [338] = {.lex_state = 51, .external_lex_state = 2},
  [339] = {.lex_state = 51, .external_lex_state = 2},
  [340] = {.lex_state = 51, .external_lex_state = 2},
  [341] = {.lex_state = 51, .external_lex_state = 2},
  [342] = {.lex_state = 51, .external_lex_state = 2},
  [343] = {.lex_state = 51, .external_lex_state = 2},
  [344] = {.lex_state = 51, .external_lex_state = 2},
  [345] = {.lex_state = 51, .external_lex_state = 2},
  [346] = {.lex_state = 51, .external_lex_state = 2},
  [347] = {.lex_state = 51, .external_lex_state = 2},
  [348] = {.lex_state = 51, .external_lex_state = 2},
  [349] = {.lex_state = 51, .external_lex_state = 2},
  [350] = {.lex_state = 51, .external_lex_state = 2},
  [351] = {.lex_state = 51, .external_lex_state = 2},
  [352] = {.lex_state = 51, .external_lex_state = 2},
  [353] = {.lex_state = 51, .external_lex_state = 2},
  [354] = {.lex_state = 51, .external_lex_state = 2},
  [355] = {.lex_state = 51, .external_lex_state = 2},
  [356] = {.lex_state = 51, .external_lex_state = 2},
  [357] = {.lex_state = 51, .external_lex_state = 2},
  [358] = {.lex_state = 51, .external_lex_state = 2},
  [359] = {.lex_state = 51, .external_lex_state = 2},
  [360] = {.lex_state = 51, .external_lex_state = 2},
  [361] = {.lex_state = 51, .external_lex_state = 2},
  [362] = {.lex_state = 51, .external_lex_state = 2},
  [363] = {.lex_state = 51, .external_lex_state = 2},
  [364] = {.lex_state = 51, .external_lex_state = 2},
  [365] = {.lex_state = 51, .external_lex_state = 2},
  [366] = {.lex_state = 51, .external_lex_state = 2},
  [367] = {.lex_state = 51, .external_lex_state = 2},
  [368] = {.lex_state = 51, .external_lex_state = 2},
  [369] = {.lex_state = 51, .external_lex_state = 2},
  [370] = {.lex_state = 51, .external_lex_state = 2},
  [371] = {.lex_state = 51, .external_lex_state = 2},
  [372] = {.lex_state = 51, .external_lex_state = 2},
  [373] = {.lex_state = 51, .external_lex_state = 2},
  [374] = {.lex_state = 51, .external_lex_state = 2},
  [375] = {.lex_state = 51, .external_lex_state = 2},
  [376] = {.lex_state = 51, .external_lex_state = 2},
  [377] = {.lex_state = 51, .external_lex_state = 2},
  [378] = {.lex_state = 51, .external_lex_state = 2},
  [379] = {.lex_state = 51, .external_lex_state = 2},
  [380] = {.lex_state = 51, .external_lex_state = 2},
  [381] = {.lex_state = 51, .external_lex_state = 2},
  [382] = {.lex_state = 51, .external_lex_state = 2},
  [383] = {.lex_state = 51, .external_lex_state = 2},
  [384] = {.lex_state = 51, .external_lex_state = 2},
  [385] = {.lex_state = 51, .external_lex_state = 2},
  [386] = {.lex_state = 51, .external_lex_state = 2},
  [387] = {.lex_state = 51, .external_lex_state = 2},
  [388] = {.lex_state = 51, .external_lex_state = 2},
  [389] = {.lex_state = 51, .external_lex_state = 2},
  [390] = {.lex_state = 51, .external_lex_state = 2},
  [391] = {.lex_state = 51, .external_lex_state = 2},
  [392] = {.lex_state = 51, .external_lex_state = 2},
  [393] = {.lex_state = 51, .external_lex_state = 2},
  [394] = {.lex_state = 51, .external_lex_state = 2},
  [395] = {.lex_state = 51, .external_lex_state = 2},
  [396] = {.lex_state = 51, .external_lex_state = 2},
  [397] = {.lex_state = 51, .external_lex_state = 2},
  [398] = {.lex_state = 51, .external_lex_state = 2},
  [399] = {.lex_state = 51, .external_lex_state = 2},
  [400] = {.lex_state = 51, .external_lex_state = 2},
  [401] = {.lex_state = 51, .external_lex_state = 2},
  [402] = {.lex_state = 51, .external_lex_state = 2},
  [403] = {.lex_state = 51, .external_lex_state = 2},
  [404] = {.lex_state = 51, .external_lex_state = 2},
  [405] = {.lex_state = 51, .external_lex_state = 2},
  [406] = {.lex_state = 51, .external_lex_state = 2},
  [407] = {.lex_state = 51, .external_lex_state = 2},
  [408] = {.lex_state = 51, .external_lex_state = 2},
  [409] = {.lex_state = 51, .external_lex_state = 2},
  [410] = {.lex_state = 51, .external_lex_state = 2},
  [411] = {.lex_state = 51, .external_lex_state = 2},
  [412] = {.lex_state = 51, .external_lex_state = 2},
  [413] = {.lex_state = 51, .external_lex_state = 2},
  [414] = {.lex_state = 51, .external_lex_state = 2},
  [415] = {.lex_state = 51, .external_lex_state = 2},
  [416] = {.lex_state = 51, .external_lex_state = 2},
  [417] = {.lex_state = 51, .external_lex_state = 2},
  [418] = {.lex_state = 51, .external_lex_state = 2},
  [419] = {.lex_state = 51, .external_lex_state = 2},
  [420] = {.lex_state = 51, .external_lex_state = 2},
  [421] = {.lex_state = 51, .external_lex_state = 2},
  [422] = {.lex_state = 51, .external_lex_state = 2},
  [423] = {.lex_state = 51, .external_lex_state = 2},
  [424] = {.lex_state = 51, .external_lex_state = 2},
  [425] = {.lex_state = 51, .external_lex_state = 2},
  [426] = {.lex_state = 51, .external_lex_state = 2},
  [427] = {.lex_state = 51, .external_lex_state = 2},
  [428] = {.lex_state = 51, .external_lex_state = 2},
  [429] = {.lex_state = 51, .external_lex_state = 2},
  [430] = {.lex_state = 51, .external_lex_state = 2},
  [431] = {.lex_state = 51, .external_lex_state = 2},
  [432] = {.lex_state = 51, .external_lex_state = 2},
  [433] = {.lex_state = 51, .external_lex_state = 2},
  [434] = {.lex_state = 51, .external_lex_state = 2},
  [435] = {.lex_state = 51, .external_lex_state = 2},
  [436] = {.lex_state = 51, .external_lex_state = 2},
  [437] = {.lex_state = 51, .external_lex_state = 2},
  [438] = {.lex_state = 51, .external_lex_state = 2},
  [439] = {.lex_state = 51, .external_lex_state = 2},
  [440] = {.lex_state = 51, .external_lex_state = 2},
  [441] = {.lex_state = 51, .external_lex_state = 2},
  [442] = {.lex_state = 51, .external_lex_state = 2},
  [443] = {.lex_state = 51, .external_lex_state = 2},
  [444] = {.lex_state = 51, .external_lex_state = 2},
  [445] = {.lex_state = 51, .external_lex_state = 2},
  [446] = {.lex_state = 51, .external_lex_state = 2},
  [447] = {.lex_state = 51, .external_lex_state = 2},
  [448] = {.lex_state = 8, .external_lex_state = 10},
  [449] = {.lex_state = 51, .external_lex_state = 2},
  [450] = {.lex_state = 51, .external_lex_state = 2},
  [451] = {.lex_state = 51, .external_lex_state = 2},
  [452] = {.lex_state = 51, .external_lex_state = 2},
  [453] = {.lex_state = 51, .external_lex_state = 2},
  [454] = {.lex_state = 51, .external_lex_state = 2},
  [455] = {.lex_state = 51, .external_lex_state = 2},
  [456] = {.lex_state = 51, .external_lex_state = 2},
  [457] = {.lex_state = 51, .external_lex_state = 2},
  [458] = {.lex_state = 51, .external_lex_state = 2},
  [459] = {.lex_state = 51, .external_lex_state = 2},
  [460] = {.lex_state = 51, .external_lex_state = 2},
  [461] = {.lex_state = 51, .external_lex_state = 2},
  [462] = {.lex_state = 51, .external_lex_state = 2},
  [463] = {.lex_state = 51, .external_lex_state = 2},
  [464] = {.lex_state = 51, .external_lex_state = 2},
  [465] = {.lex_state = 51, .external_lex_state = 2},
  [466] = {.lex_state = 8, .external_lex_state = 11},
  [467] = {.lex_state = 8, .external_lex_state = 11},
  [468] = {.lex_state = 8, .external_lex_state = 11},
  [469] = {.lex_state = 8, .external_lex_state = 10},
  [470] = {.lex_state = 8, .external_lex_state = 11},
  [471] = {.lex_state = 8, .external_lex_state = 12},
  [472] = {.lex_state = 8, .external_lex_state = 10},
  [473] = {.lex_state = 8, .external_lex_state = 10},
  [474] = {.lex_state = 8, .external_lex_state = 11},
  [475] = {.lex_state = 8, .external_lex_state = 11},
  [476] = {.lex_state = 8, .external_lex_state = 11},
  [477] = {.lex_state = 8, .external_lex_state = 11},
  [478] = {.lex_state = 8, .external_lex_state = 11},
  [479] = {.lex_state = 8, .external_lex_state = 11},
  [480] = {.lex_state = 8, .external_lex_state = 11},
  [481] = {.lex_state = 8, .external_lex_state = 11},
  [482] = {.lex_state = 8, .external_lex_state = 11},
  [483] = {.lex_state = 8, .external_lex_state = 11},
  [484] = {.lex_state = 8, .external_lex_state = 11},
  [485] = {.lex_state = 8, .external_lex_state = 12},
  [486] = {.lex_state = 8, .external_lex_state = 10},
  [487] = {.lex_state = 8, .external_lex_state = 11},
  [488] = {.lex_state = 8, .external_lex_state = 12},
  [489] = {.lex_state = 8, .external_lex_state = 12},
  [490] = {.lex_state = 8, .external_lex_state = 10},
  [491] = {.lex_state = 8, .external_lex_state = 12},
  [492] = {.lex_state = 8, .external_lex_state = 13},
  [493] = {.lex_state = 8, .external_lex_state = 13},
  [494] = {.lex_state = 8, .external_lex_state = 13},
  [495] = {.lex_state = 8, .external_lex_state = 13},
  [496] = {.lex_state = 8, .external_lex_state = 13},
  [497] = {.lex_state = 8, .external_lex_state = 13},
  [498] = {.lex_state = 8, .external_lex_state = 13},
  [499] = {.lex_state = 8, .external_lex_state = 12},
  [500] = {.lex_state = 8, .external_lex_state = 13},
  [501] = {.lex_state = 8, .external_lex_state = 13},
  [502] = {.lex_state = 8, .external_lex_state = 10},
  [503] = {.lex_state = 8, .external_lex_state = 13},
  [504] = {.lex_state = 8, .external_lex_state = 10},
  [505] = {.lex_state = 8, .external_lex_state = 10},
  [506] = {.lex_state = 8, .external_lex_state = 10},
  [507] = {.lex_state = 8, .external_lex_state = 10},
  [508] = {.lex_state = 8, .external_lex_state = 10},
  [509] = {.lex_state = 8, .external_lex_state = 10},
  [510] = {.lex_state = 8, .external_lex_state = 10},
  [511] = {.lex_state = 8, .external_lex_state = 10},
  [512] = {.lex_state = 8, .external_lex_state = 13},
  [513] = {.lex_state = 8, .external_lex_state = 13},
  [514] = {.lex_state = 8, .external_lex_state = 10},
  [515] = {.lex_state = 8, .external_lex_state = 12},
  [516] = {.lex_state = 8, .external_lex_state = 10},
  [517] = {.lex_state = 8, .external_lex_state = 13},
  [518] = {.lex_state = 8, .external_lex_state = 12},
  [519] = {.lex_state = 8, .external_lex_state = 12},
  [520] = {.lex_state = 8, .external_lex_state = 12},
  [521] = {.lex_state = 8, .external_lex_state = 12},
  [522] = {.lex_state = 8, .external_lex_state = 12},
  [523] = {.lex_state = 8, .external_lex_state = 12},
  [524] = {.lex_state = 8, .external_lex_state = 12},
  [525] = {.lex_state = 8, .external_lex_state = 12},
  [526] = {.lex_state = 8, .external_lex_state = 12},
  [527] = {.lex_state = 8, .external_lex_state = 13},
  [528] = {.lex_state = 8, .external_lex_state = 13},
  [529] = {.lex_state = 8, .external_lex_state = 13},
  [530] = {.lex_state = 8, .external_lex_state = 11},
  [531] = {.lex_state = 8, .external_lex_state = 12},
  [532] = {.lex_state = 8, .external_lex_state = 14},
  [533] = {.lex_state = 8, .external_lex_state = 10},
  [534] = {.lex_state = 8, .external_lex_state = 11},
  [535] = {.lex_state = 8, .external_lex_state = 11},
  [536] = {.lex_state = 8, .external_lex_state = 10},
  [537] = {.lex_state = 8, .external_lex_state = 11},
  [538] = {.lex_state = 8, .external_lex_state = 10},
  [539] = {.lex_state = 8, .external_lex_state = 10},
  [540] = {.lex_state = 8, .external_lex_state = 11},
  [541] = {.lex_state = 8, .external_lex_state = 11},
  [542] = {.lex_state = 8, .external_lex_state = 11},
  [543] = {.lex_state = 8, .external_lex_state = 10},
  [544] = {.lex_state = 8, .external_lex_state = 10},
  [545] = {.lex_state = 8, .external_lex_state = 11},
  [546] = {.lex_state = 8, .external_lex_state = 10},
  [547] = {.lex_state = 8, .external_lex_state = 15},
  [548] = {.lex_state = 8, .external_lex_state = 11},
  [549] = {.lex_state = 8, .external_lex_state = 10},
  [550] = {.lex_state = 8, .external_lex_state = 15},
  [551] = {.lex_state = 8, .external_lex_state = 11},
  [552] = {.lex_state = 8, .external_lex_state = 11},
  [553] = {.lex_state = 8, .external_lex_state = 15},
  [554] = {.lex_state = 8, .external_lex_state = 15},
  [555] = {.lex_state = 8, .external_lex_state = 15},
  [556] = {.lex_state = 8, .external_lex_state = 15},
  [557] = {.lex_state = 8, .external_lex_state = 10},
  [558] = {.lex_state = 8, .external_lex_state = 15},
  [559] = {.lex_state = 8, .external_lex_state = 15},
  [560] = {.lex_state = 8, .external_lex_state = 10},
  [561] = {.lex_state = 8, .external_lex_state = 15},
  [562] = {.lex_state = 8, .external_lex_state = 15},
  [563] = {.lex_state = 8, .external_lex_state = 15},
  [564] = {.lex_state = 8, .external_lex_state = 15},
  [565] = {.lex_state = 8, .external_lex_state = 14},
  [566] = {.lex_state = 8, .external_lex_state = 15},
  [567] = {.lex_state = 8, .external_lex_state = 11},
  [568] = {.lex_state = 8, .external_lex_state = 11},
  [569] = {.lex_state = 8, .external_lex_state = 14},
  [570] = {.lex_state = 8, .external_lex_state = 11},
  [571] = {.lex_state = 8, .external_lex_state = 10},
  [572] = {.lex_state = 8, .external_lex_state = 11},
  [573] = {.lex_state = 8, .external_lex_state = 10},
  [574] = {.lex_state = 8, .external_lex_state = 15},
  [575] = {.lex_state = 8, .external_lex_state = 12},
  [576] = {.lex_state = 8, .external_lex_state = 12},
  [577] = {.lex_state = 8, .external_lex_state = 12},
  [578] = {.lex_state = 8, .external_lex_state = 12},
  [579] = {.lex_state = 8, .external_lex_state = 12},
  [580] = {.lex_state = 8, .external_lex_state = 12},
  [581] = {.lex_state = 8, .external_lex_state = 12},
  [582] = {.lex_state = 8, .external_lex_state = 12},
  [583] = {.lex_state = 8, .external_lex_state = 12},
  [584] = {.lex_state = 8, .external_lex_state = 12},
  [585] = {.lex_state = 8, .external_lex_state = 12},
  [586] = {.lex_state = 8, .external_lex_state = 10},
  [587] = {.lex_state = 8, .external_lex_state = 11},
  [588] = {.lex_state = 8, .external_lex_state = 12},
  [589] = {.lex_state = 8, .external_lex_state = 10},
  [590] = {.lex_state = 8, .external_lex_state = 12},
  [591] = {.lex_state = 8, .external_lex_state = 12},
  [592] = {.lex_state = 8, .external_lex_state = 12},
  [593] = {.lex_state = 8, .external_lex_state = 12},
  [594] = {.lex_state = 8, .external_lex_state = 12},
  [595] = {.lex_state = 8, .external_lex_state = 12},
  [596] = {.lex_state = 8, .external_lex_state = 12},
  [597] = {.lex_state = 8, .external_lex_state = 10},
  [598] = {.lex_state = 8, .external_lex_state = 12},
  [599] = {.lex_state = 8, .external_lex_state = 11},
  [600] = {.lex_state = 8, .external_lex_state = 10},
  [601] = {.lex_state = 8, .external_lex_state = 11},
  [602] = {.lex_state = 8, .external_lex_state = 15},
  [603] = {.lex_state = 8, .external_lex_state = 12},
  [604] = {.lex_state = 8, .external_lex_state = 12},
  [605] = {.lex_state = 8, .external_lex_state = 12},
  [606] = {.lex_state = 8, .external_lex_state = 12},
  [607] = {.lex_state = 8, .external_lex_state = 12},
  [608] = {.lex_state = 8, .external_lex_state = 11},
  [609] = {.lex_state = 8, .external_lex_state = 13},
  [610] = {.lex_state = 8, .external_lex_state = 13},
  [611] = {.lex_state = 8, .external_lex_state = 10},
  [612] = {.lex_state = 8, .external_lex_state = 12},
  [613] = {.lex_state = 8, .external_lex_state = 13},
  [614] = {.lex_state = 8, .external_lex_state = 11},
  [615] = {.lex_state = 8, .external_lex_state = 11},
  [616] = {.lex_state = 8, .external_lex_state = 13},
  [617] = {.lex_state = 8, .external_lex_state = 13},
  [618] = {.lex_state = 8, .external_lex_state = 11},
  [619] = {.lex_state = 8, .external_lex_state = 15},
  [620] = {.lex_state = 8, .external_lex_state = 11},
  [621] = {.lex_state = 8, .external_lex_state = 11},
  [622] = {.lex_state = 8, .external_lex_state = 13},
  [623] = {.lex_state = 8, .external_lex_state = 13},
  [624] = {.lex_state = 8, .external_lex_state = 10},
  [625] = {.lex_state = 8, .external_lex_state = 11},
  [626] = {.lex_state = 8, .external_lex_state = 11},
  [627] = {.lex_state = 8, .external_lex_state = 11},
  [628] = {.lex_state = 8, .external_lex_state = 14},
  [629] = {.lex_state = 8, .external_lex_state = 13},
  [630] = {.lex_state = 8, .external_lex_state = 14},
  [631] = {.lex_state = 8, .external_lex_state = 13},
  [632] = {.lex_state = 8, .external_lex_state = 14},
  [633] = {.lex_state = 8, .external_lex_state = 14},
  [634] = {.lex_state = 8, .external_lex_state = 14},
  [635] = {.lex_state = 8, .external_lex_state = 13},
  [636] = {.lex_state = 8, .external_lex_state = 13},
  [637] = {.lex_state = 8, .external_lex_state = 13},
  [638] = {.lex_state = 8, .external_lex_state = 13},
  [639] = {.lex_state = 8, .external_lex_state = 14},
  [640] = {.lex_state = 8, .external_lex_state = 13},
  [641] = {.lex_state = 8, .external_lex_state = 13},
  [642] = {.lex_state = 8, .external_lex_state = 13},
  [643] = {.lex_state = 8, .external_lex_state = 14},
  [644] = {.lex_state = 8, .external_lex_state = 13},
  [645] = {.lex_state = 8, .external_lex_state = 13},
  [646] = {.lex_state = 8, .external_lex_state = 13},
  [647] = {.lex_state = 8, .external_lex_state = 14},
  [648] = {.lex_state = 8, .external_lex_state = 13},
  [649] = {.lex_state = 8, .external_lex_state = 10},
  [650] = {.lex_state = 8, .external_lex_state = 13},
  [651] = {.lex_state = 8, .external_lex_state = 13},
  [652] = {.lex_state = 8, .external_lex_state = 14},
  [653] = {.lex_state = 8, .external_lex_state = 10},
  [654] = {.lex_state = 8, .external_lex_state = 14},
  [655] = {.lex_state = 8, .external_lex_state = 10},
  [656] = {.lex_state = 8, .external_lex_state = 10},
  [657] = {.lex_state = 8, .external_lex_state = 10},
  [658] = {.lex_state = 8, .external_lex_state = 14},
  [659] = {.lex_state = 8, .external_lex_state = 13},
  [660] = {.lex_state = 8, .external_lex_state = 13},
  [661] = {.lex_state = 8, .external_lex_state = 14},
  [662] = {.lex_state = 8, .external_lex_state = 13},
  [663] = {.lex_state = 8, .external_lex_state = 13},
  [664] = {.lex_state = 8, .external_lex_state = 14},
  [665] = {.lex_state = 8, .external_lex_state = 13},
  [666] = {.lex_state = 8, .external_lex_state = 14},
  [667] = {.lex_state = 8, .external_lex_state = 14},
  [668] = {.lex_state = 8, .external_lex_state = 14},
  [669] = {.lex_state = 8, .external_lex_state = 15},
  [670] = {.lex_state = 8, .external_lex_state = 14},
  [671] = {.lex_state = 8, .external_lex_state = 14},
  [672] = {.lex_state = 8, .external_lex_state = 15},
  [673] = {.lex_state = 8, .external_lex_state = 15},
  [674] = {.lex_state = 8, .external_lex_state = 14},
  [675] = {.lex_state = 8, .external_lex_state = 15},
  [676] = {.lex_state = 8, .external_lex_state = 14},
  [677] = {.lex_state = 8, .external_lex_state = 15},
  [678] = {.lex_state = 8, .external_lex_state = 14},
  [679] = {.lex_state = 8, .external_lex_state = 14},
  [680] = {.lex_state = 8, .external_lex_state = 15},
  [681] = {.lex_state = 8, .external_lex_state = 14},
  [682] = {.lex_state = 8, .external_lex_state = 14},
  [683] = {.lex_state = 8, .external_lex_state = 14},
  [684] = {.lex_state = 8, .external_lex_state = 14},
  [685] = {.lex_state = 8, .external_lex_state = 14},
  [686] = {.lex_state = 8, .external_lex_state = 14},
  [687] = {.lex_state = 8, .external_lex_state = 14},
  [688] = {.lex_state = 8, .external_lex_state = 14},
  [689] = {.lex_state = 8, .external_lex_state = 14},
  [690] = {.lex_state = 8, .external_lex_state = 15},
  [691] = {.lex_state = 8, .external_lex_state = 14},
  [692] = {.lex_state = 8, .external_lex_state = 15},
  [693] = {.lex_state = 8, .external_lex_state = 14},
  [694] = {.lex_state = 8, .external_lex_state = 15},
  [695] = {.lex_state = 8, .external_lex_state = 15},
  [696] = {.lex_state = 8, .external_lex_state = 15},
  [697] = {.lex_state = 8, .external_lex_state = 14},
  [698] = {.lex_state = 8, .external_lex_state = 14},
  [699] = {.lex_state = 8, .external_lex_state = 15},
  [700] = {.lex_state = 8, .external_lex_state = 14},
  [701] = {.lex_state = 8, .external_lex_state = 14},
  [702] = {.lex_state = 8, .external_lex_state = 15},
  [703] = {.lex_state = 8, .external_lex_state = 15},
  [704] = {.lex_state = 8, .external_lex_state = 14},
  [705] = {.lex_state = 8, .external_lex_state = 15},
  [706] = {.lex_state = 8, .external_lex_state = 15},
  [707] = {.lex_state = 8, .external_lex_state = 15},
  [708] = {.lex_state = 8, .external_lex_state = 15},
  [709] = {.lex_state = 8, .external_lex_state = 14},
  [710] = {.lex_state = 8, .external_lex_state = 14},
  [711] = {.lex_state = 8, .external_lex_state = 15},
  [712] = {.lex_state = 8, .external_lex_state = 15},
  [713] = {.lex_state = 8, .external_lex_state = 15},
  [714] = {.lex_state = 8, .external_lex_state = 15},
  [715] = {.lex_state = 8, .external_lex_state = 15},
  [716] = {.lex_state = 8, .external_lex_state = 15},
  [717] = {.lex_state = 8, .external_lex_state = 15},
  [718] = {.lex_state = 8, .external_lex_state = 15},
  [719] = {.lex_state = 8, .external_lex_state = 15},
  [720] = {.lex_state = 8, .external_lex_state = 6},
  [721] = {.lex_state = 8, .external_lex_state = 6},
  [722] = {.lex_state = 51, .external_lex_state = 2},
  [723] = {.lex_state = 51, .external_lex_state = 2},
  [724] = {.lex_state = 8, .external_lex_state = 12},
  [725] = {.lex_state = 0, .external_lex_state = 16},
  [726] = {.lex_state = 8, .external_lex_state = 14},
  [727] = {.lex_state = 0, .external_lex_state = 16},
  [728] = {.lex_state = 8, .external_lex_state = 14},
  [729] = {.lex_state = 8, .external_lex_state = 14},
  [730] = {.lex_state = 8, .external_lex_state = 14},
  [731] = {.lex_state = 8, .external_lex_state = 14},
  [732] = {.lex_state = 0, .external_lex_state = 16},
  [733] = {.lex_state = 8, .external_lex_state = 14},
  [734] = {.lex_state = 8, .external_lex_state = 14},
  [735] = {.lex_state = 8, .external_lex_state = 12},
  [736] = {.lex_state = 8, .external_lex_state = 10},
  [737] = {.lex_state = 0, .external_lex_state = 2},
  [738] = {.lex_state = 0, .external_lex_state = 8},
  [739] = {.lex_state = 0, .external_lex_state = 2},
  [740] = {.lex_state = 0, .external_lex_state = 8},
  [741] = {.lex_state = 0, .external_lex_state = 8},
  [742] = {.lex_state = 0, .external_lex_state = 2},
  [743] = {.lex_state = 51, .external_lex_state = 6},
  [744] = {.lex_state = 51, .external_lex_state = 6},
  [745] = {.lex_state = 0, .external_lex_state = 2},
  [746] = {.lex_state = 51, .external_lex_state = 6},
  [747] = {.lex_state = 0, .external_lex_state = 2},
  [748] = {.lex_state = 0, .external_lex_state = 10},
  [749] = {.lex_state = 0, .external_lex_state = 6},
  [750] = {.lex_state = 0, .external_lex_state = 6},
  [751] = {.lex_state = 0, .external_lex_state = 10},
  [752] = {.lex_state = 0, .external_lex_state = 6},
  [753] = {.lex_state = 8, .external_lex_state = 12},
  [754] = {.lex_state = 8, .external_lex_state = 10},
  [755] = {.lex_state = 0, .external_lex_state = 16},
  [756] = {.lex_state = 0, .external_lex_state = 16},
  [757] = {.lex_state = 0, .external_lex_state = 16},
  [758] = {.lex_state = 8, .external_lex_state = 13},
  [759] = {.lex_state = 0, .external_lex_state = 16},
  [760] = {.lex_state = 8, .external_lex_state = 11},
  [761] = {.lex_state = 0, .external_lex_state = 16},
  [762] = {.lex_state = 8, .external_lex_state = 13},
  [763] = {.lex_state = 8, .external_lex_state = 11},
  [764] = {.lex_state = 0, .external_lex_state = 16},
  [765] = {.lex_state = 0, .external_lex_state = 16},
  [766] = {.lex_state = 8, .external_lex_state = 12},
  [767] = {.lex_state = 0, .external_lex_state = 16},
  [768] = {.lex_state = 8, .external_lex_state = 10},
  [769] = {.lex_state = 8, .external_lex_state = 14},
  [770] = {.lex_state = 8, .external_lex_state = 14},
  [771] = {.lex_state = 8, .external_lex_state = 15},
  [772] = {.lex_state = 8, .external_lex_state = 15},
  [773] = {.lex_state = 0, .external_lex_state = 6},
  [774] = {.lex_state = 0, .external_lex_state = 6},
  [775] = {.lex_state = 0, .external_lex_state = 6},
  [776] = {.lex_state = 0, .external_lex_state = 6},
  [777] = {.lex_state = 0, .external_lex_state = 6},
  [778] = {.lex_state = 0, .external_lex_state = 6},
  [779] = {.lex_state = 0, .external_lex_state = 6},
  [780] = {.lex_state = 0, .external_lex_state = 6},
  [781] = {.lex_state = 0, .external_lex_state = 6},
  [782] = {.lex_state = 0, .external_lex_state = 6},
  [783] = {.lex_state = 0, .external_lex_state = 6},
  [784] = {.lex_state = 0, .external_lex_state = 6},
  [785] = {.lex_state = 0, .external_lex_state = 6},
  [786] = {.lex_state = 0, .external_lex_state = 10},
  [787] = {.lex_state = 0, .external_lex_state = 15},
  [788] = {.lex_state = 51, .external_lex_state = 6},
  [789] = {.lex_state = 0, .external_lex_state = 10},
  [790] = {.lex_state = 0, .external_lex_state = 15},
  [791] = {.lex_state = 0, .external_lex_state = 10},
  [792] = {.lex_state = 0, .external_lex_state = 15},
  [793] = {.lex_state = 51, .external_lex_state = 6},
  [794] = {.lex_state = 0, .external_lex_state = 6},
  [795] = {.lex_state = 51, .external_lex_state = 6},
  [796] = {.lex_state = 0, .external_lex_state = 15},
  [797] = {.lex_state = 0, .external_lex_state = 15},
  [798] = {.lex_state = 51, .external_lex_state = 6},
  [799] = {.lex_state = 51, .external_lex_state = 6},
  [800] = {.lex_state = 51, .external_lex_state = 6},
  [801] = {.lex_state = 0, .external_lex_state = 15},
  [802] = {.lex_state = 51, .external_lex_state = 6},
  [803] = {.lex_state = 0, .external_lex_state = 10},
  [804] = {.lex_state = 0, .external_lex_state = 10},
  [805] = {.lex_state = 0, .external_lex_state = 10},
  [806] = {.lex_state = 51, .external_lex_state = 6},
  [807] = {.lex_state = 0, .external_lex_state = 6},
  [808] = {.lex_state = 0, .external_lex_state = 10},
  [809] = {.lex_state = 0, .external_lex_state = 10},
  [810] = {.lex_state = 51, .external_lex_state = 6},
  [811] = {.lex_state = 0, .external_lex_state = 10},
  [812] = {.lex_state = 0, .external_lex_state = 10},
  [813] = {.lex_state = 0, .external_lex_state = 10},
  [814] = {.lex_state = 51, .external_lex_state = 6},
  [815] = {.lex_state = 0, .external_lex_state = 10},
  [816] = {.lex_state = 0, .external_lex_state = 6},
  [817] = {.lex_state = 0, .external_lex_state = 10},
  [818] = {.lex_state = 51, .external_lex_state = 6},
  [819] = {.lex_state = 0, .external_lex_state = 6},
  [820] = {.lex_state = 0, .external_lex_state = 6},
  [821] = {.lex_state = 0, .external_lex_state = 2},
  [822] = {.lex_state = 51, .external_lex_state = 6},
  [823] = {.lex_state = 51, .external_lex_state = 6},
  [824] = {.lex_state = 0, .external_lex_state = 10},
  [825] = {.lex_state = 51, .external_lex_state = 6},
  [826] = {.lex_state = 51, .external_lex_state = 6},
  [827] = {.lex_state = 51, .external_lex_state = 6},
  [828] = {.lex_state = 0, .external_lex_state = 10},
  [829] = {.lex_state = 51, .external_lex_state = 6},
  [830] = {.lex_state = 0, .external_lex_state = 6},
  [831] = {.lex_state = 0, .external_lex_state = 2},
  [832] = {.lex_state = 0, .external_lex_state = 10},
  [833] = {.lex_state = 0, .external_lex_state = 10},
  [834] = {.lex_state = 51, .external_lex_state = 6},
  [835] = {.lex_state = 51, .external_lex_state = 6},
  [836] = {.lex_state = 51, .external_lex_state = 6},
  [837] = {.lex_state = 51, .external_lex_state = 6},
  [838] = {.lex_state = 51, .external_lex_state = 6},
  [839] = {.lex_state = 51, .external_lex_state = 6},
  [840] = {.lex_state = 0, .external_lex_state = 6},
  [841] = {.lex_state = 0, .external_lex_state = 10},
  [842] = {.lex_state = 0, .external_lex_state = 6},
  [843] = {.lex_state = 0, .external_lex_state = 10},
  [844] = {.lex_state = 16, .external_lex_state = 17},
  [845] = {.lex_state = 0, .external_lex_state = 6},
  [846] = {.lex_state = 0, .external_lex_state = 6},
  [847] = {.lex_state = 16, .external_lex_state = 17},
  [848] = {.lex_state = 0, .external_lex_state = 10},
  [849] = {.lex_state = 0, .external_lex_state = 10},
  [850] = {.lex_state = 0, .external_lex_state = 10},
  [851] = {.lex_state = 0, .external_lex_state = 18},
  [852] = {.lex_state = 0, .external_lex_state = 19},
  [853] = {.lex_state = 0, .external_lex_state = 18},
  [854] = {.lex_state = 51, .external_lex_state = 11},
  [855] = {.lex_state = 0, .external_lex_state = 10},
  [856] = {.lex_state = 0, .external_lex_state = 10},
  [857] = {.lex_state = 0, .external_lex_state = 6},
  [858] = {.lex_state = 16, .external_lex_state = 17},
  [859] = {.lex_state = 16, .external_lex_state = 17},
  [860] = {.lex_state = 0, .external_lex_state = 10},
  [861] = {.lex_state = 0, .external_lex_state = 6},
  [862] = {.lex_state = 0, .external_lex_state = 6},
  [863] = {.lex_state = 0, .external_lex_state = 10},
  [864] = {.lex_state = 0, .external_lex_state = 6},
  [865] = {.lex_state = 0, .external_lex_state = 6},
  [866] = {.lex_state = 16, .external_lex_state = 17},
  [867] = {.lex_state = 0, .external_lex_state = 6},
  [868] = {.lex_state = 0, .external_lex_state = 10},
  [869] = {.lex_state = 16, .external_lex_state = 17},
  [870] = {.lex_state = 0, .external_lex_state = 10},
  [871] = {.lex_state = 0, .external_lex_state = 10},
  [872] = {.lex_state = 0, .external_lex_state = 6},
  [873] = {.lex_state = 16, .external_lex_state = 17},
  [874] = {.lex_state = 16, .external_lex_state = 17},
  [875] = {.lex_state = 0, .external_lex_state = 6},
  [876] = {.lex_state = 0, .external_lex_state = 6},
  [877] = {.lex_state = 0, .external_lex_state = 20},
  [878] = {.lex_state = 16, .external_lex_state = 17},
  [879] = {.lex_state = 0, .external_lex_state = 10},
  [880] = {.lex_state = 0, .external_lex_state = 10},
  [881] = {.lex_state = 0, .external_lex_state = 10},
  [882] = {.lex_state = 16, .external_lex_state = 17},
  [883] = {.lex_state = 0, .external_lex_state = 10},
  [884] = {.lex_state = 16, .external_lex_state = 17},
  [885] = {.lex_state = 0, .external_lex_state = 6},
  [886] = {.lex_state = 16, .external_lex_state = 17},
  [887] = {.lex_state = 0, .external_lex_state = 6},
  [888] = {.lex_state = 0, .external_lex_state = 10},
  [889] = {.lex_state = 0, .external_lex_state = 10},
  [890] = {.lex_state = 0, .external_lex_state = 19},
  [891] = {.lex_state = 0, .external_lex_state = 6},
  [892] = {.lex_state = 0, .external_lex_state = 6},
  [893] = {.lex_state = 16, .external_lex_state = 17},
  [894] = {.lex_state = 0, .external_lex_state = 6},
  [895] = {.lex_state = 16, .external_lex_state = 17},
  [896] = {.lex_state = 0, .external_lex_state = 10},
  [897] = {.lex_state = 0, .external_lex_state = 18},
  [898] = {.lex_state = 0, .external_lex_state = 19},
  [899] = {.lex_state = 0, .external_lex_state = 6},
  [900] = {.lex_state = 0, .external_lex_state = 6},
  [901] = {.lex_state = 16, .external_lex_state = 17},
  [902] = {.lex_state = 16, .external_lex_state = 17},
  [903] = {.lex_state = 0, .external_lex_state = 6},
  [904] = {.lex_state = 0, .external_lex_state = 19},
  [905] = {.lex_state = 0, .external_lex_state = 18},
  [906] = {.lex_state = 0, .external_lex_state = 6},
  [907] = {.lex_state = 0, .external_lex_state = 6},
  [908] = {.lex_state = 16, .external_lex_state = 17},
  [909] = {.lex_state = 0, .external_lex_state = 11},
  [910] = {.lex_state = 51, .external_lex_state = 10},
  [911] = {.lex_state = 0, .external_lex_state = 10},
  [912] = {.lex_state = 51, .external_lex_state = 21},
  [913] = {.lex_state = 0, .external_lex_state = 6},
  [914] = {.lex_state = 51, .external_lex_state = 10},
  [915] = {.lex_state = 0, .external_lex_state = 11},
  [916] = {.lex_state = 0, .external_lex_state = 6},
  [917] = {.lex_state = 0, .external_lex_state = 13},
  [918] = {.lex_state = 0, .external_lex_state = 12},
  [919] = {.lex_state = 51, .external_lex_state = 10},
  [920] = {.lex_state = 0, .external_lex_state = 12},
  [921] = {.lex_state = 0, .external_lex_state = 6},
  [922] = {.lex_state = 0, .external_lex_state = 13},
  [923] = {.lex_state = 0, .external_lex_state = 11},
  [924] = {.lex_state = 0, .external_lex_state = 6},
  [925] = {.lex_state = 0, .external_lex_state = 13},
  [926] = {.lex_state = 0, .external_lex_state = 13},
  [927] = {.lex_state = 0, .external_lex_state = 6},
  [928] = {.lex_state = 0, .external_lex_state = 13},
  [929] = {.lex_state = 15, .external_lex_state = 10},
  [930] = {.lex_state = 0, .external_lex_state = 6},
  [931] = {.lex_state = 0, .external_lex_state = 13},
  [932] = {.lex_state = 0, .external_lex_state = 12},
  [933] = {.lex_state = 0, .external_lex_state = 11},
  [934] = {.lex_state = 51, .external_lex_state = 10},
  [935] = {.lex_state = 0, .external_lex_state = 13},
  [936] = {.lex_state = 0, .external_lex_state = 10},
  [937] = {.lex_state = 15, .external_lex_state = 10},
  [938] = {.lex_state = 0, .external_lex_state = 12},
  [939] = {.lex_state = 0, .external_lex_state = 12},
  [940] = {.lex_state = 0, .external_lex_state = 11},
  [941] = {.lex_state = 0, .external_lex_state = 6},
  [942] = {.lex_state = 0, .external_lex_state = 12},
  [943] = {.lex_state = 0, .external_lex_state = 13},
  [944] = {.lex_state = 0, .external_lex_state = 6},
  [945] = {.lex_state = 0, .external_lex_state = 12},
  [946] = {.lex_state = 0, .external_lex_state = 12},
  [947] = {.lex_state = 0, .external_lex_state = 6},
  [948] = {.lex_state = 0, .external_lex_state = 13},
  [949] = {.lex_state = 0, .external_lex_state = 13},
  [950] = {.lex_state = 0, .external_lex_state = 6},
  [951] = {.lex_state = 15, .external_lex_state = 10},
  [952] = {.lex_state = 15, .external_lex_state = 10},
  [953] = {.lex_state = 0, .external_lex_state = 6},
  [954] = {.lex_state = 15, .external_lex_state = 10},
  [955] = {.lex_state = 0, .external_lex_state = 6},
  [956] = {.lex_state = 0, .external_lex_state = 12},
  [957] = {.lex_state = 0, .external_lex_state = 6},
  [958] = {.lex_state = 0, .external_lex_state = 11},
  [959] = {.lex_state = 0, .external_lex_state = 13},
  [960] = {.lex_state = 0, .external_lex_state = 12},
  [961] = {.lex_state = 0, .external_lex_state = 12},
  [962] = {.lex_state = 0, .external_lex_state = 13},
  [963] = {.lex_state = 0, .external_lex_state = 11},
  [964] = {.lex_state = 0, .external_lex_state = 13},
  [965] = {.lex_state = 0, .external_lex_state = 12},
  [966] = {.lex_state = 0, .external_lex_state = 6},
  [967] = {.lex_state = 0, .external_lex_state = 6},
  [968] = {.lex_state = 0, .external_lex_state = 12},
  [969] = {.lex_state = 0, .external_lex_state = 10},
  [970] = {.lex_state = 0, .external_lex_state = 6},
  [971] = {.lex_state = 0, .external_lex_state = 6},
  [972] = {.lex_state = 0, .external_lex_state = 22},
  [973] = {.lex_state = 0, .external_lex_state = 6},
  [974] = {.lex_state = 51, .external_lex_state = 21},
  [975] = {.lex_state = 0, .external_lex_state = 12},
  [976] = {.lex_state = 0, .external_lex_state = 6},
  [977] = {.lex_state = 0, .external_lex_state = 22},
  [978] = {.lex_state = 0, .external_lex_state = 22},
  [979] = {.lex_state = 0, .external_lex_state = 11},
  [980] = {.lex_state = 0, .external_lex_state = 22},
  [981] = {.lex_state = 0, .external_lex_state = 13},
  [982] = {.lex_state = 15, .external_lex_state = 10},
  [983] = {.lex_state = 0, .external_lex_state = 12},
  [984] = {.lex_state = 15, .external_lex_state = 10},
  [985] = {.lex_state = 0, .external_lex_state = 22},
  [986] = {.lex_state = 0, .external_lex_state = 6},
  [987] = {.lex_state = 15, .external_lex_state = 10},
  [988] = {.lex_state = 0, .external_lex_state = 11},
  [989] = {.lex_state = 0, .external_lex_state = 22},
  [990] = {.lex_state = 0, .external_lex_state = 11},
  [991] = {.lex_state = 0, .external_lex_state = 13},
  [992] = {.lex_state = 0, .external_lex_state = 22},
  [993] = {.lex_state = 0, .external_lex_state = 22},
  [994] = {.lex_state = 0, .external_lex_state = 6},
  [995] = {.lex_state = 0, .external_lex_state = 12},
  [996] = {.lex_state = 0, .external_lex_state = 10},
  [997] = {.lex_state = 0, .external_lex_state = 6},
  [998] = {.lex_state = 15, .external_lex_state = 10},
  [999] = {.lex_state = 0, .external_lex_state = 11},
  [1000] = {.lex_state = 0, .external_lex_state = 13},
  [1001] = {.lex_state = 0, .external_lex_state = 12},
  [1002] = {.lex_state = 0, .external_lex_state = 11},
  [1003] = {.lex_state = 0, .external_lex_state = 21},
  [1004] = {.lex_state = 0, .external_lex_state = 6},
  [1005] = {.lex_state = 51, .external_lex_state = 21},
  [1006] = {.lex_state = 51, .external_lex_state = 10},
  [1007] = {.lex_state = 15, .external_lex_state = 10},
  [1008] = {.lex_state = 0, .external_lex_state = 6},
  [1009] = {.lex_state = 15, .external_lex_state = 10},
  [1010] = {.lex_state = 0, .external_lex_state = 11},
  [1011] = {.lex_state = 0, .external_lex_state = 6},
  [1012] = {.lex_state = 0, .external_lex_state = 10},
  [1013] = {.lex_state = 0, .external_lex_state = 6},
  [1014] = {.lex_state = 0, .external_lex_state = 6},
  [1015] = {.lex_state = 0, .external_lex_state = 6},
  [1016] = {.lex_state = 0, .external_lex_state = 6},
  [1017] = {.lex_state = 0, .external_lex_state = 11},
  [1018] = {.lex_state = 0, .external_lex_state = 12},
  [1019] = {.lex_state = 0, .external_lex_state = 6},
  [1020] = {.lex_state = 0, .external_lex_state = 6},
  [1021] = {.lex_state = 0, .external_lex_state = 6},
  [1022] = {.lex_state = 0, .external_lex_state = 13},
  [1023] = {.lex_state = 0, .external_lex_state = 13},
  [1024] = {.lex_state = 51, .external_lex_state = 10},
  [1025] = {.lex_state = 0, .external_lex_state = 12},
  [1026] = {.lex_state = 0, .external_lex_state = 6},
  [1027] = {.lex_state = 0, .external_lex_state = 10},
  [1028] = {.lex_state = 0, .external_lex_state = 13},
  [1029] = {.lex_state = 0, .external_lex_state = 12},
  [1030] = {.lex_state = 0, .external_lex_state = 12},
  [1031] = {.lex_state = 0, .external_lex_state = 13},
  [1032] = {.lex_state = 15, .external_lex_state = 10},
  [1033] = {.lex_state = 51, .external_lex_state = 10},
  [1034] = {.lex_state = 0, .external_lex_state = 11},
  [1035] = {.lex_state = 51, .external_lex_state = 10},
  [1036] = {.lex_state = 15, .external_lex_state = 10},
  [1037] = {.lex_state = 0, .external_lex_state = 12},
  [1038] = {.lex_state = 15, .external_lex_state = 10},
  [1039] = {.lex_state = 0, .external_lex_state = 12},
  [1040] = {.lex_state = 0, .external_lex_state = 11},
  [1041] = {.lex_state = 0, .external_lex_state = 13},
  [1042] = {.lex_state = 0, .external_lex_state = 11},
  [1043] = {.lex_state = 15, .external_lex_state = 10},
  [1044] = {.lex_state = 15, .external_lex_state = 10},
  [1045] = {.lex_state = 15, .external_lex_state = 10},
  [1046] = {.lex_state = 15, .external_lex_state = 10},
  [1047] = {.lex_state = 15, .external_lex_state = 10},
  [1048] = {.lex_state = 15, .external_lex_state = 10},
  [1049] = {.lex_state = 0, .external_lex_state = 11},
  [1050] = {.lex_state = 15, .external_lex_state = 10},
  [1051] = {.lex_state = 0, .external_lex_state = 13},
  [1052] = {.lex_state = 15, .external_lex_state = 10},
  [1053] = {.lex_state = 0, .external_lex_state = 12},
  [1054] = {.lex_state = 0, .external_lex_state = 12},
  [1055] = {.lex_state = 51, .external_lex_state = 10},
  [1056] = {.lex_state = 0, .external_lex_state = 11},
  [1057] = {.lex_state = 15, .external_lex_state = 10},
  [1058] = {.lex_state = 0, .external_lex_state = 12},
  [1059] = {.lex_state = 0, .external_lex_state = 12},
  [1060] = {.lex_state = 0, .external_lex_state = 10},
  [1061] = {.lex_state = 0, .external_lex_state = 11},
  [1062] = {.lex_state = 15, .external_lex_state = 10},
  [1063] = {.lex_state = 0, .external_lex_state = 6},
  [1064] = {.lex_state = 0, .external_lex_state = 6},
  [1065] = {.lex_state = 15, .external_lex_state = 10},
  [1066] = {.lex_state = 0, .external_lex_state = 12},
  [1067] = {.lex_state = 0, .external_lex_state = 13},
  [1068] = {.lex_state = 0, .external_lex_state = 12},
  [1069] = {.lex_state = 0, .external_lex_state = 13},
  [1070] = {.lex_state = 15, .external_lex_state = 10},
  [1071] = {.lex_state = 0, .external_lex_state = 12},
  [1072] = {.lex_state = 0, .external_lex_state = 6},
  [1073] = {.lex_state = 15, .external_lex_state = 10},
  [1074] = {.lex_state = 0, .external_lex_state = 6},
  [1075] = {.lex_state = 0, .external_lex_state = 10},
  [1076] = {.lex_state = 0, .external_lex_state = 11},
  [1077] = {.lex_state = 15, .external_lex_state = 10},
  [1078] = {.lex_state = 15, .external_lex_state = 10},
  [1079] = {.lex_state = 0, .external_lex_state = 12},
  [1080] = {.lex_state = 0, .external_lex_state = 13},
  [1081] = {.lex_state = 0, .external_lex_state = 11},
  [1082] = {.lex_state = 0, .external_lex_state = 6},
  [1083] = {.lex_state = 15, .external_lex_state = 10},
  [1084] = {.lex_state = 0, .external_lex_state = 12},
  [1085] = {.lex_state = 0, .external_lex_state = 13},
  [1086] = {.lex_state = 0, .external_lex_state = 6},
  [1087] = {.lex_state = 0, .external_lex_state = 11},
  [1088] = {.lex_state = 0, .external_lex_state = 11},
  [1089] = {.lex_state = 0, .external_lex_state = 6},
  [1090] = {.lex_state = 0, .external_lex_state = 10},
  [1091] = {.lex_state = 0, .external_lex_state = 6},
  [1092] = {.lex_state = 0, .external_lex_state = 11},
  [1093] = {.lex_state = 0, .external_lex_state = 11},
  [1094] = {.lex_state = 0, .external_lex_state = 6},
  [1095] = {.lex_state = 0, .external_lex_state = 6},
  [1096] = {.lex_state = 0, .external_lex_state = 6},
  [1097] = {.lex_state = 0, .external_lex_state = 10},
  [1098] = {.lex_state = 0, .external_lex_state = 11},
  [1099] = {.lex_state = 0, .external_lex_state = 10},
  [1100] = {.lex_state = 0, .external_lex_state = 11},
  [1101] = {.lex_state = 0, .external_lex_state = 13},
  [1102] = {.lex_state = 0, .external_lex_state = 10},
  [1103] = {.lex_state = 0, .external_lex_state = 10},
  [1104] = {.lex_state = 0, .external_lex_state = 10},
  [1105] = {.lex_state = 0, .external_lex_state = 11},
  [1106] = {.lex_state = 51, .external_lex_state = 10},
  [1107] = {.lex_state = 0, .external_lex_state = 10},
  [1108] = {.lex_state = 0, .external_lex_state = 10},
  [1109] = {.lex_state = 0, .external_lex_state = 14},
  [1110] = {.lex_state = 0, .external_lex_state = 10},
  [1111] = {.lex_state = 0, .external_lex_state = 10},
  [1112] = {.lex_state = 51, .external_lex_state = 10},
  [1113] = {.lex_state = 0, .external_lex_state = 10},
  [1114] = {.lex_state = 0, .external_lex_state = 20},
  [1115] = {.lex_state = 15, .external_lex_state = 10},
  [1116] = {.lex_state = 0, .external_lex_state = 10},
  [1117] = {.lex_state = 0, .external_lex_state = 10},
  [1118] = {.lex_state = 0, .external_lex_state = 10},
  [1119] = {.lex_state = 0, .external_lex_state = 14},
  [1120] = {.lex_state = 51, .external_lex_state = 10},
  [1121] = {.lex_state = 0, .external_lex_state = 10},
  [1122] = {.lex_state = 0, .external_lex_state = 10},
  [1123] = {.lex_state = 0, .external_lex_state = 10},
  [1124] = {.lex_state = 0, .external_lex_state = 2},
  [1125] = {.lex_state = 51, .external_lex_state = 10},
  [1126] = {.lex_state = 0, .external_lex_state = 10},
  [1127] = {.lex_state = 0, .external_lex_state = 20},
  [1128] = {.lex_state = 0, .external_lex_state = 10},
  [1129] = {.lex_state = 0, .external_lex_state = 10},
  [1130] = {.lex_state = 0, .external_lex_state = 10},
  [1131] = {.lex_state = 0, .external_lex_state = 15},
  [1132] = {.lex_state = 0, .external_lex_state = 10},
  [1133] = {.lex_state = 0, .external_lex_state = 13},
  [1134] = {.lex_state = 0, .external_lex_state = 10},
  [1135] = {.lex_state = 0, .external_lex_state = 10},
  [1136] = {.lex_state = 0, .external_lex_state = 10},
  [1137] = {.lex_state = 0, .external_lex_state = 10},
  [1138] = {.lex_state = 0, .external_lex_state = 10},
  [1139] = {.lex_state = 0, .external_lex_state = 12},
  [1140] = {.lex_state = 0, .external_lex_state = 2},
  [1141] = {.lex_state = 0, .external_lex_state = 14},
  [1142] = {.lex_state = 0, .external_lex_state = 2},
  [1143] = {.lex_state = 0, .external_lex_state = 10},
  [1144] = {.lex_state = 0, .external_lex_state = 10},
  [1145] = {.lex_state = 0, .external_lex_state = 10},
  [1146] = {.lex_state = 0, .external_lex_state = 2},
  [1147] = {.lex_state = 0, .external_lex_state = 13},
  [1148] = {.lex_state = 0, .external_lex_state = 10},
  [1149] = {.lex_state = 0, .external_lex_state = 10},
  [1150] = {.lex_state = 0, .external_lex_state = 10},
  [1151] = {.lex_state = 0, .external_lex_state = 10},
  [1152] = {.lex_state = 0, .external_lex_state = 10},
  [1153] = {.lex_state = 0, .external_lex_state = 13},
  [1154] = {.lex_state = 0, .external_lex_state = 12},
  [1155] = {.lex_state = 0, .external_lex_state = 12},
  [1156] = {.lex_state = 0, .external_lex_state = 12},
  [1157] = {.lex_state = 0, .external_lex_state = 12},
  [1158] = {.lex_state = 0, .external_lex_state = 12},
  [1159] = {.lex_state = 0, .external_lex_state = 12},
  [1160] = {.lex_state = 0, .external_lex_state = 10},
  [1161] = {.lex_state = 0, .external_lex_state = 14},
  [1162] = {.lex_state = 51, .external_lex_state = 21},
  [1163] = {.lex_state = 0, .external_lex_state = 10},
  [1164] = {.lex_state = 51, .external_lex_state = 21},
  [1165] = {.lex_state = 0, .external_lex_state = 10},
  [1166] = {.lex_state = 51, .external_lex_state = 21},
  [1167] = {.lex_state = 0, .external_lex_state = 13},
  [1168] = {.lex_state = 51, .external_lex_state = 10},
  [1169] = {.lex_state = 0, .external_lex_state = 10},
  [1170] = {.lex_state = 51, .external_lex_state = 21},
  [1171] = {.lex_state = 0, .external_lex_state = 10},
  [1172] = {.lex_state = 0, .external_lex_state = 13},
  [1173] = {.lex_state = 0, .external_lex_state = 10},
  [1174] = {.lex_state = 0, .external_lex_state = 13},
  [1175] = {.lex_state = 0, .external_lex_state = 2},
  [1176] = {.lex_state = 0, .external_lex_state = 10},
  [1177] = {.lex_state = 0, .external_lex_state = 10},
  [1178] = {.lex_state = 0, .external_lex_state = 10},
  [1179] = {.lex_state = 0, .external_lex_state = 13},
  [1180] = {.lex_state = 0, .external_lex_state = 10},
  [1181] = {.lex_state = 0, .external_lex_state = 13},
  [1182] = {.lex_state = 0, .external_lex_state = 11},
  [1183] = {.lex_state = 51, .external_lex_state = 21},
  [1184] = {.lex_state = 0, .external_lex_state = 10},
  [1185] = {.lex_state = 0, .external_lex_state = 10},
  [1186] = {.lex_state = 0, .external_lex_state = 12},
  [1187] = {.lex_state = 0, .external_lex_state = 12},
  [1188] = {.lex_state = 0, .external_lex_state = 10},
  [1189] = {.lex_state = 0, .external_lex_state = 10},
  [1190] = {.lex_state = 0, .external_lex_state = 10},
  [1191] = {.lex_state = 51, .external_lex_state = 10},
  [1192] = {.lex_state = 0, .external_lex_state = 10},
  [1193] = {.lex_state = 0, .external_lex_state = 11},
  [1194] = {.lex_state = 0, .external_lex_state = 10},
  [1195] = {.lex_state = 0, .external_lex_state = 10},
  [1196] = {.lex_state = 0, .external_lex_state = 14},
  [1197] = {.lex_state = 0, .external_lex_state = 10},
  [1198] = {.lex_state = 0, .external_lex_state = 22},
  [1199] = {.lex_state = 51, .external_lex_state = 21},
  [1200] = {.lex_state = 0, .external_lex_state = 13},
  [1201] = {.lex_state = 0, .external_lex_state = 10},
  [1202] = {.lex_state = 51, .external_lex_state = 10},
  [1203] = {.lex_state = 0, .external_lex_state = 10},
  [1204] = {.lex_state = 0, .external_lex_state = 10},
  [1205] = {.lex_state = 0, .external_lex_state = 12},
  [1206] = {.lex_state = 0, .external_lex_state = 13},
  [1207] = {.lex_state = 0, .external_lex_state = 10},
  [1208] = {.lex_state = 51, .external_lex_state = 10},
  [1209] = {.lex_state = 0, .external_lex_state = 15},
  [1210] = {.lex_state = 0, .external_lex_state = 2},
  [1211] = {.lex_state = 0, .external_lex_state = 11},
  [1212] = {.lex_state = 0, .external_lex_state = 10},
  [1213] = {.lex_state = 51, .external_lex_state = 10},
  [1214] = {.lex_state = 0, .external_lex_state = 10},
  [1215] = {.lex_state = 0, .external_lex_state = 10},
  [1216] = {.lex_state = 0, .external_lex_state = 13},
  [1217] = {.lex_state = 0, .external_lex_state = 10},
  [1218] = {.lex_state = 0, .external_lex_state = 10},
  [1219] = {.lex_state = 0, .external_lex_state = 10},
  [1220] = {.lex_state = 0, .external_lex_state = 10},
  [1221] = {.lex_state = 0, .external_lex_state = 15},
  [1222] = {.lex_state = 0, .external_lex_state = 13},
  [1223] = {.lex_state = 51, .external_lex_state = 10},
  [1224] = {.lex_state = 51, .external_lex_state = 21},
  [1225] = {.lex_state = 0, .external_lex_state = 15},
  [1226] = {.lex_state = 0, .external_lex_state = 10},
  [1227] = {.lex_state = 0, .external_lex_state = 10},
  [1228] = {.lex_state = 51, .external_lex_state = 21},
  [1229] = {.lex_state = 0, .external_lex_state = 13},
  [1230] = {.lex_state = 0, .external_lex_state = 10},
  [1231] = {.lex_state = 0, .external_lex_state = 14},
  [1232] = {.lex_state = 0, .external_lex_state = 11},
  [1233] = {.lex_state = 0, .external_lex_state = 13},
  [1234] = {.lex_state = 51, .external_lex_state = 10},
  [1235] = {.lex_state = 0, .external_lex_state = 10},
  [1236] = {.lex_state = 51, .external_lex_state = 10},
  [1237] = {.lex_state = 0, .external_lex_state = 10},
  [1238] = {.lex_state = 0, .external_lex_state = 12},
  [1239] = {.lex_state = 0, .external_lex_state = 11},
  [1240] = {.lex_state = 0, .external_lex_state = 12},
  [1241] = {.lex_state = 0, .external_lex_state = 13},
  [1242] = {.lex_state = 0, .external_lex_state = 11},
  [1243] = {.lex_state = 0, .external_lex_state = 12},
  [1244] = {.lex_state = 0, .external_lex_state = 14},
  [1245] = {.lex_state = 0, .external_lex_state = 2},
  [1246] = {.lex_state = 0, .external_lex_state = 2},
  [1247] = {.lex_state = 0, .external_lex_state = 12},
  [1248] = {.lex_state = 0, .external_lex_state = 10},
  [1249] = {.lex_state = 0, .external_lex_state = 10},
  [1250] = {.lex_state = 0, .external_lex_state = 10},
  [1251] = {.lex_state = 51, .external_lex_state = 21},
  [1252] = {.lex_state = 0, .external_lex_state = 10},
  [1253] = {.lex_state = 0, .external_lex_state = 11},
  [1254] = {.lex_state = 0, .external_lex_state = 11},
  [1255] = {.lex_state = 0, .external_lex_state = 10},
  [1256] = {.lex_state = 51, .external_lex_state = 21},
  [1257] = {.lex_state = 51, .external_lex_state = 10},
  [1258] = {.lex_state = 0, .external_lex_state = 10},
  [1259] = {.lex_state = 0, .external_lex_state = 10},
  [1260] = {.lex_state = 0, .external_lex_state = 10},
  [1261] = {.lex_state = 0, .external_lex_state = 10},
  [1262] = {.lex_state = 0, .external_lex_state = 12},
  [1263] = {.lex_state = 0, .external_lex_state = 10},
  [1264] = {.lex_state = 51, .external_lex_state = 21},
  [1265] = {.lex_state = 0, .external_lex_state = 10},
  [1266] = {.lex_state = 0, .external_lex_state = 14},
  [1267] = {.lex_state = 0, .external_lex_state = 11},
  [1268] = {.lex_state = 0, .external_lex_state = 11},
  [1269] = {.lex_state = 0, .external_lex_state = 12},
  [1270] = {.lex_state = 0, .external_lex_state = 10},
  [1271] = {.lex_state = 0, .external_lex_state = 11},
  [1272] = {.lex_state = 0, .external_lex_state = 10},
  [1273] = {.lex_state = 0, .external_lex_state = 13},
  [1274] = {.lex_state = 51, .external_lex_state = 21},
  [1275] = {.lex_state = 0, .external_lex_state = 10},
  [1276] = {.lex_state = 0, .external_lex_state = 12},
  [1277] = {.lex_state = 0, .external_lex_state = 10},
  [1278] = {.lex_state = 0, .external_lex_state = 10},
  [1279] = {.lex_state = 0, .external_lex_state = 11},
  [1280] = {.lex_state = 0, .external_lex_state = 10},
  [1281] = {.lex_state = 51, .external_lex_state = 10},
  [1282] = {.lex_state = 0, .external_lex_state = 12},
  [1283] = {.lex_state = 15, .external_lex_state = 10},
  [1284] = {.lex_state = 0, .external_lex_state = 22},
  [1285] = {.lex_state = 0, .external_lex_state = 14},
  [1286] = {.lex_state = 0, .external_lex_state = 13},
  [1287] = {.lex_state = 0, .external_lex_state = 10},
  [1288] = {.lex_state = 0, .external_lex_state = 13},
  [1289] = {.lex_state = 0, .external_lex_state = 12},
  [1290] = {.lex_state = 51, .external_lex_state = 10},
  [1291] = {.lex_state = 0, .external_lex_state = 12},
  [1292] = {.lex_state = 0, .external_lex_state = 10},
  [1293] = {.lex_state = 0, .external_lex_state = 12},
  [1294] = {.lex_state = 0, .external_lex_state = 14},
  [1295] = {.lex_state = 0, .external_lex_state = 10},
  [1296] = {.lex_state = 51, .external_lex_state = 10},
  [1297] = {.lex_state = 0, .external_lex_state = 12},
  [1298] = {.lex_state = 0, .external_lex_state = 13},
  [1299] = {.lex_state = 0, .external_lex_state = 10},
  [1300] = {.lex_state = 0, .external_lex_state = 12},
  [1301] = {.lex_state = 0, .external_lex_state = 10},
  [1302] = {.lex_state = 0, .external_lex_state = 10},
  [1303] = {.lex_state = 0, .external_lex_state = 10},
  [1304] = {.lex_state = 0, .external_lex_state = 10},
  [1305] = {.lex_state = 0, .external_lex_state = 10},
  [1306] = {.lex_state = 0, .external_lex_state = 12},
  [1307] = {.lex_state = 51, .external_lex_state = 10},
  [1308] = {.lex_state = 0, .external_lex_state = 15},
  [1309] = {.lex_state = 51, .external_lex_state = 10},
  [1310] = {.lex_state = 0, .external_lex_state = 10},
  [1311] = {.lex_state = 51, .external_lex_state = 10},
  [1312] = {.lex_state = 51, .external_lex_state = 10},
  [1313] = {.lex_state = 51, .external_lex_state = 10},
  [1314] = {.lex_state = 51, .external_lex_state = 10},
  [1315] = {.lex_state = 0, .external_lex_state = 10},
  [1316] = {.lex_state = 0, .external_lex_state = 15},
  [1317] = {.lex_state = 0, .external_lex_state = 10},
  [1318] = {.lex_state = 0, .external_lex_state = 22},
  [1319] = {.lex_state = 0, .external_lex_state = 15},
  [1320] = {.lex_state = 0, .external_lex_state = 20},
  [1321] = {.lex_state = 0, .external_lex_state = 15},
  [1322] = {.lex_state = 51, .external_lex_state = 10},
  [1323] = {.lex_state = 0, .external_lex_state = 22},
  [1324] = {.lex_state = 51, .external_lex_state = 10},
  [1325] = {.lex_state = 0, .external_lex_state = 15},
  [1326] = {.lex_state = 0, .external_lex_state = 21},
  [1327] = {.lex_state = 0, .external_lex_state = 15},
  [1328] = {.lex_state = 51, .external_lex_state = 10},
  [1329] = {.lex_state = 51, .external_lex_state = 10},
  [1330] = {.lex_state = 0, .external_lex_state = 15},
  [1331] = {.lex_state = 51, .external_lex_state = 10},
  [1332] = {.lex_state = 0, .external_lex_state = 10},
  [1333] = {.lex_state = 0, .external_lex_state = 10},
  [1334] = {.lex_state = 51, .external_lex_state = 10},
  [1335] = {.lex_state = 0, .external_lex_state = 21},
  [1336] = {.lex_state = 0, .external_lex_state = 15},
  [1337] = {.lex_state = 0, .external_lex_state = 22},
  [1338] = {.lex_state = 51, .external_lex_state = 10},
  [1339] = {.lex_state = 51, .external_lex_state = 10},
  [1340] = {.lex_state = 51, .external_lex_state = 10},
  [1341] = {.lex_state = 0, .external_lex_state = 10},
  [1342] = {.lex_state = 51, .external_lex_state = 10},
  [1343] = {.lex_state = 0, .external_lex_state = 22},
  [1344] = {.lex_state = 51, .external_lex_state = 10},
  [1345] = {.lex_state = 0, .external_lex_state = 22},
  [1346] = {.lex_state = 0, .external_lex_state = 15},
  [1347] = {.lex_state = 51, .external_lex_state = 10},
  [1348] = {.lex_state = 0, .external_lex_state = 15},
  [1349] = {.lex_state = 51, .external_lex_state = 10},
  [1350] = {.lex_state = 0, .external_lex_state = 21},
  [1351] = {.lex_state = 51, .external_lex_state = 10},
  [1352] = {.lex_state = 0, .external_lex_state = 22},
  [1353] = {.lex_state = 0, .external_lex_state = 10},
  [1354] = {.lex_state = 0, .external_lex_state = 21},
  [1355] = {.lex_state = 51, .external_lex_state = 10},
  [1356] = {.lex_state = 51, .external_lex_state = 10},
  [1357] = {.lex_state = 0, .external_lex_state = 21},
  [1358] = {.lex_state = 51, .external_lex_state = 10},
  [1359] = {.lex_state = 51, .external_lex_state = 10},
  [1360] = {.lex_state = 0, .external_lex_state = 15},
  [1361] = {.lex_state = 51, .external_lex_state = 10},
  [1362] = {.lex_state = 0, .external_lex_state = 21},
  [1363] = {.lex_state = 0, .external_lex_state = 22},
  [1364] = {.lex_state = 51, .external_lex_state = 10},
  [1365] = {.lex_state = 51, .external_lex_state = 10},
  [1366] = {.lex_state = 51, .external_lex_state = 10},
  [1367] = {.lex_state = 51, .external_lex_state = 10},
  [1368] = {.lex_state = 0, .external_lex_state = 22},
  [1369] = {.lex_state = 0, .external_lex_state = 15},
  [1370] = {.lex_state = 51, .external_lex_state = 10},
  [1371] = {.lex_state = 51, .external_lex_state = 10},
  [1372] = {.lex_state = 51, .external_lex_state = 10},
  [1373] = {.lex_state = 51, .external_lex_state = 10},
  [1374] = {.lex_state = 0, .external_lex_state = 15},
  [1375] = {.lex_state = 0, .external_lex_state = 15},
  [1376] = {.lex_state = 51, .external_lex_state = 10},
  [1377] = {.lex_state = 51, .external_lex_state = 10},
  [1378] = {.lex_state = 0, .external_lex_state = 15},
  [1379] = {.lex_state = 0, .external_lex_state = 10},
  [1380] = {.lex_state = 51, .external_lex_state = 10},
  [1381] = {.lex_state = 0, .external_lex_state = 10},
  [1382] = {.lex_state = 51, .external_lex_state = 10},
  [1383] = {.lex_state = 51, .external_lex_state = 10},
  [1384] = {.lex_state = 0, .external_lex_state = 15},
  [1385] = {.lex_state = 51, .external_lex_state = 10},
  [1386] = {.lex_state = 51, .external_lex_state = 10},
  [1387] = {.lex_state = 51, .external_lex_state = 10},
  [1388] = {.lex_state = 51, .external_lex_state = 10},
  [1389] = {.lex_state = 0, .external_lex_state = 15},
  [1390] = {.lex_state = 51, .external_lex_state = 10},
  [1391] = {.lex_state = 51, .external_lex_state = 10},
  [1392] = {.lex_state = 51, .external_lex_state = 10},
  [1393] = {.lex_state = 51, .external_lex_state = 10},
  [1394] = {.lex_state = 51, .external_lex_state = 10},
  [1395] = {.lex_state = 51, .external_lex_state = 10},
};

enum {
  ts_external_token__newline = 0,
  ts_external_token__indent = 1,
  ts_external_token__dedent = 2,
  ts_external_token__string_start = 3,
  ts_external_token__string_content = 4,
  ts_external_token__string_end = 5,
  ts_external_token_comment = 6,
  ts_external_token_RBRACK = 7,
  ts_external_token_RPAREN = 8,
  ts_external_token_RBRACE = 9,
  ts_external_token_COMMA = 10,
  ts_external_token__body_end = 11,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token__newline] = sym__newline,
  [ts_external_token__indent] = sym__indent,
  [ts_external_token__dedent] = sym__dedent,
  [ts_external_token__string_start] = sym__string_start,
  [ts_external_token__string_content] = sym__string_content,
  [ts_external_token__string_end] = sym__string_end,
  [ts_external_token_comment] = sym_comment,
  [ts_external_token_RBRACK] = anon_sym_RBRACK,
  [ts_external_token_RPAREN] = anon_sym_RPAREN,
  [ts_external_token_RBRACE] = anon_sym_RBRACE,
  [ts_external_token_COMMA] = anon_sym_COMMA,
  [ts_external_token__body_end] = sym__body_end,
};

static const bool ts_external_scanner_states[23][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token__newline] = true,
    [ts_external_token__indent] = true,
    [ts_external_token__dedent] = true,
    [ts_external_token__string_start] = true,
    [ts_external_token__string_content] = true,
    [ts_external_token__string_end] = true,
    [ts_external_token_comment] = true,
    [ts_external_token_RBRACK] = true,
    [ts_external_token_RPAREN] = true,
    [ts_external_token_RBRACE] = true,
    [ts_external_token_COMMA] = true,
    [ts_external_token__body_end] = true,
  },
  [2] = {
    [ts_external_token__string_start] = true,
    [ts_external_token_comment] = true,
  },
  [3] = {
    [ts_external_token__dedent] = true,
    [ts_external_token__string_start] = true,
    [ts_external_token_comment] = true,
    [ts_external_token__body_end] = true,
  },
  [4] = {
    [ts_external_token__newline] = true,
    [ts_external_token__indent] = true,
    [ts_external_token__string_start] = true,
    [ts_external_token_comment] = true,
    [ts_external_token__body_end] = true,
  },
  [5] = {
    [ts_external_token__newline] = true,
    [ts_external_token__string_start] = true,
    [ts_external_token_comment] = true,
    [ts_external_token__body_end] = true,
  },
  [6] = {
    [ts_external_token__newline] = true,
    [ts_external_token_comment] = true,
    [ts_external_token__body_end] = true,
  },
  [7] = {
    [ts_external_token__string_start] = true,
    [ts_external_token_comment] = true,
    [ts_external_token_RBRACE] = true,
  },
  [8] = {
    [ts_external_token__string_start] = true,
    [ts_external_token_comment] = true,
    [ts_external_token_RBRACK] = true,
  },
  [9] = {
    [ts_external_token__string_start] = true,
    [ts_external_token_comment] = true,
    [ts_external_token_RPAREN] = true,
  },
  [10] = {
    [ts_external_token_comment] = true,
  },
  [11] = {
    [ts_external_token_comment] = true,
    [ts_external_token_RPAREN] = true,
    [ts_external_token_COMMA] = true,
  },
  [12] = {
    [ts_external_token_comment] = true,
    [ts_external_token_RBRACE] = true,
    [ts_external_token_COMMA] = true,
  },
  [13] = {
    [ts_external_token_comment] = true,
    [ts_external_token_RBRACK] = true,
    [ts_external_token_COMMA] = true,
  },
  [14] = {
    [ts_external_token_comment] = true,
    [ts_external_token_RBRACK] = true,
  },
  [15] = {
    [ts_external_token_comment] = true,
    [ts_external_token_RPAREN] = true,
  },
  [16] = {
    [ts_external_token__dedent] = true,
    [ts_external_token__string_start] = true,
    [ts_external_token_comment] = true,
  },
  [17] = {
    [ts_external_token__string_content] = true,
    [ts_external_token__string_end] = true,
    [ts_external_token_comment] = true,
  },
  [18] = {
    [ts_external_token_comment] = true,
    [ts_external_token_RBRACE] = true,
  },
  [19] = {
    [ts_external_token__newline] = true,
    [ts_external_token_comment] = true,
    [ts_external_token_COMMA] = true,
    [ts_external_token__body_end] = true,
  },
  [20] = {
    [ts_external_token__indent] = true,
    [ts_external_token_comment] = true,
  },
  [21] = {
    [ts_external_token_comment] = true,
    [ts_external_token_COMMA] = true,
  },
  [22] = {
    [ts_external_token__dedent] = true,
    [ts_external_token_comment] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym__identifier] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(1),
    [sym_false] = ACTIONS(1),
    [sym_null] = ACTIONS(1),
    [sym_underscore] = ACTIONS(1),
    [sym_static_keyword] = ACTIONS(1),
    [anon_sym_remote] = ACTIONS(1),
    [anon_sym_master] = ACTIONS(1),
    [anon_sym_puppet] = ACTIONS(1),
    [anon_sym_remotesync] = ACTIONS(1),
    [anon_sym_mastersync] = ACTIONS(1),
    [anon_sym_puppetsync] = ACTIONS(1),
    [sym_float] = ACTIONS(1),
    [sym_integer] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [sym_node_path] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_AT] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_set] = ACTIONS(1),
    [anon_sym_get] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_setget] = ACTIONS(1),
    [anon_sym_var] = ACTIONS(1),
    [anon_sym_export] = ACTIONS(1),
    [anon_sym_onready] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_pass] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [sym_breakpoint_statement] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [sym_tool_statement] = ACTIONS(1),
    [anon_sym_signal] = ACTIONS(1),
    [anon_sym_class_name] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_extends] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_elif] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_in] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_match] = ACTIONS(1),
    [sym_pattern_open_ending] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_is] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_not] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_await] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_func] = ACTIONS(1),
    [anon_sym__init] = ACTIONS(1),
    [sym__newline] = ACTIONS(1),
    [sym__indent] = ACTIONS(1),
    [sym__dedent] = ACTIONS(1),
    [sym__string_start] = ACTIONS(1),
    [sym__string_content] = ACTIONS(1),
    [sym__string_end] = ACTIONS(1),
    [sym__body_end] = ACTIONS(1),
  },
  [1] = {
    [sym_source] = STATE(1315),
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(791),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym__statement] = STATE(23),
    [sym__simple_statements] = STATE(23),
    [sym_expression_statement] = STATE(892),
    [sym_annotation] = STATE(774),
    [aux_sym__annotations] = STATE(774),
    [sym_annotations] = STATE(1299),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(892),
    [sym_export_variable_statement] = STATE(892),
    [sym_onready_variable_statement] = STATE(892),
    [sym_const_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_pass_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_signal_statement] = STATE(892),
    [sym_class_name_statement] = STATE(892),
    [sym_extends_statement] = STATE(892),
    [sym_if_statement] = STATE(23),
    [sym_for_statement] = STATE(23),
    [sym_while_statement] = STATE(23),
    [sym_class_definition] = STATE(23),
    [sym_enum_definition] = STATE(23),
    [sym_match_statement] = STATE(23),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_function_definition] = STATE(23),
    [sym_constructor_definition] = STATE(23),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [aux_sym_source_repeat1] = STATE(23),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(11),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(35),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(47),
    [anon_sym_for] = ACTIONS(49),
    [anon_sym_while] = ACTIONS(51),
    [anon_sym_class] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_match] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [anon_sym_func] = ACTIONS(71),
    [sym__string_start] = ACTIONS(73),
  },
  [2] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(789),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym__statement] = STATE(9),
    [sym__simple_statements] = STATE(9),
    [sym_expression_statement] = STATE(846),
    [sym_annotation] = STATE(773),
    [aux_sym__annotations] = STATE(773),
    [sym_annotations] = STATE(1099),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(846),
    [sym_export_variable_statement] = STATE(846),
    [sym_onready_variable_statement] = STATE(846),
    [sym_const_statement] = STATE(846),
    [sym_return_statement] = STATE(846),
    [sym_pass_statement] = STATE(846),
    [sym_break_statement] = STATE(846),
    [sym_continue_statement] = STATE(846),
    [sym_signal_statement] = STATE(846),
    [sym_class_name_statement] = STATE(846),
    [sym_extends_statement] = STATE(846),
    [sym_if_statement] = STATE(9),
    [sym_for_statement] = STATE(9),
    [sym_while_statement] = STATE(9),
    [sym_class_definition] = STATE(9),
    [sym_enum_definition] = STATE(9),
    [sym_match_statement] = STATE(9),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_function_definition] = STATE(9),
    [sym_constructor_definition] = STATE(9),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [aux_sym_source_repeat1] = STATE(9),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(75),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_class] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_match] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [anon_sym_func] = ACTIONS(91),
    [sym__dedent] = ACTIONS(93),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(93),
  },
  [3] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(789),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym__statement] = STATE(12),
    [sym__simple_statements] = STATE(12),
    [sym_expression_statement] = STATE(846),
    [sym_annotation] = STATE(773),
    [aux_sym__annotations] = STATE(773),
    [sym_annotations] = STATE(1099),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(846),
    [sym_export_variable_statement] = STATE(846),
    [sym_onready_variable_statement] = STATE(846),
    [sym_const_statement] = STATE(846),
    [sym_return_statement] = STATE(846),
    [sym_pass_statement] = STATE(846),
    [sym_break_statement] = STATE(846),
    [sym_continue_statement] = STATE(846),
    [sym_signal_statement] = STATE(846),
    [sym_class_name_statement] = STATE(846),
    [sym_extends_statement] = STATE(846),
    [sym_if_statement] = STATE(12),
    [sym_for_statement] = STATE(12),
    [sym_while_statement] = STATE(12),
    [sym_class_definition] = STATE(12),
    [sym_enum_definition] = STATE(12),
    [sym_match_statement] = STATE(12),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_function_definition] = STATE(12),
    [sym_constructor_definition] = STATE(12),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [aux_sym_source_repeat1] = STATE(12),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(75),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_class] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_match] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [anon_sym_func] = ACTIONS(91),
    [sym__dedent] = ACTIONS(95),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(95),
  },
  [4] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(789),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym__statement] = STATE(5),
    [sym__simple_statements] = STATE(5),
    [sym_expression_statement] = STATE(846),
    [sym_annotation] = STATE(773),
    [aux_sym__annotations] = STATE(773),
    [sym_annotations] = STATE(1099),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(846),
    [sym_export_variable_statement] = STATE(846),
    [sym_onready_variable_statement] = STATE(846),
    [sym_const_statement] = STATE(846),
    [sym_return_statement] = STATE(846),
    [sym_pass_statement] = STATE(846),
    [sym_break_statement] = STATE(846),
    [sym_continue_statement] = STATE(846),
    [sym_signal_statement] = STATE(846),
    [sym_class_name_statement] = STATE(846),
    [sym_extends_statement] = STATE(846),
    [sym_if_statement] = STATE(5),
    [sym_for_statement] = STATE(5),
    [sym_while_statement] = STATE(5),
    [sym_class_definition] = STATE(5),
    [sym_enum_definition] = STATE(5),
    [sym_match_statement] = STATE(5),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_function_definition] = STATE(5),
    [sym_constructor_definition] = STATE(5),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [aux_sym_source_repeat1] = STATE(5),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(75),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_class] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_match] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [anon_sym_func] = ACTIONS(91),
    [sym__dedent] = ACTIONS(97),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(97),
  },
  [5] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(789),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym__statement] = STATE(16),
    [sym__simple_statements] = STATE(16),
    [sym_expression_statement] = STATE(846),
    [sym_annotation] = STATE(773),
    [aux_sym__annotations] = STATE(773),
    [sym_annotations] = STATE(1099),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(846),
    [sym_export_variable_statement] = STATE(846),
    [sym_onready_variable_statement] = STATE(846),
    [sym_const_statement] = STATE(846),
    [sym_return_statement] = STATE(846),
    [sym_pass_statement] = STATE(846),
    [sym_break_statement] = STATE(846),
    [sym_continue_statement] = STATE(846),
    [sym_signal_statement] = STATE(846),
    [sym_class_name_statement] = STATE(846),
    [sym_extends_statement] = STATE(846),
    [sym_if_statement] = STATE(16),
    [sym_for_statement] = STATE(16),
    [sym_while_statement] = STATE(16),
    [sym_class_definition] = STATE(16),
    [sym_enum_definition] = STATE(16),
    [sym_match_statement] = STATE(16),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_function_definition] = STATE(16),
    [sym_constructor_definition] = STATE(16),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [aux_sym_source_repeat1] = STATE(16),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(75),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_class] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_match] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [anon_sym_func] = ACTIONS(91),
    [sym__dedent] = ACTIONS(99),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(99),
  },
  [6] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(789),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym__statement] = STATE(7),
    [sym__simple_statements] = STATE(7),
    [sym_expression_statement] = STATE(846),
    [sym_annotation] = STATE(773),
    [aux_sym__annotations] = STATE(773),
    [sym_annotations] = STATE(1099),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(846),
    [sym_export_variable_statement] = STATE(846),
    [sym_onready_variable_statement] = STATE(846),
    [sym_const_statement] = STATE(846),
    [sym_return_statement] = STATE(846),
    [sym_pass_statement] = STATE(846),
    [sym_break_statement] = STATE(846),
    [sym_continue_statement] = STATE(846),
    [sym_signal_statement] = STATE(846),
    [sym_class_name_statement] = STATE(846),
    [sym_extends_statement] = STATE(846),
    [sym_if_statement] = STATE(7),
    [sym_for_statement] = STATE(7),
    [sym_while_statement] = STATE(7),
    [sym_class_definition] = STATE(7),
    [sym_enum_definition] = STATE(7),
    [sym_match_statement] = STATE(7),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_function_definition] = STATE(7),
    [sym_constructor_definition] = STATE(7),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [aux_sym_source_repeat1] = STATE(7),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(75),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_class] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_match] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [anon_sym_func] = ACTIONS(91),
    [sym__dedent] = ACTIONS(101),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(101),
  },
  [7] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(789),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym__statement] = STATE(16),
    [sym__simple_statements] = STATE(16),
    [sym_expression_statement] = STATE(846),
    [sym_annotation] = STATE(773),
    [aux_sym__annotations] = STATE(773),
    [sym_annotations] = STATE(1099),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(846),
    [sym_export_variable_statement] = STATE(846),
    [sym_onready_variable_statement] = STATE(846),
    [sym_const_statement] = STATE(846),
    [sym_return_statement] = STATE(846),
    [sym_pass_statement] = STATE(846),
    [sym_break_statement] = STATE(846),
    [sym_continue_statement] = STATE(846),
    [sym_signal_statement] = STATE(846),
    [sym_class_name_statement] = STATE(846),
    [sym_extends_statement] = STATE(846),
    [sym_if_statement] = STATE(16),
    [sym_for_statement] = STATE(16),
    [sym_while_statement] = STATE(16),
    [sym_class_definition] = STATE(16),
    [sym_enum_definition] = STATE(16),
    [sym_match_statement] = STATE(16),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_function_definition] = STATE(16),
    [sym_constructor_definition] = STATE(16),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [aux_sym_source_repeat1] = STATE(16),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(75),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_class] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_match] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [anon_sym_func] = ACTIONS(91),
    [sym__dedent] = ACTIONS(103),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(103),
  },
  [8] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(789),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym__statement] = STATE(10),
    [sym__simple_statements] = STATE(10),
    [sym_expression_statement] = STATE(846),
    [sym_annotation] = STATE(773),
    [aux_sym__annotations] = STATE(773),
    [sym_annotations] = STATE(1099),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(846),
    [sym_export_variable_statement] = STATE(846),
    [sym_onready_variable_statement] = STATE(846),
    [sym_const_statement] = STATE(846),
    [sym_return_statement] = STATE(846),
    [sym_pass_statement] = STATE(846),
    [sym_break_statement] = STATE(846),
    [sym_continue_statement] = STATE(846),
    [sym_signal_statement] = STATE(846),
    [sym_class_name_statement] = STATE(846),
    [sym_extends_statement] = STATE(846),
    [sym_if_statement] = STATE(10),
    [sym_for_statement] = STATE(10),
    [sym_while_statement] = STATE(10),
    [sym_class_definition] = STATE(10),
    [sym_enum_definition] = STATE(10),
    [sym_match_statement] = STATE(10),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_function_definition] = STATE(10),
    [sym_constructor_definition] = STATE(10),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [aux_sym_source_repeat1] = STATE(10),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(75),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_class] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_match] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [anon_sym_func] = ACTIONS(91),
    [sym__dedent] = ACTIONS(105),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(105),
  },
  [9] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(789),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym__statement] = STATE(16),
    [sym__simple_statements] = STATE(16),
    [sym_expression_statement] = STATE(846),
    [sym_annotation] = STATE(773),
    [aux_sym__annotations] = STATE(773),
    [sym_annotations] = STATE(1099),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(846),
    [sym_export_variable_statement] = STATE(846),
    [sym_onready_variable_statement] = STATE(846),
    [sym_const_statement] = STATE(846),
    [sym_return_statement] = STATE(846),
    [sym_pass_statement] = STATE(846),
    [sym_break_statement] = STATE(846),
    [sym_continue_statement] = STATE(846),
    [sym_signal_statement] = STATE(846),
    [sym_class_name_statement] = STATE(846),
    [sym_extends_statement] = STATE(846),
    [sym_if_statement] = STATE(16),
    [sym_for_statement] = STATE(16),
    [sym_while_statement] = STATE(16),
    [sym_class_definition] = STATE(16),
    [sym_enum_definition] = STATE(16),
    [sym_match_statement] = STATE(16),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_function_definition] = STATE(16),
    [sym_constructor_definition] = STATE(16),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [aux_sym_source_repeat1] = STATE(16),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(75),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_class] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_match] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [anon_sym_func] = ACTIONS(91),
    [sym__dedent] = ACTIONS(107),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(107),
  },
  [10] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(789),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym__statement] = STATE(16),
    [sym__simple_statements] = STATE(16),
    [sym_expression_statement] = STATE(846),
    [sym_annotation] = STATE(773),
    [aux_sym__annotations] = STATE(773),
    [sym_annotations] = STATE(1099),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(846),
    [sym_export_variable_statement] = STATE(846),
    [sym_onready_variable_statement] = STATE(846),
    [sym_const_statement] = STATE(846),
    [sym_return_statement] = STATE(846),
    [sym_pass_statement] = STATE(846),
    [sym_break_statement] = STATE(846),
    [sym_continue_statement] = STATE(846),
    [sym_signal_statement] = STATE(846),
    [sym_class_name_statement] = STATE(846),
    [sym_extends_statement] = STATE(846),
    [sym_if_statement] = STATE(16),
    [sym_for_statement] = STATE(16),
    [sym_while_statement] = STATE(16),
    [sym_class_definition] = STATE(16),
    [sym_enum_definition] = STATE(16),
    [sym_match_statement] = STATE(16),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_function_definition] = STATE(16),
    [sym_constructor_definition] = STATE(16),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [aux_sym_source_repeat1] = STATE(16),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(75),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_class] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_match] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [anon_sym_func] = ACTIONS(91),
    [sym__dedent] = ACTIONS(109),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(109),
  },
  [11] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(789),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym__statement] = STATE(16),
    [sym__simple_statements] = STATE(16),
    [sym_expression_statement] = STATE(846),
    [sym_annotation] = STATE(773),
    [aux_sym__annotations] = STATE(773),
    [sym_annotations] = STATE(1099),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(846),
    [sym_export_variable_statement] = STATE(846),
    [sym_onready_variable_statement] = STATE(846),
    [sym_const_statement] = STATE(846),
    [sym_return_statement] = STATE(846),
    [sym_pass_statement] = STATE(846),
    [sym_break_statement] = STATE(846),
    [sym_continue_statement] = STATE(846),
    [sym_signal_statement] = STATE(846),
    [sym_class_name_statement] = STATE(846),
    [sym_extends_statement] = STATE(846),
    [sym_if_statement] = STATE(16),
    [sym_for_statement] = STATE(16),
    [sym_while_statement] = STATE(16),
    [sym_class_definition] = STATE(16),
    [sym_enum_definition] = STATE(16),
    [sym_match_statement] = STATE(16),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_function_definition] = STATE(16),
    [sym_constructor_definition] = STATE(16),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [aux_sym_source_repeat1] = STATE(16),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(75),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_class] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_match] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [anon_sym_func] = ACTIONS(91),
    [sym__dedent] = ACTIONS(111),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(111),
  },
  [12] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(789),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym__statement] = STATE(16),
    [sym__simple_statements] = STATE(16),
    [sym_expression_statement] = STATE(846),
    [sym_annotation] = STATE(773),
    [aux_sym__annotations] = STATE(773),
    [sym_annotations] = STATE(1099),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(846),
    [sym_export_variable_statement] = STATE(846),
    [sym_onready_variable_statement] = STATE(846),
    [sym_const_statement] = STATE(846),
    [sym_return_statement] = STATE(846),
    [sym_pass_statement] = STATE(846),
    [sym_break_statement] = STATE(846),
    [sym_continue_statement] = STATE(846),
    [sym_signal_statement] = STATE(846),
    [sym_class_name_statement] = STATE(846),
    [sym_extends_statement] = STATE(846),
    [sym_if_statement] = STATE(16),
    [sym_for_statement] = STATE(16),
    [sym_while_statement] = STATE(16),
    [sym_class_definition] = STATE(16),
    [sym_enum_definition] = STATE(16),
    [sym_match_statement] = STATE(16),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_function_definition] = STATE(16),
    [sym_constructor_definition] = STATE(16),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [aux_sym_source_repeat1] = STATE(16),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(75),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_class] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_match] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [anon_sym_func] = ACTIONS(91),
    [sym__dedent] = ACTIONS(113),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(113),
  },
  [13] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(789),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym__statement] = STATE(11),
    [sym__simple_statements] = STATE(11),
    [sym_expression_statement] = STATE(846),
    [sym_annotation] = STATE(773),
    [aux_sym__annotations] = STATE(773),
    [sym_annotations] = STATE(1099),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(846),
    [sym_export_variable_statement] = STATE(846),
    [sym_onready_variable_statement] = STATE(846),
    [sym_const_statement] = STATE(846),
    [sym_return_statement] = STATE(846),
    [sym_pass_statement] = STATE(846),
    [sym_break_statement] = STATE(846),
    [sym_continue_statement] = STATE(846),
    [sym_signal_statement] = STATE(846),
    [sym_class_name_statement] = STATE(846),
    [sym_extends_statement] = STATE(846),
    [sym_if_statement] = STATE(11),
    [sym_for_statement] = STATE(11),
    [sym_while_statement] = STATE(11),
    [sym_class_definition] = STATE(11),
    [sym_enum_definition] = STATE(11),
    [sym_match_statement] = STATE(11),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_function_definition] = STATE(11),
    [sym_constructor_definition] = STATE(11),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [aux_sym_source_repeat1] = STATE(11),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(75),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_class] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_match] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [anon_sym_func] = ACTIONS(91),
    [sym__dedent] = ACTIONS(115),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(115),
  },
  [14] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(789),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym__statement] = STATE(21),
    [sym__simple_statements] = STATE(21),
    [sym_expression_statement] = STATE(846),
    [sym_annotation] = STATE(773),
    [aux_sym__annotations] = STATE(773),
    [sym_annotations] = STATE(1099),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(846),
    [sym_export_variable_statement] = STATE(846),
    [sym_onready_variable_statement] = STATE(846),
    [sym_const_statement] = STATE(846),
    [sym_return_statement] = STATE(846),
    [sym_pass_statement] = STATE(846),
    [sym_break_statement] = STATE(846),
    [sym_continue_statement] = STATE(846),
    [sym_signal_statement] = STATE(846),
    [sym_class_name_statement] = STATE(846),
    [sym_extends_statement] = STATE(846),
    [sym_if_statement] = STATE(21),
    [sym_for_statement] = STATE(21),
    [sym_while_statement] = STATE(21),
    [sym_class_definition] = STATE(21),
    [sym_enum_definition] = STATE(21),
    [sym_match_statement] = STATE(21),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_function_definition] = STATE(21),
    [sym_constructor_definition] = STATE(21),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [aux_sym_source_repeat1] = STATE(21),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(75),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_class] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_match] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [anon_sym_func] = ACTIONS(91),
    [sym__dedent] = ACTIONS(117),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(117),
  },
  [15] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(789),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym__statement] = STATE(16),
    [sym__simple_statements] = STATE(16),
    [sym_expression_statement] = STATE(846),
    [sym_annotation] = STATE(773),
    [aux_sym__annotations] = STATE(773),
    [sym_annotations] = STATE(1099),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(846),
    [sym_export_variable_statement] = STATE(846),
    [sym_onready_variable_statement] = STATE(846),
    [sym_const_statement] = STATE(846),
    [sym_return_statement] = STATE(846),
    [sym_pass_statement] = STATE(846),
    [sym_break_statement] = STATE(846),
    [sym_continue_statement] = STATE(846),
    [sym_signal_statement] = STATE(846),
    [sym_class_name_statement] = STATE(846),
    [sym_extends_statement] = STATE(846),
    [sym_if_statement] = STATE(16),
    [sym_for_statement] = STATE(16),
    [sym_while_statement] = STATE(16),
    [sym_class_definition] = STATE(16),
    [sym_enum_definition] = STATE(16),
    [sym_match_statement] = STATE(16),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_function_definition] = STATE(16),
    [sym_constructor_definition] = STATE(16),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [aux_sym_source_repeat1] = STATE(16),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(75),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_class] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_match] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [anon_sym_func] = ACTIONS(91),
    [sym__dedent] = ACTIONS(119),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(119),
  },
  [16] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(789),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym__statement] = STATE(16),
    [sym__simple_statements] = STATE(16),
    [sym_expression_statement] = STATE(846),
    [sym_annotation] = STATE(773),
    [aux_sym__annotations] = STATE(773),
    [sym_annotations] = STATE(1099),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(846),
    [sym_export_variable_statement] = STATE(846),
    [sym_onready_variable_statement] = STATE(846),
    [sym_const_statement] = STATE(846),
    [sym_return_statement] = STATE(846),
    [sym_pass_statement] = STATE(846),
    [sym_break_statement] = STATE(846),
    [sym_continue_statement] = STATE(846),
    [sym_signal_statement] = STATE(846),
    [sym_class_name_statement] = STATE(846),
    [sym_extends_statement] = STATE(846),
    [sym_if_statement] = STATE(16),
    [sym_for_statement] = STATE(16),
    [sym_while_statement] = STATE(16),
    [sym_class_definition] = STATE(16),
    [sym_enum_definition] = STATE(16),
    [sym_match_statement] = STATE(16),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_function_definition] = STATE(16),
    [sym_constructor_definition] = STATE(16),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [aux_sym_source_repeat1] = STATE(16),
    [sym__identifier] = ACTIONS(121),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(124),
    [sym_false] = ACTIONS(124),
    [sym_null] = ACTIONS(124),
    [sym_static_keyword] = ACTIONS(127),
    [anon_sym_remote] = ACTIONS(130),
    [anon_sym_master] = ACTIONS(130),
    [anon_sym_puppet] = ACTIONS(130),
    [anon_sym_remotesync] = ACTIONS(130),
    [anon_sym_mastersync] = ACTIONS(130),
    [anon_sym_puppetsync] = ACTIONS(130),
    [sym_float] = ACTIONS(133),
    [sym_integer] = ACTIONS(124),
    [anon_sym_AMP] = ACTIONS(136),
    [sym_node_path] = ACTIONS(133),
    [sym_get_node] = ACTIONS(133),
    [anon_sym_AT] = ACTIONS(139),
    [anon_sym_var] = ACTIONS(142),
    [anon_sym_export] = ACTIONS(145),
    [anon_sym_onready] = ACTIONS(148),
    [anon_sym_const] = ACTIONS(151),
    [anon_sym_return] = ACTIONS(154),
    [anon_sym_pass] = ACTIONS(157),
    [anon_sym_break] = ACTIONS(160),
    [sym_breakpoint_statement] = ACTIONS(163),
    [anon_sym_continue] = ACTIONS(166),
    [sym_tool_statement] = ACTIONS(163),
    [anon_sym_signal] = ACTIONS(169),
    [anon_sym_class_name] = ACTIONS(172),
    [anon_sym_DOT] = ACTIONS(175),
    [anon_sym_extends] = ACTIONS(178),
    [anon_sym_if] = ACTIONS(181),
    [anon_sym_for] = ACTIONS(184),
    [anon_sym_while] = ACTIONS(187),
    [anon_sym_class] = ACTIONS(190),
    [anon_sym_enum] = ACTIONS(193),
    [anon_sym_LBRACE] = ACTIONS(196),
    [anon_sym_match] = ACTIONS(199),
    [anon_sym_LBRACK] = ACTIONS(202),
    [anon_sym_PLUS] = ACTIONS(205),
    [anon_sym_DASH] = ACTIONS(205),
    [anon_sym_not] = ACTIONS(208),
    [anon_sym_BANG] = ACTIONS(205),
    [anon_sym_TILDE] = ACTIONS(205),
    [anon_sym_LPAREN] = ACTIONS(211),
    [anon_sym_await] = ACTIONS(214),
    [anon_sym_func] = ACTIONS(217),
    [sym__dedent] = ACTIONS(220),
    [sym__string_start] = ACTIONS(222),
    [sym__body_end] = ACTIONS(220),
  },
  [17] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(789),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym__statement] = STATE(16),
    [sym__simple_statements] = STATE(16),
    [sym_expression_statement] = STATE(846),
    [sym_annotation] = STATE(773),
    [aux_sym__annotations] = STATE(773),
    [sym_annotations] = STATE(1099),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(846),
    [sym_export_variable_statement] = STATE(846),
    [sym_onready_variable_statement] = STATE(846),
    [sym_const_statement] = STATE(846),
    [sym_return_statement] = STATE(846),
    [sym_pass_statement] = STATE(846),
    [sym_break_statement] = STATE(846),
    [sym_continue_statement] = STATE(846),
    [sym_signal_statement] = STATE(846),
    [sym_class_name_statement] = STATE(846),
    [sym_extends_statement] = STATE(846),
    [sym_if_statement] = STATE(16),
    [sym_for_statement] = STATE(16),
    [sym_while_statement] = STATE(16),
    [sym_class_definition] = STATE(16),
    [sym_enum_definition] = STATE(16),
    [sym_match_statement] = STATE(16),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_function_definition] = STATE(16),
    [sym_constructor_definition] = STATE(16),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [aux_sym_source_repeat1] = STATE(16),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(75),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_class] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_match] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [anon_sym_func] = ACTIONS(91),
    [sym__dedent] = ACTIONS(225),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(225),
  },
  [18] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(789),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym__statement] = STATE(17),
    [sym__simple_statements] = STATE(17),
    [sym_expression_statement] = STATE(846),
    [sym_annotation] = STATE(773),
    [aux_sym__annotations] = STATE(773),
    [sym_annotations] = STATE(1099),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(846),
    [sym_export_variable_statement] = STATE(846),
    [sym_onready_variable_statement] = STATE(846),
    [sym_const_statement] = STATE(846),
    [sym_return_statement] = STATE(846),
    [sym_pass_statement] = STATE(846),
    [sym_break_statement] = STATE(846),
    [sym_continue_statement] = STATE(846),
    [sym_signal_statement] = STATE(846),
    [sym_class_name_statement] = STATE(846),
    [sym_extends_statement] = STATE(846),
    [sym_if_statement] = STATE(17),
    [sym_for_statement] = STATE(17),
    [sym_while_statement] = STATE(17),
    [sym_class_definition] = STATE(17),
    [sym_enum_definition] = STATE(17),
    [sym_match_statement] = STATE(17),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_function_definition] = STATE(17),
    [sym_constructor_definition] = STATE(17),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [aux_sym_source_repeat1] = STATE(17),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(75),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_class] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_match] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [anon_sym_func] = ACTIONS(91),
    [sym__dedent] = ACTIONS(227),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(227),
  },
  [19] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(789),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym__statement] = STATE(15),
    [sym__simple_statements] = STATE(15),
    [sym_expression_statement] = STATE(846),
    [sym_annotation] = STATE(773),
    [aux_sym__annotations] = STATE(773),
    [sym_annotations] = STATE(1099),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(846),
    [sym_export_variable_statement] = STATE(846),
    [sym_onready_variable_statement] = STATE(846),
    [sym_const_statement] = STATE(846),
    [sym_return_statement] = STATE(846),
    [sym_pass_statement] = STATE(846),
    [sym_break_statement] = STATE(846),
    [sym_continue_statement] = STATE(846),
    [sym_signal_statement] = STATE(846),
    [sym_class_name_statement] = STATE(846),
    [sym_extends_statement] = STATE(846),
    [sym_if_statement] = STATE(15),
    [sym_for_statement] = STATE(15),
    [sym_while_statement] = STATE(15),
    [sym_class_definition] = STATE(15),
    [sym_enum_definition] = STATE(15),
    [sym_match_statement] = STATE(15),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_function_definition] = STATE(15),
    [sym_constructor_definition] = STATE(15),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [aux_sym_source_repeat1] = STATE(15),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(75),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_class] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_match] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [anon_sym_func] = ACTIONS(91),
    [sym__dedent] = ACTIONS(229),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(229),
  },
  [20] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(789),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym__statement] = STATE(16),
    [sym__simple_statements] = STATE(16),
    [sym_expression_statement] = STATE(846),
    [sym_annotation] = STATE(773),
    [aux_sym__annotations] = STATE(773),
    [sym_annotations] = STATE(1099),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(846),
    [sym_export_variable_statement] = STATE(846),
    [sym_onready_variable_statement] = STATE(846),
    [sym_const_statement] = STATE(846),
    [sym_return_statement] = STATE(846),
    [sym_pass_statement] = STATE(846),
    [sym_break_statement] = STATE(846),
    [sym_continue_statement] = STATE(846),
    [sym_signal_statement] = STATE(846),
    [sym_class_name_statement] = STATE(846),
    [sym_extends_statement] = STATE(846),
    [sym_if_statement] = STATE(16),
    [sym_for_statement] = STATE(16),
    [sym_while_statement] = STATE(16),
    [sym_class_definition] = STATE(16),
    [sym_enum_definition] = STATE(16),
    [sym_match_statement] = STATE(16),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_function_definition] = STATE(16),
    [sym_constructor_definition] = STATE(16),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [aux_sym_source_repeat1] = STATE(16),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(75),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_class] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_match] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [anon_sym_func] = ACTIONS(91),
    [sym__dedent] = ACTIONS(231),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(231),
  },
  [21] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(789),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym__statement] = STATE(16),
    [sym__simple_statements] = STATE(16),
    [sym_expression_statement] = STATE(846),
    [sym_annotation] = STATE(773),
    [aux_sym__annotations] = STATE(773),
    [sym_annotations] = STATE(1099),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(846),
    [sym_export_variable_statement] = STATE(846),
    [sym_onready_variable_statement] = STATE(846),
    [sym_const_statement] = STATE(846),
    [sym_return_statement] = STATE(846),
    [sym_pass_statement] = STATE(846),
    [sym_break_statement] = STATE(846),
    [sym_continue_statement] = STATE(846),
    [sym_signal_statement] = STATE(846),
    [sym_class_name_statement] = STATE(846),
    [sym_extends_statement] = STATE(846),
    [sym_if_statement] = STATE(16),
    [sym_for_statement] = STATE(16),
    [sym_while_statement] = STATE(16),
    [sym_class_definition] = STATE(16),
    [sym_enum_definition] = STATE(16),
    [sym_match_statement] = STATE(16),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_function_definition] = STATE(16),
    [sym_constructor_definition] = STATE(16),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [aux_sym_source_repeat1] = STATE(16),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(75),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_class] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_match] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [anon_sym_func] = ACTIONS(91),
    [sym__dedent] = ACTIONS(233),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(233),
  },
  [22] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(789),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym__statement] = STATE(20),
    [sym__simple_statements] = STATE(20),
    [sym_expression_statement] = STATE(846),
    [sym_annotation] = STATE(773),
    [aux_sym__annotations] = STATE(773),
    [sym_annotations] = STATE(1099),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(846),
    [sym_export_variable_statement] = STATE(846),
    [sym_onready_variable_statement] = STATE(846),
    [sym_const_statement] = STATE(846),
    [sym_return_statement] = STATE(846),
    [sym_pass_statement] = STATE(846),
    [sym_break_statement] = STATE(846),
    [sym_continue_statement] = STATE(846),
    [sym_signal_statement] = STATE(846),
    [sym_class_name_statement] = STATE(846),
    [sym_extends_statement] = STATE(846),
    [sym_if_statement] = STATE(20),
    [sym_for_statement] = STATE(20),
    [sym_while_statement] = STATE(20),
    [sym_class_definition] = STATE(20),
    [sym_enum_definition] = STATE(20),
    [sym_match_statement] = STATE(20),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_function_definition] = STATE(20),
    [sym_constructor_definition] = STATE(20),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [aux_sym_source_repeat1] = STATE(20),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(75),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(79),
    [anon_sym_for] = ACTIONS(81),
    [anon_sym_while] = ACTIONS(83),
    [anon_sym_class] = ACTIONS(85),
    [anon_sym_enum] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_match] = ACTIONS(89),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [anon_sym_func] = ACTIONS(91),
    [sym__dedent] = ACTIONS(235),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(235),
  },
  [23] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(791),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym__statement] = STATE(24),
    [sym__simple_statements] = STATE(24),
    [sym_expression_statement] = STATE(892),
    [sym_annotation] = STATE(774),
    [aux_sym__annotations] = STATE(774),
    [sym_annotations] = STATE(1299),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(892),
    [sym_export_variable_statement] = STATE(892),
    [sym_onready_variable_statement] = STATE(892),
    [sym_const_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_pass_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_signal_statement] = STATE(892),
    [sym_class_name_statement] = STATE(892),
    [sym_extends_statement] = STATE(892),
    [sym_if_statement] = STATE(24),
    [sym_for_statement] = STATE(24),
    [sym_while_statement] = STATE(24),
    [sym_class_definition] = STATE(24),
    [sym_enum_definition] = STATE(24),
    [sym_match_statement] = STATE(24),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_function_definition] = STATE(24),
    [sym_constructor_definition] = STATE(24),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [aux_sym_source_repeat1] = STATE(24),
    [ts_builtin_sym_end] = ACTIONS(237),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [sym_static_keyword] = ACTIONS(11),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(35),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_if] = ACTIONS(47),
    [anon_sym_for] = ACTIONS(49),
    [anon_sym_while] = ACTIONS(51),
    [anon_sym_class] = ACTIONS(53),
    [anon_sym_enum] = ACTIONS(55),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_match] = ACTIONS(59),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [anon_sym_func] = ACTIONS(71),
    [sym__string_start] = ACTIONS(73),
  },
  [24] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(791),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym__statement] = STATE(24),
    [sym__simple_statements] = STATE(24),
    [sym_expression_statement] = STATE(892),
    [sym_annotation] = STATE(774),
    [aux_sym__annotations] = STATE(774),
    [sym_annotations] = STATE(1299),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(892),
    [sym_export_variable_statement] = STATE(892),
    [sym_onready_variable_statement] = STATE(892),
    [sym_const_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_pass_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_signal_statement] = STATE(892),
    [sym_class_name_statement] = STATE(892),
    [sym_extends_statement] = STATE(892),
    [sym_if_statement] = STATE(24),
    [sym_for_statement] = STATE(24),
    [sym_while_statement] = STATE(24),
    [sym_class_definition] = STATE(24),
    [sym_enum_definition] = STATE(24),
    [sym_match_statement] = STATE(24),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_function_definition] = STATE(24),
    [sym_constructor_definition] = STATE(24),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [aux_sym_source_repeat1] = STATE(24),
    [ts_builtin_sym_end] = ACTIONS(220),
    [sym__identifier] = ACTIONS(121),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(124),
    [sym_false] = ACTIONS(124),
    [sym_null] = ACTIONS(124),
    [sym_static_keyword] = ACTIONS(239),
    [anon_sym_remote] = ACTIONS(130),
    [anon_sym_master] = ACTIONS(130),
    [anon_sym_puppet] = ACTIONS(130),
    [anon_sym_remotesync] = ACTIONS(130),
    [anon_sym_mastersync] = ACTIONS(130),
    [anon_sym_puppetsync] = ACTIONS(130),
    [sym_float] = ACTIONS(133),
    [sym_integer] = ACTIONS(124),
    [anon_sym_AMP] = ACTIONS(136),
    [sym_node_path] = ACTIONS(133),
    [sym_get_node] = ACTIONS(133),
    [anon_sym_AT] = ACTIONS(139),
    [anon_sym_var] = ACTIONS(142),
    [anon_sym_export] = ACTIONS(145),
    [anon_sym_onready] = ACTIONS(148),
    [anon_sym_const] = ACTIONS(151),
    [anon_sym_return] = ACTIONS(154),
    [anon_sym_pass] = ACTIONS(157),
    [anon_sym_break] = ACTIONS(160),
    [sym_breakpoint_statement] = ACTIONS(242),
    [anon_sym_continue] = ACTIONS(166),
    [sym_tool_statement] = ACTIONS(242),
    [anon_sym_signal] = ACTIONS(169),
    [anon_sym_class_name] = ACTIONS(172),
    [anon_sym_DOT] = ACTIONS(175),
    [anon_sym_extends] = ACTIONS(178),
    [anon_sym_if] = ACTIONS(245),
    [anon_sym_for] = ACTIONS(248),
    [anon_sym_while] = ACTIONS(251),
    [anon_sym_class] = ACTIONS(254),
    [anon_sym_enum] = ACTIONS(257),
    [anon_sym_LBRACE] = ACTIONS(196),
    [anon_sym_match] = ACTIONS(260),
    [anon_sym_LBRACK] = ACTIONS(202),
    [anon_sym_PLUS] = ACTIONS(205),
    [anon_sym_DASH] = ACTIONS(205),
    [anon_sym_not] = ACTIONS(208),
    [anon_sym_BANG] = ACTIONS(205),
    [anon_sym_TILDE] = ACTIONS(205),
    [anon_sym_LPAREN] = ACTIONS(211),
    [anon_sym_await] = ACTIONS(214),
    [anon_sym_func] = ACTIONS(263),
    [sym__string_start] = ACTIONS(222),
  },
  [25] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(1384),
    [sym__simple_statements] = STATE(1346),
    [sym_expression_statement] = STATE(899),
    [sym_annotation] = STATE(780),
    [aux_sym__annotations] = STATE(780),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(899),
    [sym_export_variable_statement] = STATE(899),
    [sym_onready_variable_statement] = STATE(899),
    [sym_const_statement] = STATE(899),
    [sym_return_statement] = STATE(899),
    [sym_pass_statement] = STATE(899),
    [sym_break_statement] = STATE(899),
    [sym_continue_statement] = STATE(899),
    [sym_signal_statement] = STATE(899),
    [sym_class_name_statement] = STATE(899),
    [sym_extends_statement] = STATE(899),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(266),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(266),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(268),
    [sym__indent] = ACTIONS(270),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(268),
  },
  [26] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(1378),
    [sym__simple_statements] = STATE(1346),
    [sym_expression_statement] = STATE(899),
    [sym_annotation] = STATE(780),
    [aux_sym__annotations] = STATE(780),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(899),
    [sym_export_variable_statement] = STATE(899),
    [sym_onready_variable_statement] = STATE(899),
    [sym_const_statement] = STATE(899),
    [sym_return_statement] = STATE(899),
    [sym_pass_statement] = STATE(899),
    [sym_break_statement] = STATE(899),
    [sym_continue_statement] = STATE(899),
    [sym_signal_statement] = STATE(899),
    [sym_class_name_statement] = STATE(899),
    [sym_extends_statement] = STATE(899),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(266),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(266),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(268),
    [sym__indent] = ACTIONS(270),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(268),
  },
  [27] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(199),
    [sym__simple_statements] = STATE(135),
    [sym_expression_statement] = STATE(892),
    [sym_annotation] = STATE(774),
    [aux_sym__annotations] = STATE(774),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(892),
    [sym_export_variable_statement] = STATE(892),
    [sym_onready_variable_statement] = STATE(892),
    [sym_const_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_pass_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_signal_statement] = STATE(892),
    [sym_class_name_statement] = STATE(892),
    [sym_extends_statement] = STATE(892),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(35),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(272),
    [sym__indent] = ACTIONS(274),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(272),
  },
  [28] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(173),
    [sym__simple_statements] = STATE(135),
    [sym_expression_statement] = STATE(892),
    [sym_annotation] = STATE(774),
    [aux_sym__annotations] = STATE(774),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(892),
    [sym_export_variable_statement] = STATE(892),
    [sym_onready_variable_statement] = STATE(892),
    [sym_const_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_pass_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_signal_statement] = STATE(892),
    [sym_class_name_statement] = STATE(892),
    [sym_extends_statement] = STATE(892),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(35),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(272),
    [sym__indent] = ACTIONS(274),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(272),
  },
  [29] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(168),
    [sym__simple_statements] = STATE(130),
    [sym_expression_statement] = STATE(846),
    [sym_annotation] = STATE(773),
    [aux_sym__annotations] = STATE(773),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(846),
    [sym_export_variable_statement] = STATE(846),
    [sym_onready_variable_statement] = STATE(846),
    [sym_const_statement] = STATE(846),
    [sym_return_statement] = STATE(846),
    [sym_pass_statement] = STATE(846),
    [sym_break_statement] = STATE(846),
    [sym_continue_statement] = STATE(846),
    [sym_signal_statement] = STATE(846),
    [sym_class_name_statement] = STATE(846),
    [sym_extends_statement] = STATE(846),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(276),
    [sym__indent] = ACTIONS(278),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(276),
  },
  [30] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(1273),
    [sym__simple_statements] = STATE(1153),
    [sym_expression_statement] = STATE(885),
    [sym_annotation] = STATE(775),
    [aux_sym__annotations] = STATE(775),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(885),
    [sym_export_variable_statement] = STATE(885),
    [sym_onready_variable_statement] = STATE(885),
    [sym_const_statement] = STATE(885),
    [sym_return_statement] = STATE(885),
    [sym_pass_statement] = STATE(885),
    [sym_break_statement] = STATE(885),
    [sym_continue_statement] = STATE(885),
    [sym_signal_statement] = STATE(885),
    [sym_class_name_statement] = STATE(885),
    [sym_extends_statement] = STATE(885),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(280),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(280),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(282),
    [sym__indent] = ACTIONS(284),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(282),
  },
  [31] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(1198),
    [sym__simple_statements] = STATE(972),
    [sym_expression_statement] = STATE(876),
    [sym_annotation] = STATE(784),
    [aux_sym__annotations] = STATE(784),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(876),
    [sym_export_variable_statement] = STATE(876),
    [sym_onready_variable_statement] = STATE(876),
    [sym_const_statement] = STATE(876),
    [sym_return_statement] = STATE(876),
    [sym_pass_statement] = STATE(876),
    [sym_break_statement] = STATE(876),
    [sym_continue_statement] = STATE(876),
    [sym_signal_statement] = STATE(876),
    [sym_class_name_statement] = STATE(876),
    [sym_extends_statement] = STATE(876),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(286),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(286),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(288),
    [sym__indent] = ACTIONS(290),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(288),
  },
  [32] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(153),
    [sym__simple_statements] = STATE(130),
    [sym_expression_statement] = STATE(846),
    [sym_annotation] = STATE(773),
    [aux_sym__annotations] = STATE(773),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(846),
    [sym_export_variable_statement] = STATE(846),
    [sym_onready_variable_statement] = STATE(846),
    [sym_const_statement] = STATE(846),
    [sym_return_statement] = STATE(846),
    [sym_pass_statement] = STATE(846),
    [sym_break_statement] = STATE(846),
    [sym_continue_statement] = STATE(846),
    [sym_signal_statement] = STATE(846),
    [sym_class_name_statement] = STATE(846),
    [sym_extends_statement] = STATE(846),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(276),
    [sym__indent] = ACTIONS(278),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(276),
  },
  [33] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(193),
    [sym__simple_statements] = STATE(135),
    [sym_expression_statement] = STATE(892),
    [sym_annotation] = STATE(774),
    [aux_sym__annotations] = STATE(774),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(892),
    [sym_export_variable_statement] = STATE(892),
    [sym_onready_variable_statement] = STATE(892),
    [sym_const_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_pass_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_signal_statement] = STATE(892),
    [sym_class_name_statement] = STATE(892),
    [sym_extends_statement] = STATE(892),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(35),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(272),
    [sym__indent] = ACTIONS(274),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(272),
  },
  [34] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(191),
    [sym__simple_statements] = STATE(135),
    [sym_expression_statement] = STATE(892),
    [sym_annotation] = STATE(774),
    [aux_sym__annotations] = STATE(774),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(892),
    [sym_export_variable_statement] = STATE(892),
    [sym_onready_variable_statement] = STATE(892),
    [sym_const_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_pass_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_signal_statement] = STATE(892),
    [sym_class_name_statement] = STATE(892),
    [sym_extends_statement] = STATE(892),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(35),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(272),
    [sym__indent] = ACTIONS(274),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(272),
  },
  [35] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(194),
    [sym__simple_statements] = STATE(135),
    [sym_expression_statement] = STATE(892),
    [sym_annotation] = STATE(774),
    [aux_sym__annotations] = STATE(774),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(892),
    [sym_export_variable_statement] = STATE(892),
    [sym_onready_variable_statement] = STATE(892),
    [sym_const_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_pass_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_signal_statement] = STATE(892),
    [sym_class_name_statement] = STATE(892),
    [sym_extends_statement] = STATE(892),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(35),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(272),
    [sym__indent] = ACTIONS(274),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(272),
  },
  [36] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(818),
    [sym__simple_statements] = STATE(839),
    [sym_expression_statement] = STATE(864),
    [sym_annotation] = STATE(785),
    [aux_sym__annotations] = STATE(785),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(864),
    [sym_export_variable_statement] = STATE(864),
    [sym_onready_variable_statement] = STATE(864),
    [sym_const_statement] = STATE(864),
    [sym_return_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_signal_statement] = STATE(864),
    [sym_class_name_statement] = STATE(864),
    [sym_extends_statement] = STATE(864),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(292),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(292),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(294),
    [sym__indent] = ACTIONS(296),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(294),
  },
  [37] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(187),
    [sym__simple_statements] = STATE(135),
    [sym_expression_statement] = STATE(892),
    [sym_annotation] = STATE(774),
    [aux_sym__annotations] = STATE(774),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(892),
    [sym_export_variable_statement] = STATE(892),
    [sym_onready_variable_statement] = STATE(892),
    [sym_const_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_pass_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_signal_statement] = STATE(892),
    [sym_class_name_statement] = STATE(892),
    [sym_extends_statement] = STATE(892),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(35),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(272),
    [sym__indent] = ACTIONS(274),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(272),
  },
  [38] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(201),
    [sym__simple_statements] = STATE(135),
    [sym_expression_statement] = STATE(892),
    [sym_annotation] = STATE(774),
    [aux_sym__annotations] = STATE(774),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(892),
    [sym_export_variable_statement] = STATE(892),
    [sym_onready_variable_statement] = STATE(892),
    [sym_const_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_pass_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_signal_statement] = STATE(892),
    [sym_class_name_statement] = STATE(892),
    [sym_extends_statement] = STATE(892),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(35),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(272),
    [sym__indent] = ACTIONS(274),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(272),
  },
  [39] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(185),
    [sym__simple_statements] = STATE(135),
    [sym_expression_statement] = STATE(892),
    [sym_annotation] = STATE(774),
    [aux_sym__annotations] = STATE(774),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(892),
    [sym_export_variable_statement] = STATE(892),
    [sym_onready_variable_statement] = STATE(892),
    [sym_const_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_pass_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_signal_statement] = STATE(892),
    [sym_class_name_statement] = STATE(892),
    [sym_extends_statement] = STATE(892),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(35),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(272),
    [sym__indent] = ACTIONS(274),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(272),
  },
  [40] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(196),
    [sym__simple_statements] = STATE(135),
    [sym_expression_statement] = STATE(892),
    [sym_annotation] = STATE(774),
    [aux_sym__annotations] = STATE(774),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(892),
    [sym_export_variable_statement] = STATE(892),
    [sym_onready_variable_statement] = STATE(892),
    [sym_const_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_pass_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_signal_statement] = STATE(892),
    [sym_class_name_statement] = STATE(892),
    [sym_extends_statement] = STATE(892),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(35),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(272),
    [sym__indent] = ACTIONS(274),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(272),
  },
  [41] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(1284),
    [sym__simple_statements] = STATE(972),
    [sym_expression_statement] = STATE(876),
    [sym_annotation] = STATE(784),
    [aux_sym__annotations] = STATE(784),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(876),
    [sym_export_variable_statement] = STATE(876),
    [sym_onready_variable_statement] = STATE(876),
    [sym_const_statement] = STATE(876),
    [sym_return_statement] = STATE(876),
    [sym_pass_statement] = STATE(876),
    [sym_break_statement] = STATE(876),
    [sym_continue_statement] = STATE(876),
    [sym_signal_statement] = STATE(876),
    [sym_class_name_statement] = STATE(876),
    [sym_extends_statement] = STATE(876),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(286),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(286),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(288),
    [sym__indent] = ACTIONS(290),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(288),
  },
  [42] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(137),
    [sym__simple_statements] = STATE(135),
    [sym_expression_statement] = STATE(892),
    [sym_annotation] = STATE(774),
    [aux_sym__annotations] = STATE(774),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(892),
    [sym_export_variable_statement] = STATE(892),
    [sym_onready_variable_statement] = STATE(892),
    [sym_const_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_pass_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_signal_statement] = STATE(892),
    [sym_class_name_statement] = STATE(892),
    [sym_extends_statement] = STATE(892),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(35),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(272),
    [sym__indent] = ACTIONS(274),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(272),
  },
  [43] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(127),
    [sym__simple_statements] = STATE(130),
    [sym_expression_statement] = STATE(846),
    [sym_annotation] = STATE(773),
    [aux_sym__annotations] = STATE(773),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(846),
    [sym_export_variable_statement] = STATE(846),
    [sym_onready_variable_statement] = STATE(846),
    [sym_const_statement] = STATE(846),
    [sym_return_statement] = STATE(846),
    [sym_pass_statement] = STATE(846),
    [sym_break_statement] = STATE(846),
    [sym_continue_statement] = STATE(846),
    [sym_signal_statement] = STATE(846),
    [sym_class_name_statement] = STATE(846),
    [sym_extends_statement] = STATE(846),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(276),
    [sym__indent] = ACTIONS(278),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(276),
  },
  [44] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(767),
    [sym__simple_statements] = STATE(757),
    [sym_expression_statement] = STATE(862),
    [sym_annotation] = STATE(781),
    [aux_sym__annotations] = STATE(781),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(862),
    [sym_export_variable_statement] = STATE(862),
    [sym_onready_variable_statement] = STATE(862),
    [sym_const_statement] = STATE(862),
    [sym_return_statement] = STATE(862),
    [sym_pass_statement] = STATE(862),
    [sym_break_statement] = STATE(862),
    [sym_continue_statement] = STATE(862),
    [sym_signal_statement] = STATE(862),
    [sym_class_name_statement] = STATE(862),
    [sym_extends_statement] = STATE(862),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(298),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(298),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(300),
    [sym__indent] = ACTIONS(302),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(300),
  },
  [45] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(143),
    [sym__simple_statements] = STATE(130),
    [sym_expression_statement] = STATE(846),
    [sym_annotation] = STATE(773),
    [aux_sym__annotations] = STATE(773),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(846),
    [sym_export_variable_statement] = STATE(846),
    [sym_onready_variable_statement] = STATE(846),
    [sym_const_statement] = STATE(846),
    [sym_return_statement] = STATE(846),
    [sym_pass_statement] = STATE(846),
    [sym_break_statement] = STATE(846),
    [sym_continue_statement] = STATE(846),
    [sym_signal_statement] = STATE(846),
    [sym_class_name_statement] = STATE(846),
    [sym_extends_statement] = STATE(846),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(276),
    [sym__indent] = ACTIONS(278),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(276),
  },
  [46] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(183),
    [sym__simple_statements] = STATE(135),
    [sym_expression_statement] = STATE(892),
    [sym_annotation] = STATE(774),
    [aux_sym__annotations] = STATE(774),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(892),
    [sym_export_variable_statement] = STATE(892),
    [sym_onready_variable_statement] = STATE(892),
    [sym_const_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_pass_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_signal_statement] = STATE(892),
    [sym_class_name_statement] = STATE(892),
    [sym_extends_statement] = STATE(892),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(35),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(272),
    [sym__indent] = ACTIONS(274),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(272),
  },
  [47] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(181),
    [sym__simple_statements] = STATE(135),
    [sym_expression_statement] = STATE(892),
    [sym_annotation] = STATE(774),
    [aux_sym__annotations] = STATE(774),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(892),
    [sym_export_variable_statement] = STATE(892),
    [sym_onready_variable_statement] = STATE(892),
    [sym_const_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_pass_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_signal_statement] = STATE(892),
    [sym_class_name_statement] = STATE(892),
    [sym_extends_statement] = STATE(892),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(35),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(272),
    [sym__indent] = ACTIONS(274),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(272),
  },
  [48] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(1286),
    [sym__simple_statements] = STATE(1153),
    [sym_expression_statement] = STATE(885),
    [sym_annotation] = STATE(775),
    [aux_sym__annotations] = STATE(775),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(885),
    [sym_export_variable_statement] = STATE(885),
    [sym_onready_variable_statement] = STATE(885),
    [sym_const_statement] = STATE(885),
    [sym_return_statement] = STATE(885),
    [sym_pass_statement] = STATE(885),
    [sym_break_statement] = STATE(885),
    [sym_continue_statement] = STATE(885),
    [sym_signal_statement] = STATE(885),
    [sym_class_name_statement] = STATE(885),
    [sym_extends_statement] = STATE(885),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(280),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(280),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(282),
    [sym__indent] = ACTIONS(284),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(282),
  },
  [49] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(1288),
    [sym__simple_statements] = STATE(1153),
    [sym_expression_statement] = STATE(885),
    [sym_annotation] = STATE(775),
    [aux_sym__annotations] = STATE(775),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(885),
    [sym_export_variable_statement] = STATE(885),
    [sym_onready_variable_statement] = STATE(885),
    [sym_const_statement] = STATE(885),
    [sym_return_statement] = STATE(885),
    [sym_pass_statement] = STATE(885),
    [sym_break_statement] = STATE(885),
    [sym_continue_statement] = STATE(885),
    [sym_signal_statement] = STATE(885),
    [sym_class_name_statement] = STATE(885),
    [sym_extends_statement] = STATE(885),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(280),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(280),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(282),
    [sym__indent] = ACTIONS(284),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(282),
  },
  [50] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(1298),
    [sym__simple_statements] = STATE(1153),
    [sym_expression_statement] = STATE(885),
    [sym_annotation] = STATE(775),
    [aux_sym__annotations] = STATE(775),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(885),
    [sym_export_variable_statement] = STATE(885),
    [sym_onready_variable_statement] = STATE(885),
    [sym_const_statement] = STATE(885),
    [sym_return_statement] = STATE(885),
    [sym_pass_statement] = STATE(885),
    [sym_break_statement] = STATE(885),
    [sym_continue_statement] = STATE(885),
    [sym_signal_statement] = STATE(885),
    [sym_class_name_statement] = STATE(885),
    [sym_extends_statement] = STATE(885),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(280),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(280),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(282),
    [sym__indent] = ACTIONS(284),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(282),
  },
  [51] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(142),
    [sym__simple_statements] = STATE(130),
    [sym_expression_statement] = STATE(846),
    [sym_annotation] = STATE(773),
    [aux_sym__annotations] = STATE(773),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(846),
    [sym_export_variable_statement] = STATE(846),
    [sym_onready_variable_statement] = STATE(846),
    [sym_const_statement] = STATE(846),
    [sym_return_statement] = STATE(846),
    [sym_pass_statement] = STATE(846),
    [sym_break_statement] = STATE(846),
    [sym_continue_statement] = STATE(846),
    [sym_signal_statement] = STATE(846),
    [sym_class_name_statement] = STATE(846),
    [sym_extends_statement] = STATE(846),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(276),
    [sym__indent] = ACTIONS(278),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(276),
  },
  [52] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(192),
    [sym__simple_statements] = STATE(135),
    [sym_expression_statement] = STATE(892),
    [sym_annotation] = STATE(774),
    [aux_sym__annotations] = STATE(774),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(892),
    [sym_export_variable_statement] = STATE(892),
    [sym_onready_variable_statement] = STATE(892),
    [sym_const_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_pass_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_signal_statement] = STATE(892),
    [sym_class_name_statement] = STATE(892),
    [sym_extends_statement] = STATE(892),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(35),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(272),
    [sym__indent] = ACTIONS(274),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(272),
  },
  [53] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(145),
    [sym__simple_statements] = STATE(130),
    [sym_expression_statement] = STATE(846),
    [sym_annotation] = STATE(773),
    [aux_sym__annotations] = STATE(773),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(846),
    [sym_export_variable_statement] = STATE(846),
    [sym_onready_variable_statement] = STATE(846),
    [sym_const_statement] = STATE(846),
    [sym_return_statement] = STATE(846),
    [sym_pass_statement] = STATE(846),
    [sym_break_statement] = STATE(846),
    [sym_continue_statement] = STATE(846),
    [sym_signal_statement] = STATE(846),
    [sym_class_name_statement] = STATE(846),
    [sym_extends_statement] = STATE(846),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(276),
    [sym__indent] = ACTIONS(278),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(276),
  },
  [54] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(200),
    [sym__simple_statements] = STATE(135),
    [sym_expression_statement] = STATE(892),
    [sym_annotation] = STATE(774),
    [aux_sym__annotations] = STATE(774),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(892),
    [sym_export_variable_statement] = STATE(892),
    [sym_onready_variable_statement] = STATE(892),
    [sym_const_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_pass_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_signal_statement] = STATE(892),
    [sym_class_name_statement] = STATE(892),
    [sym_extends_statement] = STATE(892),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(35),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(272),
    [sym__indent] = ACTIONS(274),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(272),
  },
  [55] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(1374),
    [sym__simple_statements] = STATE(1346),
    [sym_expression_statement] = STATE(899),
    [sym_annotation] = STATE(780),
    [aux_sym__annotations] = STATE(780),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(899),
    [sym_export_variable_statement] = STATE(899),
    [sym_onready_variable_statement] = STATE(899),
    [sym_const_statement] = STATE(899),
    [sym_return_statement] = STATE(899),
    [sym_pass_statement] = STATE(899),
    [sym_break_statement] = STATE(899),
    [sym_continue_statement] = STATE(899),
    [sym_signal_statement] = STATE(899),
    [sym_class_name_statement] = STATE(899),
    [sym_extends_statement] = STATE(899),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(266),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(266),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(268),
    [sym__indent] = ACTIONS(270),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(268),
  },
  [56] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(834),
    [sym__simple_statements] = STATE(839),
    [sym_expression_statement] = STATE(864),
    [sym_annotation] = STATE(785),
    [aux_sym__annotations] = STATE(785),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(864),
    [sym_export_variable_statement] = STATE(864),
    [sym_onready_variable_statement] = STATE(864),
    [sym_const_statement] = STATE(864),
    [sym_return_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_signal_statement] = STATE(864),
    [sym_class_name_statement] = STATE(864),
    [sym_extends_statement] = STATE(864),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(292),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(292),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(294),
    [sym__indent] = ACTIONS(296),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(294),
  },
  [57] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(761),
    [sym__simple_statements] = STATE(757),
    [sym_expression_statement] = STATE(862),
    [sym_annotation] = STATE(781),
    [aux_sym__annotations] = STATE(781),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(862),
    [sym_export_variable_statement] = STATE(862),
    [sym_onready_variable_statement] = STATE(862),
    [sym_const_statement] = STATE(862),
    [sym_return_statement] = STATE(862),
    [sym_pass_statement] = STATE(862),
    [sym_break_statement] = STATE(862),
    [sym_continue_statement] = STATE(862),
    [sym_signal_statement] = STATE(862),
    [sym_class_name_statement] = STATE(862),
    [sym_extends_statement] = STATE(862),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(298),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(298),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(300),
    [sym__indent] = ACTIONS(302),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(300),
  },
  [58] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(1344),
    [sym__simple_statements] = STATE(1322),
    [sym_expression_statement] = STATE(840),
    [sym_annotation] = STATE(782),
    [aux_sym__annotations] = STATE(782),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(840),
    [sym_export_variable_statement] = STATE(840),
    [sym_onready_variable_statement] = STATE(840),
    [sym_const_statement] = STATE(840),
    [sym_return_statement] = STATE(840),
    [sym_pass_statement] = STATE(840),
    [sym_break_statement] = STATE(840),
    [sym_continue_statement] = STATE(840),
    [sym_signal_statement] = STATE(840),
    [sym_class_name_statement] = STATE(840),
    [sym_extends_statement] = STATE(840),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(304),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(304),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(306),
    [sym__indent] = ACTIONS(308),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(306),
  },
  [59] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(148),
    [sym__simple_statements] = STATE(130),
    [sym_expression_statement] = STATE(846),
    [sym_annotation] = STATE(773),
    [aux_sym__annotations] = STATE(773),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(846),
    [sym_export_variable_statement] = STATE(846),
    [sym_onready_variable_statement] = STATE(846),
    [sym_const_statement] = STATE(846),
    [sym_return_statement] = STATE(846),
    [sym_pass_statement] = STATE(846),
    [sym_break_statement] = STATE(846),
    [sym_continue_statement] = STATE(846),
    [sym_signal_statement] = STATE(846),
    [sym_class_name_statement] = STATE(846),
    [sym_extends_statement] = STATE(846),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(276),
    [sym__indent] = ACTIONS(278),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(276),
  },
  [60] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(189),
    [sym__simple_statements] = STATE(135),
    [sym_expression_statement] = STATE(892),
    [sym_annotation] = STATE(774),
    [aux_sym__annotations] = STATE(774),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(892),
    [sym_export_variable_statement] = STATE(892),
    [sym_onready_variable_statement] = STATE(892),
    [sym_const_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_pass_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_signal_statement] = STATE(892),
    [sym_class_name_statement] = STATE(892),
    [sym_extends_statement] = STATE(892),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(35),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(272),
    [sym__indent] = ACTIONS(274),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(272),
  },
  [61] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(161),
    [sym__simple_statements] = STATE(130),
    [sym_expression_statement] = STATE(846),
    [sym_annotation] = STATE(773),
    [aux_sym__annotations] = STATE(773),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(846),
    [sym_export_variable_statement] = STATE(846),
    [sym_onready_variable_statement] = STATE(846),
    [sym_const_statement] = STATE(846),
    [sym_return_statement] = STATE(846),
    [sym_pass_statement] = STATE(846),
    [sym_break_statement] = STATE(846),
    [sym_continue_statement] = STATE(846),
    [sym_signal_statement] = STATE(846),
    [sym_class_name_statement] = STATE(846),
    [sym_extends_statement] = STATE(846),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(276),
    [sym__indent] = ACTIONS(278),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(276),
  },
  [62] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(188),
    [sym__simple_statements] = STATE(135),
    [sym_expression_statement] = STATE(892),
    [sym_annotation] = STATE(774),
    [aux_sym__annotations] = STATE(774),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(892),
    [sym_export_variable_statement] = STATE(892),
    [sym_onready_variable_statement] = STATE(892),
    [sym_const_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_pass_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_signal_statement] = STATE(892),
    [sym_class_name_statement] = STATE(892),
    [sym_extends_statement] = STATE(892),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(35),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(272),
    [sym__indent] = ACTIONS(274),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(272),
  },
  [63] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(165),
    [sym__simple_statements] = STATE(130),
    [sym_expression_statement] = STATE(846),
    [sym_annotation] = STATE(773),
    [aux_sym__annotations] = STATE(773),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(846),
    [sym_export_variable_statement] = STATE(846),
    [sym_onready_variable_statement] = STATE(846),
    [sym_const_statement] = STATE(846),
    [sym_return_statement] = STATE(846),
    [sym_pass_statement] = STATE(846),
    [sym_break_statement] = STATE(846),
    [sym_continue_statement] = STATE(846),
    [sym_signal_statement] = STATE(846),
    [sym_class_name_statement] = STATE(846),
    [sym_extends_statement] = STATE(846),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(276),
    [sym__indent] = ACTIONS(278),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(276),
  },
  [64] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(121),
    [sym__simple_statements] = STATE(130),
    [sym_expression_statement] = STATE(846),
    [sym_annotation] = STATE(773),
    [aux_sym__annotations] = STATE(773),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(846),
    [sym_export_variable_statement] = STATE(846),
    [sym_onready_variable_statement] = STATE(846),
    [sym_const_statement] = STATE(846),
    [sym_return_statement] = STATE(846),
    [sym_pass_statement] = STATE(846),
    [sym_break_statement] = STATE(846),
    [sym_continue_statement] = STATE(846),
    [sym_signal_statement] = STATE(846),
    [sym_class_name_statement] = STATE(846),
    [sym_extends_statement] = STATE(846),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(276),
    [sym__indent] = ACTIONS(278),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(276),
  },
  [65] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(195),
    [sym__simple_statements] = STATE(135),
    [sym_expression_statement] = STATE(892),
    [sym_annotation] = STATE(774),
    [aux_sym__annotations] = STATE(774),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(892),
    [sym_export_variable_statement] = STATE(892),
    [sym_onready_variable_statement] = STATE(892),
    [sym_const_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_pass_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_signal_statement] = STATE(892),
    [sym_class_name_statement] = STATE(892),
    [sym_extends_statement] = STATE(892),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(35),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(272),
    [sym__indent] = ACTIONS(274),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(272),
  },
  [66] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(1370),
    [sym__simple_statements] = STATE(1322),
    [sym_expression_statement] = STATE(840),
    [sym_annotation] = STATE(782),
    [aux_sym__annotations] = STATE(782),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(840),
    [sym_export_variable_statement] = STATE(840),
    [sym_onready_variable_statement] = STATE(840),
    [sym_const_statement] = STATE(840),
    [sym_return_statement] = STATE(840),
    [sym_pass_statement] = STATE(840),
    [sym_break_statement] = STATE(840),
    [sym_continue_statement] = STATE(840),
    [sym_signal_statement] = STATE(840),
    [sym_class_name_statement] = STATE(840),
    [sym_extends_statement] = STATE(840),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(304),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(304),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(306),
    [sym__indent] = ACTIONS(308),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(306),
  },
  [67] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(124),
    [sym__simple_statements] = STATE(135),
    [sym_expression_statement] = STATE(892),
    [sym_annotation] = STATE(774),
    [aux_sym__annotations] = STATE(774),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(892),
    [sym_export_variable_statement] = STATE(892),
    [sym_onready_variable_statement] = STATE(892),
    [sym_const_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_pass_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_signal_statement] = STATE(892),
    [sym_class_name_statement] = STATE(892),
    [sym_extends_statement] = STATE(892),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(35),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(272),
    [sym__indent] = ACTIONS(274),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(272),
  },
  [68] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(1321),
    [sym__simple_statements] = STATE(1346),
    [sym_expression_statement] = STATE(899),
    [sym_annotation] = STATE(780),
    [aux_sym__annotations] = STATE(780),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(899),
    [sym_export_variable_statement] = STATE(899),
    [sym_onready_variable_statement] = STATE(899),
    [sym_const_statement] = STATE(899),
    [sym_return_statement] = STATE(899),
    [sym_pass_statement] = STATE(899),
    [sym_break_statement] = STATE(899),
    [sym_continue_statement] = STATE(899),
    [sym_signal_statement] = STATE(899),
    [sym_class_name_statement] = STATE(899),
    [sym_extends_statement] = STATE(899),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(266),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(266),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(268),
    [sym__indent] = ACTIONS(270),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(268),
  },
  [69] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(158),
    [sym__simple_statements] = STATE(130),
    [sym_expression_statement] = STATE(846),
    [sym_annotation] = STATE(773),
    [aux_sym__annotations] = STATE(773),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(846),
    [sym_export_variable_statement] = STATE(846),
    [sym_onready_variable_statement] = STATE(846),
    [sym_const_statement] = STATE(846),
    [sym_return_statement] = STATE(846),
    [sym_pass_statement] = STATE(846),
    [sym_break_statement] = STATE(846),
    [sym_continue_statement] = STATE(846),
    [sym_signal_statement] = STATE(846),
    [sym_class_name_statement] = STATE(846),
    [sym_extends_statement] = STATE(846),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(276),
    [sym__indent] = ACTIONS(278),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(276),
  },
  [70] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(174),
    [sym__simple_statements] = STATE(135),
    [sym_expression_statement] = STATE(892),
    [sym_annotation] = STATE(774),
    [aux_sym__annotations] = STATE(774),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(892),
    [sym_export_variable_statement] = STATE(892),
    [sym_onready_variable_statement] = STATE(892),
    [sym_const_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_pass_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_signal_statement] = STATE(892),
    [sym_class_name_statement] = STATE(892),
    [sym_extends_statement] = STATE(892),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(35),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(272),
    [sym__indent] = ACTIONS(274),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(272),
  },
  [71] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(184),
    [sym__simple_statements] = STATE(135),
    [sym_expression_statement] = STATE(892),
    [sym_annotation] = STATE(774),
    [aux_sym__annotations] = STATE(774),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(892),
    [sym_export_variable_statement] = STATE(892),
    [sym_onready_variable_statement] = STATE(892),
    [sym_const_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_pass_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_signal_statement] = STATE(892),
    [sym_class_name_statement] = STATE(892),
    [sym_extends_statement] = STATE(892),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(35),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(272),
    [sym__indent] = ACTIONS(274),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(272),
  },
  [72] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(160),
    [sym__simple_statements] = STATE(130),
    [sym_expression_statement] = STATE(846),
    [sym_annotation] = STATE(773),
    [aux_sym__annotations] = STATE(773),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(846),
    [sym_export_variable_statement] = STATE(846),
    [sym_onready_variable_statement] = STATE(846),
    [sym_const_statement] = STATE(846),
    [sym_return_statement] = STATE(846),
    [sym_pass_statement] = STATE(846),
    [sym_break_statement] = STATE(846),
    [sym_continue_statement] = STATE(846),
    [sym_signal_statement] = STATE(846),
    [sym_class_name_statement] = STATE(846),
    [sym_extends_statement] = STATE(846),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(276),
    [sym__indent] = ACTIONS(278),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(276),
  },
  [73] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(1238),
    [sym__simple_statements] = STATE(1159),
    [sym_expression_statement] = STATE(867),
    [sym_annotation] = STATE(783),
    [aux_sym__annotations] = STATE(783),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(867),
    [sym_export_variable_statement] = STATE(867),
    [sym_onready_variable_statement] = STATE(867),
    [sym_const_statement] = STATE(867),
    [sym_return_statement] = STATE(867),
    [sym_pass_statement] = STATE(867),
    [sym_break_statement] = STATE(867),
    [sym_continue_statement] = STATE(867),
    [sym_signal_statement] = STATE(867),
    [sym_class_name_statement] = STATE(867),
    [sym_extends_statement] = STATE(867),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(310),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(310),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(312),
    [sym__indent] = ACTIONS(314),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(312),
  },
  [74] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(1240),
    [sym__simple_statements] = STATE(1159),
    [sym_expression_statement] = STATE(867),
    [sym_annotation] = STATE(783),
    [aux_sym__annotations] = STATE(783),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(867),
    [sym_export_variable_statement] = STATE(867),
    [sym_onready_variable_statement] = STATE(867),
    [sym_const_statement] = STATE(867),
    [sym_return_statement] = STATE(867),
    [sym_pass_statement] = STATE(867),
    [sym_break_statement] = STATE(867),
    [sym_continue_statement] = STATE(867),
    [sym_signal_statement] = STATE(867),
    [sym_class_name_statement] = STATE(867),
    [sym_extends_statement] = STATE(867),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(310),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(310),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(312),
    [sym__indent] = ACTIONS(314),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(312),
  },
  [75] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(1243),
    [sym__simple_statements] = STATE(1159),
    [sym_expression_statement] = STATE(867),
    [sym_annotation] = STATE(783),
    [aux_sym__annotations] = STATE(783),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(867),
    [sym_export_variable_statement] = STATE(867),
    [sym_onready_variable_statement] = STATE(867),
    [sym_const_statement] = STATE(867),
    [sym_return_statement] = STATE(867),
    [sym_pass_statement] = STATE(867),
    [sym_break_statement] = STATE(867),
    [sym_continue_statement] = STATE(867),
    [sym_signal_statement] = STATE(867),
    [sym_class_name_statement] = STATE(867),
    [sym_extends_statement] = STATE(867),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(310),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(310),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(312),
    [sym__indent] = ACTIONS(314),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(312),
  },
  [76] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(159),
    [sym__simple_statements] = STATE(130),
    [sym_expression_statement] = STATE(846),
    [sym_annotation] = STATE(773),
    [aux_sym__annotations] = STATE(773),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(846),
    [sym_export_variable_statement] = STATE(846),
    [sym_onready_variable_statement] = STATE(846),
    [sym_const_statement] = STATE(846),
    [sym_return_statement] = STATE(846),
    [sym_pass_statement] = STATE(846),
    [sym_break_statement] = STATE(846),
    [sym_continue_statement] = STATE(846),
    [sym_signal_statement] = STATE(846),
    [sym_class_name_statement] = STATE(846),
    [sym_extends_statement] = STATE(846),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(276),
    [sym__indent] = ACTIONS(278),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(276),
  },
  [77] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(176),
    [sym__simple_statements] = STATE(135),
    [sym_expression_statement] = STATE(892),
    [sym_annotation] = STATE(774),
    [aux_sym__annotations] = STATE(774),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(892),
    [sym_export_variable_statement] = STATE(892),
    [sym_onready_variable_statement] = STATE(892),
    [sym_const_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_pass_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_signal_statement] = STATE(892),
    [sym_class_name_statement] = STATE(892),
    [sym_extends_statement] = STATE(892),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(35),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(272),
    [sym__indent] = ACTIONS(274),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(272),
  },
  [78] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(171),
    [sym__simple_statements] = STATE(130),
    [sym_expression_statement] = STATE(846),
    [sym_annotation] = STATE(773),
    [aux_sym__annotations] = STATE(773),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(846),
    [sym_export_variable_statement] = STATE(846),
    [sym_onready_variable_statement] = STATE(846),
    [sym_const_statement] = STATE(846),
    [sym_return_statement] = STATE(846),
    [sym_pass_statement] = STATE(846),
    [sym_break_statement] = STATE(846),
    [sym_continue_statement] = STATE(846),
    [sym_signal_statement] = STATE(846),
    [sym_class_name_statement] = STATE(846),
    [sym_extends_statement] = STATE(846),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(276),
    [sym__indent] = ACTIONS(278),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(276),
  },
  [79] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(1247),
    [sym__simple_statements] = STATE(1159),
    [sym_expression_statement] = STATE(867),
    [sym_annotation] = STATE(783),
    [aux_sym__annotations] = STATE(783),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(867),
    [sym_export_variable_statement] = STATE(867),
    [sym_onready_variable_statement] = STATE(867),
    [sym_const_statement] = STATE(867),
    [sym_return_statement] = STATE(867),
    [sym_pass_statement] = STATE(867),
    [sym_break_statement] = STATE(867),
    [sym_continue_statement] = STATE(867),
    [sym_signal_statement] = STATE(867),
    [sym_class_name_statement] = STATE(867),
    [sym_extends_statement] = STATE(867),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(310),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(310),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(312),
    [sym__indent] = ACTIONS(314),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(312),
  },
  [80] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(170),
    [sym__simple_statements] = STATE(130),
    [sym_expression_statement] = STATE(846),
    [sym_annotation] = STATE(773),
    [aux_sym__annotations] = STATE(773),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(846),
    [sym_export_variable_statement] = STATE(846),
    [sym_onready_variable_statement] = STATE(846),
    [sym_const_statement] = STATE(846),
    [sym_return_statement] = STATE(846),
    [sym_pass_statement] = STATE(846),
    [sym_break_statement] = STATE(846),
    [sym_continue_statement] = STATE(846),
    [sym_signal_statement] = STATE(846),
    [sym_class_name_statement] = STATE(846),
    [sym_extends_statement] = STATE(846),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(276),
    [sym__indent] = ACTIONS(278),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(276),
  },
  [81] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(152),
    [sym__simple_statements] = STATE(130),
    [sym_expression_statement] = STATE(846),
    [sym_annotation] = STATE(773),
    [aux_sym__annotations] = STATE(773),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(846),
    [sym_export_variable_statement] = STATE(846),
    [sym_onready_variable_statement] = STATE(846),
    [sym_const_statement] = STATE(846),
    [sym_return_statement] = STATE(846),
    [sym_pass_statement] = STATE(846),
    [sym_break_statement] = STATE(846),
    [sym_continue_statement] = STATE(846),
    [sym_signal_statement] = STATE(846),
    [sym_class_name_statement] = STATE(846),
    [sym_extends_statement] = STATE(846),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(276),
    [sym__indent] = ACTIONS(278),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(276),
  },
  [82] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(162),
    [sym__simple_statements] = STATE(130),
    [sym_expression_statement] = STATE(846),
    [sym_annotation] = STATE(773),
    [aux_sym__annotations] = STATE(773),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(846),
    [sym_export_variable_statement] = STATE(846),
    [sym_onready_variable_statement] = STATE(846),
    [sym_const_statement] = STATE(846),
    [sym_return_statement] = STATE(846),
    [sym_pass_statement] = STATE(846),
    [sym_break_statement] = STATE(846),
    [sym_continue_statement] = STATE(846),
    [sym_signal_statement] = STATE(846),
    [sym_class_name_statement] = STATE(846),
    [sym_extends_statement] = STATE(846),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(276),
    [sym__indent] = ACTIONS(278),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(276),
  },
  [83] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(146),
    [sym__simple_statements] = STATE(130),
    [sym_expression_statement] = STATE(846),
    [sym_annotation] = STATE(773),
    [aux_sym__annotations] = STATE(773),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(846),
    [sym_export_variable_statement] = STATE(846),
    [sym_onready_variable_statement] = STATE(846),
    [sym_const_statement] = STATE(846),
    [sym_return_statement] = STATE(846),
    [sym_pass_statement] = STATE(846),
    [sym_break_statement] = STATE(846),
    [sym_continue_statement] = STATE(846),
    [sym_signal_statement] = STATE(846),
    [sym_class_name_statement] = STATE(846),
    [sym_extends_statement] = STATE(846),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(276),
    [sym__indent] = ACTIONS(278),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(276),
  },
  [84] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(1351),
    [sym__simple_statements] = STATE(1322),
    [sym_expression_statement] = STATE(840),
    [sym_annotation] = STATE(782),
    [aux_sym__annotations] = STATE(782),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(840),
    [sym_export_variable_statement] = STATE(840),
    [sym_onready_variable_statement] = STATE(840),
    [sym_const_statement] = STATE(840),
    [sym_return_statement] = STATE(840),
    [sym_pass_statement] = STATE(840),
    [sym_break_statement] = STATE(840),
    [sym_continue_statement] = STATE(840),
    [sym_signal_statement] = STATE(840),
    [sym_class_name_statement] = STATE(840),
    [sym_extends_statement] = STATE(840),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(304),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(304),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(306),
    [sym__indent] = ACTIONS(308),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(306),
  },
  [85] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(198),
    [sym__simple_statements] = STATE(135),
    [sym_expression_statement] = STATE(892),
    [sym_annotation] = STATE(774),
    [aux_sym__annotations] = STATE(774),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(892),
    [sym_export_variable_statement] = STATE(892),
    [sym_onready_variable_statement] = STATE(892),
    [sym_const_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_pass_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_signal_statement] = STATE(892),
    [sym_class_name_statement] = STATE(892),
    [sym_extends_statement] = STATE(892),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(35),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(272),
    [sym__indent] = ACTIONS(274),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(272),
  },
  [86] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(147),
    [sym__simple_statements] = STATE(130),
    [sym_expression_statement] = STATE(846),
    [sym_annotation] = STATE(773),
    [aux_sym__annotations] = STATE(773),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(846),
    [sym_export_variable_statement] = STATE(846),
    [sym_onready_variable_statement] = STATE(846),
    [sym_const_statement] = STATE(846),
    [sym_return_statement] = STATE(846),
    [sym_pass_statement] = STATE(846),
    [sym_break_statement] = STATE(846),
    [sym_continue_statement] = STATE(846),
    [sym_signal_statement] = STATE(846),
    [sym_class_name_statement] = STATE(846),
    [sym_extends_statement] = STATE(846),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(276),
    [sym__indent] = ACTIONS(278),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(276),
  },
  [87] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(172),
    [sym__simple_statements] = STATE(135),
    [sym_expression_statement] = STATE(892),
    [sym_annotation] = STATE(774),
    [aux_sym__annotations] = STATE(774),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(892),
    [sym_export_variable_statement] = STATE(892),
    [sym_onready_variable_statement] = STATE(892),
    [sym_const_statement] = STATE(892),
    [sym_return_statement] = STATE(892),
    [sym_pass_statement] = STATE(892),
    [sym_break_statement] = STATE(892),
    [sym_continue_statement] = STATE(892),
    [sym_signal_statement] = STATE(892),
    [sym_class_name_statement] = STATE(892),
    [sym_extends_statement] = STATE(892),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(35),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(35),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(272),
    [sym__indent] = ACTIONS(274),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(272),
  },
  [88] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(1371),
    [sym__simple_statements] = STATE(1322),
    [sym_expression_statement] = STATE(840),
    [sym_annotation] = STATE(782),
    [aux_sym__annotations] = STATE(782),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(840),
    [sym_export_variable_statement] = STATE(840),
    [sym_onready_variable_statement] = STATE(840),
    [sym_const_statement] = STATE(840),
    [sym_return_statement] = STATE(840),
    [sym_pass_statement] = STATE(840),
    [sym_break_statement] = STATE(840),
    [sym_continue_statement] = STATE(840),
    [sym_signal_statement] = STATE(840),
    [sym_class_name_statement] = STATE(840),
    [sym_extends_statement] = STATE(840),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(304),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(304),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(306),
    [sym__indent] = ACTIONS(308),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(306),
  },
  [89] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(144),
    [sym__simple_statements] = STATE(130),
    [sym_expression_statement] = STATE(846),
    [sym_annotation] = STATE(773),
    [aux_sym__annotations] = STATE(773),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(846),
    [sym_export_variable_statement] = STATE(846),
    [sym_onready_variable_statement] = STATE(846),
    [sym_const_statement] = STATE(846),
    [sym_return_statement] = STATE(846),
    [sym_pass_statement] = STATE(846),
    [sym_break_statement] = STATE(846),
    [sym_continue_statement] = STATE(846),
    [sym_signal_statement] = STATE(846),
    [sym_class_name_statement] = STATE(846),
    [sym_extends_statement] = STATE(846),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(276),
    [sym__indent] = ACTIONS(278),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(276),
  },
  [90] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(822),
    [sym__simple_statements] = STATE(839),
    [sym_expression_statement] = STATE(864),
    [sym_annotation] = STATE(785),
    [aux_sym__annotations] = STATE(785),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(864),
    [sym_export_variable_statement] = STATE(864),
    [sym_onready_variable_statement] = STATE(864),
    [sym_const_statement] = STATE(864),
    [sym_return_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_signal_statement] = STATE(864),
    [sym_class_name_statement] = STATE(864),
    [sym_extends_statement] = STATE(864),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(292),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(292),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(294),
    [sym__indent] = ACTIONS(296),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(294),
  },
  [91] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(1271),
    [sym__simple_statements] = STATE(1253),
    [sym_expression_statement] = STATE(907),
    [sym_annotation] = STATE(779),
    [aux_sym__annotations] = STATE(779),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(907),
    [sym_export_variable_statement] = STATE(907),
    [sym_onready_variable_statement] = STATE(907),
    [sym_const_statement] = STATE(907),
    [sym_return_statement] = STATE(907),
    [sym_pass_statement] = STATE(907),
    [sym_break_statement] = STATE(907),
    [sym_continue_statement] = STATE(907),
    [sym_signal_statement] = STATE(907),
    [sym_class_name_statement] = STATE(907),
    [sym_extends_statement] = STATE(907),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(316),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(316),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(318),
    [sym__indent] = ACTIONS(320),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(318),
  },
  [92] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(151),
    [sym__simple_statements] = STATE(130),
    [sym_expression_statement] = STATE(846),
    [sym_annotation] = STATE(773),
    [aux_sym__annotations] = STATE(773),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(846),
    [sym_export_variable_statement] = STATE(846),
    [sym_onready_variable_statement] = STATE(846),
    [sym_const_statement] = STATE(846),
    [sym_return_statement] = STATE(846),
    [sym_pass_statement] = STATE(846),
    [sym_break_statement] = STATE(846),
    [sym_continue_statement] = STATE(846),
    [sym_signal_statement] = STATE(846),
    [sym_class_name_statement] = STATE(846),
    [sym_extends_statement] = STATE(846),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(276),
    [sym__indent] = ACTIONS(278),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(276),
  },
  [93] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(1268),
    [sym__simple_statements] = STATE(1253),
    [sym_expression_statement] = STATE(907),
    [sym_annotation] = STATE(779),
    [aux_sym__annotations] = STATE(779),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(907),
    [sym_export_variable_statement] = STATE(907),
    [sym_onready_variable_statement] = STATE(907),
    [sym_const_statement] = STATE(907),
    [sym_return_statement] = STATE(907),
    [sym_pass_statement] = STATE(907),
    [sym_break_statement] = STATE(907),
    [sym_continue_statement] = STATE(907),
    [sym_signal_statement] = STATE(907),
    [sym_class_name_statement] = STATE(907),
    [sym_extends_statement] = STATE(907),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(316),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(316),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(318),
    [sym__indent] = ACTIONS(320),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(318),
  },
  [94] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(1267),
    [sym__simple_statements] = STATE(1253),
    [sym_expression_statement] = STATE(907),
    [sym_annotation] = STATE(779),
    [aux_sym__annotations] = STATE(779),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(907),
    [sym_export_variable_statement] = STATE(907),
    [sym_onready_variable_statement] = STATE(907),
    [sym_const_statement] = STATE(907),
    [sym_return_statement] = STATE(907),
    [sym_pass_statement] = STATE(907),
    [sym_break_statement] = STATE(907),
    [sym_continue_statement] = STATE(907),
    [sym_signal_statement] = STATE(907),
    [sym_class_name_statement] = STATE(907),
    [sym_extends_statement] = STATE(907),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(316),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(316),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(318),
    [sym__indent] = ACTIONS(320),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(318),
  },
  [95] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(150),
    [sym__simple_statements] = STATE(130),
    [sym_expression_statement] = STATE(846),
    [sym_annotation] = STATE(773),
    [aux_sym__annotations] = STATE(773),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(846),
    [sym_export_variable_statement] = STATE(846),
    [sym_onready_variable_statement] = STATE(846),
    [sym_const_statement] = STATE(846),
    [sym_return_statement] = STATE(846),
    [sym_pass_statement] = STATE(846),
    [sym_break_statement] = STATE(846),
    [sym_continue_statement] = STATE(846),
    [sym_signal_statement] = STATE(846),
    [sym_class_name_statement] = STATE(846),
    [sym_extends_statement] = STATE(846),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(276),
    [sym__indent] = ACTIONS(278),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(276),
  },
  [96] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(149),
    [sym__simple_statements] = STATE(130),
    [sym_expression_statement] = STATE(846),
    [sym_annotation] = STATE(773),
    [aux_sym__annotations] = STATE(773),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(846),
    [sym_export_variable_statement] = STATE(846),
    [sym_onready_variable_statement] = STATE(846),
    [sym_const_statement] = STATE(846),
    [sym_return_statement] = STATE(846),
    [sym_pass_statement] = STATE(846),
    [sym_break_statement] = STATE(846),
    [sym_continue_statement] = STATE(846),
    [sym_signal_statement] = STATE(846),
    [sym_class_name_statement] = STATE(846),
    [sym_extends_statement] = STATE(846),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(77),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(77),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(276),
    [sym__indent] = ACTIONS(278),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(276),
  },
  [97] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(1254),
    [sym__simple_statements] = STATE(1253),
    [sym_expression_statement] = STATE(907),
    [sym_annotation] = STATE(779),
    [aux_sym__annotations] = STATE(779),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(907),
    [sym_export_variable_statement] = STATE(907),
    [sym_onready_variable_statement] = STATE(907),
    [sym_const_statement] = STATE(907),
    [sym_return_statement] = STATE(907),
    [sym_pass_statement] = STATE(907),
    [sym_break_statement] = STATE(907),
    [sym_continue_statement] = STATE(907),
    [sym_signal_statement] = STATE(907),
    [sym_class_name_statement] = STATE(907),
    [sym_extends_statement] = STATE(907),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(316),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(316),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(318),
    [sym__indent] = ACTIONS(320),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(318),
  },
  [98] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_body] = STATE(825),
    [sym__simple_statements] = STATE(839),
    [sym_expression_statement] = STATE(864),
    [sym_annotation] = STATE(785),
    [aux_sym__annotations] = STATE(785),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(864),
    [sym_export_variable_statement] = STATE(864),
    [sym_onready_variable_statement] = STATE(864),
    [sym_const_statement] = STATE(864),
    [sym_return_statement] = STATE(864),
    [sym_pass_statement] = STATE(864),
    [sym_break_statement] = STATE(864),
    [sym_continue_statement] = STATE(864),
    [sym_signal_statement] = STATE(864),
    [sym_class_name_statement] = STATE(864),
    [sym_extends_statement] = STATE(864),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(292),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(292),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(294),
    [sym__indent] = ACTIONS(296),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(294),
  },
  [99] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_expression_statement] = STATE(1082),
    [sym_annotation] = STATE(794),
    [aux_sym__annotations] = STATE(794),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(1082),
    [sym_export_variable_statement] = STATE(1082),
    [sym_onready_variable_statement] = STATE(1082),
    [sym_const_statement] = STATE(1082),
    [sym_return_statement] = STATE(1082),
    [sym_pass_statement] = STATE(1082),
    [sym_break_statement] = STATE(1082),
    [sym_continue_statement] = STATE(1082),
    [sym_signal_statement] = STATE(1082),
    [sym_class_name_statement] = STATE(1082),
    [sym_extends_statement] = STATE(1082),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(322),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(322),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(324),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(324),
  },
  [100] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_expression_statement] = STATE(1082),
    [sym_annotation] = STATE(794),
    [aux_sym__annotations] = STATE(794),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(1082),
    [sym_export_variable_statement] = STATE(1082),
    [sym_onready_variable_statement] = STATE(1082),
    [sym_const_statement] = STATE(1082),
    [sym_return_statement] = STATE(1082),
    [sym_pass_statement] = STATE(1082),
    [sym_break_statement] = STATE(1082),
    [sym_continue_statement] = STATE(1082),
    [sym_signal_statement] = STATE(1082),
    [sym_class_name_statement] = STATE(1082),
    [sym_extends_statement] = STATE(1082),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(322),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(322),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(326),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(326),
  },
  [101] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_expression_statement] = STATE(1082),
    [sym_annotation] = STATE(794),
    [aux_sym__annotations] = STATE(794),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(1082),
    [sym_export_variable_statement] = STATE(1082),
    [sym_onready_variable_statement] = STATE(1082),
    [sym_const_statement] = STATE(1082),
    [sym_return_statement] = STATE(1082),
    [sym_pass_statement] = STATE(1082),
    [sym_break_statement] = STATE(1082),
    [sym_continue_statement] = STATE(1082),
    [sym_signal_statement] = STATE(1082),
    [sym_class_name_statement] = STATE(1082),
    [sym_extends_statement] = STATE(1082),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(322),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(322),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(328),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(328),
  },
  [102] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_expression_statement] = STATE(1082),
    [sym_annotation] = STATE(794),
    [aux_sym__annotations] = STATE(794),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(1082),
    [sym_export_variable_statement] = STATE(1082),
    [sym_onready_variable_statement] = STATE(1082),
    [sym_const_statement] = STATE(1082),
    [sym_return_statement] = STATE(1082),
    [sym_pass_statement] = STATE(1082),
    [sym_break_statement] = STATE(1082),
    [sym_continue_statement] = STATE(1082),
    [sym_signal_statement] = STATE(1082),
    [sym_class_name_statement] = STATE(1082),
    [sym_extends_statement] = STATE(1082),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(322),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(322),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(330),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(330),
  },
  [103] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_expression_statement] = STATE(1082),
    [sym_annotation] = STATE(794),
    [aux_sym__annotations] = STATE(794),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(1082),
    [sym_export_variable_statement] = STATE(1082),
    [sym_onready_variable_statement] = STATE(1082),
    [sym_const_statement] = STATE(1082),
    [sym_return_statement] = STATE(1082),
    [sym_pass_statement] = STATE(1082),
    [sym_break_statement] = STATE(1082),
    [sym_continue_statement] = STATE(1082),
    [sym_signal_statement] = STATE(1082),
    [sym_class_name_statement] = STATE(1082),
    [sym_extends_statement] = STATE(1082),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(322),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(322),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(332),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(332),
  },
  [104] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_expression_statement] = STATE(1082),
    [sym_annotation] = STATE(794),
    [aux_sym__annotations] = STATE(794),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(1082),
    [sym_export_variable_statement] = STATE(1082),
    [sym_onready_variable_statement] = STATE(1082),
    [sym_const_statement] = STATE(1082),
    [sym_return_statement] = STATE(1082),
    [sym_pass_statement] = STATE(1082),
    [sym_break_statement] = STATE(1082),
    [sym_continue_statement] = STATE(1082),
    [sym_signal_statement] = STATE(1082),
    [sym_class_name_statement] = STATE(1082),
    [sym_extends_statement] = STATE(1082),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(322),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(322),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(334),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(334),
  },
  [105] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_expression_statement] = STATE(1082),
    [sym_annotation] = STATE(794),
    [aux_sym__annotations] = STATE(794),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(1082),
    [sym_export_variable_statement] = STATE(1082),
    [sym_onready_variable_statement] = STATE(1082),
    [sym_const_statement] = STATE(1082),
    [sym_return_statement] = STATE(1082),
    [sym_pass_statement] = STATE(1082),
    [sym_break_statement] = STATE(1082),
    [sym_continue_statement] = STATE(1082),
    [sym_signal_statement] = STATE(1082),
    [sym_class_name_statement] = STATE(1082),
    [sym_extends_statement] = STATE(1082),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(322),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(322),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(336),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(336),
  },
  [106] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_expression_statement] = STATE(1082),
    [sym_annotation] = STATE(794),
    [aux_sym__annotations] = STATE(794),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(1082),
    [sym_export_variable_statement] = STATE(1082),
    [sym_onready_variable_statement] = STATE(1082),
    [sym_const_statement] = STATE(1082),
    [sym_return_statement] = STATE(1082),
    [sym_pass_statement] = STATE(1082),
    [sym_break_statement] = STATE(1082),
    [sym_continue_statement] = STATE(1082),
    [sym_signal_statement] = STATE(1082),
    [sym_class_name_statement] = STATE(1082),
    [sym_extends_statement] = STATE(1082),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(322),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(322),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(338),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(338),
  },
  [107] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_expression_statement] = STATE(1082),
    [sym_annotation] = STATE(794),
    [aux_sym__annotations] = STATE(794),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(1082),
    [sym_export_variable_statement] = STATE(1082),
    [sym_onready_variable_statement] = STATE(1082),
    [sym_const_statement] = STATE(1082),
    [sym_return_statement] = STATE(1082),
    [sym_pass_statement] = STATE(1082),
    [sym_break_statement] = STATE(1082),
    [sym_continue_statement] = STATE(1082),
    [sym_signal_statement] = STATE(1082),
    [sym_class_name_statement] = STATE(1082),
    [sym_extends_statement] = STATE(1082),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(322),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(322),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(340),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(340),
  },
  [108] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_expression_statement] = STATE(1082),
    [sym_annotation] = STATE(794),
    [aux_sym__annotations] = STATE(794),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(1082),
    [sym_export_variable_statement] = STATE(1082),
    [sym_onready_variable_statement] = STATE(1082),
    [sym_const_statement] = STATE(1082),
    [sym_return_statement] = STATE(1082),
    [sym_pass_statement] = STATE(1082),
    [sym_break_statement] = STATE(1082),
    [sym_continue_statement] = STATE(1082),
    [sym_signal_statement] = STATE(1082),
    [sym_class_name_statement] = STATE(1082),
    [sym_extends_statement] = STATE(1082),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(322),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(322),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(342),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(342),
  },
  [109] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_expression_statement] = STATE(1082),
    [sym_annotation] = STATE(794),
    [aux_sym__annotations] = STATE(794),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(1082),
    [sym_export_variable_statement] = STATE(1082),
    [sym_onready_variable_statement] = STATE(1082),
    [sym_const_statement] = STATE(1082),
    [sym_return_statement] = STATE(1082),
    [sym_pass_statement] = STATE(1082),
    [sym_break_statement] = STATE(1082),
    [sym_continue_statement] = STATE(1082),
    [sym_signal_statement] = STATE(1082),
    [sym_class_name_statement] = STATE(1082),
    [sym_extends_statement] = STATE(1082),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(322),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(322),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(344),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(344),
  },
  [110] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_expression_statement] = STATE(1082),
    [sym_annotation] = STATE(794),
    [aux_sym__annotations] = STATE(794),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(1082),
    [sym_export_variable_statement] = STATE(1082),
    [sym_onready_variable_statement] = STATE(1082),
    [sym_const_statement] = STATE(1082),
    [sym_return_statement] = STATE(1082),
    [sym_pass_statement] = STATE(1082),
    [sym_break_statement] = STATE(1082),
    [sym_continue_statement] = STATE(1082),
    [sym_signal_statement] = STATE(1082),
    [sym_class_name_statement] = STATE(1082),
    [sym_extends_statement] = STATE(1082),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(322),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(322),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(346),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(346),
  },
  [111] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_expression_statement] = STATE(1082),
    [sym_annotation] = STATE(794),
    [aux_sym__annotations] = STATE(794),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(1082),
    [sym_export_variable_statement] = STATE(1082),
    [sym_onready_variable_statement] = STATE(1082),
    [sym_const_statement] = STATE(1082),
    [sym_return_statement] = STATE(1082),
    [sym_pass_statement] = STATE(1082),
    [sym_break_statement] = STATE(1082),
    [sym_continue_statement] = STATE(1082),
    [sym_signal_statement] = STATE(1082),
    [sym_class_name_statement] = STATE(1082),
    [sym_extends_statement] = STATE(1082),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(322),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(322),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(348),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(348),
  },
  [112] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_expression_statement] = STATE(1082),
    [sym_annotation] = STATE(794),
    [aux_sym__annotations] = STATE(794),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(1082),
    [sym_export_variable_statement] = STATE(1082),
    [sym_onready_variable_statement] = STATE(1082),
    [sym_const_statement] = STATE(1082),
    [sym_return_statement] = STATE(1082),
    [sym_pass_statement] = STATE(1082),
    [sym_break_statement] = STATE(1082),
    [sym_continue_statement] = STATE(1082),
    [sym_signal_statement] = STATE(1082),
    [sym_class_name_statement] = STATE(1082),
    [sym_extends_statement] = STATE(1082),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(322),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(322),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(350),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(350),
  },
  [113] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_expression_statement] = STATE(1082),
    [sym_annotation] = STATE(794),
    [aux_sym__annotations] = STATE(794),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(1082),
    [sym_export_variable_statement] = STATE(1082),
    [sym_onready_variable_statement] = STATE(1082),
    [sym_const_statement] = STATE(1082),
    [sym_return_statement] = STATE(1082),
    [sym_pass_statement] = STATE(1082),
    [sym_break_statement] = STATE(1082),
    [sym_continue_statement] = STATE(1082),
    [sym_signal_statement] = STATE(1082),
    [sym_class_name_statement] = STATE(1082),
    [sym_extends_statement] = STATE(1082),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(322),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(322),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(352),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(352),
  },
  [114] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_expression_statement] = STATE(1082),
    [sym_annotation] = STATE(794),
    [aux_sym__annotations] = STATE(794),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(1082),
    [sym_export_variable_statement] = STATE(1082),
    [sym_onready_variable_statement] = STATE(1082),
    [sym_const_statement] = STATE(1082),
    [sym_return_statement] = STATE(1082),
    [sym_pass_statement] = STATE(1082),
    [sym_break_statement] = STATE(1082),
    [sym_continue_statement] = STATE(1082),
    [sym_signal_statement] = STATE(1082),
    [sym_class_name_statement] = STATE(1082),
    [sym_extends_statement] = STATE(1082),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(322),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(322),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(354),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(354),
  },
  [115] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_expression_statement] = STATE(1082),
    [sym_annotation] = STATE(794),
    [aux_sym__annotations] = STATE(794),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(1082),
    [sym_export_variable_statement] = STATE(1082),
    [sym_onready_variable_statement] = STATE(1082),
    [sym_const_statement] = STATE(1082),
    [sym_return_statement] = STATE(1082),
    [sym_pass_statement] = STATE(1082),
    [sym_break_statement] = STATE(1082),
    [sym_continue_statement] = STATE(1082),
    [sym_signal_statement] = STATE(1082),
    [sym_class_name_statement] = STATE(1082),
    [sym_extends_statement] = STATE(1082),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(322),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(322),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(356),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(356),
  },
  [116] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_expression_statement] = STATE(1082),
    [sym_annotation] = STATE(794),
    [aux_sym__annotations] = STATE(794),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(1082),
    [sym_export_variable_statement] = STATE(1082),
    [sym_onready_variable_statement] = STATE(1082),
    [sym_const_statement] = STATE(1082),
    [sym_return_statement] = STATE(1082),
    [sym_pass_statement] = STATE(1082),
    [sym_break_statement] = STATE(1082),
    [sym_continue_statement] = STATE(1082),
    [sym_signal_statement] = STATE(1082),
    [sym_class_name_statement] = STATE(1082),
    [sym_extends_statement] = STATE(1082),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(322),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(322),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(358),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(358),
  },
  [117] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_expression_statement] = STATE(1082),
    [sym_annotation] = STATE(794),
    [aux_sym__annotations] = STATE(794),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(1082),
    [sym_export_variable_statement] = STATE(1082),
    [sym_onready_variable_statement] = STATE(1082),
    [sym_const_statement] = STATE(1082),
    [sym_return_statement] = STATE(1082),
    [sym_pass_statement] = STATE(1082),
    [sym_break_statement] = STATE(1082),
    [sym_continue_statement] = STATE(1082),
    [sym_signal_statement] = STATE(1082),
    [sym_class_name_statement] = STATE(1082),
    [sym_extends_statement] = STATE(1082),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(322),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(322),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(360),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(360),
  },
  [118] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_expression_statement] = STATE(1082),
    [sym_annotation] = STATE(794),
    [aux_sym__annotations] = STATE(794),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(1082),
    [sym_export_variable_statement] = STATE(1082),
    [sym_onready_variable_statement] = STATE(1082),
    [sym_const_statement] = STATE(1082),
    [sym_return_statement] = STATE(1082),
    [sym_pass_statement] = STATE(1082),
    [sym_break_statement] = STATE(1082),
    [sym_continue_statement] = STATE(1082),
    [sym_signal_statement] = STATE(1082),
    [sym_class_name_statement] = STATE(1082),
    [sym_extends_statement] = STATE(1082),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(322),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(322),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__newline] = ACTIONS(362),
    [sym__string_start] = ACTIONS(73),
    [sym__body_end] = ACTIONS(362),
  },
  [119] = {
    [sym_identifier] = STATE(233),
    [sym_remote_keyword] = STATE(805),
    [sym_string] = STATE(233),
    [sym_string_name] = STATE(237),
    [sym_expression_statement] = STATE(1082),
    [sym_annotation] = STATE(794),
    [aux_sym__annotations] = STATE(794),
    [sym_annotations] = STATE(1317),
    [sym__variable_statement] = STATE(1020),
    [sym_variable_statement] = STATE(1082),
    [sym_export_variable_statement] = STATE(1082),
    [sym_onready_variable_statement] = STATE(1082),
    [sym_const_statement] = STATE(1082),
    [sym_return_statement] = STATE(1082),
    [sym_pass_statement] = STATE(1082),
    [sym_break_statement] = STATE(1082),
    [sym_continue_statement] = STATE(1082),
    [sym_signal_statement] = STATE(1082),
    [sym_class_name_statement] = STATE(1082),
    [sym_extends_statement] = STATE(1082),
    [sym__expression] = STATE(749),
    [sym__primary_expression] = STATE(215),
    [sym__attribute_expression] = STATE(1292),
    [sym_binary_operator] = STATE(233),
    [sym_unary_operator] = STATE(233),
    [sym_comparison_operator] = STATE(744),
    [sym_subscript] = STATE(233),
    [sym_attribute] = STATE(237),
    [sym_conditional_expression] = STATE(744),
    [sym_parenthesized_expression] = STATE(233),
    [sym_await_expression] = STATE(744),
    [sym_assignment] = STATE(1019),
    [sym_augmented_assignment] = STATE(1019),
    [sym_dictionary] = STATE(233),
    [sym_array] = STATE(233),
    [sym_base_call] = STATE(233),
    [sym_call] = STATE(233),
    [sym__identifier] = ACTIONS(7),
    [sym_comment] = ACTIONS(3),
    [sym_true] = ACTIONS(9),
    [sym_false] = ACTIONS(9),
    [sym_null] = ACTIONS(9),
    [anon_sym_remote] = ACTIONS(13),
    [anon_sym_master] = ACTIONS(13),
    [anon_sym_puppet] = ACTIONS(13),
    [anon_sym_remotesync] = ACTIONS(13),
    [anon_sym_mastersync] = ACTIONS(13),
    [anon_sym_puppetsync] = ACTIONS(13),
    [sym_float] = ACTIONS(15),
    [sym_integer] = ACTIONS(9),
    [anon_sym_AMP] = ACTIONS(17),
    [sym_node_path] = ACTIONS(15),
    [sym_get_node] = ACTIONS(15),
    [anon_sym_AT] = ACTIONS(19),
    [anon_sym_var] = ACTIONS(21),
    [anon_sym_export] = ACTIONS(23),
    [anon_sym_onready] = ACTIONS(25),
    [anon_sym_const] = ACTIONS(27),
    [anon_sym_return] = ACTIONS(29),
    [anon_sym_pass] = ACTIONS(31),
    [anon_sym_break] = ACTIONS(33),
    [sym_breakpoint_statement] = ACTIONS(322),
    [anon_sym_continue] = ACTIONS(37),
    [sym_tool_statement] = ACTIONS(322),
    [anon_sym_signal] = ACTIONS(39),
    [anon_sym_class_name] = ACTIONS(41),
    [anon_sym_DOT] = ACTIONS(43),
    [anon_sym_extends] = ACTIONS(45),
    [anon_sym_LBRACE] = ACTIONS(57),
    [anon_sym_LBRACK] = ACTIONS(61),
    [anon_sym_PLUS] = ACTIONS(63),
    [anon_sym_DASH] = ACTIONS(63),
    [anon_sym_not] = ACTIONS(65),
    [anon_sym_BANG] = ACTIONS(63),
    [anon_sym_TILDE] = ACTIONS(63),
    [anon_sym_LPAREN] = ACTIONS(67),
    [anon_sym_await] = ACTIONS(69),
    [sym__string_start] = ACTIONS(73),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(368), 1,
      anon_sym_elif,
    ACTIONS(370), 1,
      anon_sym_else,
    STATE(122), 1,
      aux_sym_if_statement_repeat1,
    STATE(126), 1,
      sym_elif_clause,
    STATE(156), 1,
      sym_else_clause,
    ACTIONS(366), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(364), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [73] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(368), 1,
      anon_sym_elif,
    ACTIONS(370), 1,
      anon_sym_else,
    STATE(120), 1,
      aux_sym_if_statement_repeat1,
    STATE(126), 1,
      sym_elif_clause,
    STATE(163), 1,
      sym_else_clause,
    ACTIONS(374), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(372), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [146] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(380), 1,
      anon_sym_elif,
    STATE(122), 1,
      aux_sym_if_statement_repeat1,
    STATE(126), 1,
      sym_elif_clause,
    ACTIONS(378), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(376), 37,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [214] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(383), 1,
      anon_sym_elif,
    ACTIONS(385), 1,
      anon_sym_else,
    STATE(125), 1,
      aux_sym_if_statement_repeat1,
    STATE(139), 1,
      sym_elif_clause,
    STATE(186), 1,
      sym_else_clause,
    ACTIONS(366), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(364), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [286] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(383), 1,
      anon_sym_elif,
    ACTIONS(385), 1,
      anon_sym_else,
    STATE(123), 1,
      aux_sym_if_statement_repeat1,
    STATE(139), 1,
      sym_elif_clause,
    STATE(175), 1,
      sym_else_clause,
    ACTIONS(374), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(372), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [358] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(387), 1,
      anon_sym_elif,
    STATE(125), 1,
      aux_sym_if_statement_repeat1,
    STATE(139), 1,
      sym_elif_clause,
    ACTIONS(378), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(376), 37,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [425] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(392), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(390), 38,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [485] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(396), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(394), 38,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [545] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(400), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(398), 38,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [605] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(404), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(402), 38,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [665] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(408), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(406), 38,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [725] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(412), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(410), 38,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [785] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(416), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(414), 38,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [845] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(420), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(418), 38,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [905] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(416), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(414), 38,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [964] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(408), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(406), 38,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [1023] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(420), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(418), 38,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [1082] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(396), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(394), 38,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [1141] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(412), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(410), 38,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [1200] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(392), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(390), 38,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [1259] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(404), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(402), 38,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [1318] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(400), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(398), 38,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_elif,
      anon_sym_else,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [1377] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(424), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(422), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [1435] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(428), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(426), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [1493] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(432), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(430), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [1551] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(436), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(434), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [1609] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(440), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(438), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [1667] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(444), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(442), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [1725] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(448), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(446), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [1783] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(452), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(450), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [1841] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(456), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(454), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [1899] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(460), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(458), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [1957] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(464), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(462), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [2015] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(468), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(466), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [2073] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(472), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(470), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [2131] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(476), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(474), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [2189] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(480), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(478), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [2247] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(484), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(482), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [2305] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(488), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(486), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [2363] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(492), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(490), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [2421] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(496), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(494), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [2479] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(500), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(498), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [2537] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(504), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(502), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [2595] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(508), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(506), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [2653] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(512), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(510), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [2711] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(516), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(514), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [2769] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(520), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(518), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [2827] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(524), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(522), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [2885] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(528), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(526), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [2943] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(532), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(530), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [3001] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(536), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(534), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [3059] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(540), 14,
      sym__dedent,
      sym__string_start,
      sym__body_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(538), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [3117] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(516), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(514), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [3174] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(504), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(502), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [3231] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(488), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(486), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [3288] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(508), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(506), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [3345] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(492), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(490), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [3402] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(512), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(510), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [3459] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(476), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(474), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [3516] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(520), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(518), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [3573] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(484), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(482), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [3630] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(536), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(534), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [3687] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(472), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(470), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [3744] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(424), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(422), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [3801] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(496), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(494), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [3858] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(428), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(426), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [3915] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(480), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(478), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [3972] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(528), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(526), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [4029] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(440), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(438), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [4086] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(500), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(498), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [4143] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(532), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(530), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [4200] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(436), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(434), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [4257] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(432), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(430), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [4314] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(468), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(466), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [4371] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(448), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(446), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [4428] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(540), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(538), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [4485] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(452), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(450), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [4542] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(524), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(522), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [4599] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(456), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(454), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [4656] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(460), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(458), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [4713] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(464), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(462), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [4770] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(444), 13,
      sym__string_start,
      ts_builtin_sym_end,
      sym_float,
      anon_sym_AMP,
      sym_node_path,
      sym_get_node,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
      anon_sym_LPAREN,
    ACTIONS(442), 36,
      sym__identifier,
      sym_true,
      sym_false,
      sym_null,
      sym_static_keyword,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      sym_integer,
      anon_sym_AT,
      anon_sym_var,
      anon_sym_export,
      anon_sym_onready,
      anon_sym_const,
      anon_sym_return,
      anon_sym_pass,
      anon_sym_break,
      sym_breakpoint_statement,
      anon_sym_continue,
      sym_tool_statement,
      anon_sym_signal,
      anon_sym_class_name,
      anon_sym_DOT,
      anon_sym_extends,
      anon_sym_if,
      anon_sym_for,
      anon_sym_while,
      anon_sym_class,
      anon_sym_enum,
      anon_sym_match,
      anon_sym_not,
      anon_sym_await,
      anon_sym_func,
  [4827] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(542), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(544), 33,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_var,
      anon_sym_DOT,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_func,
  [4881] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(546), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(548), 33,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_var,
      anon_sym_DOT,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_func,
  [4935] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(550), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(552), 33,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_var,
      anon_sym_DOT,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_func,
  [4989] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(554), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(556), 33,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_var,
      anon_sym_DOT,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_func,
  [5043] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(558), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(560), 33,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_var,
      anon_sym_DOT,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_func,
  [5097] = 8,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(568), 1,
      anon_sym_is,
    ACTIONS(570), 1,
      anon_sym_as,
    ACTIONS(572), 1,
      anon_sym_LPAREN,
    STATE(248), 1,
      sym_arguments,
    ACTIONS(566), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(562), 10,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(564), 27,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_DOT,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [5159] = 10,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(568), 1,
      anon_sym_is,
    ACTIONS(570), 1,
      anon_sym_as,
    ACTIONS(572), 1,
      anon_sym_LPAREN,
    STATE(248), 1,
      sym_arguments,
    ACTIONS(574), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(576), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(566), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(562), 6,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(564), 27,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_DOT,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [5225] = 12,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(568), 1,
      anon_sym_is,
    ACTIONS(570), 1,
      anon_sym_as,
    ACTIONS(572), 1,
      anon_sym_LPAREN,
    ACTIONS(578), 1,
      anon_sym_AMP,
    ACTIONS(580), 1,
      anon_sym_CARET,
    STATE(248), 1,
      sym_arguments,
    ACTIONS(574), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(576), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(566), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(562), 4,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(564), 27,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_DOT,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [5295] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(568), 1,
      anon_sym_is,
    ACTIONS(570), 1,
      anon_sym_as,
    ACTIONS(572), 1,
      anon_sym_LPAREN,
    STATE(248), 1,
      sym_arguments,
    ACTIONS(562), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(564), 27,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_DOT,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [5355] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym__identifier,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(43), 1,
      anon_sym_DOT,
    ACTIONS(57), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_not,
    ACTIONS(67), 1,
      anon_sym_LPAREN,
    ACTIONS(69), 1,
      anon_sym_await,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(584), 1,
      anon_sym_func,
    STATE(215), 1,
      sym__primary_expression,
    STATE(810), 1,
      sym__expression,
    STATE(1292), 1,
      sym__attribute_expression,
    STATE(237), 2,
      sym_string_name,
      sym_attribute,
    STATE(1004), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(15), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(582), 3,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
    STATE(744), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(9), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(63), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(233), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [5445] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(570), 1,
      anon_sym_as,
    ACTIONS(572), 1,
      anon_sym_LPAREN,
    STATE(248), 1,
      sym_arguments,
    ACTIONS(562), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(564), 28,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_DOT,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [5503] = 14,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(568), 1,
      anon_sym_is,
    ACTIONS(570), 1,
      anon_sym_as,
    ACTIONS(572), 1,
      anon_sym_LPAREN,
    ACTIONS(578), 1,
      anon_sym_AMP,
    ACTIONS(580), 1,
      anon_sym_CARET,
    ACTIONS(588), 1,
      anon_sym_PIPE,
    STATE(248), 1,
      sym_arguments,
    ACTIONS(574), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(576), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(586), 2,
      anon_sym_and,
      anon_sym_AMP_AMP,
    ACTIONS(562), 3,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(566), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(564), 25,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_DOT,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [5577] = 13,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(568), 1,
      anon_sym_is,
    ACTIONS(570), 1,
      anon_sym_as,
    ACTIONS(572), 1,
      anon_sym_LPAREN,
    ACTIONS(578), 1,
      anon_sym_AMP,
    ACTIONS(580), 1,
      anon_sym_CARET,
    ACTIONS(588), 1,
      anon_sym_PIPE,
    STATE(248), 1,
      sym_arguments,
    ACTIONS(574), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(576), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(562), 3,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(566), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(564), 27,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_DOT,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [5649] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(570), 1,
      anon_sym_as,
    ACTIONS(572), 1,
      anon_sym_LPAREN,
    ACTIONS(578), 1,
      anon_sym_AMP,
    ACTIONS(580), 1,
      anon_sym_CARET,
    ACTIONS(588), 1,
      anon_sym_PIPE,
    ACTIONS(592), 1,
      anon_sym_EQ,
    ACTIONS(596), 1,
      anon_sym_LBRACK,
    ACTIONS(600), 1,
      anon_sym_is,
    STATE(248), 1,
      sym_arguments,
    STATE(720), 1,
      aux_sym_comparison_operator_repeat1,
    ACTIONS(574), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(576), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(586), 2,
      anon_sym_and,
      anon_sym_AMP_AMP,
    ACTIONS(598), 2,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
    ACTIONS(602), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(566), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(594), 5,
      anon_sym_in,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
    ACTIONS(590), 16,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_if,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [5733] = 4,
    ACTIONS(3), 1,
      sym_comment,
    STATE(218), 1,
      aux_sym_attribute_repeat1,
    ACTIONS(604), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(606), 30,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_DOT,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [5787] = 11,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(568), 1,
      anon_sym_is,
    ACTIONS(570), 1,
      anon_sym_as,
    ACTIONS(572), 1,
      anon_sym_LPAREN,
    ACTIONS(580), 1,
      anon_sym_CARET,
    STATE(248), 1,
      sym_arguments,
    ACTIONS(574), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(576), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(566), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(562), 5,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(564), 27,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_DOT,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [5855] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(612), 1,
      anon_sym_DOT,
    STATE(218), 1,
      aux_sym_attribute_repeat1,
    ACTIONS(608), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(610), 29,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [5911] = 5,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(615), 1,
      anon_sym_DOT,
    STATE(218), 1,
      aux_sym_attribute_repeat1,
    ACTIONS(604), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(606), 29,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [5967] = 9,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(568), 1,
      anon_sym_is,
    ACTIONS(570), 1,
      anon_sym_as,
    ACTIONS(572), 1,
      anon_sym_LPAREN,
    STATE(248), 1,
      sym_arguments,
    ACTIONS(574), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(566), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(562), 8,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(564), 27,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_DOT,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [6031] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(572), 1,
      anon_sym_LPAREN,
    ACTIONS(617), 1,
      anon_sym_LBRACK,
    STATE(258), 1,
      sym_arguments,
    ACTIONS(608), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(610), 28,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_DOT,
      anon_sym_if,
      anon_sym_in,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [6089] = 6,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(570), 1,
      anon_sym_as,
    ACTIONS(572), 1,
      anon_sym_LPAREN,
    STATE(248), 1,
      sym_arguments,
    ACTIONS(562), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(564), 28,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_DOT,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [6147] = 7,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(568), 1,
      anon_sym_is,
    ACTIONS(570), 1,
      anon_sym_as,
    ACTIONS(572), 1,
      anon_sym_LPAREN,
    STATE(248), 1,
      sym_arguments,
    ACTIONS(619), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(621), 27,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_DOT,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [6207] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(623), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(625), 30,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_DOT,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [6258] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(639), 1,
      anon_sym_RBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(649), 1,
      anon_sym_await,
    ACTIONS(651), 1,
      anon_sym_func,
    ACTIONS(653), 1,
      sym__string_start,
    STATE(472), 1,
      sym__primary_expression,
    STATE(546), 1,
      sym_identifier,
    STATE(1120), 1,
      sym__expression,
    STATE(1134), 1,
      sym__attribute_expression,
    STATE(1186), 1,
      sym_pair,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    STATE(1342), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1006), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 9,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [6351] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(649), 1,
      anon_sym_await,
    ACTIONS(651), 1,
      anon_sym_func,
    ACTIONS(653), 1,
      sym__string_start,
    ACTIONS(655), 1,
      anon_sym_RBRACE,
    STATE(472), 1,
      sym__primary_expression,
    STATE(546), 1,
      sym_identifier,
    STATE(1120), 1,
      sym__expression,
    STATE(1134), 1,
      sym__attribute_expression,
    STATE(1186), 1,
      sym_pair,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    STATE(1342), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1006), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 9,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [6444] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(649), 1,
      anon_sym_await,
    ACTIONS(651), 1,
      anon_sym_func,
    ACTIONS(653), 1,
      sym__string_start,
    ACTIONS(657), 1,
      anon_sym_RBRACE,
    STATE(472), 1,
      sym__primary_expression,
    STATE(546), 1,
      sym_identifier,
    STATE(945), 1,
      sym_pair,
    STATE(1120), 1,
      sym__expression,
    STATE(1134), 1,
      sym__attribute_expression,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    STATE(1342), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1006), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 9,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [6537] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(659), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(661), 30,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_DOT,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [6588] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(649), 1,
      anon_sym_await,
    ACTIONS(651), 1,
      anon_sym_func,
    ACTIONS(653), 1,
      sym__string_start,
    ACTIONS(663), 1,
      anon_sym_RBRACE,
    STATE(472), 1,
      sym__primary_expression,
    STATE(546), 1,
      sym_identifier,
    STATE(1030), 1,
      sym_pair,
    STATE(1120), 1,
      sym__expression,
    STATE(1134), 1,
      sym__attribute_expression,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    STATE(1342), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1006), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 9,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [6681] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(568), 1,
      anon_sym_is,
    ACTIONS(570), 1,
      anon_sym_as,
    ACTIONS(572), 1,
      anon_sym_LPAREN,
    ACTIONS(578), 1,
      anon_sym_AMP,
    ACTIONS(580), 1,
      anon_sym_CARET,
    ACTIONS(588), 1,
      anon_sym_PIPE,
    ACTIONS(596), 1,
      anon_sym_LBRACK,
    STATE(248), 1,
      sym_arguments,
    ACTIONS(574), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(576), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(586), 2,
      anon_sym_and,
      anon_sym_AMP_AMP,
    ACTIONS(598), 2,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
    ACTIONS(566), 3,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
    ACTIONS(667), 3,
      anon_sym_EQ,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(665), 21,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [6758] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(562), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(564), 30,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_DOT,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [6809] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(608), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(610), 30,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_DOT,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [6860] = 4,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(673), 1,
      anon_sym_DOT,
    ACTIONS(669), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(671), 29,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [6913] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(675), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(677), 30,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_DOT,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [6964] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(649), 1,
      anon_sym_await,
    ACTIONS(651), 1,
      anon_sym_func,
    ACTIONS(653), 1,
      sym__string_start,
    ACTIONS(679), 1,
      anon_sym_RBRACE,
    STATE(472), 1,
      sym__primary_expression,
    STATE(546), 1,
      sym_identifier,
    STATE(946), 1,
      sym_pair,
    STATE(1120), 1,
      sym__expression,
    STATE(1134), 1,
      sym__attribute_expression,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    STATE(1342), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1006), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 9,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [7057] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(649), 1,
      anon_sym_await,
    ACTIONS(651), 1,
      anon_sym_func,
    ACTIONS(653), 1,
      sym__string_start,
    ACTIONS(681), 1,
      anon_sym_RBRACE,
    STATE(472), 1,
      sym__primary_expression,
    STATE(546), 1,
      sym_identifier,
    STATE(1120), 1,
      sym__expression,
    STATE(1134), 1,
      sym__attribute_expression,
    STATE(1186), 1,
      sym_pair,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    STATE(1342), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1006), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 9,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [7150] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(669), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(671), 30,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_DOT,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [7201] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(683), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(685), 30,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_DOT,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [7252] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(687), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(689), 30,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_DOT,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [7303] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(691), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(693), 30,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_DOT,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [7354] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(649), 1,
      anon_sym_await,
    ACTIONS(651), 1,
      anon_sym_func,
    ACTIONS(653), 1,
      sym__string_start,
    ACTIONS(695), 1,
      anon_sym_RBRACE,
    STATE(472), 1,
      sym__primary_expression,
    STATE(546), 1,
      sym_identifier,
    STATE(1120), 1,
      sym__expression,
    STATE(1134), 1,
      sym__attribute_expression,
    STATE(1186), 1,
      sym_pair,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    STATE(1342), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1006), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 9,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [7447] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(649), 1,
      anon_sym_await,
    ACTIONS(651), 1,
      anon_sym_func,
    ACTIONS(653), 1,
      sym__string_start,
    ACTIONS(697), 1,
      anon_sym_RBRACE,
    STATE(472), 1,
      sym__primary_expression,
    STATE(546), 1,
      sym_identifier,
    STATE(1120), 1,
      sym__expression,
    STATE(1134), 1,
      sym__attribute_expression,
    STATE(1186), 1,
      sym_pair,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    STATE(1342), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1006), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 9,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [7540] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(649), 1,
      anon_sym_await,
    ACTIONS(651), 1,
      anon_sym_func,
    ACTIONS(653), 1,
      sym__string_start,
    ACTIONS(699), 1,
      anon_sym_RBRACE,
    STATE(472), 1,
      sym__primary_expression,
    STATE(546), 1,
      sym_identifier,
    STATE(1120), 1,
      sym__expression,
    STATE(1134), 1,
      sym__attribute_expression,
    STATE(1186), 1,
      sym_pair,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    STATE(1342), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1006), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 9,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [7633] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(649), 1,
      anon_sym_await,
    ACTIONS(651), 1,
      anon_sym_func,
    ACTIONS(653), 1,
      sym__string_start,
    ACTIONS(701), 1,
      anon_sym_RBRACE,
    STATE(472), 1,
      sym__primary_expression,
    STATE(546), 1,
      sym_identifier,
    STATE(1120), 1,
      sym__expression,
    STATE(1134), 1,
      sym__attribute_expression,
    STATE(1186), 1,
      sym_pair,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    STATE(1342), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1006), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 9,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [7726] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(703), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(705), 30,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_DOT,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [7777] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(649), 1,
      anon_sym_await,
    ACTIONS(651), 1,
      anon_sym_func,
    ACTIONS(653), 1,
      sym__string_start,
    ACTIONS(707), 1,
      anon_sym_RBRACE,
    STATE(472), 1,
      sym__primary_expression,
    STATE(546), 1,
      sym_identifier,
    STATE(965), 1,
      sym_pair,
    STATE(1120), 1,
      sym__expression,
    STATE(1134), 1,
      sym__attribute_expression,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    STATE(1342), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1006), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 9,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [7870] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(709), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(711), 30,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_DOT,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [7921] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(713), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(715), 30,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_DOT,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [7972] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(717), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(719), 30,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_DOT,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [8023] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(721), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(723), 30,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_DOT,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [8074] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(725), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(727), 30,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_DOT,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [8125] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(649), 1,
      anon_sym_await,
    ACTIONS(651), 1,
      anon_sym_func,
    ACTIONS(653), 1,
      sym__string_start,
    ACTIONS(729), 1,
      anon_sym_RBRACE,
    STATE(472), 1,
      sym__primary_expression,
    STATE(546), 1,
      sym_identifier,
    STATE(1120), 1,
      sym__expression,
    STATE(1134), 1,
      sym__attribute_expression,
    STATE(1186), 1,
      sym_pair,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    STATE(1342), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1006), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 9,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [8218] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(649), 1,
      anon_sym_await,
    ACTIONS(651), 1,
      anon_sym_func,
    ACTIONS(653), 1,
      sym__string_start,
    ACTIONS(731), 1,
      anon_sym_RBRACE,
    STATE(472), 1,
      sym__primary_expression,
    STATE(546), 1,
      sym_identifier,
    STATE(1120), 1,
      sym__expression,
    STATE(1134), 1,
      sym__attribute_expression,
    STATE(1186), 1,
      sym_pair,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    STATE(1342), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1006), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 9,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [8311] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(733), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(735), 30,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_DOT,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [8362] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(649), 1,
      anon_sym_await,
    ACTIONS(651), 1,
      anon_sym_func,
    ACTIONS(653), 1,
      sym__string_start,
    ACTIONS(737), 1,
      anon_sym_RBRACE,
    STATE(472), 1,
      sym__primary_expression,
    STATE(546), 1,
      sym_identifier,
    STATE(1120), 1,
      sym__expression,
    STATE(1134), 1,
      sym__attribute_expression,
    STATE(1186), 1,
      sym_pair,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    STATE(1342), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1006), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 9,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [8455] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(739), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(741), 30,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_DOT,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [8506] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(649), 1,
      anon_sym_await,
    ACTIONS(651), 1,
      anon_sym_func,
    ACTIONS(653), 1,
      sym__string_start,
    ACTIONS(743), 1,
      anon_sym_RBRACE,
    STATE(472), 1,
      sym__primary_expression,
    STATE(546), 1,
      sym_identifier,
    STATE(1120), 1,
      sym__expression,
    STATE(1134), 1,
      sym__attribute_expression,
    STATE(1186), 1,
      sym_pair,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    STATE(1342), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1006), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 9,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [8599] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(745), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(747), 30,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_DOT,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [8650] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(649), 1,
      anon_sym_await,
    ACTIONS(651), 1,
      anon_sym_func,
    ACTIONS(653), 1,
      sym__string_start,
    ACTIONS(749), 1,
      anon_sym_RBRACE,
    STATE(472), 1,
      sym__primary_expression,
    STATE(546), 1,
      sym_identifier,
    STATE(918), 1,
      sym_pair,
    STATE(1120), 1,
      sym__expression,
    STATE(1134), 1,
      sym__attribute_expression,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    STATE(1342), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1006), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 9,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [8743] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(649), 1,
      anon_sym_await,
    ACTIONS(651), 1,
      anon_sym_func,
    ACTIONS(653), 1,
      sym__string_start,
    ACTIONS(751), 1,
      anon_sym_RBRACE,
    STATE(472), 1,
      sym__primary_expression,
    STATE(546), 1,
      sym_identifier,
    STATE(1001), 1,
      sym_pair,
    STATE(1120), 1,
      sym__expression,
    STATE(1134), 1,
      sym__attribute_expression,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    STATE(1342), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1006), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 9,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [8836] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(649), 1,
      anon_sym_await,
    ACTIONS(651), 1,
      anon_sym_func,
    ACTIONS(653), 1,
      sym__string_start,
    ACTIONS(753), 1,
      anon_sym_RBRACE,
    STATE(472), 1,
      sym__primary_expression,
    STATE(546), 1,
      sym_identifier,
    STATE(1120), 1,
      sym__expression,
    STATE(1134), 1,
      sym__attribute_expression,
    STATE(1186), 1,
      sym_pair,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    STATE(1342), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1006), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 9,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [8929] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(755), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(757), 30,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_DOT,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [8980] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(649), 1,
      anon_sym_await,
    ACTIONS(651), 1,
      anon_sym_func,
    ACTIONS(653), 1,
      sym__string_start,
    ACTIONS(759), 1,
      anon_sym_RBRACE,
    STATE(472), 1,
      sym__primary_expression,
    STATE(546), 1,
      sym_identifier,
    STATE(1120), 1,
      sym__expression,
    STATE(1134), 1,
      sym__attribute_expression,
    STATE(1186), 1,
      sym_pair,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    STATE(1342), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1006), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 9,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [9073] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(761), 13,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(763), 30,
      sym__newline,
      sym__body_end,
      anon_sym_SEMI,
      anon_sym_COLON,
      anon_sym_setget,
      anon_sym_DOT,
      anon_sym_if,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_CARET_EQ,
      anon_sym_PIPE_EQ,
  [9124] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(649), 1,
      anon_sym_await,
    ACTIONS(651), 1,
      anon_sym_func,
    ACTIONS(653), 1,
      sym__string_start,
    ACTIONS(765), 1,
      anon_sym_RBRACE,
    STATE(472), 1,
      sym__primary_expression,
    STATE(546), 1,
      sym_identifier,
    STATE(1120), 1,
      sym__expression,
    STATE(1134), 1,
      sym__attribute_expression,
    STATE(1186), 1,
      sym_pair,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    STATE(1342), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1006), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 9,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [9217] = 24,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(649), 1,
      anon_sym_await,
    ACTIONS(651), 1,
      anon_sym_func,
    ACTIONS(653), 1,
      sym__string_start,
    ACTIONS(767), 1,
      anon_sym_RBRACE,
    STATE(472), 1,
      sym__primary_expression,
    STATE(546), 1,
      sym_identifier,
    STATE(1079), 1,
      sym_pair,
    STATE(1120), 1,
      sym__expression,
    STATE(1134), 1,
      sym__attribute_expression,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    STATE(1342), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1006), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 9,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [9310] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(769), 1,
      sym__identifier,
    ACTIONS(775), 1,
      anon_sym_AMP,
    ACTIONS(777), 1,
      anon_sym_DOT,
    ACTIONS(779), 1,
      anon_sym_LBRACE,
    ACTIONS(781), 1,
      anon_sym_LBRACK,
    ACTIONS(783), 1,
      anon_sym_RBRACK,
    ACTIONS(787), 1,
      anon_sym_not,
    ACTIONS(789), 1,
      anon_sym_LPAREN,
    ACTIONS(791), 1,
      anon_sym_await,
    ACTIONS(793), 1,
      anon_sym_func,
    ACTIONS(795), 1,
      sym__string_start,
    STATE(529), 1,
      sym__primary_expression,
    STATE(926), 1,
      sym__expression,
    STATE(1103), 1,
      sym__attribute_expression,
    STATE(613), 2,
      sym_string_name,
      sym_attribute,
    STATE(1181), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(773), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(928), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(771), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(785), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(610), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [9398] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(797), 1,
      sym__identifier,
    ACTIONS(803), 1,
      anon_sym_AMP,
    ACTIONS(805), 1,
      anon_sym_DOT,
    ACTIONS(807), 1,
      anon_sym_LBRACE,
    ACTIONS(809), 1,
      anon_sym_LBRACK,
    ACTIONS(813), 1,
      anon_sym_not,
    ACTIONS(815), 1,
      anon_sym_LPAREN,
    ACTIONS(817), 1,
      anon_sym_RPAREN,
    ACTIONS(819), 1,
      anon_sym_await,
    ACTIONS(821), 1,
      anon_sym_func,
    ACTIONS(823), 1,
      sym__string_start,
    STATE(468), 1,
      sym__primary_expression,
    STATE(1088), 1,
      sym__expression,
    STATE(1215), 1,
      sym__attribute_expression,
    STATE(534), 2,
      sym_string_name,
      sym_attribute,
    STATE(1081), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(801), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1092), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(799), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(811), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(537), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [9486] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(769), 1,
      sym__identifier,
    ACTIONS(775), 1,
      anon_sym_AMP,
    ACTIONS(777), 1,
      anon_sym_DOT,
    ACTIONS(779), 1,
      anon_sym_LBRACE,
    ACTIONS(781), 1,
      anon_sym_LBRACK,
    ACTIONS(787), 1,
      anon_sym_not,
    ACTIONS(789), 1,
      anon_sym_LPAREN,
    ACTIONS(791), 1,
      anon_sym_await,
    ACTIONS(793), 1,
      anon_sym_func,
    ACTIONS(795), 1,
      sym__string_start,
    ACTIONS(825), 1,
      anon_sym_RBRACK,
    STATE(529), 1,
      sym__primary_expression,
    STATE(926), 1,
      sym__expression,
    STATE(1103), 1,
      sym__attribute_expression,
    STATE(613), 2,
      sym_string_name,
      sym_attribute,
    STATE(917), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(773), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(928), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(771), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(785), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(610), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [9574] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(769), 1,
      sym__identifier,
    ACTIONS(775), 1,
      anon_sym_AMP,
    ACTIONS(777), 1,
      anon_sym_DOT,
    ACTIONS(779), 1,
      anon_sym_LBRACE,
    ACTIONS(781), 1,
      anon_sym_LBRACK,
    ACTIONS(787), 1,
      anon_sym_not,
    ACTIONS(789), 1,
      anon_sym_LPAREN,
    ACTIONS(791), 1,
      anon_sym_await,
    ACTIONS(793), 1,
      anon_sym_func,
    ACTIONS(795), 1,
      sym__string_start,
    ACTIONS(827), 1,
      anon_sym_RBRACK,
    STATE(529), 1,
      sym__primary_expression,
    STATE(926), 1,
      sym__expression,
    STATE(1103), 1,
      sym__attribute_expression,
    STATE(613), 2,
      sym_string_name,
      sym_attribute,
    STATE(1080), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(773), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(928), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(771), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(785), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(610), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [9662] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(797), 1,
      sym__identifier,
    ACTIONS(803), 1,
      anon_sym_AMP,
    ACTIONS(805), 1,
      anon_sym_DOT,
    ACTIONS(807), 1,
      anon_sym_LBRACE,
    ACTIONS(809), 1,
      anon_sym_LBRACK,
    ACTIONS(813), 1,
      anon_sym_not,
    ACTIONS(815), 1,
      anon_sym_LPAREN,
    ACTIONS(819), 1,
      anon_sym_await,
    ACTIONS(821), 1,
      anon_sym_func,
    ACTIONS(823), 1,
      sym__string_start,
    ACTIONS(829), 1,
      anon_sym_RPAREN,
    STATE(468), 1,
      sym__primary_expression,
    STATE(1088), 1,
      sym__expression,
    STATE(1215), 1,
      sym__attribute_expression,
    STATE(534), 2,
      sym_string_name,
      sym_attribute,
    STATE(1242), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(801), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1092), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(799), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(811), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(537), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [9750] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(769), 1,
      sym__identifier,
    ACTIONS(775), 1,
      anon_sym_AMP,
    ACTIONS(777), 1,
      anon_sym_DOT,
    ACTIONS(779), 1,
      anon_sym_LBRACE,
    ACTIONS(781), 1,
      anon_sym_LBRACK,
    ACTIONS(787), 1,
      anon_sym_not,
    ACTIONS(789), 1,
      anon_sym_LPAREN,
    ACTIONS(791), 1,
      anon_sym_await,
    ACTIONS(793), 1,
      anon_sym_func,
    ACTIONS(795), 1,
      sym__string_start,
    ACTIONS(831), 1,
      anon_sym_RBRACK,
    STATE(529), 1,
      sym__primary_expression,
    STATE(926), 1,
      sym__expression,
    STATE(1103), 1,
      sym__attribute_expression,
    STATE(613), 2,
      sym_string_name,
      sym_attribute,
    STATE(1181), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(773), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(928), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(771), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(785), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(610), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [9838] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(769), 1,
      sym__identifier,
    ACTIONS(775), 1,
      anon_sym_AMP,
    ACTIONS(777), 1,
      anon_sym_DOT,
    ACTIONS(779), 1,
      anon_sym_LBRACE,
    ACTIONS(781), 1,
      anon_sym_LBRACK,
    ACTIONS(787), 1,
      anon_sym_not,
    ACTIONS(789), 1,
      anon_sym_LPAREN,
    ACTIONS(791), 1,
      anon_sym_await,
    ACTIONS(793), 1,
      anon_sym_func,
    ACTIONS(795), 1,
      sym__string_start,
    ACTIONS(833), 1,
      anon_sym_RBRACK,
    STATE(529), 1,
      sym__primary_expression,
    STATE(926), 1,
      sym__expression,
    STATE(1103), 1,
      sym__attribute_expression,
    STATE(613), 2,
      sym_string_name,
      sym_attribute,
    STATE(1181), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(773), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(928), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(771), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(785), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(610), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [9926] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(797), 1,
      sym__identifier,
    ACTIONS(803), 1,
      anon_sym_AMP,
    ACTIONS(805), 1,
      anon_sym_DOT,
    ACTIONS(807), 1,
      anon_sym_LBRACE,
    ACTIONS(809), 1,
      anon_sym_LBRACK,
    ACTIONS(813), 1,
      anon_sym_not,
    ACTIONS(815), 1,
      anon_sym_LPAREN,
    ACTIONS(819), 1,
      anon_sym_await,
    ACTIONS(821), 1,
      anon_sym_func,
    ACTIONS(823), 1,
      sym__string_start,
    ACTIONS(835), 1,
      anon_sym_RPAREN,
    STATE(468), 1,
      sym__primary_expression,
    STATE(1088), 1,
      sym__expression,
    STATE(1215), 1,
      sym__attribute_expression,
    STATE(534), 2,
      sym_string_name,
      sym_attribute,
    STATE(1242), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(801), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1092), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(799), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(811), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(537), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [10014] = 23,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(649), 1,
      anon_sym_await,
    ACTIONS(651), 1,
      anon_sym_func,
    ACTIONS(653), 1,
      sym__string_start,
    STATE(472), 1,
      sym__primary_expression,
    STATE(546), 1,
      sym_identifier,
    STATE(1120), 1,
      sym__expression,
    STATE(1134), 1,
      sym__attribute_expression,
    STATE(1186), 1,
      sym_pair,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    STATE(1342), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1006), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 9,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [10104] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(797), 1,
      sym__identifier,
    ACTIONS(803), 1,
      anon_sym_AMP,
    ACTIONS(805), 1,
      anon_sym_DOT,
    ACTIONS(807), 1,
      anon_sym_LBRACE,
    ACTIONS(809), 1,
      anon_sym_LBRACK,
    ACTIONS(813), 1,
      anon_sym_not,
    ACTIONS(815), 1,
      anon_sym_LPAREN,
    ACTIONS(819), 1,
      anon_sym_await,
    ACTIONS(821), 1,
      anon_sym_func,
    ACTIONS(823), 1,
      sym__string_start,
    ACTIONS(837), 1,
      anon_sym_RPAREN,
    STATE(468), 1,
      sym__primary_expression,
    STATE(1088), 1,
      sym__expression,
    STATE(1215), 1,
      sym__attribute_expression,
    STATE(534), 2,
      sym_string_name,
      sym_attribute,
    STATE(915), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(801), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1092), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(799), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(811), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(537), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [10192] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(797), 1,
      sym__identifier,
    ACTIONS(803), 1,
      anon_sym_AMP,
    ACTIONS(805), 1,
      anon_sym_DOT,
    ACTIONS(807), 1,
      anon_sym_LBRACE,
    ACTIONS(809), 1,
      anon_sym_LBRACK,
    ACTIONS(813), 1,
      anon_sym_not,
    ACTIONS(815), 1,
      anon_sym_LPAREN,
    ACTIONS(819), 1,
      anon_sym_await,
    ACTIONS(821), 1,
      anon_sym_func,
    ACTIONS(823), 1,
      sym__string_start,
    ACTIONS(839), 1,
      anon_sym_RPAREN,
    STATE(468), 1,
      sym__primary_expression,
    STATE(1088), 1,
      sym__expression,
    STATE(1215), 1,
      sym__attribute_expression,
    STATE(534), 2,
      sym_string_name,
      sym_attribute,
    STATE(1242), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(801), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1092), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(799), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(811), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(537), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [10280] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(769), 1,
      sym__identifier,
    ACTIONS(775), 1,
      anon_sym_AMP,
    ACTIONS(777), 1,
      anon_sym_DOT,
    ACTIONS(779), 1,
      anon_sym_LBRACE,
    ACTIONS(781), 1,
      anon_sym_LBRACK,
    ACTIONS(787), 1,
      anon_sym_not,
    ACTIONS(789), 1,
      anon_sym_LPAREN,
    ACTIONS(791), 1,
      anon_sym_await,
    ACTIONS(793), 1,
      anon_sym_func,
    ACTIONS(795), 1,
      sym__string_start,
    ACTIONS(841), 1,
      anon_sym_RBRACK,
    STATE(529), 1,
      sym__primary_expression,
    STATE(926), 1,
      sym__expression,
    STATE(1103), 1,
      sym__attribute_expression,
    STATE(613), 2,
      sym_string_name,
      sym_attribute,
    STATE(1181), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(773), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(928), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(771), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(785), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(610), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [10368] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(769), 1,
      sym__identifier,
    ACTIONS(775), 1,
      anon_sym_AMP,
    ACTIONS(777), 1,
      anon_sym_DOT,
    ACTIONS(779), 1,
      anon_sym_LBRACE,
    ACTIONS(781), 1,
      anon_sym_LBRACK,
    ACTIONS(787), 1,
      anon_sym_not,
    ACTIONS(789), 1,
      anon_sym_LPAREN,
    ACTIONS(791), 1,
      anon_sym_await,
    ACTIONS(793), 1,
      anon_sym_func,
    ACTIONS(795), 1,
      sym__string_start,
    ACTIONS(843), 1,
      anon_sym_RBRACK,
    STATE(529), 1,
      sym__primary_expression,
    STATE(926), 1,
      sym__expression,
    STATE(1103), 1,
      sym__attribute_expression,
    STATE(613), 2,
      sym_string_name,
      sym_attribute,
    STATE(1000), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(773), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(928), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(771), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(785), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(610), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [10456] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(769), 1,
      sym__identifier,
    ACTIONS(775), 1,
      anon_sym_AMP,
    ACTIONS(777), 1,
      anon_sym_DOT,
    ACTIONS(779), 1,
      anon_sym_LBRACE,
    ACTIONS(781), 1,
      anon_sym_LBRACK,
    ACTIONS(787), 1,
      anon_sym_not,
    ACTIONS(789), 1,
      anon_sym_LPAREN,
    ACTIONS(791), 1,
      anon_sym_await,
    ACTIONS(793), 1,
      anon_sym_func,
    ACTIONS(795), 1,
      sym__string_start,
    ACTIONS(845), 1,
      anon_sym_RBRACK,
    STATE(529), 1,
      sym__primary_expression,
    STATE(926), 1,
      sym__expression,
    STATE(1103), 1,
      sym__attribute_expression,
    STATE(613), 2,
      sym_string_name,
      sym_attribute,
    STATE(1181), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(773), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(928), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(771), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(785), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(610), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [10544] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(769), 1,
      sym__identifier,
    ACTIONS(775), 1,
      anon_sym_AMP,
    ACTIONS(777), 1,
      anon_sym_DOT,
    ACTIONS(779), 1,
      anon_sym_LBRACE,
    ACTIONS(781), 1,
      anon_sym_LBRACK,
    ACTIONS(787), 1,
      anon_sym_not,
    ACTIONS(789), 1,
      anon_sym_LPAREN,
    ACTIONS(791), 1,
      anon_sym_await,
    ACTIONS(793), 1,
      anon_sym_func,
    ACTIONS(795), 1,
      sym__string_start,
    ACTIONS(847), 1,
      anon_sym_RBRACK,
    STATE(529), 1,
      sym__primary_expression,
    STATE(926), 1,
      sym__expression,
    STATE(1103), 1,
      sym__attribute_expression,
    STATE(613), 2,
      sym_string_name,
      sym_attribute,
    STATE(1181), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(773), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(928), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(771), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(785), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(610), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [10632] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(797), 1,
      sym__identifier,
    ACTIONS(803), 1,
      anon_sym_AMP,
    ACTIONS(805), 1,
      anon_sym_DOT,
    ACTIONS(807), 1,
      anon_sym_LBRACE,
    ACTIONS(809), 1,
      anon_sym_LBRACK,
    ACTIONS(813), 1,
      anon_sym_not,
    ACTIONS(815), 1,
      anon_sym_LPAREN,
    ACTIONS(819), 1,
      anon_sym_await,
    ACTIONS(821), 1,
      anon_sym_func,
    ACTIONS(823), 1,
      sym__string_start,
    ACTIONS(849), 1,
      anon_sym_RPAREN,
    STATE(468), 1,
      sym__primary_expression,
    STATE(1088), 1,
      sym__expression,
    STATE(1215), 1,
      sym__attribute_expression,
    STATE(534), 2,
      sym_string_name,
      sym_attribute,
    STATE(999), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(801), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1092), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(799), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(811), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(537), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [10720] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(769), 1,
      sym__identifier,
    ACTIONS(775), 1,
      anon_sym_AMP,
    ACTIONS(777), 1,
      anon_sym_DOT,
    ACTIONS(779), 1,
      anon_sym_LBRACE,
    ACTIONS(781), 1,
      anon_sym_LBRACK,
    ACTIONS(787), 1,
      anon_sym_not,
    ACTIONS(789), 1,
      anon_sym_LPAREN,
    ACTIONS(791), 1,
      anon_sym_await,
    ACTIONS(793), 1,
      anon_sym_func,
    ACTIONS(795), 1,
      sym__string_start,
    ACTIONS(851), 1,
      anon_sym_RBRACK,
    STATE(529), 1,
      sym__primary_expression,
    STATE(926), 1,
      sym__expression,
    STATE(1103), 1,
      sym__attribute_expression,
    STATE(613), 2,
      sym_string_name,
      sym_attribute,
    STATE(1181), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(773), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(928), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(771), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(785), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(610), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [10808] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(769), 1,
      sym__identifier,
    ACTIONS(775), 1,
      anon_sym_AMP,
    ACTIONS(777), 1,
      anon_sym_DOT,
    ACTIONS(779), 1,
      anon_sym_LBRACE,
    ACTIONS(781), 1,
      anon_sym_LBRACK,
    ACTIONS(787), 1,
      anon_sym_not,
    ACTIONS(789), 1,
      anon_sym_LPAREN,
    ACTIONS(791), 1,
      anon_sym_await,
    ACTIONS(793), 1,
      anon_sym_func,
    ACTIONS(795), 1,
      sym__string_start,
    ACTIONS(853), 1,
      anon_sym_RBRACK,
    STATE(529), 1,
      sym__primary_expression,
    STATE(926), 1,
      sym__expression,
    STATE(1103), 1,
      sym__attribute_expression,
    STATE(613), 2,
      sym_string_name,
      sym_attribute,
    STATE(1181), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(773), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(928), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(771), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(785), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(610), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [10896] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(769), 1,
      sym__identifier,
    ACTIONS(775), 1,
      anon_sym_AMP,
    ACTIONS(777), 1,
      anon_sym_DOT,
    ACTIONS(779), 1,
      anon_sym_LBRACE,
    ACTIONS(781), 1,
      anon_sym_LBRACK,
    ACTIONS(787), 1,
      anon_sym_not,
    ACTIONS(789), 1,
      anon_sym_LPAREN,
    ACTIONS(791), 1,
      anon_sym_await,
    ACTIONS(793), 1,
      anon_sym_func,
    ACTIONS(795), 1,
      sym__string_start,
    ACTIONS(855), 1,
      anon_sym_RBRACK,
    STATE(529), 1,
      sym__primary_expression,
    STATE(926), 1,
      sym__expression,
    STATE(1103), 1,
      sym__attribute_expression,
    STATE(613), 2,
      sym_string_name,
      sym_attribute,
    STATE(1181), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(773), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(928), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(771), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(785), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(610), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [10984] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(797), 1,
      sym__identifier,
    ACTIONS(803), 1,
      anon_sym_AMP,
    ACTIONS(805), 1,
      anon_sym_DOT,
    ACTIONS(807), 1,
      anon_sym_LBRACE,
    ACTIONS(809), 1,
      anon_sym_LBRACK,
    ACTIONS(813), 1,
      anon_sym_not,
    ACTIONS(815), 1,
      anon_sym_LPAREN,
    ACTIONS(819), 1,
      anon_sym_await,
    ACTIONS(821), 1,
      anon_sym_func,
    ACTIONS(823), 1,
      sym__string_start,
    ACTIONS(857), 1,
      anon_sym_RPAREN,
    STATE(468), 1,
      sym__primary_expression,
    STATE(1088), 1,
      sym__expression,
    STATE(1215), 1,
      sym__attribute_expression,
    STATE(534), 2,
      sym_string_name,
      sym_attribute,
    STATE(1242), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(801), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1092), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(799), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(811), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(537), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [11072] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(769), 1,
      sym__identifier,
    ACTIONS(775), 1,
      anon_sym_AMP,
    ACTIONS(777), 1,
      anon_sym_DOT,
    ACTIONS(779), 1,
      anon_sym_LBRACE,
    ACTIONS(781), 1,
      anon_sym_LBRACK,
    ACTIONS(787), 1,
      anon_sym_not,
    ACTIONS(789), 1,
      anon_sym_LPAREN,
    ACTIONS(791), 1,
      anon_sym_await,
    ACTIONS(793), 1,
      anon_sym_func,
    ACTIONS(795), 1,
      sym__string_start,
    ACTIONS(859), 1,
      anon_sym_RBRACK,
    STATE(529), 1,
      sym__primary_expression,
    STATE(926), 1,
      sym__expression,
    STATE(1103), 1,
      sym__attribute_expression,
    STATE(613), 2,
      sym_string_name,
      sym_attribute,
    STATE(1181), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(773), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(928), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(771), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(785), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(610), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [11160] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(769), 1,
      sym__identifier,
    ACTIONS(775), 1,
      anon_sym_AMP,
    ACTIONS(777), 1,
      anon_sym_DOT,
    ACTIONS(779), 1,
      anon_sym_LBRACE,
    ACTIONS(781), 1,
      anon_sym_LBRACK,
    ACTIONS(787), 1,
      anon_sym_not,
    ACTIONS(789), 1,
      anon_sym_LPAREN,
    ACTIONS(791), 1,
      anon_sym_await,
    ACTIONS(793), 1,
      anon_sym_func,
    ACTIONS(795), 1,
      sym__string_start,
    ACTIONS(861), 1,
      anon_sym_RBRACK,
    STATE(529), 1,
      sym__primary_expression,
    STATE(926), 1,
      sym__expression,
    STATE(1103), 1,
      sym__attribute_expression,
    STATE(613), 2,
      sym_string_name,
      sym_attribute,
    STATE(943), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(773), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(928), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(771), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(785), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(610), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [11248] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(797), 1,
      sym__identifier,
    ACTIONS(803), 1,
      anon_sym_AMP,
    ACTIONS(805), 1,
      anon_sym_DOT,
    ACTIONS(807), 1,
      anon_sym_LBRACE,
    ACTIONS(809), 1,
      anon_sym_LBRACK,
    ACTIONS(813), 1,
      anon_sym_not,
    ACTIONS(815), 1,
      anon_sym_LPAREN,
    ACTIONS(819), 1,
      anon_sym_await,
    ACTIONS(821), 1,
      anon_sym_func,
    ACTIONS(823), 1,
      sym__string_start,
    ACTIONS(863), 1,
      anon_sym_RPAREN,
    STATE(468), 1,
      sym__primary_expression,
    STATE(1088), 1,
      sym__expression,
    STATE(1215), 1,
      sym__attribute_expression,
    STATE(534), 2,
      sym_string_name,
      sym_attribute,
    STATE(1242), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(801), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1092), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(799), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(811), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(537), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [11336] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(797), 1,
      sym__identifier,
    ACTIONS(803), 1,
      anon_sym_AMP,
    ACTIONS(805), 1,
      anon_sym_DOT,
    ACTIONS(807), 1,
      anon_sym_LBRACE,
    ACTIONS(809), 1,
      anon_sym_LBRACK,
    ACTIONS(813), 1,
      anon_sym_not,
    ACTIONS(815), 1,
      anon_sym_LPAREN,
    ACTIONS(819), 1,
      anon_sym_await,
    ACTIONS(821), 1,
      anon_sym_func,
    ACTIONS(823), 1,
      sym__string_start,
    ACTIONS(865), 1,
      anon_sym_RPAREN,
    STATE(468), 1,
      sym__primary_expression,
    STATE(1088), 1,
      sym__expression,
    STATE(1215), 1,
      sym__attribute_expression,
    STATE(534), 2,
      sym_string_name,
      sym_attribute,
    STATE(1242), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(801), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1092), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(799), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(811), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(537), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [11424] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(797), 1,
      sym__identifier,
    ACTIONS(803), 1,
      anon_sym_AMP,
    ACTIONS(805), 1,
      anon_sym_DOT,
    ACTIONS(807), 1,
      anon_sym_LBRACE,
    ACTIONS(809), 1,
      anon_sym_LBRACK,
    ACTIONS(813), 1,
      anon_sym_not,
    ACTIONS(815), 1,
      anon_sym_LPAREN,
    ACTIONS(819), 1,
      anon_sym_await,
    ACTIONS(821), 1,
      anon_sym_func,
    ACTIONS(823), 1,
      sym__string_start,
    ACTIONS(867), 1,
      anon_sym_RPAREN,
    STATE(468), 1,
      sym__primary_expression,
    STATE(1088), 1,
      sym__expression,
    STATE(1215), 1,
      sym__attribute_expression,
    STATE(534), 2,
      sym_string_name,
      sym_attribute,
    STATE(1242), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(801), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1092), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(799), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(811), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(537), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [11512] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(797), 1,
      sym__identifier,
    ACTIONS(803), 1,
      anon_sym_AMP,
    ACTIONS(805), 1,
      anon_sym_DOT,
    ACTIONS(807), 1,
      anon_sym_LBRACE,
    ACTIONS(809), 1,
      anon_sym_LBRACK,
    ACTIONS(813), 1,
      anon_sym_not,
    ACTIONS(815), 1,
      anon_sym_LPAREN,
    ACTIONS(819), 1,
      anon_sym_await,
    ACTIONS(821), 1,
      anon_sym_func,
    ACTIONS(823), 1,
      sym__string_start,
    ACTIONS(869), 1,
      anon_sym_RPAREN,
    STATE(468), 1,
      sym__primary_expression,
    STATE(1088), 1,
      sym__expression,
    STATE(1215), 1,
      sym__attribute_expression,
    STATE(534), 2,
      sym_string_name,
      sym_attribute,
    STATE(1242), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(801), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1092), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(799), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(811), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(537), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [11600] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(769), 1,
      sym__identifier,
    ACTIONS(775), 1,
      anon_sym_AMP,
    ACTIONS(777), 1,
      anon_sym_DOT,
    ACTIONS(779), 1,
      anon_sym_LBRACE,
    ACTIONS(781), 1,
      anon_sym_LBRACK,
    ACTIONS(787), 1,
      anon_sym_not,
    ACTIONS(789), 1,
      anon_sym_LPAREN,
    ACTIONS(791), 1,
      anon_sym_await,
    ACTIONS(793), 1,
      anon_sym_func,
    ACTIONS(795), 1,
      sym__string_start,
    ACTIONS(871), 1,
      anon_sym_RBRACK,
    STATE(529), 1,
      sym__primary_expression,
    STATE(926), 1,
      sym__expression,
    STATE(1103), 1,
      sym__attribute_expression,
    STATE(613), 2,
      sym_string_name,
      sym_attribute,
    STATE(964), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(773), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(928), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(771), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(785), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(610), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [11688] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(797), 1,
      sym__identifier,
    ACTIONS(803), 1,
      anon_sym_AMP,
    ACTIONS(805), 1,
      anon_sym_DOT,
    ACTIONS(807), 1,
      anon_sym_LBRACE,
    ACTIONS(809), 1,
      anon_sym_LBRACK,
    ACTIONS(813), 1,
      anon_sym_not,
    ACTIONS(815), 1,
      anon_sym_LPAREN,
    ACTIONS(819), 1,
      anon_sym_await,
    ACTIONS(821), 1,
      anon_sym_func,
    ACTIONS(823), 1,
      sym__string_start,
    ACTIONS(873), 1,
      anon_sym_RPAREN,
    STATE(468), 1,
      sym__primary_expression,
    STATE(1088), 1,
      sym__expression,
    STATE(1215), 1,
      sym__attribute_expression,
    STATE(534), 2,
      sym_string_name,
      sym_attribute,
    STATE(963), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(801), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1092), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(799), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(811), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(537), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [11776] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(797), 1,
      sym__identifier,
    ACTIONS(803), 1,
      anon_sym_AMP,
    ACTIONS(805), 1,
      anon_sym_DOT,
    ACTIONS(807), 1,
      anon_sym_LBRACE,
    ACTIONS(809), 1,
      anon_sym_LBRACK,
    ACTIONS(813), 1,
      anon_sym_not,
    ACTIONS(815), 1,
      anon_sym_LPAREN,
    ACTIONS(819), 1,
      anon_sym_await,
    ACTIONS(821), 1,
      anon_sym_func,
    ACTIONS(823), 1,
      sym__string_start,
    ACTIONS(875), 1,
      anon_sym_RPAREN,
    STATE(468), 1,
      sym__primary_expression,
    STATE(1088), 1,
      sym__expression,
    STATE(1215), 1,
      sym__attribute_expression,
    STATE(534), 2,
      sym_string_name,
      sym_attribute,
    STATE(1093), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(801), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1092), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(799), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(811), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(537), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [11864] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(797), 1,
      sym__identifier,
    ACTIONS(803), 1,
      anon_sym_AMP,
    ACTIONS(805), 1,
      anon_sym_DOT,
    ACTIONS(807), 1,
      anon_sym_LBRACE,
    ACTIONS(809), 1,
      anon_sym_LBRACK,
    ACTIONS(813), 1,
      anon_sym_not,
    ACTIONS(815), 1,
      anon_sym_LPAREN,
    ACTIONS(819), 1,
      anon_sym_await,
    ACTIONS(821), 1,
      anon_sym_func,
    ACTIONS(823), 1,
      sym__string_start,
    ACTIONS(877), 1,
      anon_sym_RPAREN,
    STATE(468), 1,
      sym__primary_expression,
    STATE(1088), 1,
      sym__expression,
    STATE(1215), 1,
      sym__attribute_expression,
    STATE(534), 2,
      sym_string_name,
      sym_attribute,
    STATE(1242), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(801), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1092), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(799), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(811), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(537), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [11952] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(797), 1,
      sym__identifier,
    ACTIONS(803), 1,
      anon_sym_AMP,
    ACTIONS(805), 1,
      anon_sym_DOT,
    ACTIONS(807), 1,
      anon_sym_LBRACE,
    ACTIONS(809), 1,
      anon_sym_LBRACK,
    ACTIONS(813), 1,
      anon_sym_not,
    ACTIONS(815), 1,
      anon_sym_LPAREN,
    ACTIONS(819), 1,
      anon_sym_await,
    ACTIONS(821), 1,
      anon_sym_func,
    ACTIONS(823), 1,
      sym__string_start,
    ACTIONS(879), 1,
      anon_sym_RPAREN,
    STATE(468), 1,
      sym__primary_expression,
    STATE(1088), 1,
      sym__expression,
    STATE(1215), 1,
      sym__attribute_expression,
    STATE(534), 2,
      sym_string_name,
      sym_attribute,
    STATE(1242), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(801), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1092), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(799), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(811), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(537), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [12040] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(769), 1,
      sym__identifier,
    ACTIONS(775), 1,
      anon_sym_AMP,
    ACTIONS(777), 1,
      anon_sym_DOT,
    ACTIONS(779), 1,
      anon_sym_LBRACE,
    ACTIONS(781), 1,
      anon_sym_LBRACK,
    ACTIONS(787), 1,
      anon_sym_not,
    ACTIONS(789), 1,
      anon_sym_LPAREN,
    ACTIONS(791), 1,
      anon_sym_await,
    ACTIONS(793), 1,
      anon_sym_func,
    ACTIONS(795), 1,
      sym__string_start,
    ACTIONS(881), 1,
      anon_sym_RBRACK,
    STATE(529), 1,
      sym__primary_expression,
    STATE(926), 1,
      sym__expression,
    STATE(1103), 1,
      sym__attribute_expression,
    STATE(613), 2,
      sym_string_name,
      sym_attribute,
    STATE(1181), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(773), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(928), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(771), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(785), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(610), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [12128] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(769), 1,
      sym__identifier,
    ACTIONS(775), 1,
      anon_sym_AMP,
    ACTIONS(777), 1,
      anon_sym_DOT,
    ACTIONS(779), 1,
      anon_sym_LBRACE,
    ACTIONS(781), 1,
      anon_sym_LBRACK,
    ACTIONS(787), 1,
      anon_sym_not,
    ACTIONS(789), 1,
      anon_sym_LPAREN,
    ACTIONS(791), 1,
      anon_sym_await,
    ACTIONS(793), 1,
      anon_sym_func,
    ACTIONS(795), 1,
      sym__string_start,
    ACTIONS(883), 1,
      anon_sym_RBRACK,
    STATE(529), 1,
      sym__primary_expression,
    STATE(926), 1,
      sym__expression,
    STATE(1103), 1,
      sym__attribute_expression,
    STATE(613), 2,
      sym_string_name,
      sym_attribute,
    STATE(1181), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(773), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(928), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(771), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(785), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(610), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [12216] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(797), 1,
      sym__identifier,
    ACTIONS(803), 1,
      anon_sym_AMP,
    ACTIONS(805), 1,
      anon_sym_DOT,
    ACTIONS(807), 1,
      anon_sym_LBRACE,
    ACTIONS(809), 1,
      anon_sym_LBRACK,
    ACTIONS(813), 1,
      anon_sym_not,
    ACTIONS(815), 1,
      anon_sym_LPAREN,
    ACTIONS(819), 1,
      anon_sym_await,
    ACTIONS(821), 1,
      anon_sym_func,
    ACTIONS(823), 1,
      sym__string_start,
    ACTIONS(885), 1,
      anon_sym_RPAREN,
    STATE(468), 1,
      sym__primary_expression,
    STATE(1088), 1,
      sym__expression,
    STATE(1215), 1,
      sym__attribute_expression,
    STATE(534), 2,
      sym_string_name,
      sym_attribute,
    STATE(1242), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(801), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1092), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(799), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(811), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(537), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [12304] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(797), 1,
      sym__identifier,
    ACTIONS(803), 1,
      anon_sym_AMP,
    ACTIONS(805), 1,
      anon_sym_DOT,
    ACTIONS(807), 1,
      anon_sym_LBRACE,
    ACTIONS(809), 1,
      anon_sym_LBRACK,
    ACTIONS(813), 1,
      anon_sym_not,
    ACTIONS(815), 1,
      anon_sym_LPAREN,
    ACTIONS(819), 1,
      anon_sym_await,
    ACTIONS(821), 1,
      anon_sym_func,
    ACTIONS(823), 1,
      sym__string_start,
    ACTIONS(887), 1,
      anon_sym_RPAREN,
    STATE(468), 1,
      sym__primary_expression,
    STATE(1088), 1,
      sym__expression,
    STATE(1215), 1,
      sym__attribute_expression,
    STATE(534), 2,
      sym_string_name,
      sym_attribute,
    STATE(1242), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(801), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1092), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(799), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(811), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(537), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [12392] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(797), 1,
      sym__identifier,
    ACTIONS(803), 1,
      anon_sym_AMP,
    ACTIONS(805), 1,
      anon_sym_DOT,
    ACTIONS(807), 1,
      anon_sym_LBRACE,
    ACTIONS(809), 1,
      anon_sym_LBRACK,
    ACTIONS(813), 1,
      anon_sym_not,
    ACTIONS(815), 1,
      anon_sym_LPAREN,
    ACTIONS(819), 1,
      anon_sym_await,
    ACTIONS(821), 1,
      anon_sym_func,
    ACTIONS(823), 1,
      sym__string_start,
    ACTIONS(889), 1,
      anon_sym_RPAREN,
    STATE(468), 1,
      sym__primary_expression,
    STATE(1088), 1,
      sym__expression,
    STATE(1215), 1,
      sym__attribute_expression,
    STATE(534), 2,
      sym_string_name,
      sym_attribute,
    STATE(940), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(801), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1092), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(799), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(811), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(537), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [12480] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(769), 1,
      sym__identifier,
    ACTIONS(775), 1,
      anon_sym_AMP,
    ACTIONS(777), 1,
      anon_sym_DOT,
    ACTIONS(779), 1,
      anon_sym_LBRACE,
    ACTIONS(781), 1,
      anon_sym_LBRACK,
    ACTIONS(787), 1,
      anon_sym_not,
    ACTIONS(789), 1,
      anon_sym_LPAREN,
    ACTIONS(791), 1,
      anon_sym_await,
    ACTIONS(793), 1,
      anon_sym_func,
    ACTIONS(795), 1,
      sym__string_start,
    ACTIONS(891), 1,
      anon_sym_RBRACK,
    STATE(529), 1,
      sym__primary_expression,
    STATE(926), 1,
      sym__expression,
    STATE(1103), 1,
      sym__attribute_expression,
    STATE(613), 2,
      sym_string_name,
      sym_attribute,
    STATE(1181), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(773), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(928), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(771), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(785), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(610), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [12568] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(797), 1,
      sym__identifier,
    ACTIONS(803), 1,
      anon_sym_AMP,
    ACTIONS(805), 1,
      anon_sym_DOT,
    ACTIONS(807), 1,
      anon_sym_LBRACE,
    ACTIONS(809), 1,
      anon_sym_LBRACK,
    ACTIONS(813), 1,
      anon_sym_not,
    ACTIONS(815), 1,
      anon_sym_LPAREN,
    ACTIONS(819), 1,
      anon_sym_await,
    ACTIONS(821), 1,
      anon_sym_func,
    ACTIONS(823), 1,
      sym__string_start,
    ACTIONS(893), 1,
      anon_sym_RPAREN,
    STATE(468), 1,
      sym__primary_expression,
    STATE(1088), 1,
      sym__expression,
    STATE(1215), 1,
      sym__attribute_expression,
    STATE(534), 2,
      sym_string_name,
      sym_attribute,
    STATE(1242), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(801), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1092), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(799), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(811), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(537), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [12656] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(769), 1,
      sym__identifier,
    ACTIONS(775), 1,
      anon_sym_AMP,
    ACTIONS(777), 1,
      anon_sym_DOT,
    ACTIONS(779), 1,
      anon_sym_LBRACE,
    ACTIONS(781), 1,
      anon_sym_LBRACK,
    ACTIONS(787), 1,
      anon_sym_not,
    ACTIONS(789), 1,
      anon_sym_LPAREN,
    ACTIONS(791), 1,
      anon_sym_await,
    ACTIONS(793), 1,
      anon_sym_func,
    ACTIONS(795), 1,
      sym__string_start,
    ACTIONS(895), 1,
      anon_sym_RBRACK,
    STATE(529), 1,
      sym__primary_expression,
    STATE(926), 1,
      sym__expression,
    STATE(1103), 1,
      sym__attribute_expression,
    STATE(613), 2,
      sym_string_name,
      sym_attribute,
    STATE(949), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(773), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(928), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(771), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(785), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(610), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [12744] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(769), 1,
      sym__identifier,
    ACTIONS(775), 1,
      anon_sym_AMP,
    ACTIONS(777), 1,
      anon_sym_DOT,
    ACTIONS(779), 1,
      anon_sym_LBRACE,
    ACTIONS(781), 1,
      anon_sym_LBRACK,
    ACTIONS(787), 1,
      anon_sym_not,
    ACTIONS(789), 1,
      anon_sym_LPAREN,
    ACTIONS(791), 1,
      anon_sym_await,
    ACTIONS(793), 1,
      anon_sym_func,
    ACTIONS(795), 1,
      sym__string_start,
    ACTIONS(897), 1,
      anon_sym_RBRACK,
    STATE(529), 1,
      sym__primary_expression,
    STATE(926), 1,
      sym__expression,
    STATE(1103), 1,
      sym__attribute_expression,
    STATE(613), 2,
      sym_string_name,
      sym_attribute,
    STATE(1181), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(773), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(928), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(771), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(785), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(610), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [12832] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(797), 1,
      sym__identifier,
    ACTIONS(803), 1,
      anon_sym_AMP,
    ACTIONS(805), 1,
      anon_sym_DOT,
    ACTIONS(807), 1,
      anon_sym_LBRACE,
    ACTIONS(809), 1,
      anon_sym_LBRACK,
    ACTIONS(813), 1,
      anon_sym_not,
    ACTIONS(815), 1,
      anon_sym_LPAREN,
    ACTIONS(819), 1,
      anon_sym_await,
    ACTIONS(821), 1,
      anon_sym_func,
    ACTIONS(823), 1,
      sym__string_start,
    ACTIONS(899), 1,
      anon_sym_RPAREN,
    STATE(468), 1,
      sym__primary_expression,
    STATE(1088), 1,
      sym__expression,
    STATE(1215), 1,
      sym__attribute_expression,
    STATE(534), 2,
      sym_string_name,
      sym_attribute,
    STATE(1242), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(801), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1092), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(799), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(811), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(537), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [12920] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(769), 1,
      sym__identifier,
    ACTIONS(775), 1,
      anon_sym_AMP,
    ACTIONS(777), 1,
      anon_sym_DOT,
    ACTIONS(779), 1,
      anon_sym_LBRACE,
    ACTIONS(781), 1,
      anon_sym_LBRACK,
    ACTIONS(787), 1,
      anon_sym_not,
    ACTIONS(789), 1,
      anon_sym_LPAREN,
    ACTIONS(791), 1,
      anon_sym_await,
    ACTIONS(793), 1,
      anon_sym_func,
    ACTIONS(795), 1,
      sym__string_start,
    ACTIONS(901), 1,
      anon_sym_RBRACK,
    STATE(529), 1,
      sym__primary_expression,
    STATE(926), 1,
      sym__expression,
    STATE(1103), 1,
      sym__attribute_expression,
    STATE(613), 2,
      sym_string_name,
      sym_attribute,
    STATE(1031), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(773), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(928), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(771), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(785), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(610), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [13008] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(797), 1,
      sym__identifier,
    ACTIONS(803), 1,
      anon_sym_AMP,
    ACTIONS(805), 1,
      anon_sym_DOT,
    ACTIONS(807), 1,
      anon_sym_LBRACE,
    ACTIONS(809), 1,
      anon_sym_LBRACK,
    ACTIONS(813), 1,
      anon_sym_not,
    ACTIONS(815), 1,
      anon_sym_LPAREN,
    ACTIONS(819), 1,
      anon_sym_await,
    ACTIONS(821), 1,
      anon_sym_func,
    ACTIONS(823), 1,
      sym__string_start,
    ACTIONS(903), 1,
      anon_sym_RPAREN,
    STATE(468), 1,
      sym__primary_expression,
    STATE(1088), 1,
      sym__expression,
    STATE(1215), 1,
      sym__attribute_expression,
    STATE(534), 2,
      sym_string_name,
      sym_attribute,
    STATE(1034), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(801), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1092), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(799), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(811), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(537), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [13096] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(649), 1,
      anon_sym_await,
    ACTIONS(653), 1,
      sym__string_start,
    ACTIONS(905), 1,
      anon_sym_RBRACE,
    ACTIONS(907), 1,
      sym_pattern_open_ending,
    STATE(472), 1,
      sym__primary_expression,
    STATE(1066), 1,
      sym_pattern_pair,
    STATE(1134), 1,
      sym__attribute_expression,
    STATE(1191), 1,
      sym__expression,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1006), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [13183] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(649), 1,
      anon_sym_await,
    ACTIONS(653), 1,
      sym__string_start,
    ACTIONS(909), 1,
      anon_sym_RBRACE,
    ACTIONS(911), 1,
      sym_pattern_open_ending,
    STATE(472), 1,
      sym__primary_expression,
    STATE(1029), 1,
      sym_pattern_pair,
    STATE(1134), 1,
      sym__attribute_expression,
    STATE(1191), 1,
      sym__expression,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1006), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [13270] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym__identifier,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(43), 1,
      anon_sym_DOT,
    ACTIONS(57), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_not,
    ACTIONS(67), 1,
      anon_sym_LPAREN,
    ACTIONS(69), 1,
      anon_sym_await,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(584), 1,
      anon_sym_func,
    STATE(215), 1,
      sym__primary_expression,
    STATE(810), 1,
      sym__expression,
    STATE(1292), 1,
      sym__attribute_expression,
    STATE(237), 2,
      sym_string_name,
      sym_attribute,
    STATE(1026), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(15), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(744), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(9), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(63), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(233), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [13355] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(913), 1,
      sym__identifier,
    ACTIONS(919), 1,
      anon_sym_AMP,
    ACTIONS(921), 1,
      anon_sym_DOT,
    ACTIONS(923), 1,
      anon_sym_LBRACE,
    ACTIONS(925), 1,
      anon_sym_LBRACK,
    ACTIONS(929), 1,
      anon_sym_not,
    ACTIONS(931), 1,
      anon_sym_LPAREN,
    ACTIONS(933), 1,
      anon_sym_await,
    ACTIONS(935), 1,
      anon_sym_func,
    ACTIONS(937), 1,
      sym__string_start,
    STATE(619), 1,
      sym__primary_expression,
    STATE(1180), 1,
      sym__attribute_expression,
    STATE(1221), 1,
      sym__expression,
    STATE(699), 2,
      sym_string_name,
      sym_attribute,
    STATE(1348), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(917), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1225), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(915), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(927), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(696), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [13440] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(913), 1,
      sym__identifier,
    ACTIONS(919), 1,
      anon_sym_AMP,
    ACTIONS(921), 1,
      anon_sym_DOT,
    ACTIONS(923), 1,
      anon_sym_LBRACE,
    ACTIONS(925), 1,
      anon_sym_LBRACK,
    ACTIONS(929), 1,
      anon_sym_not,
    ACTIONS(931), 1,
      anon_sym_LPAREN,
    ACTIONS(933), 1,
      anon_sym_await,
    ACTIONS(935), 1,
      anon_sym_func,
    ACTIONS(937), 1,
      sym__string_start,
    STATE(619), 1,
      sym__primary_expression,
    STATE(1180), 1,
      sym__attribute_expression,
    STATE(1221), 1,
      sym__expression,
    STATE(699), 2,
      sym_string_name,
      sym_attribute,
    STATE(1327), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(917), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1225), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(915), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(927), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(696), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [13525] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(797), 1,
      sym__identifier,
    ACTIONS(803), 1,
      anon_sym_AMP,
    ACTIONS(805), 1,
      anon_sym_DOT,
    ACTIONS(807), 1,
      anon_sym_LBRACE,
    ACTIONS(809), 1,
      anon_sym_LBRACK,
    ACTIONS(813), 1,
      anon_sym_not,
    ACTIONS(815), 1,
      anon_sym_LPAREN,
    ACTIONS(819), 1,
      anon_sym_await,
    ACTIONS(821), 1,
      anon_sym_func,
    ACTIONS(823), 1,
      sym__string_start,
    STATE(468), 1,
      sym__primary_expression,
    STATE(1088), 1,
      sym__expression,
    STATE(1215), 1,
      sym__attribute_expression,
    STATE(534), 2,
      sym_string_name,
      sym_attribute,
    STATE(1279), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(801), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1092), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(799), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(811), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(537), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [13610] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(769), 1,
      sym__identifier,
    ACTIONS(775), 1,
      anon_sym_AMP,
    ACTIONS(777), 1,
      anon_sym_DOT,
    ACTIONS(779), 1,
      anon_sym_LBRACE,
    ACTIONS(781), 1,
      anon_sym_LBRACK,
    ACTIONS(787), 1,
      anon_sym_not,
    ACTIONS(789), 1,
      anon_sym_LPAREN,
    ACTIONS(791), 1,
      anon_sym_await,
    ACTIONS(793), 1,
      anon_sym_func,
    ACTIONS(795), 1,
      sym__string_start,
    STATE(529), 1,
      sym__primary_expression,
    STATE(926), 1,
      sym__expression,
    STATE(1103), 1,
      sym__attribute_expression,
    STATE(613), 2,
      sym_string_name,
      sym_attribute,
    STATE(1181), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(773), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(928), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(771), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(785), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(610), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [13695] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym__identifier,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(43), 1,
      anon_sym_DOT,
    ACTIONS(57), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_not,
    ACTIONS(67), 1,
      anon_sym_LPAREN,
    ACTIONS(69), 1,
      anon_sym_await,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(584), 1,
      anon_sym_func,
    STATE(215), 1,
      sym__primary_expression,
    STATE(810), 1,
      sym__expression,
    STATE(1292), 1,
      sym__attribute_expression,
    STATE(237), 2,
      sym_string_name,
      sym_attribute,
    STATE(1021), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(15), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(744), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(9), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(63), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(233), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [13780] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(913), 1,
      sym__identifier,
    ACTIONS(919), 1,
      anon_sym_AMP,
    ACTIONS(921), 1,
      anon_sym_DOT,
    ACTIONS(923), 1,
      anon_sym_LBRACE,
    ACTIONS(925), 1,
      anon_sym_LBRACK,
    ACTIONS(929), 1,
      anon_sym_not,
    ACTIONS(931), 1,
      anon_sym_LPAREN,
    ACTIONS(933), 1,
      anon_sym_await,
    ACTIONS(935), 1,
      anon_sym_func,
    ACTIONS(937), 1,
      sym__string_start,
    STATE(619), 1,
      sym__primary_expression,
    STATE(1180), 1,
      sym__attribute_expression,
    STATE(1221), 1,
      sym__expression,
    STATE(699), 2,
      sym_string_name,
      sym_attribute,
    STATE(1336), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(917), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1225), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(915), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(927), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(696), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [13865] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym__identifier,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(43), 1,
      anon_sym_DOT,
    ACTIONS(57), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_not,
    ACTIONS(67), 1,
      anon_sym_LPAREN,
    ACTIONS(69), 1,
      anon_sym_await,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(584), 1,
      anon_sym_func,
    STATE(215), 1,
      sym__primary_expression,
    STATE(810), 1,
      sym__expression,
    STATE(1292), 1,
      sym__attribute_expression,
    STATE(237), 2,
      sym_string_name,
      sym_attribute,
    STATE(838), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(15), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(744), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(9), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(63), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(233), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [13950] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym__identifier,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(43), 1,
      anon_sym_DOT,
    ACTIONS(57), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_not,
    ACTIONS(67), 1,
      anon_sym_LPAREN,
    ACTIONS(69), 1,
      anon_sym_await,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(584), 1,
      anon_sym_func,
    STATE(215), 1,
      sym__primary_expression,
    STATE(810), 1,
      sym__expression,
    STATE(1292), 1,
      sym__attribute_expression,
    STATE(237), 2,
      sym_string_name,
      sym_attribute,
    STATE(837), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(15), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(744), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(9), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(63), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(233), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [14035] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(913), 1,
      sym__identifier,
    ACTIONS(919), 1,
      anon_sym_AMP,
    ACTIONS(921), 1,
      anon_sym_DOT,
    ACTIONS(923), 1,
      anon_sym_LBRACE,
    ACTIONS(925), 1,
      anon_sym_LBRACK,
    ACTIONS(929), 1,
      anon_sym_not,
    ACTIONS(931), 1,
      anon_sym_LPAREN,
    ACTIONS(933), 1,
      anon_sym_await,
    ACTIONS(935), 1,
      anon_sym_func,
    ACTIONS(937), 1,
      sym__string_start,
    STATE(619), 1,
      sym__primary_expression,
    STATE(1180), 1,
      sym__attribute_expression,
    STATE(1221), 1,
      sym__expression,
    STATE(699), 2,
      sym_string_name,
      sym_attribute,
    STATE(1360), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(917), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1225), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(915), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(927), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(696), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [14120] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(913), 1,
      sym__identifier,
    ACTIONS(919), 1,
      anon_sym_AMP,
    ACTIONS(921), 1,
      anon_sym_DOT,
    ACTIONS(923), 1,
      anon_sym_LBRACE,
    ACTIONS(925), 1,
      anon_sym_LBRACK,
    ACTIONS(929), 1,
      anon_sym_not,
    ACTIONS(931), 1,
      anon_sym_LPAREN,
    ACTIONS(933), 1,
      anon_sym_await,
    ACTIONS(935), 1,
      anon_sym_func,
    ACTIONS(937), 1,
      sym__string_start,
    STATE(619), 1,
      sym__primary_expression,
    STATE(1180), 1,
      sym__attribute_expression,
    STATE(1221), 1,
      sym__expression,
    STATE(699), 2,
      sym_string_name,
      sym_attribute,
    STATE(1369), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(917), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1225), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(915), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(927), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(696), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [14205] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(913), 1,
      sym__identifier,
    ACTIONS(919), 1,
      anon_sym_AMP,
    ACTIONS(921), 1,
      anon_sym_DOT,
    ACTIONS(923), 1,
      anon_sym_LBRACE,
    ACTIONS(925), 1,
      anon_sym_LBRACK,
    ACTIONS(929), 1,
      anon_sym_not,
    ACTIONS(931), 1,
      anon_sym_LPAREN,
    ACTIONS(933), 1,
      anon_sym_await,
    ACTIONS(935), 1,
      anon_sym_func,
    ACTIONS(937), 1,
      sym__string_start,
    STATE(619), 1,
      sym__primary_expression,
    STATE(1180), 1,
      sym__attribute_expression,
    STATE(1221), 1,
      sym__expression,
    STATE(699), 2,
      sym_string_name,
      sym_attribute,
    STATE(1375), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(917), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1225), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(915), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(927), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(696), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [14290] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym__identifier,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(43), 1,
      anon_sym_DOT,
    ACTIONS(57), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_not,
    ACTIONS(67), 1,
      anon_sym_LPAREN,
    ACTIONS(69), 1,
      anon_sym_await,
    ACTIONS(73), 1,
      sym__string_start,
    ACTIONS(584), 1,
      anon_sym_func,
    STATE(215), 1,
      sym__primary_expression,
    STATE(810), 1,
      sym__expression,
    STATE(1292), 1,
      sym__attribute_expression,
    STATE(237), 2,
      sym_string_name,
      sym_attribute,
    STATE(836), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(15), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(744), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(9), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(63), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(233), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [14375] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(797), 1,
      sym__identifier,
    ACTIONS(803), 1,
      anon_sym_AMP,
    ACTIONS(805), 1,
      anon_sym_DOT,
    ACTIONS(807), 1,
      anon_sym_LBRACE,
    ACTIONS(809), 1,
      anon_sym_LBRACK,
    ACTIONS(813), 1,
      anon_sym_not,
    ACTIONS(815), 1,
      anon_sym_LPAREN,
    ACTIONS(819), 1,
      anon_sym_await,
    ACTIONS(821), 1,
      anon_sym_func,
    ACTIONS(823), 1,
      sym__string_start,
    STATE(468), 1,
      sym__primary_expression,
    STATE(1088), 1,
      sym__expression,
    STATE(1215), 1,
      sym__attribute_expression,
    STATE(534), 2,
      sym_string_name,
      sym_attribute,
    STATE(1242), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(801), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1092), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(799), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(811), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(537), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [14460] = 22,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(649), 1,
      anon_sym_await,
    ACTIONS(653), 1,
      sym__string_start,
    ACTIONS(939), 1,
      anon_sym_RBRACE,
    ACTIONS(941), 1,
      sym_pattern_open_ending,
    STATE(472), 1,
      sym__primary_expression,
    STATE(960), 1,
      sym_pattern_pair,
    STATE(1134), 1,
      sym__attribute_expression,
    STATE(1191), 1,
      sym__expression,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1006), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [14547] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(797), 1,
      sym__identifier,
    ACTIONS(803), 1,
      anon_sym_AMP,
    ACTIONS(805), 1,
      anon_sym_DOT,
    ACTIONS(807), 1,
      anon_sym_LBRACE,
    ACTIONS(809), 1,
      anon_sym_LBRACK,
    ACTIONS(813), 1,
      anon_sym_not,
    ACTIONS(815), 1,
      anon_sym_LPAREN,
    ACTIONS(819), 1,
      anon_sym_await,
    ACTIONS(821), 1,
      anon_sym_func,
    ACTIONS(823), 1,
      sym__string_start,
    STATE(468), 1,
      sym__primary_expression,
    STATE(1088), 1,
      sym__expression,
    STATE(1215), 1,
      sym__attribute_expression,
    STATE(534), 2,
      sym_string_name,
      sym_attribute,
    STATE(1105), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(801), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1092), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(799), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(811), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(537), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [14632] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(913), 1,
      sym__identifier,
    ACTIONS(919), 1,
      anon_sym_AMP,
    ACTIONS(921), 1,
      anon_sym_DOT,
    ACTIONS(923), 1,
      anon_sym_LBRACE,
    ACTIONS(925), 1,
      anon_sym_LBRACK,
    ACTIONS(929), 1,
      anon_sym_not,
    ACTIONS(931), 1,
      anon_sym_LPAREN,
    ACTIONS(933), 1,
      anon_sym_await,
    ACTIONS(935), 1,
      anon_sym_func,
    ACTIONS(937), 1,
      sym__string_start,
    STATE(619), 1,
      sym__primary_expression,
    STATE(1180), 1,
      sym__attribute_expression,
    STATE(1221), 1,
      sym__expression,
    STATE(699), 2,
      sym_string_name,
      sym_attribute,
    STATE(1389), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(917), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1225), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(915), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(927), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(696), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [14717] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(943), 1,
      sym__identifier,
    ACTIONS(949), 1,
      anon_sym_AMP,
    ACTIONS(951), 1,
      anon_sym_DOT,
    ACTIONS(953), 1,
      anon_sym_LBRACE,
    ACTIONS(955), 1,
      anon_sym_LBRACK,
    ACTIONS(959), 1,
      anon_sym_not,
    ACTIONS(961), 1,
      anon_sym_LPAREN,
    ACTIONS(963), 1,
      anon_sym_await,
    ACTIONS(965), 1,
      anon_sym_func,
    ACTIONS(967), 1,
      sym__string_start,
    STATE(488), 1,
      sym__primary_expression,
    STATE(1018), 1,
      sym__expression,
    STATE(1302), 1,
      sym__attribute_expression,
    STATE(607), 2,
      sym_string_name,
      sym_attribute,
    STATE(1187), 2,
      sym__rhs_expression,
      sym_lambda,
    ACTIONS(947), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(932), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(945), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(957), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(612), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [14802] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(550), 8,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(552), 32,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_var,
      anon_sym_onready,
      anon_sym_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_DASH_GT,
      anon_sym_func,
  [14850] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(542), 8,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(544), 32,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_var,
      anon_sym_onready,
      anon_sym_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_DASH_GT,
      anon_sym_func,
  [14898] = 21,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(649), 1,
      anon_sym_await,
    ACTIONS(653), 1,
      sym__string_start,
    ACTIONS(969), 1,
      sym_pattern_open_ending,
    STATE(472), 1,
      sym__primary_expression,
    STATE(1134), 1,
      sym__attribute_expression,
    STATE(1191), 1,
      sym__expression,
    STATE(1289), 1,
      sym_pattern_pair,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1006), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [14982] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(558), 8,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(560), 32,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_var,
      anon_sym_onready,
      anon_sym_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_DASH_GT,
      anon_sym_func,
  [15030] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(546), 8,
      anon_sym_remote,
      anon_sym_master,
      anon_sym_puppet,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(548), 32,
      anon_sym_remotesync,
      anon_sym_mastersync,
      anon_sym_puppetsync,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_var,
      anon_sym_onready,
      anon_sym_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_DASH_GT,
      anon_sym_func,
  [15078] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(649), 1,
      anon_sym_await,
    ACTIONS(653), 1,
      sym__string_start,
    STATE(472), 1,
      sym__primary_expression,
    STATE(1104), 1,
      sym__expression,
    STATE(1134), 1,
      sym__attribute_expression,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1006), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [15156] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(649), 1,
      anon_sym_await,
    ACTIONS(653), 1,
      sym__string_start,
    STATE(472), 1,
      sym__primary_expression,
    STATE(1118), 1,
      sym__expression,
    STATE(1134), 1,
      sym__attribute_expression,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1006), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [15234] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(769), 1,
      sym__identifier,
    ACTIONS(775), 1,
      anon_sym_AMP,
    ACTIONS(777), 1,
      anon_sym_DOT,
    ACTIONS(779), 1,
      anon_sym_LBRACE,
    ACTIONS(781), 1,
      anon_sym_LBRACK,
    ACTIONS(787), 1,
      anon_sym_not,
    ACTIONS(789), 1,
      anon_sym_LPAREN,
    ACTIONS(791), 1,
      anon_sym_await,
    ACTIONS(795), 1,
      sym__string_start,
    STATE(529), 1,
      sym__primary_expression,
    STATE(1022), 1,
      sym__expression,
    STATE(1103), 1,
      sym__attribute_expression,
    STATE(613), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(773), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(928), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(771), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(785), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(610), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [15312] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(913), 1,
      sym__identifier,
    ACTIONS(919), 1,
      anon_sym_AMP,
    ACTIONS(921), 1,
      anon_sym_DOT,
    ACTIONS(923), 1,
      anon_sym_LBRACE,
    ACTIONS(925), 1,
      anon_sym_LBRACK,
    ACTIONS(929), 1,
      anon_sym_not,
    ACTIONS(931), 1,
      anon_sym_LPAREN,
    ACTIONS(933), 1,
      anon_sym_await,
    ACTIONS(937), 1,
      sym__string_start,
    STATE(619), 1,
      sym__primary_expression,
    STATE(1180), 1,
      sym__attribute_expression,
    STATE(1209), 1,
      sym__expression,
    STATE(699), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(917), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1225), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(915), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(927), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(696), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [15390] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(913), 1,
      sym__identifier,
    ACTIONS(919), 1,
      anon_sym_AMP,
    ACTIONS(921), 1,
      anon_sym_DOT,
    ACTIONS(923), 1,
      anon_sym_LBRACE,
    ACTIONS(925), 1,
      anon_sym_LBRACK,
    ACTIONS(929), 1,
      anon_sym_not,
    ACTIONS(931), 1,
      anon_sym_LPAREN,
    ACTIONS(933), 1,
      anon_sym_await,
    ACTIONS(937), 1,
      sym__string_start,
    STATE(619), 1,
      sym__primary_expression,
    STATE(1131), 1,
      sym__expression,
    STATE(1180), 1,
      sym__attribute_expression,
    STATE(699), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(917), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1225), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(915), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(927), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(696), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [15468] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(797), 1,
      sym__identifier,
    ACTIONS(803), 1,
      anon_sym_AMP,
    ACTIONS(805), 1,
      anon_sym_DOT,
    ACTIONS(807), 1,
      anon_sym_LBRACE,
    ACTIONS(809), 1,
      anon_sym_LBRACK,
    ACTIONS(813), 1,
      anon_sym_not,
    ACTIONS(815), 1,
      anon_sym_LPAREN,
    ACTIONS(819), 1,
      anon_sym_await,
    ACTIONS(823), 1,
      sym__string_start,
    STATE(468), 1,
      sym__primary_expression,
    STATE(1076), 1,
      sym__expression,
    STATE(1215), 1,
      sym__attribute_expression,
    STATE(534), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(801), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1092), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(799), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(811), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(537), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [15546] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(649), 1,
      anon_sym_await,
    ACTIONS(653), 1,
      sym__string_start,
    STATE(472), 1,
      sym__primary_expression,
    STATE(1134), 1,
      sym__attribute_expression,
    STATE(1208), 1,
      sym__expression,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1006), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [15624] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym__identifier,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(43), 1,
      anon_sym_DOT,
    ACTIONS(57), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_not,
    ACTIONS(67), 1,
      anon_sym_LPAREN,
    ACTIONS(69), 1,
      anon_sym_await,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(215), 1,
      sym__primary_expression,
    STATE(743), 1,
      sym__expression,
    STATE(1292), 1,
      sym__attribute_expression,
    STATE(237), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(15), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(744), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(9), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(63), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(233), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [15702] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(943), 1,
      sym__identifier,
    ACTIONS(949), 1,
      anon_sym_AMP,
    ACTIONS(951), 1,
      anon_sym_DOT,
    ACTIONS(953), 1,
      anon_sym_LBRACE,
    ACTIONS(955), 1,
      anon_sym_LBRACK,
    ACTIONS(959), 1,
      anon_sym_not,
    ACTIONS(961), 1,
      anon_sym_LPAREN,
    ACTIONS(963), 1,
      anon_sym_await,
    ACTIONS(967), 1,
      sym__string_start,
    STATE(488), 1,
      sym__primary_expression,
    STATE(983), 1,
      sym__expression,
    STATE(1302), 1,
      sym__attribute_expression,
    STATE(607), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(947), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(932), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(945), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(957), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(612), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [15780] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(971), 1,
      sym__identifier,
    ACTIONS(977), 1,
      anon_sym_AMP,
    ACTIONS(979), 1,
      anon_sym_DOT,
    ACTIONS(981), 1,
      anon_sym_LBRACE,
    ACTIONS(983), 1,
      anon_sym_LBRACK,
    ACTIONS(987), 1,
      anon_sym_not,
    ACTIONS(989), 1,
      anon_sym_LPAREN,
    ACTIONS(991), 1,
      anon_sym_await,
    ACTIONS(993), 1,
      sym__string_start,
    STATE(630), 1,
      sym__primary_expression,
    STATE(1109), 1,
      sym__expression,
    STATE(1295), 1,
      sym__attribute_expression,
    STATE(688), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(975), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1294), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(973), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(985), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(691), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [15858] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(649), 1,
      anon_sym_await,
    ACTIONS(653), 1,
      sym__string_start,
    STATE(472), 1,
      sym__primary_expression,
    STATE(914), 1,
      sym__expression,
    STATE(1134), 1,
      sym__attribute_expression,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1006), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [15936] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(797), 1,
      sym__identifier,
    ACTIONS(803), 1,
      anon_sym_AMP,
    ACTIONS(805), 1,
      anon_sym_DOT,
    ACTIONS(807), 1,
      anon_sym_LBRACE,
    ACTIONS(809), 1,
      anon_sym_LBRACK,
    ACTIONS(813), 1,
      anon_sym_not,
    ACTIONS(815), 1,
      anon_sym_LPAREN,
    ACTIONS(819), 1,
      anon_sym_await,
    ACTIONS(823), 1,
      sym__string_start,
    STATE(468), 1,
      sym__primary_expression,
    STATE(1061), 1,
      sym__expression,
    STATE(1215), 1,
      sym__attribute_expression,
    STATE(534), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(801), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1092), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(799), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(811), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(537), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [16014] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(649), 1,
      anon_sym_await,
    ACTIONS(653), 1,
      sym__string_start,
    STATE(472), 1,
      sym__primary_expression,
    STATE(1134), 1,
      sym__attribute_expression,
    STATE(1213), 1,
      sym__expression,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1006), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [16092] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(971), 1,
      sym__identifier,
    ACTIONS(977), 1,
      anon_sym_AMP,
    ACTIONS(979), 1,
      anon_sym_DOT,
    ACTIONS(981), 1,
      anon_sym_LBRACE,
    ACTIONS(983), 1,
      anon_sym_LBRACK,
    ACTIONS(987), 1,
      anon_sym_not,
    ACTIONS(989), 1,
      anon_sym_LPAREN,
    ACTIONS(991), 1,
      anon_sym_await,
    ACTIONS(993), 1,
      sym__string_start,
    STATE(630), 1,
      sym__primary_expression,
    STATE(1285), 1,
      sym__expression,
    STATE(1295), 1,
      sym__attribute_expression,
    STATE(688), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(975), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1294), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(973), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(985), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(691), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [16170] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(649), 1,
      anon_sym_await,
    ACTIONS(653), 1,
      sym__string_start,
    STATE(472), 1,
      sym__primary_expression,
    STATE(1106), 1,
      sym__expression,
    STATE(1134), 1,
      sym__attribute_expression,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1006), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [16248] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(649), 1,
      anon_sym_await,
    ACTIONS(653), 1,
      sym__string_start,
    STATE(472), 1,
      sym__primary_expression,
    STATE(1125), 1,
      sym__expression,
    STATE(1134), 1,
      sym__attribute_expression,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1006), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [16326] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(649), 1,
      anon_sym_await,
    ACTIONS(653), 1,
      sym__string_start,
    STATE(472), 1,
      sym__primary_expression,
    STATE(1134), 1,
      sym__attribute_expression,
    STATE(1234), 1,
      sym__expression,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1006), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [16404] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(943), 1,
      sym__identifier,
    ACTIONS(949), 1,
      anon_sym_AMP,
    ACTIONS(951), 1,
      anon_sym_DOT,
    ACTIONS(953), 1,
      anon_sym_LBRACE,
    ACTIONS(955), 1,
      anon_sym_LBRACK,
    ACTIONS(959), 1,
      anon_sym_not,
    ACTIONS(961), 1,
      anon_sym_LPAREN,
    ACTIONS(963), 1,
      anon_sym_await,
    ACTIONS(967), 1,
      sym__string_start,
    STATE(488), 1,
      sym__primary_expression,
    STATE(939), 1,
      sym__expression,
    STATE(1302), 1,
      sym__attribute_expression,
    STATE(607), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(947), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(932), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(945), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(957), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(612), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [16482] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(649), 1,
      anon_sym_await,
    ACTIONS(653), 1,
      sym__string_start,
    STATE(472), 1,
      sym__primary_expression,
    STATE(1134), 1,
      sym__attribute_expression,
    STATE(1236), 1,
      sym__expression,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1006), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [16560] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(769), 1,
      sym__identifier,
    ACTIONS(775), 1,
      anon_sym_AMP,
    ACTIONS(777), 1,
      anon_sym_DOT,
    ACTIONS(779), 1,
      anon_sym_LBRACE,
    ACTIONS(781), 1,
      anon_sym_LBRACK,
    ACTIONS(787), 1,
      anon_sym_not,
    ACTIONS(789), 1,
      anon_sym_LPAREN,
    ACTIONS(791), 1,
      anon_sym_await,
    ACTIONS(795), 1,
      sym__string_start,
    STATE(529), 1,
      sym__primary_expression,
    STATE(922), 1,
      sym__expression,
    STATE(1103), 1,
      sym__attribute_expression,
    STATE(613), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(773), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(928), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(771), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(785), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(610), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [16638] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(971), 1,
      sym__identifier,
    ACTIONS(977), 1,
      anon_sym_AMP,
    ACTIONS(979), 1,
      anon_sym_DOT,
    ACTIONS(981), 1,
      anon_sym_LBRACE,
    ACTIONS(983), 1,
      anon_sym_LBRACK,
    ACTIONS(987), 1,
      anon_sym_not,
    ACTIONS(989), 1,
      anon_sym_LPAREN,
    ACTIONS(991), 1,
      anon_sym_await,
    ACTIONS(993), 1,
      sym__string_start,
    STATE(630), 1,
      sym__primary_expression,
    STATE(1119), 1,
      sym__expression,
    STATE(1295), 1,
      sym__attribute_expression,
    STATE(688), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(975), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1294), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(973), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(985), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(691), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [16716] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(649), 1,
      anon_sym_await,
    ACTIONS(653), 1,
      sym__string_start,
    STATE(472), 1,
      sym__primary_expression,
    STATE(1134), 1,
      sym__attribute_expression,
    STATE(1202), 1,
      sym__expression,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1006), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [16794] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(649), 1,
      anon_sym_await,
    ACTIONS(653), 1,
      sym__string_start,
    STATE(472), 1,
      sym__primary_expression,
    STATE(1134), 1,
      sym__attribute_expression,
    STATE(1160), 1,
      sym__expression,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1006), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [16872] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(971), 1,
      sym__identifier,
    ACTIONS(977), 1,
      anon_sym_AMP,
    ACTIONS(979), 1,
      anon_sym_DOT,
    ACTIONS(981), 1,
      anon_sym_LBRACE,
    ACTIONS(983), 1,
      anon_sym_LBRACK,
    ACTIONS(987), 1,
      anon_sym_not,
    ACTIONS(989), 1,
      anon_sym_LPAREN,
    ACTIONS(991), 1,
      anon_sym_await,
    ACTIONS(993), 1,
      sym__string_start,
    STATE(630), 1,
      sym__primary_expression,
    STATE(1161), 1,
      sym__expression,
    STATE(1295), 1,
      sym__attribute_expression,
    STATE(688), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(975), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1294), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(973), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(985), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(691), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [16950] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym__identifier,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(43), 1,
      anon_sym_DOT,
    ACTIONS(57), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_not,
    ACTIONS(67), 1,
      anon_sym_LPAREN,
    ACTIONS(69), 1,
      anon_sym_await,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(215), 1,
      sym__primary_expression,
    STATE(746), 1,
      sym__expression,
    STATE(1292), 1,
      sym__attribute_expression,
    STATE(237), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(15), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(744), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(9), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(63), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(233), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [17028] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(971), 1,
      sym__identifier,
    ACTIONS(977), 1,
      anon_sym_AMP,
    ACTIONS(979), 1,
      anon_sym_DOT,
    ACTIONS(981), 1,
      anon_sym_LBRACE,
    ACTIONS(983), 1,
      anon_sym_LBRACK,
    ACTIONS(987), 1,
      anon_sym_not,
    ACTIONS(989), 1,
      anon_sym_LPAREN,
    ACTIONS(991), 1,
      anon_sym_await,
    ACTIONS(993), 1,
      sym__string_start,
    STATE(630), 1,
      sym__primary_expression,
    STATE(1244), 1,
      sym__expression,
    STATE(1295), 1,
      sym__attribute_expression,
    STATE(688), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(975), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1294), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(973), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(985), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(691), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [17106] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(649), 1,
      anon_sym_await,
    ACTIONS(653), 1,
      sym__string_start,
    STATE(472), 1,
      sym__primary_expression,
    STATE(1134), 1,
      sym__attribute_expression,
    STATE(1195), 1,
      sym__expression,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1006), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [17184] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(971), 1,
      sym__identifier,
    ACTIONS(977), 1,
      anon_sym_AMP,
    ACTIONS(979), 1,
      anon_sym_DOT,
    ACTIONS(981), 1,
      anon_sym_LBRACE,
    ACTIONS(983), 1,
      anon_sym_LBRACK,
    ACTIONS(987), 1,
      anon_sym_not,
    ACTIONS(989), 1,
      anon_sym_LPAREN,
    ACTIONS(991), 1,
      anon_sym_await,
    ACTIONS(993), 1,
      sym__string_start,
    STATE(630), 1,
      sym__primary_expression,
    STATE(1196), 1,
      sym__expression,
    STATE(1295), 1,
      sym__attribute_expression,
    STATE(688), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(975), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1294), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(973), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(985), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(691), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [17262] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(649), 1,
      anon_sym_await,
    ACTIONS(653), 1,
      sym__string_start,
    STATE(472), 1,
      sym__primary_expression,
    STATE(1134), 1,
      sym__attribute_expression,
    STATE(1281), 1,
      sym__expression,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1006), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [17340] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(971), 1,
      sym__identifier,
    ACTIONS(977), 1,
      anon_sym_AMP,
    ACTIONS(979), 1,
      anon_sym_DOT,
    ACTIONS(981), 1,
      anon_sym_LBRACE,
    ACTIONS(983), 1,
      anon_sym_LBRACK,
    ACTIONS(987), 1,
      anon_sym_not,
    ACTIONS(989), 1,
      anon_sym_LPAREN,
    ACTIONS(991), 1,
      anon_sym_await,
    ACTIONS(993), 1,
      sym__string_start,
    STATE(630), 1,
      sym__primary_expression,
    STATE(1141), 1,
      sym__expression,
    STATE(1295), 1,
      sym__attribute_expression,
    STATE(688), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(975), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1294), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(973), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(985), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(691), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [17418] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(649), 1,
      anon_sym_await,
    ACTIONS(653), 1,
      sym__string_start,
    STATE(472), 1,
      sym__primary_expression,
    STATE(1134), 1,
      sym__attribute_expression,
    STATE(1230), 1,
      sym__expression,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1006), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [17496] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(971), 1,
      sym__identifier,
    ACTIONS(977), 1,
      anon_sym_AMP,
    ACTIONS(979), 1,
      anon_sym_DOT,
    ACTIONS(981), 1,
      anon_sym_LBRACE,
    ACTIONS(983), 1,
      anon_sym_LBRACK,
    ACTIONS(987), 1,
      anon_sym_not,
    ACTIONS(989), 1,
      anon_sym_LPAREN,
    ACTIONS(991), 1,
      anon_sym_await,
    ACTIONS(993), 1,
      sym__string_start,
    STATE(630), 1,
      sym__primary_expression,
    STATE(1231), 1,
      sym__expression,
    STATE(1295), 1,
      sym__attribute_expression,
    STATE(688), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(975), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1294), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(973), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(985), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(691), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [17574] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(649), 1,
      anon_sym_await,
    ACTIONS(653), 1,
      sym__string_start,
    STATE(472), 1,
      sym__primary_expression,
    STATE(1134), 1,
      sym__attribute_expression,
    STATE(1138), 1,
      sym__expression,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1006), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [17652] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(649), 1,
      anon_sym_await,
    ACTIONS(653), 1,
      sym__string_start,
    STATE(472), 1,
      sym__primary_expression,
    STATE(1134), 1,
      sym__attribute_expression,
    STATE(1265), 1,
      sym__expression,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1006), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [17730] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(971), 1,
      sym__identifier,
    ACTIONS(977), 1,
      anon_sym_AMP,
    ACTIONS(979), 1,
      anon_sym_DOT,
    ACTIONS(981), 1,
      anon_sym_LBRACE,
    ACTIONS(983), 1,
      anon_sym_LBRACK,
    ACTIONS(987), 1,
      anon_sym_not,
    ACTIONS(989), 1,
      anon_sym_LPAREN,
    ACTIONS(991), 1,
      anon_sym_await,
    ACTIONS(993), 1,
      sym__string_start,
    STATE(630), 1,
      sym__primary_expression,
    STATE(1266), 1,
      sym__expression,
    STATE(1295), 1,
      sym__attribute_expression,
    STATE(688), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(975), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1294), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(973), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(985), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(691), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [17808] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(649), 1,
      anon_sym_await,
    ACTIONS(653), 1,
      sym__string_start,
    STATE(472), 1,
      sym__primary_expression,
    STATE(1035), 1,
      sym__expression,
    STATE(1134), 1,
      sym__attribute_expression,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1006), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [17886] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(649), 1,
      anon_sym_await,
    ACTIONS(653), 1,
      sym__string_start,
    STATE(472), 1,
      sym__primary_expression,
    STATE(1134), 1,
      sym__attribute_expression,
    STATE(1296), 1,
      sym__expression,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1006), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [17964] = 19,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(649), 1,
      anon_sym_await,
    ACTIONS(653), 1,
      sym__string_start,
    STATE(472), 1,
      sym__primary_expression,
    STATE(1134), 1,
      sym__attribute_expression,
    STATE(1290), 1,
      sym__expression,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    STATE(1006), 3,
      sym_comparison_operator,
      sym_conditional_expression,
      sym_await_expression,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [18042] = 20,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(653), 1,
      sym__string_start,
    ACTIONS(943), 1,
      sym__identifier,
    ACTIONS(959), 1,
      anon_sym_not,
    ACTIONS(961), 1,
      anon_sym_LPAREN,
    ACTIONS(995), 1,
      sym_integer,
    STATE(571), 1,
      sym_string_name,
    STATE(735), 1,
      sym_attribute,
    STATE(736), 1,
      sym__primary_expression,
    STATE(1300), 1,
      sym__enumerator_expression,
    STATE(1302), 1,
      sym__attribute_expression,
    ACTIONS(629), 3,
      sym_true,
      sym_false,
      sym_null,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(957), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 4,
      sym_string,
      sym_dictionary,
      sym_array,
      sym_base_call,
    STATE(724), 6,
      sym_identifier,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_call,
  [18118] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(913), 1,
      sym__identifier,
    ACTIONS(919), 1,
      anon_sym_AMP,
    ACTIONS(921), 1,
      anon_sym_DOT,
    ACTIONS(923), 1,
      anon_sym_LBRACE,
    ACTIONS(925), 1,
      anon_sym_LBRACK,
    ACTIONS(929), 1,
      anon_sym_not,
    ACTIONS(931), 1,
      anon_sym_LPAREN,
    ACTIONS(937), 1,
      sym__string_start,
    STATE(602), 1,
      sym__primary_expression,
    STATE(1287), 1,
      sym__attribute_expression,
    STATE(699), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(917), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(915), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(927), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(696), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [18185] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(943), 1,
      sym__identifier,
    ACTIONS(949), 1,
      anon_sym_AMP,
    ACTIONS(951), 1,
      anon_sym_DOT,
    ACTIONS(953), 1,
      anon_sym_LBRACE,
    ACTIONS(955), 1,
      anon_sym_LBRACK,
    ACTIONS(959), 1,
      anon_sym_not,
    ACTIONS(961), 1,
      anon_sym_LPAREN,
    ACTIONS(967), 1,
      sym__string_start,
    STATE(491), 1,
      sym__primary_expression,
    STATE(1304), 1,
      sym__attribute_expression,
    STATE(607), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(947), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(945), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(957), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(612), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [18252] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(971), 1,
      sym__identifier,
    ACTIONS(977), 1,
      anon_sym_AMP,
    ACTIONS(979), 1,
      anon_sym_DOT,
    ACTIONS(981), 1,
      anon_sym_LBRACE,
    ACTIONS(983), 1,
      anon_sym_LBRACK,
    ACTIONS(987), 1,
      anon_sym_not,
    ACTIONS(989), 1,
      anon_sym_LPAREN,
    ACTIONS(993), 1,
      sym__string_start,
    STATE(734), 1,
      sym__primary_expression,
    STATE(1295), 1,
      sym__attribute_expression,
    STATE(688), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(975), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(973), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(985), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(691), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [18319] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(971), 1,
      sym__identifier,
    ACTIONS(977), 1,
      anon_sym_AMP,
    ACTIONS(979), 1,
      anon_sym_DOT,
    ACTIONS(981), 1,
      anon_sym_LBRACE,
    ACTIONS(983), 1,
      anon_sym_LBRACK,
    ACTIONS(987), 1,
      anon_sym_not,
    ACTIONS(989), 1,
      anon_sym_LPAREN,
    ACTIONS(993), 1,
      sym__string_start,
    STATE(729), 1,
      sym__primary_expression,
    STATE(1295), 1,
      sym__attribute_expression,
    STATE(688), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(975), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(973), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(985), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(691), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [18386] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(971), 1,
      sym__identifier,
    ACTIONS(977), 1,
      anon_sym_AMP,
    ACTIONS(979), 1,
      anon_sym_DOT,
    ACTIONS(981), 1,
      anon_sym_LBRACE,
    ACTIONS(983), 1,
      anon_sym_LBRACK,
    ACTIONS(987), 1,
      anon_sym_not,
    ACTIONS(989), 1,
      anon_sym_LPAREN,
    ACTIONS(993), 1,
      sym__string_start,
    STATE(730), 1,
      sym__primary_expression,
    STATE(1295), 1,
      sym__attribute_expression,
    STATE(688), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(975), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(973), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(985), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(691), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [18453] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(971), 1,
      sym__identifier,
    ACTIONS(977), 1,
      anon_sym_AMP,
    ACTIONS(979), 1,
      anon_sym_DOT,
    ACTIONS(981), 1,
      anon_sym_LBRACE,
    ACTIONS(983), 1,
      anon_sym_LBRACK,
    ACTIONS(987), 1,
      anon_sym_not,
    ACTIONS(989), 1,
      anon_sym_LPAREN,
    ACTIONS(993), 1,
      sym__string_start,
    STATE(726), 1,
      sym__primary_expression,
    STATE(1295), 1,
      sym__attribute_expression,
    STATE(688), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(975), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(973), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(985), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(691), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [18520] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(971), 1,
      sym__identifier,
    ACTIONS(977), 1,
      anon_sym_AMP,
    ACTIONS(979), 1,
      anon_sym_DOT,
    ACTIONS(981), 1,
      anon_sym_LBRACE,
    ACTIONS(983), 1,
      anon_sym_LBRACK,
    ACTIONS(987), 1,
      anon_sym_not,
    ACTIONS(989), 1,
      anon_sym_LPAREN,
    ACTIONS(993), 1,
      sym__string_start,
    STATE(731), 1,
      sym__primary_expression,
    STATE(1295), 1,
      sym__attribute_expression,
    STATE(688), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(975), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(973), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(985), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(691), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [18587] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(971), 1,
      sym__identifier,
    ACTIONS(977), 1,
      anon_sym_AMP,
    ACTIONS(979), 1,
      anon_sym_DOT,
    ACTIONS(981), 1,
      anon_sym_LBRACE,
    ACTIONS(983), 1,
      anon_sym_LBRACK,
    ACTIONS(987), 1,
      anon_sym_not,
    ACTIONS(989), 1,
      anon_sym_LPAREN,
    ACTIONS(993), 1,
      sym__string_start,
    STATE(733), 1,
      sym__primary_expression,
    STATE(1295), 1,
      sym__attribute_expression,
    STATE(688), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(975), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(973), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(985), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(691), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [18654] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym__identifier,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(43), 1,
      anon_sym_DOT,
    ACTIONS(57), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_not,
    ACTIONS(67), 1,
      anon_sym_LPAREN,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(223), 1,
      sym__primary_expression,
    STATE(1145), 1,
      sym__attribute_expression,
    STATE(237), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(15), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(9), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(63), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(233), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [18721] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym__identifier,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(43), 1,
      anon_sym_DOT,
    ACTIONS(57), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_not,
    ACTIONS(67), 1,
      anon_sym_LPAREN,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(217), 1,
      sym__primary_expression,
    STATE(1145), 1,
      sym__attribute_expression,
    STATE(237), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(15), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(9), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(63), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(233), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [18788] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym__identifier,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(43), 1,
      anon_sym_DOT,
    ACTIONS(57), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_not,
    ACTIONS(67), 1,
      anon_sym_LPAREN,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(230), 1,
      sym__primary_expression,
    STATE(1292), 1,
      sym__attribute_expression,
    STATE(237), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(15), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(9), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(63), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(233), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [18855] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym__identifier,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(43), 1,
      anon_sym_DOT,
    ACTIONS(57), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_not,
    ACTIONS(67), 1,
      anon_sym_LPAREN,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(214), 1,
      sym__primary_expression,
    STATE(1145), 1,
      sym__attribute_expression,
    STATE(237), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(15), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(9), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(63), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(233), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [18922] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym__identifier,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(43), 1,
      anon_sym_DOT,
    ACTIONS(57), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_not,
    ACTIONS(67), 1,
      anon_sym_LPAREN,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(213), 1,
      sym__primary_expression,
    STATE(1145), 1,
      sym__attribute_expression,
    STATE(237), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(15), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(9), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(63), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(233), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [18989] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym__identifier,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(43), 1,
      anon_sym_DOT,
    ACTIONS(57), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_not,
    ACTIONS(67), 1,
      anon_sym_LPAREN,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(207), 1,
      sym__primary_expression,
    STATE(1145), 1,
      sym__attribute_expression,
    STATE(237), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(15), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(9), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(63), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(233), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [19056] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym__identifier,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(43), 1,
      anon_sym_DOT,
    ACTIONS(57), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_not,
    ACTIONS(67), 1,
      anon_sym_LPAREN,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(210), 1,
      sym__primary_expression,
    STATE(1145), 1,
      sym__attribute_expression,
    STATE(237), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(15), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(9), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(63), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(233), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [19123] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym__identifier,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(43), 1,
      anon_sym_DOT,
    ACTIONS(57), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_not,
    ACTIONS(67), 1,
      anon_sym_LPAREN,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(209), 1,
      sym__primary_expression,
    STATE(1145), 1,
      sym__attribute_expression,
    STATE(237), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(15), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(9), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(63), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(233), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [19190] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym__identifier,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(43), 1,
      anon_sym_DOT,
    ACTIONS(57), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_not,
    ACTIONS(67), 1,
      anon_sym_LPAREN,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(208), 1,
      sym__primary_expression,
    STATE(1145), 1,
      sym__attribute_expression,
    STATE(237), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(15), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(9), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(63), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(233), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [19257] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym__identifier,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(43), 1,
      anon_sym_DOT,
    ACTIONS(57), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_not,
    ACTIONS(67), 1,
      anon_sym_LPAREN,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(220), 1,
      sym__primary_expression,
    STATE(1145), 1,
      sym__attribute_expression,
    STATE(237), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(15), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(9), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(63), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(233), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [19324] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym__identifier,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(43), 1,
      anon_sym_DOT,
    ACTIONS(57), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_not,
    ACTIONS(67), 1,
      anon_sym_LPAREN,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(212), 1,
      sym__primary_expression,
    STATE(1145), 1,
      sym__attribute_expression,
    STATE(237), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(15), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(9), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(63), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(233), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [19391] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(7), 1,
      sym__identifier,
    ACTIONS(17), 1,
      anon_sym_AMP,
    ACTIONS(43), 1,
      anon_sym_DOT,
    ACTIONS(57), 1,
      anon_sym_LBRACE,
    ACTIONS(61), 1,
      anon_sym_LBRACK,
    ACTIONS(65), 1,
      anon_sym_not,
    ACTIONS(67), 1,
      anon_sym_LPAREN,
    ACTIONS(73), 1,
      sym__string_start,
    STATE(222), 1,
      sym__primary_expression,
    STATE(1145), 1,
      sym__attribute_expression,
    STATE(237), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(15), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(9), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(63), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(233), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [19458] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(971), 1,
      sym__identifier,
    ACTIONS(977), 1,
      anon_sym_AMP,
    ACTIONS(979), 1,
      anon_sym_DOT,
    ACTIONS(981), 1,
      anon_sym_LBRACE,
    ACTIONS(983), 1,
      anon_sym_LBRACK,
    ACTIONS(987), 1,
      anon_sym_not,
    ACTIONS(989), 1,
      anon_sym_LPAREN,
    ACTIONS(993), 1,
      sym__string_start,
    STATE(728), 1,
      sym__primary_expression,
    STATE(1295), 1,
      sym__attribute_expression,
    STATE(688), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(975), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(973), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(985), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(691), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [19525] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(769), 1,
      sym__identifier,
    ACTIONS(775), 1,
      anon_sym_AMP,
    ACTIONS(777), 1,
      anon_sym_DOT,
    ACTIONS(779), 1,
      anon_sym_LBRACE,
    ACTIONS(781), 1,
      anon_sym_LBRACK,
    ACTIONS(787), 1,
      anon_sym_not,
    ACTIONS(789), 1,
      anon_sym_LPAREN,
    ACTIONS(795), 1,
      sym__string_start,
    STATE(528), 1,
      sym__primary_expression,
    STATE(1278), 1,
      sym__attribute_expression,
    STATE(613), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(773), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(771), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(785), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(610), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [19592] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(769), 1,
      sym__identifier,
    ACTIONS(775), 1,
      anon_sym_AMP,
    ACTIONS(777), 1,
      anon_sym_DOT,
    ACTIONS(779), 1,
      anon_sym_LBRACE,
    ACTIONS(781), 1,
      anon_sym_LBRACK,
    ACTIONS(787), 1,
      anon_sym_not,
    ACTIONS(789), 1,
      anon_sym_LPAREN,
    ACTIONS(795), 1,
      sym__string_start,
    STATE(513), 1,
      sym__primary_expression,
    STATE(1278), 1,
      sym__attribute_expression,
    STATE(613), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(773), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(771), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(785), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(610), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [19659] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(769), 1,
      sym__identifier,
    ACTIONS(775), 1,
      anon_sym_AMP,
    ACTIONS(777), 1,
      anon_sym_DOT,
    ACTIONS(779), 1,
      anon_sym_LBRACE,
    ACTIONS(781), 1,
      anon_sym_LBRACK,
    ACTIONS(787), 1,
      anon_sym_not,
    ACTIONS(789), 1,
      anon_sym_LPAREN,
    ACTIONS(795), 1,
      sym__string_start,
    STATE(650), 1,
      sym__primary_expression,
    STATE(1103), 1,
      sym__attribute_expression,
    STATE(613), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(773), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(771), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(785), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(610), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [19726] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(769), 1,
      sym__identifier,
    ACTIONS(775), 1,
      anon_sym_AMP,
    ACTIONS(777), 1,
      anon_sym_DOT,
    ACTIONS(779), 1,
      anon_sym_LBRACE,
    ACTIONS(781), 1,
      anon_sym_LBRACK,
    ACTIONS(787), 1,
      anon_sym_not,
    ACTIONS(789), 1,
      anon_sym_LPAREN,
    ACTIONS(795), 1,
      sym__string_start,
    STATE(512), 1,
      sym__primary_expression,
    STATE(1278), 1,
      sym__attribute_expression,
    STATE(613), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(773), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(771), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(785), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(610), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [19793] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(769), 1,
      sym__identifier,
    ACTIONS(775), 1,
      anon_sym_AMP,
    ACTIONS(777), 1,
      anon_sym_DOT,
    ACTIONS(779), 1,
      anon_sym_LBRACE,
    ACTIONS(781), 1,
      anon_sym_LBRACK,
    ACTIONS(787), 1,
      anon_sym_not,
    ACTIONS(789), 1,
      anon_sym_LPAREN,
    ACTIONS(795), 1,
      sym__string_start,
    STATE(503), 1,
      sym__primary_expression,
    STATE(1278), 1,
      sym__attribute_expression,
    STATE(613), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(773), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(771), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(785), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(610), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [19860] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(769), 1,
      sym__identifier,
    ACTIONS(775), 1,
      anon_sym_AMP,
    ACTIONS(777), 1,
      anon_sym_DOT,
    ACTIONS(779), 1,
      anon_sym_LBRACE,
    ACTIONS(781), 1,
      anon_sym_LBRACK,
    ACTIONS(787), 1,
      anon_sym_not,
    ACTIONS(789), 1,
      anon_sym_LPAREN,
    ACTIONS(795), 1,
      sym__string_start,
    STATE(501), 1,
      sym__primary_expression,
    STATE(1278), 1,
      sym__attribute_expression,
    STATE(613), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(773), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(771), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(785), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(610), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [19927] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(769), 1,
      sym__identifier,
    ACTIONS(775), 1,
      anon_sym_AMP,
    ACTIONS(777), 1,
      anon_sym_DOT,
    ACTIONS(779), 1,
      anon_sym_LBRACE,
    ACTIONS(781), 1,
      anon_sym_LBRACK,
    ACTIONS(787), 1,
      anon_sym_not,
    ACTIONS(789), 1,
      anon_sym_LPAREN,
    ACTIONS(795), 1,
      sym__string_start,
    STATE(500), 1,
      sym__primary_expression,
    STATE(1278), 1,
      sym__attribute_expression,
    STATE(613), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(773), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(771), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(785), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(610), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [19994] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(769), 1,
      sym__identifier,
    ACTIONS(775), 1,
      anon_sym_AMP,
    ACTIONS(777), 1,
      anon_sym_DOT,
    ACTIONS(779), 1,
      anon_sym_LBRACE,
    ACTIONS(781), 1,
      anon_sym_LBRACK,
    ACTIONS(787), 1,
      anon_sym_not,
    ACTIONS(789), 1,
      anon_sym_LPAREN,
    ACTIONS(795), 1,
      sym__string_start,
    STATE(498), 1,
      sym__primary_expression,
    STATE(1278), 1,
      sym__attribute_expression,
    STATE(613), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(773), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(771), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(785), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(610), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [20061] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(769), 1,
      sym__identifier,
    ACTIONS(775), 1,
      anon_sym_AMP,
    ACTIONS(777), 1,
      anon_sym_DOT,
    ACTIONS(779), 1,
      anon_sym_LBRACE,
    ACTIONS(781), 1,
      anon_sym_LBRACK,
    ACTIONS(787), 1,
      anon_sym_not,
    ACTIONS(789), 1,
      anon_sym_LPAREN,
    ACTIONS(795), 1,
      sym__string_start,
    STATE(497), 1,
      sym__primary_expression,
    STATE(1278), 1,
      sym__attribute_expression,
    STATE(613), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(773), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(771), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(785), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(610), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [20128] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(769), 1,
      sym__identifier,
    ACTIONS(775), 1,
      anon_sym_AMP,
    ACTIONS(777), 1,
      anon_sym_DOT,
    ACTIONS(779), 1,
      anon_sym_LBRACE,
    ACTIONS(781), 1,
      anon_sym_LBRACK,
    ACTIONS(787), 1,
      anon_sym_not,
    ACTIONS(789), 1,
      anon_sym_LPAREN,
    ACTIONS(795), 1,
      sym__string_start,
    STATE(496), 1,
      sym__primary_expression,
    STATE(1278), 1,
      sym__attribute_expression,
    STATE(613), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(773), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(771), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(785), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(610), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [20195] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(769), 1,
      sym__identifier,
    ACTIONS(775), 1,
      anon_sym_AMP,
    ACTIONS(777), 1,
      anon_sym_DOT,
    ACTIONS(779), 1,
      anon_sym_LBRACE,
    ACTIONS(781), 1,
      anon_sym_LBRACK,
    ACTIONS(787), 1,
      anon_sym_not,
    ACTIONS(789), 1,
      anon_sym_LPAREN,
    ACTIONS(795), 1,
      sym__string_start,
    STATE(495), 1,
      sym__primary_expression,
    STATE(1278), 1,
      sym__attribute_expression,
    STATE(613), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(773), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(771), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(785), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(610), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [20262] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(769), 1,
      sym__identifier,
    ACTIONS(775), 1,
      anon_sym_AMP,
    ACTIONS(777), 1,
      anon_sym_DOT,
    ACTIONS(779), 1,
      anon_sym_LBRACE,
    ACTIONS(781), 1,
      anon_sym_LBRACK,
    ACTIONS(787), 1,
      anon_sym_not,
    ACTIONS(789), 1,
      anon_sym_LPAREN,
    ACTIONS(795), 1,
      sym__string_start,
    STATE(492), 1,
      sym__primary_expression,
    STATE(1278), 1,
      sym__attribute_expression,
    STATE(613), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(773), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(771), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(785), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(610), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [20329] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(653), 1,
      sym__string_start,
    STATE(473), 1,
      sym__primary_expression,
    STATE(1250), 1,
      sym__attribute_expression,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [20396] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(913), 1,
      sym__identifier,
    ACTIONS(919), 1,
      anon_sym_AMP,
    ACTIONS(921), 1,
      anon_sym_DOT,
    ACTIONS(923), 1,
      anon_sym_LBRACE,
    ACTIONS(925), 1,
      anon_sym_LBRACK,
    ACTIONS(929), 1,
      anon_sym_not,
    ACTIONS(931), 1,
      anon_sym_LPAREN,
    ACTIONS(937), 1,
      sym__string_start,
    STATE(566), 1,
      sym__primary_expression,
    STATE(1287), 1,
      sym__attribute_expression,
    STATE(699), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(917), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(915), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(927), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(696), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [20463] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(913), 1,
      sym__identifier,
    ACTIONS(919), 1,
      anon_sym_AMP,
    ACTIONS(921), 1,
      anon_sym_DOT,
    ACTIONS(923), 1,
      anon_sym_LBRACE,
    ACTIONS(925), 1,
      anon_sym_LBRACK,
    ACTIONS(929), 1,
      anon_sym_not,
    ACTIONS(931), 1,
      anon_sym_LPAREN,
    ACTIONS(937), 1,
      sym__string_start,
    STATE(713), 1,
      sym__primary_expression,
    STATE(1180), 1,
      sym__attribute_expression,
    STATE(699), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(917), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(915), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(927), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(696), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [20530] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(943), 1,
      sym__identifier,
    ACTIONS(949), 1,
      anon_sym_AMP,
    ACTIONS(951), 1,
      anon_sym_DOT,
    ACTIONS(953), 1,
      anon_sym_LBRACE,
    ACTIONS(955), 1,
      anon_sym_LBRACK,
    ACTIONS(959), 1,
      anon_sym_not,
    ACTIONS(961), 1,
      anon_sym_LPAREN,
    ACTIONS(967), 1,
      sym__string_start,
    STATE(526), 1,
      sym__primary_expression,
    STATE(1304), 1,
      sym__attribute_expression,
    STATE(607), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(947), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(945), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(957), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(612), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [20597] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(913), 1,
      sym__identifier,
    ACTIONS(919), 1,
      anon_sym_AMP,
    ACTIONS(921), 1,
      anon_sym_DOT,
    ACTIONS(923), 1,
      anon_sym_LBRACE,
    ACTIONS(925), 1,
      anon_sym_LBRACK,
    ACTIONS(929), 1,
      anon_sym_not,
    ACTIONS(931), 1,
      anon_sym_LPAREN,
    ACTIONS(937), 1,
      sym__string_start,
    STATE(564), 1,
      sym__primary_expression,
    STATE(1287), 1,
      sym__attribute_expression,
    STATE(699), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(917), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(915), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(927), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(696), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [20664] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(943), 1,
      sym__identifier,
    ACTIONS(949), 1,
      anon_sym_AMP,
    ACTIONS(951), 1,
      anon_sym_DOT,
    ACTIONS(953), 1,
      anon_sym_LBRACE,
    ACTIONS(955), 1,
      anon_sym_LBRACK,
    ACTIONS(959), 1,
      anon_sym_not,
    ACTIONS(961), 1,
      anon_sym_LPAREN,
    ACTIONS(967), 1,
      sym__string_start,
    STATE(523), 1,
      sym__primary_expression,
    STATE(1304), 1,
      sym__attribute_expression,
    STATE(607), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(947), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(945), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(957), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(612), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [20731] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(943), 1,
      sym__identifier,
    ACTIONS(949), 1,
      anon_sym_AMP,
    ACTIONS(951), 1,
      anon_sym_DOT,
    ACTIONS(953), 1,
      anon_sym_LBRACE,
    ACTIONS(955), 1,
      anon_sym_LBRACK,
    ACTIONS(959), 1,
      anon_sym_not,
    ACTIONS(961), 1,
      anon_sym_LPAREN,
    ACTIONS(967), 1,
      sym__string_start,
    STATE(522), 1,
      sym__primary_expression,
    STATE(1304), 1,
      sym__attribute_expression,
    STATE(607), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(947), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(945), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(957), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(612), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [20798] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(943), 1,
      sym__identifier,
    ACTIONS(949), 1,
      anon_sym_AMP,
    ACTIONS(951), 1,
      anon_sym_DOT,
    ACTIONS(953), 1,
      anon_sym_LBRACE,
    ACTIONS(955), 1,
      anon_sym_LBRACK,
    ACTIONS(959), 1,
      anon_sym_not,
    ACTIONS(961), 1,
      anon_sym_LPAREN,
    ACTIONS(967), 1,
      sym__string_start,
    STATE(521), 1,
      sym__primary_expression,
    STATE(1304), 1,
      sym__attribute_expression,
    STATE(607), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(947), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(945), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(957), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(612), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [20865] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(943), 1,
      sym__identifier,
    ACTIONS(949), 1,
      anon_sym_AMP,
    ACTIONS(951), 1,
      anon_sym_DOT,
    ACTIONS(953), 1,
      anon_sym_LBRACE,
    ACTIONS(955), 1,
      anon_sym_LBRACK,
    ACTIONS(959), 1,
      anon_sym_not,
    ACTIONS(961), 1,
      anon_sym_LPAREN,
    ACTIONS(967), 1,
      sym__string_start,
    STATE(520), 1,
      sym__primary_expression,
    STATE(1304), 1,
      sym__attribute_expression,
    STATE(607), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(947), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(945), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(957), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(612), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [20932] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(943), 1,
      sym__identifier,
    ACTIONS(949), 1,
      anon_sym_AMP,
    ACTIONS(951), 1,
      anon_sym_DOT,
    ACTIONS(953), 1,
      anon_sym_LBRACE,
    ACTIONS(955), 1,
      anon_sym_LBRACK,
    ACTIONS(959), 1,
      anon_sym_not,
    ACTIONS(961), 1,
      anon_sym_LPAREN,
    ACTIONS(967), 1,
      sym__string_start,
    STATE(519), 1,
      sym__primary_expression,
    STATE(1304), 1,
      sym__attribute_expression,
    STATE(607), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(947), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(945), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(957), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(612), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [20999] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(943), 1,
      sym__identifier,
    ACTIONS(949), 1,
      anon_sym_AMP,
    ACTIONS(951), 1,
      anon_sym_DOT,
    ACTIONS(953), 1,
      anon_sym_LBRACE,
    ACTIONS(955), 1,
      anon_sym_LBRACK,
    ACTIONS(959), 1,
      anon_sym_not,
    ACTIONS(961), 1,
      anon_sym_LPAREN,
    ACTIONS(967), 1,
      sym__string_start,
    STATE(518), 1,
      sym__primary_expression,
    STATE(1304), 1,
      sym__attribute_expression,
    STATE(607), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(947), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(945), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(957), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(612), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [21066] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(943), 1,
      sym__identifier,
    ACTIONS(949), 1,
      anon_sym_AMP,
    ACTIONS(951), 1,
      anon_sym_DOT,
    ACTIONS(953), 1,
      anon_sym_LBRACE,
    ACTIONS(955), 1,
      anon_sym_LBRACK,
    ACTIONS(959), 1,
      anon_sym_not,
    ACTIONS(961), 1,
      anon_sym_LPAREN,
    ACTIONS(967), 1,
      sym__string_start,
    STATE(515), 1,
      sym__primary_expression,
    STATE(1304), 1,
      sym__attribute_expression,
    STATE(607), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(947), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(945), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(957), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(612), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [21133] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(943), 1,
      sym__identifier,
    ACTIONS(949), 1,
      anon_sym_AMP,
    ACTIONS(951), 1,
      anon_sym_DOT,
    ACTIONS(953), 1,
      anon_sym_LBRACE,
    ACTIONS(955), 1,
      anon_sym_LBRACK,
    ACTIONS(959), 1,
      anon_sym_not,
    ACTIONS(961), 1,
      anon_sym_LPAREN,
    ACTIONS(967), 1,
      sym__string_start,
    STATE(499), 1,
      sym__primary_expression,
    STATE(1304), 1,
      sym__attribute_expression,
    STATE(607), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(947), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(945), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(957), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(612), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [21200] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(943), 1,
      sym__identifier,
    ACTIONS(949), 1,
      anon_sym_AMP,
    ACTIONS(951), 1,
      anon_sym_DOT,
    ACTIONS(953), 1,
      anon_sym_LBRACE,
    ACTIONS(955), 1,
      anon_sym_LBRACK,
    ACTIONS(959), 1,
      anon_sym_not,
    ACTIONS(961), 1,
      anon_sym_LPAREN,
    ACTIONS(967), 1,
      sym__string_start,
    STATE(590), 1,
      sym__primary_expression,
    STATE(1302), 1,
      sym__attribute_expression,
    STATE(607), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(947), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(945), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(957), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(612), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [21267] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(913), 1,
      sym__identifier,
    ACTIONS(919), 1,
      anon_sym_AMP,
    ACTIONS(921), 1,
      anon_sym_DOT,
    ACTIONS(923), 1,
      anon_sym_LBRACE,
    ACTIONS(925), 1,
      anon_sym_LBRACK,
    ACTIONS(929), 1,
      anon_sym_not,
    ACTIONS(931), 1,
      anon_sym_LPAREN,
    ACTIONS(937), 1,
      sym__string_start,
    STATE(550), 1,
      sym__primary_expression,
    STATE(1287), 1,
      sym__attribute_expression,
    STATE(699), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(917), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(915), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(927), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(696), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [21334] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(913), 1,
      sym__identifier,
    ACTIONS(919), 1,
      anon_sym_AMP,
    ACTIONS(921), 1,
      anon_sym_DOT,
    ACTIONS(923), 1,
      anon_sym_LBRACE,
    ACTIONS(925), 1,
      anon_sym_LBRACK,
    ACTIONS(929), 1,
      anon_sym_not,
    ACTIONS(931), 1,
      anon_sym_LPAREN,
    ACTIONS(937), 1,
      sym__string_start,
    STATE(563), 1,
      sym__primary_expression,
    STATE(1287), 1,
      sym__attribute_expression,
    STATE(699), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(917), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(915), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(927), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(696), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [21401] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(913), 1,
      sym__identifier,
    ACTIONS(919), 1,
      anon_sym_AMP,
    ACTIONS(921), 1,
      anon_sym_DOT,
    ACTIONS(923), 1,
      anon_sym_LBRACE,
    ACTIONS(925), 1,
      anon_sym_LBRACK,
    ACTIONS(929), 1,
      anon_sym_not,
    ACTIONS(931), 1,
      anon_sym_LPAREN,
    ACTIONS(937), 1,
      sym__string_start,
    STATE(562), 1,
      sym__primary_expression,
    STATE(1287), 1,
      sym__attribute_expression,
    STATE(699), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(917), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(915), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(927), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(696), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [21468] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(943), 1,
      sym__identifier,
    ACTIONS(949), 1,
      anon_sym_AMP,
    ACTIONS(951), 1,
      anon_sym_DOT,
    ACTIONS(953), 1,
      anon_sym_LBRACE,
    ACTIONS(955), 1,
      anon_sym_LBRACK,
    ACTIONS(959), 1,
      anon_sym_not,
    ACTIONS(961), 1,
      anon_sym_LPAREN,
    ACTIONS(967), 1,
      sym__string_start,
    STATE(489), 1,
      sym__primary_expression,
    STATE(1304), 1,
      sym__attribute_expression,
    STATE(607), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(947), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(945), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(957), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(612), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [21535] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(971), 1,
      sym__identifier,
    ACTIONS(977), 1,
      anon_sym_AMP,
    ACTIONS(979), 1,
      anon_sym_DOT,
    ACTIONS(981), 1,
      anon_sym_LBRACE,
    ACTIONS(983), 1,
      anon_sym_LBRACK,
    ACTIONS(987), 1,
      anon_sym_not,
    ACTIONS(989), 1,
      anon_sym_LPAREN,
    ACTIONS(993), 1,
      sym__string_start,
    STATE(628), 1,
      sym__primary_expression,
    STATE(1303), 1,
      sym__attribute_expression,
    STATE(688), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(975), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(973), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(985), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(691), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [21602] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(913), 1,
      sym__identifier,
    ACTIONS(919), 1,
      anon_sym_AMP,
    ACTIONS(921), 1,
      anon_sym_DOT,
    ACTIONS(923), 1,
      anon_sym_LBRACE,
    ACTIONS(925), 1,
      anon_sym_LBRACK,
    ACTIONS(929), 1,
      anon_sym_not,
    ACTIONS(931), 1,
      anon_sym_LPAREN,
    ACTIONS(937), 1,
      sym__string_start,
    STATE(561), 1,
      sym__primary_expression,
    STATE(1287), 1,
      sym__attribute_expression,
    STATE(699), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(917), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(915), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(927), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(696), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [21669] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(971), 1,
      sym__identifier,
    ACTIONS(977), 1,
      anon_sym_AMP,
    ACTIONS(979), 1,
      anon_sym_DOT,
    ACTIONS(981), 1,
      anon_sym_LBRACE,
    ACTIONS(983), 1,
      anon_sym_LBRACK,
    ACTIONS(987), 1,
      anon_sym_not,
    ACTIONS(989), 1,
      anon_sym_LPAREN,
    ACTIONS(993), 1,
      sym__string_start,
    STATE(639), 1,
      sym__primary_expression,
    STATE(1303), 1,
      sym__attribute_expression,
    STATE(688), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(975), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(973), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(985), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(691), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [21736] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(971), 1,
      sym__identifier,
    ACTIONS(977), 1,
      anon_sym_AMP,
    ACTIONS(979), 1,
      anon_sym_DOT,
    ACTIONS(981), 1,
      anon_sym_LBRACE,
    ACTIONS(983), 1,
      anon_sym_LBRACK,
    ACTIONS(987), 1,
      anon_sym_not,
    ACTIONS(989), 1,
      anon_sym_LPAREN,
    ACTIONS(993), 1,
      sym__string_start,
    STATE(643), 1,
      sym__primary_expression,
    STATE(1303), 1,
      sym__attribute_expression,
    STATE(688), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(975), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(973), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(985), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(691), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [21803] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(971), 1,
      sym__identifier,
    ACTIONS(977), 1,
      anon_sym_AMP,
    ACTIONS(979), 1,
      anon_sym_DOT,
    ACTIONS(981), 1,
      anon_sym_LBRACE,
    ACTIONS(983), 1,
      anon_sym_LBRACK,
    ACTIONS(987), 1,
      anon_sym_not,
    ACTIONS(989), 1,
      anon_sym_LPAREN,
    ACTIONS(993), 1,
      sym__string_start,
    STATE(647), 1,
      sym__primary_expression,
    STATE(1303), 1,
      sym__attribute_expression,
    STATE(688), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(975), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(973), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(985), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(691), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [21870] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(971), 1,
      sym__identifier,
    ACTIONS(977), 1,
      anon_sym_AMP,
    ACTIONS(979), 1,
      anon_sym_DOT,
    ACTIONS(981), 1,
      anon_sym_LBRACE,
    ACTIONS(983), 1,
      anon_sym_LBRACK,
    ACTIONS(987), 1,
      anon_sym_not,
    ACTIONS(989), 1,
      anon_sym_LPAREN,
    ACTIONS(993), 1,
      sym__string_start,
    STATE(652), 1,
      sym__primary_expression,
    STATE(1303), 1,
      sym__attribute_expression,
    STATE(688), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(975), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(973), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(985), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(691), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [21937] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(971), 1,
      sym__identifier,
    ACTIONS(977), 1,
      anon_sym_AMP,
    ACTIONS(979), 1,
      anon_sym_DOT,
    ACTIONS(981), 1,
      anon_sym_LBRACE,
    ACTIONS(983), 1,
      anon_sym_LBRACK,
    ACTIONS(987), 1,
      anon_sym_not,
    ACTIONS(989), 1,
      anon_sym_LPAREN,
    ACTIONS(993), 1,
      sym__string_start,
    STATE(654), 1,
      sym__primary_expression,
    STATE(1303), 1,
      sym__attribute_expression,
    STATE(688), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(975), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(973), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(985), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(691), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [22004] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(971), 1,
      sym__identifier,
    ACTIONS(977), 1,
      anon_sym_AMP,
    ACTIONS(979), 1,
      anon_sym_DOT,
    ACTIONS(981), 1,
      anon_sym_LBRACE,
    ACTIONS(983), 1,
      anon_sym_LBRACK,
    ACTIONS(987), 1,
      anon_sym_not,
    ACTIONS(989), 1,
      anon_sym_LPAREN,
    ACTIONS(993), 1,
      sym__string_start,
    STATE(658), 1,
      sym__primary_expression,
    STATE(1303), 1,
      sym__attribute_expression,
    STATE(688), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(975), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(973), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(985), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(691), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [22071] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(971), 1,
      sym__identifier,
    ACTIONS(977), 1,
      anon_sym_AMP,
    ACTIONS(979), 1,
      anon_sym_DOT,
    ACTIONS(981), 1,
      anon_sym_LBRACE,
    ACTIONS(983), 1,
      anon_sym_LBRACK,
    ACTIONS(987), 1,
      anon_sym_not,
    ACTIONS(989), 1,
      anon_sym_LPAREN,
    ACTIONS(993), 1,
      sym__string_start,
    STATE(532), 1,
      sym__primary_expression,
    STATE(1303), 1,
      sym__attribute_expression,
    STATE(688), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(975), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(973), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(985), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(691), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [22138] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(971), 1,
      sym__identifier,
    ACTIONS(977), 1,
      anon_sym_AMP,
    ACTIONS(979), 1,
      anon_sym_DOT,
    ACTIONS(981), 1,
      anon_sym_LBRACE,
    ACTIONS(983), 1,
      anon_sym_LBRACK,
    ACTIONS(987), 1,
      anon_sym_not,
    ACTIONS(989), 1,
      anon_sym_LPAREN,
    ACTIONS(993), 1,
      sym__string_start,
    STATE(661), 1,
      sym__primary_expression,
    STATE(1303), 1,
      sym__attribute_expression,
    STATE(688), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(975), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(973), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(985), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(691), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [22205] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(971), 1,
      sym__identifier,
    ACTIONS(977), 1,
      anon_sym_AMP,
    ACTIONS(979), 1,
      anon_sym_DOT,
    ACTIONS(981), 1,
      anon_sym_LBRACE,
    ACTIONS(983), 1,
      anon_sym_LBRACK,
    ACTIONS(987), 1,
      anon_sym_not,
    ACTIONS(989), 1,
      anon_sym_LPAREN,
    ACTIONS(993), 1,
      sym__string_start,
    STATE(668), 1,
      sym__primary_expression,
    STATE(1295), 1,
      sym__attribute_expression,
    STATE(688), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(975), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(973), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(985), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(691), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [22272] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(971), 1,
      sym__identifier,
    ACTIONS(977), 1,
      anon_sym_AMP,
    ACTIONS(979), 1,
      anon_sym_DOT,
    ACTIONS(981), 1,
      anon_sym_LBRACE,
    ACTIONS(983), 1,
      anon_sym_LBRACK,
    ACTIONS(987), 1,
      anon_sym_not,
    ACTIONS(989), 1,
      anon_sym_LPAREN,
    ACTIONS(993), 1,
      sym__string_start,
    STATE(664), 1,
      sym__primary_expression,
    STATE(1303), 1,
      sym__attribute_expression,
    STATE(688), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(975), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(973), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(985), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(691), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [22339] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(971), 1,
      sym__identifier,
    ACTIONS(977), 1,
      anon_sym_AMP,
    ACTIONS(979), 1,
      anon_sym_DOT,
    ACTIONS(981), 1,
      anon_sym_LBRACE,
    ACTIONS(983), 1,
      anon_sym_LBRACK,
    ACTIONS(987), 1,
      anon_sym_not,
    ACTIONS(989), 1,
      anon_sym_LPAREN,
    ACTIONS(993), 1,
      sym__string_start,
    STATE(633), 1,
      sym__primary_expression,
    STATE(1303), 1,
      sym__attribute_expression,
    STATE(688), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(975), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(973), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(985), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(691), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [22406] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(913), 1,
      sym__identifier,
    ACTIONS(919), 1,
      anon_sym_AMP,
    ACTIONS(921), 1,
      anon_sym_DOT,
    ACTIONS(923), 1,
      anon_sym_LBRACE,
    ACTIONS(925), 1,
      anon_sym_LBRACK,
    ACTIONS(929), 1,
      anon_sym_not,
    ACTIONS(931), 1,
      anon_sym_LPAREN,
    ACTIONS(937), 1,
      sym__string_start,
    STATE(559), 1,
      sym__primary_expression,
    STATE(1287), 1,
      sym__attribute_expression,
    STATE(699), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(917), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(915), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(927), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(696), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [22473] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(913), 1,
      sym__identifier,
    ACTIONS(919), 1,
      anon_sym_AMP,
    ACTIONS(921), 1,
      anon_sym_DOT,
    ACTIONS(923), 1,
      anon_sym_LBRACE,
    ACTIONS(925), 1,
      anon_sym_LBRACK,
    ACTIONS(929), 1,
      anon_sym_not,
    ACTIONS(931), 1,
      anon_sym_LPAREN,
    ACTIONS(937), 1,
      sym__string_start,
    STATE(558), 1,
      sym__primary_expression,
    STATE(1287), 1,
      sym__attribute_expression,
    STATE(699), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(917), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(915), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(927), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(696), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [22540] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(913), 1,
      sym__identifier,
    ACTIONS(919), 1,
      anon_sym_AMP,
    ACTIONS(921), 1,
      anon_sym_DOT,
    ACTIONS(923), 1,
      anon_sym_LBRACE,
    ACTIONS(925), 1,
      anon_sym_LBRACK,
    ACTIONS(929), 1,
      anon_sym_not,
    ACTIONS(931), 1,
      anon_sym_LPAREN,
    ACTIONS(937), 1,
      sym__string_start,
    STATE(556), 1,
      sym__primary_expression,
    STATE(1287), 1,
      sym__attribute_expression,
    STATE(699), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(917), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(915), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(927), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(696), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [22607] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(653), 1,
      sym__string_start,
    STATE(511), 1,
      sym__primary_expression,
    STATE(1250), 1,
      sym__attribute_expression,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [22674] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(653), 1,
      sym__string_start,
    STATE(510), 1,
      sym__primary_expression,
    STATE(1250), 1,
      sym__attribute_expression,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [22741] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(653), 1,
      sym__string_start,
    STATE(509), 1,
      sym__primary_expression,
    STATE(1250), 1,
      sym__attribute_expression,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [22808] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(653), 1,
      sym__string_start,
    STATE(508), 1,
      sym__primary_expression,
    STATE(1250), 1,
      sym__attribute_expression,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [22875] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(653), 1,
      sym__string_start,
    STATE(507), 1,
      sym__primary_expression,
    STATE(1250), 1,
      sym__attribute_expression,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [22942] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(653), 1,
      sym__string_start,
    STATE(506), 1,
      sym__primary_expression,
    STATE(1250), 1,
      sym__attribute_expression,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [23009] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(653), 1,
      sym__string_start,
    STATE(505), 1,
      sym__primary_expression,
    STATE(1250), 1,
      sym__attribute_expression,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [23076] = 3,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(554), 5,
      anon_sym_AMP,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(556), 28,
      anon_sym_AT,
      anon_sym_COLON,
      anon_sym_var,
      anon_sym_DOT,
      anon_sym_if,
      anon_sym_else,
      anon_sym_in,
      anon_sym_LBRACK,
      anon_sym_and,
      anon_sym_AMP_AMP,
      anon_sym_or,
      anon_sym_PIPE_PIPE,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_SLASH,
      anon_sym_PERCENT,
      anon_sym_CARET,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_is,
      anon_sym_as,
      anon_sym_LT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_GT_EQ,
      anon_sym_LPAREN,
      anon_sym_func,
  [23117] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(653), 1,
      sym__string_start,
    STATE(504), 1,
      sym__primary_expression,
    STATE(1250), 1,
      sym__attribute_expression,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [23184] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(653), 1,
      sym__string_start,
    STATE(533), 1,
      sym__primary_expression,
    STATE(1134), 1,
      sym__attribute_expression,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [23251] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(653), 1,
      sym__string_start,
    STATE(469), 1,
      sym__primary_expression,
    STATE(1250), 1,
      sym__attribute_expression,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [23318] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(627), 1,
      sym__identifier,
    ACTIONS(633), 1,
      anon_sym_AMP,
    ACTIONS(635), 1,
      anon_sym_DOT,
    ACTIONS(637), 1,
      anon_sym_LBRACE,
    ACTIONS(641), 1,
      anon_sym_LBRACK,
    ACTIONS(645), 1,
      anon_sym_not,
    ACTIONS(647), 1,
      anon_sym_LPAREN,
    ACTIONS(653), 1,
      sym__string_start,
    STATE(502), 1,
      sym__primary_expression,
    STATE(1250), 1,
      sym__attribute_expression,
    STATE(571), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(631), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(629), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(643), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(573), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [23385] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(797), 1,
      sym__identifier,
    ACTIONS(803), 1,
      anon_sym_AMP,
    ACTIONS(805), 1,
      anon_sym_DOT,
    ACTIONS(807), 1,
      anon_sym_LBRACE,
    ACTIONS(809), 1,
      anon_sym_LBRACK,
    ACTIONS(813), 1,
      anon_sym_not,
    ACTIONS(815), 1,
      anon_sym_LPAREN,
    ACTIONS(823), 1,
      sym__string_start,
    STATE(484), 1,
      sym__primary_expression,
    STATE(1301), 1,
      sym__attribute_expression,
    STATE(534), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(801), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(799), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(811), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(537), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [23452] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(913), 1,
      sym__identifier,
    ACTIONS(919), 1,
      anon_sym_AMP,
    ACTIONS(921), 1,
      anon_sym_DOT,
    ACTIONS(923), 1,
      anon_sym_LBRACE,
    ACTIONS(925), 1,
      anon_sym_LBRACK,
    ACTIONS(929), 1,
      anon_sym_not,
    ACTIONS(931), 1,
      anon_sym_LPAREN,
    ACTIONS(937), 1,
      sym__string_start,
    STATE(555), 1,
      sym__primary_expression,
    STATE(1287), 1,
      sym__attribute_expression,
    STATE(699), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(917), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(915), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(927), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(696), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [23519] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(797), 1,
      sym__identifier,
    ACTIONS(803), 1,
      anon_sym_AMP,
    ACTIONS(805), 1,
      anon_sym_DOT,
    ACTIONS(807), 1,
      anon_sym_LBRACE,
    ACTIONS(809), 1,
      anon_sym_LBRACK,
    ACTIONS(813), 1,
      anon_sym_not,
    ACTIONS(815), 1,
      anon_sym_LPAREN,
    ACTIONS(823), 1,
      sym__string_start,
    STATE(481), 1,
      sym__primary_expression,
    STATE(1301), 1,
      sym__attribute_expression,
    STATE(534), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(801), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(799), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(811), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(537), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [23586] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(797), 1,
      sym__identifier,
    ACTIONS(803), 1,
      anon_sym_AMP,
    ACTIONS(805), 1,
      anon_sym_DOT,
    ACTIONS(807), 1,
      anon_sym_LBRACE,
    ACTIONS(809), 1,
      anon_sym_LBRACK,
    ACTIONS(813), 1,
      anon_sym_not,
    ACTIONS(815), 1,
      anon_sym_LPAREN,
    ACTIONS(823), 1,
      sym__string_start,
    STATE(480), 1,
      sym__primary_expression,
    STATE(1301), 1,
      sym__attribute_expression,
    STATE(534), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(801), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(799), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(811), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(537), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [23653] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(797), 1,
      sym__identifier,
    ACTIONS(803), 1,
      anon_sym_AMP,
    ACTIONS(805), 1,
      anon_sym_DOT,
    ACTIONS(807), 1,
      anon_sym_LBRACE,
    ACTIONS(809), 1,
      anon_sym_LBRACK,
    ACTIONS(813), 1,
      anon_sym_not,
    ACTIONS(815), 1,
      anon_sym_LPAREN,
    ACTIONS(823), 1,
      sym__string_start,
    STATE(479), 1,
      sym__primary_expression,
    STATE(1301), 1,
      sym__attribute_expression,
    STATE(534), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(801), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(799), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(811), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(537), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [23720] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(797), 1,
      sym__identifier,
    ACTIONS(803), 1,
      anon_sym_AMP,
    ACTIONS(805), 1,
      anon_sym_DOT,
    ACTIONS(807), 1,
      anon_sym_LBRACE,
    ACTIONS(809), 1,
      anon_sym_LBRACK,
    ACTIONS(813), 1,
      anon_sym_not,
    ACTIONS(815), 1,
      anon_sym_LPAREN,
    ACTIONS(823), 1,
      sym__string_start,
    STATE(478), 1,
      sym__primary_expression,
    STATE(1301), 1,
      sym__attribute_expression,
    STATE(534), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(801), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(799), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(811), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(537), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [23787] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(797), 1,
      sym__identifier,
    ACTIONS(803), 1,
      anon_sym_AMP,
    ACTIONS(805), 1,
      anon_sym_DOT,
    ACTIONS(807), 1,
      anon_sym_LBRACE,
    ACTIONS(809), 1,
      anon_sym_LBRACK,
    ACTIONS(813), 1,
      anon_sym_not,
    ACTIONS(815), 1,
      anon_sym_LPAREN,
    ACTIONS(823), 1,
      sym__string_start,
    STATE(477), 1,
      sym__primary_expression,
    STATE(1301), 1,
      sym__attribute_expression,
    STATE(534), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(801), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(799), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(811), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(537), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [23854] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(797), 1,
      sym__identifier,
    ACTIONS(803), 1,
      anon_sym_AMP,
    ACTIONS(805), 1,
      anon_sym_DOT,
    ACTIONS(807), 1,
      anon_sym_LBRACE,
    ACTIONS(809), 1,
      anon_sym_LBRACK,
    ACTIONS(813), 1,
      anon_sym_not,
    ACTIONS(815), 1,
      anon_sym_LPAREN,
    ACTIONS(823), 1,
      sym__string_start,
    STATE(476), 1,
      sym__primary_expression,
    STATE(1301), 1,
      sym__attribute_expression,
    STATE(534), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(801), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(799), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(811), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(537), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [23921] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(797), 1,
      sym__identifier,
    ACTIONS(803), 1,
      anon_sym_AMP,
    ACTIONS(805), 1,
      anon_sym_DOT,
    ACTIONS(807), 1,
      anon_sym_LBRACE,
    ACTIONS(809), 1,
      anon_sym_LBRACK,
    ACTIONS(813), 1,
      anon_sym_not,
    ACTIONS(815), 1,
      anon_sym_LPAREN,
    ACTIONS(823), 1,
      sym__string_start,
    STATE(475), 1,
      sym__primary_expression,
    STATE(1301), 1,
      sym__attribute_expression,
    STATE(534), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(801), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(799), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(811), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(537), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [23988] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(797), 1,
      sym__identifier,
    ACTIONS(803), 1,
      anon_sym_AMP,
    ACTIONS(805), 1,
      anon_sym_DOT,
    ACTIONS(807), 1,
      anon_sym_LBRACE,
    ACTIONS(809), 1,
      anon_sym_LBRACK,
    ACTIONS(813), 1,
      anon_sym_not,
    ACTIONS(815), 1,
      anon_sym_LPAREN,
    ACTIONS(823), 1,
      sym__string_start,
    STATE(474), 1,
      sym__primary_expression,
    STATE(1301), 1,
      sym__attribute_expression,
    STATE(534), 2,
      sym_string_name,
      sym_attribute,
    ACTIONS(801), 3,
      sym_float,
      sym_node_path,
      sym_get_node,
    ACTIONS(799), 4,
      sym_true,
      sym_false,
      sym_null,
      sym_integer,
    ACTIONS(811), 4,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_BANG,
      anon_sym_TILDE,
    STATE(537), 10,
      sym_identifier,
      sym_string,
      sym_binary_operator,
      sym_unary_operator,
      sym_subscript,
      sym_parenthesized_expression,
      sym_dictionary,
      sym_array,
      sym_base_call,
      sym_call,
  [24055] = 16,
    ACTIONS(3), 1,
      sym_comment,
    ACTIONS(797), 1,
      sym__identifier,
    ACTIONS(803), 1,
      anon_sym_AMP,
    ACTIONS(805), 1,
      anon_sym_DOT,
    ACTIONS(807), 1,
      anon_sym_LBRACE,
    ACTIONS(809), 1,
      anon_sym_LBRACK,
    ACTIONS(813), 1,
      anon_sym_not,