#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 798
#define LARGE_STATE_COUNT 2
#define SYMBOL_COUNT 90
#define ALIAS_COUNT 0
#define TOKEN_COUNT 39
#define EXTERNAL_TOKEN_COUNT 3
#define FIELD_COUNT 0
#define MAX_ALIAS_SEQUENCE_LENGTH 7
#define PRODUCTION_ID_COUNT 1

enum ts_symbol_identifiers {
  sym__escape_identity = 1,
  anon_sym_BSLASHt = 2,
  anon_sym_BSLASHr = 3,
  anon_sym_BSLASHn = 4,
  anon_sym_SEMI = 5,
  anon_sym_BSLASH_SEMI = 6,
  aux_sym_variable_token1 = 7,
  anon_sym_DOLLAR = 8,
  anon_sym_LBRACE = 9,
  anon_sym_RBRACE = 10,
  anon_sym_ENV = 11,
  anon_sym_CACHE = 12,
  aux_sym__untrimmed_argument_token1 = 13,
  anon_sym_LPAREN = 14,
  anon_sym_RPAREN = 15,
  anon_sym_DQUOTE = 16,
  aux_sym__quoted_text_token1 = 17,
  aux_sym__unquoted_text_token1 = 18,
  aux_sym_if_command_token1 = 19,
  aux_sym_endwhile_command_token1 = 20,
  sym_if = 21,
  sym_elseif = 22,
  sym_else = 23,
  sym_endif = 24,
  sym_foreach = 25,
  sym_endforeach = 26,
  sym_while = 27,
  sym_endwhile = 28,
  sym_function = 29,
  sym_endfunction = 30,
  sym_macro = 31,
  sym_endmacro = 32,
  sym_block = 33,
  sym_endblock = 34,
  sym_identifier = 35,
  sym_bracket_argument = 36,
  sym_bracket_comment = 37,
  sym_line_comment = 38,
  sym_source_file = 39,
  sym_escape_sequence = 40,
  sym__escape_encoded = 41,
  sym__escape_semicolon = 42,
  sym_variable = 43,
  sym_variable_ref = 44,
  sym_normal_var = 45,
  sym_env_var = 46,
  sym_cache_var = 47,
  sym_argument = 48,
  sym__untrimmed_argument = 49,
  sym__paren_argument = 50,
  sym_quoted_argument = 51,
  sym_quoted_element = 52,
  sym__quoted_text = 53,
  sym_unquoted_argument = 54,
  sym__unquoted_text = 55,
  sym_body = 56,
  sym_argument_list = 57,
  sym_if_command = 58,
  sym_elseif_command = 59,
  sym_else_command = 60,
  sym_endif_command = 61,
  sym_if_condition = 62,
  sym_foreach_command = 63,
  sym_endforeach_command = 64,
  sym_foreach_loop = 65,
  sym_while_command = 66,
  sym_endwhile_command = 67,
  sym_while_loop = 68,
  sym_function_command = 69,
  sym_endfunction_command = 70,
  sym_function_def = 71,
  sym_macro_command = 72,
  sym_endmacro_command = 73,
  sym_macro_def = 74,
  sym_block_command = 75,
  sym_endblock_command = 76,
  sym_block_def = 77,
  sym_normal_command = 78,
  sym__command_invocation = 79,
  sym__untrimmed_command_invocation = 80,
  aux_sym_source_file_repeat1 = 81,
  aux_sym_variable_repeat1 = 82,
  aux_sym__paren_argument_repeat1 = 83,
  aux_sym_quoted_element_repeat1 = 84,
  aux_sym__quoted_text_repeat1 = 85,
  aux_sym_unquoted_argument_repeat1 = 86,
  aux_sym__unquoted_text_repeat1 = 87,
  aux_sym_if_command_repeat1 = 88,
  aux_sym_if_condition_repeat1 = 89,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym__escape_identity] = "_escape_identity",
  [anon_sym_BSLASHt] = "\\t",
  [anon_sym_BSLASHr] = "\\r",
  [anon_sym_BSLASHn] = "\\n",
  [anon_sym_SEMI] = ";",
  [anon_sym_BSLASH_SEMI] = "\\;",
  [aux_sym_variable_token1] = "variable_token1",
  [anon_sym_DOLLAR] = "$",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_ENV] = "ENV",
  [anon_sym_CACHE] = "CACHE",
  [aux_sym__untrimmed_argument_token1] = "_untrimmed_argument_token1",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym__quoted_text_token1] = "_quoted_text_token1",
  [aux_sym__unquoted_text_token1] = "_unquoted_text_token1",
  [aux_sym_if_command_token1] = "if_command_token1",
  [aux_sym_endwhile_command_token1] = "endwhile_command_token1",
  [sym_if] = "if",
  [sym_elseif] = "elseif",
  [sym_else] = "else",
  [sym_endif] = "endif",
  [sym_foreach] = "foreach",
  [sym_endforeach] = "endforeach",
  [sym_while] = "while",
  [sym_endwhile] = "endwhile",
  [sym_function] = "function",
  [sym_endfunction] = "endfunction",
  [sym_macro] = "macro",
  [sym_endmacro] = "endmacro",
  [sym_block] = "block",
  [sym_endblock] = "endblock",
  [sym_identifier] = "identifier",
  [sym_bracket_argument] = "bracket_argument",
  [sym_bracket_comment] = "bracket_comment",
  [sym_line_comment] = "line_comment",
  [sym_source_file] = "source_file",
  [sym_escape_sequence] = "escape_sequence",
  [sym__escape_encoded] = "_escape_encoded",
  [sym__escape_semicolon] = "_escape_semicolon",
  [sym_variable] = "variable",
  [sym_variable_ref] = "variable_ref",
  [sym_normal_var] = "normal_var",
  [sym_env_var] = "env_var",
  [sym_cache_var] = "cache_var",
  [sym_argument] = "argument",
  [sym__untrimmed_argument] = "_untrimmed_argument",
  [sym__paren_argument] = "_paren_argument",
  [sym_quoted_argument] = "quoted_argument",
  [sym_quoted_element] = "quoted_element",
  [sym__quoted_text] = "_quoted_text",
  [sym_unquoted_argument] = "unquoted_argument",
  [sym__unquoted_text] = "_unquoted_text",
  [sym_body] = "body",
  [sym_argument_list] = "argument_list",
  [sym_if_command] = "if_command",
  [sym_elseif_command] = "elseif_command",
  [sym_else_command] = "else_command",
  [sym_endif_command] = "endif_command",
  [sym_if_condition] = "if_condition",
  [sym_foreach_command] = "foreach_command",
  [sym_endforeach_command] = "endforeach_command",
  [sym_foreach_loop] = "foreach_loop",
  [sym_while_command] = "while_command",
  [sym_endwhile_command] = "endwhile_command",
  [sym_while_loop] = "while_loop",
  [sym_function_command] = "function_command",
  [sym_endfunction_command] = "endfunction_command",
  [sym_function_def] = "function_def",
  [sym_macro_command] = "macro_command",
  [sym_endmacro_command] = "endmacro_command",
  [sym_macro_def] = "macro_def",
  [sym_block_command] = "block_command",
  [sym_endblock_command] = "endblock_command",
  [sym_block_def] = "block_def",
  [sym_normal_command] = "normal_command",
  [sym__command_invocation] = "_command_invocation",
  [sym__untrimmed_command_invocation] = "_untrimmed_command_invocation",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_variable_repeat1] = "variable_repeat1",
  [aux_sym__paren_argument_repeat1] = "_paren_argument_repeat1",
  [aux_sym_quoted_element_repeat1] = "quoted_element_repeat1",
  [aux_sym__quoted_text_repeat1] = "_quoted_text_repeat1",
  [aux_sym_unquoted_argument_repeat1] = "unquoted_argument_repeat1",
  [aux_sym__unquoted_text_repeat1] = "_unquoted_text_repeat1",
  [aux_sym_if_command_repeat1] = "if_command_repeat1",
  [aux_sym_if_condition_repeat1] = "if_condition_repeat1",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym__escape_identity] = sym__escape_identity,
  [anon_sym_BSLASHt] = anon_sym_BSLASHt,
  [anon_sym_BSLASHr] = anon_sym_BSLASHr,
  [anon_sym_BSLASHn] = anon_sym_BSLASHn,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym_BSLASH_SEMI] = anon_sym_BSLASH_SEMI,
  [aux_sym_variable_token1] = aux_sym_variable_token1,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_ENV] = anon_sym_ENV,
  [anon_sym_CACHE] = anon_sym_CACHE,
  [aux_sym__untrimmed_argument_token1] = aux_sym__untrimmed_argument_token1,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym__quoted_text_token1] = aux_sym__quoted_text_token1,
  [aux_sym__unquoted_text_token1] = aux_sym__unquoted_text_token1,
  [aux_sym_if_command_token1] = aux_sym_if_command_token1,
  [aux_sym_endwhile_command_token1] = aux_sym_endwhile_command_token1,
  [sym_if] = sym_if,
  [sym_elseif] = sym_elseif,
  [sym_else] = sym_else,
  [sym_endif] = sym_endif,
  [sym_foreach] = sym_foreach,
  [sym_endforeach] = sym_endforeach,
  [sym_while] = sym_while,
  [sym_endwhile] = sym_endwhile,
  [sym_function] = sym_function,
  [sym_endfunction] = sym_endfunction,
  [sym_macro] = sym_macro,
  [sym_endmacro] = sym_endmacro,
  [sym_block] = sym_block,
  [sym_endblock] = sym_endblock,
  [sym_identifier] = sym_identifier,
  [sym_bracket_argument] = sym_bracket_argument,
  [sym_bracket_comment] = sym_bracket_comment,
  [sym_line_comment] = sym_line_comment,
  [sym_source_file] = sym_source_file,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym__escape_encoded] = sym__escape_encoded,
  [sym__escape_semicolon] = sym__escape_semicolon,
  [sym_variable] = sym_variable,
  [sym_variable_ref] = sym_variable_ref,
  [sym_normal_var] = sym_normal_var,
  [sym_env_var] = sym_env_var,
  [sym_cache_var] = sym_cache_var,
  [sym_argument] = sym_argument,
  [sym__untrimmed_argument] = sym__untrimmed_argument,
  [sym__paren_argument] = sym__paren_argument,
  [sym_quoted_argument] = sym_quoted_argument,
  [sym_quoted_element] = sym_quoted_element,
  [sym__quoted_text] = sym__quoted_text,
  [sym_unquoted_argument] = sym_unquoted_argument,
  [sym__unquoted_text] = sym__unquoted_text,
  [sym_body] = sym_body,
  [sym_argument_list] = sym_argument_list,
  [sym_if_command] = sym_if_command,
  [sym_elseif_command] = sym_elseif_command,
  [sym_else_command] = sym_else_command,
  [sym_endif_command] = sym_endif_command,
  [sym_if_condition] = sym_if_condition,
  [sym_foreach_command] = sym_foreach_command,
  [sym_endforeach_command] = sym_endforeach_command,
  [sym_foreach_loop] = sym_foreach_loop,
  [sym_while_command] = sym_while_command,
  [sym_endwhile_command] = sym_endwhile_command,
  [sym_while_loop] = sym_while_loop,
  [sym_function_command] = sym_function_command,
  [sym_endfunction_command] = sym_endfunction_command,
  [sym_function_def] = sym_function_def,
  [sym_macro_command] = sym_macro_command,
  [sym_endmacro_command] = sym_endmacro_command,
  [sym_macro_def] = sym_macro_def,
  [sym_block_command] = sym_block_command,
  [sym_endblock_command] = sym_endblock_command,
  [sym_block_def] = sym_block_def,
  [sym_normal_command] = sym_normal_command,
  [sym__command_invocation] = sym__command_invocation,
  [sym__untrimmed_command_invocation] = sym__untrimmed_command_invocation,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_variable_repeat1] = aux_sym_variable_repeat1,
  [aux_sym__paren_argument_repeat1] = aux_sym__paren_argument_repeat1,
  [aux_sym_quoted_element_repeat1] = aux_sym_quoted_element_repeat1,
  [aux_sym__quoted_text_repeat1] = aux_sym__quoted_text_repeat1,
  [aux_sym_unquoted_argument_repeat1] = aux_sym_unquoted_argument_repeat1,
  [aux_sym__unquoted_text_repeat1] = aux_sym__unquoted_text_repeat1,
  [aux_sym_if_command_repeat1] = aux_sym_if_command_repeat1,
  [aux_sym_if_condition_repeat1] = aux_sym_if_condition_repeat1,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym__escape_identity] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_BSLASHt] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASHn] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BSLASH_SEMI] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_variable_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ENV] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CACHE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__untrimmed_argument_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__quoted_text_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__unquoted_text_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_command_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_endwhile_command_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_if] = {
    .visible = true,
    .named = true,
  },
  [sym_elseif] = {
    .visible = true,
    .named = true,
  },
  [sym_else] = {
    .visible = true,
    .named = true,
  },
  [sym_endif] = {
    .visible = true,
    .named = true,
  },
  [sym_foreach] = {
    .visible = true,
    .named = true,
  },
  [sym_endforeach] = {
    .visible = true,
    .named = true,
  },
  [sym_while] = {
    .visible = true,
    .named = true,
  },
  [sym_endwhile] = {
    .visible = true,
    .named = true,
  },
  [sym_function] = {
    .visible = true,
    .named = true,
  },
  [sym_endfunction] = {
    .visible = true,
    .named = true,
  },
  [sym_macro] = {
    .visible = true,
    .named = true,
  },
  [sym_endmacro] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym_endblock] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym_bracket_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_bracket_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_line_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym__escape_encoded] = {
    .visible = false,
    .named = true,
  },
  [sym__escape_semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym_variable] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_ref] = {
    .visible = true,
    .named = true,
  },
  [sym_normal_var] = {
    .visible = true,
    .named = true,
  },
  [sym_env_var] = {
    .visible = true,
    .named = true,
  },
  [sym_cache_var] = {
    .visible = true,
    .named = true,
  },
  [sym_argument] = {
    .visible = true,
    .named = true,
  },
  [sym__untrimmed_argument] = {
    .visible = false,
    .named = true,
  },
  [sym__paren_argument] = {
    .visible = false,
    .named = true,
  },
  [sym_quoted_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_quoted_element] = {
    .visible = true,
    .named = true,
  },
  [sym__quoted_text] = {
    .visible = false,
    .named = true,
  },
  [sym_unquoted_argument] = {
    .visible = true,
    .named = true,
  },
  [sym__unquoted_text] = {
    .visible = false,
    .named = true,
  },
  [sym_body] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_list] = {
    .visible = true,
    .named = true,
  },
  [sym_if_command] = {
    .visible = true,
    .named = true,
  },
  [sym_elseif_command] = {
    .visible = true,
    .named = true,
  },
  [sym_else_command] = {
    .visible = true,
    .named = true,
  },
  [sym_endif_command] = {
    .visible = true,
    .named = true,
  },
  [sym_if_condition] = {
    .visible = true,
    .named = true,
  },
  [sym_foreach_command] = {
    .visible = true,
    .named = true,
  },
  [sym_endforeach_command] = {
    .visible = true,
    .named = true,
  },
  [sym_foreach_loop] = {
    .visible = true,
    .named = true,
  },
  [sym_while_command] = {
    .visible = true,
    .named = true,
  },
  [sym_endwhile_command] = {
    .visible = true,
    .named = true,
  },
  [sym_while_loop] = {
    .visible = true,
    .named = true,
  },
  [sym_function_command] = {
    .visible = true,
    .named = true,
  },
  [sym_endfunction_command] = {
    .visible = true,
    .named = true,
  },
  [sym_function_def] = {
    .visible = true,
    .named = true,
  },
  [sym_macro_command] = {
    .visible = true,
    .named = true,
  },
  [sym_endmacro_command] = {
    .visible = true,
    .named = true,
  },
  [sym_macro_def] = {
    .visible = true,
    .named = true,
  },
  [sym_block_command] = {
    .visible = true,
    .named = true,
  },
  [sym_endblock_command] = {
    .visible = true,
    .named = true,
  },
  [sym_block_def] = {
    .visible = true,
    .named = true,
  },
  [sym_normal_command] = {
    .visible = true,
    .named = true,
  },
  [sym__command_invocation] = {
    .visible = false,
    .named = true,
  },
  [sym__untrimmed_command_invocation] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__paren_argument_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_quoted_element_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__quoted_text_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_unquoted_argument_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__unquoted_text_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_command_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_condition_repeat1] = {
    .visible = false,
    .named = false,
  },
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
};

static const uint16_t ts_non_terminal_alias_map[] = {
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 2,
  [5] = 3,
  [6] = 2,
  [7] = 3,
  [8] = 2,
  [9] = 3,
  [10] = 3,
  [11] = 2,
  [12] = 3,
  [13] = 2,
  [14] = 2,
  [15] = 3,
  [16] = 16,
  [17] = 17,
  [18] = 18,
  [19] = 19,
  [20] = 18,
  [21] = 21,
  [22] = 17,
  [23] = 17,
  [24] = 19,
  [25] = 25,
  [26] = 25,
  [27] = 27,
  [28] = 28,
  [29] = 28,
  [30] = 30,
  [31] = 18,
  [32] = 32,
  [33] = 17,
  [34] = 34,
  [35] = 27,
  [36] = 19,
  [37] = 21,
  [38] = 17,
  [39] = 25,
  [40] = 28,
  [41] = 30,
  [42] = 34,
  [43] = 30,
  [44] = 18,
  [45] = 32,
  [46] = 32,
  [47] = 34,
  [48] = 18,
  [49] = 30,
  [50] = 18,
  [51] = 27,
  [52] = 19,
  [53] = 32,
  [54] = 34,
  [55] = 34,
  [56] = 28,
  [57] = 32,
  [58] = 27,
  [59] = 19,
  [60] = 21,
  [61] = 25,
  [62] = 30,
  [63] = 27,
  [64] = 64,
  [65] = 21,
  [66] = 25,
  [67] = 17,
  [68] = 25,
  [69] = 28,
  [70] = 30,
  [71] = 71,
  [72] = 17,
  [73] = 28,
  [74] = 18,
  [75] = 34,
  [76] = 27,
  [77] = 25,
  [78] = 28,
  [79] = 19,
  [80] = 21,
  [81] = 21,
  [82] = 19,
  [83] = 27,
  [84] = 30,
  [85] = 34,
  [86] = 32,
  [87] = 32,
  [88] = 21,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 101,
  [102] = 102,
  [103] = 103,
  [104] = 104,
  [105] = 105,
  [106] = 106,
  [107] = 107,
  [108] = 108,
  [109] = 109,
  [110] = 110,
  [111] = 110,
  [112] = 108,
  [113] = 113,
  [114] = 109,
  [115] = 115,
  [116] = 116,
  [117] = 113,
  [118] = 110,
  [119] = 110,
  [120] = 113,
  [121] = 107,
  [122] = 113,
  [123] = 107,
  [124] = 115,
  [125] = 115,
  [126] = 116,
  [127] = 108,
  [128] = 109,
  [129] = 115,
  [130] = 108,
  [131] = 110,
  [132] = 107,
  [133] = 107,
  [134] = 116,
  [135] = 113,
  [136] = 109,
  [137] = 113,
  [138] = 107,
  [139] = 115,
  [140] = 108,
  [141] = 116,
  [142] = 110,
  [143] = 113,
  [144] = 109,
  [145] = 115,
  [146] = 109,
  [147] = 116,
  [148] = 115,
  [149] = 116,
  [150] = 109,
  [151] = 107,
  [152] = 110,
  [153] = 116,
  [154] = 108,
  [155] = 155,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 159,
  [160] = 159,
  [161] = 159,
  [162] = 158,
  [163] = 159,
  [164] = 158,
  [165] = 159,
  [166] = 159,
  [167] = 158,
  [168] = 158,
  [169] = 159,
  [170] = 158,
  [171] = 158,
  [172] = 172,
  [173] = 172,
  [174] = 174,
  [175] = 172,
  [176] = 174,
  [177] = 172,
  [178] = 172,
  [179] = 172,
  [180] = 174,
  [181] = 172,
  [182] = 174,
  [183] = 174,
  [184] = 174,
  [185] = 174,
  [186] = 186,
  [187] = 186,
  [188] = 186,
  [189] = 189,
  [190] = 156,
  [191] = 156,
  [192] = 192,
  [193] = 157,
  [194] = 157,
  [195] = 195,
  [196] = 196,
  [197] = 197,
  [198] = 198,
  [199] = 196,
  [200] = 200,
  [201] = 198,
  [202] = 198,
  [203] = 197,
  [204] = 196,
  [205] = 205,
  [206] = 197,
  [207] = 198,
  [208] = 196,
  [209] = 197,
  [210] = 198,
  [211] = 197,
  [212] = 196,
  [213] = 213,
  [214] = 214,
  [215] = 215,
  [216] = 216,
  [217] = 217,
  [218] = 218,
  [219] = 219,
  [220] = 220,
  [221] = 221,
  [222] = 222,
  [223] = 223,
  [224] = 224,
  [225] = 225,
  [226] = 226,
  [227] = 227,
  [228] = 228,
  [229] = 229,
  [230] = 230,
  [231] = 231,
  [232] = 232,
  [233] = 233,
  [234] = 234,
  [235] = 235,
  [236] = 236,
  [237] = 237,
  [238] = 238,
  [239] = 239,
  [240] = 240,
  [241] = 241,
  [242] = 242,
  [243] = 243,
  [244] = 244,
  [245] = 245,
  [246] = 246,
  [247] = 247,
  [248] = 248,
  [249] = 249,
  [250] = 250,
  [251] = 251,
  [252] = 252,
  [253] = 253,
  [254] = 254,
  [255] = 255,
  [256] = 256,
  [257] = 257,
  [258] = 258,
  [259] = 259,
  [260] = 260,
  [261] = 195,
  [262] = 195,
  [263] = 255,
  [264] = 243,
  [265] = 254,
  [266] = 225,
  [267] = 250,
  [268] = 233,
  [269] = 244,
  [270] = 252,
  [271] = 226,
  [272] = 224,
  [273] = 228,
  [274] = 229,
  [275] = 232,
  [276] = 234,
  [277] = 232,
  [278] = 233,
  [279] = 234,
  [280] = 235,
  [281] = 236,
  [282] = 237,
  [283] = 249,
  [284] = 236,
  [285] = 229,
  [286] = 247,
  [287] = 245,
  [288] = 242,
  [289] = 241,
  [290] = 240,
  [291] = 238,
  [292] = 231,
  [293] = 227,
  [294] = 246,
  [295] = 239,
  [296] = 243,
  [297] = 257,
  [298] = 255,
  [299] = 254,
  [300] = 225,
  [301] = 250,
  [302] = 237,
  [303] = 244,
  [304] = 252,
  [305] = 226,
  [306] = 224,
  [307] = 228,
  [308] = 229,
  [309] = 249,
  [310] = 228,
  [311] = 232,
  [312] = 233,
  [313] = 234,
  [314] = 235,
  [315] = 236,
  [316] = 237,
  [317] = 249,
  [318] = 224,
  [319] = 257,
  [320] = 226,
  [321] = 252,
  [322] = 247,
  [323] = 245,
  [324] = 242,
  [325] = 241,
  [326] = 240,
  [327] = 238,
  [328] = 231,
  [329] = 227,
  [330] = 246,
  [331] = 239,
  [332] = 243,
  [333] = 257,
  [334] = 255,
  [335] = 254,
  [336] = 225,
  [337] = 250,
  [338] = 244,
  [339] = 244,
  [340] = 252,
  [341] = 226,
  [342] = 224,
  [343] = 228,
  [344] = 229,
  [345] = 247,
  [346] = 255,
  [347] = 232,
  [348] = 233,
  [349] = 234,
  [350] = 235,
  [351] = 236,
  [352] = 237,
  [353] = 249,
  [354] = 243,
  [355] = 239,
  [356] = 247,
  [357] = 245,
  [358] = 242,
  [359] = 241,
  [360] = 240,
  [361] = 238,
  [362] = 231,
  [363] = 227,
  [364] = 246,
  [365] = 239,
  [366] = 235,
  [367] = 257,
  [368] = 255,
  [369] = 254,
  [370] = 225,
  [371] = 250,
  [372] = 244,
  [373] = 252,
  [374] = 226,
  [375] = 224,
  [376] = 228,
  [377] = 229,
  [378] = 232,
  [379] = 233,
  [380] = 234,
  [381] = 235,
  [382] = 236,
  [383] = 237,
  [384] = 249,
  [385] = 227,
  [386] = 247,
  [387] = 245,
  [388] = 242,
  [389] = 241,
  [390] = 240,
  [391] = 238,
  [392] = 231,
  [393] = 227,
  [394] = 246,
  [395] = 239,
  [396] = 243,
  [397] = 257,
  [398] = 246,
  [399] = 254,
  [400] = 225,
  [401] = 250,
  [402] = 244,
  [403] = 252,
  [404] = 226,
  [405] = 224,
  [406] = 228,
  [407] = 229,
  [408] = 232,
  [409] = 233,
  [410] = 234,
  [411] = 235,
  [412] = 236,
  [413] = 237,
  [414] = 225,
  [415] = 250,
  [416] = 231,
  [417] = 254,
  [418] = 255,
  [419] = 227,
  [420] = 257,
  [421] = 240,
  [422] = 231,
  [423] = 246,
  [424] = 238,
  [425] = 240,
  [426] = 243,
  [427] = 238,
  [428] = 245,
  [429] = 241,
  [430] = 242,
  [431] = 249,
  [432] = 245,
  [433] = 247,
  [434] = 242,
  [435] = 241,
  [436] = 239,
  [437] = 213,
  [438] = 213,
  [439] = 439,
  [440] = 440,
  [441] = 441,
  [442] = 442,
  [443] = 443,
  [444] = 444,
  [445] = 445,
  [446] = 446,
  [447] = 447,
  [448] = 448,
  [449] = 449,
  [450] = 216,
  [451] = 219,
  [452] = 214,
  [453] = 223,
  [454] = 214,
  [455] = 216,
  [456] = 215,
  [457] = 223,
  [458] = 219,
  [459] = 219,
  [460] = 214,
  [461] = 216,
  [462] = 215,
  [463] = 215,
  [464] = 223,
  [465] = 215,
  [466] = 219,
  [467] = 214,
  [468] = 216,
  [469] = 223,
  [470] = 470,
  [471] = 471,
  [472] = 472,
  [473] = 471,
  [474] = 474,
  [475] = 475,
  [476] = 474,
  [477] = 477,
  [478] = 478,
  [479] = 479,
  [480] = 471,
  [481] = 481,
  [482] = 482,
  [483] = 483,
  [484] = 470,
  [485] = 485,
  [486] = 472,
  [487] = 470,
  [488] = 488,
  [489] = 489,
  [490] = 490,
  [491] = 491,
  [492] = 492,
  [493] = 493,
  [494] = 471,
  [495] = 474,
  [496] = 488,
  [497] = 489,
  [498] = 490,
  [499] = 491,
  [500] = 492,
  [501] = 493,
  [502] = 471,
  [503] = 474,
  [504] = 481,
  [505] = 481,
  [506] = 506,
  [507] = 485,
  [508] = 482,
  [509] = 509,
  [510] = 510,
  [511] = 489,
  [512] = 483,
  [513] = 485,
  [514] = 472,
  [515] = 470,
  [516] = 516,
  [517] = 470,
  [518] = 488,
  [519] = 481,
  [520] = 489,
  [521] = 493,
  [522] = 490,
  [523] = 491,
  [524] = 492,
  [525] = 493,
  [526] = 471,
  [527] = 474,
  [528] = 481,
  [529] = 492,
  [530] = 491,
  [531] = 482,
  [532] = 483,
  [533] = 485,
  [534] = 490,
  [535] = 481,
  [536] = 488,
  [537] = 482,
  [538] = 483,
  [539] = 474,
  [540] = 472,
  [541] = 470,
  [542] = 542,
  [543] = 488,
  [544] = 489,
  [545] = 490,
  [546] = 489,
  [547] = 472,
  [548] = 471,
  [549] = 488,
  [550] = 491,
  [551] = 492,
  [552] = 493,
  [553] = 485,
  [554] = 485,
  [555] = 493,
  [556] = 474,
  [557] = 557,
  [558] = 493,
  [559] = 472,
  [560] = 560,
  [561] = 492,
  [562] = 483,
  [563] = 481,
  [564] = 491,
  [565] = 482,
  [566] = 482,
  [567] = 483,
  [568] = 485,
  [569] = 472,
  [570] = 470,
  [571] = 571,
  [572] = 572,
  [573] = 483,
  [574] = 492,
  [575] = 482,
  [576] = 491,
  [577] = 490,
  [578] = 578,
  [579] = 579,
  [580] = 580,
  [581] = 488,
  [582] = 489,
  [583] = 583,
  [584] = 584,
  [585] = 490,
  [586] = 586,
  [587] = 586,
  [588] = 588,
  [589] = 589,
  [590] = 590,
  [591] = 591,
  [592] = 588,
  [593] = 593,
  [594] = 594,
  [595] = 588,
  [596] = 590,
  [597] = 588,
  [598] = 586,
  [599] = 589,
  [600] = 590,
  [601] = 591,
  [602] = 593,
  [603] = 594,
  [604] = 594,
  [605] = 586,
  [606] = 588,
  [607] = 593,
  [608] = 594,
  [609] = 593,
  [610] = 591,
  [611] = 590,
  [612] = 589,
  [613] = 591,
  [614] = 586,
  [615] = 589,
  [616] = 589,
  [617] = 590,
  [618] = 591,
  [619] = 589,
  [620] = 586,
  [621] = 590,
  [622] = 590,
  [623] = 591,
  [624] = 591,
  [625] = 593,
  [626] = 594,
  [627] = 588,
  [628] = 593,
  [629] = 593,
  [630] = 594,
  [631] = 594,
  [632] = 588,
  [633] = 586,
  [634] = 589,
  [635] = 635,
  [636] = 636,
  [637] = 637,
  [638] = 638,
  [639] = 635,
  [640] = 640,
  [641] = 641,
  [642] = 642,
  [643] = 643,
  [644] = 644,
  [645] = 641,
  [646] = 646,
  [647] = 644,
  [648] = 648,
  [649] = 649,
  [650] = 650,
  [651] = 651,
  [652] = 652,
  [653] = 653,
  [654] = 654,
  [655] = 655,
  [656] = 656,
  [657] = 636,
  [658] = 637,
  [659] = 638,
  [660] = 635,
  [661] = 640,
  [662] = 662,
  [663] = 663,
  [664] = 664,
  [665] = 665,
  [666] = 666,
  [667] = 667,
  [668] = 668,
  [669] = 669,
  [670] = 642,
  [671] = 656,
  [672] = 655,
  [673] = 653,
  [674] = 652,
  [675] = 650,
  [676] = 649,
  [677] = 641,
  [678] = 644,
  [679] = 679,
  [680] = 680,
  [681] = 640,
  [682] = 635,
  [683] = 638,
  [684] = 637,
  [685] = 636,
  [686] = 668,
  [687] = 669,
  [688] = 656,
  [689] = 689,
  [690] = 679,
  [691] = 691,
  [692] = 655,
  [693] = 653,
  [694] = 649,
  [695] = 652,
  [696] = 650,
  [697] = 649,
  [698] = 698,
  [699] = 650,
  [700] = 652,
  [701] = 641,
  [702] = 644,
  [703] = 698,
  [704] = 653,
  [705] = 642,
  [706] = 655,
  [707] = 679,
  [708] = 642,
  [709] = 640,
  [710] = 668,
  [711] = 669,
  [712] = 638,
  [713] = 713,
  [714] = 714,
  [715] = 715,
  [716] = 716,
  [717] = 717,
  [718] = 637,
  [719] = 636,
  [720] = 656,
  [721] = 689,
  [722] = 679,
  [723] = 689,
  [724] = 655,
  [725] = 653,
  [726] = 652,
  [727] = 656,
  [728] = 650,
  [729] = 649,
  [730] = 698,
  [731] = 668,
  [732] = 732,
  [733] = 636,
  [734] = 668,
  [735] = 669,
  [736] = 641,
  [737] = 644,
  [738] = 637,
  [739] = 642,
  [740] = 638,
  [741] = 635,
  [742] = 640,
  [743] = 635,
  [744] = 638,
  [745] = 637,
  [746] = 636,
  [747] = 656,
  [748] = 689,
  [749] = 679,
  [750] = 669,
  [751] = 655,
  [752] = 653,
  [753] = 652,
  [754] = 650,
  [755] = 668,
  [756] = 669,
  [757] = 649,
  [758] = 698,
  [759] = 640,
  [760] = 222,
  [761] = 641,
  [762] = 644,
  [763] = 665,
  [764] = 220,
  [765] = 642,
  [766] = 218,
  [767] = 640,
  [768] = 635,
  [769] = 638,
  [770] = 637,
  [771] = 636,
  [772] = 656,
  [773] = 689,
  [774] = 218,
  [775] = 655,
  [776] = 668,
  [777] = 669,
  [778] = 667,
  [779] = 666,
  [780] = 653,
  [781] = 222,
  [782] = 667,
  [783] = 666,
  [784] = 652,
  [785] = 650,
  [786] = 667,
  [787] = 666,
  [788] = 649,
  [789] = 789,
  [790] = 667,
  [791] = 666,
  [792] = 698,
  [793] = 641,
  [794] = 644,
  [795] = 665,
  [796] = 642,
  [797] = 220,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(20);
      ADVANCE_MAP(
        '"', 36,
        '$', 28,
        '(', 34,
        ')', 35,
        ';', 25,
        'C', 41,
        'E', 42,
        '\\', 8,
        '{', 29,
        '\t', 33,
        ' ', 33,
      );
      if (('\n' <= lookahead && lookahead <= '\r')) ADVANCE(33);
      if (lookahead != 0 &&
          (lookahead < '"' || '$' < lookahead)) ADVANCE(40);
      END_STATE();
    case 1:
      ADVANCE_MAP(
        '"', 36,
        '$', 28,
        '(', 34,
        ')', 35,
        ';', 25,
        'C', 41,
        'E', 42,
        '\\', 8,
        '{', 29,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(33);
      if (lookahead != 0 &&
          (lookahead < '"' || '$' < lookahead)) ADVANCE(40);
      END_STATE();
    case 2:
      if (lookahead == '"') ADVANCE(36);
      if (lookahead == '$') ADVANCE(28);
      if (lookahead == '(') ADVANCE(34);
      if (lookahead == ')') ADVANCE(35);
      if (lookahead == ';') ADVANCE(25);
      if (lookahead == '\\') ADVANCE(8);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(33);
      if (lookahead != 0 &&
          (lookahead < '"' || '$' < lookahead)) ADVANCE(40);
      END_STATE();
    case 3:
      if (lookahead == '"') ADVANCE(36);
      if (lookahead == '$') ADVANCE(28);
      if (lookahead == ')') ADVANCE(35);
      if (lookahead == ';') ADVANCE(25);
      if (lookahead == '\\') ADVANCE(8);
      if (lookahead != 0 &&
          (lookahead < '"' || '$' < lookahead) &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(40);
      END_STATE();
    case 4:
      if (lookahead == '"') ADVANCE(36);
      if (lookahead == '$') ADVANCE(28);
      if (lookahead == ';') ADVANCE(25);
      if (lookahead == 'C') ADVANCE(38);
      if (lookahead == 'E') ADVANCE(39);
      if (lookahead == '\\') ADVANCE(8);
      if (lookahead == '{') ADVANCE(29);
      if (lookahead != 0) ADVANCE(37);
      END_STATE();
    case 5:
      if (lookahead == '"') ADVANCE(36);
      if (lookahead == '$') ADVANCE(28);
      if (lookahead == ';') ADVANCE(25);
      if (lookahead == '\\') ADVANCE(8);
      if (lookahead != 0) ADVANCE(37);
      END_STATE();
    case 6:
      if (lookahead == '$') ADVANCE(28);
      if (lookahead == '(') ADVANCE(34);
      if (lookahead == ';') ADVANCE(25);
      if (lookahead == '\\') ADVANCE(8);
      if (lookahead == '}') ADVANCE(30);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(44);
      if (lookahead == '+' ||
          ('-' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(27);
      END_STATE();
    case 7:
      if (lookahead == '$') ADVANCE(28);
      if (lookahead == ')') ADVANCE(35);
      if (lookahead == ';') ADVANCE(25);
      if (lookahead == 'C') ADVANCE(41);
      if (lookahead == 'E') ADVANCE(42);
      if (lookahead == '\\') ADVANCE(8);
      if (lookahead == '{') ADVANCE(29);
      if (lookahead != 0 &&
          (lookahead < '"' || '$' < lookahead) &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(40);
      END_STATE();
    case 8:
      if (lookahead == ';') ADVANCE(26);
      if (lookahead == 'n') ADVANCE(24);
      if (lookahead == 'r') ADVANCE(23);
      if (lookahead == 't') ADVANCE(22);
      if (lookahead != 0 &&
          (lookahead < '0' || '9' < lookahead) &&
          (lookahead < 'A' || 'Z' < lookahead) &&
          (lookahead < 'a' || 'z' < lookahead)) ADVANCE(21);
      END_STATE();
    case 9:
      if (lookahead == 'C') ADVANCE(11);
      END_STATE();
    case 10:
      if (lookahead == 'E') ADVANCE(32);
      END_STATE();
    case 11:
      if (lookahead == 'H') ADVANCE(10);
      END_STATE();
    case 12:
      if (lookahead == 'V') ADVANCE(31);
      END_STATE();
    case 13:
      ADVANCE_MAP(
        'B', 103,
        'b', 103,
        'E', 104,
        'e', 104,
        'F', 118,
        'f', 118,
        'I', 87,
        'i', 87,
        'M', 63,
        'm', 63,
        'W', 92,
        'w', 92,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(33);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 14:
      ADVANCE_MAP(
        'B', 103,
        'b', 103,
        'E', 111,
        'e', 111,
        'F', 118,
        'f', 118,
        'I', 87,
        'i', 87,
        'M', 63,
        'm', 63,
        'W', 92,
        'w', 92,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(33);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 15:
      ADVANCE_MAP(
        'B', 103,
        'b', 103,
        'E', 113,
        'e', 113,
        'F', 118,
        'f', 118,
        'I', 87,
        'i', 87,
        'M', 63,
        'm', 63,
        'W', 92,
        'w', 92,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(33);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 16:
      ADVANCE_MAP(
        'B', 103,
        'b', 103,
        'E', 114,
        'e', 114,
        'F', 118,
        'f', 118,
        'I', 87,
        'i', 87,
        'M', 63,
        'm', 63,
        'W', 92,
        'w', 92,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(33);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 17:
      ADVANCE_MAP(
        'B', 103,
        'b', 103,
        'E', 115,
        'e', 115,
        'F', 118,
        'f', 118,
        'I', 87,
        'i', 87,
        'M', 63,
        'm', 63,
        'W', 92,
        'w', 92,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(33);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 18:
      ADVANCE_MAP(
        'B', 103,
        'b', 103,
        'E', 116,
        'e', 116,
        'F', 118,
        'f', 118,
        'I', 87,
        'i', 87,
        'M', 63,
        'm', 63,
        'W', 92,
        'w', 92,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(33);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 19:
      if (eof) ADVANCE(20);
      ADVANCE_MAP(
        '}', 30,
        'B', 103,
        'b', 103,
        'F', 118,
        'f', 118,
        'I', 87,
        'i', 87,
        'M', 63,
        'm', 63,
        'W', 92,
        'w', 92,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(33);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(sym__escape_identity);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(anon_sym_BSLASHt);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(anon_sym_BSLASHr);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(anon_sym_BSLASHn);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_BSLASH_SEMI);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(aux_sym_variable_token1);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      END_STATE();
    case 29:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 30:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 31:
      ACCEPT_TOKEN(anon_sym_ENV);
      END_STATE();
    case 32:
      ACCEPT_TOKEN(anon_sym_CACHE);
      END_STATE();
    case 33:
      ACCEPT_TOKEN(aux_sym__untrimmed_argument_token1);
      END_STATE();
    case 34:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 36:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 37:
      ACCEPT_TOKEN(aux_sym__quoted_text_token1);
      END_STATE();
    case 38:
      ACCEPT_TOKEN(aux_sym__quoted_text_token1);
      if (lookahead == 'A') ADVANCE(9);
      END_STATE();
    case 39:
      ACCEPT_TOKEN(aux_sym__quoted_text_token1);
      if (lookahead == 'N') ADVANCE(12);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(aux_sym__unquoted_text_token1);
      END_STATE();
    case 41:
      ACCEPT_TOKEN(aux_sym__unquoted_text_token1);
      if (lookahead == 'A') ADVANCE(9);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(aux_sym__unquoted_text_token1);
      if (lookahead == 'N') ADVANCE(12);
      END_STATE();
    case 43:
      ACCEPT_TOKEN(aux_sym__unquoted_text_token1);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(48);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(aux_sym_if_command_token1);
      END_STATE();
    case 45:
      ACCEPT_TOKEN(aux_sym_endwhile_command_token1);
      if (lookahead == '$') ADVANCE(28);
      if (lookahead == ';') ADVANCE(25);
      if (lookahead == 'C') ADVANCE(41);
      if (lookahead == 'E') ADVANCE(42);
      if (lookahead == '\\') ADVANCE(8);
      if (lookahead == '{') ADVANCE(29);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(43);
      if (lookahead != 0 &&
          (lookahead < '"' || '$' < lookahead) &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(40);
      END_STATE();
    case 46:
      ACCEPT_TOKEN(aux_sym_endwhile_command_token1);
      if (lookahead == '$') ADVANCE(28);
      if (lookahead == ';') ADVANCE(25);
      if (lookahead == '\\') ADVANCE(8);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(43);
      if (lookahead != 0 &&
          (lookahead < '"' || '$' < lookahead) &&
          lookahead != '(' &&
          lookahead != ')') ADVANCE(40);
      END_STATE();
    case 47:
      ACCEPT_TOKEN(aux_sym_endwhile_command_token1);
      if (lookahead == ')') ADVANCE(35);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(48);
      END_STATE();
    case 48:
      ACCEPT_TOKEN(aux_sym_endwhile_command_token1);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(48);
      END_STATE();
    case 49:
      ACCEPT_TOKEN(sym_if);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(sym_elseif);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(sym_else);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(89);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(sym_endif);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(sym_foreach);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(sym_endforeach);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(sym_while);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(sym_endwhile);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(sym_function);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(sym_endfunction);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(sym_macro);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(sym_endmacro);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(sym_block);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(sym_endblock);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(71);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(70);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(73);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'A' ||
          lookahead == 'a') ADVANCE(74);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('B' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'B' ||
          lookahead == 'b') ADVANCE(107);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(101);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(131);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(93);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(127);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(102);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(94);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(128);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'C' ||
          lookahead == 'c') ADVANCE(132);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(67);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(134);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(108);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(97);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(90);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'D' ||
          lookahead == 'd') ADVANCE(91);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(55);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(51);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(56);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(64);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(65);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(49);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(52);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(50);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(133);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'F' ||
          lookahead == 'f') ADVANCE(125);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(96);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(53);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(54);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'H' ||
          lookahead == 'h') ADVANCE(100);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(105);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(88);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(121);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(123);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'I' ||
          lookahead == 'i') ADVANCE(106);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'K' ||
          lookahead == 'k') ADVANCE(61);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'K' ||
          lookahead == 'k') ADVANCE(62);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(122);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(130);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(79);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(82);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(84);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'L' ||
          lookahead == 'l') ADVANCE(124);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'M' ||
          lookahead == 'm') ADVANCE(66);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(57);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(58);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(80);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(69);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(76);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(77);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(78);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(81);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'N' ||
          lookahead == 'n') ADVANCE(75);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(126);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(112);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(59);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(60);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(109);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(68);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(110);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(72);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'O' ||
          lookahead == 'o') ADVANCE(129);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(85);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(119);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(120);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'R' ||
          lookahead == 'r') ADVANCE(86);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'S' ||
          lookahead == 's') ADVANCE(83);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(98);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'T' ||
          lookahead == 't') ADVANCE(99);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'U' ||
          lookahead == 'u') ADVANCE(117);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'W' ||
          lookahead == 'w') ADVANCE(95);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(135);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 19, .external_lex_state = 2},
  [2] = {.lex_state = 13, .external_lex_state = 2},
  [3] = {.lex_state = 13, .external_lex_state = 2},
  [4] = {.lex_state = 13, .external_lex_state = 2},
  [5] = {.lex_state = 13, .external_lex_state = 2},
  [6] = {.lex_state = 13, .external_lex_state = 2},
  [7] = {.lex_state = 13, .external_lex_state = 2},
  [8] = {.lex_state = 13, .external_lex_state = 2},
  [9] = {.lex_state = 13, .external_lex_state = 2},
  [10] = {.lex_state = 13, .external_lex_state = 2},
  [11] = {.lex_state = 13, .external_lex_state = 2},
  [12] = {.lex_state = 13, .external_lex_state = 2},
  [13] = {.lex_state = 13, .external_lex_state = 2},
  [14] = {.lex_state = 13, .external_lex_state = 2},
  [15] = {.lex_state = 13, .external_lex_state = 2},
  [16] = {.lex_state = 13, .external_lex_state = 2},
  [17] = {.lex_state = 2, .external_lex_state = 1},
  [18] = {.lex_state = 2, .external_lex_state = 1},
  [19] = {.lex_state = 2, .external_lex_state = 1},
  [20] = {.lex_state = 2, .external_lex_state = 1},
  [21] = {.lex_state = 2, .external_lex_state = 1},
  [22] = {.lex_state = 2, .external_lex_state = 1},
  [23] = {.lex_state = 2, .external_lex_state = 1},
  [24] = {.lex_state = 2, .external_lex_state = 1},
  [25] = {.lex_state = 2, .external_lex_state = 1},
  [26] = {.lex_state = 2, .external_lex_state = 1},
  [27] = {.lex_state = 2, .external_lex_state = 1},
  [28] = {.lex_state = 2, .external_lex_state = 1},
  [29] = {.lex_state = 2, .external_lex_state = 1},
  [30] = {.lex_state = 2, .external_lex_state = 1},
  [31] = {.lex_state = 2, .external_lex_state = 1},
  [32] = {.lex_state = 2, .external_lex_state = 1},
  [33] = {.lex_state = 2, .external_lex_state = 1},
  [34] = {.lex_state = 2, .external_lex_state = 1},
  [35] = {.lex_state = 2, .external_lex_state = 1},
  [36] = {.lex_state = 2, .external_lex_state = 1},
  [37] = {.lex_state = 2, .external_lex_state = 1},
  [38] = {.lex_state = 2, .external_lex_state = 1},
  [39] = {.lex_state = 2, .external_lex_state = 1},
  [40] = {.lex_state = 2, .external_lex_state = 1},
  [41] = {.lex_state = 2, .external_lex_state = 1},
  [42] = {.lex_state = 2, .external_lex_state = 1},
  [43] = {.lex_state = 2, .external_lex_state = 1},
  [44] = {.lex_state = 2, .external_lex_state = 1},
  [45] = {.lex_state = 2, .external_lex_state = 1},
  [46] = {.lex_state = 2, .external_lex_state = 1},
  [47] = {.lex_state = 2, .external_lex_state = 1},
  [48] = {.lex_state = 2, .external_lex_state = 1},
  [49] = {.lex_state = 2, .external_lex_state = 1},
  [50] = {.lex_state = 2, .external_lex_state = 1},
  [51] = {.lex_state = 2, .external_lex_state = 1},
  [52] = {.lex_state = 2, .external_lex_state = 1},
  [53] = {.lex_state = 2, .external_lex_state = 1},
  [54] = {.lex_state = 2, .external_lex_state = 1},
  [55] = {.lex_state = 2, .external_lex_state = 1},
  [56] = {.lex_state = 2, .external_lex_state = 1},
  [57] = {.lex_state = 2, .external_lex_state = 1},
  [58] = {.lex_state = 2, .external_lex_state = 1},
  [59] = {.lex_state = 2, .external_lex_state = 1},
  [60] = {.lex_state = 2, .external_lex_state = 1},
  [61] = {.lex_state = 2, .external_lex_state = 1},
  [62] = {.lex_state = 2, .external_lex_state = 1},
  [63] = {.lex_state = 2, .external_lex_state = 1},
  [64] = {.lex_state = 2, .external_lex_state = 1},
  [65] = {.lex_state = 2, .external_lex_state = 1},
  [66] = {.lex_state = 2, .external_lex_state = 1},
  [67] = {.lex_state = 2, .external_lex_state = 1},
  [68] = {.lex_state = 2, .external_lex_state = 1},
  [69] = {.lex_state = 2, .external_lex_state = 1},
  [70] = {.lex_state = 2, .external_lex_state = 1},
  [71] = {.lex_state = 2, .external_lex_state = 1},
  [72] = {.lex_state = 2, .external_lex_state = 1},
  [73] = {.lex_state = 2, .external_lex_state = 1},
  [74] = {.lex_state = 2, .external_lex_state = 1},
  [75] = {.lex_state = 2, .external_lex_state = 1},
  [76] = {.lex_state = 2, .external_lex_state = 1},
  [77] = {.lex_state = 2, .external_lex_state = 1},
  [78] = {.lex_state = 2, .external_lex_state = 1},
  [79] = {.lex_state = 2, .external_lex_state = 1},
  [80] = {.lex_state = 2, .external_lex_state = 1},
  [81] = {.lex_state = 2, .external_lex_state = 1},
  [82] = {.lex_state = 2, .external_lex_state = 1},
  [83] = {.lex_state = 2, .external_lex_state = 1},
  [84] = {.lex_state = 2, .external_lex_state = 1},
  [85] = {.lex_state = 2, .external_lex_state = 1},
  [86] = {.lex_state = 2, .external_lex_state = 1},
  [87] = {.lex_state = 2, .external_lex_state = 1},
  [88] = {.lex_state = 2, .external_lex_state = 1},
  [89] = {.lex_state = 2, .external_lex_state = 1},
  [90] = {.lex_state = 2, .external_lex_state = 1},
  [91] = {.lex_state = 2, .external_lex_state = 1},
  [92] = {.lex_state = 2, .external_lex_state = 1},
  [93] = {.lex_state = 2, .external_lex_state = 1},
  [94] = {.lex_state = 2, .external_lex_state = 1},
  [95] = {.lex_state = 2, .external_lex_state = 1},
  [96] = {.lex_state = 2, .external_lex_state = 1},
  [97] = {.lex_state = 2, .external_lex_state = 1},
  [98] = {.lex_state = 2, .external_lex_state = 1},
  [99] = {.lex_state = 2, .external_lex_state = 1},
  [100] = {.lex_state = 2, .external_lex_state = 1},
  [101] = {.lex_state = 2, .external_lex_state = 1},
  [102] = {.lex_state = 2, .external_lex_state = 1},
  [103] = {.lex_state = 2, .external_lex_state = 1},
  [104] = {.lex_state = 2, .external_lex_state = 1},
  [105] = {.lex_state = 2, .external_lex_state = 1},
  [106] = {.lex_state = 2, .external_lex_state = 1},
  [107] = {.lex_state = 13, .external_lex_state = 2},
  [108] = {.lex_state = 13, .external_lex_state = 2},
  [109] = {.lex_state = 19, .external_lex_state = 2},
  [110] = {.lex_state = 19, .external_lex_state = 2},
  [111] = {.lex_state = 19, .external_lex_state = 2},
  [112] = {.lex_state = 14, .external_lex_state = 2},
  [113] = {.lex_state = 19, .external_lex_state = 2},
  [114] = {.lex_state = 19, .external_lex_state = 2},
  [115] = {.lex_state = 19, .external_lex_state = 2},
  [116] = {.lex_state = 19, .external_lex_state = 2},
  [117] = {.lex_state = 19, .external_lex_state = 2},
  [118] = {.lex_state = 19, .external_lex_state = 2},
  [119] = {.lex_state = 19, .external_lex_state = 2},
  [120] = {.lex_state = 19, .external_lex_state = 2},
  [121] = {.lex_state = 15, .external_lex_state = 2},
  [122] = {.lex_state = 19, .external_lex_state = 2},
  [123] = {.lex_state = 16, .external_lex_state = 2},
  [124] = {.lex_state = 19, .external_lex_state = 2},
  [125] = {.lex_state = 19, .external_lex_state = 2},
  [126] = {.lex_state = 19, .external_lex_state = 2},
  [127] = {.lex_state = 18, .external_lex_state = 2},
  [128] = {.lex_state = 19, .external_lex_state = 2},
  [129] = {.lex_state = 19, .external_lex_state = 2},
  [130] = {.lex_state = 16, .external_lex_state = 2},
  [131] = {.lex_state = 19, .external_lex_state = 2},
  [132] = {.lex_state = 18, .external_lex_state = 2},
  [133] = {.lex_state = 19, .external_lex_state = 2},
  [134] = {.lex_state = 19, .external_lex_state = 2},
  [135] = {.lex_state = 19, .external_lex_state = 2},
  [136] = {.lex_state = 19, .external_lex_state = 2},
  [137] = {.lex_state = 19, .external_lex_state = 2},
  [138] = {.lex_state = 17, .external_lex_state = 2},
  [139] = {.lex_state = 19, .external_lex_state = 2},
  [140] = {.lex_state = 15, .external_lex_state = 2},
  [141] = {.lex_state = 19, .external_lex_state = 2},
  [142] = {.lex_state = 19, .external_lex_state = 2},
  [143] = {.lex_state = 19, .external_lex_state = 2},
  [144] = {.lex_state = 19, .external_lex_state = 2},
  [145] = {.lex_state = 19, .external_lex_state = 2},
  [146] = {.lex_state = 19, .external_lex_state = 2},
  [147] = {.lex_state = 19, .external_lex_state = 2},
  [148] = {.lex_state = 19, .external_lex_state = 2},
  [149] = {.lex_state = 19, .external_lex_state = 2},
  [150] = {.lex_state = 19, .external_lex_state = 2},
  [151] = {.lex_state = 14, .external_lex_state = 2},
  [152] = {.lex_state = 19, .external_lex_state = 2},
  [153] = {.lex_state = 19, .external_lex_state = 2},
  [154] = {.lex_state = 17, .external_lex_state = 2},
  [155] = {.lex_state = 19, .external_lex_state = 2},
  [156] = {.lex_state = 2, .external_lex_state = 1},
  [157] = {.lex_state = 2, .external_lex_state = 1},
  [158] = {.lex_state = 3, .external_lex_state = 3},
  [159] = {.lex_state = 3, .external_lex_state = 3},
  [160] = {.lex_state = 3, .external_lex_state = 3},
  [161] = {.lex_state = 3, .external_lex_state = 3},
  [162] = {.lex_state = 3, .external_lex_state = 3},
  [163] = {.lex_state = 3, .external_lex_state = 3},
  [164] = {.lex_state = 3, .external_lex_state = 3},
  [165] = {.lex_state = 3, .external_lex_state = 3},
  [166] = {.lex_state = 3, .external_lex_state = 3},
  [167] = {.lex_state = 3, .external_lex_state = 3},
  [168] = {.lex_state = 3, .external_lex_state = 3},
  [169] = {.lex_state = 3, .external_lex_state = 3},
  [170] = {.lex_state = 3, .external_lex_state = 3},
  [171] = {.lex_state = 3, .external_lex_state = 3},
  [172] = {.lex_state = 3, .external_lex_state = 3},
  [173] = {.lex_state = 3, .external_lex_state = 3},
  [174] = {.lex_state = 3, .external_lex_state = 3},
  [175] = {.lex_state = 3, .external_lex_state = 3},
  [176] = {.lex_state = 3, .external_lex_state = 3},
  [177] = {.lex_state = 3, .external_lex_state = 3},
  [178] = {.lex_state = 3, .external_lex_state = 3},
  [179] = {.lex_state = 3, .external_lex_state = 3},
  [180] = {.lex_state = 3, .external_lex_state = 3},
  [181] = {.lex_state = 3, .external_lex_state = 3},
  [182] = {.lex_state = 3, .external_lex_state = 3},
  [183] = {.lex_state = 3, .external_lex_state = 3},
  [184] = {.lex_state = 3, .external_lex_state = 3},
  [185] = {.lex_state = 3, .external_lex_state = 3},
  [186] = {.lex_state = 5},
  [187] = {.lex_state = 5},
  [188] = {.lex_state = 5},
  [189] = {.lex_state = 5},
  [190] = {.lex_state = 3},
  [191] = {.lex_state = 46},
  [192] = {.lex_state = 5},
  [193] = {.lex_state = 46},
  [194] = {.lex_state = 3},
  [195] = {.lex_state = 1, .external_lex_state = 1},
  [196] = {.lex_state = 6},
  [197] = {.lex_state = 6},
  [198] = {.lex_state = 6},
  [199] = {.lex_state = 6},
  [200] = {.lex_state = 6},
  [201] = {.lex_state = 6},
  [202] = {.lex_state = 6},
  [203] = {.lex_state = 6},
  [204] = {.lex_state = 6},
  [205] = {.lex_state = 6},
  [206] = {.lex_state = 6},
  [207] = {.lex_state = 6},
  [208] = {.lex_state = 6},
  [209] = {.lex_state = 6},
  [210] = {.lex_state = 6},
  [211] = {.lex_state = 6},
  [212] = {.lex_state = 6},
  [213] = {.lex_state = 2, .external_lex_state = 1},
  [214] = {.lex_state = 2, .external_lex_state = 1},
  [215] = {.lex_state = 2, .external_lex_state = 1},
  [216] = {.lex_state = 2, .external_lex_state = 1},
  [217] = {.lex_state = 2, .external_lex_state = 1},
  [218] = {.lex_state = 2, .external_lex_state = 1},
  [219] = {.lex_state = 2, .external_lex_state = 1},
  [220] = {.lex_state = 2, .external_lex_state = 1},
  [221] = {.lex_state = 2, .external_lex_state = 1},
  [222] = {.lex_state = 2, .external_lex_state = 1},
  [223] = {.lex_state = 2, .external_lex_state = 1},
  [224] = {.lex_state = 13, .external_lex_state = 2},
  [225] = {.lex_state = 13, .external_lex_state = 2},
  [226] = {.lex_state = 13, .external_lex_state = 2},
  [227] = {.lex_state = 13, .external_lex_state = 2},
  [228] = {.lex_state = 13, .external_lex_state = 2},
  [229] = {.lex_state = 13, .external_lex_state = 2},
  [230] = {.lex_state = 13, .external_lex_state = 2},
  [231] = {.lex_state = 13, .external_lex_state = 2},
  [232] = {.lex_state = 13, .external_lex_state = 2},
  [233] = {.lex_state = 13, .external_lex_state = 2},
  [234] = {.lex_state = 13, .external_lex_state = 2},
  [235] = {.lex_state = 13, .external_lex_state = 2},
  [236] = {.lex_state = 13, .external_lex_state = 2},
  [237] = {.lex_state = 13, .external_lex_state = 2},
  [238] = {.lex_state = 13, .external_lex_state = 2},
  [239] = {.lex_state = 13, .external_lex_state = 2},
  [240] = {.lex_state = 13, .external_lex_state = 2},
  [241] = {.lex_state = 13, .external_lex_state = 2},
  [242] = {.lex_state = 13, .external_lex_state = 2},
  [243] = {.lex_state = 13, .external_lex_state = 2},
  [244] = {.lex_state = 13, .external_lex_state = 2},
  [245] = {.lex_state = 13, .external_lex_state = 2},
  [246] = {.lex_state = 13, .external_lex_state = 2},
  [247] = {.lex_state = 13, .external_lex_state = 2},
  [248] = {.lex_state = 13, .external_lex_state = 2},
  [249] = {.lex_state = 13, .external_lex_state = 2},
  [250] = {.lex_state = 13, .external_lex_state = 2},
  [251] = {.lex_state = 13, .external_lex_state = 2},
  [252] = {.lex_state = 13, .external_lex_state = 2},
  [253] = {.lex_state = 13, .external_lex_state = 2},
  [254] = {.lex_state = 13, .external_lex_state = 2},
  [255] = {.lex_state = 13, .external_lex_state = 2},
  [256] = {.lex_state = 13, .external_lex_state = 2},
  [257] = {.lex_state = 13, .external_lex_state = 2},
  [258] = {.lex_state = 13, .external_lex_state = 2},
  [259] = {.lex_state = 13, .external_lex_state = 2},
  [260] = {.lex_state = 4},
  [261] = {.lex_state = 7},
  [262] = {.lex_state = 45},
  [263] = {.lex_state = 15, .external_lex_state = 2},
  [264] = {.lex_state = 17, .external_lex_state = 2},
  [265] = {.lex_state = 18, .external_lex_state = 2},
  [266] = {.lex_state = 18, .external_lex_state = 2},
  [267] = {.lex_state = 18, .external_lex_state = 2},
  [268] = {.lex_state = 19, .external_lex_state = 2},
  [269] = {.lex_state = 18, .external_lex_state = 2},
  [270] = {.lex_state = 18, .external_lex_state = 2},
  [271] = {.lex_state = 18, .external_lex_state = 2},
  [272] = {.lex_state = 18, .external_lex_state = 2},
  [273] = {.lex_state = 18, .external_lex_state = 2},
  [274] = {.lex_state = 18, .external_lex_state = 2},
  [275] = {.lex_state = 19, .external_lex_state = 2},
  [276] = {.lex_state = 19, .external_lex_state = 2},
  [277] = {.lex_state = 18, .external_lex_state = 2},
  [278] = {.lex_state = 18, .external_lex_state = 2},
  [279] = {.lex_state = 18, .external_lex_state = 2},
  [280] = {.lex_state = 18, .external_lex_state = 2},
  [281] = {.lex_state = 18, .external_lex_state = 2},
  [282] = {.lex_state = 18, .external_lex_state = 2},
  [283] = {.lex_state = 16, .external_lex_state = 2},
  [284] = {.lex_state = 19, .external_lex_state = 2},
  [285] = {.lex_state = 19, .external_lex_state = 2},
  [286] = {.lex_state = 16, .external_lex_state = 2},
  [287] = {.lex_state = 16, .external_lex_state = 2},
  [288] = {.lex_state = 16, .external_lex_state = 2},
  [289] = {.lex_state = 16, .external_lex_state = 2},
  [290] = {.lex_state = 16, .external_lex_state = 2},
  [291] = {.lex_state = 16, .external_lex_state = 2},
  [292] = {.lex_state = 16, .external_lex_state = 2},
  [293] = {.lex_state = 16, .external_lex_state = 2},
  [294] = {.lex_state = 16, .external_lex_state = 2},
  [295] = {.lex_state = 16, .external_lex_state = 2},
  [296] = {.lex_state = 16, .external_lex_state = 2},
  [297] = {.lex_state = 16, .external_lex_state = 2},
  [298] = {.lex_state = 16, .external_lex_state = 2},
  [299] = {.lex_state = 16, .external_lex_state = 2},
  [300] = {.lex_state = 16, .external_lex_state = 2},
  [301] = {.lex_state = 16, .external_lex_state = 2},
  [302] = {.lex_state = 19, .external_lex_state = 2},
  [303] = {.lex_state = 16, .external_lex_state = 2},
  [304] = {.lex_state = 16, .external_lex_state = 2},
  [305] = {.lex_state = 16, .external_lex_state = 2},
  [306] = {.lex_state = 16, .external_lex_state = 2},
  [307] = {.lex_state = 16, .external_lex_state = 2},
  [308] = {.lex_state = 16, .external_lex_state = 2},
  [309] = {.lex_state = 19, .external_lex_state = 2},
  [310] = {.lex_state = 19, .external_lex_state = 2},
  [311] = {.lex_state = 16, .external_lex_state = 2},
  [312] = {.lex_state = 16, .external_lex_state = 2},
  [313] = {.lex_state = 16, .external_lex_state = 2},
  [314] = {.lex_state = 16, .external_lex_state = 2},
  [315] = {.lex_state = 16, .external_lex_state = 2},
  [316] = {.lex_state = 16, .external_lex_state = 2},
  [317] = {.lex_state = 14, .external_lex_state = 2},
  [318] = {.lex_state = 19, .external_lex_state = 2},
  [319] = {.lex_state = 18, .external_lex_state = 2},
  [320] = {.lex_state = 19, .external_lex_state = 2},
  [321] = {.lex_state = 19, .external_lex_state = 2},
  [322] = {.lex_state = 14, .external_lex_state = 2},
  [323] = {.lex_state = 14, .external_lex_state = 2},
  [324] = {.lex_state = 14, .external_lex_state = 2},
  [325] = {.lex_state = 14, .external_lex_state = 2},
  [326] = {.lex_state = 14, .external_lex_state = 2},
  [327] = {.lex_state = 14, .external_lex_state = 2},
  [328] = {.lex_state = 14, .external_lex_state = 2},
  [329] = {.lex_state = 14, .external_lex_state = 2},
  [330] = {.lex_state = 14, .external_lex_state = 2},
  [331] = {.lex_state = 14, .external_lex_state = 2},
  [332] = {.lex_state = 14, .external_lex_state = 2},
  [333] = {.lex_state = 14, .external_lex_state = 2},
  [334] = {.lex_state = 14, .external_lex_state = 2},
  [335] = {.lex_state = 14, .external_lex_state = 2},
  [336] = {.lex_state = 14, .external_lex_state = 2},
  [337] = {.lex_state = 14, .external_lex_state = 2},
  [338] = {.lex_state = 19, .external_lex_state = 2},
  [339] = {.lex_state = 14, .external_lex_state = 2},
  [340] = {.lex_state = 14, .external_lex_state = 2},
  [341] = {.lex_state = 14, .external_lex_state = 2},
  [342] = {.lex_state = 14, .external_lex_state = 2},
  [343] = {.lex_state = 14, .external_lex_state = 2},
  [344] = {.lex_state = 14, .external_lex_state = 2},
  [345] = {.lex_state = 19, .external_lex_state = 2},
  [346] = {.lex_state = 18, .external_lex_state = 2},
  [347] = {.lex_state = 14, .external_lex_state = 2},
  [348] = {.lex_state = 14, .external_lex_state = 2},
  [349] = {.lex_state = 14, .external_lex_state = 2},
  [350] = {.lex_state = 14, .external_lex_state = 2},
  [351] = {.lex_state = 14, .external_lex_state = 2},
  [352] = {.lex_state = 14, .external_lex_state = 2},
  [353] = {.lex_state = 17, .external_lex_state = 2},
  [354] = {.lex_state = 18, .external_lex_state = 2},
  [355] = {.lex_state = 18, .external_lex_state = 2},
  [356] = {.lex_state = 17, .external_lex_state = 2},
  [357] = {.lex_state = 17, .external_lex_state = 2},
  [358] = {.lex_state = 17, .external_lex_state = 2},
  [359] = {.lex_state = 17, .external_lex_state = 2},
  [360] = {.lex_state = 17, .external_lex_state = 2},
  [361] = {.lex_state = 17, .external_lex_state = 2},
  [362] = {.lex_state = 17, .external_lex_state = 2},
  [363] = {.lex_state = 17, .external_lex_state = 2},
  [364] = {.lex_state = 17, .external_lex_state = 2},
  [365] = {.lex_state = 17, .external_lex_state = 2},
  [366] = {.lex_state = 19, .external_lex_state = 2},
  [367] = {.lex_state = 17, .external_lex_state = 2},
  [368] = {.lex_state = 17, .external_lex_state = 2},
  [369] = {.lex_state = 17, .external_lex_state = 2},
  [370] = {.lex_state = 17, .external_lex_state = 2},
  [371] = {.lex_state = 17, .external_lex_state = 2},
  [372] = {.lex_state = 17, .external_lex_state = 2},
  [373] = {.lex_state = 17, .external_lex_state = 2},
  [374] = {.lex_state = 17, .external_lex_state = 2},
  [375] = {.lex_state = 17, .external_lex_state = 2},
  [376] = {.lex_state = 17, .external_lex_state = 2},
  [377] = {.lex_state = 17, .external_lex_state = 2},
  [378] = {.lex_state = 17, .external_lex_state = 2},
  [379] = {.lex_state = 17, .external_lex_state = 2},
  [380] = {.lex_state = 17, .external_lex_state = 2},
  [381] = {.lex_state = 17, .external_lex_state = 2},
  [382] = {.lex_state = 17, .external_lex_state = 2},
  [383] = {.lex_state = 17, .external_lex_state = 2},
  [384] = {.lex_state = 15, .external_lex_state = 2},
  [385] = {.lex_state = 18, .external_lex_state = 2},
  [386] = {.lex_state = 15, .external_lex_state = 2},
  [387] = {.lex_state = 15, .external_lex_state = 2},
  [388] = {.lex_state = 15, .external_lex_state = 2},
  [389] = {.lex_state = 15, .external_lex_state = 2},
  [390] = {.lex_state = 15, .external_lex_state = 2},
  [391] = {.lex_state = 15, .external_lex_state = 2},
  [392] = {.lex_state = 15, .external_lex_state = 2},
  [393] = {.lex_state = 15, .external_lex_state = 2},
  [394] = {.lex_state = 15, .external_lex_state = 2},
  [395] = {.lex_state = 15, .external_lex_state = 2},
  [396] = {.lex_state = 15, .external_lex_state = 2},
  [397] = {.lex_state = 15, .external_lex_state = 2},
  [398] = {.lex_state = 18, .external_lex_state = 2},
  [399] = {.lex_state = 15, .external_lex_state = 2},
  [400] = {.lex_state = 15, .external_lex_state = 2},
  [401] = {.lex_state = 15, .external_lex_state = 2},
  [402] = {.lex_state = 15, .external_lex_state = 2},
  [403] = {.lex_state = 15, .external_lex_state = 2},
  [404] = {.lex_state = 15, .external_lex_state = 2},
  [405] = {.lex_state = 15, .external_lex_state = 2},
  [406] = {.lex_state = 15, .external_lex_state = 2},
  [407] = {.lex_state = 15, .external_lex_state = 2},
  [408] = {.lex_state = 15, .external_lex_state = 2},
  [409] = {.lex_state = 15, .external_lex_state = 2},
  [410] = {.lex_state = 15, .external_lex_state = 2},
  [411] = {.lex_state = 15, .external_lex_state = 2},
  [412] = {.lex_state = 15, .external_lex_state = 2},
  [413] = {.lex_state = 15, .external_lex_state = 2},
  [414] = {.lex_state = 19, .external_lex_state = 2},
  [415] = {.lex_state = 19, .external_lex_state = 2},
  [416] = {.lex_state = 19, .external_lex_state = 2},
  [417] = {.lex_state = 19, .external_lex_state = 2},
  [418] = {.lex_state = 19, .external_lex_state = 2},
  [419] = {.lex_state = 19, .external_lex_state = 2},
  [420] = {.lex_state = 19, .external_lex_state = 2},
  [421] = {.lex_state = 19, .external_lex_state = 2},
  [422] = {.lex_state = 18, .external_lex_state = 2},
  [423] = {.lex_state = 19, .external_lex_state = 2},
  [424] = {.lex_state = 18, .external_lex_state = 2},
  [425] = {.lex_state = 18, .external_lex_state = 2},
  [426] = {.lex_state = 19, .external_lex_state = 2},
  [427] = {.lex_state = 19, .external_lex_state = 2},
  [428] = {.lex_state = 19, .external_lex_state = 2},
  [429] = {.lex_state = 18, .external_lex_state = 2},
  [430] = {.lex_state = 18, .external_lex_state = 2},
  [431] = {.lex_state = 18, .external_lex_state = 2},
  [432] = {.lex_state = 18, .external_lex_state = 2},
  [433] = {.lex_state = 18, .external_lex_state = 2},
  [434] = {.lex_state = 19, .external_lex_state = 2},
  [435] = {.lex_state = 19, .external_lex_state = 2},
  [436] = {.lex_state = 19, .external_lex_state = 2},
  [437] = {.lex_state = 46},
  [438] = {.lex_state = 3},
  [439] = {.lex_state = 19, .external_lex_state = 2},
  [440] = {.lex_state = 19, .external_lex_state = 2},
  [441] = {.lex_state = 19, .external_lex_state = 2},
  [442] = {.lex_state = 19, .external_lex_state = 2},
  [443] = {.lex_state = 19, .external_lex_state = 2},
  [444] = {.lex_state = 5},
  [445] = {.lex_state = 19, .external_lex_state = 2},
  [446] = {.lex_state = 19, .external_lex_state = 2},
  [447] = {.lex_state = 19, .external_lex_state = 2},
  [448] = {.lex_state = 19, .external_lex_state = 2},
  [449] = {.lex_state = 19, .external_lex_state = 2},
  [450] = {.lex_state = 46},
  [451] = {.lex_state = 46},
  [452] = {.lex_state = 46},
  [453] = {.lex_state = 6},
  [454] = {.lex_state = 5},
  [455] = {.lex_state = 5},
  [456] = {.lex_state = 46},
  [457] = {.lex_state = 46},
  [458] = {.lex_state = 5},
  [459] = {.lex_state = 3},
  [460] = {.lex_state = 3},
  [461] = {.lex_state = 3},
  [462] = {.lex_state = 6},
  [463] = {.lex_state = 3},
  [464] = {.lex_state = 3},
  [465] = {.lex_state = 5},
  [466] = {.lex_state = 6},
  [467] = {.lex_state = 6},
  [468] = {.lex_state = 6},
  [469] = {.lex_state = 5},
  [470] = {.lex_state = 6},
  [471] = {.lex_state = 6},
  [472] = {.lex_state = 6},
  [473] = {.lex_state = 6},
  [474] = {.lex_state = 6},
  [475] = {.lex_state = 6},
  [476] = {.lex_state = 6},
  [477] = {.lex_state = 6},
  [478] = {.lex_state = 6},
  [479] = {.lex_state = 6},
  [480] = {.lex_state = 6},
  [481] = {.lex_state = 6},
  [482] = {.lex_state = 6},
  [483] = {.lex_state = 6},
  [484] = {.lex_state = 6},
  [485] = {.lex_state = 6},
  [486] = {.lex_state = 6},
  [487] = {.lex_state = 6},
  [488] = {.lex_state = 6},
  [489] = {.lex_state = 6},
  [490] = {.lex_state = 6},
  [491] = {.lex_state = 6},
  [492] = {.lex_state = 6},
  [493] = {.lex_state = 6},
  [494] = {.lex_state = 6},
  [495] = {.lex_state = 6},
  [496] = {.lex_state = 6},
  [497] = {.lex_state = 6},
  [498] = {.lex_state = 6},
  [499] = {.lex_state = 6},
  [500] = {.lex_state = 6},
  [501] = {.lex_state = 6},
  [502] = {.lex_state = 6},
  [503] = {.lex_state = 6},
  [504] = {.lex_state = 6},
  [505] = {.lex_state = 6},
  [506] = {.lex_state = 6},
  [507] = {.lex_state = 6},
  [508] = {.lex_state = 6},
  [509] = {.lex_state = 6},
  [510] = {.lex_state = 6},
  [511] = {.lex_state = 6},
  [512] = {.lex_state = 6},
  [513] = {.lex_state = 6},
  [514] = {.lex_state = 6},
  [515] = {.lex_state = 6},
  [516] = {.lex_state = 6},
  [517] = {.lex_state = 6},
  [518] = {.lex_state = 6},
  [519] = {.lex_state = 6},
  [520] = {.lex_state = 6},
  [521] = {.lex_state = 6},
  [522] = {.lex_state = 6},
  [523] = {.lex_state = 6},
  [524] = {.lex_state = 6},
  [525] = {.lex_state = 6},
  [526] = {.lex_state = 6},
  [527] = {.lex_state = 6},
  [528] = {.lex_state = 6},
  [529] = {.lex_state = 6},
  [530] = {.lex_state = 6},
  [531] = {.lex_state = 6},
  [532] = {.lex_state = 6},
  [533] = {.lex_state = 6},
  [534] = {.lex_state = 6},
  [535] = {.lex_state = 6},
  [536] = {.lex_state = 6},
  [537] = {.lex_state = 6},
  [538] = {.lex_state = 6},
  [539] = {.lex_state = 6},
  [540] = {.lex_state = 6},
  [541] = {.lex_state = 6},
  [542] = {.lex_state = 6},
  [543] = {.lex_state = 6},
  [544] = {.lex_state = 6},
  [545] = {.lex_state = 6},
  [546] = {.lex_state = 6},
  [547] = {.lex_state = 6},
  [548] = {.lex_state = 6},
  [549] = {.lex_state = 6},
  [550] = {.lex_state = 6},
  [551] = {.lex_state = 6},
  [552] = {.lex_state = 6},
  [553] = {.lex_state = 6},
  [554] = {.lex_state = 6},
  [555] = {.lex_state = 6},
  [556] = {.lex_state = 6},
  [557] = {.lex_state = 6},
  [558] = {.lex_state = 6},
  [559] = {.lex_state = 6},
  [560] = {.lex_state = 6},
  [561] = {.lex_state = 6},
  [562] = {.lex_state = 6},
  [563] = {.lex_state = 6},
  [564] = {.lex_state = 6},
  [565] = {.lex_state = 6},
  [566] = {.lex_state = 6},
  [567] = {.lex_state = 6},
  [568] = {.lex_state = 6},
  [569] = {.lex_state = 6},
  [570] = {.lex_state = 6},
  [571] = {.lex_state = 6},
  [572] = {.lex_state = 6},
  [573] = {.lex_state = 6},
  [574] = {.lex_state = 6},
  [575] = {.lex_state = 6},
  [576] = {.lex_state = 6},
  [577] = {.lex_state = 6},
  [578] = {.lex_state = 6},
  [579] = {.lex_state = 0},
  [580] = {.lex_state = 6},
  [581] = {.lex_state = 6},
  [582] = {.lex_state = 6},
  [583] = {.lex_state = 6},
  [584] = {.lex_state = 6},
  [585] = {.lex_state = 6},
  [586] = {.lex_state = 47},
  [587] = {.lex_state = 47},
  [588] = {.lex_state = 47},
  [589] = {.lex_state = 15},
  [590] = {.lex_state = 17},
  [591] = {.lex_state = 14},
  [592] = {.lex_state = 47},
  [593] = {.lex_state = 16},
  [594] = {.lex_state = 18},
  [595] = {.lex_state = 47},
  [596] = {.lex_state = 17},
  [597] = {.lex_state = 47},
  [598] = {.lex_state = 47},
  [599] = {.lex_state = 15},
  [600] = {.lex_state = 17},
  [601] = {.lex_state = 14},
  [602] = {.lex_state = 16},
  [603] = {.lex_state = 18},
  [604] = {.lex_state = 18},
  [605] = {.lex_state = 47},
  [606] = {.lex_state = 47},
  [607] = {.lex_state = 16},
  [608] = {.lex_state = 18},
  [609] = {.lex_state = 16},
  [610] = {.lex_state = 14},
  [611] = {.lex_state = 17},
  [612] = {.lex_state = 15},
  [613] = {.lex_state = 14},
  [614] = {.lex_state = 47},
  [615] = {.lex_state = 15},
  [616] = {.lex_state = 15},
  [617] = {.lex_state = 17},
  [618] = {.lex_state = 14},
  [619] = {.lex_state = 15},
  [620] = {.lex_state = 47},
  [621] = {.lex_state = 17},
  [622] = {.lex_state = 17},
  [623] = {.lex_state = 14},
  [624] = {.lex_state = 14},
  [625] = {.lex_state = 16},
  [626] = {.lex_state = 18},
  [627] = {.lex_state = 47},
  [628] = {.lex_state = 16},
  [629] = {.lex_state = 16},
  [630] = {.lex_state = 18},
  [631] = {.lex_state = 18},
  [632] = {.lex_state = 47},
  [633] = {.lex_state = 47},
  [634] = {.lex_state = 15},
  [635] = {.lex_state = 0},
  [636] = {.lex_state = 0},
  [637] = {.lex_state = 0},
  [638] = {.lex_state = 0},
  [639] = {.lex_state = 0},
  [640] = {.lex_state = 0},
  [641] = {.lex_state = 0},
  [642] = {.lex_state = 0},
  [643] = {.lex_state = 0},
  [644] = {.lex_state = 0},
  [645] = {.lex_state = 0},
  [646] = {.lex_state = 0},
  [647] = {.lex_state = 0},
  [648] = {.lex_state = 0},
  [649] = {.lex_state = 0},
  [650] = {.lex_state = 0},
  [651] = {.lex_state = 0},
  [652] = {.lex_state = 0},
  [653] = {.lex_state = 0},
  [654] = {.lex_state = 0},
  [655] = {.lex_state = 0},
  [656] = {.lex_state = 0},
  [657] = {.lex_state = 0},
  [658] = {.lex_state = 0},
  [659] = {.lex_state = 0},
  [660] = {.lex_state = 0},
  [661] = {.lex_state = 0},
  [662] = {.lex_state = 0},
  [663] = {.lex_state = 0},
  [664] = {.lex_state = 0},
  [665] = {.lex_state = 0},
  [666] = {.lex_state = 0},
  [667] = {.lex_state = 0},
  [668] = {.lex_state = 48},
  [669] = {.lex_state = 48},
  [670] = {.lex_state = 0},
  [671] = {.lex_state = 0},
  [672] = {.lex_state = 0},
  [673] = {.lex_state = 0},
  [674] = {.lex_state = 0},
  [675] = {.lex_state = 0},
  [676] = {.lex_state = 0},
  [677] = {.lex_state = 0},
  [678] = {.lex_state = 0},
  [679] = {.lex_state = 19},
  [680] = {.lex_state = 0},
  [681] = {.lex_state = 0},
  [682] = {.lex_state = 0},
  [683] = {.lex_state = 0},
  [684] = {.lex_state = 0},
  [685] = {.lex_state = 0},
  [686] = {.lex_state = 48},
  [687] = {.lex_state = 48},
  [688] = {.lex_state = 0},
  [689] = {.lex_state = 19},
  [690] = {.lex_state = 19},
  [691] = {.lex_state = 0},
  [692] = {.lex_state = 0},
  [693] = {.lex_state = 0},
  [694] = {.lex_state = 0},
  [695] = {.lex_state = 0},
  [696] = {.lex_state = 0},
  [697] = {.lex_state = 0},
  [698] = {.lex_state = 19},
  [699] = {.lex_state = 0},
  [700] = {.lex_state = 0},
  [701] = {.lex_state = 0},
  [702] = {.lex_state = 0},
  [703] = {.lex_state = 19},
  [704] = {.lex_state = 0},
  [705] = {.lex_state = 0},
  [706] = {.lex_state = 0},
  [707] = {.lex_state = 19},
  [708] = {.lex_state = 0},
  [709] = {.lex_state = 0},
  [710] = {.lex_state = 48},
  [711] = {.lex_state = 48},
  [712] = {.lex_state = 0},
  [713] = {.lex_state = 0},
  [714] = {.lex_state = 0},
  [715] = {.lex_state = 0},
  [716] = {.lex_state = 0},
  [717] = {.lex_state = 0},
  [718] = {.lex_state = 0},
  [719] = {.lex_state = 0},
  [720] = {.lex_state = 0},
  [721] = {.lex_state = 19},
  [722] = {.lex_state = 19},
  [723] = {.lex_state = 19},
  [724] = {.lex_state = 0},
  [725] = {.lex_state = 0},
  [726] = {.lex_state = 0},
  [727] = {.lex_state = 0},
  [728] = {.lex_state = 0},
  [729] = {.lex_state = 0},
  [730] = {.lex_state = 19},
  [731] = {.lex_state = 48},
  [732] = {.lex_state = 0},
  [733] = {.lex_state = 0},
  [734] = {.lex_state = 48},
  [735] = {.lex_state = 48},
  [736] = {.lex_state = 0},
  [737] = {.lex_state = 0},
  [738] = {.lex_state = 0},
  [739] = {.lex_state = 0},
  [740] = {.lex_state = 0},
  [741] = {.lex_state = 0},
  [742] = {.lex_state = 0},
  [743] = {.lex_state = 0},
  [744] = {.lex_state = 0},
  [745] = {.lex_state = 0},
  [746] = {.lex_state = 0},
  [747] = {.lex_state = 0},
  [748] = {.lex_state = 19},
  [749] = {.lex_state = 19},
  [750] = {.lex_state = 48},
  [751] = {.lex_state = 0},
  [752] = {.lex_state = 0},
  [753] = {.lex_state = 0},
  [754] = {.lex_state = 0},
  [755] = {.lex_state = 48},
  [756] = {.lex_state = 48},
  [757] = {.lex_state = 0},
  [758] = {.lex_state = 19},
  [759] = {.lex_state = 0},
  [760] = {.lex_state = 0},
  [761] = {.lex_state = 0},
  [762] = {.lex_state = 0},
  [763] = {.lex_state = 0},
  [764] = {.lex_state = 0},
  [765] = {.lex_state = 0},
  [766] = {.lex_state = 0},
  [767] = {.lex_state = 0},
  [768] = {.lex_state = 0},
  [769] = {.lex_state = 0},
  [770] = {.lex_state = 0},
  [771] = {.lex_state = 0},
  [772] = {.lex_state = 0},
  [773] = {.lex_state = 19},
  [774] = {.lex_state = 48},
  [775] = {.lex_state = 0},
  [776] = {.lex_state = 48},
  [777] = {.lex_state = 48},
  [778] = {.lex_state = 0},
  [779] = {.lex_state = 0},
  [780] = {.lex_state = 0},
  [781] = {.lex_state = 48},
  [782] = {.lex_state = 0},
  [783] = {.lex_state = 0},
  [784] = {.lex_state = 0},
  [785] = {.lex_state = 0},
  [786] = {.lex_state = 0},
  [787] = {.lex_state = 0},
  [788] = {.lex_state = 0},
  [789] = {.lex_state = 0},
  [790] = {.lex_state = 0},
  [791] = {.lex_state = 0},
  [792] = {.lex_state = 19},
  [793] = {.lex_state = 0},
  [794] = {.lex_state = 0},
  [795] = {.lex_state = 0},
  [796] = {.lex_state = 0},
  [797] = {.lex_state = 48},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym__escape_identity] = ACTIONS(1),
    [anon_sym_BSLASHt] = ACTIONS(1),
    [anon_sym_BSLASHr] = ACTIONS(1),
    [anon_sym_BSLASHn] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_BSLASH_SEMI] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_ENV] = ACTIONS(1),
    [anon_sym_CACHE] = ACTIONS(1),
    [aux_sym__untrimmed_argument_token1] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [aux_sym__unquoted_text_token1] = ACTIONS(1),
    [aux_sym_if_command_token1] = ACTIONS(1),
    [sym_bracket_argument] = ACTIONS(1),
    [sym_bracket_comment] = ACTIONS(1),
    [sym_line_comment] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(789),
    [sym_if_command] = STATE(10),
    [sym_if_condition] = STATE(155),
    [sym_foreach_command] = STATE(118),
    [sym_foreach_loop] = STATE(155),
    [sym_while_command] = STATE(117),
    [sym_while_loop] = STATE(155),
    [sym_function_command] = STATE(128),
    [sym_function_def] = STATE(155),
    [sym_macro_command] = STATE(124),
    [sym_macro_def] = STATE(155),
    [sym_block_command] = STATE(149),
    [sym_block_def] = STATE(155),
    [sym_normal_command] = STATE(155),
    [sym__command_invocation] = STATE(155),
    [sym__untrimmed_command_invocation] = STATE(155),
    [aux_sym_source_file_repeat1] = STATE(155),
    [ts_builtin_sym_end] = ACTIONS(3),
    [aux_sym__untrimmed_argument_token1] = ACTIONS(5),
    [sym_if] = ACTIONS(7),
    [sym_foreach] = ACTIONS(9),
    [sym_while] = ACTIONS(11),
    [sym_function] = ACTIONS(13),
    [sym_macro] = ACTIONS(15),
    [sym_block] = ACTIONS(17),
    [sym_identifier] = ACTIONS(19),
    [sym_bracket_comment] = ACTIONS(5),
    [sym_line_comment] = ACTIONS(5),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 20,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(23), 1,
      sym_elseif,
    ACTIONS(25), 1,
      sym_else,
    ACTIONS(27), 1,
      sym_endif,
    ACTIONS(29), 1,
      sym_identifier,
    STATE(9), 1,
      sym_if_command,
    STATE(131), 1,
      sym_foreach_command,
    STATE(137), 1,
      sym_while_command,
    STATE(146), 1,
      sym_function_command,
    STATE(148), 1,
      sym_macro_command,
    STATE(153), 1,
      sym_block_command,
    STATE(432), 1,
      sym_endif_command,
    ACTIONS(21), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(16), 4,
      sym_body,
      sym_elseif_command,
      sym_else_command,
      aux_sym_if_condition_repeat1,
    STATE(108), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [75] = 20,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(23), 1,
      sym_elseif,
    ACTIONS(25), 1,
      sym_else,
    ACTIONS(29), 1,
      sym_identifier,
    ACTIONS(31), 1,
      sym_endif,
    STATE(9), 1,
      sym_if_command,
    STATE(131), 1,
      sym_foreach_command,
    STATE(137), 1,
      sym_while_command,
    STATE(146), 1,
      sym_function_command,
    STATE(148), 1,
      sym_macro_command,
    STATE(153), 1,
      sym_block_command,
    STATE(317), 1,
      sym_endif_command,
    ACTIONS(21), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(4), 4,
      sym_body,
      sym_elseif_command,
      sym_else_command,
      aux_sym_if_condition_repeat1,
    STATE(108), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [150] = 20,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(23), 1,
      sym_elseif,
    ACTIONS(25), 1,
      sym_else,
    ACTIONS(29), 1,
      sym_identifier,
    ACTIONS(31), 1,
      sym_endif,
    STATE(9), 1,
      sym_if_command,
    STATE(131), 1,
      sym_foreach_command,
    STATE(137), 1,
      sym_while_command,
    STATE(146), 1,
      sym_function_command,
    STATE(148), 1,
      sym_macro_command,
    STATE(153), 1,
      sym_block_command,
    STATE(323), 1,
      sym_endif_command,
    ACTIONS(21), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(16), 4,
      sym_body,
      sym_elseif_command,
      sym_else_command,
      aux_sym_if_condition_repeat1,
    STATE(108), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [225] = 20,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(23), 1,
      sym_elseif,
    ACTIONS(25), 1,
      sym_else,
    ACTIONS(29), 1,
      sym_identifier,
    ACTIONS(33), 1,
      sym_endif,
    STATE(9), 1,
      sym_if_command,
    STATE(131), 1,
      sym_foreach_command,
    STATE(137), 1,
      sym_while_command,
    STATE(146), 1,
      sym_function_command,
    STATE(148), 1,
      sym_macro_command,
    STATE(153), 1,
      sym_block_command,
    STATE(353), 1,
      sym_endif_command,
    ACTIONS(21), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(6), 4,
      sym_body,
      sym_elseif_command,
      sym_else_command,
      aux_sym_if_condition_repeat1,
    STATE(108), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [300] = 20,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(23), 1,
      sym_elseif,
    ACTIONS(25), 1,
      sym_else,
    ACTIONS(29), 1,
      sym_identifier,
    ACTIONS(33), 1,
      sym_endif,
    STATE(9), 1,
      sym_if_command,
    STATE(131), 1,
      sym_foreach_command,
    STATE(137), 1,
      sym_while_command,
    STATE(146), 1,
      sym_function_command,
    STATE(148), 1,
      sym_macro_command,
    STATE(153), 1,
      sym_block_command,
    STATE(357), 1,
      sym_endif_command,
    ACTIONS(21), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(16), 4,
      sym_body,
      sym_elseif_command,
      sym_else_command,
      aux_sym_if_condition_repeat1,
    STATE(108), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [375] = 20,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(23), 1,
      sym_elseif,
    ACTIONS(25), 1,
      sym_else,
    ACTIONS(29), 1,
      sym_identifier,
    ACTIONS(35), 1,
      sym_endif,
    STATE(9), 1,
      sym_if_command,
    STATE(131), 1,
      sym_foreach_command,
    STATE(137), 1,
      sym_while_command,
    STATE(146), 1,
      sym_function_command,
    STATE(148), 1,
      sym_macro_command,
    STATE(153), 1,
      sym_block_command,
    STATE(384), 1,
      sym_endif_command,
    ACTIONS(21), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(8), 4,
      sym_body,
      sym_elseif_command,
      sym_else_command,
      aux_sym_if_condition_repeat1,
    STATE(108), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [450] = 20,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(23), 1,
      sym_elseif,
    ACTIONS(25), 1,
      sym_else,
    ACTIONS(29), 1,
      sym_identifier,
    ACTIONS(35), 1,
      sym_endif,
    STATE(9), 1,
      sym_if_command,
    STATE(131), 1,
      sym_foreach_command,
    STATE(137), 1,
      sym_while_command,
    STATE(146), 1,
      sym_function_command,
    STATE(148), 1,
      sym_macro_command,
    STATE(153), 1,
      sym_block_command,
    STATE(387), 1,
      sym_endif_command,
    ACTIONS(21), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(16), 4,
      sym_body,
      sym_elseif_command,
      sym_else_command,
      aux_sym_if_condition_repeat1,
    STATE(108), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [525] = 20,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(23), 1,
      sym_elseif,
    ACTIONS(25), 1,
      sym_else,
    ACTIONS(29), 1,
      sym_identifier,
    ACTIONS(37), 1,
      sym_endif,
    STATE(9), 1,
      sym_if_command,
    STATE(131), 1,
      sym_foreach_command,
    STATE(137), 1,
      sym_while_command,
    STATE(146), 1,
      sym_function_command,
    STATE(148), 1,
      sym_macro_command,
    STATE(153), 1,
      sym_block_command,
    STATE(249), 1,
      sym_endif_command,
    ACTIONS(21), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(14), 4,
      sym_body,
      sym_elseif_command,
      sym_else_command,
      aux_sym_if_condition_repeat1,
    STATE(108), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [600] = 20,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(23), 1,
      sym_elseif,
    ACTIONS(25), 1,
      sym_else,
    ACTIONS(29), 1,
      sym_identifier,
    ACTIONS(39), 1,
      sym_endif,
    STATE(9), 1,
      sym_if_command,
    STATE(131), 1,
      sym_foreach_command,
    STATE(137), 1,
      sym_while_command,
    STATE(146), 1,
      sym_function_command,
    STATE(148), 1,
      sym_macro_command,
    STATE(153), 1,
      sym_block_command,
    STATE(309), 1,
      sym_endif_command,
    ACTIONS(21), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(13), 4,
      sym_body,
      sym_elseif_command,
      sym_else_command,
      aux_sym_if_condition_repeat1,
    STATE(108), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [675] = 20,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(23), 1,
      sym_elseif,
    ACTIONS(25), 1,
      sym_else,
    ACTIONS(29), 1,
      sym_identifier,
    ACTIONS(41), 1,
      sym_endif,
    STATE(9), 1,
      sym_if_command,
    STATE(131), 1,
      sym_foreach_command,
    STATE(137), 1,
      sym_while_command,
    STATE(146), 1,
      sym_function_command,
    STATE(148), 1,
      sym_macro_command,
    STATE(153), 1,
      sym_block_command,
    STATE(287), 1,
      sym_endif_command,
    ACTIONS(21), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(16), 4,
      sym_body,
      sym_elseif_command,
      sym_else_command,
      aux_sym_if_condition_repeat1,
    STATE(108), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [750] = 20,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(23), 1,
      sym_elseif,
    ACTIONS(25), 1,
      sym_else,
    ACTIONS(29), 1,
      sym_identifier,
    ACTIONS(41), 1,
      sym_endif,
    STATE(9), 1,
      sym_if_command,
    STATE(131), 1,
      sym_foreach_command,
    STATE(137), 1,
      sym_while_command,
    STATE(146), 1,
      sym_function_command,
    STATE(148), 1,
      sym_macro_command,
    STATE(153), 1,
      sym_block_command,
    STATE(283), 1,
      sym_endif_command,
    ACTIONS(21), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(11), 4,
      sym_body,
      sym_elseif_command,
      sym_else_command,
      aux_sym_if_condition_repeat1,
    STATE(108), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [825] = 20,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(23), 1,
      sym_elseif,
    ACTIONS(25), 1,
      sym_else,
    ACTIONS(29), 1,
      sym_identifier,
    ACTIONS(39), 1,
      sym_endif,
    STATE(9), 1,
      sym_if_command,
    STATE(131), 1,
      sym_foreach_command,
    STATE(137), 1,
      sym_while_command,
    STATE(146), 1,
      sym_function_command,
    STATE(148), 1,
      sym_macro_command,
    STATE(153), 1,
      sym_block_command,
    STATE(428), 1,
      sym_endif_command,
    ACTIONS(21), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(16), 4,
      sym_body,
      sym_elseif_command,
      sym_else_command,
      aux_sym_if_condition_repeat1,
    STATE(108), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [900] = 20,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(23), 1,
      sym_elseif,
    ACTIONS(25), 1,
      sym_else,
    ACTIONS(29), 1,
      sym_identifier,
    ACTIONS(37), 1,
      sym_endif,
    STATE(9), 1,
      sym_if_command,
    STATE(131), 1,
      sym_foreach_command,
    STATE(137), 1,
      sym_while_command,
    STATE(146), 1,
      sym_function_command,
    STATE(148), 1,
      sym_macro_command,
    STATE(153), 1,
      sym_block_command,
    STATE(245), 1,
      sym_endif_command,
    ACTIONS(21), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(16), 4,
      sym_body,
      sym_elseif_command,
      sym_else_command,
      aux_sym_if_condition_repeat1,
    STATE(108), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [975] = 20,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(23), 1,
      sym_elseif,
    ACTIONS(25), 1,
      sym_else,
    ACTIONS(27), 1,
      sym_endif,
    ACTIONS(29), 1,
      sym_identifier,
    STATE(9), 1,
      sym_if_command,
    STATE(131), 1,
      sym_foreach_command,
    STATE(137), 1,
      sym_while_command,
    STATE(146), 1,
      sym_function_command,
    STATE(148), 1,
      sym_macro_command,
    STATE(153), 1,
      sym_block_command,
    STATE(431), 1,
      sym_endif_command,
    ACTIONS(21), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(2), 4,
      sym_body,
      sym_elseif_command,
      sym_else_command,
      aux_sym_if_condition_repeat1,
    STATE(108), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [1050] = 19,
    ACTIONS(46), 1,
      sym_if,
    ACTIONS(49), 1,
      sym_elseif,
    ACTIONS(52), 1,
      sym_else,
    ACTIONS(55), 1,
      sym_endif,
    ACTIONS(57), 1,
      sym_foreach,
    ACTIONS(60), 1,
      sym_while,
    ACTIONS(63), 1,
      sym_function,
    ACTIONS(66), 1,
      sym_macro,
    ACTIONS(69), 1,
      sym_block,
    ACTIONS(72), 1,
      sym_identifier,
    STATE(9), 1,
      sym_if_command,
    STATE(131), 1,
      sym_foreach_command,
    STATE(137), 1,
      sym_while_command,
    STATE(146), 1,
      sym_function_command,
    STATE(148), 1,
      sym_macro_command,
    STATE(153), 1,
      sym_block_command,
    ACTIONS(43), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(16), 4,
      sym_body,
      sym_elseif_command,
      sym_else_command,
      aux_sym_if_condition_repeat1,
    STATE(108), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [1122] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_RPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    STATE(642), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [1183] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(91), 1,
      anon_sym_RPAREN,
    STATE(700), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [1244] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(93), 1,
      anon_sym_RPAREN,
    STATE(718), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [1305] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(95), 1,
      anon_sym_RPAREN,
    STATE(753), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [1366] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(97), 1,
      anon_sym_RPAREN,
    STATE(740), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [1427] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(99), 1,
      anon_sym_RPAREN,
    STATE(705), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [1488] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(101), 1,
      anon_sym_RPAREN,
    STATE(796), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [1549] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(103), 1,
      anon_sym_RPAREN,
    STATE(738), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [1610] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(105), 1,
      anon_sym_RPAREN,
    STATE(702), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [1671] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(107), 1,
      anon_sym_RPAREN,
    STATE(794), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [1732] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(109), 1,
      anon_sym_RPAREN,
    STATE(733), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [1793] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(111), 1,
      anon_sym_RPAREN,
    STATE(793), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [1854] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(113), 1,
      anon_sym_RPAREN,
    STATE(701), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [1915] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(115), 1,
      anon_sym_RPAREN,
    STATE(697), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [1976] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(117), 1,
      anon_sym_RPAREN,
    STATE(695), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [2037] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(119), 1,
      anon_sym_RPAREN,
    STATE(693), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [2098] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(121), 1,
      anon_sym_RPAREN,
    STATE(708), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [2159] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(123), 1,
      anon_sym_RPAREN,
    STATE(692), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [2220] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(125), 1,
      anon_sym_RPAREN,
    STATE(685), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [2281] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(127), 1,
      anon_sym_RPAREN,
    STATE(684), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [2342] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(129), 1,
      anon_sym_RPAREN,
    STATE(683), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [2403] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(131), 1,
      anon_sym_RPAREN,
    STATE(670), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [2464] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(133), 1,
      anon_sym_RPAREN,
    STATE(678), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [2525] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(135), 1,
      anon_sym_RPAREN,
    STATE(677), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [2586] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(137), 1,
      anon_sym_RPAREN,
    STATE(676), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [2647] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(139), 1,
      anon_sym_RPAREN,
    STATE(724), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [2708] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(141), 1,
      anon_sym_RPAREN,
    STATE(788), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [2769] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(143), 1,
      anon_sym_RPAREN,
    STATE(784), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [2830] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(145), 1,
      anon_sym_RPAREN,
    STATE(725), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [2891] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(147), 1,
      anon_sym_RPAREN,
    STATE(780), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [2952] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(149), 1,
      anon_sym_RPAREN,
    STATE(775), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [3013] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(151), 1,
      anon_sym_RPAREN,
    STATE(726), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [3074] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(153), 1,
      anon_sym_RPAREN,
    STATE(729), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [3135] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(155), 1,
      anon_sym_RPAREN,
    STATE(674), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [3196] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(157), 1,
      anon_sym_RPAREN,
    STATE(771), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [3257] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(159), 1,
      anon_sym_RPAREN,
    STATE(770), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [3318] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(161), 1,
      anon_sym_RPAREN,
    STATE(673), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [3379] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(163), 1,
      anon_sym_RPAREN,
    STATE(672), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [3440] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(165), 1,
      anon_sym_RPAREN,
    STATE(706), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [3501] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(167), 1,
      anon_sym_RPAREN,
    STATE(736), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [3562] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(169), 1,
      anon_sym_RPAREN,
    STATE(704), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [3623] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(171), 1,
      anon_sym_RPAREN,
    STATE(636), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [3684] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(173), 1,
      anon_sym_RPAREN,
    STATE(637), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [3745] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(175), 1,
      anon_sym_RPAREN,
    STATE(638), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [3806] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(177), 1,
      anon_sym_RPAREN,
    STATE(737), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [3867] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(179), 1,
      anon_sym_RPAREN,
    STATE(694), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [3928] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(181), 1,
      anon_sym_RPAREN,
    STATE(719), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [3989] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(183), 1,
      anon_sym_RPAREN,
    STATE(691), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [4050] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(185), 1,
      anon_sym_RPAREN,
    STATE(769), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [4111] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(187), 1,
      anon_sym_RPAREN,
    STATE(644), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [4172] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(189), 1,
      anon_sym_RPAREN,
    STATE(765), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [4233] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(191), 1,
      anon_sym_RPAREN,
    STATE(647), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [4294] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(193), 1,
      anon_sym_RPAREN,
    STATE(645), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [4355] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(195), 1,
      anon_sym_RPAREN,
    STATE(649), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [4416] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(197), 1,
      anon_sym_RPAREN,
    STATE(643), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [4477] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(199), 1,
      anon_sym_RPAREN,
    STATE(739), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [4538] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(201), 1,
      anon_sym_RPAREN,
    STATE(641), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [4599] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(203), 1,
      anon_sym_RPAREN,
    STATE(652), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [4660] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(205), 1,
      anon_sym_RPAREN,
    STATE(655), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [4721] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(207), 1,
      anon_sym_RPAREN,
    STATE(657), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [4782] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(209), 1,
      anon_sym_RPAREN,
    STATE(762), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [4843] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(211), 1,
      anon_sym_RPAREN,
    STATE(761), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [4904] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(213), 1,
      anon_sym_RPAREN,
    STATE(658), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [4965] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(215), 1,
      anon_sym_RPAREN,
    STATE(659), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [5026] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(217), 1,
      anon_sym_RPAREN,
    STATE(744), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [5087] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(219), 1,
      anon_sym_RPAREN,
    STATE(745), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [5148] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(221), 1,
      anon_sym_RPAREN,
    STATE(746), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [5209] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(223), 1,
      anon_sym_RPAREN,
    STATE(757), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [5270] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(225), 1,
      anon_sym_RPAREN,
    STATE(751), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [5331] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(227), 1,
      anon_sym_RPAREN,
    STATE(752), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [5392] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(229), 1,
      anon_sym_RPAREN,
    STATE(653), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [5453] = 14,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(231), 1,
      anon_sym_RPAREN,
    STATE(712), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [5514] = 13,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    STATE(651), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [5572] = 13,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    STATE(732), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [5630] = 13,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    STATE(717), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [5688] = 13,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    STATE(716), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [5746] = 13,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    STATE(715), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [5804] = 13,
    ACTIONS(236), 1,
      anon_sym_DOLLAR,
    ACTIONS(242), 1,
      anon_sym_LPAREN,
    ACTIONS(245), 1,
      anon_sym_RPAREN,
    ACTIONS(247), 1,
      anon_sym_DQUOTE,
    ACTIONS(250), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(253), 1,
      sym_bracket_argument,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(239), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(94), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(233), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [5862] = 13,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    STATE(714), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [5920] = 13,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    STATE(663), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [5978] = 13,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    STATE(713), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [6036] = 13,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(258), 1,
      anon_sym_RPAREN,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(256), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(105), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [6094] = 13,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(262), 1,
      anon_sym_RPAREN,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(260), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(94), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [6152] = 13,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    STATE(664), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [6210] = 13,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    STATE(654), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [6268] = 13,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    STATE(646), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [6326] = 13,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    STATE(680), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [6384] = 13,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    STATE(662), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [6442] = 13,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    ACTIONS(264), 1,
      anon_sym_RPAREN,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(260), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(94), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [6500] = 13,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(89), 1,
      sym_bracket_argument,
    STATE(648), 1,
      sym_argument_list,
    STATE(222), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    ACTIONS(79), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(99), 4,
      sym_argument,
      sym__untrimmed_argument,
      sym__paren_argument,
      aux_sym__paren_argument_repeat1,
    STATE(157), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [6558] = 16,
    ACTIONS(269), 1,
      sym_if,
    ACTIONS(274), 1,
      sym_foreach,
    ACTIONS(277), 1,
      sym_while,
    ACTIONS(280), 1,
      sym_function,
    ACTIONS(283), 1,
      sym_macro,
    ACTIONS(286), 1,
      sym_block,
    ACTIONS(289), 1,
      sym_identifier,
    STATE(9), 1,
      sym_if_command,
    STATE(131), 1,
      sym_foreach_command,
    STATE(137), 1,
      sym_while_command,
    STATE(146), 1,
      sym_function_command,
    STATE(148), 1,
      sym_macro_command,
    STATE(153), 1,
      sym_block_command,
    ACTIONS(266), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(272), 3,
      sym_elseif,
      sym_else,
      sym_endif,
    STATE(107), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [6620] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(29), 1,
      sym_identifier,
    STATE(9), 1,
      sym_if_command,
    STATE(131), 1,
      sym_foreach_command,
    STATE(137), 1,
      sym_while_command,
    STATE(146), 1,
      sym_function_command,
    STATE(148), 1,
      sym_macro_command,
    STATE(153), 1,
      sym_block_command,
    ACTIONS(292), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(294), 3,
      sym_elseif,
      sym_else,
      sym_endif,
    STATE(107), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [6682] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(298), 1,
      sym_identifier,
    STATE(3), 1,
      sym_if_command,
    STATE(119), 1,
      sym_foreach_command,
    STATE(120), 1,
      sym_while_command,
    STATE(125), 1,
      sym_macro_command,
    STATE(126), 1,
      sym_block_command,
    STATE(150), 1,
      sym_function_command,
    STATE(613), 1,
      sym_body,
    ACTIONS(296), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(112), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [6742] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(302), 1,
      sym_identifier,
    STATE(15), 1,
      sym_if_command,
    STATE(109), 1,
      sym_function_command,
    STATE(122), 1,
      sym_while_command,
    STATE(129), 1,
      sym_macro_command,
    STATE(134), 1,
      sym_block_command,
    STATE(152), 1,
      sym_foreach_command,
    STATE(594), 1,
      sym_body,
    ACTIONS(300), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(127), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [6802] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(302), 1,
      sym_identifier,
    STATE(15), 1,
      sym_if_command,
    STATE(109), 1,
      sym_function_command,
    STATE(122), 1,
      sym_while_command,
    STATE(129), 1,
      sym_macro_command,
    STATE(134), 1,
      sym_block_command,
    STATE(152), 1,
      sym_foreach_command,
    STATE(626), 1,
      sym_body,
    ACTIONS(300), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(127), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [6862] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(294), 1,
      sym_endfunction,
    ACTIONS(298), 1,
      sym_identifier,
    STATE(3), 1,
      sym_if_command,
    STATE(119), 1,
      sym_foreach_command,
    STATE(120), 1,
      sym_while_command,
    STATE(125), 1,
      sym_macro_command,
    STATE(126), 1,
      sym_block_command,
    STATE(150), 1,
      sym_function_command,
    ACTIONS(304), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(151), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [6922] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(308), 1,
      sym_identifier,
    STATE(12), 1,
      sym_if_command,
    STATE(111), 1,
      sym_foreach_command,
    STATE(113), 1,
      sym_while_command,
    STATE(114), 1,
      sym_function_command,
    STATE(115), 1,
      sym_macro_command,
    STATE(116), 1,
      sym_block_command,
    STATE(625), 1,
      sym_body,
    ACTIONS(306), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(130), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [6982] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(298), 1,
      sym_identifier,
    STATE(3), 1,
      sym_if_command,
    STATE(119), 1,
      sym_foreach_command,
    STATE(120), 1,
      sym_while_command,
    STATE(125), 1,
      sym_macro_command,
    STATE(126), 1,
      sym_block_command,
    STATE(150), 1,
      sym_function_command,
    STATE(624), 1,
      sym_body,
    ACTIONS(296), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(112), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [7042] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(312), 1,
      sym_identifier,
    STATE(5), 1,
      sym_if_command,
    STATE(110), 1,
      sym_foreach_command,
    STATE(135), 1,
      sym_while_command,
    STATE(136), 1,
      sym_function_command,
    STATE(139), 1,
      sym_macro_command,
    STATE(141), 1,
      sym_block_command,
    STATE(622), 1,
      sym_body,
    ACTIONS(310), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(154), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [7102] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(316), 1,
      sym_identifier,
    STATE(7), 1,
      sym_if_command,
    STATE(142), 1,
      sym_foreach_command,
    STATE(143), 1,
      sym_while_command,
    STATE(144), 1,
      sym_function_command,
    STATE(145), 1,
      sym_macro_command,
    STATE(147), 1,
      sym_block_command,
    STATE(619), 1,
      sym_body,
    ACTIONS(314), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(140), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [7162] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(308), 1,
      sym_identifier,
    STATE(12), 1,
      sym_if_command,
    STATE(111), 1,
      sym_foreach_command,
    STATE(113), 1,
      sym_while_command,
    STATE(114), 1,
      sym_function_command,
    STATE(115), 1,
      sym_macro_command,
    STATE(116), 1,
      sym_block_command,
    STATE(628), 1,
      sym_body,
    ACTIONS(306), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(130), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [7222] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(302), 1,
      sym_identifier,
    STATE(15), 1,
      sym_if_command,
    STATE(109), 1,
      sym_function_command,
    STATE(122), 1,
      sym_while_command,
    STATE(129), 1,
      sym_macro_command,
    STATE(134), 1,
      sym_block_command,
    STATE(152), 1,
      sym_foreach_command,
    STATE(630), 1,
      sym_body,
    ACTIONS(300), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(127), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [7282] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(302), 1,
      sym_identifier,
    STATE(15), 1,
      sym_if_command,
    STATE(109), 1,
      sym_function_command,
    STATE(122), 1,
      sym_while_command,
    STATE(129), 1,
      sym_macro_command,
    STATE(134), 1,
      sym_block_command,
    STATE(152), 1,
      sym_foreach_command,
    STATE(603), 1,
      sym_body,
    ACTIONS(300), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(127), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [7342] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(308), 1,
      sym_identifier,
    STATE(12), 1,
      sym_if_command,
    STATE(111), 1,
      sym_foreach_command,
    STATE(113), 1,
      sym_while_command,
    STATE(114), 1,
      sym_function_command,
    STATE(115), 1,
      sym_macro_command,
    STATE(116), 1,
      sym_block_command,
    STATE(602), 1,
      sym_body,
    ACTIONS(306), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(130), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [7402] = 16,
    ACTIONS(269), 1,
      sym_if,
    ACTIONS(272), 1,
      sym_endblock,
    ACTIONS(274), 1,
      sym_foreach,
    ACTIONS(277), 1,
      sym_while,
    ACTIONS(280), 1,
      sym_function,
    ACTIONS(283), 1,
      sym_macro,
    ACTIONS(286), 1,
      sym_block,
    ACTIONS(321), 1,
      sym_identifier,
    STATE(7), 1,
      sym_if_command,
    STATE(142), 1,
      sym_foreach_command,
    STATE(143), 1,
      sym_while_command,
    STATE(144), 1,
      sym_function_command,
    STATE(145), 1,
      sym_macro_command,
    STATE(147), 1,
      sym_block_command,
    ACTIONS(318), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(121), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [7462] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(308), 1,
      sym_identifier,
    STATE(12), 1,
      sym_if_command,
    STATE(111), 1,
      sym_foreach_command,
    STATE(113), 1,
      sym_while_command,
    STATE(114), 1,
      sym_function_command,
    STATE(115), 1,
      sym_macro_command,
    STATE(116), 1,
      sym_block_command,
    STATE(607), 1,
      sym_body,
    ACTIONS(306), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(130), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [7522] = 16,
    ACTIONS(269), 1,
      sym_if,
    ACTIONS(272), 1,
      sym_endwhile,
    ACTIONS(274), 1,
      sym_foreach,
    ACTIONS(277), 1,
      sym_while,
    ACTIONS(280), 1,
      sym_function,
    ACTIONS(283), 1,
      sym_macro,
    ACTIONS(286), 1,
      sym_block,
    ACTIONS(327), 1,
      sym_identifier,
    STATE(12), 1,
      sym_if_command,
    STATE(111), 1,
      sym_foreach_command,
    STATE(113), 1,
      sym_while_command,
    STATE(114), 1,
      sym_function_command,
    STATE(115), 1,
      sym_macro_command,
    STATE(116), 1,
      sym_block_command,
    ACTIONS(324), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(123), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [7582] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(312), 1,
      sym_identifier,
    STATE(5), 1,
      sym_if_command,
    STATE(110), 1,
      sym_foreach_command,
    STATE(135), 1,
      sym_while_command,
    STATE(136), 1,
      sym_function_command,
    STATE(139), 1,
      sym_macro_command,
    STATE(141), 1,
      sym_block_command,
    STATE(617), 1,
      sym_body,
    ACTIONS(310), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(154), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [7642] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(312), 1,
      sym_identifier,
    STATE(5), 1,
      sym_if_command,
    STATE(110), 1,
      sym_foreach_command,
    STATE(135), 1,
      sym_while_command,
    STATE(136), 1,
      sym_function_command,
    STATE(139), 1,
      sym_macro_command,
    STATE(141), 1,
      sym_block_command,
    STATE(600), 1,
      sym_body,
    ACTIONS(310), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(154), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [7702] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(316), 1,
      sym_identifier,
    STATE(7), 1,
      sym_if_command,
    STATE(142), 1,
      sym_foreach_command,
    STATE(143), 1,
      sym_while_command,
    STATE(144), 1,
      sym_function_command,
    STATE(145), 1,
      sym_macro_command,
    STATE(147), 1,
      sym_block_command,
    STATE(599), 1,
      sym_body,
    ACTIONS(314), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(140), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [7762] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(294), 1,
      sym_endforeach,
    ACTIONS(302), 1,
      sym_identifier,
    STATE(15), 1,
      sym_if_command,
    STATE(109), 1,
      sym_function_command,
    STATE(122), 1,
      sym_while_command,
    STATE(129), 1,
      sym_macro_command,
    STATE(134), 1,
      sym_block_command,
    STATE(152), 1,
      sym_foreach_command,
    ACTIONS(330), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(132), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [7822] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(298), 1,
      sym_identifier,
    STATE(3), 1,
      sym_if_command,
    STATE(119), 1,
      sym_foreach_command,
    STATE(120), 1,
      sym_while_command,
    STATE(125), 1,
      sym_macro_command,
    STATE(126), 1,
      sym_block_command,
    STATE(150), 1,
      sym_function_command,
    STATE(618), 1,
      sym_body,
    ACTIONS(296), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(112), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [7882] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(312), 1,
      sym_identifier,
    STATE(5), 1,
      sym_if_command,
    STATE(110), 1,
      sym_foreach_command,
    STATE(135), 1,
      sym_while_command,
    STATE(136), 1,
      sym_function_command,
    STATE(139), 1,
      sym_macro_command,
    STATE(141), 1,
      sym_block_command,
    STATE(596), 1,
      sym_body,
    ACTIONS(310), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(154), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [7942] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(294), 1,
      sym_endwhile,
    ACTIONS(308), 1,
      sym_identifier,
    STATE(12), 1,
      sym_if_command,
    STATE(111), 1,
      sym_foreach_command,
    STATE(113), 1,
      sym_while_command,
    STATE(114), 1,
      sym_function_command,
    STATE(115), 1,
      sym_macro_command,
    STATE(116), 1,
      sym_block_command,
    ACTIONS(332), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(123), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8002] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(302), 1,
      sym_identifier,
    STATE(15), 1,
      sym_if_command,
    STATE(109), 1,
      sym_function_command,
    STATE(122), 1,
      sym_while_command,
    STATE(129), 1,
      sym_macro_command,
    STATE(134), 1,
      sym_block_command,
    STATE(152), 1,
      sym_foreach_command,
    STATE(631), 1,
      sym_body,
    ACTIONS(300), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(127), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8062] = 16,
    ACTIONS(269), 1,
      sym_if,
    ACTIONS(272), 1,
      sym_endforeach,
    ACTIONS(274), 1,
      sym_foreach,
    ACTIONS(277), 1,
      sym_while,
    ACTIONS(280), 1,
      sym_function,
    ACTIONS(283), 1,
      sym_macro,
    ACTIONS(286), 1,
      sym_block,
    ACTIONS(337), 1,
      sym_identifier,
    STATE(15), 1,
      sym_if_command,
    STATE(109), 1,
      sym_function_command,
    STATE(122), 1,
      sym_while_command,
    STATE(129), 1,
      sym_macro_command,
    STATE(134), 1,
      sym_block_command,
    STATE(152), 1,
      sym_foreach_command,
    ACTIONS(334), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(132), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8122] = 16,
    ACTIONS(269), 1,
      sym_if,
    ACTIONS(274), 1,
      sym_foreach,
    ACTIONS(277), 1,
      sym_while,
    ACTIONS(280), 1,
      sym_function,
    ACTIONS(283), 1,
      sym_macro,
    ACTIONS(286), 1,
      sym_block,
    ACTIONS(340), 1,
      ts_builtin_sym_end,
    ACTIONS(345), 1,
      sym_identifier,
    STATE(10), 1,
      sym_if_command,
    STATE(117), 1,
      sym_while_command,
    STATE(118), 1,
      sym_foreach_command,
    STATE(124), 1,
      sym_macro_command,
    STATE(128), 1,
      sym_function_command,
    STATE(149), 1,
      sym_block_command,
    ACTIONS(342), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(133), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8182] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(316), 1,
      sym_identifier,
    STATE(7), 1,
      sym_if_command,
    STATE(142), 1,
      sym_foreach_command,
    STATE(143), 1,
      sym_while_command,
    STATE(144), 1,
      sym_function_command,
    STATE(145), 1,
      sym_macro_command,
    STATE(147), 1,
      sym_block_command,
    STATE(634), 1,
      sym_body,
    ACTIONS(314), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(140), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8242] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(308), 1,
      sym_identifier,
    STATE(12), 1,
      sym_if_command,
    STATE(111), 1,
      sym_foreach_command,
    STATE(113), 1,
      sym_while_command,
    STATE(114), 1,
      sym_function_command,
    STATE(115), 1,
      sym_macro_command,
    STATE(116), 1,
      sym_block_command,
    STATE(593), 1,
      sym_body,
    ACTIONS(306), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(130), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8302] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(298), 1,
      sym_identifier,
    STATE(3), 1,
      sym_if_command,
    STATE(119), 1,
      sym_foreach_command,
    STATE(120), 1,
      sym_while_command,
    STATE(125), 1,
      sym_macro_command,
    STATE(126), 1,
      sym_block_command,
    STATE(150), 1,
      sym_function_command,
    STATE(591), 1,
      sym_body,
    ACTIONS(296), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(112), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8362] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(308), 1,
      sym_identifier,
    STATE(12), 1,
      sym_if_command,
    STATE(111), 1,
      sym_foreach_command,
    STATE(113), 1,
      sym_while_command,
    STATE(114), 1,
      sym_function_command,
    STATE(115), 1,
      sym_macro_command,
    STATE(116), 1,
      sym_block_command,
    STATE(629), 1,
      sym_body,
    ACTIONS(306), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(130), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8422] = 16,
    ACTIONS(269), 1,
      sym_if,
    ACTIONS(272), 1,
      sym_endmacro,
    ACTIONS(274), 1,
      sym_foreach,
    ACTIONS(277), 1,
      sym_while,
    ACTIONS(280), 1,
      sym_function,
    ACTIONS(283), 1,
      sym_macro,
    ACTIONS(286), 1,
      sym_block,
    ACTIONS(351), 1,
      sym_identifier,
    STATE(5), 1,
      sym_if_command,
    STATE(110), 1,
      sym_foreach_command,
    STATE(135), 1,
      sym_while_command,
    STATE(136), 1,
      sym_function_command,
    STATE(139), 1,
      sym_macro_command,
    STATE(141), 1,
      sym_block_command,
    ACTIONS(348), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(138), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8482] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(312), 1,
      sym_identifier,
    STATE(5), 1,
      sym_if_command,
    STATE(110), 1,
      sym_foreach_command,
    STATE(135), 1,
      sym_while_command,
    STATE(136), 1,
      sym_function_command,
    STATE(139), 1,
      sym_macro_command,
    STATE(141), 1,
      sym_block_command,
    STATE(590), 1,
      sym_body,
    ACTIONS(310), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(154), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8542] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(294), 1,
      sym_endblock,
    ACTIONS(316), 1,
      sym_identifier,
    STATE(7), 1,
      sym_if_command,
    STATE(142), 1,
      sym_foreach_command,
    STATE(143), 1,
      sym_while_command,
    STATE(144), 1,
      sym_function_command,
    STATE(145), 1,
      sym_macro_command,
    STATE(147), 1,
      sym_block_command,
    ACTIONS(354), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(121), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8602] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(316), 1,
      sym_identifier,
    STATE(7), 1,
      sym_if_command,
    STATE(142), 1,
      sym_foreach_command,
    STATE(143), 1,
      sym_while_command,
    STATE(144), 1,
      sym_function_command,
    STATE(145), 1,
      sym_macro_command,
    STATE(147), 1,
      sym_block_command,
    STATE(589), 1,
      sym_body,
    ACTIONS(314), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(140), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8662] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(302), 1,
      sym_identifier,
    STATE(15), 1,
      sym_if_command,
    STATE(109), 1,
      sym_function_command,
    STATE(122), 1,
      sym_while_command,
    STATE(129), 1,
      sym_macro_command,
    STATE(134), 1,
      sym_block_command,
    STATE(152), 1,
      sym_foreach_command,
    STATE(608), 1,
      sym_body,
    ACTIONS(300), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(127), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8722] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(308), 1,
      sym_identifier,
    STATE(12), 1,
      sym_if_command,
    STATE(111), 1,
      sym_foreach_command,
    STATE(113), 1,
      sym_while_command,
    STATE(114), 1,
      sym_function_command,
    STATE(115), 1,
      sym_macro_command,
    STATE(116), 1,
      sym_block_command,
    STATE(609), 1,
      sym_body,
    ACTIONS(306), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(130), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8782] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(298), 1,
      sym_identifier,
    STATE(3), 1,
      sym_if_command,
    STATE(119), 1,
      sym_foreach_command,
    STATE(120), 1,
      sym_while_command,
    STATE(125), 1,
      sym_macro_command,
    STATE(126), 1,
      sym_block_command,
    STATE(150), 1,
      sym_function_command,
    STATE(610), 1,
      sym_body,
    ACTIONS(296), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(112), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8842] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(312), 1,
      sym_identifier,
    STATE(5), 1,
      sym_if_command,
    STATE(110), 1,
      sym_foreach_command,
    STATE(135), 1,
      sym_while_command,
    STATE(136), 1,
      sym_function_command,
    STATE(139), 1,
      sym_macro_command,
    STATE(141), 1,
      sym_block_command,
    STATE(611), 1,
      sym_body,
    ACTIONS(310), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(154), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8902] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(298), 1,
      sym_identifier,
    STATE(3), 1,
      sym_if_command,
    STATE(119), 1,
      sym_foreach_command,
    STATE(120), 1,
      sym_while_command,
    STATE(125), 1,
      sym_macro_command,
    STATE(126), 1,
      sym_block_command,
    STATE(150), 1,
      sym_function_command,
    STATE(623), 1,
      sym_body,
    ACTIONS(296), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(112), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [8962] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(316), 1,
      sym_identifier,
    STATE(7), 1,
      sym_if_command,
    STATE(142), 1,
      sym_foreach_command,
    STATE(143), 1,
      sym_while_command,
    STATE(144), 1,
      sym_function_command,
    STATE(145), 1,
      sym_macro_command,
    STATE(147), 1,
      sym_block_command,
    STATE(612), 1,
      sym_body,
    ACTIONS(314), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(140), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [9022] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(312), 1,
      sym_identifier,
    STATE(5), 1,
      sym_if_command,
    STATE(110), 1,
      sym_foreach_command,
    STATE(135), 1,
      sym_while_command,
    STATE(136), 1,
      sym_function_command,
    STATE(139), 1,
      sym_macro_command,
    STATE(141), 1,
      sym_block_command,
    STATE(621), 1,
      sym_body,
    ACTIONS(310), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(154), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [9082] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(316), 1,
      sym_identifier,
    STATE(7), 1,
      sym_if_command,
    STATE(142), 1,
      sym_foreach_command,
    STATE(143), 1,
      sym_while_command,
    STATE(144), 1,
      sym_function_command,
    STATE(145), 1,
      sym_macro_command,
    STATE(147), 1,
      sym_block_command,
    STATE(615), 1,
      sym_body,
    ACTIONS(314), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(140), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [9142] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(298), 1,
      sym_identifier,
    STATE(3), 1,
      sym_if_command,
    STATE(119), 1,
      sym_foreach_command,
    STATE(120), 1,
      sym_while_command,
    STATE(125), 1,
      sym_macro_command,
    STATE(126), 1,
      sym_block_command,
    STATE(150), 1,
      sym_function_command,
    STATE(601), 1,
      sym_body,
    ACTIONS(296), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(112), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [9202] = 16,
    ACTIONS(269), 1,
      sym_if,
    ACTIONS(272), 1,
      sym_endfunction,
    ACTIONS(274), 1,
      sym_foreach,
    ACTIONS(277), 1,
      sym_while,
    ACTIONS(280), 1,
      sym_function,
    ACTIONS(283), 1,
      sym_macro,
    ACTIONS(286), 1,
      sym_block,
    ACTIONS(359), 1,
      sym_identifier,
    STATE(3), 1,
      sym_if_command,
    STATE(119), 1,
      sym_foreach_command,
    STATE(120), 1,
      sym_while_command,
    STATE(125), 1,
      sym_macro_command,
    STATE(126), 1,
      sym_block_command,
    STATE(150), 1,
      sym_function_command,
    ACTIONS(356), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(151), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [9262] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(302), 1,
      sym_identifier,
    STATE(15), 1,
      sym_if_command,
    STATE(109), 1,
      sym_function_command,
    STATE(122), 1,
      sym_while_command,
    STATE(129), 1,
      sym_macro_command,
    STATE(134), 1,
      sym_block_command,
    STATE(152), 1,
      sym_foreach_command,
    STATE(604), 1,
      sym_body,
    ACTIONS(300), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(127), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [9322] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(316), 1,
      sym_identifier,
    STATE(7), 1,
      sym_if_command,
    STATE(142), 1,
      sym_foreach_command,
    STATE(143), 1,
      sym_while_command,
    STATE(144), 1,
      sym_function_command,
    STATE(145), 1,
      sym_macro_command,
    STATE(147), 1,
      sym_block_command,
    STATE(616), 1,
      sym_body,
    ACTIONS(314), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(140), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [9382] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(294), 1,
      sym_endmacro,
    ACTIONS(312), 1,
      sym_identifier,
    STATE(5), 1,
      sym_if_command,
    STATE(110), 1,
      sym_foreach_command,
    STATE(135), 1,
      sym_while_command,
    STATE(136), 1,
      sym_function_command,
    STATE(139), 1,
      sym_macro_command,
    STATE(141), 1,
      sym_block_command,
    ACTIONS(362), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(138), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [9442] = 16,
    ACTIONS(7), 1,
      sym_if,
    ACTIONS(9), 1,
      sym_foreach,
    ACTIONS(11), 1,
      sym_while,
    ACTIONS(13), 1,
      sym_function,
    ACTIONS(15), 1,
      sym_macro,
    ACTIONS(17), 1,
      sym_block,
    ACTIONS(19), 1,
      sym_identifier,
    ACTIONS(364), 1,
      ts_builtin_sym_end,
    STATE(10), 1,
      sym_if_command,
    STATE(117), 1,
      sym_while_command,
    STATE(118), 1,
      sym_foreach_command,
    STATE(124), 1,
      sym_macro_command,
    STATE(128), 1,
      sym_function_command,
    STATE(149), 1,
      sym_block_command,
    ACTIONS(366), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    STATE(133), 10,
      sym_if_condition,
      sym_foreach_loop,
      sym_while_loop,
      sym_function_def,
      sym_macro_def,
      sym_block_def,
      sym_normal_command,
      sym__command_invocation,
      sym__untrimmed_command_invocation,
      aux_sym_source_file_repeat1,
  [9502] = 7,
    ACTIONS(371), 1,
      anon_sym_DOLLAR,
    ACTIONS(376), 1,
      aux_sym__unquoted_text_token1,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(156), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(368), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    ACTIONS(374), 7,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [9542] = 7,
    ACTIONS(77), 1,
      anon_sym_DOLLAR,
    ACTIONS(381), 1,
      aux_sym__unquoted_text_token1,
    STATE(223), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(215), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(156), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(75), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
    ACTIONS(379), 7,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [9582] = 11,
    ACTIONS(385), 1,
      anon_sym_DOLLAR,
    ACTIONS(387), 1,
      anon_sym_RPAREN,
    ACTIONS(389), 1,
      anon_sym_DQUOTE,
    ACTIONS(391), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(393), 1,
      sym_bracket_argument,
    STATE(754), 1,
      sym_argument,
    STATE(464), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(760), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(463), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(194), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(383), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [9629] = 11,
    ACTIONS(385), 1,
      anon_sym_DOLLAR,
    ACTIONS(389), 1,
      anon_sym_DQUOTE,
    ACTIONS(391), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(393), 1,
      sym_bracket_argument,
    ACTIONS(395), 1,
      anon_sym_RPAREN,
    STATE(671), 1,
      sym_argument,
    STATE(464), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(760), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(463), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(194), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(383), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [9676] = 11,
    ACTIONS(385), 1,
      anon_sym_DOLLAR,
    ACTIONS(389), 1,
      anon_sym_DQUOTE,
    ACTIONS(391), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(393), 1,
      sym_bracket_argument,
    ACTIONS(397), 1,
      anon_sym_RPAREN,
    STATE(688), 1,
      sym_argument,
    STATE(464), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(760), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(463), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(194), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(383), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [9723] = 11,
    ACTIONS(385), 1,
      anon_sym_DOLLAR,
    ACTIONS(389), 1,
      anon_sym_DQUOTE,
    ACTIONS(391), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(393), 1,
      sym_bracket_argument,
    ACTIONS(399), 1,
      anon_sym_RPAREN,
    STATE(772), 1,
      sym_argument,
    STATE(464), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(760), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(463), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(194), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(383), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [9770] = 11,
    ACTIONS(385), 1,
      anon_sym_DOLLAR,
    ACTIONS(389), 1,
      anon_sym_DQUOTE,
    ACTIONS(391), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(393), 1,
      sym_bracket_argument,
    ACTIONS(401), 1,
      anon_sym_RPAREN,
    STATE(785), 1,
      sym_argument,
    STATE(464), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(760), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(463), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(194), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(383), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [9817] = 11,
    ACTIONS(385), 1,
      anon_sym_DOLLAR,
    ACTIONS(389), 1,
      anon_sym_DQUOTE,
    ACTIONS(391), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(393), 1,
      sym_bracket_argument,
    ACTIONS(403), 1,
      anon_sym_RPAREN,
    STATE(727), 1,
      sym_argument,
    STATE(464), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(760), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(463), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(194), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(383), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [9864] = 11,
    ACTIONS(385), 1,
      anon_sym_DOLLAR,
    ACTIONS(389), 1,
      anon_sym_DQUOTE,
    ACTIONS(391), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(393), 1,
      sym_bracket_argument,
    ACTIONS(405), 1,
      anon_sym_RPAREN,
    STATE(675), 1,
      sym_argument,
    STATE(464), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(760), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(463), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(194), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(383), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [9911] = 11,
    ACTIONS(385), 1,
      anon_sym_DOLLAR,
    ACTIONS(389), 1,
      anon_sym_DQUOTE,
    ACTIONS(391), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(393), 1,
      sym_bracket_argument,
    ACTIONS(407), 1,
      anon_sym_RPAREN,
    STATE(747), 1,
      sym_argument,
    STATE(464), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(760), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(463), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(194), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(383), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [9958] = 11,
    ACTIONS(385), 1,
      anon_sym_DOLLAR,
    ACTIONS(389), 1,
      anon_sym_DQUOTE,
    ACTIONS(391), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(393), 1,
      sym_bracket_argument,
    ACTIONS(409), 1,
      anon_sym_RPAREN,
    STATE(656), 1,
      sym_argument,
    STATE(464), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(760), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(463), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(194), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(383), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [10005] = 11,
    ACTIONS(385), 1,
      anon_sym_DOLLAR,
    ACTIONS(389), 1,
      anon_sym_DQUOTE,
    ACTIONS(391), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(393), 1,
      sym_bracket_argument,
    ACTIONS(411), 1,
      anon_sym_RPAREN,
    STATE(650), 1,
      sym_argument,
    STATE(464), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(760), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(463), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(194), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(383), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [10052] = 11,
    ACTIONS(385), 1,
      anon_sym_DOLLAR,
    ACTIONS(389), 1,
      anon_sym_DQUOTE,
    ACTIONS(391), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(393), 1,
      sym_bracket_argument,
    ACTIONS(413), 1,
      anon_sym_RPAREN,
    STATE(696), 1,
      sym_argument,
    STATE(464), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(760), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(463), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(194), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(383), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [10099] = 11,
    ACTIONS(385), 1,
      anon_sym_DOLLAR,
    ACTIONS(389), 1,
      anon_sym_DQUOTE,
    ACTIONS(391), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(393), 1,
      sym_bracket_argument,
    ACTIONS(415), 1,
      anon_sym_RPAREN,
    STATE(720), 1,
      sym_argument,
    STATE(464), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(760), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(463), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(194), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(383), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [10146] = 11,
    ACTIONS(385), 1,
      anon_sym_DOLLAR,
    ACTIONS(389), 1,
      anon_sym_DQUOTE,
    ACTIONS(391), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(393), 1,
      sym_bracket_argument,
    ACTIONS(417), 1,
      anon_sym_RPAREN,
    STATE(699), 1,
      sym_argument,
    STATE(464), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(760), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(463), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(194), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(383), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [10193] = 11,
    ACTIONS(385), 1,
      anon_sym_DOLLAR,
    ACTIONS(389), 1,
      anon_sym_DQUOTE,
    ACTIONS(391), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(393), 1,
      sym_bracket_argument,
    ACTIONS(419), 1,
      anon_sym_RPAREN,
    STATE(728), 1,
      sym_argument,
    STATE(464), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(760), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(463), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(194), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(383), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [10240] = 10,
    ACTIONS(423), 1,
      anon_sym_DOLLAR,
    ACTIONS(425), 1,
      anon_sym_DQUOTE,
    ACTIONS(427), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(429), 1,
      sym_bracket_argument,
    STATE(686), 1,
      sym_argument,
    STATE(457), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(781), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(456), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(193), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(421), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [10284] = 10,
    ACTIONS(423), 1,
      anon_sym_DOLLAR,
    ACTIONS(425), 1,
      anon_sym_DQUOTE,
    ACTIONS(427), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(429), 1,
      sym_bracket_argument,
    STATE(668), 1,
      sym_argument,
    STATE(457), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(781), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(456), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(193), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(421), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [10328] = 10,
    ACTIONS(423), 1,
      anon_sym_DOLLAR,
    ACTIONS(425), 1,
      anon_sym_DQUOTE,
    ACTIONS(427), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(429), 1,
      sym_bracket_argument,
    STATE(735), 1,
      sym_argument,
    STATE(457), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(781), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(456), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(193), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(421), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [10372] = 10,
    ACTIONS(423), 1,
      anon_sym_DOLLAR,
    ACTIONS(425), 1,
      anon_sym_DQUOTE,
    ACTIONS(427), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(429), 1,
      sym_bracket_argument,
    STATE(734), 1,
      sym_argument,
    STATE(457), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(781), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(456), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(193), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(421), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [10416] = 10,
    ACTIONS(423), 1,
      anon_sym_DOLLAR,
    ACTIONS(425), 1,
      anon_sym_DQUOTE,
    ACTIONS(427), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(429), 1,
      sym_bracket_argument,
    STATE(711), 1,
      sym_argument,
    STATE(457), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(781), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(456), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(193), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(421), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [10460] = 10,
    ACTIONS(423), 1,
      anon_sym_DOLLAR,
    ACTIONS(425), 1,
      anon_sym_DQUOTE,
    ACTIONS(427), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(429), 1,
      sym_bracket_argument,
    STATE(776), 1,
      sym_argument,
    STATE(457), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(781), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(456), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(193), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(421), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [10504] = 10,
    ACTIONS(423), 1,
      anon_sym_DOLLAR,
    ACTIONS(425), 1,
      anon_sym_DQUOTE,
    ACTIONS(427), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(429), 1,
      sym_bracket_argument,
    STATE(710), 1,
      sym_argument,
    STATE(457), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(781), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(456), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(193), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(421), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [10548] = 10,
    ACTIONS(423), 1,
      anon_sym_DOLLAR,
    ACTIONS(425), 1,
      anon_sym_DQUOTE,
    ACTIONS(427), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(429), 1,
      sym_bracket_argument,
    STATE(731), 1,
      sym_argument,
    STATE(457), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(781), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(456), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(193), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(421), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [10592] = 10,
    ACTIONS(423), 1,
      anon_sym_DOLLAR,
    ACTIONS(425), 1,
      anon_sym_DQUOTE,
    ACTIONS(427), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(429), 1,
      sym_bracket_argument,
    STATE(750), 1,
      sym_argument,
    STATE(457), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(781), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(456), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(193), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(421), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [10636] = 10,
    ACTIONS(423), 1,
      anon_sym_DOLLAR,
    ACTIONS(425), 1,
      anon_sym_DQUOTE,
    ACTIONS(427), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(429), 1,
      sym_bracket_argument,
    STATE(755), 1,
      sym_argument,
    STATE(457), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(781), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(456), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(193), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(421), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [10680] = 10,
    ACTIONS(423), 1,
      anon_sym_DOLLAR,
    ACTIONS(425), 1,
      anon_sym_DQUOTE,
    ACTIONS(427), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(429), 1,
      sym_bracket_argument,
    STATE(777), 1,
      sym_argument,
    STATE(457), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(781), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(456), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(193), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(421), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [10724] = 10,
    ACTIONS(423), 1,
      anon_sym_DOLLAR,
    ACTIONS(425), 1,
      anon_sym_DQUOTE,
    ACTIONS(427), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(429), 1,
      sym_bracket_argument,
    STATE(687), 1,
      sym_argument,
    STATE(457), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(781), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(456), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(193), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(421), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [10768] = 10,
    ACTIONS(423), 1,
      anon_sym_DOLLAR,
    ACTIONS(425), 1,
      anon_sym_DQUOTE,
    ACTIONS(427), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(429), 1,
      sym_bracket_argument,
    STATE(756), 1,
      sym_argument,
    STATE(457), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(781), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(456), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(193), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(421), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [10812] = 10,
    ACTIONS(423), 1,
      anon_sym_DOLLAR,
    ACTIONS(425), 1,
      anon_sym_DQUOTE,
    ACTIONS(427), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(429), 1,
      sym_bracket_argument,
    STATE(669), 1,
      sym_argument,
    STATE(457), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(781), 2,
      sym_quoted_argument,
      sym_unquoted_argument,
    STATE(456), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(193), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(421), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [10856] = 8,
    ACTIONS(433), 1,
      anon_sym_DOLLAR,
    ACTIONS(435), 1,
      anon_sym_DQUOTE,
    ACTIONS(437), 1,
      aux_sym__quoted_text_token1,
    STATE(763), 1,
      sym_quoted_element,
    STATE(469), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(465), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(192), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__quoted_text,
      aux_sym_quoted_element_repeat1,
      aux_sym__quoted_text_repeat1,
    ACTIONS(431), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [10893] = 8,
    ACTIONS(433), 1,
      anon_sym_DOLLAR,
    ACTIONS(437), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(439), 1,
      anon_sym_DQUOTE,
    STATE(665), 1,
      sym_quoted_element,
    STATE(469), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(465), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(192), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__quoted_text,
      aux_sym_quoted_element_repeat1,
      aux_sym__quoted_text_repeat1,
    ACTIONS(431), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [10930] = 8,
    ACTIONS(433), 1,
      anon_sym_DOLLAR,
    ACTIONS(437), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(441), 1,
      anon_sym_DQUOTE,
    STATE(795), 1,
      sym_quoted_element,
    STATE(469), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(465), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(192), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__quoted_text,
      aux_sym_quoted_element_repeat1,
      aux_sym__quoted_text_repeat1,
    ACTIONS(431), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [10967] = 7,
    ACTIONS(446), 1,
      anon_sym_DOLLAR,
    ACTIONS(449), 1,
      anon_sym_DQUOTE,
    ACTIONS(451), 1,
      aux_sym__quoted_text_token1,
    STATE(469), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(465), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(189), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__quoted_text,
      aux_sym_quoted_element_repeat1,
      aux_sym__quoted_text_repeat1,
    ACTIONS(443), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [11001] = 7,
    ACTIONS(374), 1,
      anon_sym_RPAREN,
    ACTIONS(457), 1,
      anon_sym_DOLLAR,
    ACTIONS(460), 1,
      aux_sym__unquoted_text_token1,
    STATE(464), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(463), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(190), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(454), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [11035] = 7,
    ACTIONS(466), 1,
      anon_sym_DOLLAR,
    ACTIONS(469), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(472), 1,
      aux_sym_endwhile_command_token1,
    STATE(457), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(456), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(191), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(463), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [11069] = 7,
    ACTIONS(433), 1,
      anon_sym_DOLLAR,
    ACTIONS(474), 1,
      anon_sym_DQUOTE,
    ACTIONS(476), 1,
      aux_sym__quoted_text_token1,
    STATE(469), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(465), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(189), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__quoted_text,
      aux_sym_quoted_element_repeat1,
      aux_sym__quoted_text_repeat1,
    ACTIONS(431), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [11103] = 7,
    ACTIONS(423), 1,
      anon_sym_DOLLAR,
    ACTIONS(478), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(480), 1,
      aux_sym_endwhile_command_token1,
    STATE(457), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(456), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(191), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(421), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [11137] = 7,
    ACTIONS(379), 1,
      anon_sym_RPAREN,
    ACTIONS(385), 1,
      anon_sym_DOLLAR,
    ACTIONS(482), 1,
      aux_sym__unquoted_text_token1,
    STATE(464), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(463), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    STATE(190), 5,
      sym_escape_sequence,
      sym_variable_ref,
      sym__unquoted_text,
      aux_sym_unquoted_argument_repeat1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(383), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [11171] = 5,
    ACTIONS(486), 1,
      anon_sym_LBRACE,
    ACTIONS(488), 1,
      anon_sym_ENV,
    ACTIONS(490), 1,
      anon_sym_CACHE,
    ACTIONS(492), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(484), 14,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [11200] = 7,
    ACTIONS(496), 1,
      aux_sym_variable_token1,
    ACTIONS(498), 1,
      anon_sym_DOLLAR,
    STATE(723), 1,
      sym_variable,
    STATE(453), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(205), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(462), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(494), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [11232] = 7,
    ACTIONS(496), 1,
      aux_sym_variable_token1,
    ACTIONS(498), 1,
      anon_sym_DOLLAR,
    STATE(679), 1,
      sym_variable,
    STATE(453), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(205), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(462), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(494), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [11264] = 7,
    ACTIONS(496), 1,
      aux_sym_variable_token1,
    ACTIONS(498), 1,
      anon_sym_DOLLAR,
    STATE(703), 1,
      sym_variable,
    STATE(453), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(205), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(462), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(494), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [11296] = 7,
    ACTIONS(496), 1,
      aux_sym_variable_token1,
    ACTIONS(498), 1,
      anon_sym_DOLLAR,
    STATE(773), 1,
      sym_variable,
    STATE(453), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(205), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(462), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(494), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [11328] = 7,
    ACTIONS(503), 1,
      aux_sym_variable_token1,
    ACTIONS(506), 1,
      anon_sym_DOLLAR,
    ACTIONS(509), 1,
      anon_sym_RBRACE,
    STATE(453), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(200), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(462), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(500), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [11360] = 7,
    ACTIONS(496), 1,
      aux_sym_variable_token1,
    ACTIONS(498), 1,
      anon_sym_DOLLAR,
    STATE(758), 1,
      sym_variable,
    STATE(453), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(205), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(462), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(494), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [11392] = 7,
    ACTIONS(496), 1,
      aux_sym_variable_token1,
    ACTIONS(498), 1,
      anon_sym_DOLLAR,
    STATE(792), 1,
      sym_variable,
    STATE(453), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(205), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(462), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(494), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [11424] = 7,
    ACTIONS(496), 1,
      aux_sym_variable_token1,
    ACTIONS(498), 1,
      anon_sym_DOLLAR,
    STATE(690), 1,
      sym_variable,
    STATE(453), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(205), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(462), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(494), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [11456] = 7,
    ACTIONS(496), 1,
      aux_sym_variable_token1,
    ACTIONS(498), 1,
      anon_sym_DOLLAR,
    STATE(689), 1,
      sym_variable,
    STATE(453), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(205), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(462), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(494), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [11488] = 7,
    ACTIONS(498), 1,
      anon_sym_DOLLAR,
    ACTIONS(511), 1,
      aux_sym_variable_token1,
    ACTIONS(513), 1,
      anon_sym_RBRACE,
    STATE(453), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(200), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(462), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(494), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [11520] = 7,
    ACTIONS(496), 1,
      aux_sym_variable_token1,
    ACTIONS(498), 1,
      anon_sym_DOLLAR,
    STATE(707), 1,
      sym_variable,
    STATE(453), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(205), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(462), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(494), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [11552] = 7,
    ACTIONS(496), 1,
      aux_sym_variable_token1,
    ACTIONS(498), 1,
      anon_sym_DOLLAR,
    STATE(698), 1,
      sym_variable,
    STATE(453), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(205), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(462), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(494), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [11584] = 7,
    ACTIONS(496), 1,
      aux_sym_variable_token1,
    ACTIONS(498), 1,
      anon_sym_DOLLAR,
    STATE(721), 1,
      sym_variable,
    STATE(453), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(205), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(462), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(494), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [11616] = 7,
    ACTIONS(496), 1,
      aux_sym_variable_token1,
    ACTIONS(498), 1,
      anon_sym_DOLLAR,
    STATE(722), 1,
      sym_variable,
    STATE(453), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(205), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(462), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(494), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [11648] = 7,
    ACTIONS(496), 1,
      aux_sym_variable_token1,
    ACTIONS(498), 1,
      anon_sym_DOLLAR,
    STATE(730), 1,
      sym_variable,
    STATE(453), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(205), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(462), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(494), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [11680] = 7,
    ACTIONS(496), 1,
      aux_sym_variable_token1,
    ACTIONS(498), 1,
      anon_sym_DOLLAR,
    STATE(749), 1,
      sym_variable,
    STATE(453), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(205), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(462), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(494), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [11712] = 7,
    ACTIONS(496), 1,
      aux_sym_variable_token1,
    ACTIONS(498), 1,
      anon_sym_DOLLAR,
    STATE(748), 1,
      sym_variable,
    STATE(453), 2,
      sym__escape_encoded,
      sym__escape_semicolon,
    STATE(205), 3,
      sym_escape_sequence,
      sym_variable_ref,
      aux_sym_variable_repeat1,
    STATE(462), 3,
      sym_normal_var,
      sym_env_var,
      sym_cache_var,
    ACTIONS(494), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [11744] = 4,
    ACTIONS(517), 1,
      anon_sym_DOLLAR,
    ACTIONS(520), 1,
      aux_sym__unquoted_text_token1,
    STATE(213), 1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(515), 13,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [11769] = 2,
    ACTIONS(525), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(523), 14,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [11789] = 2,
    ACTIONS(529), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(527), 14,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [11809] = 2,
    ACTIONS(533), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(531), 14,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [11829] = 2,
    ACTIONS(537), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(535), 14,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [11849] = 2,
    ACTIONS(541), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(539), 14,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [11869] = 2,
    ACTIONS(545), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(543), 14,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [11889] = 2,
    ACTIONS(549), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(547), 14,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [11909] = 2,
    ACTIONS(553), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(551), 14,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [11929] = 2,
    ACTIONS(557), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(555), 14,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [11949] = 2,
    ACTIONS(561), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(559), 14,
      sym_bracket_argument,
      sym_bracket_comment,
      sym_line_comment,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      aux_sym__untrimmed_argument_token1,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
  [11969] = 2,
    ACTIONS(563), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(565), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [11987] = 2,
    ACTIONS(567), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(569), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12005] = 2,
    ACTIONS(571), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(573), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12023] = 2,
    ACTIONS(575), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(577), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12041] = 2,
    ACTIONS(579), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(581), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12059] = 2,
    ACTIONS(583), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(585), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12077] = 2,
    ACTIONS(587), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(589), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12095] = 2,
    ACTIONS(591), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(593), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12113] = 2,
    ACTIONS(595), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(597), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12131] = 2,
    ACTIONS(599), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(601), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12149] = 2,
    ACTIONS(603), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(605), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12167] = 2,
    ACTIONS(607), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(609), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12185] = 2,
    ACTIONS(611), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(613), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12203] = 2,
    ACTIONS(615), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(617), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12221] = 2,
    ACTIONS(619), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(621), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12239] = 2,
    ACTIONS(623), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(625), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12257] = 2,
    ACTIONS(627), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(629), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12275] = 2,
    ACTIONS(631), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(633), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12293] = 2,
    ACTIONS(635), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(637), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12311] = 2,
    ACTIONS(639), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(641), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12329] = 2,
    ACTIONS(643), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(645), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12347] = 2,
    ACTIONS(647), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(649), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12365] = 2,
    ACTIONS(651), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(653), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12383] = 2,
    ACTIONS(655), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(657), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12401] = 2,
    ACTIONS(659), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(661), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12419] = 2,
    ACTIONS(663), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(665), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12437] = 2,
    ACTIONS(667), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(669), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12455] = 2,
    ACTIONS(671), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(673), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12473] = 2,
    ACTIONS(675), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(677), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12491] = 2,
    ACTIONS(679), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(681), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12509] = 2,
    ACTIONS(683), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(685), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12527] = 2,
    ACTIONS(687), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(689), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12545] = 2,
    ACTIONS(691), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(693), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12563] = 2,
    ACTIONS(695), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(697), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12581] = 2,
    ACTIONS(699), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(701), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12599] = 2,
    ACTIONS(703), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(705), 10,
      sym_if,
      sym_elseif,
      sym_else,
      sym_endif,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12617] = 5,
    ACTIONS(709), 1,
      anon_sym_LBRACE,
    ACTIONS(711), 1,
      anon_sym_ENV,
    ACTIONS(713), 1,
      anon_sym_CACHE,
    ACTIONS(715), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(707), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
  [12640] = 5,
    ACTIONS(492), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(717), 1,
      anon_sym_LBRACE,
    ACTIONS(719), 1,
      anon_sym_ENV,
    ACTIONS(721), 1,
      anon_sym_CACHE,
    ACTIONS(484), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
  [12663] = 5,
    ACTIONS(723), 1,
      anon_sym_LBRACE,
    ACTIONS(725), 1,
      anon_sym_ENV,
    ACTIONS(727), 1,
      anon_sym_CACHE,
    ACTIONS(492), 2,
      aux_sym__unquoted_text_token1,
      aux_sym_endwhile_command_token1,
    ACTIONS(484), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
  [12686] = 2,
    ACTIONS(687), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(689), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [12702] = 2,
    ACTIONS(639), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(641), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [12718] = 2,
    ACTIONS(683), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(685), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12734] = 2,
    ACTIONS(567), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(569), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12750] = 2,
    ACTIONS(667), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(669), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12766] = 2,
    ACTIONS(599), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(601), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12782] = 2,
    ACTIONS(643), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(645), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12798] = 2,
    ACTIONS(675), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(677), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12814] = 2,
    ACTIONS(571), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(573), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12830] = 2,
    ACTIONS(563), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(565), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12846] = 2,
    ACTIONS(579), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(581), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12862] = 2,
    ACTIONS(583), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(585), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12878] = 2,
    ACTIONS(595), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(597), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12894] = 2,
    ACTIONS(603), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(605), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12910] = 2,
    ACTIONS(595), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(597), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12926] = 2,
    ACTIONS(599), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(601), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12942] = 2,
    ACTIONS(603), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(605), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12958] = 2,
    ACTIONS(607), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(609), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12974] = 2,
    ACTIONS(611), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(613), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [12990] = 2,
    ACTIONS(615), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(617), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13006] = 2,
    ACTIONS(663), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(665), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13022] = 2,
    ACTIONS(611), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(613), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13038] = 2,
    ACTIONS(583), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(585), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13054] = 2,
    ACTIONS(655), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(657), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13070] = 2,
    ACTIONS(647), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(649), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13086] = 2,
    ACTIONS(635), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(637), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13102] = 2,
    ACTIONS(631), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(633), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13118] = 2,
    ACTIONS(627), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(629), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13134] = 2,
    ACTIONS(619), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(621), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13150] = 2,
    ACTIONS(591), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(593), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13166] = 2,
    ACTIONS(575), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(577), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13182] = 2,
    ACTIONS(651), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(653), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13198] = 2,
    ACTIONS(623), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(625), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13214] = 2,
    ACTIONS(639), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(641), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13230] = 2,
    ACTIONS(695), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(697), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13246] = 2,
    ACTIONS(687), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(689), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13262] = 2,
    ACTIONS(683), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(685), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13278] = 2,
    ACTIONS(567), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(569), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13294] = 2,
    ACTIONS(667), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(669), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13310] = 2,
    ACTIONS(615), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(617), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13326] = 2,
    ACTIONS(643), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(645), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13342] = 2,
    ACTIONS(675), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(677), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13358] = 2,
    ACTIONS(571), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(573), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13374] = 2,
    ACTIONS(563), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(565), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13390] = 2,
    ACTIONS(579), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(581), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13406] = 2,
    ACTIONS(583), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(585), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13422] = 2,
    ACTIONS(663), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(665), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13438] = 2,
    ACTIONS(579), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(581), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13454] = 2,
    ACTIONS(595), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(597), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13470] = 2,
    ACTIONS(599), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(601), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13486] = 2,
    ACTIONS(603), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(605), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13502] = 2,
    ACTIONS(607), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(609), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13518] = 2,
    ACTIONS(611), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(613), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13534] = 2,
    ACTIONS(615), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(617), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_endwhile,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13550] = 2,
    ACTIONS(663), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(665), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [13566] = 2,
    ACTIONS(563), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(565), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13582] = 2,
    ACTIONS(695), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(697), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13598] = 2,
    ACTIONS(571), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(573), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13614] = 2,
    ACTIONS(675), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(677), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13630] = 2,
    ACTIONS(655), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(657), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [13646] = 2,
    ACTIONS(647), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(649), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [13662] = 2,
    ACTIONS(635), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(637), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [13678] = 2,
    ACTIONS(631), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(633), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [13694] = 2,
    ACTIONS(627), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(629), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [13710] = 2,
    ACTIONS(619), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(621), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [13726] = 2,
    ACTIONS(591), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(593), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [13742] = 2,
    ACTIONS(575), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(577), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [13758] = 2,
    ACTIONS(651), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(653), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [13774] = 2,
    ACTIONS(623), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(625), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [13790] = 2,
    ACTIONS(639), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(641), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [13806] = 2,
    ACTIONS(695), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(697), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [13822] = 2,
    ACTIONS(687), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(689), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [13838] = 2,
    ACTIONS(683), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(685), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [13854] = 2,
    ACTIONS(567), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(569), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [13870] = 2,
    ACTIONS(667), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(669), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [13886] = 2,
    ACTIONS(643), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(645), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [13902] = 2,
    ACTIONS(643), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(645), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [13918] = 2,
    ACTIONS(675), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(677), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [13934] = 2,
    ACTIONS(571), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(573), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [13950] = 2,
    ACTIONS(563), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(565), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [13966] = 2,
    ACTIONS(579), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(581), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [13982] = 2,
    ACTIONS(583), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(585), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [13998] = 2,
    ACTIONS(655), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(657), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14014] = 2,
    ACTIONS(687), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(689), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14030] = 2,
    ACTIONS(595), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(597), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [14046] = 2,
    ACTIONS(599), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(601), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [14062] = 2,
    ACTIONS(603), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(605), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [14078] = 2,
    ACTIONS(607), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(609), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [14094] = 2,
    ACTIONS(611), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(613), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [14110] = 2,
    ACTIONS(615), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(617), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_endfunction,
      sym_macro,
      sym_block,
      sym_identifier,
  [14126] = 2,
    ACTIONS(663), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(665), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [14142] = 2,
    ACTIONS(639), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(641), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14158] = 2,
    ACTIONS(623), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(625), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14174] = 2,
    ACTIONS(655), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(657), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [14190] = 2,
    ACTIONS(647), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(649), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [14206] = 2,
    ACTIONS(635), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(637), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [14222] = 2,
    ACTIONS(631), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(633), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [14238] = 2,
    ACTIONS(627), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(629), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [14254] = 2,
    ACTIONS(619), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(621), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [14270] = 2,
    ACTIONS(591), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(593), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [14286] = 2,
    ACTIONS(575), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(577), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [14302] = 2,
    ACTIONS(651), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(653), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [14318] = 2,
    ACTIONS(623), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(625), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [14334] = 2,
    ACTIONS(607), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(609), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14350] = 2,
    ACTIONS(695), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(697), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [14366] = 2,
    ACTIONS(687), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(689), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [14382] = 2,
    ACTIONS(683), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(685), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [14398] = 2,
    ACTIONS(567), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(569), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [14414] = 2,
    ACTIONS(667), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(669), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [14430] = 2,
    ACTIONS(643), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(645), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [14446] = 2,
    ACTIONS(675), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(677), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [14462] = 2,
    ACTIONS(571), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(573), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [14478] = 2,
    ACTIONS(563), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(565), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [14494] = 2,
    ACTIONS(579), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(581), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [14510] = 2,
    ACTIONS(583), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(585), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [14526] = 2,
    ACTIONS(595), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(597), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [14542] = 2,
    ACTIONS(599), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(601), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [14558] = 2,
    ACTIONS(603), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(605), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [14574] = 2,
    ACTIONS(607), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(609), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [14590] = 2,
    ACTIONS(611), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(613), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [14606] = 2,
    ACTIONS(615), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(617), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_endmacro,
      sym_block,
      sym_identifier,
  [14622] = 2,
    ACTIONS(663), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(665), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [14638] = 2,
    ACTIONS(575), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(577), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14654] = 2,
    ACTIONS(655), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(657), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [14670] = 2,
    ACTIONS(647), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(649), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [14686] = 2,
    ACTIONS(635), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(637), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [14702] = 2,
    ACTIONS(631), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(633), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [14718] = 2,
    ACTIONS(627), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(629), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [14734] = 2,
    ACTIONS(619), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(621), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [14750] = 2,
    ACTIONS(591), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(593), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [14766] = 2,
    ACTIONS(575), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(577), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [14782] = 2,
    ACTIONS(651), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(653), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [14798] = 2,
    ACTIONS(623), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(625), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [14814] = 2,
    ACTIONS(639), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(641), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [14830] = 2,
    ACTIONS(695), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(697), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [14846] = 2,
    ACTIONS(651), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(653), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [14862] = 2,
    ACTIONS(683), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(685), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [14878] = 2,
    ACTIONS(567), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(569), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [14894] = 2,
    ACTIONS(667), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(669), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [14910] = 2,
    ACTIONS(643), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(645), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [14926] = 2,
    ACTIONS(675), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(677), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [14942] = 2,
    ACTIONS(571), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(573), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [14958] = 2,
    ACTIONS(563), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(565), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [14974] = 2,
    ACTIONS(579), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(581), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [14990] = 2,
    ACTIONS(583), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(585), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [15006] = 2,
    ACTIONS(595), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(597), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [15022] = 2,
    ACTIONS(599), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(601), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [15038] = 2,
    ACTIONS(603), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(605), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [15054] = 2,
    ACTIONS(607), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(609), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [15070] = 2,
    ACTIONS(611), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(613), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [15086] = 2,
    ACTIONS(615), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(617), 8,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_endblock,
      sym_identifier,
  [15102] = 2,
    ACTIONS(567), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(569), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [15118] = 2,
    ACTIONS(667), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(669), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [15134] = 2,
    ACTIONS(591), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(593), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [15150] = 2,
    ACTIONS(683), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(685), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [15166] = 2,
    ACTIONS(687), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(689), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [15182] = 2,
    ACTIONS(575), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(577), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [15198] = 2,
    ACTIONS(695), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(697), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [15214] = 2,
    ACTIONS(627), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(629), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [15230] = 2,
    ACTIONS(591), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(593), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [15246] = 2,
    ACTIONS(651), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(653), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [15262] = 2,
    ACTIONS(619), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(621), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [15278] = 2,
    ACTIONS(627), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(629), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [15294] = 2,
    ACTIONS(639), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(641), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [15310] = 2,
    ACTIONS(619), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(621), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [15326] = 2,
    ACTIONS(647), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(649), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [15342] = 2,
    ACTIONS(631), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(633), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [15358] = 2,
    ACTIONS(635), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(637), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [15374] = 2,
    ACTIONS(663), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(665), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [15390] = 2,
    ACTIONS(647), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(649), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [15406] = 2,
    ACTIONS(655), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(657), 8,
      sym_if,
      sym_foreach,
      sym_endforeach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [15422] = 2,
    ACTIONS(635), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(637), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [15438] = 2,
    ACTIONS(631), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(633), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [15454] = 2,
    ACTIONS(623), 4,
      sym_bracket_comment,
      sym_line_comment,
      ts_builtin_sym_end,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(625), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [15470] = 5,
    ACTIONS(729), 1,
      anon_sym_DOLLAR,
    ACTIONS(732), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(735), 1,
      aux_sym_endwhile_command_token1,
    STATE(437), 1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(515), 6,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
  [15491] = 4,
    ACTIONS(737), 1,
      anon_sym_DOLLAR,
    ACTIONS(740), 1,
      aux_sym__unquoted_text_token1,
    STATE(438), 1,
      aux_sym__unquoted_text_repeat1,
    ACTIONS(515), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_RPAREN,
  [15510] = 2,
    ACTIONS(743), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(745), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [15525] = 2,
    ACTIONS(747), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(749), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [15540] = 2,
    ACTIONS(751), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(753), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [15555] = 2,
    ACTIONS(755), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(757), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [15570] = 2,
    ACTIONS(759), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(761), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [15585] = 4,
    ACTIONS(765), 1,
      anon_sym_DOLLAR,
    ACTIONS(768), 1,
      aux_sym__quoted_text_token1,
    STATE(444), 1,
      aux_sym__quoted_text_repeat1,
    ACTIONS(763), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DQUOTE,
  [15604] = 2,
    ACTIONS(771), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(773), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [15619] = 2,
    ACTIONS(775), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(777), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [15634] = 2,
    ACTIONS(779), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(781), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [15649] = 2,
    ACTIONS(783), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(785), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [15664] = 2,
    ACTIONS(787), 3,
      sym_bracket_comment,
      sym_line_comment,
      aux_sym__untrimmed_argument_token1,
    ACTIONS(789), 7,
      sym_if,
      sym_foreach,
      sym_while,
      sym_function,
      sym_macro,
      sym_block,
      sym_identifier,
  [15679] = 2,
    ACTIONS(533), 2,
      aux_sym__unquoted_text_token1,
      aux_sym_endwhile_command_token1,
    ACTIONS(531), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
  [15693] = 2,
    ACTIONS(545), 2,
      aux_sym__unquoted_text_token1,
      aux_sym_endwhile_command_token1,
    ACTIONS(543), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
  [15707] = 2,
    ACTIONS(525), 2,
      aux_sym__unquoted_text_token1,
      aux_sym_endwhile_command_token1,
    ACTIONS(523), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
  [15721] = 1,
    ACTIONS(559), 9,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      aux_sym_variable_token1,
      anon_sym_DOLLAR,
      anon_sym_RBRACE,
  [15733] = 2,
    ACTIONS(525), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(523), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
  [15747] = 2,
    ACTIONS(533), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(531), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
  [15761] = 2,
    ACTIONS(529), 2,
      aux_sym__unquoted_text_token1,
      aux_sym_endwhile_command_token1,
    ACTIONS(527), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
  [15775] = 2,
    ACTIONS(561), 2,
      aux_sym__unquoted_text_token1,
      aux_sym_endwhile_command_token1,
    ACTIONS(559), 7,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
  [15789] = 2,
    ACTIONS(545), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(543), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
  [15803] = 2,
    ACTIONS(545), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(543), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
  [15817] = 2,
    ACTIONS(525), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(523), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
  [15831] = 2,
    ACTIONS(533), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(531), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
  [15845] = 1,
    ACTIONS(527), 9,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      aux_sym_variable_token1,
      anon_sym_DOLLAR,
      anon_sym_RBRACE,
  [15857] = 2,
    ACTIONS(529), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(527), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
  [15871] = 2,
    ACTIONS(561), 1,
      aux_sym__unquoted_text_token1,
    ACTIONS(559), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_RPAREN,
  [15885] = 2,
    ACTIONS(529), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(527), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
  [15899] = 1,
    ACTIONS(543), 9,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      aux_sym_variable_token1,
      anon_sym_DOLLAR,
      anon_sym_RBRACE,
  [15911] = 1,
    ACTIONS(523), 9,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      aux_sym_variable_token1,
      anon_sym_DOLLAR,
      anon_sym_RBRACE,
  [15923] = 1,
    ACTIONS(531), 9,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      aux_sym_variable_token1,
      anon_sym_DOLLAR,
      anon_sym_RBRACE,
  [15935] = 2,
    ACTIONS(561), 1,
      aux_sym__quoted_text_token1,
    ACTIONS(559), 8,
      sym__escape_identity,
      anon_sym_BSLASHt,
      anon_sym_BSLASHr,
      anon_sym_BSLASHn,
      anon_sym_SEMI,
      anon_sym_BSLASH_SEMI,
      anon_sym_DOLLAR,
      anon_sym_DQUOTE,
  [15949] = 3,
    ACTIONS(791), 1,
      anon_sym_LPAREN,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [15959] = 3,
    ACTIONS(795), 1,
      anon_sym_LPAREN,
    ACTIONS(797), 1,
      aux_sym_if_command_token1,
    STATE(552), 1,
      aux_sym_if_command_repeat1,
  [15969] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(799), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [15979] = 3,
    ACTIONS(801), 1,
      anon_sym_LPAREN,
    ACTIONS(803), 1,
      aux_sym_if_command_token1,
    STATE(521), 1,
      aux_sym_if_command_repeat1,
  [15989] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(805), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [15999] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(807), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [16009] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(809), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [16019] = 3,
    ACTIONS(811), 1,
      anon_sym_LPAREN,
    ACTIONS(813), 1,
      aux_sym_if_command_token1,
    STATE(542), 1,
      aux_sym_if_command_repeat1,
  [16029] = 3,
    ACTIONS(815), 1,
      anon_sym_LPAREN,
    ACTIONS(817), 1,
      aux_sym_if_command_token1,
    STATE(557), 1,
      aux_sym_if_command_repeat1,
  [16039] = 3,
    ACTIONS(819), 1,
      anon_sym_LPAREN,
    ACTIONS(821), 1,
      aux_sym_if_command_token1,
    STATE(580), 1,
      aux_sym_if_command_repeat1,
  [16049] = 3,
    ACTIONS(823), 1,
      anon_sym_LPAREN,
    ACTIONS(825), 1,
      aux_sym_if_command_token1,
    STATE(558), 1,
      aux_sym_if_command_repeat1,
  [16059] = 3,
    ACTIONS(827), 1,
      anon_sym_LPAREN,
    ACTIONS(829), 1,
      aux_sym_if_command_token1,
    STATE(474), 1,
      aux_sym_if_command_repeat1,
  [16069] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(831), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [16079] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(833), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [16089] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(835), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [16099] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(837), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [16109] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(839), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [16119] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(841), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [16129] = 3,
    ACTIONS(843), 1,
      anon_sym_LPAREN,
    ACTIONS(845), 1,
      aux_sym_if_command_token1,
    STATE(482), 1,
      aux_sym_if_command_repeat1,
  [16139] = 3,
    ACTIONS(847), 1,
      anon_sym_LPAREN,
    ACTIONS(849), 1,
      aux_sym_if_command_token1,
    STATE(483), 1,
      aux_sym_if_command_repeat1,
  [16149] = 3,
    ACTIONS(851), 1,
      anon_sym_LPAREN,
    ACTIONS(853), 1,
      aux_sym_if_command_token1,
    STATE(485), 1,
      aux_sym_if_command_repeat1,
  [16159] = 3,
    ACTIONS(855), 1,
      anon_sym_LPAREN,
    ACTIONS(857), 1,
      aux_sym_if_command_token1,
    STATE(486), 1,
      aux_sym_if_command_repeat1,
  [16169] = 3,
    ACTIONS(859), 1,
      anon_sym_LPAREN,
    ACTIONS(861), 1,
      aux_sym_if_command_token1,
    STATE(487), 1,
      aux_sym_if_command_repeat1,
  [16179] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(863), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [16189] = 3,
    ACTIONS(865), 1,
      anon_sym_LPAREN,
    ACTIONS(867), 1,
      aux_sym_if_command_token1,
    STATE(493), 1,
      aux_sym_if_command_repeat1,
  [16199] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(869), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [16209] = 3,
    ACTIONS(871), 1,
      anon_sym_LPAREN,
    ACTIONS(873), 1,
      aux_sym_if_command_token1,
    STATE(537), 1,
      aux_sym_if_command_repeat1,
  [16219] = 3,
    ACTIONS(875), 1,
      anon_sym_LPAREN,
    ACTIONS(877), 1,
      aux_sym_if_command_token1,
    STATE(538), 1,
      aux_sym_if_command_repeat1,
  [16229] = 3,
    ACTIONS(879), 1,
      anon_sym_LPAREN,
    ACTIONS(881), 1,
      aux_sym_if_command_token1,
    STATE(554), 1,
      aux_sym_if_command_repeat1,
  [16239] = 3,
    ACTIONS(883), 1,
      anon_sym_LPAREN,
    ACTIONS(885), 1,
      aux_sym_if_command_token1,
    STATE(472), 1,
      aux_sym_if_command_repeat1,
  [16249] = 3,
    ACTIONS(887), 1,
      anon_sym_LPAREN,
    ACTIONS(889), 1,
      aux_sym_if_command_token1,
    STATE(484), 1,
      aux_sym_if_command_repeat1,
  [16259] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(891), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [16269] = 3,
    ACTIONS(893), 1,
      anon_sym_LPAREN,
    ACTIONS(895), 1,
      aux_sym_if_command_token1,
    STATE(501), 1,
      aux_sym_if_command_repeat1,
  [16279] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(897), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [16289] = 3,
    ACTIONS(899), 1,
      anon_sym_LPAREN,
    ACTIONS(901), 1,
      aux_sym_if_command_token1,
    STATE(539), 1,
      aux_sym_if_command_repeat1,
  [16299] = 3,
    ACTIONS(903), 1,
      anon_sym_LPAREN,
    ACTIONS(905), 1,
      aux_sym_if_command_token1,
    STATE(495), 1,
      aux_sym_if_command_repeat1,
  [16309] = 3,
    ACTIONS(907), 1,
      anon_sym_LPAREN,
    ACTIONS(909), 1,
      aux_sym_if_command_token1,
    STATE(572), 1,
      aux_sym_if_command_repeat1,
  [16319] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(911), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [16329] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(913), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [16339] = 3,
    ACTIONS(915), 1,
      anon_sym_LPAREN,
    ACTIONS(917), 1,
      aux_sym_if_command_token1,
    STATE(571), 1,
      aux_sym_if_command_repeat1,
  [16349] = 3,
    ACTIONS(919), 1,
      anon_sym_LPAREN,
    ACTIONS(921), 1,
      aux_sym_if_command_token1,
    STATE(475), 1,
      aux_sym_if_command_repeat1,
  [16359] = 3,
    ACTIONS(923), 1,
      anon_sym_LPAREN,
    ACTIONS(925), 1,
      aux_sym_if_command_token1,
    STATE(573), 1,
      aux_sym_if_command_repeat1,
  [16369] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(927), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [16379] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(929), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [16389] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(931), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [16399] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(933), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [16409] = 3,
    ACTIONS(935), 1,
      anon_sym_LPAREN,
    ACTIONS(937), 1,
      aux_sym_if_command_token1,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [16419] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(940), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [16429] = 3,
    ACTIONS(942), 1,
      anon_sym_LPAREN,
    ACTIONS(944), 1,
      aux_sym_if_command_token1,
    STATE(508), 1,
      aux_sym_if_command_repeat1,
  [16439] = 3,
    ACTIONS(946), 1,
      anon_sym_LPAREN,
    ACTIONS(948), 1,
      aux_sym_if_command_token1,
    STATE(503), 1,
      aux_sym_if_command_repeat1,
  [16449] = 3,
    ACTIONS(950), 1,
      anon_sym_LPAREN,
    ACTIONS(952), 1,
      aux_sym_if_command_token1,
    STATE(512), 1,
      aux_sym_if_command_repeat1,
  [16459] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(954), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [16469] = 3,
    ACTIONS(956), 1,
      anon_sym_LPAREN,
    ACTIONS(958), 1,
      aux_sym_if_command_token1,
    STATE(513), 1,
      aux_sym_if_command_repeat1,
  [16479] = 3,
    ACTIONS(960), 1,
      anon_sym_LPAREN,
    ACTIONS(962), 1,
      aux_sym_if_command_token1,
    STATE(514), 1,
      aux_sym_if_command_repeat1,
  [16489] = 3,
    ACTIONS(964), 1,
      anon_sym_LPAREN,
    ACTIONS(966), 1,
      aux_sym_if_command_token1,
    STATE(515), 1,
      aux_sym_if_command_repeat1,
  [16499] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(968), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [16509] = 3,
    ACTIONS(970), 1,
      anon_sym_LPAREN,
    ACTIONS(972), 1,
      aux_sym_if_command_token1,
    STATE(525), 1,
      aux_sym_if_command_repeat1,
  [16519] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(974), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [16529] = 3,
    ACTIONS(976), 1,
      anon_sym_LPAREN,
    ACTIONS(978), 1,
      aux_sym_if_command_token1,
    STATE(527), 1,
      aux_sym_if_command_repeat1,
  [16539] = 3,
    ACTIONS(980), 1,
      anon_sym_LPAREN,
    ACTIONS(982), 1,
      aux_sym_if_command_token1,
    STATE(470), 1,
      aux_sym_if_command_repeat1,
  [16549] = 3,
    ACTIONS(984), 1,
      anon_sym_LPAREN,
    ACTIONS(986), 1,
      aux_sym_if_command_token1,
    STATE(559), 1,
      aux_sym_if_command_repeat1,
  [16559] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(988), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [16569] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(990), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [16579] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(992), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [16589] = 3,
    ACTIONS(994), 1,
      anon_sym_LPAREN,
    ACTIONS(996), 1,
      aux_sym_if_command_token1,
    STATE(507), 1,
      aux_sym_if_command_repeat1,
  [16599] = 3,
    ACTIONS(998), 1,
      anon_sym_LPAREN,
    ACTIONS(1000), 1,
      aux_sym_if_command_token1,
    STATE(476), 1,
      aux_sym_if_command_repeat1,
  [16609] = 3,
    ACTIONS(1002), 1,
      anon_sym_LPAREN,
    ACTIONS(1004), 1,
      aux_sym_if_command_token1,
    STATE(575), 1,
      aux_sym_if_command_repeat1,
  [16619] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(1006), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [16629] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(1008), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [16639] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(1010), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [16649] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(1012), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [16659] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(1014), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [16669] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(1016), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [16679] = 3,
    ACTIONS(1018), 1,
      anon_sym_LPAREN,
    ACTIONS(1020), 1,
      aux_sym_if_command_token1,
    STATE(531), 1,
      aux_sym_if_command_repeat1,
  [16689] = 3,
    ACTIONS(1022), 1,
      anon_sym_LPAREN,
    ACTIONS(1024), 1,
      aux_sym_if_command_token1,
    STATE(532), 1,
      aux_sym_if_command_repeat1,
  [16699] = 3,
    ACTIONS(1026), 1,
      anon_sym_LPAREN,
    ACTIONS(1028), 1,
      aux_sym_if_command_token1,
    STATE(533), 1,
      aux_sym_if_command_repeat1,
  [16709] = 3,
    ACTIONS(1030), 1,
      anon_sym_LPAREN,
    ACTIONS(1032), 1,
      aux_sym_if_command_token1,
    STATE(562), 1,
      aux_sym_if_command_repeat1,
  [16719] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(1034), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [16729] = 3,
    ACTIONS(1036), 1,
      anon_sym_LPAREN,
    ACTIONS(1038), 1,
      aux_sym_if_command_token1,
    STATE(555), 1,
      aux_sym_if_command_repeat1,
  [16739] = 3,
    ACTIONS(1040), 1,
      anon_sym_LPAREN,
    ACTIONS(1042), 1,
      aux_sym_if_command_token1,
    STATE(565), 1,
      aux_sym_if_command_repeat1,
  [16749] = 3,
    ACTIONS(1044), 1,
      anon_sym_LPAREN,
    ACTIONS(1046), 1,
      aux_sym_if_command_token1,
    STATE(540), 1,
      aux_sym_if_command_repeat1,
  [16759] = 3,
    ACTIONS(1048), 1,
      anon_sym_LPAREN,
    ACTIONS(1050), 1,
      aux_sym_if_command_token1,
    STATE(541), 1,
      aux_sym_if_command_repeat1,
  [16769] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(1052), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [16779] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(1054), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [16789] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(1056), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [16799] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(1058), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [16809] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(1060), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [16819] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(1062), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [16829] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(1064), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [16839] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(1066), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [16849] = 3,
    ACTIONS(1068), 1,
      anon_sym_LPAREN,
    ACTIONS(1070), 1,
      aux_sym_if_command_token1,
    STATE(583), 1,
      aux_sym_if_command_repeat1,
  [16859] = 3,
    ACTIONS(1072), 1,
      anon_sym_LPAREN,
    ACTIONS(1074), 1,
      aux_sym_if_command_token1,
    STATE(517), 1,
      aux_sym_if_command_repeat1,
  [16869] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(1076), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [16879] = 3,
    ACTIONS(1078), 1,
      anon_sym_LPAREN,
    ACTIONS(1080), 1,
      aux_sym_if_command_token1,
    STATE(556), 1,
      aux_sym_if_command_repeat1,
  [16889] = 3,
    ACTIONS(1082), 1,
      anon_sym_LPAREN,
    ACTIONS(1084), 1,
      aux_sym_if_command_token1,
    STATE(547), 1,
      aux_sym_if_command_repeat1,
  [16899] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(1086), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [16909] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(1088), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [16919] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(1090), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [16929] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(1092), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [16939] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(1094), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [16949] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(1096), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [16959] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(1098), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [16969] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(1100), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [16979] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(1102), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [16989] = 3,
    ACTIONS(1104), 1,
      anon_sym_LPAREN,
    ACTIONS(1106), 1,
      aux_sym_if_command_token1,
    STATE(570), 1,
      aux_sym_if_command_repeat1,
  [16999] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(1108), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [17009] = 3,
    ACTIONS(1110), 1,
      anon_sym_LPAREN,
    ACTIONS(1112), 1,
      aux_sym_if_command_token1,
    STATE(569), 1,
      aux_sym_if_command_repeat1,
  [17019] = 3,
    ACTIONS(1114), 1,
      anon_sym_LPAREN,
    ACTIONS(1116), 1,
      aux_sym_if_command_token1,
    STATE(568), 1,
      aux_sym_if_command_repeat1,
  [17029] = 3,
    ACTIONS(1118), 1,
      anon_sym_LPAREN,
    ACTIONS(1120), 1,
      aux_sym_if_command_token1,
    STATE(584), 1,
      aux_sym_if_command_repeat1,
  [17039] = 3,
    ACTIONS(1122), 1,
      anon_sym_LBRACE,
    ACTIONS(1124), 1,
      anon_sym_ENV,
    ACTIONS(1126), 1,
      anon_sym_CACHE,
  [17049] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(1128), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [17059] = 3,
    ACTIONS(1130), 1,
      anon_sym_LPAREN,
    ACTIONS(1132), 1,
      aux_sym_if_command_token1,
    STATE(566), 1,
      aux_sym_if_command_repeat1,
  [17069] = 3,
    ACTIONS(1134), 1,
      anon_sym_LPAREN,
    ACTIONS(1136), 1,
      aux_sym_if_command_token1,
    STATE(567), 1,
      aux_sym_if_command_repeat1,
  [17079] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(1138), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [17089] = 3,
    ACTIONS(793), 1,
      aux_sym_if_command_token1,
    ACTIONS(1140), 1,
      anon_sym_LPAREN,
    STATE(516), 1,
      aux_sym_if_command_repeat1,
  [17099] = 3,
    ACTIONS(1142), 1,
      anon_sym_LPAREN,
    ACTIONS(1144), 1,
      aux_sym_if_command_token1,
    STATE(553), 1,
      aux_sym_if_command_repeat1,
  [17109] = 2,
    ACTIONS(1146), 1,
      anon_sym_RPAREN,
    ACTIONS(1148), 1,
      aux_sym_endwhile_command_token1,
  [17116] = 2,
    ACTIONS(1150), 1,
      anon_sym_RPAREN,
    ACTIONS(1152), 1,
      aux_sym_endwhile_command_token1,
  [17123] = 2,
    ACTIONS(1154), 1,
      anon_sym_RPAREN,
    ACTIONS(1156), 1,
      aux_sym_endwhile_command_token1,
  [17130] = 2,
    ACTIONS(1158), 1,
      sym_endblock,
    STATE(362), 1,
      sym_endblock_command,
  [17137] = 2,
    ACTIONS(1160), 1,
      sym_endmacro,
    STATE(361), 1,
      sym_endmacro_command,
  [17144] = 2,
    ACTIONS(1162), 1,
      sym_endfunction,
    STATE(360), 1,
      sym_endfunction_command,
  [17151] = 2,
    ACTIONS(1164), 1,
      anon_sym_RPAREN,
    ACTIONS(1166), 1,
      aux_sym_endwhile_command_token1,
  [17158] = 2,
    ACTIONS(1168), 1,
      sym_endwhile,
    STATE(359), 1,
      sym_endwhile_command,
  [17165] = 2,
    ACTIONS(1170), 1,
      sym_endforeach,
    STATE(358), 1,
      sym_endforeach_command,
  [17172] = 2,
    ACTIONS(1172), 1,
      anon_sym_RPAREN,
    ACTIONS(1174), 1,
      aux_sym_endwhile_command_token1,
  [17179] = 2,
    ACTIONS(1176), 1,
      sym_endmacro,
    STATE(424), 1,
      sym_endmacro_command,
  [17186] = 2,
    ACTIONS(1178), 1,
      anon_sym_RPAREN,
    ACTIONS(1180), 1,
      aux_sym_endwhile_command_token1,
  [17193] = 2,
    ACTIONS(1182), 1,
      anon_sym_RPAREN,
    ACTIONS(1184), 1,
      aux_sym_endwhile_command_token1,
  [17200] = 2,
    ACTIONS(1186), 1,
      sym_endblock,
    STATE(328), 1,
      sym_endblock_command,
  [17207] = 2,
    ACTIONS(1188), 1,
      sym_endmacro,
    STATE(327), 1,
      sym_endmacro_command,
  [17214] = 2,
    ACTIONS(1190), 1,
      sym_endfunction,
    STATE(326), 1,
      sym_endfunction_command,
  [17221] = 2,
    ACTIONS(1192), 1,
      sym_endwhile,
    STATE(325), 1,
      sym_endwhile_command,
  [17228] = 2,
    ACTIONS(1194), 1,
      sym_endforeach,
    STATE(324), 1,
      sym_endforeach_command,
  [17235] = 2,
    ACTIONS(1196), 1,
      sym_endforeach,
    STATE(430), 1,
      sym_endforeach_command,
  [17242] = 2,
    ACTIONS(1198), 1,
      anon_sym_RPAREN,
    ACTIONS(1200), 1,
      aux_sym_endwhile_command_token1,
  [17249] = 2,
    ACTIONS(1202), 1,
      anon_sym_RPAREN,
    ACTIONS(1204), 1,
      aux_sym_endwhile_command_token1,
  [17256] = 2,
    ACTIONS(1206), 1,
      sym_endwhile,
    STATE(429), 1,
      sym_endwhile_command,
  [17263] = 2,
    ACTIONS(1208), 1,
      sym_endforeach,
    STATE(388), 1,
      sym_endforeach_command,
  [17270] = 2,
    ACTIONS(1210), 1,
      sym_endwhile,
    STATE(389), 1,
      sym_endwhile_command,
  [17277] = 2,
    ACTIONS(1212), 1,
      sym_endfunction,
    STATE(390), 1,
      sym_endfunction_command,
  [17284] = 2,
    ACTIONS(1214), 1,
      sym_endmacro,
    STATE(391), 1,
      sym_endmacro_command,
  [17291] = 2,
    ACTIONS(1216), 1,
      sym_endblock,
    STATE(392), 1,
      sym_endblock_command,
  [17298] = 2,
    ACTIONS(1218), 1,
      sym_endfunction,
    STATE(425), 1,
      sym_endfunction_command,
  [17305] = 2,
    ACTIONS(1220), 1,
      anon_sym_RPAREN,
    ACTIONS(1222), 1,
      aux_sym_endwhile_command_token1,
  [17312] = 2,
    ACTIONS(1224), 1,
      sym_endblock,
    STATE(416), 1,
      sym_endblock_command,
  [17319] = 2,
    ACTIONS(1226), 1,
      sym_endblock,
    STATE(231), 1,
      sym_endblock_command,
  [17326] = 2,
    ACTIONS(1228), 1,
      sym_endmacro,
    STATE(427), 1,
      sym_endmacro_command,
  [17333] = 2,
    ACTIONS(1230), 1,
      sym_endfunction,
    STATE(421), 1,
      sym_endfunction_command,
  [17340] = 2,
    ACTIONS(1232), 1,
      sym_endblock,
    STATE(292), 1,
      sym_endblock_command,
  [17347] = 2,
    ACTIONS(1234), 1,
      anon_sym_RPAREN,
    ACTIONS(1236), 1,
      aux_sym_endwhile_command_token1,
  [17354] = 2,
    ACTIONS(1238), 1,
      sym_endmacro,
    STATE(238), 1,
      sym_endmacro_command,
  [17361] = 2,
    ACTIONS(1240), 1,
      sym_endmacro,
    STATE(291), 1,
      sym_endmacro_command,
  [17368] = 2,
    ACTIONS(1242), 1,
      sym_endfunction,
    STATE(240), 1,
      sym_endfunction_command,
  [17375] = 2,
    ACTIONS(1244), 1,
      sym_endfunction,
    STATE(290), 1,
      sym_endfunction_command,
  [17382] = 2,
    ACTIONS(1246), 1,
      sym_endwhile,
    STATE(289), 1,
      sym_endwhile_command,
  [17389] = 2,
    ACTIONS(1248), 1,
      sym_endforeach,
    STATE(288), 1,
      sym_endforeach_command,
  [17396] = 2,
    ACTIONS(1250), 1,
      anon_sym_RPAREN,
    ACTIONS(1252), 1,
      aux_sym_endwhile_command_token1,
  [17403] = 2,
    ACTIONS(1254), 1,
      sym_endwhile,
    STATE(435), 1,
      sym_endwhile_command,
  [17410] = 2,
    ACTIONS(1256), 1,
      sym_endwhile,
    STATE(241), 1,
      sym_endwhile_command,
  [17417] = 2,
    ACTIONS(1258), 1,
      sym_endforeach,
    STATE(434), 1,
      sym_endforeach_command,
  [17424] = 2,
    ACTIONS(1260), 1,
      sym_endforeach,
    STATE(242), 1,
      sym_endforeach_command,
  [17431] = 2,
    ACTIONS(1262), 1,
      anon_sym_RPAREN,
    ACTIONS(1264), 1,
      aux_sym_endwhile_command_token1,
  [17438] = 2,
    ACTIONS(1266), 1,
      anon_sym_RPAREN,
    ACTIONS(1268), 1,
      aux_sym_endwhile_command_token1,
  [17445] = 2,
    ACTIONS(1270), 1,
      sym_endblock,
    STATE(422), 1,
      sym_endblock_command,
  [17452] = 1,
    ACTIONS(1272), 1,
      anon_sym_RPAREN,
  [17456] = 1,
    ACTIONS(1274), 1,
      anon_sym_RPAREN,
  [17460] = 1,
    ACTIONS(1276), 1,
      anon_sym_RPAREN,
  [17464] = 1,
    ACTIONS(1278), 1,
      anon_sym_RPAREN,
  [17468] = 1,
    ACTIONS(1280), 1,
      anon_sym_RPAREN,
  [17472] = 1,
    ACTIONS(1282), 1,
      anon_sym_RPAREN,
  [17476] = 1,
    ACTIONS(179), 1,
      anon_sym_RPAREN,
  [17480] = 1,
    ACTIONS(187), 1,
      anon_sym_RPAREN,
  [17484] = 1,
    ACTIONS(183), 1,
      anon_sym_RPAREN,
  [17488] = 1,
    ACTIONS(1284), 1,
      anon_sym_RPAREN,
  [17492] = 1,
    ACTIONS(195), 1,
      anon_sym_RPAREN,
  [17496] = 1,
    ACTIONS(1286), 1,
      anon_sym_RPAREN,
  [17500] = 1,
    ACTIONS(1288), 1,
      anon_sym_RPAREN,
  [17504] = 1,
    ACTIONS(1290), 1,
      anon_sym_RPAREN,
  [17508] = 1,
    ACTIONS(1292), 1,
      anon_sym_RPAREN,
  [17512] = 1,
    ACTIONS(409), 1,
      anon_sym_RPAREN,
  [17516] = 1,
    ACTIONS(1294), 1,
      anon_sym_RPAREN,
  [17520] = 1,
    ACTIONS(207), 1,
      anon_sym_RPAREN,
  [17524] = 1,
    ACTIONS(213), 1,
      anon_sym_RPAREN,
  [17528] = 1,
    ACTIONS(1296), 1,
      anon_sym_RPAREN,
  [17532] = 1,
    ACTIONS(215), 1,
      anon_sym_RPAREN,
  [17536] = 1,
    ACTIONS(1298), 1,
      anon_sym_RPAREN,
  [17540] = 1,
    ACTIONS(1300), 1,
      anon_sym_RPAREN,
  [17544] = 1,
    ACTIONS(1302), 1,
      anon_sym_RPAREN,
  [17548] = 1,
    ACTIONS(1304), 1,
      anon_sym_RPAREN,
  [17552] = 1,
    ACTIONS(1306), 1,
      anon_sym_RPAREN,
  [17556] = 1,
    ACTIONS(1308), 1,
      anon_sym_RPAREN,
  [17560] = 1,
    ACTIONS(1310), 1,
      anon_sym_RPAREN,
  [17564] = 1,
    ACTIONS(1312), 1,
      anon_sym_RPAREN,
  [17568] = 1,
    ACTIONS(1314), 1,
      anon_sym_RPAREN,
  [17572] = 1,
    ACTIONS(1316), 1,
      anon_sym_DQUOTE,
  [17576] = 1,
    ACTIONS(1318), 1,
      anon_sym_LBRACE,
  [17580] = 1,
    ACTIONS(1320), 1,
      anon_sym_LBRACE,
  [17584] = 1,
    ACTIONS(1322), 1,
      aux_sym_endwhile_command_token1,
  [17588] = 1,
    ACTIONS(1324), 1,
      aux_sym_endwhile_command_token1,
  [17592] = 1,
    ACTIONS(133), 1,
      anon_sym_RPAREN,
  [17596] = 1,
    ACTIONS(1326), 1,
      anon_sym_RPAREN,
  [17600] = 1,
    ACTIONS(175), 1,
      anon_sym_RPAREN,
  [17604] = 1,
    ACTIONS(173), 1,
      anon_sym_RPAREN,
  [17608] = 1,
    ACTIONS(171), 1,
      anon_sym_RPAREN,
  [17612] = 1,
    ACTIONS(395), 1,
      anon_sym_RPAREN,
  [17616] = 1,
    ACTIONS(1328), 1,
      anon_sym_RPAREN,
  [17620] = 1,
    ACTIONS(137), 1,
      anon_sym_RPAREN,
  [17624] = 1,
    ACTIONS(1330), 1,
      anon_sym_RPAREN,
  [17628] = 1,
    ACTIONS(1332), 1,
      anon_sym_RBRACE,
  [17632] = 1,
    ACTIONS(1334), 1,
      anon_sym_RPAREN,
  [17636] = 1,
    ACTIONS(1336), 1,
      anon_sym_RPAREN,
  [17640] = 1,
    ACTIONS(1338), 1,
      anon_sym_RPAREN,
  [17644] = 1,
    ACTIONS(1340), 1,
      anon_sym_RPAREN,
  [17648] = 1,
    ACTIONS(1342), 1,
      anon_sym_RPAREN,
  [17652] = 1,
    ACTIONS(1344), 1,
      anon_sym_RPAREN,
  [17656] = 1,
    ACTIONS(1346), 1,
      aux_sym_endwhile_command_token1,
  [17660] = 1,
    ACTIONS(1348), 1,
      aux_sym_endwhile_command_token1,
  [17664] = 1,
    ACTIONS(1350), 1,
      anon_sym_RPAREN,
  [17668] = 1,
    ACTIONS(1352), 1,
      anon_sym_RBRACE,
  [17672] = 1,
    ACTIONS(1354), 1,
      anon_sym_RBRACE,
  [17676] = 1,
    ACTIONS(1356), 1,
      anon_sym_RPAREN,
  [17680] = 1,
    ACTIONS(129), 1,
      anon_sym_RPAREN,
  [17684] = 1,
    ACTIONS(127), 1,
      anon_sym_RPAREN,
  [17688] = 1,
    ACTIONS(1358), 1,
      anon_sym_RPAREN,
  [17692] = 1,
    ACTIONS(125), 1,
      anon_sym_RPAREN,
  [17696] = 1,
    ACTIONS(397), 1,
      anon_sym_RPAREN,
  [17700] = 1,
    ACTIONS(1360), 1,
      anon_sym_RPAREN,
  [17704] = 1,
    ACTIONS(1362), 1,
      anon_sym_RBRACE,
  [17708] = 1,
    ACTIONS(403), 1,
      anon_sym_RPAREN,
  [17712] = 1,
    ACTIONS(109), 1,
      anon_sym_RPAREN,
  [17716] = 1,
    ACTIONS(115), 1,
      anon_sym_RPAREN,
  [17720] = 1,
    ACTIONS(1364), 1,
      anon_sym_RPAREN,
  [17724] = 1,
    ACTIONS(1366), 1,
      anon_sym_RBRACE,
  [17728] = 1,
    ACTIONS(103), 1,
      anon_sym_RPAREN,
  [17732] = 1,
    ACTIONS(105), 1,
      anon_sym_RPAREN,
  [17736] = 1,
    ACTIONS(97), 1,
      anon_sym_RPAREN,
  [17740] = 1,
    ACTIONS(1368), 1,
      anon_sym_RBRACE,
  [17744] = 1,
    ACTIONS(191), 1,
      anon_sym_RPAREN,
  [17748] = 1,
    ACTIONS(1370), 1,
      anon_sym_RPAREN,
  [17752] = 1,
    ACTIONS(1372), 1,
      aux_sym_endwhile_command_token1,
  [17756] = 1,
    ACTIONS(1374), 1,
      aux_sym_endwhile_command_token1,
  [17760] = 1,
    ACTIONS(1376), 1,
      anon_sym_RPAREN,
  [17764] = 1,
    ACTIONS(1378), 1,
      anon_sym_RPAREN,
  [17768] = 1,
    ACTIONS(1380), 1,
      anon_sym_RPAREN,
  [17772] = 1,
    ACTIONS(1382), 1,
      anon_sym_RPAREN,
  [17776] = 1,
    ACTIONS(1384), 1,
      anon_sym_RPAREN,
  [17780] = 1,
    ACTIONS(1386), 1,
      anon_sym_RPAREN,
  [17784] = 1,
    ACTIONS(1388), 1,
      anon_sym_RPAREN,
  [17788] = 1,
    ACTIONS(1390), 1,
      anon_sym_RPAREN,
  [17792] = 1,
    ACTIONS(1392), 1,
      anon_sym_RPAREN,
  [17796] = 1,
    ACTIONS(1394), 1,
      anon_sym_RBRACE,
  [17800] = 1,
    ACTIONS(1396), 1,
      anon_sym_RBRACE,
  [17804] = 1,
    ACTIONS(1398), 1,
      anon_sym_RBRACE,
  [17808] = 1,
    ACTIONS(231), 1,
      anon_sym_RPAREN,
  [17812] = 1,
    ACTIONS(93), 1,
      anon_sym_RPAREN,
  [17816] = 1,
    ACTIONS(181), 1,
      anon_sym_RPAREN,
  [17820] = 1,
    ACTIONS(1400), 1,
      anon_sym_RPAREN,
  [17824] = 1,
    ACTIONS(415), 1,
      anon_sym_RPAREN,
  [17828] = 1,
    ACTIONS(1402), 1,
      anon_sym_RPAREN,
  [17832] = 1,
    ACTIONS(1404), 1,
      anon_sym_RBRACE,
  [17836] = 1,
    ACTIONS(1406), 1,
      aux_sym_endwhile_command_token1,
  [17840] = 1,
    ACTIONS(1408), 1,
      anon_sym_RPAREN,
  [17844] = 1,
    ACTIONS(1410), 1,
      anon_sym_RPAREN,
  [17848] = 1,
    ACTIONS(1412), 1,
      aux_sym_endwhile_command_token1,
  [17852] = 1,
    ACTIONS(1414), 1,
      aux_sym_endwhile_command_token1,
  [17856] = 1,
    ACTIONS(153), 1,
      anon_sym_RPAREN,
  [17860] = 1,
    ACTIONS(1416), 1,
      anon_sym_RPAREN,
  [17864] = 1,
    ACTIONS(1418), 1,
      anon_sym_RPAREN,
  [17868] = 1,
    ACTIONS(177), 1,
      anon_sym_RPAREN,
  [17872] = 1,
    ACTIONS(1420), 1,
      anon_sym_RPAREN,
  [17876] = 1,
    ACTIONS(1422), 1,
      anon_sym_RPAREN,
  [17880] = 1,
    ACTIONS(1424), 1,
      anon_sym_RPAREN,
  [17884] = 1,
    ACTIONS(1426), 1,
      anon_sym_RPAREN,
  [17888] = 1,
    ACTIONS(1428), 1,
      anon_sym_RPAREN,
  [17892] = 1,
    ACTIONS(1430), 1,
      anon_sym_RPAREN,
  [17896] = 1,
    ACTIONS(1432), 1,
      anon_sym_RPAREN,
  [17900] = 1,
    ACTIONS(1434), 1,
      anon_sym_RPAREN,
  [17904] = 1,
    ACTIONS(1436), 1,
      anon_sym_RBRACE,
  [17908] = 1,
    ACTIONS(1438), 1,
      anon_sym_RBRACE,
  [17912] = 1,
    ACTIONS(1440), 1,
      aux_sym_endwhile_command_token1,
  [17916] = 1,
    ACTIONS(217), 1,
      anon_sym_RPAREN,
  [17920] = 1,
    ACTIONS(219), 1,
      anon_sym_RPAREN,
  [17924] = 1,
    ACTIONS(221), 1,
      anon_sym_RPAREN,
  [17928] = 1,
    ACTIONS(407), 1,
      anon_sym_RPAREN,
  [17932] = 1,
    ACTIONS(1442), 1,
      aux_sym_endwhile_command_token1,
  [17936] = 1,
    ACTIONS(1444), 1,
      aux_sym_endwhile_command_token1,
  [17940] = 1,
    ACTIONS(1446), 1,
      anon_sym_RPAREN,
  [17944] = 1,
    ACTIONS(1448), 1,
      anon_sym_RBRACE,
  [17948] = 1,
    ACTIONS(1450), 1,
      anon_sym_RPAREN,
  [17952] = 1,
    ACTIONS(555), 1,
      anon_sym_RPAREN,
  [17956] = 1,
    ACTIONS(223), 1,
      anon_sym_RPAREN,
  [17960] = 1,
    ACTIONS(1452), 1,
      anon_sym_RPAREN,
  [17964] = 1,
    ACTIONS(1454), 1,
      anon_sym_DQUOTE,
  [17968] = 1,
    ACTIONS(547), 1,
      anon_sym_RPAREN,
  [17972] = 1,
    ACTIONS(209), 1,
      anon_sym_RPAREN,
  [17976] = 1,
    ACTIONS(539), 1,
      anon_sym_RPAREN,
  [17980] = 1,
    ACTIONS(1456), 1,
      anon_sym_RPAREN,
  [17984] = 1,
    ACTIONS(1458), 1,
      anon_sym_RPAREN,
  [17988] = 1,
    ACTIONS(1460), 1,
      anon_sym_RPAREN,
  [17992] = 1,
    ACTIONS(1462), 1,
      anon_sym_RPAREN,
  [17996] = 1,
    ACTIONS(1464), 1,
      anon_sym_RPAREN,
  [18000] = 1,
    ACTIONS(1466), 1,
      anon_sym_RPAREN,
  [18004] = 1,
    ACTIONS(1468), 1,
      anon_sym_RBRACE,
  [18008] = 1,
    ACTIONS(539), 1,
      aux_sym_endwhile_command_token1,
  [18012] = 1,
    ACTIONS(185), 1,
      anon_sym_RPAREN,
  [18016] = 1,
    ACTIONS(1470), 1,
      aux_sym_endwhile_command_token1,
  [18020] = 1,
    ACTIONS(1472), 1,
      aux_sym_endwhile_command_token1,
  [18024] = 1,
    ACTIONS(1474), 1,
      anon_sym_LBRACE,
  [18028] = 1,
    ACTIONS(1476), 1,
      anon_sym_LBRACE,
  [18032] = 1,
    ACTIONS(159), 1,
      anon_sym_RPAREN,
  [18036] = 1,
    ACTIONS(555), 1,
      aux_sym_endwhile_command_token1,
  [18040] = 1,
    ACTIONS(1478), 1,
      anon_sym_LBRACE,
  [18044] = 1,
    ACTIONS(1480), 1,
      anon_sym_LBRACE,
  [18048] = 1,
    ACTIONS(157), 1,
      anon_sym_RPAREN,
  [18052] = 1,
    ACTIONS(399), 1,
      anon_sym_RPAREN,
  [18056] = 1,
    ACTIONS(1482), 1,
      anon_sym_LBRACE,
  [18060] = 1,
    ACTIONS(1484), 1,
      anon_sym_LBRACE,
  [18064] = 1,
    ACTIONS(1486), 1,
      anon_sym_RPAREN,
  [18068] = 1,
    ACTIONS(1488), 1,
      ts_builtin_sym_end,
  [18072] = 1,
    ACTIONS(1490), 1,
      anon_sym_LBRACE,
  [18076] = 1,
    ACTIONS(1492), 1,
      anon_sym_LBRACE,
  [18080] = 1,
    ACTIONS(1494), 1,
      anon_sym_RBRACE,
  [18084] = 1,
    ACTIONS(141), 1,
      anon_sym_RPAREN,
  [18088] = 1,
    ACTIONS(1496), 1,
      anon_sym_RPAREN,
  [18092] = 1,
    ACTIONS(1498), 1,
      anon_sym_DQUOTE,
  [18096] = 1,
    ACTIONS(107), 1,
      anon_sym_RPAREN,
  [18100] = 1,
    ACTIONS(547), 1,
      aux_sym_endwhile_command_token1,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(2)] = 0,
  [SMALL_STATE(3)] = 75,
  [SMALL_STATE(4)] = 150,
  [SMALL_STATE(5)] = 225,
  [SMALL_STATE(6)] = 300,
  [SMALL_STATE(7)] = 375,
  [SMALL_STATE(8)] = 450,
  [SMALL_STATE(9)] = 525,
  [SMALL_STATE(10)] = 600,
  [SMALL_STATE(11)] = 675,
  [SMALL_STATE(12)] = 750,
  [SMALL_STATE(13)] = 825,
  [SMALL_STATE(14)] = 900,
  [SMALL_STATE(15)] = 975,
  [SMALL_STATE(16)] = 1050,
  [SMALL_STATE(17)] = 1122,
  [SMALL_STATE(18)] = 1183,
  [SMALL_STATE(19)] = 1244,
  [SMALL_STATE(20)] = 1305,
  [SMALL_STATE(21)] = 1366,
  [SMALL_STATE(22)] = 1427,
  [SMALL_STATE(23)] = 1488,
  [SMALL_STATE(24)] = 1549,
  [SMALL_STATE(25)] = 1610,
  [SMALL_STATE(26)] = 1671,
  [SMALL_STATE(27)] = 1732,
  [SMALL_STATE(28)] = 1793,
  [SMALL_STATE(29)] = 1854,
  [SMALL_STATE(30)] = 1915,
  [SMALL_STATE(31)] = 1976,
  [SMALL_STATE(32)] = 2037,
  [SMALL_STATE(33)] = 2098,
  [SMALL_STATE(34)] = 2159,
  [SMALL_STATE(35)] = 2220,
  [SMALL_STATE(36)] = 2281,
  [SMALL_STATE(37)] = 2342,
  [SMALL_STATE(38)] = 2403,
  [SMALL_STATE(39)] = 2464,
  [SMALL_STATE(40)] = 2525,
  [SMALL_STATE(41)] = 2586,
  [SMALL_STATE(42)] = 2647,
  [SMALL_STATE(43)] = 2708,
  [SMALL_STATE(44)] = 2769,
  [SMALL_STATE(45)] = 2830,
  [SMALL_STATE(46)] = 2891,
  [SMALL_STATE(47)] = 2952,
  [SMALL_STATE(48)] = 3013,
  [SMALL_STATE(49)] = 3074,
  [SMALL_STATE(50)] = 3135,
  [SMALL_STATE(51)] = 3196,
  [SMALL_STATE(52)] = 3257,
  [SMALL_STATE(53)] = 3318,
  [SMALL_STATE(54)] = 3379,
  [SMALL_STATE(55)] = 3440,
  [SMALL_STATE(56)] = 3501,
  [SMALL_STATE(57)] = 3562,
  [SMALL_STATE(58)] = 3623,
  [SMALL_STATE(59)] = 3684,
  [SMALL_STATE(60)] = 3745,
  [SMALL_STATE(61)] = 3806,
  [SMALL_STATE(62)] = 3867,
  [SMALL_STATE(63)] = 3928,
  [SMALL_STATE(64)] = 3989,
  [SMALL_STATE(65)] = 4050,
  [SMALL_STATE(66)] = 4111,
  [SMALL_STATE(67)] = 4172,
  [SMALL_STATE(68)] = 4233,
  [SMALL_STATE(69)] = 4294,
  [SMALL_STATE(70)] = 4355,
  [SMALL_STATE(71)] = 4416,
  [SMALL_STATE(72)] = 4477,
  [SMALL_STATE(73)] = 4538,
  [SMALL_STATE(74)] = 4599,
  [SMALL_STATE(75)] = 4660,
  [SMALL_STATE(76)] = 4721,
  [SMALL_STATE(77)] = 4782,
  [SMALL_STATE(78)] = 4843,
  [SMALL_STATE(79)] = 4904,
  [SMALL_STATE(80)] = 4965,
  [SMALL_STATE(81)] = 5026,
  [SMALL_STATE(82)] = 5087,
  [SMALL_STATE(83)] = 5148,
  [SMALL_STATE(84)] = 5209,
  [SMALL_STATE(85)] = 5270,
  [SMALL_STATE(86)] = 5331,
  [SMALL_STATE(87)] = 5392,
  [SMALL_STATE(88)] = 5453,
  [SMALL_STATE(89)] = 5514,
  [SMALL_STATE(90)] = 5572,
  [SMALL_STATE(91)] = 5630,
  [SMALL_STATE(92)] = 5688,
  [SMALL_STATE(93)] = 5746,
  [SMALL_STATE(94)] = 5804,
  [SMALL_STATE(95)] = 5862,
  [SMALL_STATE(96)] = 5920,
  [SMALL_STATE(97)] = 5978,
  [SMALL_STATE(98)] = 6036,
  [SMALL_STATE(99)] = 6094,
  [SMALL_STATE(100)] = 6152,
  [SMALL_STATE(101)] = 6210,
  [SMALL_STATE(102)] = 6268,
  [SMALL_STATE(103)] = 6326,
  [SMALL_STATE(104)] = 6384,
  [SMALL_STATE(105)] = 6442,
  [SMALL_STATE(106)] = 6500,
  [SMALL_STATE(107)] = 6558,
  [SMALL_STATE(108)] = 6620,
  [SMALL_STATE(109)] = 6682,
  [SMALL_STATE(110)] = 6742,
  [SMALL_STATE(111)] = 6802,
  [SMALL_STATE(112)] = 6862,
  [SMALL_STATE(113)] = 6922,
  [SMALL_STATE(114)] = 6982,
  [SMALL_STATE(115)] = 7042,
  [SMALL_STATE(116)] = 7102,
  [SMALL_STATE(117)] = 7162,
  [SMALL_STATE(118)] = 7222,
  [SMALL_STATE(119)] = 7282,
  [SMALL_STATE(120)] = 7342,
  [SMALL_STATE(121)] = 7402,
  [SMALL_STATE(122)] = 7462,
  [SMALL_STATE(123)] = 7522,
  [SMALL_STATE(124)] = 7582,
  [SMALL_STATE(125)] = 7642,
  [SMALL_STATE(126)] = 7702,
  [SMALL_STATE(127)] = 7762,
  [SMALL_STATE(128)] = 7822,
  [SMALL_STATE(129)] = 7882,
  [SMALL_STATE(130)] = 7942,
  [SMALL_STATE(131)] = 8002,
  [SMALL_STATE(132)] = 8062,
  [SMALL_STATE(133)] = 8122,
  [SMALL_STATE(134)] = 8182,
  [SMALL_STATE(135)] = 8242,
  [SMALL_STATE(136)] = 8302,
  [SMALL_STATE(137)] = 8362,
  [SMALL_STATE(138)] = 8422,
  [SMALL_STATE(139)] = 8482,
  [SMALL_STATE(140)] = 8542,
  [SMALL_STATE(141)] = 8602,
  [SMALL_STATE(142)] = 8662,
  [SMALL_STATE(143)] = 8722,
  [SMALL_STATE(144)] = 8782,
  [SMALL_STATE(145)] = 8842,
  [SMALL_STATE(146)] = 8902,
  [SMALL_STATE(147)] = 8962,
  [SMALL_STATE(148)] = 9022,
  [SMALL_STATE(149)] = 9082,
  [SMALL_STATE(150)] = 9142,
  [SMALL_STATE(151)] = 9202,
  [SMALL_STATE(152)] = 9262,
  [SMALL_STATE(153)] = 9322,
  [SMALL_STATE(154)] = 9382,
  [SMALL_STATE(155)] = 9442,
  [SMALL_STATE(156)] = 9502,
  [SMALL_STATE(157)] = 9542,
  [SMALL_STATE(158)] = 9582,
  [SMALL_STATE(159)] = 9629,
  [SMALL_STATE(160)] = 9676,
  [SMALL_STATE(161)] = 9723,
  [SMALL_STATE(162)] = 9770,
  [SMALL_STATE(163)] = 9817,
  [SMALL_STATE(164)] = 9864,
  [SMALL_STATE(165)] = 9911,
  [SMALL_STATE(166)] = 9958,
  [SMALL_STATE(167)] = 10005,
  [SMALL_STATE(168)] = 10052,
  [SMALL_STATE(169)] = 10099,
  [SMALL_STATE(170)] = 10146,
  [SMALL_STATE(171)] = 10193,
  [SMALL_STATE(172)] = 10240,
  [SMALL_STATE(173)] = 10284,
  [SMALL_STATE(174)] = 10328,
  [SMALL_STATE(175)] = 10372,
  [SMALL_STATE(176)] = 10416,
  [SMALL_STATE(177)] = 10460,
  [SMALL_STATE(178)] = 10504,
  [SMALL_STATE(179)] = 10548,
  [SMALL_STATE(180)] = 10592,
  [SMALL_STATE(181)] = 10636,
  [SMALL_STATE(182)] = 10680,
  [SMALL_STATE(183)] = 10724,
  [SMALL_STATE(184)] = 10768,
  [SMALL_STATE(185)] = 10812,
  [SMALL_STATE(186)] = 10856,
  [SMALL_STATE(187)] = 10893,
  [SMALL_STATE(188)] = 10930,
  [SMALL_STATE(189)] = 10967,
  [SMALL_STATE(190)] = 11001,
  [SMALL_STATE(191)] = 11035,
  [SMALL_STATE(192)] = 11069,
  [SMALL_STATE(193)] = 11103,
  [SMALL_STATE(194)] = 11137,
  [SMALL_STATE(195)] = 11171,
  [SMALL_STATE(196)] = 11200,
  [SMALL_STATE(197)] = 11232,
  [SMALL_STATE(198)] = 11264,
  [SMALL_STATE(199)] = 11296,
  [SMALL_STATE(200)] = 11328,
  [SMALL_STATE(201)] = 11360,
  [SMALL_STATE(202)] = 11392,
  [SMALL_STATE(203)] = 11424,
  [SMALL_STATE(204)] = 11456,
  [SMALL_STATE(205)] = 11488,
  [SMALL_STATE(206)] = 11520,
  [SMALL_STATE(207)] = 11552,
  [SMALL_STATE(208)] = 11584,
  [SMALL_STATE(209)] = 11616,
  [SMALL_STATE(210)] = 11648,
  [SMALL_STATE(211)] = 11680,
  [SMALL_STATE(212)] = 11712,
  [SMALL_STATE(213)] = 11744,
  [SMALL_STATE(214)] = 11769,
  [SMALL_STATE(215)] = 11789,
  [SMALL_STATE(216)] = 11809,
  [SMALL_STATE(217)] = 11829,
  [SMALL_STATE(218)] = 11849,
  [SMALL_STATE(219)] = 11869,
  [SMALL_STATE(220)] = 11889,
  [SMALL_STATE(221)] = 11909,
  [SMALL_STATE(222)] = 11929,
  [SMALL_STATE(223)] = 11949,
  [SMALL_STATE(224)] = 11969,
  [SMALL_STATE(225)] = 11987,
  [SMALL_STATE(226)] = 12005,
  [SMALL_STATE(227)] = 12023,
  [SMALL_STATE(228)] = 12041,
  [SMALL_STATE(229)] = 12059,
  [SMALL_STATE(230)] = 12077,
  [SMALL_STATE(231)] = 12095,
  [SMALL_STATE(232)] = 12113,
  [SMALL_STATE(233)] = 12131,
  [SMALL_STATE(234)] = 12149,
  [SMALL_STATE(235)] = 12167,
  [SMALL_STATE(236)] = 12185,
  [SMALL_STATE(237)] = 12203,
  [SMALL_STATE(238)] = 12221,
  [SMALL_STATE(239)] = 12239,
  [SMALL_STATE(240)] = 12257,
  [SMALL_STATE(241)] = 12275,
  [SMALL_STATE(242)] = 12293,
  [SMALL_STATE(243)] = 12311,
  [SMALL_STATE(244)] = 12329,
  [SMALL_STATE(245)] = 12347,
  [SMALL_STATE(246)] = 12365,
  [SMALL_STATE(247)] = 12383,
  [SMALL_STATE(248)] = 12401,
  [SMALL_STATE(249)] = 12419,
  [SMALL_STATE(250)] = 12437,
  [SMALL_STATE(251)] = 12455,
  [SMALL_STATE(252)] = 12473,
  [SMALL_STATE(253)] = 12491,
  [SMALL_STATE(254)] = 12509,
  [SMALL_STATE(255)] = 12527,
  [SMALL_STATE(256)] = 12545,
  [SMALL_STATE(257)] = 12563,
  [SMALL_STATE(258)] = 12581,
  [SMALL_STATE(259)] = 12599,
  [SMALL_STATE(260)] = 12617,
  [SMALL_STATE(261)] = 12640,
  [SMALL_STATE(262)] = 12663,
  [SMALL_STATE(263)] = 12686,
  [SMALL_STATE(264)] = 12702,
  [SMALL_STATE(265)] = 12718,
  [SMALL_STATE(266)] = 12734,
  [SMALL_STATE(267)] = 12750,
  [SMALL_STATE(268)] = 12766,
  [SMALL_STATE(269)] = 12782,
  [SMALL_STATE(270)] = 12798,
  [SMALL_STATE(271)] = 12814,
  [SMALL_STATE(272)] = 12830,
  [SMALL_STATE(273)] = 12846,
  [SMALL_STATE(274)] = 12862,
  [SMALL_STATE(275)] = 12878,
  [SMALL_STATE(276)] = 12894,
  [SMALL_STATE(277)] = 12910,
  [SMALL_STATE(278)] = 12926,
  [SMALL_STATE(279)] = 12942,
  [SMALL_STATE(280)] = 12958,
  [SMALL_STATE(281)] = 12974,
  [SMALL_STATE(282)] = 12990,
  [SMALL_STATE(283)] = 13006,
  [SMALL_STATE(284)] = 13022,
  [SMALL_STATE(285)] = 13038,
  [SMALL_STATE(286)] = 13054,
  [SMALL_STATE(287)] = 13070,
  [SMALL_STATE(288)] = 13086,
  [SMALL_STATE(289)] = 13102,
  [SMALL_STATE(290)] = 13118,
  [SMALL_STATE(291)] = 13134,
  [SMALL_STATE(292)] = 13150,
  [SMALL_STATE(293)] = 13166,
  [SMALL_STATE(294)] = 13182,
  [SMALL_STATE(295)] = 13198,
  [SMALL_STATE(296)] = 13214,
  [SMALL_STATE(297)] = 13230,
  [SMALL_STATE(298)] = 13246,
  [SMALL_STATE(299)] = 13262,
  [SMALL_STATE(300)] = 13278,
  [SMALL_STATE(301)] = 13294,
  [SMALL_STATE(302)] = 13310,
  [SMALL_STATE(303)] = 13326,
  [SMALL_STATE(304)] = 13342,
  [SMALL_STATE(305)] = 13358,
  [SMALL_STATE(306)] = 13374,
  [SMALL_STATE(307)] = 13390,
  [SMALL_STATE(308)] = 13406,
  [SMALL_STATE(309)] = 13422,
  [SMALL_STATE(310)] = 13438,
  [SMALL_STATE(311)] = 13454,
  [SMALL_STATE(312)] = 13470,
  [SMALL_STATE(313)] = 13486,
  [SMALL_STATE(314)] = 13502,
  [SMALL_STATE(315)] = 13518,
  [SMALL_STATE(316)] = 13534,
  [SMALL_STATE(317)] = 13550,
  [SMALL_STATE(318)] = 13566,
  [SMALL_STATE(319)] = 13582,
  [SMALL_STATE(320)] = 13598,
  [SMALL_STATE(321)] = 13614,
  [SMALL_STATE(322)] = 13630,
  [SMALL_STATE(323)] = 13646,
  [SMALL_STATE(324)] = 13662,
  [SMALL_STATE(325)] = 13678,
  [SMALL_STATE(326)] = 13694,
  [SMALL_STATE(327)] = 13710,
  [SMALL_STATE(328)] = 13726,
  [SMALL_STATE(329)] = 13742,
  [SMALL_STATE(330)] = 13758,
  [SMALL_STATE(331)] = 13774,
  [SMALL_STATE(332)] = 13790,
  [SMALL_STATE(333)] = 13806,
  [SMALL_STATE(334)] = 13822,
  [SMALL_STATE(335)] = 13838,
  [SMALL_STATE(336)] = 13854,
  [SMALL_STATE(337)] = 13870,
  [SMALL_STATE(338)] = 13886,
  [SMALL_STATE(339)] = 13902,
  [SMALL_STATE(340)] = 13918,
  [SMALL_STATE(341)] = 13934,
  [SMALL_STATE(342)] = 13950,
  [SMALL_STATE(343)] = 13966,
  [SMALL_STATE(344)] = 13982,
  [SMALL_STATE(345)] = 13998,
  [SMALL_STATE(346)] = 14014,
  [SMALL_STATE(347)] = 14030,
  [SMALL_STATE(348)] = 14046,
  [SMALL_STATE(349)] = 14062,
  [SMALL_STATE(350)] = 14078,
  [SMALL_STATE(351)] = 14094,
  [SMALL_STATE(352)] = 14110,
  [SMALL_STATE(353)] = 14126,
  [SMALL_STATE(354)] = 14142,
  [SMALL_STATE(355)] = 14158,
  [SMALL_STATE(356)] = 14174,
  [SMALL_STATE(357)] = 14190,
  [SMALL_STATE(358)] = 14206,
  [SMALL_STATE(359)] = 14222,
  [SMALL_STATE(360)] = 14238,
  [SMALL_STATE(361)] = 14254,
  [SMALL_STATE(362)] = 14270,
  [SMALL_STATE(363)] = 14286,
  [SMALL_STATE(364)] = 14302,
  [SMALL_STATE(365)] = 14318,
  [SMALL_STATE(366)] = 14334,
  [SMALL_STATE(367)] = 14350,
  [SMALL_STATE(368)] = 14366,
  [SMALL_STATE(369)] = 14382,
  [SMALL_STATE(370)] = 14398,
  [SMALL_STATE(371)] = 14414,
  [SMALL_STATE(372)] = 14430,
  [SMALL_STATE(373)] = 14446,
  [SMALL_STATE(374)] = 14462,
  [SMALL_STATE(375)] = 14478,
  [SMALL_STATE(376)] = 14494,
  [SMALL_STATE(377)] = 14510,
  [SMALL_STATE(378)] = 14526,
  [SMALL_STATE(379)] = 14542,
  [SMALL_STATE(380)] = 14558,
  [SMALL_STATE(381)] = 14574,
  [SMALL_STATE(382)] = 14590,
  [SMALL_STATE(383)] = 14606,
  [SMALL_STATE(384)] = 14622,
  [SMALL_STATE(385)] = 14638,
  [SMALL_STATE(386)] = 14654,
  [SMALL_STATE(387)] = 14670,
  [SMALL_STATE(388)] = 14686,
  [SMALL_STATE(389)] = 14702,
  [SMALL_STATE(390)] = 14718,
  [SMALL_STATE(391)] = 14734,
  [SMALL_STATE(392)] = 14750,
  [SMALL_STATE(393)] = 14766,
  [SMALL_STATE(394)] = 14782,
  [SMALL_STATE(395)] = 14798,
  [SMALL_STATE(396)] = 14814,
  [SMALL_STATE(397)] = 14830,
  [SMALL_STATE(398)] = 14846,
  [SMALL_STATE(399)] = 14862,
  [SMALL_STATE(400)] = 14878,
  [SMALL_STATE(401)] = 14894,
  [SMALL_STATE(402)] = 14910,
  [SMALL_STATE(403)] = 14926,
  [SMALL_STATE(404)] = 14942,
  [SMALL_STATE(405)] = 14958,
  [SMALL_STATE(406)] = 14974,
  [SMALL_STATE(407)] = 14990,
  [SMALL_STATE(408)] = 15006,
  [SMALL_STATE(409)] = 15022,
  [SMALL_STATE(410)] = 15038,
  [SMALL_STATE(411)] = 15054,
  [SMALL_STATE(412)] = 15070,
  [SMALL_STATE(413)] = 15086,
  [SMALL_STATE(414)] = 15102,
  [SMALL_STATE(415)] = 15118,
  [SMALL_STATE(416)] = 15134,
  [SMALL_STATE(417)] = 15150,
  [SMALL_STATE(418)] = 15166,
  [SMALL_STATE(419)] = 15182,
  [SMALL_STATE(420)] = 15198,
  [SMALL_STATE(421)] = 15214,
  [SMALL_STATE(422)] = 15230,
  [SMALL_STATE(423)] = 15246,
  [SMALL_STATE(424)] = 15262,
  [SMALL_STATE(425)] = 15278,
  [SMALL_STATE(426)] = 15294,
  [SMALL_STATE(427)] = 15310,
  [SMALL_STATE(428)] = 15326,
  [SMALL_STATE(429)] = 15342,
  [SMALL_STATE(430)] = 15358,
  [SMALL_STATE(431)] = 15374,
  [SMALL_STATE(432)] = 15390,
  [SMALL_STATE(433)] = 15406,
  [SMALL_STATE(434)] = 15422,
  [SMALL_STATE(435)] = 15438,
  [SMALL_STATE(436)] = 15454,
  [SMALL_STATE(437)] = 15470,
  [SMALL_STATE(438)] = 15491,
  [SMALL_STATE(439)] = 15510,
  [SMALL_STATE(440)] = 15525,
  [SMALL_STATE(441)] = 15540,
  [SMALL_STATE(442)] = 15555,
  [SMALL_STATE(443)] = 15570,
  [SMALL_STATE(444)] = 15585,
  [SMALL_STATE(445)] = 15604,
  [SMALL_STATE(446)] = 15619,
  [SMALL_STATE(447)] = 15634,
  [SMALL_STATE(448)] = 15649,
  [SMALL_STATE(449)] = 15664,
  [SMALL_STATE(450)] = 15679,
  [SMALL_STATE(451)] = 15693,
  [SMALL_STATE(452)] = 15707,
  [SMALL_STATE(453)] = 15721,
  [SMALL_STATE(454)] = 15733,
  [SMALL_STATE(455)] = 15747,
  [SMALL_STATE(456)] = 15761,
  [SMALL_STATE(457)] = 15775,
  [SMALL_STATE(458)] = 15789,
  [SMALL_STATE(459)] = 15803,
  [SMALL_STATE(460)] = 15817,
  [SMALL_STATE(461)] = 15831,
  [SMALL_STATE(462)] = 15845,
  [SMALL_STATE(463)] = 15857,
  [SMALL_STATE(464)] = 15871,
  [SMALL_STATE(465)] = 15885,
  [SMALL_STATE(466)] = 15899,
  [SMALL_STATE(467)] = 15911,
  [SMALL_STATE(468)] = 15923,
  [SMALL_STATE(469)] = 15935,
  [SMALL_STATE(470)] = 15949,
  [SMALL_STATE(471)] = 15959,
  [SMALL_STATE(472)] = 15969,
  [SMALL_STATE(473)] = 15979,
  [SMALL_STATE(474)] = 15989,
  [SMALL_STATE(475)] = 15999,
  [SMALL_STATE(476)] = 16009,
  [SMALL_STATE(477)] = 16019,
  [SMALL_STATE(478)] = 16029,
  [SMALL_STATE(479)] = 16039,
  [SMALL_STATE(480)] = 16049,
  [SMALL_STATE(481)] = 16059,
  [SMALL_STATE(482)] = 16069,
  [SMALL_STATE(483)] = 16079,
  [SMALL_STATE(484)] = 16089,
  [SMALL_STATE(485)] = 16099,
  [SMALL_STATE(486)] = 16109,
  [SMALL_STATE(487)] = 16119,
  [SMALL_STATE(488)] = 16129,
  [SMALL_STATE(489)] = 16139,
  [SMALL_STATE(490)] = 16149,
  [SMALL_STATE(491)] = 16159,
  [SMALL_STATE(492)] = 16169,
  [SMALL_STATE(493)] = 16179,
  [SMALL_STATE(494)] = 16189,
  [SMALL_STATE(495)] = 16199,
  [SMALL_STATE(496)] = 16209,
  [SMALL_STATE(497)] = 16219,
  [SMALL_STATE(498)] = 16229,
  [SMALL_STATE(499)] = 16239,
  [SMALL_STATE(500)] = 16249,
  [SMALL_STATE(501)] = 16259,
  [SMALL_STATE(502)] = 16269,
  [SMALL_STATE(503)] = 16279,
  [SMALL_STATE(504)] = 16289,
  [SMALL_STATE(505)] = 16299,
  [SMALL_STATE(506)] = 16309,
  [SMALL_STATE(507)] = 16319,
  [SMALL_STATE(508)] = 16329,
  [SMALL_STATE(509)] = 16339,
  [SMALL_STATE(510)] = 16349,
  [SMALL_STATE(511)] = 16359,
  [SMALL_STATE(512)] = 16369,
  [SMALL_STATE(513)] = 16379,
  [SMALL_STATE(514)] = 16389,
  [SMALL_STATE(515)] = 16399,
  [SMALL_STATE(516)] = 16409,
  [SMALL_STATE(517)] = 16419,
  [SMALL_STATE(518)] = 16429,
  [SMALL_STATE(519)] = 16439,
  [SMALL_STATE(520)] = 16449,
  [SMALL_STATE(521)] = 16459,
  [SMALL_STATE(522)] = 16469,
  [SMALL_STATE(523)] = 16479,
  [SMALL_STATE(524)] = 16489,
  [SMALL_STATE(525)] = 16499,
  [SMALL_STATE(526)] = 16509,
  [SMALL_STATE(527)] = 16519,
  [SMALL_STATE(528)] = 16529,
  [SMALL_STATE(529)] = 16539,
  [SMALL_STATE(530)] = 16549,
  [SMALL_STATE(531)] = 16559,
  [SMALL_STATE(532)] = 16569,
  [SMALL_STATE(533)] = 16579,
  [SMALL_STATE(534)] = 16589,
  [SMALL_STATE(535)] = 16599,
  [SMALL_STATE(536)] = 16609,
  [SMALL_STATE(537)] = 16619,
  [SMALL_STATE(538)] = 16629,
  [SMALL_STATE(539)] = 16639,
  [SMALL_STATE(540)] = 16649,
  [SMALL_STATE(541)] = 16659,
  [SMALL_STATE(542)] = 16669,
  [SMALL_STATE(543)] = 16679,
  [SMALL_STATE(544)] = 16689,
  [SMALL_STATE(545)] = 16699,
  [SMALL_STATE(546)] = 16709,
  [SMALL_STATE(547)] = 16719,
  [SMALL_STATE(548)] = 16729,
  [SMALL_STATE(549)] = 16739,
  [SMALL_STATE(550)] = 16749,
  [SMALL_STATE(551)] = 16759,
  [SMALL_STATE(552)] = 16769,
  [SMALL_STATE(553)] = 16779,
  [SMALL_STATE(554)] = 16789,
  [SMALL_STATE(555)] = 16799,
  [SMALL_STATE(556)] = 16809,
  [SMALL_STATE(557)] = 16819,
  [SMALL_STATE(558)] = 16829,
  [SMALL_STATE(559)] = 16839,
  [SMALL_STATE(560)] = 16849,
  [SMALL_STATE(561)] = 16859,
  [SMALL_STATE(562)] = 16869,
  [SMALL_STATE(563)] = 16879,
  [SMALL_STATE(564)] = 16889,
  [SMALL_STATE(565)] = 16899,
  [SMALL_STATE(566)] = 16909,
  [SMALL_STATE(567)] = 16919,
  [SMALL_STATE(568)] = 16929,
  [SMALL_STATE(569)] = 16939,
  [SMALL_STATE(570)] = 16949,
  [SMALL_STATE(571)] = 16959,
  [SMALL_STATE(572)] = 16969,
  [SMALL_STATE(573)] = 16979,
  [SMALL_STATE(574)] = 16989,
  [SMALL_STATE(575)] = 16999,
  [SMALL_STATE(576)] = 17009,
  [SMALL_STATE(577)] = 17019,
  [SMALL_STATE(578)] = 17029,
  [SMALL_STATE(579)] = 17039,
  [SMALL_STATE(580)] = 17049,
  [SMALL_STATE(581)] = 17059,
  [SMALL_STATE(582)] = 17069,
  [SMALL_STATE(583)] = 17079,
  [SMALL_STATE(584)] = 17089,
  [SMALL_STATE(585)] = 17099,
  [SMALL_STATE(586)] = 17109,
  [SMALL_STATE(587)] = 17116,
  [SMALL_STATE(588)] = 17123,
  [SMALL_STATE(589)] = 17130,
  [SMALL_STATE(590)] = 17137,
  [SMALL_STATE(591)] = 17144,
  [SMALL_STATE(592)] = 17151,
  [SMALL_STATE(593)] = 17158,
  [SMALL_STATE(594)] = 17165,
  [SMALL_STATE(595)] = 17172,
  [SMALL_STATE(596)] = 17179,
  [SMALL_STATE(597)] = 17186,
  [SMALL_STATE(598)] = 17193,
  [SMALL_STATE(599)] = 17200,
  [SMALL_STATE(600)] = 17207,
  [SMALL_STATE(601)] = 17214,
  [SMALL_STATE(602)] = 17221,
  [SMALL_STATE(603)] = 17228,
  [SMALL_STATE(604)] = 17235,
  [SMALL_STATE(605)] = 17242,
  [SMALL_STATE(606)] = 17249,
  [SMALL_STATE(607)] = 17256,
  [SMALL_STATE(608)] = 17263,
  [SMALL_STATE(609)] = 17270,
  [SMALL_STATE(610)] = 17277,
  [SMALL_STATE(611)] = 17284,
  [SMALL_STATE(612)] = 17291,
  [SMALL_STATE(613)] = 17298,
  [SMALL_STATE(614)] = 17305,
  [SMALL_STATE(615)] = 17312,
  [SMALL_STATE(616)] = 17319,
  [SMALL_STATE(617)] = 17326,
  [SMALL_STATE(618)] = 17333,
  [SMALL_STATE(619)] = 17340,
  [SMALL_STATE(620)] = 17347,
  [SMALL_STATE(621)] = 17354,
  [SMALL_STATE(622)] = 17361,
  [SMALL_STATE(623)] = 17368,
  [SMALL_STATE(624)] = 17375,
  [SMALL_STATE(625)] = 17382,
  [SMALL_STATE(626)] = 17389,
  [SMALL_STATE(627)] = 17396,
  [SMALL_STATE(628)] = 17403,
  [SMALL_STATE(629)] = 17410,
  [SMALL_STATE(630)] = 17417,
  [SMALL_STATE(631)] = 17424,
  [SMALL_STATE(632)] = 17431,
  [SMALL_STATE(633)] = 17438,
  [SMALL_STATE(634)] = 17445,
  [SMALL_STATE(635)] = 17452,
  [SMALL_STATE(636)] = 17456,
  [SMALL_STATE(637)] = 17460,
  [SMALL_STATE(638)] = 17464,
  [SMALL_STATE(639)] = 17468,
  [SMALL_STATE(640)] = 17472,
  [SMALL_STATE(641)] = 17476,
  [SMALL_STATE(642)] = 17480,
  [SMALL_STATE(643)] = 17484,
  [SMALL_STATE(644)] = 17488,
  [SMALL_STATE(645)] = 17492,
  [SMALL_STATE(646)] = 17496,
  [SMALL_STATE(647)] = 17500,
  [SMALL_STATE(648)] = 17504,
  [SMALL_STATE(649)] = 17508,
  [SMALL_STATE(650)] = 17512,
  [SMALL_STATE(651)] = 17516,
  [SMALL_STATE(652)] = 17520,
  [SMALL_STATE(653)] = 17524,
  [SMALL_STATE(654)] = 17528,
  [SMALL_STATE(655)] = 17532,
  [SMALL_STATE(656)] = 17536,
  [SMALL_STATE(657)] = 17540,
  [SMALL_STATE(658)] = 17544,
  [SMALL_STATE(659)] = 17548,
  [SMALL_STATE(660)] = 17552,
  [SMALL_STATE(661)] = 17556,
  [SMALL_STATE(662)] = 17560,
  [SMALL_STATE(663)] = 17564,
  [SMALL_STATE(664)] = 17568,
  [SMALL_STATE(665)] = 17572,
  [SMALL_STATE(666)] = 17576,
  [SMALL_STATE(667)] = 17580,
  [SMALL_STATE(668)] = 17584,
  [SMALL_STATE(669)] = 17588,
  [SMALL_STATE(670)] = 17592,
  [SMALL_STATE(671)] = 17596,
  [SMALL_STATE(672)] = 17600,
  [SMALL_STATE(673)] = 17604,
  [SMALL_STATE(674)] = 17608,
  [SMALL_STATE(675)] = 17612,
  [SMALL_STATE(676)] = 17616,
  [SMALL_STATE(677)] = 17620,
  [SMALL_STATE(678)] = 17624,
  [SMALL_STATE(679)] = 17628,
  [SMALL_STATE(680)] = 17632,
  [SMALL_STATE(681)] = 17636,
  [SMALL_STATE(682)] = 17640,
  [SMALL_STATE(683)] = 17644,
  [SMALL_STATE(684)] = 17648,
  [SMALL_STATE(685)] = 17652,
  [SMALL_STATE(686)] = 17656,
  [SMALL_STATE(687)] = 17660,
  [SMALL_STATE(688)] = 17664,
  [SMALL_STATE(689)] = 17668,
  [SMALL_STATE(690)] = 17672,
  [SMALL_STATE(691)] = 17676,
  [SMALL_STATE(692)] = 17680,
  [SMALL_STATE(693)] = 17684,
  [SMALL_STATE(694)] = 17688,
  [SMALL_STATE(695)] = 17692,
  [SMALL_STATE(696)] = 17696,
  [SMALL_STATE(697)] = 17700,
  [SMALL_STATE(698)] = 17704,
  [SMALL_STATE(699)] = 17708,
  [SMALL_STATE(700)] = 17712,
  [SMALL_STATE(701)] = 17716,
  [SMALL_STATE(702)] = 17720,
  [SMALL_STATE(703)] = 17724,
  [SMALL_STATE(704)] = 17728,
  [SMALL_STATE(705)] = 17732,
  [SMALL_STATE(706)] = 17736,
  [SMALL_STATE(707)] = 17740,
  [SMALL_STATE(708)] = 17744,
  [SMALL_STATE(709)] = 17748,
  [SMALL_STATE(710)] = 17752,
  [SMALL_STATE(711)] = 17756,
  [SMALL_STATE(712)] = 17760,
  [SMALL_STATE(713)] = 17764,
  [SMALL_STATE(714)] = 17768,
  [SMALL_STATE(715)] = 17772,
  [SMALL_STATE(716)] = 17776,
  [SMALL_STATE(717)] = 17780,
  [SMALL_STATE(718)] = 17784,
  [SMALL_STATE(719)] = 17788,
  [SMALL_STATE(720)] = 17792,
  [SMALL_STATE(721)] = 17796,
  [SMALL_STATE(722)] = 17800,
  [SMALL_STATE(723)] = 17804,
  [SMALL_STATE(724)] = 17808,
  [SMALL_STATE(725)] = 17812,
  [SMALL_STATE(726)] = 17816,
  [SMALL_STATE(727)] = 17820,
  [SMALL_STATE(728)] = 17824,
  [SMALL_STATE(729)] = 17828,
  [SMALL_STATE(730)] = 17832,
  [SMALL_STATE(731)] = 17836,
  [SMALL_STATE(732)] = 17840,
  [SMALL_STATE(733)] = 17844,
  [SMALL_STATE(734)] = 17848,
  [SMALL_STATE(735)] = 17852,
  [SMALL_STATE(736)] = 17856,
  [SMALL_STATE(737)] = 17860,
  [SMALL_STATE(738)] = 17864,
  [SMALL_STATE(739)] = 17868,
  [SMALL_STATE(740)] = 17872,
  [SMALL_STATE(741)] = 17876,
  [SMALL_STATE(742)] = 17880,
  [SMALL_STATE(743)] = 17884,
  [SMALL_STATE(744)] = 17888,
  [SMALL_STATE(745)] = 17892,
  [SMALL_STATE(746)] = 17896,
  [SMALL_STATE(747)] = 17900,
  [SMALL_STATE(748)] = 17904,
  [SMALL_STATE(749)] = 17908,
  [SMALL_STATE(750)] = 17912,
  [SMALL_STATE(751)] = 17916,
  [SMALL_STATE(752)] = 17920,
  [SMALL_STATE(753)] = 17924,
  [SMALL_STATE(754)] = 17928,
  [SMALL_STATE(755)] = 17932,
  [SMALL_STATE(756)] = 17936,
  [SMALL_STATE(757)] = 17940,
  [SMALL_STATE(758)] = 17944,
  [SMALL_STATE(759)] = 17948,
  [SMALL_STATE(760)] = 17952,
  [SMALL_STATE(761)] = 17956,
  [SMALL_STATE(762)] = 17960,
  [SMALL_STATE(763)] = 17964,
  [SMALL_STATE(764)] = 17968,
  [SMALL_STATE(765)] = 17972,
  [SMALL_STATE(766)] = 17976,
  [SMALL_STATE(767)] = 17980,
  [SMALL_STATE(768)] = 17984,
  [SMALL_STATE(769)] = 17988,
  [SMALL_STATE(770)] = 17992,
  [SMALL_STATE(771)] = 17996,
  [SMALL_STATE(772)] = 18000,
  [SMALL_STATE(773)] = 18004,
  [SMALL_STATE(774)] = 18008,
  [SMALL_STATE(775)] = 18012,
  [SMALL_STATE(776)] = 18016,
  [SMALL_STATE(777)] = 18020,
  [SMALL_STATE(778)] = 18024,
  [SMALL_STATE(779)] = 18028,
  [SMALL_STATE(780)] = 18032,
  [SMALL_STATE(781)] = 18036,
  [SMALL_STATE(782)] = 18040,
  [SMALL_STATE(783)] = 18044,
  [SMALL_STATE(784)] = 18048,
  [SMALL_STATE(785)] = 18052,
  [SMALL_STATE(786)] = 18056,
  [SMALL_STATE(787)] = 18060,
  [SMALL_STATE(788)] = 18064,
  [SMALL_STATE(789)] = 18068,
  [SMALL_STATE(790)] = 18072,
  [SMALL_STATE(791)] = 18076,
  [SMALL_STATE(792)] = 18080,
  [SMALL_STATE(793)] = 18084,
  [SMALL_STATE(794)] = 18088,
  [SMALL_STATE(795)] = 18092,
  [SMALL_STATE(796)] = 18096,
  [SMALL_STATE(797)] = 18100,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 0, 0, 0),
  [5] = {.entry = {.count = 1, .reusable = true}}, SHIFT(155),
  [7] = {.entry = {.count = 1, .reusable = false}}, SHIFT(578),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(560),
  [11] = {.entry = {.count = 1, .reusable = false}}, SHIFT(479),
  [13] = {.entry = {.count = 1, .reusable = false}}, SHIFT(506),
  [15] = {.entry = {.count = 1, .reusable = false}}, SHIFT(509),
  [17] = {.entry = {.count = 1, .reusable = false}}, SHIFT(510),
  [19] = {.entry = {.count = 1, .reusable = false}}, SHIFT(535),
  [21] = {.entry = {.count = 1, .reusable = true}}, SHIFT(108),
  [23] = {.entry = {.count = 1, .reusable = false}}, SHIFT(477),
  [25] = {.entry = {.count = 1, .reusable = false}}, SHIFT(478),
  [27] = {.entry = {.count = 1, .reusable = false}}, SHIFT(548),
  [29] = {.entry = {.count = 1, .reusable = false}}, SHIFT(519),
  [31] = {.entry = {.count = 1, .reusable = false}}, SHIFT(526),
  [33] = {.entry = {.count = 1, .reusable = false}}, SHIFT(494),
  [35] = {.entry = {.count = 1, .reusable = false}}, SHIFT(473),
  [37] = {.entry = {.count = 1, .reusable = false}}, SHIFT(502),
  [39] = {.entry = {.count = 1, .reusable = false}}, SHIFT(480),
  [41] = {.entry = {.count = 1, .reusable = false}}, SHIFT(471),
  [43] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_if_condition_repeat1, 2, 0, 0), SHIFT_REPEAT(108),
  [46] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_condition_repeat1, 2, 0, 0), SHIFT_REPEAT(578),
  [49] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_condition_repeat1, 2, 0, 0), SHIFT_REPEAT(477),
  [52] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_condition_repeat1, 2, 0, 0), SHIFT_REPEAT(478),
  [55] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_if_condition_repeat1, 2, 0, 0),
  [57] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_condition_repeat1, 2, 0, 0), SHIFT_REPEAT(560),
  [60] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_condition_repeat1, 2, 0, 0), SHIFT_REPEAT(479),
  [63] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_condition_repeat1, 2, 0, 0), SHIFT_REPEAT(506),
  [66] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_condition_repeat1, 2, 0, 0), SHIFT_REPEAT(509),
  [69] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_condition_repeat1, 2, 0, 0), SHIFT_REPEAT(510),
  [72] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_if_condition_repeat1, 2, 0, 0), SHIFT_REPEAT(519),
  [75] = {.entry = {.count = 1, .reusable = true}}, SHIFT(223),
  [77] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [79] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [81] = {.entry = {.count = 1, .reusable = true}}, SHIFT(98),
  [83] = {.entry = {.count = 1, .reusable = true}}, SHIFT(386),
  [85] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [87] = {.entry = {.count = 1, .reusable = false}}, SHIFT(157),
  [89] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [91] = {.entry = {.count = 1, .reusable = true}}, SHIFT(417),
  [93] = {.entry = {.count = 1, .reusable = true}}, SHIFT(307),
  [95] = {.entry = {.count = 1, .reusable = true}}, SHIFT(265),
  [97] = {.entry = {.count = 1, .reusable = true}}, SHIFT(285),
  [99] = {.entry = {.count = 1, .reusable = true}}, SHIFT(322),
  [101] = {.entry = {.count = 1, .reusable = true}}, SHIFT(247),
  [103] = {.entry = {.count = 1, .reusable = true}}, SHIFT(310),
  [105] = {.entry = {.count = 1, .reusable = true}}, SHIFT(329),
  [107] = {.entry = {.count = 1, .reusable = true}}, SHIFT(227),
  [109] = {.entry = {.count = 1, .reusable = true}}, SHIFT(318),
  [111] = {.entry = {.count = 1, .reusable = true}}, SHIFT(246),
  [113] = {.entry = {.count = 1, .reusable = true}}, SHIFT(330),
  [115] = {.entry = {.count = 1, .reusable = true}}, SHIFT(332),
  [117] = {.entry = {.count = 1, .reusable = true}}, SHIFT(335),
  [119] = {.entry = {.count = 1, .reusable = true}}, SHIFT(336),
  [121] = {.entry = {.count = 1, .reusable = true}}, SHIFT(345),
  [123] = {.entry = {.count = 1, .reusable = true}}, SHIFT(337),
  [125] = {.entry = {.count = 1, .reusable = true}}, SHIFT(342),
  [127] = {.entry = {.count = 1, .reusable = true}}, SHIFT(343),
  [129] = {.entry = {.count = 1, .reusable = true}}, SHIFT(344),
  [131] = {.entry = {.count = 1, .reusable = true}}, SHIFT(356),
  [133] = {.entry = {.count = 1, .reusable = true}}, SHIFT(363),
  [135] = {.entry = {.count = 1, .reusable = true}}, SHIFT(364),
  [137] = {.entry = {.count = 1, .reusable = true}}, SHIFT(264),
  [139] = {.entry = {.count = 1, .reusable = true}}, SHIFT(301),
  [141] = {.entry = {.count = 1, .reusable = true}}, SHIFT(243),
  [143] = {.entry = {.count = 1, .reusable = true}}, SHIFT(254),
  [145] = {.entry = {.count = 1, .reusable = true}}, SHIFT(300),
  [147] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [149] = {.entry = {.count = 1, .reusable = true}}, SHIFT(250),
  [151] = {.entry = {.count = 1, .reusable = true}}, SHIFT(299),
  [153] = {.entry = {.count = 1, .reusable = true}}, SHIFT(296),
  [155] = {.entry = {.count = 1, .reusable = true}}, SHIFT(369),
  [157] = {.entry = {.count = 1, .reusable = true}}, SHIFT(224),
  [159] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [161] = {.entry = {.count = 1, .reusable = true}}, SHIFT(370),
  [163] = {.entry = {.count = 1, .reusable = true}}, SHIFT(371),
  [165] = {.entry = {.count = 1, .reusable = true}}, SHIFT(415),
  [167] = {.entry = {.count = 1, .reusable = true}}, SHIFT(294),
  [169] = {.entry = {.count = 1, .reusable = true}}, SHIFT(414),
  [171] = {.entry = {.count = 1, .reusable = true}}, SHIFT(375),
  [173] = {.entry = {.count = 1, .reusable = true}}, SHIFT(376),
  [175] = {.entry = {.count = 1, .reusable = true}}, SHIFT(377),
  [177] = {.entry = {.count = 1, .reusable = true}}, SHIFT(293),
  [179] = {.entry = {.count = 1, .reusable = true}}, SHIFT(426),
  [181] = {.entry = {.count = 1, .reusable = true}}, SHIFT(306),
  [183] = {.entry = {.count = 1, .reusable = true}}, SHIFT(248),
  [185] = {.entry = {.count = 1, .reusable = true}}, SHIFT(229),
  [187] = {.entry = {.count = 1, .reusable = true}}, SHIFT(393),
  [189] = {.entry = {.count = 1, .reusable = true}}, SHIFT(433),
  [191] = {.entry = {.count = 1, .reusable = true}}, SHIFT(419),
  [193] = {.entry = {.count = 1, .reusable = true}}, SHIFT(394),
  [195] = {.entry = {.count = 1, .reusable = true}}, SHIFT(396),
  [197] = {.entry = {.count = 1, .reusable = true}}, SHIFT(256),
  [199] = {.entry = {.count = 1, .reusable = true}}, SHIFT(286),
  [201] = {.entry = {.count = 1, .reusable = true}}, SHIFT(423),
  [203] = {.entry = {.count = 1, .reusable = true}}, SHIFT(399),
  [205] = {.entry = {.count = 1, .reusable = true}}, SHIFT(401),
  [207] = {.entry = {.count = 1, .reusable = true}}, SHIFT(405),
  [209] = {.entry = {.count = 1, .reusable = true}}, SHIFT(385),
  [211] = {.entry = {.count = 1, .reusable = true}}, SHIFT(398),
  [213] = {.entry = {.count = 1, .reusable = true}}, SHIFT(406),
  [215] = {.entry = {.count = 1, .reusable = true}}, SHIFT(407),
  [217] = {.entry = {.count = 1, .reusable = true}}, SHIFT(274),
  [219] = {.entry = {.count = 1, .reusable = true}}, SHIFT(273),
  [221] = {.entry = {.count = 1, .reusable = true}}, SHIFT(272),
  [223] = {.entry = {.count = 1, .reusable = true}}, SHIFT(354),
  [225] = {.entry = {.count = 1, .reusable = true}}, SHIFT(267),
  [227] = {.entry = {.count = 1, .reusable = true}}, SHIFT(266),
  [229] = {.entry = {.count = 1, .reusable = true}}, SHIFT(400),
  [231] = {.entry = {.count = 1, .reusable = true}}, SHIFT(308),
  [233] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paren_argument_repeat1, 2, 0, 0), SHIFT_REPEAT(223),
  [236] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paren_argument_repeat1, 2, 0, 0), SHIFT_REPEAT(195),
  [239] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paren_argument_repeat1, 2, 0, 0), SHIFT_REPEAT(94),
  [242] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paren_argument_repeat1, 2, 0, 0), SHIFT_REPEAT(98),
  [245] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__paren_argument_repeat1, 2, 0, 0),
  [247] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paren_argument_repeat1, 2, 0, 0), SHIFT_REPEAT(187),
  [250] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__paren_argument_repeat1, 2, 0, 0), SHIFT_REPEAT(157),
  [253] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paren_argument_repeat1, 2, 0, 0), SHIFT_REPEAT(222),
  [256] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [258] = {.entry = {.count = 1, .reusable = true}}, SHIFT(221),
  [260] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [262] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_list, 1, 0, 0),
  [264] = {.entry = {.count = 1, .reusable = true}}, SHIFT(217),
  [266] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(107),
  [269] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(578),
  [272] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0),
  [274] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(560),
  [277] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(479),
  [280] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(506),
  [283] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(509),
  [286] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(510),
  [289] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(519),
  [292] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [294] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_body, 1, 0, 0),
  [296] = {.entry = {.count = 1, .reusable = true}}, SHIFT(112),
  [298] = {.entry = {.count = 1, .reusable = false}}, SHIFT(528),
  [300] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [302] = {.entry = {.count = 1, .reusable = false}}, SHIFT(504),
  [304] = {.entry = {.count = 1, .reusable = true}}, SHIFT(151),
  [306] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [308] = {.entry = {.count = 1, .reusable = false}}, SHIFT(563),
  [310] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [312] = {.entry = {.count = 1, .reusable = false}}, SHIFT(505),
  [314] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [316] = {.entry = {.count = 1, .reusable = false}}, SHIFT(481),
  [318] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(121),
  [321] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(481),
  [324] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(123),
  [327] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(563),
  [330] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [332] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [334] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(132),
  [337] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(504),
  [340] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0),
  [342] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(133),
  [345] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(535),
  [348] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(138),
  [351] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(505),
  [354] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [356] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(151),
  [359] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2, 0, 0), SHIFT_REPEAT(528),
  [362] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [364] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 1, 0, 0),
  [366] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [368] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2, 0, 0), SHIFT_REPEAT(223),
  [371] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2, 0, 0), SHIFT_REPEAT(195),
  [374] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2, 0, 0),
  [376] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2, 0, 0), SHIFT_REPEAT(156),
  [379] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unquoted_argument, 1, 0, 0),
  [381] = {.entry = {.count = 1, .reusable = false}}, SHIFT(156),
  [383] = {.entry = {.count = 1, .reusable = true}}, SHIFT(464),
  [385] = {.entry = {.count = 1, .reusable = true}}, SHIFT(261),
  [387] = {.entry = {.count = 1, .reusable = true}}, SHIFT(319),
  [389] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [391] = {.entry = {.count = 1, .reusable = false}}, SHIFT(194),
  [393] = {.entry = {.count = 1, .reusable = true}}, SHIFT(760),
  [395] = {.entry = {.count = 1, .reusable = true}}, SHIFT(373),
  [397] = {.entry = {.count = 1, .reusable = true}}, SHIFT(340),
  [399] = {.entry = {.count = 1, .reusable = true}}, SHIFT(252),
  [401] = {.entry = {.count = 1, .reusable = true}}, SHIFT(257),
  [403] = {.entry = {.count = 1, .reusable = true}}, SHIFT(321),
  [405] = {.entry = {.count = 1, .reusable = true}}, SHIFT(367),
  [407] = {.entry = {.count = 1, .reusable = true}}, SHIFT(270),
  [409] = {.entry = {.count = 1, .reusable = true}}, SHIFT(403),
  [411] = {.entry = {.count = 1, .reusable = true}}, SHIFT(397),
  [413] = {.entry = {.count = 1, .reusable = true}}, SHIFT(333),
  [415] = {.entry = {.count = 1, .reusable = true}}, SHIFT(304),
  [417] = {.entry = {.count = 1, .reusable = true}}, SHIFT(420),
  [419] = {.entry = {.count = 1, .reusable = true}}, SHIFT(297),
  [421] = {.entry = {.count = 1, .reusable = true}}, SHIFT(457),
  [423] = {.entry = {.count = 1, .reusable = true}}, SHIFT(262),
  [425] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [427] = {.entry = {.count = 1, .reusable = false}}, SHIFT(193),
  [429] = {.entry = {.count = 1, .reusable = true}}, SHIFT(781),
  [431] = {.entry = {.count = 1, .reusable = true}}, SHIFT(469),
  [433] = {.entry = {.count = 1, .reusable = true}}, SHIFT(260),
  [435] = {.entry = {.count = 1, .reusable = true}}, SHIFT(797),
  [437] = {.entry = {.count = 1, .reusable = false}}, SHIFT(192),
  [439] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [441] = {.entry = {.count = 1, .reusable = true}}, SHIFT(764),
  [443] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_quoted_element_repeat1, 2, 0, 0), SHIFT_REPEAT(469),
  [446] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_quoted_element_repeat1, 2, 0, 0), SHIFT_REPEAT(260),
  [449] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_quoted_element_repeat1, 2, 0, 0),
  [451] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_quoted_element_repeat1, 2, 0, 0), SHIFT_REPEAT(189),
  [454] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2, 0, 0), SHIFT_REPEAT(464),
  [457] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2, 0, 0), SHIFT_REPEAT(261),
  [460] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2, 0, 0), SHIFT_REPEAT(190),
  [463] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2, 0, 0), SHIFT_REPEAT(457),
  [466] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2, 0, 0), SHIFT_REPEAT(262),
  [469] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2, 0, 0), SHIFT_REPEAT(191),
  [472] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_unquoted_argument_repeat1, 2, 0, 0),
  [474] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quoted_element, 1, 0, 0),
  [476] = {.entry = {.count = 1, .reusable = false}}, SHIFT(189),
  [478] = {.entry = {.count = 1, .reusable = false}}, SHIFT(191),
  [480] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unquoted_argument, 1, 0, 0),
  [482] = {.entry = {.count = 1, .reusable = false}}, SHIFT(190),
  [484] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__unquoted_text_repeat1, 1, 0, 0),
  [486] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [488] = {.entry = {.count = 1, .reusable = true}}, SHIFT(667),
  [490] = {.entry = {.count = 1, .reusable = true}}, SHIFT(666),
  [492] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__unquoted_text_repeat1, 1, 0, 0),
  [494] = {.entry = {.count = 1, .reusable = true}}, SHIFT(453),
  [496] = {.entry = {.count = 1, .reusable = true}}, SHIFT(205),
  [498] = {.entry = {.count = 1, .reusable = true}}, SHIFT(579),
  [500] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_variable_repeat1, 2, 0, 0), SHIFT_REPEAT(453),
  [503] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_variable_repeat1, 2, 0, 0), SHIFT_REPEAT(200),
  [506] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_variable_repeat1, 2, 0, 0), SHIFT_REPEAT(579),
  [509] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_variable_repeat1, 2, 0, 0),
  [511] = {.entry = {.count = 1, .reusable = true}}, SHIFT(200),
  [513] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable, 1, 0, 0),
  [515] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__unquoted_text_repeat1, 2, 0, 0),
  [517] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__unquoted_text_repeat1, 2, 0, 0), SHIFT_REPEAT(213),
  [520] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__unquoted_text_repeat1, 2, 0, 0), SHIFT_REPEAT(213),
  [523] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_env_var, 5, 0, 0),
  [525] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_env_var, 5, 0, 0),
  [527] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_ref, 1, 0, 0),
  [529] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable_ref, 1, 0, 0),
  [531] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_normal_var, 4, 0, 0),
  [533] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_normal_var, 4, 0, 0),
  [535] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__paren_argument, 3, 0, 0),
  [537] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__paren_argument, 3, 0, 0),
  [539] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quoted_argument, 3, 0, 0),
  [541] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_quoted_argument, 3, 0, 0),
  [543] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_cache_var, 5, 0, 0),
  [545] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_cache_var, 5, 0, 0),
  [547] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_quoted_argument, 2, 0, 0),
  [549] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_quoted_argument, 2, 0, 0),
  [551] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__paren_argument, 2, 0, 0),
  [553] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__paren_argument, 2, 0, 0),
  [555] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument, 1, 0, 0),
  [557] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument, 1, 0, 0),
  [559] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_escape_sequence, 1, 0, 0),
  [561] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_escape_sequence, 1, 0, 0),
  [563] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endfunction_command, 4, 0, 0),
  [565] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endfunction_command, 4, 0, 0),
  [567] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endmacro_command, 3, 0, 0),
  [569] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endmacro_command, 3, 0, 0),
  [571] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endwhile_command, 4, 0, 0),
  [573] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endwhile_command, 4, 0, 0),
  [575] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_normal_command, 4, 0, 0),
  [577] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_normal_command, 4, 0, 0),
  [579] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endmacro_command, 4, 0, 0),
  [581] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endmacro_command, 4, 0, 0),
  [583] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endblock_command, 4, 0, 0),
  [585] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endblock_command, 4, 0, 0),
  [587] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_elseif_command, 4, 0, 0),
  [589] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_elseif_command, 4, 0, 0),
  [591] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_def, 3, 0, 0),
  [593] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_def, 3, 0, 0),
  [595] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endforeach_command, 5, 0, 0),
  [597] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endforeach_command, 5, 0, 0),
  [599] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endfunction_command, 5, 0, 0),
  [601] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endfunction_command, 5, 0, 0),
  [603] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endmacro_command, 5, 0, 0),
  [605] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endmacro_command, 5, 0, 0),
  [607] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endblock_command, 5, 0, 0),
  [609] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endblock_command, 5, 0, 0),
  [611] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endwhile_command, 6, 0, 0),
  [613] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endwhile_command, 6, 0, 0),
  [615] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endwhile_command, 7, 0, 0),
  [617] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endwhile_command, 7, 0, 0),
  [619] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_macro_def, 3, 0, 0),
  [621] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_macro_def, 3, 0, 0),
  [623] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_normal_command, 5, 0, 0),
  [625] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_normal_command, 5, 0, 0),
  [627] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_def, 3, 0, 0),
  [629] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_def, 3, 0, 0),
  [631] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_while_loop, 3, 0, 0),
  [633] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_while_loop, 3, 0, 0),
  [635] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_foreach_loop, 3, 0, 0),
  [637] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_foreach_loop, 3, 0, 0),
  [639] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endif_command, 4, 0, 0),
  [641] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endif_command, 4, 0, 0),
  [643] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endif_command, 5, 0, 0),
  [645] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endif_command, 5, 0, 0),
  [647] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_condition, 3, 0, 0),
  [649] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_condition, 3, 0, 0),
  [651] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endif_command, 3, 0, 0),
  [653] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endif_command, 3, 0, 0),
  [655] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_normal_command, 3, 0, 0),
  [657] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_normal_command, 3, 0, 0),
  [659] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_command, 4, 0, 0),
  [661] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_command, 4, 0, 0),
  [663] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_condition, 2, 0, 0),
  [665] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_condition, 2, 0, 0),
  [667] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endblock_command, 3, 0, 0),
  [669] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endblock_command, 3, 0, 0),
  [671] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_elseif_command, 5, 0, 0),
  [673] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_elseif_command, 5, 0, 0),
  [675] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endforeach_command, 4, 0, 0),
  [677] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endforeach_command, 4, 0, 0),
  [679] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_command, 4, 0, 0),
  [681] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_command, 4, 0, 0),
  [683] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endfunction_command, 3, 0, 0),
  [685] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endfunction_command, 3, 0, 0),
  [687] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endwhile_command, 3, 0, 0),
  [689] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endwhile_command, 3, 0, 0),
  [691] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_command, 3, 0, 0),
  [693] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_command, 3, 0, 0),
  [695] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_endforeach_command, 3, 0, 0),
  [697] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_endforeach_command, 3, 0, 0),
  [699] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if_command, 5, 0, 0),
  [701] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if_command, 5, 0, 0),
  [703] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_else_command, 5, 0, 0),
  [705] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_else_command, 5, 0, 0),
  [707] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__quoted_text_repeat1, 1, 0, 0),
  [709] = {.entry = {.count = 1, .reusable = true}}, SHIFT(202),
  [711] = {.entry = {.count = 1, .reusable = true}}, SHIFT(778),
  [713] = {.entry = {.count = 1, .reusable = true}}, SHIFT(779),
  [715] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__quoted_text_repeat1, 1, 0, 0),
  [717] = {.entry = {.count = 1, .reusable = true}}, SHIFT(210),
  [719] = {.entry = {.count = 1, .reusable = true}}, SHIFT(786),
  [721] = {.entry = {.count = 1, .reusable = true}}, SHIFT(787),
  [723] = {.entry = {.count = 1, .reusable = true}}, SHIFT(207),
  [725] = {.entry = {.count = 1, .reusable = true}}, SHIFT(790),
  [727] = {.entry = {.count = 1, .reusable = true}}, SHIFT(791),
  [729] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__unquoted_text_repeat1, 2, 0, 0), SHIFT_REPEAT(437),
  [732] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__unquoted_text_repeat1, 2, 0, 0), SHIFT_REPEAT(437),
  [735] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__unquoted_text_repeat1, 2, 0, 0),
  [737] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__unquoted_text_repeat1, 2, 0, 0), SHIFT_REPEAT(438),
  [740] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__unquoted_text_repeat1, 2, 0, 0), SHIFT_REPEAT(438),
  [743] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_command, 5, 0, 0),
  [745] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_command, 5, 0, 0),
  [747] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_command, 5, 0, 0),
  [749] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_command, 5, 0, 0),
  [751] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_while_command, 5, 0, 0),
  [753] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_while_command, 5, 0, 0),
  [755] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_command, 4, 0, 0),
  [757] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_command, 4, 0, 0),
  [759] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_foreach_command, 5, 0, 0),
  [761] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_foreach_command, 5, 0, 0),
  [763] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__quoted_text_repeat1, 2, 0, 0),
  [765] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__quoted_text_repeat1, 2, 0, 0), SHIFT_REPEAT(444),
  [768] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__quoted_text_repeat1, 2, 0, 0), SHIFT_REPEAT(444),
  [771] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_macro_command, 5, 0, 0),
  [773] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_macro_command, 5, 0, 0),
  [775] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_while_command, 4, 0, 0),
  [777] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_while_command, 4, 0, 0),
  [779] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_foreach_command, 4, 0, 0),
  [781] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_foreach_command, 4, 0, 0),
  [783] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_block_command, 4, 0, 0),
  [785] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_block_command, 4, 0, 0),
  [787] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_macro_command, 4, 0, 0),
  [789] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_macro_command, 4, 0, 0),
  [791] = {.entry = {.count = 1, .reusable = true}}, SHIFT(166),
  [793] = {.entry = {.count = 1, .reusable = true}}, SHIFT(516),
  [795] = {.entry = {.count = 1, .reusable = true}}, SHIFT(56),
  [797] = {.entry = {.count = 1, .reusable = true}}, SHIFT(552),
  [799] = {.entry = {.count = 1, .reusable = true}}, SHIFT(588),
  [801] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [803] = {.entry = {.count = 1, .reusable = true}}, SHIFT(521),
  [805] = {.entry = {.count = 1, .reusable = true}}, SHIFT(66),
  [807] = {.entry = {.count = 1, .reusable = true}}, SHIFT(106),
  [809] = {.entry = {.count = 1, .reusable = true}}, SHIFT(68),
  [811] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [813] = {.entry = {.count = 1, .reusable = true}}, SHIFT(542),
  [815] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [817] = {.entry = {.count = 1, .reusable = true}}, SHIFT(557),
  [819] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [821] = {.entry = {.count = 1, .reusable = true}}, SHIFT(580),
  [823] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [825] = {.entry = {.count = 1, .reusable = true}}, SHIFT(558),
  [827] = {.entry = {.count = 1, .reusable = true}}, SHIFT(17),
  [829] = {.entry = {.count = 1, .reusable = true}}, SHIFT(474),
  [831] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [833] = {.entry = {.count = 1, .reusable = true}}, SHIFT(59),
  [835] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [837] = {.entry = {.count = 1, .reusable = true}}, SHIFT(58),
  [839] = {.entry = {.count = 1, .reusable = true}}, SHIFT(592),
  [841] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [843] = {.entry = {.count = 1, .reusable = true}}, SHIFT(54),
  [845] = {.entry = {.count = 1, .reusable = true}}, SHIFT(482),
  [847] = {.entry = {.count = 1, .reusable = true}}, SHIFT(53),
  [849] = {.entry = {.count = 1, .reusable = true}}, SHIFT(483),
  [851] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [853] = {.entry = {.count = 1, .reusable = true}}, SHIFT(485),
  [855] = {.entry = {.count = 1, .reusable = true}}, SHIFT(587),
  [857] = {.entry = {.count = 1, .reusable = true}}, SHIFT(486),
  [859] = {.entry = {.count = 1, .reusable = true}}, SHIFT(164),
  [861] = {.entry = {.count = 1, .reusable = true}}, SHIFT(487),
  [863] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [865] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [867] = {.entry = {.count = 1, .reusable = true}}, SHIFT(493),
  [869] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [871] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [873] = {.entry = {.count = 1, .reusable = true}}, SHIFT(537),
  [875] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [877] = {.entry = {.count = 1, .reusable = true}}, SHIFT(538),
  [879] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [881] = {.entry = {.count = 1, .reusable = true}}, SHIFT(554),
  [883] = {.entry = {.count = 1, .reusable = true}}, SHIFT(586),
  [885] = {.entry = {.count = 1, .reusable = true}}, SHIFT(472),
  [887] = {.entry = {.count = 1, .reusable = true}}, SHIFT(162),
  [889] = {.entry = {.count = 1, .reusable = true}}, SHIFT(484),
  [891] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [893] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [895] = {.entry = {.count = 1, .reusable = true}}, SHIFT(501),
  [897] = {.entry = {.count = 1, .reusable = true}}, SHIFT(26),
  [899] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [901] = {.entry = {.count = 1, .reusable = true}}, SHIFT(539),
  [903] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [905] = {.entry = {.count = 1, .reusable = true}}, SHIFT(495),
  [907] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [909] = {.entry = {.count = 1, .reusable = true}}, SHIFT(572),
  [911] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [913] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [915] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [917] = {.entry = {.count = 1, .reusable = true}}, SHIFT(571),
  [919] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [921] = {.entry = {.count = 1, .reusable = true}}, SHIFT(475),
  [923] = {.entry = {.count = 1, .reusable = true}}, SHIFT(57),
  [925] = {.entry = {.count = 1, .reusable = true}}, SHIFT(573),
  [927] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [929] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [931] = {.entry = {.count = 1, .reusable = true}}, SHIFT(595),
  [933] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [935] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_if_command_repeat1, 2, 0, 0),
  [937] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_if_command_repeat1, 2, 0, 0), SHIFT_REPEAT(516),
  [940] = {.entry = {.count = 1, .reusable = true}}, SHIFT(163),
  [942] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [944] = {.entry = {.count = 1, .reusable = true}}, SHIFT(508),
  [946] = {.entry = {.count = 1, .reusable = true}}, SHIFT(23),
  [948] = {.entry = {.count = 1, .reusable = true}}, SHIFT(503),
  [950] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [952] = {.entry = {.count = 1, .reusable = true}}, SHIFT(512),
  [954] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [956] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [958] = {.entry = {.count = 1, .reusable = true}}, SHIFT(513),
  [960] = {.entry = {.count = 1, .reusable = true}}, SHIFT(598),
  [962] = {.entry = {.count = 1, .reusable = true}}, SHIFT(514),
  [964] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [966] = {.entry = {.count = 1, .reusable = true}}, SHIFT(515),
  [968] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [970] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [972] = {.entry = {.count = 1, .reusable = true}}, SHIFT(525),
  [974] = {.entry = {.count = 1, .reusable = true}}, SHIFT(25),
  [976] = {.entry = {.count = 1, .reusable = true}}, SHIFT(22),
  [978] = {.entry = {.count = 1, .reusable = true}}, SHIFT(527),
  [980] = {.entry = {.count = 1, .reusable = true}}, SHIFT(167),
  [982] = {.entry = {.count = 1, .reusable = true}}, SHIFT(470),
  [984] = {.entry = {.count = 1, .reusable = true}}, SHIFT(620),
  [986] = {.entry = {.count = 1, .reusable = true}}, SHIFT(559),
  [988] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [990] = {.entry = {.count = 1, .reusable = true}}, SHIFT(19),
  [992] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [994] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [996] = {.entry = {.count = 1, .reusable = true}}, SHIFT(507),
  [998] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [1000] = {.entry = {.count = 1, .reusable = true}}, SHIFT(476),
  [1002] = {.entry = {.count = 1, .reusable = true}}, SHIFT(55),
  [1004] = {.entry = {.count = 1, .reusable = true}}, SHIFT(575),
  [1006] = {.entry = {.count = 1, .reusable = true}}, SHIFT(65),
  [1008] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [1010] = {.entry = {.count = 1, .reusable = true}}, SHIFT(77),
  [1012] = {.entry = {.count = 1, .reusable = true}}, SHIFT(606),
  [1014] = {.entry = {.count = 1, .reusable = true}}, SHIFT(169),
  [1016] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [1018] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [1020] = {.entry = {.count = 1, .reusable = true}}, SHIFT(531),
  [1022] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [1024] = {.entry = {.count = 1, .reusable = true}}, SHIFT(532),
  [1026] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [1028] = {.entry = {.count = 1, .reusable = true}}, SHIFT(533),
  [1030] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [1032] = {.entry = {.count = 1, .reusable = true}}, SHIFT(562),
  [1034] = {.entry = {.count = 1, .reusable = true}}, SHIFT(597),
  [1036] = {.entry = {.count = 1, .reusable = true}}, SHIFT(78),
  [1038] = {.entry = {.count = 1, .reusable = true}}, SHIFT(555),
  [1040] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [1042] = {.entry = {.count = 1, .reusable = true}}, SHIFT(565),
  [1044] = {.entry = {.count = 1, .reusable = true}}, SHIFT(614),
  [1046] = {.entry = {.count = 1, .reusable = true}}, SHIFT(540),
  [1048] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [1050] = {.entry = {.count = 1, .reusable = true}}, SHIFT(541),
  [1052] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [1054] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [1056] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [1058] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [1060] = {.entry = {.count = 1, .reusable = true}}, SHIFT(61),
  [1062] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [1064] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [1066] = {.entry = {.count = 1, .reusable = true}}, SHIFT(627),
  [1068] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [1070] = {.entry = {.count = 1, .reusable = true}}, SHIFT(583),
  [1072] = {.entry = {.count = 1, .reusable = true}}, SHIFT(170),
  [1074] = {.entry = {.count = 1, .reusable = true}}, SHIFT(517),
  [1076] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [1078] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [1080] = {.entry = {.count = 1, .reusable = true}}, SHIFT(556),
  [1082] = {.entry = {.count = 1, .reusable = true}}, SHIFT(605),
  [1084] = {.entry = {.count = 1, .reusable = true}}, SHIFT(547),
  [1086] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [1088] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [1090] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [1092] = {.entry = {.count = 1, .reusable = true}}, SHIFT(83),
  [1094] = {.entry = {.count = 1, .reusable = true}}, SHIFT(632),
  [1096] = {.entry = {.count = 1, .reusable = true}}, SHIFT(165),
  [1098] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [1100] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [1102] = {.entry = {.count = 1, .reusable = true}}, SHIFT(24),
  [1104] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [1106] = {.entry = {.count = 1, .reusable = true}}, SHIFT(570),
  [1108] = {.entry = {.count = 1, .reusable = true}}, SHIFT(21),
  [1110] = {.entry = {.count = 1, .reusable = true}}, SHIFT(633),
  [1112] = {.entry = {.count = 1, .reusable = true}}, SHIFT(569),
  [1114] = {.entry = {.count = 1, .reusable = true}}, SHIFT(20),
  [1116] = {.entry = {.count = 1, .reusable = true}}, SHIFT(568),
  [1118] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [1120] = {.entry = {.count = 1, .reusable = true}}, SHIFT(584),
  [1122] = {.entry = {.count = 1, .reusable = true}}, SHIFT(201),
  [1124] = {.entry = {.count = 1, .reusable = true}}, SHIFT(782),
  [1126] = {.entry = {.count = 1, .reusable = true}}, SHIFT(783),
  [1128] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [1130] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [1132] = {.entry = {.count = 1, .reusable = true}}, SHIFT(566),
  [1134] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [1136] = {.entry = {.count = 1, .reusable = true}}, SHIFT(567),
  [1138] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [1140] = {.entry = {.count = 1, .reusable = true}}, SHIFT(100),
  [1142] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [1144] = {.entry = {.count = 1, .reusable = true}}, SHIFT(553),
  [1146] = {.entry = {.count = 1, .reusable = true}}, SHIFT(255),
  [1148] = {.entry = {.count = 1, .reusable = false}}, SHIFT(173),
  [1150] = {.entry = {.count = 1, .reusable = true}}, SHIFT(368),
  [1152] = {.entry = {.count = 1, .reusable = false}}, SHIFT(181),
  [1154] = {.entry = {.count = 1, .reusable = true}}, SHIFT(226),
  [1156] = {.entry = {.count = 1, .reusable = false}}, SHIFT(185),
  [1158] = {.entry = {.count = 1, .reusable = true}}, SHIFT(488),
  [1160] = {.entry = {.count = 1, .reusable = true}}, SHIFT(489),
  [1162] = {.entry = {.count = 1, .reusable = true}}, SHIFT(490),
  [1164] = {.entry = {.count = 1, .reusable = true}}, SHIFT(374),
  [1166] = {.entry = {.count = 1, .reusable = false}}, SHIFT(184),
  [1168] = {.entry = {.count = 1, .reusable = true}}, SHIFT(491),
  [1170] = {.entry = {.count = 1, .reusable = true}}, SHIFT(492),
  [1172] = {.entry = {.count = 1, .reusable = true}}, SHIFT(341),
  [1174] = {.entry = {.count = 1, .reusable = false}}, SHIFT(174),
  [1176] = {.entry = {.count = 1, .reusable = true}}, SHIFT(582),
  [1178] = {.entry = {.count = 1, .reusable = true}}, SHIFT(320),
  [1180] = {.entry = {.count = 1, .reusable = false}}, SHIFT(180),
  [1182] = {.entry = {.count = 1, .reusable = true}}, SHIFT(334),
  [1184] = {.entry = {.count = 1, .reusable = false}}, SHIFT(175),
  [1186] = {.entry = {.count = 1, .reusable = true}}, SHIFT(518),
  [1188] = {.entry = {.count = 1, .reusable = true}}, SHIFT(520),
  [1190] = {.entry = {.count = 1, .reusable = true}}, SHIFT(522),
  [1192] = {.entry = {.count = 1, .reusable = true}}, SHIFT(523),
  [1194] = {.entry = {.count = 1, .reusable = true}}, SHIFT(524),
  [1196] = {.entry = {.count = 1, .reusable = true}}, SHIFT(574),
  [1198] = {.entry = {.count = 1, .reusable = true}}, SHIFT(418),
  [1200] = {.entry = {.count = 1, .reusable = false}}, SHIFT(179),
  [1202] = {.entry = {.count = 1, .reusable = true}}, SHIFT(305),
  [1204] = {.entry = {.count = 1, .reusable = false}}, SHIFT(176),
  [1206] = {.entry = {.count = 1, .reusable = true}}, SHIFT(576),
  [1208] = {.entry = {.count = 1, .reusable = true}}, SHIFT(529),
  [1210] = {.entry = {.count = 1, .reusable = true}}, SHIFT(530),
  [1212] = {.entry = {.count = 1, .reusable = true}}, SHIFT(534),
  [1214] = {.entry = {.count = 1, .reusable = true}}, SHIFT(546),
  [1216] = {.entry = {.count = 1, .reusable = true}}, SHIFT(549),
  [1218] = {.entry = {.count = 1, .reusable = true}}, SHIFT(577),
  [1220] = {.entry = {.count = 1, .reusable = true}}, SHIFT(298),
  [1222] = {.entry = {.count = 1, .reusable = false}}, SHIFT(178),
  [1224] = {.entry = {.count = 1, .reusable = true}}, SHIFT(536),
  [1226] = {.entry = {.count = 1, .reusable = true}}, SHIFT(496),
  [1228] = {.entry = {.count = 1, .reusable = true}}, SHIFT(511),
  [1230] = {.entry = {.count = 1, .reusable = true}}, SHIFT(585),
  [1232] = {.entry = {.count = 1, .reusable = true}}, SHIFT(543),
  [1234] = {.entry = {.count = 1, .reusable = true}}, SHIFT(263),
  [1236] = {.entry = {.count = 1, .reusable = false}}, SHIFT(177),
  [1238] = {.entry = {.count = 1, .reusable = true}}, SHIFT(497),
  [1240] = {.entry = {.count = 1, .reusable = true}}, SHIFT(544),
  [1242] = {.entry = {.count = 1, .reusable = true}}, SHIFT(498),
  [1244] = {.entry = {.count = 1, .reusable = true}}, SHIFT(545),
  [1246] = {.entry = {.count = 1, .reusable = true}}, SHIFT(550),
  [1248] = {.entry = {.count = 1, .reusable = true}}, SHIFT(551),
  [1250] = {.entry = {.count = 1, .reusable = true}}, SHIFT(404),
  [1252] = {.entry = {.count = 1, .reusable = false}}, SHIFT(182),
  [1254] = {.entry = {.count = 1, .reusable = true}}, SHIFT(564),
  [1256] = {.entry = {.count = 1, .reusable = true}}, SHIFT(499),
  [1258] = {.entry = {.count = 1, .reusable = true}}, SHIFT(561),
  [1260] = {.entry = {.count = 1, .reusable = true}}, SHIFT(500),
  [1262] = {.entry = {.count = 1, .reusable = true}}, SHIFT(271),
  [1264] = {.entry = {.count = 1, .reusable = false}}, SHIFT(183),
  [1266] = {.entry = {.count = 1, .reusable = true}}, SHIFT(346),
  [1268] = {.entry = {.count = 1, .reusable = false}}, SHIFT(172),
  [1270] = {.entry = {.count = 1, .reusable = true}}, SHIFT(581),
  [1272] = {.entry = {.count = 1, .reusable = true}}, SHIFT(315),
  [1274] = {.entry = {.count = 1, .reusable = true}}, SHIFT(379),
  [1276] = {.entry = {.count = 1, .reusable = true}}, SHIFT(380),
  [1278] = {.entry = {.count = 1, .reusable = true}}, SHIFT(381),
  [1280] = {.entry = {.count = 1, .reusable = true}}, SHIFT(382),
  [1282] = {.entry = {.count = 1, .reusable = true}}, SHIFT(383),
  [1284] = {.entry = {.count = 1, .reusable = true}}, SHIFT(395),
  [1286] = {.entry = {.count = 1, .reusable = true}}, SHIFT(230),
  [1288] = {.entry = {.count = 1, .reusable = true}}, SHIFT(436),
  [1290] = {.entry = {.count = 1, .reusable = true}}, SHIFT(439),
  [1292] = {.entry = {.count = 1, .reusable = true}}, SHIFT(402),
  [1294] = {.entry = {.count = 1, .reusable = true}}, SHIFT(445),
  [1296] = {.entry = {.count = 1, .reusable = true}}, SHIFT(440),
  [1298] = {.entry = {.count = 1, .reusable = true}}, SHIFT(408),
  [1300] = {.entry = {.count = 1, .reusable = true}}, SHIFT(409),
  [1302] = {.entry = {.count = 1, .reusable = true}}, SHIFT(410),
  [1304] = {.entry = {.count = 1, .reusable = true}}, SHIFT(411),
  [1306] = {.entry = {.count = 1, .reusable = true}}, SHIFT(412),
  [1308] = {.entry = {.count = 1, .reusable = true}}, SHIFT(413),
  [1310] = {.entry = {.count = 1, .reusable = true}}, SHIFT(441),
  [1312] = {.entry = {.count = 1, .reusable = true}}, SHIFT(443),
  [1314] = {.entry = {.count = 1, .reusable = true}}, SHIFT(258),
  [1316] = {.entry = {.count = 1, .reusable = true}}, SHIFT(218),
  [1318] = {.entry = {.count = 1, .reusable = true}}, SHIFT(196),
  [1320] = {.entry = {.count = 1, .reusable = true}}, SHIFT(206),
  [1322] = {.entry = {.count = 1, .reusable = true}}, SHIFT(768),
  [1324] = {.entry = {.count = 1, .reusable = true}}, SHIFT(767),
  [1326] = {.entry = {.count = 1, .reusable = true}}, SHIFT(378),
  [1328] = {.entry = {.count = 1, .reusable = true}}, SHIFT(372),
  [1330] = {.entry = {.count = 1, .reusable = true}}, SHIFT(365),
  [1332] = {.entry = {.count = 1, .reusable = true}}, SHIFT(454),
  [1334] = {.entry = {.count = 1, .reusable = true}}, SHIFT(251),
  [1336] = {.entry = {.count = 1, .reusable = true}}, SHIFT(352),
  [1338] = {.entry = {.count = 1, .reusable = true}}, SHIFT(351),
  [1340] = {.entry = {.count = 1, .reusable = true}}, SHIFT(350),
  [1342] = {.entry = {.count = 1, .reusable = true}}, SHIFT(349),
  [1344] = {.entry = {.count = 1, .reusable = true}}, SHIFT(348),
  [1346] = {.entry = {.count = 1, .reusable = true}}, SHIFT(743),
  [1348] = {.entry = {.count = 1, .reusable = true}}, SHIFT(742),
  [1350] = {.entry = {.count = 1, .reusable = true}}, SHIFT(347),
  [1352] = {.entry = {.count = 1, .reusable = true}}, SHIFT(451),
  [1354] = {.entry = {.count = 1, .reusable = true}}, SHIFT(452),
  [1356] = {.entry = {.count = 1, .reusable = true}}, SHIFT(259),
  [1358] = {.entry = {.count = 1, .reusable = true}}, SHIFT(338),
  [1360] = {.entry = {.count = 1, .reusable = true}}, SHIFT(339),
  [1362] = {.entry = {.count = 1, .reusable = true}}, SHIFT(450),
  [1364] = {.entry = {.count = 1, .reusable = true}}, SHIFT(331),
  [1366] = {.entry = {.count = 1, .reusable = true}}, SHIFT(216),
  [1368] = {.entry = {.count = 1, .reusable = true}}, SHIFT(214),
  [1370] = {.entry = {.count = 1, .reusable = true}}, SHIFT(316),
  [1372] = {.entry = {.count = 1, .reusable = true}}, SHIFT(635),
  [1374] = {.entry = {.count = 1, .reusable = true}}, SHIFT(709),
  [1376] = {.entry = {.count = 1, .reusable = true}}, SHIFT(314),
  [1378] = {.entry = {.count = 1, .reusable = true}}, SHIFT(448),
  [1380] = {.entry = {.count = 1, .reusable = true}}, SHIFT(449),
  [1382] = {.entry = {.count = 1, .reusable = true}}, SHIFT(442),
  [1384] = {.entry = {.count = 1, .reusable = true}}, SHIFT(446),
  [1386] = {.entry = {.count = 1, .reusable = true}}, SHIFT(447),
  [1388] = {.entry = {.count = 1, .reusable = true}}, SHIFT(313),
  [1390] = {.entry = {.count = 1, .reusable = true}}, SHIFT(312),
  [1392] = {.entry = {.count = 1, .reusable = true}}, SHIFT(311),
  [1394] = {.entry = {.count = 1, .reusable = true}}, SHIFT(459),
  [1396] = {.entry = {.count = 1, .reusable = true}}, SHIFT(460),
  [1398] = {.entry = {.count = 1, .reusable = true}}, SHIFT(219),
  [1400] = {.entry = {.count = 1, .reusable = true}}, SHIFT(275),
  [1402] = {.entry = {.count = 1, .reusable = true}}, SHIFT(303),
  [1404] = {.entry = {.count = 1, .reusable = true}}, SHIFT(461),
  [1406] = {.entry = {.count = 1, .reusable = true}}, SHIFT(741),
  [1408] = {.entry = {.count = 1, .reusable = true}}, SHIFT(253),
  [1410] = {.entry = {.count = 1, .reusable = true}}, SHIFT(268),
  [1412] = {.entry = {.count = 1, .reusable = true}}, SHIFT(682),
  [1414] = {.entry = {.count = 1, .reusable = true}}, SHIFT(681),
  [1416] = {.entry = {.count = 1, .reusable = true}}, SHIFT(295),
  [1418] = {.entry = {.count = 1, .reusable = true}}, SHIFT(276),
  [1420] = {.entry = {.count = 1, .reusable = true}}, SHIFT(366),
  [1422] = {.entry = {.count = 1, .reusable = true}}, SHIFT(284),
  [1424] = {.entry = {.count = 1, .reusable = true}}, SHIFT(282),
  [1426] = {.entry = {.count = 1, .reusable = true}}, SHIFT(281),
  [1428] = {.entry = {.count = 1, .reusable = true}}, SHIFT(280),
  [1430] = {.entry = {.count = 1, .reusable = true}}, SHIFT(279),
  [1432] = {.entry = {.count = 1, .reusable = true}}, SHIFT(278),
  [1434] = {.entry = {.count = 1, .reusable = true}}, SHIFT(277),
  [1436] = {.entry = {.count = 1, .reusable = true}}, SHIFT(466),
  [1438] = {.entry = {.count = 1, .reusable = true}}, SHIFT(467),
  [1440] = {.entry = {.count = 1, .reusable = true}}, SHIFT(759),
  [1442] = {.entry = {.count = 1, .reusable = true}}, SHIFT(639),
  [1444] = {.entry = {.count = 1, .reusable = true}}, SHIFT(640),
  [1446] = {.entry = {.count = 1, .reusable = true}}, SHIFT(269),
  [1448] = {.entry = {.count = 1, .reusable = true}}, SHIFT(468),
  [1450] = {.entry = {.count = 1, .reusable = true}}, SHIFT(302),
  [1452] = {.entry = {.count = 1, .reusable = true}}, SHIFT(355),
  [1454] = {.entry = {.count = 1, .reusable = true}}, SHIFT(774),
  [1456] = {.entry = {.count = 1, .reusable = true}}, SHIFT(237),
  [1458] = {.entry = {.count = 1, .reusable = true}}, SHIFT(236),
  [1460] = {.entry = {.count = 1, .reusable = true}}, SHIFT(235),
  [1462] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [1464] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [1466] = {.entry = {.count = 1, .reusable = true}}, SHIFT(232),
  [1468] = {.entry = {.count = 1, .reusable = true}}, SHIFT(458),
  [1470] = {.entry = {.count = 1, .reusable = true}}, SHIFT(660),
  [1472] = {.entry = {.count = 1, .reusable = true}}, SHIFT(661),
  [1474] = {.entry = {.count = 1, .reusable = true}}, SHIFT(197),
  [1476] = {.entry = {.count = 1, .reusable = true}}, SHIFT(199),
  [1478] = {.entry = {.count = 1, .reusable = true}}, SHIFT(211),
  [1480] = {.entry = {.count = 1, .reusable = true}}, SHIFT(212),
  [1482] = {.entry = {.count = 1, .reusable = true}}, SHIFT(209),
  [1484] = {.entry = {.count = 1, .reusable = true}}, SHIFT(208),
  [1486] = {.entry = {.count = 1, .reusable = true}}, SHIFT(244),
  [1488] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [1490] = {.entry = {.count = 1, .reusable = true}}, SHIFT(203),
  [1492] = {.entry = {.count = 1, .reusable = true}}, SHIFT(204),
  [1494] = {.entry = {.count = 1, .reusable = true}}, SHIFT(455),
  [1496] = {.entry = {.count = 1, .reusable = true}}, SHIFT(239),
  [1498] = {.entry = {.count = 1, .reusable = true}}, SHIFT(766),
};

enum ts_external_scanner_symbol_identifiers {
  ts_external_token_bracket_argument = 0,
  ts_external_token_bracket_comment = 1,
  ts_external_token_line_comment = 2,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token_bracket_argument] = sym_bracket_argument,
  [ts_external_token_bracket_comment] = sym_bracket_comment,
  [ts_external_token_line_comment] = sym_line_comment,
};

static const bool ts_external_scanner_states[4][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token_bracket_argument] = true,
    [ts_external_token_bracket_comment] = true,
    [ts_external_token_line_comment] = true,
  },
  [2] = {
    [ts_external_token_bracket_comment] = true,
    [ts_external_token_line_comment] = true,
  },
  [3] = {
    [ts_external_token_bracket_argument] = true,
  },
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_cmake_external_scanner_create(void);
void tree_sitter_cmake_external_scanner_destroy(void *);
bool tree_sitter_cmake_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_cmake_external_scanner_serialize(void *, char *);
void tree_sitter_cmake_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef TREE_SITTER_HIDE_SYMBOLS
#define TS_PUBLIC
#elif defined(_WIN32)
#define TS_PUBLIC __declspec(dllexport)
#else
#define TS_PUBLIC __attribute__((visibility("default")))
#endif

TS_PUBLIC const TSLanguage *tree_sitter_cmake(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .external_scanner = {
      &ts_external_scanner_states[0][0],
      ts_external_scanner_symbol_map,
      tree_sitter_cmake_external_scanner_create,
      tree_sitter_cmake_external_scanner_destroy,
      tree_sitter_cmake_external_scanner_scan,
      tree_sitter_cmake_external_scanner_serialize,
      tree_sitter_cmake_external_scanner_deserialize,
    },
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
