/* handle_options.c
 	vi:ts=3 sw=3:
 */

/* $Id: handle_options.c,v 1.1 1996/03/12 22:35:29 espie Exp espie $
 * $Log: handle_options.c,v $
 * Revision 1.1  1996/03/12 22:35:29  espie
 * Initial revision
 *
 * Revision 1.3  1995/09/17 23:27:13  espie
 * *** empty log message ***
 *
 * Revision 1.2  1995/09/16 15:32:52  espie
 * Newer options.
 *
 * Revision 1.1  1995/09/07 14:33:24  espie
 * Initial revision
 *
 */


#include "defs.h"
#include "extern.h"
#include <ctype.h>

#include <exec/types.h>
#include <exec/memory.h>
#include <proto/dos.h>
#include <proto/exec.h>
#include <dos/dosasl.h>
#include <dos/dosextens.h>
#include <exec/libraries.h>

#include "Arch/amiga/wb2cli.h"
#include "tags.h"
#include "prefs.h"

XT void print_usage P((void));

/* arg parser for command-line options. */

LOCAL char *template = 
"FILES/M,HELP/S,QUIET/S,TOLERANT/S,PICKY/S,NEW/S,OLD/S,BOTH/S,V=VERBOSE/S,\
TRANS=TRANSPOSE/K/N,R=REPEATS/K,SPEED/K/N,START/K,\
CUT/K,ADD/K,SCROLL/S,GUI/S,SPEEDMODE/K,\
RAND=RANDOMIZE/S,LOOP/S,LIST/K";

LOCAL struct RDArgs *rdargs = 0;

LOCAL void free_args()
   {
   if (rdargs)
      FreeArgs(rdargs);
   }

unsigned long half_mask = 0;
int ask_freq;		/* parameters for setup audio */
int oversample;
int stereo;

int start;			/* parameters for st_play */
int trandom;

int loop = FALSE;	/* main automaton looping at end of argv ? */



#define OPT_HELP 1
#define OPT_QUIET 2
#define OPT_TOLERANT 3
#define OPT_PICKY 4
#define OPT_NEW 5
#define OPT_OLD 6
#define OPT_BOTH 7
#define OPT_VERBOSE 8
#define OPT_TRANSPOSE 9
#define OPT_REPEATS 10
#define OPT_SPEED 11
#define OPT_START 12
#define OPT_CUT 13
#define OPT_ADD 14
#define OPT_SHOW 15
#define OPT_GUI 16
#define OPT_SPEEDMODE 17
#define OPT_RANDOM 18
#define OPT_LOOP 19
#define OPT_LIST 20



LOCAL LONG args[24];

/* initialize all options to default values */
void set_default_prefs()
	{
   start = 0;
   set_pref_scalar(PREF_IMASK, 0);
   set_pref_scalar(PREF_BCDVOL, 0);
   set_pref_scalar(PREF_DUMP, FALSE);
	set_pref_scalar(PREF_SPEEDMODE, NORMAL_SPEEDMODE);
   set_pref_scalar(PREF_SPEED, 50);
   set_pref_scalar(PREF_TYPE, BOTH);
   set_pref_scalar(PREF_OUTPUT, TRUE);
   set_pref_scalar(PREF_REPEATS, 1);
	}

LOCAL unsigned long get_mask(s)
char *s;
	{
	char c;
	unsigned long mask = 0;

	while (c = *s++)
		{			
			/* this is not ANSI and depends on the char set being
			 * ASCII-like contiguous
			 */
		 if (c >= '1' && c <= '9')
		 	mask |= 1 << (c-'0');
		else if (c >= 'a' && c <= 'z')
			mask |= 1 << (c-'a'+10);
		else if (c >= 'A' && c <= 'Z')
			mask |= 1 << (c-'A'+10);
		}
	return mask;
	}
			
#define MAXLINELENGTH 200
LOCAL char linebuf[MAXLINELENGTH+1];

LOCAL char *read_line(f)
struct exfile *f;
	{
	int i, c;

	i = 0;
	while (((c = getc_file(f)) != EOF) && (c != '\n'))
		{
		if (i < MAXLINELENGTH)
			linebuf[i++] = c;
		}
	if (c == EOF)
		return 0;
	else
		{
		char *s;

		s = malloc(i+1);
		strncpy(s, linebuf, i);
		s[i] = 0;
		return s;
		}
	}

/* add test for >=37 */

XT struct DosLibrary *DOSBase;      
XT struct WBStartup *_WBenchMsg;

void handle_options(argc, argv)
int argc;
char *argv[];
	{
	char **name;

   if (DOSBase->dl_lib.lib_Version < 37)
      end_all("Need OS >= 2.04");
   
   if (argc > 0)        /* CLI */
      {
      /* check the command name for default reading type */

      rdargs = ReadArgs(template, args, 0);
      if (rdargs)
         at_end(free_args);
      else
         end_all(0);
      }
   else
      (void)WB2CLI(_WBenchMsg, 4000, DOSBase);

/*
	if (s = getenv("TRACKER_DEFAULTS"))
		{
		int t;
		char **v;

		t = string2args(s, 0);
		v = malloc(sizeof(char *) * t);
		string2args(s, v);
		parse_options(t, v, add_play_list);
		free(v);
		}
*/
   if (args[0])
      {
      for (name = args[0]; *name; name++)
         add_play_list(*name);
      }
   if (args[OPT_CUT])
      set_pref_scalar(PREF_IMASK, get_mask(args[OPT_CUT]));
   if (args[OPT_ADD])
      set_pref_scalar(PREF_IMASK, ~get_mask(args[OPT_ADD]));
   if (args[OPT_OLD])
      set_pref_scalar(PREF_TYPE, OLD);
   if (args[OPT_NEW])
      set_pref_scalar(PREF_TYPE, NEW);
   if (args[OPT_SPEEDMODE])
      {
      char *check;
      int mode;
      
      check = args[OPT_SPEEDMODE];
		if (stricmp(check, "normal") == 0)
			mode = NORMAL_SPEEDMODE;
		else if (stricmp(check, "finespeed") == 0)
			mode = FINESPEED_ONLY;
		else if (stricmp(check, "speed") == 0)
			mode = SPEED_ONLY;
		else if (stricmp(check, "old") == 0)
			mode = OLD_SPEEDMODE;
		else if (stricmp(check, "vblank") == 0)
			mode = OLD_SPEEDMODE;
		else if (stricmp(check, "alter") == 0)
			mode = ALTER_PROTRACKER;
		else
			end_all("Unknwon speedmode");
		set_pref_scalar(PREF_SPEEDMODE, mode);
	   }
   if (args[OPT_SHOW])
      set_pref_scalar(PREF_SHOW, TRUE);
   if (args[OPT_BOTH])
      set_pref_scalar(PREF_TYPE, BOTH);
   if (args[OPT_REPEATS])
      set_pref_scalar(PREF_REPEATS, *((ULONG *)args[OPT_REPEATS]));
   if (args[OPT_SPEED])
      set_pref_scalar(PREF_SPEED, *((ULONG *)args[OPT_SPEED]));
   if (args[OPT_TRANSPOSE])
      set_pref_scalar(PREF_TRANSPOSE, *((ULONG *)args[OPT_TRANSPOSE]));
   else
      set_pref_scalar(PREF_TRANSPOSE, 0);
/*
      transpose = *((LONG *)args[OPT_TRANSPOSE]);
*/
   if (args[OPT_PICKY])
      set_pref_scalar(PREF_TOLERATE, 0);
   else if (args[OPT_TOLERANT])
      set_pref_scalar(PREF_TOLERATE, 2);
   if (args[OPT_START])
      start = *((ULONG *)args[OPT_START]);
   if (args[OPT_HELP])
      {
      print_usage();
      end_all(0);
      }
   if (args[OPT_VERBOSE])
      set_pref_scalar(PREF_DUMP, TRUE);
   if (args[OPT_RANDOM])
      trandom = TRUE;
   if (args[OPT_LOOP])
      loop = TRUE;

	if (args[OPT_LIST])
		{
		struct exfile *file;
		char *s;
		
		file = open_file(args[OPT_LIST], "r", 0);
		if (!file)
			end_all("List file does not exist");
		else
			while (s = read_line(file))
				add_play_list(s);
		close_file(file);
		}
	}
