/****************************************************************************/
/*                                                                          */
/* KEYS.H 08 Apr 2003                                                       */
/*                                                                          */
/* This file is copyright 2003 IBM. See "License" for details               */
/****************************************************************************/
#ifndef KEYS_H
#define KEYS_H

#include <openssl/rsa.h>

typedef struct pubkeydata {
    uint32_t algorithm;
    uint16_t encscheme;
    uint16_t sigscheme;
    uint32_t keybitlen;
    uint32_t numprimes;
    uint32_t expsize;
    unsigned char exponent[3];
    uint32_t keylength;
    unsigned char modulus[256];
    uint32_t pcrinfolen;
    unsigned char pcrinfo[256];
} pubkeydata;

typedef struct keydata {
    unsigned char version[4];
    uint16_t keyusage;
    uint32_t keyflags;
    unsigned char authdatausage;
    pubkeydata pub;
    uint32_t privkeylen;
    unsigned char encprivkey[1024];
} keydata;

int KeyExtract(unsigned char *keybuff, keydata *k);
int PubKeyExtract(unsigned char *pkeybuff, pubkeydata *k, int pcrpresent);
RSA *convpubkey(pubkeydata *k);
int BuildKey(unsigned char *buffer, keydata *k);
int KeySize(unsigned char *keybuff);
int PubKeySize(unsigned char *keybuff, int pcrpresent);

#endif
