/****************************************************************************/
/*                                                                          */
/*                            Unseal a Data File                            */
/*                                                                          */
/*  This file is copyright 2003 IBM. See "License" for details              */
/****************************************************************************/
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <tcpa.h>

int main(int argc, char *argv[])
{
    uint32_t ret;
    struct stat sbuf;
    unsigned char databuff[256];    /* data buffer */
    unsigned int datalen;           /* size of data */
    uint32_t parhandle;             /* handle of parent key */
    unsigned char passhash1[20];    /* hash of parent key password */
    unsigned char passhash2[20];    /* hash of data password */
    unsigned char blob[4096];       /* sealed blob */
    unsigned int bloblen;           /* blob length */
    FILE *infile;
    FILE *outfile;

    if (argc < 6) {
        fprintf(stderr, "Usage: unsealfile <key handle in hex> <key password> <data password> <input file> <outputfile>\n");
        exit(1);
    }
    ret = sscanf(argv[1], "%x", &parhandle);
    if (ret != 1) {
        fprintf(stderr, "Invalid argument '%s'\n", argv[1]);
        exit(2);
    }
    sha1(argv[2], strlen(argv[2]), passhash1);
    sha1(argv[3], strlen(argv[3]), passhash2);
    stat(argv[4], &sbuf);
    bloblen = (int) sbuf.st_size;
    infile = fopen(argv[4], "r");
    if (infile == NULL) {
        fprintf(stderr, "Unable to open input file '%s'\n", argv[4]);
        exit(4);
    }
    ret = fread(blob, 1, bloblen, infile);
    if (ret != bloblen) {
        fprintf(stderr, "I/O Error while reading input file '%s'\n",
                argv[4]);
        exit(5);
    }
    ret = TPM_Unseal(parhandle,          /* KEY Entity Value */
                     passhash1,          /* Key Password */
                     passhash2,          /* blob password */
                     blob, bloblen,      /* encrypted blob, blob length */
                     databuff, &datalen, /* buffer for decrypted data, len */
		     TPMLOG);
    if (ret != 0) {
        printf("Error %d from TPM_Unseal\n", ret);
        exit(6);
    }
    outfile = fopen(argv[5], "w");
    if (outfile == NULL) {
        fprintf(stderr, "Unable to open output file '%s'\n", argv[5]);
        exit(7);
    }
    ret = fwrite(databuff, 1, datalen, outfile);
    if (ret != datalen) {
        fprintf(stderr, "I/O Error while writing output file '%s'\n",
                argv[5]);
        exit(8);
    }
    fclose(outfile);
    exit(0);
}
