/****************************************************************************/
/*                                                                          */
/*                      Create and Load a signing Key                       */
/*                                                                          */
/*  This file is copyright 2003 IBM. See "License" for details              */
/****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <openssl/rsa.h>
#include <openssl/pem.h>
#include <openssl/evp.h>
#include <tcpa.h>

int main(int argc, char *argv[])
{
    uint32_t ret, parhandle;      /* handle of parent key */
    unsigned char hashpass1[20];  /* hash of parent key password */
    keydata q;                    /* keydata structure for resulting key */
    unsigned int newhandle;       /* generated key handle */
    FILE *keyfile;                /* input file for public key */
    unsigned char pkeyname[256];  /* file name string of public key file */

    if (argc < 4) {
        fprintf(stderr, "Usage: loadkey <parent key handle in hex> <parent key password> <key name>\n");
        exit(-1);
    }
    ret = sscanf(argv[1], "%x", &parhandle);
    if (ret != 1) {
        fprintf(stderr, "Invalid argument '%s'\n", argv[1]);
        exit(-1);
    }
    sha1(argv[2], strlen(argv[2]), hashpass1);

    /* load in struct q from name.key file */
    snprintf(pkeyname,sizeof(pkeyname),"%s.key",argv[3]);
    keyfile = fopen(pkeyname,"r");
    ret = fread(&q,sizeof(q),1,keyfile);
    ret = TPM_LoadKey(parhandle, hashpass1, &q, &newhandle, TPMLOG);
    if (ret != 0) {
        fprintf(stderr, "Error %d from TPM_LoadKey\n", ret);
        exit(-1);
    }
    printf("loaded key %s, returned handle %04x\n", argv[3], newhandle);
    fclose(keyfile);
    exit(0);
}
