/* tn5250 -- an implentation of the 5250 telnet protocol.
 * Copyright (C) 1997 Michael Madore
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef UTILITY_H
#define UTILITY_H

unsigned char ascii2ebcdic(unsigned char ascii);
unsigned char ebcdic2ascii(unsigned char ebcdic);
void settransmap(char* map);
int Printable(unsigned char data);
int Attribute(unsigned char data);
int isnumeric(char data);

#ifndef NDEBUG
void log_open (const char *fname);
void log_printf (const char *fmt, ...);
void log_close (void);
#define LOG(args) log_printf args
#ifndef ASSERT
#define ASSERT(expr) assert(expr)
#endif
#else
#define LOG(args)
#ifndef ASSERT
#define ASSERT(expr)
#endif
#endif

#endif /* UTILITY_H */
