/* tn5250 -- an implentation of the 5250 telnet protocol.
 * Copyright (C) 1997 Michael Madore
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "buffer.h"
#include "record.h"
#include "utility.h"
#include <assert.h>
#include <stdio.h>
#include <string.h>
#include <ctype.h>

unsigned char Record::GetByte()
{
   cur_pos++;
   ASSERT (cur_pos <= (length ()-header_length));
   return operator [] (cur_pos-1);
}

void Record::UnGetByte()
{
   LOG (("Record::UnGetByte: entered.\n"));
   ASSERT (cur_pos > 0);
   cur_pos--;
}

void Record::SetFlowType(unsigned char byte1, unsigned char byte2)
{
   flowtype[0] = byte1;
   flowtype[1] = byte2;
}

void Record::SetFlags(unsigned char NewFlags)
{
   flags = NewFlags;
}

void Record::SetOpcode(unsigned char NewOpcode)
{
   opcode = NewOpcode;
}

unsigned char Record::GetOpcode()
{
   return(opcode);
}

int Record::GetFlowType()
{
   return (flowtype[0] << 8) | flowtype[1];
}


void Record::Init()
{
   flags = 0;
   opcode = 0;
   cur_pos = 0;
   length (0);
}

Record::Record()
{
   flags = 0;
   opcode = 0;
   cur_pos = 0;
}

void Record::SetHeaderLength(int hlength)
{
   header_length = hlength;
}

int Record::IsChainEnd()
{
   LOG (("Record::IsChainEnd: entered.\n"));
   LOG (("Record::IsChainEnd: length = 0x%X; cur_pos = 0x%X\n",
      length ()- header_length, cur_pos));
   return( (length ()-header_length) == cur_pos );
}

void Record::Dump()
{
#ifndef NDEBUG
   int pos;
   unsigned char t[17];
   unsigned char c;
   int n;

   for(pos = 0; pos < length ()-header_length ; )
   {
      memset(t, 0, sizeof(t));
      LOG (("Record::Dump: +%4.4X ", pos));
      for (n=0; n < 16; n++)
      {
         if (pos < length ()-header_length)
         {
            c = operator [] (pos);
	    LOG (("%02x", c));
//            c = ebcdic2ascii(c);
            t[n] = (isprint(c))? c : '.';
         }
         else 
	    LOG (("  "));
         pos++;
         if ((pos & 3) == 0)
	    LOG ((" "));
      }
      LOG ((" %s\n", t));
   }
#endif 
}

int Record::SysRequest()
{
   return(flags & H_SRQ);
}

int Record::Attention()
{
   return(flags & H_ATN);
}

