# ProfLycee package
# Matthew Bertucci 2022/11/08 for v2.0.1

#include:xcolor
# xcolor loaded with table and svgnames options
#include:tikz
# loads calc, decorations, decorations.pathreplacing, decorations.markings, arrows,
# arrows.meta, babel, shapes.geometric, and decorations.pathmorphing tikzlibraries
#include:tkz-tab
#include:mathtools
#include:pgf
#include:pgffor
#include:ifthen
#include:xparse
#include:xkeyval
#include:xfp
#include:xstring
#include:xintexpr
#include:xintbinhex
#include:simplekv
#include:listofitems
#include:tabularray
#include:siunitx
#include:fontawesome5
#include:csvsimple-l3
#include:tcolorbox
# tcolorbox loaded with most option and minted library loaded by default
#include:iftex
#include:piton
#include:fancyvrb
#include:pythontex

#keyvals:\usepackage/ProfLycee#c
nonshellescape
build
csvii
#endkeyvals

#ifOption:csvii
#include:csvsimple-legacy
#endif

## L’outil « SplineTikz » ##
\SplineTikz{x1/y1/d1§x2/y2/d2§...}
\SplineTikz[options%keyvals]{x1/y1/d1§x2/y2/d2§...}

#keyvals:\SplineTikz
Couleur=#%color
Epaisseur=##L
Style={%<TikZ clés%>}
Coeffs=
CouleurPoints=#%color
AffPoints#true,false
TaillePoints=##L
#endkeyvals

## L’outil « TangenteTikz » ##
\TangenteTikz{x1/y1/d1§x2/y2/d2§...}
\TangenteTikz[options%keyvals]{x1/y1/d1§x2/y2/d2§...}

#keyvals:\TangenteTikz
Point=%<num%>
Epaisseur=##L
Couleur=#%color
Style={%<TikZ clés%>}
xl=%<num%>
xr=%<num%>
#endkeyvals

## Suites récurrentes et « toile » ##
\ToileRecurrence[options%keyvals]
\ToileRecurrence[options%keyvals][options du tracé]
\ToileRecurrence[options%keyvals][options du tracé][option supplémentaire des termes]

#keyvals:\ToileRecurrence
Fct=%<fonction%>
Nom=%<nom%>
No=%<l’indice initial%>
Uno=%<la valeur du terme initial%>
Nb=%<nombre%>
PosLabel=%<pos%>
DecalLabel=##L
TailleLabel=%<fontsize cmd%>
AffTermes#true,false
#endkeyvals

## L’outil « Calcul Formel » ##
\CalculFormelParametres
\CalculFormelParametres[options%keyvals]

#keyvals:\paramCF
Largeur=%<largeur%>
EspaceLg=##L
PremCol=%<largeur%>
HautPremCol=%<hauteur%>
Taille=%<fontsize cmd%>
Couleur=#%color
Titre#true,false
TailleTitre=%<fontsize cmd%>
PosCmd=#centre,gauche,right
PosRes=#centre,gauche,right
CouleurCmd=#%color
CouleurRes=#%color
Sep#true,false
Menu#true,false
LabelTitre={%<texte%>}
#endkeyvals

\CalculFormelLigne{commande%text}{résultat%text}
\CalculFormelLigne[options%keyvals]{commande%text}{résultat%text}

#keyvals:\CalculFormelLigne
HautCmd=%<hauteur%>
HautRes=%<hauteur%>
#endkeyvals

\CFchap#*
\CFpremcol#*
\CFhpremcol#*

## Code Python « simple » via le package listings ##
\begin{CodePythonLst}{tcolorbox options}#V
\begin{CodePythonLst}[largeur%l]{tcolorbox options}#V
\begin{CodePythonLst}*{tcolorbox options}#V
\begin{CodePythonLst}*[largeur%l]{tcolorbox options}#V
\end{CodePythonLst}

\CodePythonLstFichier{tcolorbox options}{file}#i
\CodePythonLstFichier[largeur%l]{tcolorbox options}{file}#i
\CodePythonLstFichier*{tcolorbox options}{file}#i
\CodePythonLstFichier*[largeur%l]{tcolorbox options}{file}#i

## Code Python via le package piton ##
\begin{CodePiton}#V
\begin{CodePiton}[options%keyvals]#V
\end{CodePiton}

#keyvals:\begin{CodePiton}
Lignes#true,false
Largeur=##L
Alignement=#justify,left,flush left,right,flush right,center,flush center
#endkeyvals

## Code & Console Python, via les packages Pythontex ou Minted ##
\begin{CodePythontex}#V
\begin{CodePythontex}[options%keyvals]#V
\end{CodePythontex}

#keyvals:\begin{envcodepythontex}
Largeur=##L
Centre#true,false
Lignes#true,false
#endkeyvals

\begin{CodePythonMinted}#V
\begin{CodePythonMinted}[largeur%l][tcolorbox options]#V
\begin{CodePythonMinted}*#V
\begin{CodePythonMinted}*[largeur%l][tcolorbox options]#V
\end{CodePythonMinted}

## Code & Console Python, version Pythontex ou Minted ##
\begin{ConsolePythontex}#V
\begin{ConsolePythontex}[options%keyvals]#V
\end{ConsolePythontex}

#keyvals:\begin{ConsolePythontex}
Largeur=##L
Centre#true,false
Label#true,false
#endkeyvals

## Pseudo-Code ##
\begin{PseudoCode}
\begin{PseudoCode}[largeur%l][tcolorbox options]
\begin{PseudoCode}*
\begin{PseudoCode}*[largeur%l][tcolorbox options]
\end{PseudoCode}

## Terminal Windows/UNiX/OSX ##
\begin{TerminalWin}{Titre=%<texte%>}#V
\begin{TerminalWin}[%<largeur%>]{Titre=%<texte%>}[%<tcolorbox options%>]#V
\end{TerminalWin}

\begin{TerminalUnix}{Titre=%<texte%>}#V
\begin{TerminalUnix}[%<largeur%>]{Titre=%<texte%>}[%<tcolorbox options%>]#V
\end{TerminalUnix}

\begin{TerminalOSX}{Titre=%<texte%>}#V
\begin{TerminalOSX}[%<largeur%>]{Titre=%<texte%>}[%<tcolorbox options%>]#V
\end{TerminalOSX}

## Cartouche Capytale ##
\CartoucheCapytale{code capytale}
\CartoucheCapytale[prefix]{code capytale}
\CartoucheCapytale*{code capytale}
\CartoucheCapytale*[prefix]{code capytale}

## Pavé droit « simple » ##
\PaveTikz
\PaveTikz[options%keyvals]

#keyvals:\PaveTikz
Largeur=%<num%>
Profondeur=%<num%>
Hauteur=%<num%>
Angle=%<degrees%>
Fuite=%<num%>
Sommets=%<A1§...§A8%>
Epaisseur=%<épaisseur%>
Aff#true,false
Plein#true,false
Cube#true,false
#endkeyvals

## Tétraèdre « simple » ##
\TetraedreTikz
\TetraedreTikz[options%keyvals]

#keyvals:\TetraedreTikz
Largeur=%<num%>
Profondeur=%<num%>
Hauteur=%<num%>
Alpha=%<degrees%>
Beta=%<degrees%>
Sommets=%<A1§...§A8%>
Epaisseur=%<épaisseur%>
Aff#true,false
Plein#true,false
#endkeyvals

## Cercle trigo ##
\CercleTrigo
\CercleTrigo[options%keyvals]

#keyvals:\CercleTrigo
Rayon=%<rayon%>
Epaisseur=%<épaisseur%>
Epaisseursol=%<épaisseur%>
Marge=%<marge%>
TailleValeurs=%<fontsize cmd%>
TailleAngles=%<fontsize cmd%>
CouleurFond=#%color
Decal=##L
MoinsPi#true,false
AffAngles#true,false
AffTraits#true,false
AffValeurs#true,false
Equationcos#true,false
Equationsin#true,false
cos=%<degrees%>
sin=%<degrees%>
CouleurSol=#%color
#endkeyvals

## Paramètres d’une régression linéaire par la méthode des moindres carrés ##
\CalculsRegLin{listeX}{listeY}
\CalculsRegLin[options%keyvals]{listeX}{listeY}

#keyvals:\CalculsRegLin
NomCoeffa=%<nom%>
NomCoeffb=%<nom%>
NomCoeffr=%<nom%>
NomCoeffrd=%<nom%>
NomXmin=%<nom%>
NomXmax=%<nom%>
#endkeyvals

\LX#*
\LY#*
\LNB#S
\LXSomme#*
\LYSomme#*
\LXmoy#*
\LYmoy#*
\LXvar#*
\LYvar#*
\LXYvar#*

\PointsRegLin{listeX}{listeY}
\PointsRegLin[options%keyvals]{listeX}{listeY}

#keyvals:\PointsRegLin
Couleur=#%color
Taille=##L
Ox=%<num%>
Oy=%<num%>
#endkeyvals

## Statistiques à deux variables ##
#keyvals:\tikz#c,\begin{tikzpicture}#c,\tikzset#c
Ox=%<num%>
Oy=%<num%>
xmin=%<num%>
xmax=%<num%>
ymin=%<num%>
ymax=%<num%>
xgrille=%<num%>
xgrilles=%<num%>
ygrille=%<num%>
ygrilles=%<num%>
xunit=%<num%>
yunit=%<num%>
#endkeyvals

\GrilleTikz
\GrilleTikz[options%keyvals]
\GrilleTikz[options%keyvals][options grille ppale]#*
\GrilleTikz[options%keyvals][options grille ppale][options grille second]

#keyvals:\GrilleTikz
Affp#true,false
Affs#true,false
#endkeyvals

\AxesTikz
\AxesTikz[options%keyvals]

#keyvals:\AxesTikz
Epaisseur=##L
Police=%<font commands%>
Labelx=%<text%>
Labely=%<text%>
AffLabel=#x,y,xy
PosLabelx=%<TikZ pos%>
PosLabely=%<TikZ pos%>
EchelleFleche=%<num%>
TypeFleche=%<type%>
#endkeyvals

\AxexTikz{valeurs}
\AxexTikz[options%keyvals]{valeurs}
\AxeyTikz{valeurs}
\AxeyTikz[options%keyvals]{valeurs}

#keyvals:\AxexTikz,\AxeyTikz
Epaisseur=##L
Police=%<font commands%>
PosGrad=%<TikZ pos%>
HautGrad=##L
AffGrad#true,false
AffOrigine#true,false
Annee#true,false
#endkeyvals

\FenetreTikz
\FenetreSimpleTikz{liste abscisses}{liste ordonnées}
\FenetreSimpleTikz{liste abscisses}<options axe Oy>{liste ordonnées}
\FenetreSimpleTikz<options axe Ox>{liste abscisses}{liste ordonnées}
\FenetreSimpleTikz<options axe Ox>{liste abscisses}<options axe Oy>{liste ordonnées}

\OrigineTikz#*
\OrigineTikz[options%keyvals]#*

#keyvals:\OrigineTikz
Police=%<font commands%>
Pos=%<TikZ pos%>
Decal=##L
Valeur=%<num%>
#endkeyvals

\NuagePointsTikz{listeX}{listeY}
\NuagePointsTikz[options%keyvals]{listeX}{listeY}

#keyvals:\NuagePointsTikz
Taille=##L
Style=#o,x,+
Couleur=#%color
#endkeyvals

\PointMoyenTikz
\PointMoyenTikz[options%keyvals]

#keyvals:\PointMoyenTikz
Police=%<font commands%>
Taille=##L
Couleur=#%color
Style=#o,x,+
xg=%<num%>
yg=%<num%>
Nom=%<text%>
Pos=%<TikZ pos%>
Decal=##L
AffNom#true,false
#endkeyvals

\CourbeTikz{formule}{domaine}
\CourbeTikz[TikZ clés]{formule}{domaine}

\axexOx#*
\axeyOy#*
\xmin#*
\xmax#*
\ymin#*
\ymax#*
\xgrille#*
\xgrilles#*
\ygrille#*
\ygrilles#*
\xunit#*
\yunit#*

## Boîtes à moustaches ##
\BoiteMoustaches{a1/a2/...}
\BoiteMoustaches[options%keyvals]{a1/a2/...}

#keyvals:\BoiteMoustaches
Couleur=#%color
Elevation=%<nombre%>
Hauteur=%<nombre%>
Moyenne=%<nombre%>
Epaisseur=%<épaisseur%>
Remplir=#%color
AffMoyenne#true,false
Pointilles#true,false
Valeurs#true,false
#endkeyvals

\BoiteMoustachesAxe[options%keyvals]

#keyvals:\BoiteMoustachesAxe
Min=%<nombre%>
Max=%<nombre%>
Elargir=%<pourcentage%>
Epaisseur=%<épaisseur%>
Valeurs={%<liste%>}
AffValeurs#true,false
#endkeyvals

## Calculs de probabilités ##
\CalcBinomP{n}{p}{k}
\CalcBinomC{n}{p}{a}{b}
\CalcPoissP{l}{k}
\CalcPoissC{l}{a}{b}
\CalcGeomP{p}{k}
\CalcGeomC{l}{a}{b}
\CalcHypergeomP{N}{n}{m}{k}
\CalcHypergeomC{N}{n}{m}{a}{b}
\CalcNormC{m}{s}{a}{b}
\CalcExpoC{l}{a}{b}

\BinomP{n}{p}{k}
\BinomP[prec]{n}{p}{k}
\BinomP*{n}{p}{k}
\BinomP*[prec]{n}{p}{k}
\BinomC{n}{p}{a}{b}
\BinomC[prec]{n}{p}{a}{b}
\BinomC*{n}{p}{a}{b}
\BinomC*[prec]{n}{p}{a}{b}
\PoissonP{l}{k}
\PoissonP[prec]{l}{k}
\PoissonP*{l}{k}
\PoissonP*[prec]{l}{k}
\PoissonC{l}{a}{b}
\PoissonC[prec]{l}{a}{b}
\PoissonC*{l}{a}{b}
\PoissonC*[prec]{l}{a}{b}
\GeomP{p}{k}
\GeomP[prec]{p}{k}
\GeomP*{p}{k}
\GeomP*[prec]{p}{k}
\GeomC{l}{a}{b}
\GeomC[prec]{l}{a}{b}
\GeomC*{l}{a}{b}
\GeomC*[prec]{l}{a}{b}
\HypergeomP{N}{n}{m}{k}
\HypergeomP[prec]{N}{n}{m}{k}
\HypergeomP*{N}{n}{m}{k}
\HypergeomP*[prec]{N}{n}{m}{k}
\HypergeomC{N}{n}{m}{a}{b}
\HypergeomC[prec]{N}{n}{m}{a}{b}
\HypergeomC*{N}{n}{m}{a}{b}
\HypergeomC*[prec]{N}{n}{m}{a}{b}
\NormaleC{m}{s}{a}{b}
\NormaleC[prec]{m}{s}{a}{b}
\NormaleC*{m}{s}{a}{b}
\NormaleC*[prec]{m}{s}{a}{b}
\ExpoC{l}{a}{b}
\ExpoC[prec]{l}{a}{b}
\ExpoC*{l}{a}{b}
\ExpoC*[prec]{l}{a}{b}

## Arbres de probabilités « classiques » ##
\ArbreProbasTikz{donnees}
\ArbreProbasTikz[options%keyvals]{donnees}
\begin{EnvArbreProbasTikz}{donnees}
\begin{EnvArbreProbasTikz}[options%keyvals]{donnees}
\end{EnvArbreProbasTikz}

#keyvals:\ArbreProbasTikz,\begin{EnvArbreProbasTikz}
Unite=##L
EspaceNiveau=%<nombre%>
EspaceFeuille=%<nombre%>
Type=#2x2,2x3,3x2,3x3
Police=%<font commands%>
PoliceProbas=%<font commands%>
InclineProbas#true,false
Fleche#true,false
StyleTrait={%<TikZ keys%>}
EpaisseurTrait=%<épaisseur%>
#endkeyvals

## Petits schémas pour des probabilités continues ##
\LoiNormaleGraphe{m}{s}{a}{b}
\LoiNormaleGraphe<TikZ options>{m}{s}{a}{b}
\LoiNormaleGraphe[options%keyvals]{m}{s}{a}{b}
\LoiNormaleGraphe[options%keyvals]<TikZ options>{m}{s}{a}{b}
\LoiExpoGraphe{l}{a}{b}
\LoiExpoGraphe<TikZ options>{l}{a}{b}
\LoiExpoGraphe[options%keyvals]{l}{a}{b}
\LoiExpoGraphe[options%keyvals]<TikZ options>{l}{a}{b}

#keyvals:\LoiNormaleGraphe,\LoiExpoGraphe
CouleurAire=#%color
CouleurCourbe=#%color
Largeur=%<nombre%>
Hauteur=%<nombre%>
AfficheM#true,false
AfficheCadre#true,false
#endkeyvals

## Conversions binaire/hexadécimal/décimal ##
\ConversionDecBin{nombre}
\ConversionDecBin[options%keyvals]{nombre}
\ConversionDecBin*{nombre}
\ConversionDecBin*[options%keyvals]{nombre}

#keyvals:\ConversionDecBin,\ConversionDecBin*
AffBase#true,false
#endkeyvals

\ConversionBinHex{nombre}
\ConversionBinHex[options%keyvals]{nombre}

#keyvals:\ConversionBinHex
AffBase#true,false
Details#true,false
#endkeyvals

\ConversionVersDec{nombre}
\ConversionVersDec[options%keyvals]{nombre}
\ConversionBaseDix{nombre}{base de départ}
\ConversionBaseDix[options%keyvals]{nombre}{base de départ}

#keyvals:\ConversionVersDec,\ConversionBaseDix
BaseDep=%<2 ou 16%>
AffBase#true,false
Details#true,false
Zeros#true,false
#endkeyvals

## Conversion « présentée » d’un nombre en décimal ##
\ConversionDepuisBaseDix{nombre en base 10}{base d'arrivée}
\ConversionDepuisBaseDix[options%keyvals]{nombre en base 10}{base d'arrivée}

#keyvals:\ConversionDepuisBaseDix
Couleur=#%color
DecalH=##L
DecalV=##L
Noeud=%<préfixe%>
Rect#true,false
CouleurRes#true,false
#endkeyvals

## Algorithme d’Euclide pour le PGCD ##
\PresentationPGCD{a}{b}
\PresentationPGCD[options%keyvals]{a}{b}

#keyvals:\PresentationPGCD
Couleur=#%color
DecalRect=##L
Rectangle#true,false
Noeud=%<nom du nœud%>
CouleurResultat#true,false
AfficheConclusion#true,false
AfficheDelimiteurs#true,false
#endkeyvals

## Fractions, ensembles ##
\ConversionFraction{fraction expr}
\ConversionFraction[d ou t]{fraction expr}

\EcritureEnsemble{a1/a2/...}
\EcritureEnsemble[options%keyvals]{a1/a2/...}

#keyvals:\EcritureEnsemble
Sep={%<separator%>}
Option={%<code%>}
Mathpunct#true,false
#endkeyvals

## Petits schémas pour le signe d’une fonction affine ou d’un trinôme ##
\MiniSchemaSignes
\MiniSchemaSignes[options%keyvals]

\MiniSchemaSignesTkzTab{numligne}
\MiniSchemaSignesTkzTab{numligne}[echelle]
\MiniSchemaSignesTkzTab{numligne}[echelle][décalage horizontal]
\MiniSchemaSignesTkzTab[options%keyvals]{numligne}
\MiniSchemaSignesTkzTab[options%keyvals]{numligne}[echelle]
\MiniSchemaSignesTkzTab[options%keyvals]{numligne}[echelle][décalage horizontal]

#keyvals:\aidesignePL,\aidesignetkztabPL
Code=
Couleur=#%color
Racines=%<racines%>
Largeur=%<num%>
Hauteur=%<num%>
Cadre#true,false
#endkeyvals

## Style « main levée » en TikZ ##
#keyvals:\draw#c
mainlevee
mainlevee=%<segment-length%> et %<amplitude%>
#endkeyvals

## Écriture d’un trinôme, trinôme aléatoire ##
\EcritureTrinome{a}{b}{c}
\EcritureTrinome[options%keyvals]{a}{b}{c}

#keyvals:\EcritureTrinome
Alea#true,false
Anegatif#true,false
#endkeyvals

## PixelART via un fichier csv, en TikZ ##
\PixelArtTikz{file}#i
\PixelArtTikz[options%keyvals]{file}#i

#keyvals:\PixelArtTikz
Codes=%<chaîne%>
Couleurs={%<couleur1,couleur2,...%>}
Symboles={%<symbol1,symbol2,...%>}
Correction#true,false
Symb#true,false
BordCases#true,false
Style=%<font commands%>
#endkeyvals

## SudoMaths, en TikZ ##
\SudoMaths{liste}
\SudoMaths[options%keyvals]{liste}

\begin{EnvSudoMaths}{grille}
\begin{EnvSudoMaths}[options%keyvals]{grille}
\end{EnvSudoMaths}

#keyvals:\SudoMaths,\begin{EnvSudoMaths}
Epaisseurg=##L
Epaisseur=##L
Unite=##L
CouleurCase=#%color
CouleurTexte=#%color
NbCol=%<nombre%>
NbSubCol=%<nombre%>
NbLig=%<nombre%>
NbSubLig=%<nombre%>
Police=%<font commands%>
Legendes#true,false
PoliceLeg=%<font commands%>
ListeLegV=%<liste%>
ListeLegH=%<liste%>
DecalLegende=%<décalage%>
#endkeyvals

# from table option of xcolor
#include:colortbl

# from svgnames option of xcolor
AliceBlue#B
DarkKhaki#B
Green#B
LightSlateGrey#B
AntiqueWhite#B
DarkMagenta#B
GreenYellow#B
LightSteelBlue#B
Aqua#B
DarkOliveGreen#B
Grey#B
LightYellow#B
Aquamarine#B
DarkOrange#B
Honeydew#B
Lime#B
Azure#B
DarkOrchid#B
HotPink#B
LimeGreen#B
Beige#B
DarkRed#B
IndianRed#B
Linen#B
Bisque#B
DarkSalmon#B
Indigo#B
Magenta#B
Black#B
DarkSeaGreen#B
Ivory#B
Maroon#B
BlanchedAlmond#B
DarkSlateBlue#B
Khaki#B
MediumAquamarine#B
Blue#B
DarkSlateGray#B
Lavender#B
MediumBlue#B
BlueViolet#B
DarkSlateGrey#B
LavenderBlush#B
MediumOrchid#B
Brown#B
DarkTurquoise#B
LawnGreen#B
MediumPurple#B
BurlyWood#B
DarkViolet#B
LemonChiffon#B
MediumSeaGreen#B
CadetBlue#B
DeepPink#B
LightBlue#B
MediumSlateBlue#B
Chartreuse#B
DeepSkyBlue#B
LightCoral#B
MediumSpringGreen#B
Chocolate#B
DimGray#B
LightCyan#B
MediumTurquoise#B
Coral#B
DimGrey#B
LightGoldenrod#B
MediumVioletRed#B
CornflowerBlue#B
DodgerBlue#B
LightGoldenrodYellow#B
MidnightBlue#B
Cornsilk#B
FireBrick#B
LightGray#B
MintCream#B
Crimson#B
FloralWhite#B
LightGreen#B
MistyRose#B
Cyan#B
ForestGreen#B
LightGrey#B
Moccasin#B
DarkBlue#B
Fuchsia#B
LightPink#B
NavajoWhite#B
DarkCyan#B
Gainsboro#B
LightSalmon#B
Navy#B
DarkGoldenrod#B
GhostWhite#B
LightSeaGreen#B
NavyBlue#B
DarkGray#B
Gold#B
LightSkyBlue#B
OldLace#B
DarkGreen#B
Goldenrod#B
LightSlateBlue#B
Olive#B
DarkGrey#B
Gray#B
LightSlateGray#B
OliveDrab#B
Orange#B
Plum#B
Sienna#B
Thistle#B
OrangeRed#B
PowderBlue#B
Silver#B
Tomato#B
Orchid#B
Purple#B
SkyBlue#B
Turquoise#B
PaleGoldenrod#B
Red#B
SlateBlue#B
Violet#B
PaleGreen#B
RosyBrown#B
SlateGray#B
VioletRed#B
PaleTurquoise#B
RoyalBlue#B
SlateGrey#B
Wheat#B
PaleVioletRed#B
SaddleBrown#B
Snow#B
White#B
PapayaWhip#B
Salmon#B
SpringGreen#B
WhiteSmoke#B
PeachPuff#B
SandyBrown#B
SteelBlue#B
Yellow#B
Peru#B
SeaGreen#B
Tan#B
YellowGreen#B
Pink#B
Seashell#B
Teal#B

# from most option of tcolorbox (repeats removed)
#include:amsmath
#include:incgraph
#include:listings
#include:listingsutf8
#include:shellesc
#include:pdfcol

# from minted tcolorbox library
#include:minted

PLlinux#B
PLmgray#B
PLmpurple#B
PLogray#B
PLoorange#B
PLosxgray#B
PLterminal#B
PLwinblue#B
vertcapyt#B

# not documented
\AleaSigneA#S
\algomathttPL{text%plain}#S
\axesafflabel#S
\axesechellefleche#S
\axesfont#S
\axeslabelx#S
\axeslabely#S
\axesordecal#S
\axesorfont#S
\axesorpos#S
\axesorval#S
\axesposlabelx#S
\axesposlabely#S
\axestypefleche#S
\axeswidth#S
\axexfont#S
\axexposlabel#S
\axextickwidth#S
\axextickwidthA#S
\axextickwidthB#S
\axexwidth#S
\axeyfont#S
\axeyposlabel#S
\axeytickwidth#S
\axeytickwidthA#S
\axeytickwidthB#S
\axeywidth#S
\BaMAxeElarg#S
\BaMAxeEpaisseur#S
\BaMaxelargeur#S
\BaMAxeMax#S
\BaMAxeMin#S
\BaMAxeValeurs#S
\BaMaxexmax#S
\BaMaxexmin#S
\BaMCouleur#S
\BaMElevation#S
\BaMEpaisseur#S
\BaMHauteur#S
\BaMListeparams#S
\BaMmax#S
\BaMmed#S
\BaMmin#S
\BaMMoyenne#S
\BaMqt#S
\BaMqu#S
\BaMRemplissage#S
\basedepart#S
\begin{PLstats}#S
\begin{PLstats}[opt]#S
\begin{pythont}#S
\begin{tcpythontexcode}#S
\begin{tcpythontexcode}[width]#S
\begin{tcpythontexcodeno}#S
\begin{tcpythontexcodeno}[width]#S
\BorneInf#S
\BorneSup#S
\calculargument#S
\CFcoulcmd#S
\CFcouleur#S
\CFcoulres#S
\CFesplg#S
\CFhle#S
\CFhlr#S
\CFL#S
\CFLA#S
\CFlabeltitre#S
\CFlarg#S
\CFposcmd#S
\CFposres#S
\CFtaille#S
\CFtailletitre#S
\chbrut#S
\chiffre#S
\CODPITalign#S
\CODPITlargeur#S
\CODPYlargeur#S
\COEFF#S
\COEFFA#S
\Coeffa#S
\COEFFB#S
\Coeffc#S
\convertbasedixtobase{arg1}{arg2}#S
\convertbasetobasedix{arg1}{arg2}#S
\cpt#S
\CSPYlargeur#S
\denominateur#S
\densexpo{arg}#S
\densnorm{arg}#S
\end{PLstats}#S
\end{pythont}#S
\end{tcpythontexcode}#S
\end{tcpythontexcodeno}#S
\extractcoeff{liste}{numero}#S
\fctdecx#S
\fprimea#S
\fprimeb#S
\GRPHPROBcoulcbe#S
\GRPHPROBcoulsurf#S
\GRPHPROBhauteur#S
\GRPHPROBlarg#S
\hookcenterpost#S
\hookcenterpre#S
\ifinal#S
\iinit#S
\indice#S
\larcolinter#S
\larliginter#S
\LCNA#S
\lcoeffs#S
\LCPA#S
\listepointsaffiches#S
\MOYENNE#S
\nbblocs#S
\nbchiffres#S
\nbdepart#S
\NBdepart#S
\nbgrp#S
\numerateur#S
\PATchiffres#S
\PATcouleurs#S
\PATlettres#S
\PATtaille#S
\PaveA#S
\PaveB#S
\PaveC#S
\PaveD#S
\PaveE#S
\PaveF#S
\PaveG#S
\PaveH#S
\PFListeSommets#S
\PFPaveAngl#S
\PFPaveFuite#S
\PFPaveHt#S
\PFPaveLg#S
\PFPavePf#S
\PFPaveSommets#S
\PFPaveSommets#S
\PFPaveThick#S
\PFTetraAlpha#S
\PFTetraBeta#S
\PFTetraHt#S
\PFTetraLg#S
\PFTetraPf#S
\PFTetraSommets#S
\PFTetraThick#S
\pixchf#S
\pixcnt#S
\pixcol#S
\pixpos#S
\PLAPeptrait#S
\PLAPespfeuille#S
\PLAPespniv#S
\PLAPfont#S
\PLAPfontproba#S
\PLAPtype#S
\PLAPtypetrait#S
\PLAPunite#S
\PLARBREDONNES#S
\PLcercleangles#S
\PLcerclecoleq#S
\PLcercledecal#S
\PLcerclefond#S
\PLcerclemarge#S
\PLcerclerayon#S
\PLcerclesolthick#S
\PLcerclethick#S
\PLcerclevalcos#S
\PLcerclevaleurs#S
\PLcerclevalsin#S
\PLcommandeswin#S
\PLConvCouleur#S
\PLConvDecalH#S
\PLConvDecalV#S
\PLConvNoeud#S
\PLDm#S
\PLDM#S
\PLdomaine#S
\PLensopt#S
\PLenssep#S
\PLnoeud{arg1}{arg2}#S
\PLnuagepoints[opt]{arg}#S
\PLnuagepoints{arg}#S
\PLOSXGreen#S
\PLOSXLG#S
\PLOSXOrange#S
\PLOSXRed#S
\PLpgcd#S
\PLPGCDCouleur#S
\PLPGCDDecal#S
\PLPGCDNoeud#S
\PLRecurfct#S
\PLRecurlabelsize#S
\PLRecurnb#S
\PLRecurno#S
\PLRecurnom#S
\PLRecuroffset#S
\PLRecurposlab#S
\PLRecuruno#S
\PLSMcoulcase#S
\PLSMcoultexte#S
\PLSMdecalleg#S
\PLSMepf#S
\PLSMepg#S
\PLSMfonte#S
\PLSMfonteleg#S
\PLSMlistelegh#S
\PLSMlistelegv#S
\PLSMnbcol#S
\PLSMnblig#S
\PLSMnbsubcol#S
\PLSMnbsublig#S
\PLSMunite#S
\PLstrzeros{nombre}#S
\PLUbuntuClose#S
\PLUbuntuMax#S
\PLUbuntuMin#S
\PLUbuntuWhite#S
\ptmoycouleur#S
\ptmoycouleurA#S
\ptmoycouleurB#S
\ptmoydecal#S
\ptmoyfont#S
\ptmoynom#S
\ptmoypos#S
\ptmoystyle#S
\ptmoytaille#S
\ptmoyx#S
\ptmoyy#S
\ptscouleur#S
\ptscouleurA#S
\ptscouleurB#S
\ptsstyle#S
\ptstaille#S
\puiss#S
\RegLinCoeffa#S
\RegLinCoeffb#S
\RegLinCoeffr#S
\RegLinCoeffrd#S
\RegLinCoeffXmax#S
\RegLinCoeffXmin#S
\RegLinNuageCouleur#S
\RegLinNuageOx#S
\RegLinNuageOy#S
\RegLinNuageTaille#S
\resbrut#S
\resinter#S
\respgcd#S
\schematdsaff*{arg1}{arg2}{arg3}{arg4}#S
\schematdsaff{arg1}{arg2}{arg3}{arg4}#S
\schematdsparab{arg1}{arg2}{arg3}{arg4}{arg5}#S
\schematdsparab{arg1}{arg2}{arg3}{arg4}{arg5}[opt]#S
\SMcase#S
\SMcaseb#S
\SPGrilleSudoMaths#S
\SPLcoeffs#S
\SPLcouleur#S
\SPLcouleurpoints#S
\SPLepaisseur#S
\SPLlistepoints#S
\SPLlistepointslen#S
\SPLnbsplines#S
\SPLstyle#S
\SPLtaillepoints#S
\tdscouleur#S
\tdshaut#S
\tdslarg#S
\tdsparam#S
\tdsracine#S
\termnuxtitre#S
\termnuxtitre[opt]#S
\termosxtitre#S
\termosxtitre[opt]#S
\termwintitre#S
\termwintitre[opt]#S
\TetraA#S
\TetraB#S
\TetraC#S
\TetraD#S
\TGTcouleur#S
\TGTDEB#S
\TGTepaisseur#S
\TGTFIN#S
\TGTlistepoints#S
\TGTnumpt#S
\TGTstyle#S
\TGTXL#S
\TGTXR#S
\theCFnum#S
\TriPartieA#S
\TriPartieB#S
\TriPartieC#S
\TriSigneA#S
\UNITEX#S
\UNITEY#S
\ValA#S
\ValA#S
\ValB#S
\ValB#S
\ValMU#S
\ValQ#S
\ValQ#S
\ValR#S
\ValR#S
\ValRes#S
\ValTMP#S
\verbcenterpost#S
\verbcenterpre#S
\xa#S
\xb#S
\xliste#S
\XPT#S
\ya#S
\yb#S
\yliste#S
\YPT#S
