/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kinesis.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.flink.annotation.Internal;
import org.apache.flink.kinesis.shaded.com.amazonaws.regions.Regions;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.producer.KinesisProducerConfiguration;
import org.apache.flink.streaming.connectors.kinesis.config.AWSConfigConstants;
import org.apache.flink.streaming.connectors.kinesis.config.ConsumerConfigConstants;
import org.apache.flink.streaming.connectors.kinesis.util.AWSUtil;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class KinesisConfigUtil {
    protected static final String COLLECTION_MAX_COUNT = "CollectionMaxCount";
    protected static final String AGGREGATION_MAX_COUNT = "AggregationMaxCount";
    protected static final String RATE_LIMIT = "RateLimit";
    protected static final String THREADING_MODEL = "ThreadingModel";
    protected static final String THREAD_POOL_SIZE = "ThreadPoolSize";
    protected static final long DEFAULT_RATE_LIMIT = 100L;
    protected static final KinesisProducerConfiguration.ThreadingModel DEFAULT_THREADING_MODEL = KinesisProducerConfiguration.ThreadingModel.POOLED;
    protected static final int DEFAULT_THREAD_POOL_SIZE = 10;
    private static final Logger LOG = LoggerFactory.getLogger(KinesisConfigUtil.class);

    public static void validateConsumerConfiguration(Properties config) {
        Preconditions.checkNotNull((Object)config, (String)"config can not be null");
        KinesisConfigUtil.validateAwsConfiguration(config);
        if (!(config.containsKey("aws.region") ^ config.containsKey("aws.endpoint"))) {
            throw new IllegalArgumentException(String.format("For FlinkKinesisConsumer either AWS region ('%s') or AWS endpoint ('%s') must be set in the config.", "aws.region", "aws.endpoint"));
        }
        if (config.containsKey("flink.stream.initpos")) {
            String initPosType = config.getProperty("flink.stream.initpos");
            try {
                ConsumerConfigConstants.InitialPosition.valueOf(initPosType);
            }
            catch (IllegalArgumentException e) {
                StringBuilder sb = new StringBuilder();
                for (ConsumerConfigConstants.InitialPosition pos : ConsumerConfigConstants.InitialPosition.values()) {
                    sb.append(pos.toString()).append(", ");
                }
                throw new IllegalArgumentException("Invalid initial position in stream set in config. Valid values are: " + sb.toString());
            }
            if (ConsumerConfigConstants.InitialPosition.valueOf(initPosType) == ConsumerConfigConstants.InitialPosition.AT_TIMESTAMP) {
                if (!config.containsKey("flink.stream.initpos.timestamp")) {
                    throw new IllegalArgumentException("Please set value for initial timestamp ('flink.stream.initpos.timestamp') when using AT_TIMESTAMP initial position.");
                }
                KinesisConfigUtil.validateOptionalDateProperty(config, "flink.stream.initpos.timestamp", config.getProperty("flink.stream.initpos.timestamp.format", "yyyy-MM-dd'T'HH:mm:ss.SSSXXX"), "Invalid value given for initial timestamp for AT_TIMESTAMP initial position in stream. Must be a valid format: yyyy-MM-dd'T'HH:mm:ss.SSSXXX or non-negative double value. For example, 2016-04-04T19:58:46.480-00:00 or 1459799926.480 .");
            }
        }
        KinesisConfigUtil.validateOptionalPositiveIntProperty(config, "flink.shard.getrecords.maxrecordcount", "Invalid value given for maximum records per getRecords shard operation. Must be a valid non-negative integer value.");
        KinesisConfigUtil.validateOptionalPositiveIntProperty(config, "flink.shard.getrecords.maxretries", "Invalid value given for maximum retry attempts for getRecords shard operation. Must be a valid non-negative integer value.");
        KinesisConfigUtil.validateOptionalPositiveLongProperty(config, "flink.shard.getrecords.backoff.base", "Invalid value given for get records operation base backoff milliseconds. Must be a valid non-negative long value.");
        KinesisConfigUtil.validateOptionalPositiveLongProperty(config, "flink.shard.getrecords.backoff.max", "Invalid value given for get records operation max backoff milliseconds. Must be a valid non-negative long value.");
        KinesisConfigUtil.validateOptionalPositiveDoubleProperty(config, "flink.shard.getrecords.backoff.expconst", "Invalid value given for get records operation backoff exponential constant. Must be a valid non-negative double value.");
        KinesisConfigUtil.validateOptionalPositiveLongProperty(config, "flink.shard.getrecords.intervalmillis", "Invalid value given for getRecords sleep interval in milliseconds. Must be a valid non-negative long value.");
        KinesisConfigUtil.validateOptionalPositiveIntProperty(config, "flink.shard.getiterator.maxretries", "Invalid value given for maximum retry attempts for getShardIterator shard operation. Must be a valid non-negative integer value.");
        KinesisConfigUtil.validateOptionalPositiveLongProperty(config, "flink.shard.getiterator.backoff.base", "Invalid value given for get shard iterator operation base backoff milliseconds. Must be a valid non-negative long value.");
        KinesisConfigUtil.validateOptionalPositiveLongProperty(config, "flink.shard.getiterator.backoff.max", "Invalid value given for get shard iterator operation max backoff milliseconds. Must be a valid non-negative long value.");
        KinesisConfigUtil.validateOptionalPositiveDoubleProperty(config, "flink.shard.getiterator.backoff.expconst", "Invalid value given for get shard iterator operation backoff exponential constant. Must be a valid non-negative double value.");
        KinesisConfigUtil.validateOptionalPositiveLongProperty(config, "flink.shard.discovery.intervalmillis", "Invalid value given for shard discovery sleep interval in milliseconds. Must be a valid non-negative long value.");
        KinesisConfigUtil.validateOptionalPositiveLongProperty(config, "flink.list.shards.backoff.base", "Invalid value given for list shards operation base backoff milliseconds. Must be a valid non-negative long value.");
        KinesisConfigUtil.validateOptionalPositiveLongProperty(config, "flink.list.shards.backoff.max", "Invalid value given for list shards operation max backoff milliseconds. Must be a valid non-negative long value.");
        KinesisConfigUtil.validateOptionalPositiveDoubleProperty(config, "flink.list.shards.backoff.expconst", "Invalid value given for list shards operation backoff exponential constant. Must be a valid non-negative double value.");
        if (config.containsKey("flink.shard.getrecords.intervalmillis")) {
            Preconditions.checkArgument((Long.parseLong(config.getProperty("flink.shard.getrecords.intervalmillis")) < 300000L ? 1 : 0) != 0, (Object)"Invalid value given for getRecords sleep interval in milliseconds. Must be lower than 300000 milliseconds.");
        }
    }

    public static Properties replaceDeprecatedProducerKeys(Properties configProps) {
        if (configProps.containsKey("aws.producer.collectionMaxCount")) {
            configProps.setProperty(COLLECTION_MAX_COUNT, configProps.getProperty("aws.producer.collectionMaxCount"));
            configProps.remove("aws.producer.collectionMaxCount");
        }
        if (configProps.containsKey("aws.producer.aggregationMaxCount")) {
            configProps.setProperty(AGGREGATION_MAX_COUNT, configProps.getProperty("aws.producer.aggregationMaxCount"));
            configProps.remove("aws.producer.aggregationMaxCount");
        }
        return configProps;
    }

    public static Properties backfillConsumerKeys(Properties configProps) {
        HashMap<String, String> oldKeyToNewKeys = new HashMap<String, String>();
        oldKeyToNewKeys.put("flink.stream.describe.backoff.base", "flink.list.shards.backoff.base");
        oldKeyToNewKeys.put("flink.stream.describe.backoff.max", "flink.list.shards.backoff.max");
        oldKeyToNewKeys.put("flink.stream.describe.backoff.expconst", "flink.list.shards.backoff.expconst");
        for (Map.Entry entry : oldKeyToNewKeys.entrySet()) {
            String oldKey = (String)entry.getKey();
            String newKey = (String)entry.getValue();
            if (!configProps.containsKey(oldKey)) continue;
            configProps.setProperty(newKey, configProps.getProperty(oldKey));
        }
        return configProps;
    }

    public static KinesisProducerConfiguration getValidatedProducerConfiguration(Properties config) {
        Preconditions.checkNotNull((Object)config, (String)"config can not be null");
        KinesisConfigUtil.validateAwsConfiguration(config);
        if (!config.containsKey("aws.region")) {
            throw new IllegalArgumentException(String.format("For FlinkKinesisProducer AWS region ('%s') must be set in the config.", "aws.region"));
        }
        KinesisProducerConfiguration kpc = KinesisProducerConfiguration.fromProperties(config);
        kpc.setRegion(config.getProperty("aws.region"));
        kpc.setCredentialsProvider(AWSUtil.getCredentialsProvider(config));
        kpc.setCredentialsRefreshDelay(100L);
        if (!config.containsKey(RATE_LIMIT)) {
            kpc.setRateLimit(100L);
        }
        if (!config.containsKey(THREADING_MODEL)) {
            kpc.setThreadingModel(DEFAULT_THREADING_MODEL);
        }
        if (!config.containsKey(THREAD_POOL_SIZE)) {
            kpc.setThreadPoolSize(10);
        }
        return kpc;
    }

    public static void validateAwsConfiguration(Properties config) {
        if (config.containsKey("aws.credentials.provider")) {
            AWSConfigConstants.CredentialProvider providerType;
            String credentialsProviderType = config.getProperty("aws.credentials.provider");
            try {
                providerType = AWSConfigConstants.CredentialProvider.valueOf(credentialsProviderType);
            }
            catch (IllegalArgumentException e) {
                StringBuilder sb = new StringBuilder();
                for (AWSConfigConstants.CredentialProvider type : AWSConfigConstants.CredentialProvider.values()) {
                    sb.append(type.toString()).append(", ");
                }
                throw new IllegalArgumentException("Invalid AWS Credential Provider Type set in config. Valid values are: " + sb.toString());
            }
            if (!(providerType != AWSConfigConstants.CredentialProvider.BASIC || config.containsKey(AWSConfigConstants.AWS_ACCESS_KEY_ID) && config.containsKey(AWSConfigConstants.AWS_SECRET_ACCESS_KEY))) {
                throw new IllegalArgumentException("Please set values for AWS Access Key ID ('" + AWSConfigConstants.AWS_ACCESS_KEY_ID + "') and Secret Key ('" + AWSConfigConstants.AWS_SECRET_ACCESS_KEY + "') when using the BASIC AWS credential provider type.");
            }
        }
        if (config.containsKey("aws.region") && !AWSUtil.isValidRegion(config.getProperty("aws.region"))) {
            StringBuilder sb = new StringBuilder();
            for (Regions region : Regions.values()) {
                sb.append(region.getName()).append(", ");
            }
            throw new IllegalArgumentException("Invalid AWS region set in config. Valid values are: " + sb.toString());
        }
    }

    private static void validateOptionalPositiveLongProperty(Properties config, String key, String message) {
        if (config.containsKey(key)) {
            try {
                long value = Long.parseLong(config.getProperty(key));
                if (value < 0L) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(message);
            }
        }
    }

    private static void validateOptionalPositiveIntProperty(Properties config, String key, String message) {
        if (config.containsKey(key)) {
            try {
                int value = Integer.parseInt(config.getProperty(key));
                if (value < 0) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(message);
            }
        }
    }

    private static void validateOptionalPositiveDoubleProperty(Properties config, String key, String message) {
        if (config.containsKey(key)) {
            try {
                double value = Double.parseDouble(config.getProperty(key));
                if (value < 0.0) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(message);
            }
        }
    }

    private static void validateOptionalDateProperty(Properties config, String timestampKey, String format, String message) {
        if (config.containsKey(timestampKey)) {
            try {
                SimpleDateFormat customDateFormat = new SimpleDateFormat(format);
                customDateFormat.parse(config.getProperty(timestampKey));
            }
            catch (IllegalArgumentException | NullPointerException exception) {
                throw new IllegalArgumentException(message);
            }
            catch (ParseException exception) {
                try {
                    double value = Double.parseDouble(config.getProperty(timestampKey));
                    if (value < 0.0) {
                        throw new IllegalArgumentException(message);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException(message);
                }
            }
        }
    }
}

