/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.connectors.kinesis.proxy;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.flink.kinesis.shaded.com.amazonaws.ClientConfiguration;
import org.apache.flink.kinesis.shaded.com.amazonaws.ClientConfigurationFactory;
import org.apache.flink.kinesis.shaded.com.amazonaws.auth.AWSCredentialsProvider;
import org.apache.flink.kinesis.shaded.com.amazonaws.regions.Region;
import org.apache.flink.kinesis.shaded.com.amazonaws.regions.Regions;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.streamsadapter.AmazonDynamoDBStreamsAdapterClient;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.AmazonKinesis;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.DescribeStreamResult;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.Shard;
import org.apache.flink.runtime.util.EnvironmentInformation;
import org.apache.flink.streaming.connectors.kinesis.model.StreamShardHandle;
import org.apache.flink.streaming.connectors.kinesis.proxy.GetShardListResult;
import org.apache.flink.streaming.connectors.kinesis.proxy.KinesisProxy;
import org.apache.flink.streaming.connectors.kinesis.proxy.KinesisProxyInterface;
import org.apache.flink.streaming.connectors.kinesis.util.AWSUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamoDBStreamsProxy
extends KinesisProxy {
    private static final Logger LOG = LoggerFactory.getLogger(DynamoDBStreamsProxy.class);
    private static final String USER_AGENT_FORMAT = "Apache Flink %s (%s) DynamoDB Streams Connector";

    protected DynamoDBStreamsProxy(Properties configProps) {
        super(configProps);
    }

    public static KinesisProxyInterface create(Properties configProps) {
        return new DynamoDBStreamsProxy(configProps);
    }

    @Override
    protected AmazonKinesis createKinesisClient(Properties configProps) {
        ClientConfiguration awsClientConfig = new ClientConfigurationFactory().getConfig();
        AWSUtil.setAwsClientConfigProperties(awsClientConfig, configProps);
        AWSCredentialsProvider credentials = AWSUtil.getCredentialsProvider(configProps);
        awsClientConfig.setUserAgentPrefix(String.format(USER_AGENT_FORMAT, EnvironmentInformation.getVersion(), EnvironmentInformation.getRevisionInformation().commitId));
        AmazonDynamoDBStreamsAdapterClient adapterClient = new AmazonDynamoDBStreamsAdapterClient(credentials, awsClientConfig);
        if (configProps.containsKey("aws.endpoint")) {
            adapterClient.setEndpoint(configProps.getProperty("aws.endpoint"));
        } else {
            adapterClient.setRegion(Region.getRegion(Regions.fromName(configProps.getProperty("aws.region"))));
        }
        return adapterClient;
    }

    @Override
    public GetShardListResult getShardList(Map<String, String> streamNamesWithLastSeenShardIds) throws InterruptedException {
        GetShardListResult result = new GetShardListResult();
        for (Map.Entry<String, String> streamNameWithLastSeenShardId : streamNamesWithLastSeenShardIds.entrySet()) {
            String stream = streamNameWithLastSeenShardId.getKey();
            String lastSeenShardId = streamNameWithLastSeenShardId.getValue();
            result.addRetrievedShardsToStream(stream, this.getShardsOfStream(stream, lastSeenShardId));
        }
        return result;
    }

    private List<StreamShardHandle> getShardsOfStream(String streamName, @Nullable String lastSeenShardId) throws InterruptedException {
        DescribeStreamResult describeStreamResult;
        ArrayList<StreamShardHandle> shardsOfStream = new ArrayList<StreamShardHandle>();
        do {
            describeStreamResult = this.describeStream(streamName, lastSeenShardId);
            List<Shard> shards = describeStreamResult.getStreamDescription().getShards();
            for (Shard shard : shards) {
                shardsOfStream.add(new StreamShardHandle(streamName, shard));
            }
            if (shards.size() == 0) continue;
            lastSeenShardId = shards.get(shards.size() - 1).getShardId();
        } while (describeStreamResult.getStreamDescription().isHasMoreShards().booleanValue());
        return shardsOfStream;
    }
}

