/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.securitytoken.model.transform;

import org.apache.flink.kinesis.shaded.com.amazonaws.DefaultRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.Request;
import org.apache.flink.kinesis.shaded.com.amazonaws.SdkClientException;
import org.apache.flink.kinesis.shaded.com.amazonaws.http.HttpMethodName;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.securitytoken.model.GetFederationTokenRequest;
import org.apache.flink.kinesis.shaded.com.amazonaws.transform.Marshaller;
import org.apache.flink.kinesis.shaded.com.amazonaws.util.StringUtils;

public class GetFederationTokenRequestMarshaller
implements Marshaller<Request<GetFederationTokenRequest>, GetFederationTokenRequest> {
    @Override
    public Request<GetFederationTokenRequest> marshall(GetFederationTokenRequest getFederationTokenRequest) {
        if (getFederationTokenRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetFederationTokenRequest> request = new DefaultRequest<GetFederationTokenRequest>(getFederationTokenRequest, "AWSSecurityTokenService");
        request.addParameter("Action", "GetFederationToken");
        request.addParameter("Version", "2011-06-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (getFederationTokenRequest.getName() != null) {
            request.addParameter("Name", StringUtils.fromString(getFederationTokenRequest.getName()));
        }
        if (getFederationTokenRequest.getPolicy() != null) {
            request.addParameter("Policy", StringUtils.fromString(getFederationTokenRequest.getPolicy()));
        }
        if (getFederationTokenRequest.getDurationSeconds() != null) {
            request.addParameter("DurationSeconds", StringUtils.fromInteger(getFederationTokenRequest.getDurationSeconds()));
        }
        return request;
    }
}

