/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.multilang;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.multilang.LineReaderTask;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.multilang.messages.Message;

class GetNextMessageTask
extends LineReaderTask<Message> {
    private static final Log LOG = LogFactory.getLog(GetNextMessageTask.class);
    private ObjectMapper objectMapper;
    private static final String EMPTY_LINE = "";

    GetNextMessageTask(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    static boolean isEmptyLine(String line) {
        return EMPTY_LINE.equals(line);
    }

    @Override
    protected LineReaderTask.HandleLineResult<Message> handleLine(String line) {
        try {
            if (!GetNextMessageTask.isEmptyLine(line)) {
                return new LineReaderTask.HandleLineResult<Message>(this, this.objectMapper.readValue(line, Message.class));
            }
        }
        catch (IOException e) {
            LOG.info("Skipping unexpected line on STDOUT for shard " + this.getShardId() + ": " + line);
        }
        return new LineReaderTask.HandleLineResult<Message>(this);
    }

    @Override
    protected Message returnAfterException(Exception e) {
        throw new RuntimeException("Encountered an error while reading a line from STDIN for shard " + this.getShardId() + " so won't be able to return a message.", e);
    }

    @Override
    protected Message returnAfterEndOfInput() {
        throw new RuntimeException("Reached end of STDIN of child process for shard " + this.getShardId() + " so won't be able to return a message.");
    }

    public LineReaderTask<Message> initialize(BufferedReader reader, String shardId) {
        return this.initialize(reader, shardId, "Reading next message from STDIN for " + shardId);
    }
}

