/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.metrics.impl;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.apache.flink.kinesis.shaded.com.amazonaws.AbortedException;
import org.apache.flink.kinesis.shaded.com.amazonaws.ClientConfiguration;
import org.apache.flink.kinesis.shaded.com.amazonaws.auth.AWSCredentialsProvider;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.AmazonCloudWatchClient;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.metrics.impl.CWMetricKey;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.metrics.impl.CWMetricsScope;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.metrics.impl.CWPublisherRunnable;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.metrics.impl.DefaultCWMetricsPublisher;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.metrics.interfaces.IMetricsFactory;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.metrics.interfaces.IMetricsScope;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.metrics.interfaces.MetricsLevel;

public class CWMetricsFactory
implements IMetricsFactory {
    public static final MetricsLevel DEFAULT_METRICS_LEVEL = MetricsLevel.DETAILED;
    public static final Set<String> DEFAULT_METRICS_ENABLED_DIMENSIONS = ImmutableSet.of("ALL");
    private static final int FLUSH_SIZE = 200;
    private final CWPublisherRunnable<CWMetricKey> runnable;
    private final Thread publicationThread;
    private final MetricsLevel metricsLevel;
    private final Set<String> metricsEnabledDimensions;

    public CWMetricsFactory(AWSCredentialsProvider credentialsProvider, String namespace, long bufferTimeMillis, int maxQueueSize) {
        this((AmazonCloudWatch)new AmazonCloudWatchClient(credentialsProvider), namespace, bufferTimeMillis, maxQueueSize);
    }

    public CWMetricsFactory(AWSCredentialsProvider credentialsProvider, ClientConfiguration clientConfig, String namespace, long bufferTimeMillis, int maxQueueSize) {
        this((AmazonCloudWatch)new AmazonCloudWatchClient(credentialsProvider, clientConfig), namespace, bufferTimeMillis, maxQueueSize);
    }

    public CWMetricsFactory(AmazonCloudWatch cloudWatchClient, String namespace, long bufferTimeMillis, int maxQueueSize) {
        this(cloudWatchClient, namespace, bufferTimeMillis, maxQueueSize, DEFAULT_METRICS_LEVEL, DEFAULT_METRICS_ENABLED_DIMENSIONS);
    }

    public CWMetricsFactory(AmazonCloudWatch cloudWatchClient, String namespace, long bufferTimeMillis, int maxQueueSize, MetricsLevel metricsLevel, Set<String> metricsEnabledDimensions) {
        this.metricsLevel = metricsLevel == null ? DEFAULT_METRICS_LEVEL : metricsLevel;
        this.metricsEnabledDimensions = metricsEnabledDimensions == null ? ImmutableSet.of() : ImmutableSet.copyOf(metricsEnabledDimensions);
        this.runnable = new CWPublisherRunnable<CWMetricKey>(new DefaultCWMetricsPublisher(cloudWatchClient, namespace), bufferTimeMillis, maxQueueSize, 200);
        this.publicationThread = new Thread(this.runnable);
        this.publicationThread.setName("cw-metrics-publisher");
        this.publicationThread.start();
    }

    @Override
    public IMetricsScope createMetrics() {
        return new CWMetricsScope(this.runnable, this.metricsLevel, this.metricsEnabledDimensions);
    }

    public void shutdown() {
        this.runnable.shutdown();
        try {
            this.publicationThread.join();
        }
        catch (InterruptedException e) {
            throw new AbortedException(e.getMessage(), e);
        }
    }
}

