/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.kinesis.shaded.com.amazonaws.regions.Region;
import org.apache.flink.kinesis.shaded.com.amazonaws.regions.RegionUtils;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.AmazonCloudWatchClient;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.AmazonKinesis;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.AmazonKinesisClient;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.interfaces.ICheckpoint;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.interfaces.IRecordProcessorFactory;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.interfaces.v2.IRecordProcessor;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.GracefulShutdownContext;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.GracefulShutdownCoordinator;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStreamExtended;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.KinesisClientLibConfiguration;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.KinesisClientLibLeaseCoordinator;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.MetricsCollectingTaskDecorator;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.ParentsFirstShardPrioritization;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.RecordsFetcherFactory;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardConsumer;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardConsumerShutdownNotification;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardInfo;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardPrioritization;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardSyncTask;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardSyncTaskManager;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShutdownReason;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.StreamConfig;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.TaskResult;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.V1ToV2RecordProcessorFactoryAdapter;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.proxies.IKinesisProxy;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.proxies.KinesisProxy;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.leases.exceptions.LeasingException;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.leases.impl.KinesisClientLease;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.leases.impl.KinesisClientLeaseManager;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.metrics.impl.CWMetricsFactory;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.metrics.impl.NullMetricsFactory;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.metrics.interfaces.IMetricsFactory;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.metrics.interfaces.MetricsLevel;

public class Worker
implements Runnable {
    private static final Log LOG = LogFactory.getLog(Worker.class);
    private static final int MAX_INITIALIZATION_ATTEMPTS = 20;
    private WorkerLog wlog = new WorkerLog();
    private final String applicationName;
    private final org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.interfaces.v2.IRecordProcessorFactory recordProcessorFactory;
    private final KinesisClientLibConfiguration config;
    private final StreamConfig streamConfig;
    private final InitialPositionInStreamExtended initialPosition;
    private final ICheckpoint checkpointTracker;
    private final long idleTimeInMilliseconds;
    private final long parentShardPollIntervalMillis;
    private final ExecutorService executorService;
    private final IMetricsFactory metricsFactory;
    private final long taskBackoffTimeMillis;
    private final long failoverTimeMillis;
    private final Optional<Integer> retryGetRecordsInSeconds;
    private final Optional<Integer> maxGetRecordsThreadPool;
    private final KinesisClientLibLeaseCoordinator leaseCoordinator;
    private final ShardSyncTaskManager controlServer;
    private final ShardPrioritization shardPrioritization;
    private volatile boolean shutdown;
    private volatile long shutdownStartTimeMillis;
    private volatile boolean shutdownComplete = false;
    private ConcurrentMap<ShardInfo, ShardConsumer> shardInfoShardConsumerMap = new ConcurrentHashMap<ShardInfo, ShardConsumer>();
    private final boolean cleanupLeasesUponShardCompletion;
    private final boolean skipShardSyncAtWorkerInitializationIfLeasesExist;
    private Future<Boolean> gracefulShutdownFuture;
    @VisibleForTesting
    protected boolean gracefuleShutdownStarted = false;
    @VisibleForTesting
    protected GracefulShutdownCoordinator gracefulShutdownCoordinator = new GracefulShutdownCoordinator();

    public Worker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config) {
        this(recordProcessorFactory, config, Worker.getExecutorService());
    }

    public Worker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, ExecutorService execService) {
        this(recordProcessorFactory, config, new AmazonKinesisClient(config.getKinesisCredentialsProvider(), config.getKinesisClientConfiguration()), new AmazonDynamoDBClient(config.getDynamoDBCredentialsProvider(), config.getDynamoDBClientConfiguration()), new AmazonCloudWatchClient(config.getCloudWatchCredentialsProvider(), config.getCloudWatchClientConfiguration()), execService);
    }

    public Worker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, IMetricsFactory metricsFactory) {
        this(recordProcessorFactory, config, metricsFactory, Worker.getExecutorService());
    }

    public Worker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, IMetricsFactory metricsFactory, ExecutorService execService) {
        this(recordProcessorFactory, config, new AmazonKinesisClient(config.getKinesisCredentialsProvider(), config.getKinesisClientConfiguration()), new AmazonDynamoDBClient(config.getDynamoDBCredentialsProvider(), config.getDynamoDBClientConfiguration()), metricsFactory, execService);
    }

    public Worker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, AmazonKinesis kinesisClient, AmazonDynamoDB dynamoDBClient, AmazonCloudWatch cloudWatchClient) {
        this(recordProcessorFactory, config, kinesisClient, dynamoDBClient, cloudWatchClient, Worker.getExecutorService());
    }

    public Worker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, AmazonKinesis kinesisClient, AmazonDynamoDB dynamoDBClient, AmazonCloudWatch cloudWatchClient, ExecutorService execService) {
        this(recordProcessorFactory, config, kinesisClient, dynamoDBClient, Worker.getMetricsFactory(cloudWatchClient, config), execService);
    }

    public Worker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, AmazonKinesis kinesisClient, AmazonDynamoDB dynamoDBClient, IMetricsFactory metricsFactory, ExecutorService execService) {
        this(config.getApplicationName(), new V1ToV2RecordProcessorFactoryAdapter(recordProcessorFactory), config, new StreamConfig(new KinesisProxy(config, kinesisClient), config.getMaxRecords(), config.getIdleTimeBetweenReadsInMillis(), config.shouldCallProcessRecordsEvenForEmptyRecordList(), config.shouldValidateSequenceNumberBeforeCheckpointing(), config.getInitialPositionInStreamExtended()), config.getInitialPositionInStreamExtended(), config.getParentShardPollIntervalMillis(), config.getShardSyncIntervalMillis(), config.shouldCleanupLeasesUponShardCompletion(), null, new KinesisClientLibLeaseCoordinator(new KinesisClientLeaseManager(config.getTableName(), dynamoDBClient), config.getWorkerIdentifier(), config.getFailoverTimeMillis(), config.getEpsilonMillis(), config.getMaxLeasesForWorker(), config.getMaxLeasesToStealAtOneTime(), config.getMaxLeaseRenewalThreads(), metricsFactory).withInitialLeaseTableReadCapacity(config.getInitialLeaseTableReadCapacity()).withInitialLeaseTableWriteCapacity(config.getInitialLeaseTableWriteCapacity()), execService, metricsFactory, config.getTaskBackoffTimeMillis(), config.getFailoverTimeMillis(), config.getSkipShardSyncAtWorkerInitializationIfLeasesExist(), config.getShardPrioritizationStrategy(), config.getRetryGetRecordsInSeconds(), config.getMaxGetRecordsThreadPool());
        if (config.getRegionName() != null) {
            Region region = RegionUtils.getRegion(config.getRegionName());
            kinesisClient.setRegion(region);
            LOG.debug("The region of Amazon Kinesis client has been set to " + config.getRegionName());
            dynamoDBClient.setRegion(region);
            LOG.debug("The region of Amazon DynamoDB client has been set to " + config.getRegionName());
        }
        if (config.getDynamoDBEndpoint() != null) {
            dynamoDBClient.setEndpoint(config.getDynamoDBEndpoint());
            LOG.debug("The endpoint of Amazon DynamoDB client has been set to " + config.getDynamoDBEndpoint());
        }
        if (config.getKinesisEndpoint() != null) {
            kinesisClient.setEndpoint(config.getKinesisEndpoint());
            if (config.getRegionName() != null) {
                LOG.warn("Received configuration for both region name as " + config.getRegionName() + ", and Amazon Kinesis endpoint as " + config.getKinesisEndpoint() + ". Amazon Kinesis endpoint will overwrite region name.");
                LOG.debug("The region of Amazon Kinesis client has been overwritten to " + config.getKinesisEndpoint());
            } else {
                LOG.debug("The region of Amazon Kinesis client has been set to " + config.getKinesisEndpoint());
            }
        }
    }

    Worker(String applicationName, org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.interfaces.v2.IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, StreamConfig streamConfig, InitialPositionInStreamExtended initialPositionInStream, long parentShardPollIntervalMillis, long shardSyncIdleTimeMillis, boolean cleanupLeasesUponShardCompletion, ICheckpoint checkpoint, KinesisClientLibLeaseCoordinator leaseCoordinator, ExecutorService execService, IMetricsFactory metricsFactory, long taskBackoffTimeMillis, long failoverTimeMillis, boolean skipShardSyncAtWorkerInitializationIfLeasesExist, ShardPrioritization shardPrioritization) {
        this(applicationName, recordProcessorFactory, config, streamConfig, initialPositionInStream, parentShardPollIntervalMillis, shardSyncIdleTimeMillis, cleanupLeasesUponShardCompletion, checkpoint, leaseCoordinator, execService, metricsFactory, taskBackoffTimeMillis, failoverTimeMillis, skipShardSyncAtWorkerInitializationIfLeasesExist, shardPrioritization, Optional.empty(), Optional.empty());
    }

    Worker(String applicationName, org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.interfaces.v2.IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, StreamConfig streamConfig, InitialPositionInStreamExtended initialPositionInStream, long parentShardPollIntervalMillis, long shardSyncIdleTimeMillis, boolean cleanupLeasesUponShardCompletion, ICheckpoint checkpoint, KinesisClientLibLeaseCoordinator leaseCoordinator, ExecutorService execService, IMetricsFactory metricsFactory, long taskBackoffTimeMillis, long failoverTimeMillis, boolean skipShardSyncAtWorkerInitializationIfLeasesExist, ShardPrioritization shardPrioritization, Optional<Integer> retryGetRecordsInSeconds, Optional<Integer> maxGetRecordsThreadPool) {
        this.applicationName = applicationName;
        this.recordProcessorFactory = recordProcessorFactory;
        this.config = config;
        this.streamConfig = streamConfig;
        this.initialPosition = initialPositionInStream;
        this.parentShardPollIntervalMillis = parentShardPollIntervalMillis;
        this.cleanupLeasesUponShardCompletion = cleanupLeasesUponShardCompletion;
        this.checkpointTracker = checkpoint != null ? checkpoint : leaseCoordinator;
        this.idleTimeInMilliseconds = streamConfig.getIdleTimeInMilliseconds();
        this.executorService = execService;
        this.leaseCoordinator = leaseCoordinator;
        this.metricsFactory = metricsFactory;
        this.controlServer = new ShardSyncTaskManager(streamConfig.getStreamProxy(), leaseCoordinator.getLeaseManager(), initialPositionInStream, cleanupLeasesUponShardCompletion, config.shouldIgnoreUnexpectedChildShards(), shardSyncIdleTimeMillis, metricsFactory, this.executorService);
        this.taskBackoffTimeMillis = taskBackoffTimeMillis;
        this.failoverTimeMillis = failoverTimeMillis;
        this.skipShardSyncAtWorkerInitializationIfLeasesExist = skipShardSyncAtWorkerInitializationIfLeasesExist;
        this.shardPrioritization = shardPrioritization;
        this.retryGetRecordsInSeconds = retryGetRecordsInSeconds;
        this.maxGetRecordsThreadPool = maxGetRecordsThreadPool;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    @Override
    public void run() {
        if (this.shutdown) {
            return;
        }
        try {
            this.initialize();
            LOG.info("Initialization complete. Starting worker loop.");
        }
        catch (RuntimeException e1) {
            LOG.error("Unable to initialize after 20 attempts. Shutting down.", e1);
            this.shutdown();
        }
        while (!this.shouldShutdown()) {
            this.runProcessLoop();
        }
        this.finalShutdown();
        LOG.info("Worker loop is complete. Exiting from worker.");
    }

    @VisibleForTesting
    void runProcessLoop() {
        try {
            boolean foundCompletedShard = false;
            HashSet<ShardInfo> assignedShards = new HashSet<ShardInfo>();
            for (ShardInfo shardInfo : this.getShardInfoForAssignments()) {
                ShardConsumer shardConsumer = this.createOrGetShardConsumer(shardInfo, this.recordProcessorFactory);
                if (shardConsumer.isShutdown() && shardConsumer.getShutdownReason().equals((Object)ShutdownReason.TERMINATE)) {
                    foundCompletedShard = true;
                } else {
                    shardConsumer.consumeShard();
                }
                assignedShards.add(shardInfo);
            }
            if (foundCompletedShard) {
                this.controlServer.syncShardAndLeaseInfo(null);
            }
            this.cleanupShardConsumers(assignedShards);
            this.wlog.info("Sleeping ...");
            Thread.sleep(this.idleTimeInMilliseconds);
        }
        catch (Exception e) {
            LOG.error(String.format("Worker.run caught exception, sleeping for %s milli seconds!", String.valueOf(this.idleTimeInMilliseconds)), e);
            try {
                Thread.sleep(this.idleTimeInMilliseconds);
            }
            catch (InterruptedException ex) {
                LOG.info("Worker: sleep interrupted after catching exception ", ex);
            }
        }
        this.wlog.resetInfoLogging();
    }

    private void initialize() {
        boolean isDone = false;
        Exception lastException = null;
        for (int i2 = 0; !isDone && i2 < 20; ++i2) {
            try {
                LOG.info("Initialization attempt " + (i2 + 1));
                LOG.info("Initializing LeaseCoordinator");
                this.leaseCoordinator.initialize();
                TaskResult result = null;
                if (!this.skipShardSyncAtWorkerInitializationIfLeasesExist || this.leaseCoordinator.getLeaseManager().isLeaseTableEmpty()) {
                    LOG.info("Syncing Kinesis shard info");
                    ShardSyncTask shardSyncTask = new ShardSyncTask(this.streamConfig.getStreamProxy(), this.leaseCoordinator.getLeaseManager(), this.initialPosition, this.cleanupLeasesUponShardCompletion, this.config.shouldIgnoreUnexpectedChildShards(), 0L);
                    result = new MetricsCollectingTaskDecorator(shardSyncTask, this.metricsFactory).call();
                } else {
                    LOG.info("Skipping shard sync per config setting (and lease table is not empty)");
                }
                if (result == null || result.getException() == null) {
                    if (!this.leaseCoordinator.isRunning()) {
                        LOG.info("Starting LeaseCoordinator");
                        this.leaseCoordinator.start();
                    } else {
                        LOG.info("LeaseCoordinator is already running. No need to start it.");
                    }
                    isDone = true;
                } else {
                    lastException = result.getException();
                }
            }
            catch (LeasingException e) {
                LOG.error("Caught exception when initializing LeaseCoordinator", e);
                lastException = e;
            }
            catch (Exception e) {
                lastException = e;
            }
            try {
                Thread.sleep(this.parentShardPollIntervalMillis);
                continue;
            }
            catch (InterruptedException e) {
                LOG.debug("Sleep interrupted while initializing worker.");
            }
        }
        if (!isDone) {
            throw new RuntimeException(lastException);
        }
    }

    void cleanupShardConsumers(Set<ShardInfo> assignedShards) {
        for (ShardInfo shard : this.shardInfoShardConsumerMap.keySet()) {
            boolean isShutdown;
            if (assignedShards.contains(shard) || !(isShutdown = ((ShardConsumer)this.shardInfoShardConsumerMap.get(shard)).beginShutdown())) continue;
            this.shardInfoShardConsumerMap.remove(shard);
        }
    }

    private List<ShardInfo> getShardInfoForAssignments() {
        List<ShardInfo> assignedStreamShards = this.leaseCoordinator.getCurrentAssignments();
        List<ShardInfo> prioritizedShards = this.shardPrioritization.prioritize(assignedStreamShards);
        if (prioritizedShards != null && !prioritizedShards.isEmpty()) {
            if (this.wlog.isInfoEnabled()) {
                StringBuilder builder = new StringBuilder();
                boolean firstItem = true;
                for (ShardInfo shardInfo : prioritizedShards) {
                    if (!firstItem) {
                        builder.append(", ");
                    }
                    builder.append(shardInfo.getShardId());
                    firstItem = false;
                }
                this.wlog.info("Current stream shard assignments: " + builder.toString());
            }
        } else {
            this.wlog.info("No activities assigned");
        }
        return prioritizedShards;
    }

    @Deprecated
    public Future<Void> requestShutdown() {
        final Future<Boolean> requestedShutdownFuture = this.startGracefulShutdown();
        return new Future<Void>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return requestedShutdownFuture.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return requestedShutdownFuture.isCancelled();
            }

            @Override
            public boolean isDone() {
                return requestedShutdownFuture.isDone();
            }

            @Override
            public Void get() throws InterruptedException, ExecutionException {
                requestedShutdownFuture.get();
                return null;
            }

            @Override
            public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                requestedShutdownFuture.get(timeout, unit);
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Boolean> startGracefulShutdown() {
        Worker worker = this;
        synchronized (worker) {
            if (this.gracefulShutdownFuture == null) {
                this.gracefulShutdownFuture = this.gracefulShutdownCoordinator.startGracefulShutdown(this.createGracefulShutdownCallable());
            }
        }
        return this.gracefulShutdownFuture;
    }

    public Callable<Boolean> createGracefulShutdownCallable() {
        if (this.isShutdownComplete()) {
            return () -> true;
        }
        Callable<GracefulShutdownContext> startShutdown = this.createWorkerShutdownCallable();
        return this.gracefulShutdownCoordinator.createGracefulShutdownCallable(startShutdown);
    }

    public boolean hasGracefulShutdownStarted() {
        return this.gracefuleShutdownStarted;
    }

    @VisibleForTesting
    Callable<GracefulShutdownContext> createWorkerShutdownCallable() {
        return () -> {
            Worker worker = this;
            synchronized (worker) {
                if (this.gracefuleShutdownStarted) {
                    throw new IllegalStateException("Requested shutdown has already been started");
                }
                this.gracefuleShutdownStarted = true;
            }
            this.leaseCoordinator.stopLeaseTaker();
            Collection leases = this.leaseCoordinator.getAssignments();
            if (leases == null || leases.isEmpty()) {
                this.shutdown();
                return GracefulShutdownContext.SHUTDOWN_ALREADY_COMPLETED;
            }
            CountDownLatch shutdownCompleteLatch = new CountDownLatch(leases.size());
            CountDownLatch notificationCompleteLatch = new CountDownLatch(leases.size());
            for (KinesisClientLease lease : leases) {
                ShardConsumerShutdownNotification shutdownNotification = new ShardConsumerShutdownNotification(this.leaseCoordinator, lease, notificationCompleteLatch, shutdownCompleteLatch);
                ShardInfo shardInfo = KinesisClientLibLeaseCoordinator.convertLeaseToAssignment(lease);
                ShardConsumer consumer = (ShardConsumer)this.shardInfoShardConsumerMap.get(shardInfo);
                if (consumer != null) {
                    consumer.notifyShutdownRequested(shutdownNotification);
                    continue;
                }
                notificationCompleteLatch.countDown();
                shutdownCompleteLatch.countDown();
            }
            return new GracefulShutdownContext(shutdownCompleteLatch, notificationCompleteLatch, this);
        };
    }

    boolean isShutdownComplete() {
        return this.shutdownComplete;
    }

    ConcurrentMap<ShardInfo, ShardConsumer> getShardInfoShardConsumerMap() {
        return this.shardInfoShardConsumerMap;
    }

    public void shutdown() {
        if (this.shutdown) {
            LOG.warn("Shutdown requested a second time.");
            return;
        }
        LOG.info("Worker shutdown requested.");
        this.shutdown = true;
        this.shutdownStartTimeMillis = System.currentTimeMillis();
        this.leaseCoordinator.stop();
    }

    private void finalShutdown() {
        LOG.info("Starting worker's final shutdown.");
        if (this.executorService instanceof WorkerThreadPoolExecutor) {
            this.executorService.shutdownNow();
        }
        if (this.metricsFactory instanceof WorkerCWMetricsFactory) {
            ((CWMetricsFactory)this.metricsFactory).shutdown();
        }
        this.shutdownComplete = true;
    }

    @VisibleForTesting
    boolean shouldShutdown() {
        if (this.executorService.isShutdown()) {
            LOG.error("Worker executor service has been shutdown, so record processors cannot be shutdown.");
            return true;
        }
        if (this.shutdown) {
            if (this.shardInfoShardConsumerMap.isEmpty()) {
                LOG.info("All record processors have been shutdown successfully.");
                return true;
            }
            if (System.currentTimeMillis() - this.shutdownStartTimeMillis >= this.failoverTimeMillis) {
                LOG.info("Lease failover time is reached, so forcing shutdown.");
                return true;
            }
        }
        return false;
    }

    ShardConsumer createOrGetShardConsumer(ShardInfo shardInfo, org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.interfaces.v2.IRecordProcessorFactory processorFactory) {
        ShardConsumer consumer = (ShardConsumer)this.shardInfoShardConsumerMap.get(shardInfo);
        if (consumer == null || consumer.isShutdown() && consumer.getShutdownReason().equals((Object)ShutdownReason.ZOMBIE)) {
            consumer = this.buildConsumer(shardInfo, processorFactory);
            this.shardInfoShardConsumerMap.put(shardInfo, consumer);
            this.wlog.infoForce("Created new shardConsumer for : " + shardInfo);
        }
        return consumer;
    }

    protected ShardConsumer buildConsumer(ShardInfo shardInfo, org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.interfaces.v2.IRecordProcessorFactory processorFactory) {
        IRecordProcessor recordProcessor = processorFactory.createProcessor();
        return new ShardConsumer(shardInfo, this.streamConfig, this.checkpointTracker, recordProcessor, this.leaseCoordinator.getLeaseManager(), this.parentShardPollIntervalMillis, this.cleanupLeasesUponShardCompletion, this.executorService, this.metricsFactory, this.taskBackoffTimeMillis, this.skipShardSyncAtWorkerInitializationIfLeasesExist, this.retryGetRecordsInSeconds, this.maxGetRecordsThreadPool, this.config);
    }

    public Worker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, AmazonKinesisClient kinesisClient, AmazonDynamoDBClient dynamoDBClient, AmazonCloudWatchClient cloudWatchClient) {
        this(recordProcessorFactory, config, (AmazonKinesis)kinesisClient, (AmazonDynamoDB)dynamoDBClient, (AmazonCloudWatch)cloudWatchClient);
    }

    public Worker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, AmazonKinesisClient kinesisClient, AmazonDynamoDBClient dynamoDBClient, AmazonCloudWatchClient cloudWatchClient, ExecutorService execService) {
        this(recordProcessorFactory, config, (AmazonKinesis)kinesisClient, (AmazonDynamoDB)dynamoDBClient, (AmazonCloudWatch)cloudWatchClient, execService);
    }

    public Worker(IRecordProcessorFactory recordProcessorFactory, KinesisClientLibConfiguration config, AmazonKinesisClient kinesisClient, AmazonDynamoDBClient dynamoDBClient, IMetricsFactory metricsFactory, ExecutorService execService) {
        this(recordProcessorFactory, config, (AmazonKinesis)kinesisClient, (AmazonDynamoDB)dynamoDBClient, metricsFactory, execService);
    }

    @VisibleForTesting
    StreamConfig getStreamConfig() {
        return this.streamConfig;
    }

    private static IMetricsFactory getMetricsFactory(AmazonCloudWatch cloudWatchClient, KinesisClientLibConfiguration config) {
        IMetricsFactory metricsFactory;
        if (config.getMetricsLevel() == MetricsLevel.NONE) {
            metricsFactory = new NullMetricsFactory();
        } else {
            if (config.getRegionName() != null) {
                Region region = RegionUtils.getRegion(config.getRegionName());
                cloudWatchClient.setRegion(region);
                LOG.debug("The region of Amazon CloudWatch client has been set to " + config.getRegionName());
            }
            metricsFactory = new WorkerCWMetricsFactory(cloudWatchClient, config.getApplicationName(), config.getMetricsBufferTimeMillis(), config.getMetricsMaxQueueSize(), config.getMetricsLevel(), config.getMetricsEnabledDimensions());
        }
        return metricsFactory;
    }

    private static ExecutorService getExecutorService() {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("RecordProcessor-%04d").build();
        return new WorkerThreadPoolExecutor(threadFactory);
    }

    public static class Builder {
        private org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.interfaces.v2.IRecordProcessorFactory recordProcessorFactory;
        private RecordsFetcherFactory recordsFetcherFactory;
        private KinesisClientLibConfiguration config;
        private AmazonKinesis kinesisClient;
        private AmazonDynamoDB dynamoDBClient;
        private AmazonCloudWatch cloudWatchClient;
        private IMetricsFactory metricsFactory;
        private ExecutorService execService;
        private ShardPrioritization shardPrioritization;
        private IKinesisProxy kinesisProxy;

        public Builder recordProcessorFactory(IRecordProcessorFactory recordProcessorFactory) {
            this.recordProcessorFactory = new V1ToV2RecordProcessorFactoryAdapter(recordProcessorFactory);
            return this;
        }

        public Builder recordProcessorFactory(org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.interfaces.v2.IRecordProcessorFactory recordProcessorFactory) {
            this.recordProcessorFactory = recordProcessorFactory;
            return this;
        }

        public Builder config(KinesisClientLibConfiguration config) {
            this.config = config;
            return this;
        }

        public Builder kinesisClient(AmazonKinesis kinesisClient) {
            this.kinesisClient = kinesisClient;
            return this;
        }

        public Builder dynamoDBClient(AmazonDynamoDB dynamoDBClient) {
            this.dynamoDBClient = dynamoDBClient;
            return this;
        }

        public Builder cloudWatchClient(AmazonCloudWatch cloudWatchClient) {
            this.cloudWatchClient = cloudWatchClient;
            return this;
        }

        public Builder metricsFactory(IMetricsFactory metricsFactory) {
            this.metricsFactory = metricsFactory;
            return this;
        }

        public Builder execService(ExecutorService execService) {
            this.execService = execService;
            return this;
        }

        public Builder shardPrioritization(ShardPrioritization shardPrioritization) {
            this.shardPrioritization = shardPrioritization;
            return this;
        }

        public Builder kinesisProxy(IKinesisProxy kinesisProxy) {
            this.kinesisProxy = kinesisProxy;
            return this;
        }

        public Worker build() {
            if (this.config == null) {
                throw new IllegalArgumentException("Kinesis Client Library configuration needs to be provided to build Worker");
            }
            if (this.recordProcessorFactory == null) {
                throw new IllegalArgumentException("A Record Processor Factory needs to be provided to build Worker");
            }
            if (this.execService == null) {
                this.execService = Worker.getExecutorService();
            }
            if (this.kinesisClient == null) {
                this.kinesisClient = new AmazonKinesisClient(this.config.getKinesisCredentialsProvider(), this.config.getKinesisClientConfiguration());
            }
            if (this.dynamoDBClient == null) {
                this.dynamoDBClient = new AmazonDynamoDBClient(this.config.getDynamoDBCredentialsProvider(), this.config.getDynamoDBClientConfiguration());
            }
            if (this.cloudWatchClient == null) {
                this.cloudWatchClient = new AmazonCloudWatchClient(this.config.getCloudWatchCredentialsProvider(), this.config.getCloudWatchClientConfiguration());
            }
            if (this.config.getRegionName() != null) {
                Region region = RegionUtils.getRegion(this.config.getRegionName());
                this.cloudWatchClient.setRegion(region);
                LOG.debug("The region of Amazon CloudWatch client has been set to " + this.config.getRegionName());
                this.kinesisClient.setRegion(region);
                LOG.debug("The region of Amazon Kinesis client has been set to " + this.config.getRegionName());
                this.dynamoDBClient.setRegion(region);
                LOG.debug("The region of Amazon DynamoDB client has been set to " + this.config.getRegionName());
            }
            if (this.config.getDynamoDBEndpoint() != null) {
                this.dynamoDBClient.setEndpoint(this.config.getDynamoDBEndpoint());
                LOG.debug("The endpoint of Amazon DynamoDB client has been set to " + this.config.getDynamoDBEndpoint());
            }
            if (this.config.getKinesisEndpoint() != null) {
                this.kinesisClient.setEndpoint(this.config.getKinesisEndpoint());
                if (this.config.getRegionName() != null) {
                    LOG.warn("Received configuration for both region name as " + this.config.getRegionName() + ", and Amazon Kinesis endpoint as " + this.config.getKinesisEndpoint() + ". Amazon Kinesis endpoint will overwrite region name.");
                    LOG.debug("The region of Amazon Kinesis client has been overwritten to " + this.config.getKinesisEndpoint());
                } else {
                    LOG.debug("The region of Amazon Kinesis client has been set to " + this.config.getKinesisEndpoint());
                }
            }
            if (this.metricsFactory == null) {
                this.metricsFactory = Worker.getMetricsFactory(this.cloudWatchClient, this.config);
            }
            if (this.shardPrioritization == null) {
                this.shardPrioritization = new ParentsFirstShardPrioritization(1);
            }
            if (this.kinesisProxy == null) {
                this.kinesisProxy = new KinesisProxy(this.config, this.kinesisClient);
            }
            return new Worker(this.config.getApplicationName(), this.recordProcessorFactory, this.config, new StreamConfig(this.kinesisProxy, this.config.getMaxRecords(), this.config.getIdleTimeBetweenReadsInMillis(), this.config.shouldCallProcessRecordsEvenForEmptyRecordList(), this.config.shouldValidateSequenceNumberBeforeCheckpointing(), this.config.getInitialPositionInStreamExtended()), this.config.getInitialPositionInStreamExtended(), this.config.getParentShardPollIntervalMillis(), this.config.getShardSyncIntervalMillis(), this.config.shouldCleanupLeasesUponShardCompletion(), null, new KinesisClientLibLeaseCoordinator(new KinesisClientLeaseManager(this.config.getTableName(), this.dynamoDBClient), this.config.getWorkerIdentifier(), this.config.getFailoverTimeMillis(), this.config.getEpsilonMillis(), this.config.getMaxLeasesForWorker(), this.config.getMaxLeasesToStealAtOneTime(), this.config.getMaxLeaseRenewalThreads(), this.metricsFactory).withInitialLeaseTableReadCapacity(this.config.getInitialLeaseTableReadCapacity()).withInitialLeaseTableWriteCapacity(this.config.getInitialLeaseTableWriteCapacity()), this.execService, this.metricsFactory, this.config.getTaskBackoffTimeMillis(), this.config.getFailoverTimeMillis(), this.config.getSkipShardSyncAtWorkerInitializationIfLeasesExist(), this.shardPrioritization, this.config.getRetryGetRecordsInSeconds(), this.config.getMaxGetRecordsThreadPool());
        }
    }

    static class WorkerThreadPoolExecutor
    extends ThreadPoolExecutor {
        private static final long DEFAULT_KEEP_ALIVE_TIME = 60L;

        WorkerThreadPoolExecutor(ThreadFactory threadFactory) {
            super(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory);
        }
    }

    static class WorkerCWMetricsFactory
    extends CWMetricsFactory {
        WorkerCWMetricsFactory(AmazonCloudWatch cloudWatchClient, String namespace, long bufferTimeMillis, int maxQueueSize, MetricsLevel metricsLevel, Set<String> metricsEnabledDimensions) {
            super(cloudWatchClient, namespace, bufferTimeMillis, maxQueueSize, metricsLevel, metricsEnabledDimensions);
        }
    }

    private static class WorkerLog {
        private long reportIntervalMillis = TimeUnit.MINUTES.toMillis(1L);
        private long nextReportTime = System.currentTimeMillis() + this.reportIntervalMillis;
        private boolean infoReporting;

        private WorkerLog() {
        }

        public void debug(Object message, Throwable t) {
            LOG.debug(message, t);
        }

        public void info(Object message) {
            if (this.isInfoEnabled()) {
                LOG.info(message);
            }
        }

        public void infoForce(Object message) {
            LOG.info(message);
        }

        public void warn(Object message) {
            LOG.warn(message);
        }

        public void error(Object message, Throwable t) {
            LOG.error(message, t);
        }

        private boolean isInfoEnabled() {
            return this.infoReporting;
        }

        private void resetInfoLogging() {
            if (this.infoReporting) {
                if (LOG.isInfoEnabled()) {
                    this.infoReporting = false;
                    this.nextReportTime = System.currentTimeMillis() + this.reportIntervalMillis;
                }
            } else if (this.nextReportTime <= System.currentTimeMillis()) {
                this.infoReporting = true;
            }
        }
    }
}

