/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import com.google.common.annotations.VisibleForTesting;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.interfaces.v2.IRecordProcessor;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.GetRecordsCache;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.ITask;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStreamExtended;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.RecordProcessorCheckpointer;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardInfo;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShardSyncer;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.ShutdownReason;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.TaskResult;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.TaskType;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.proxies.IKinesisProxy;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.types.ExtendedSequenceNumber;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.types.ShutdownInput;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.leases.impl.KinesisClientLease;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.leases.interfaces.ILeaseManager;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.metrics.impl.MetricsHelper;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.metrics.interfaces.MetricsLevel;

class ShutdownTask
implements ITask {
    private static final Log LOG = LogFactory.getLog(ShutdownTask.class);
    private static final String RECORD_PROCESSOR_SHUTDOWN_METRIC = "RecordProcessor.shutdown";
    private final ShardInfo shardInfo;
    private final IRecordProcessor recordProcessor;
    private final RecordProcessorCheckpointer recordProcessorCheckpointer;
    private final ShutdownReason reason;
    private final IKinesisProxy kinesisProxy;
    private final ILeaseManager<KinesisClientLease> leaseManager;
    private final InitialPositionInStreamExtended initialPositionInStream;
    private final boolean cleanupLeasesOfCompletedShards;
    private final boolean ignoreUnexpectedChildShards;
    private final TaskType taskType = TaskType.SHUTDOWN;
    private final long backoffTimeMillis;
    private final GetRecordsCache getRecordsCache;

    ShutdownTask(ShardInfo shardInfo, IRecordProcessor recordProcessor, RecordProcessorCheckpointer recordProcessorCheckpointer, ShutdownReason reason, IKinesisProxy kinesisProxy, InitialPositionInStreamExtended initialPositionInStream, boolean cleanupLeasesOfCompletedShards, boolean ignoreUnexpectedChildShards, ILeaseManager<KinesisClientLease> leaseManager, long backoffTimeMillis, GetRecordsCache getRecordsCache) {
        this.shardInfo = shardInfo;
        this.recordProcessor = recordProcessor;
        this.recordProcessorCheckpointer = recordProcessorCheckpointer;
        this.reason = reason;
        this.kinesisProxy = kinesisProxy;
        this.initialPositionInStream = initialPositionInStream;
        this.cleanupLeasesOfCompletedShards = cleanupLeasesOfCompletedShards;
        this.ignoreUnexpectedChildShards = ignoreUnexpectedChildShards;
        this.leaseManager = leaseManager;
        this.backoffTimeMillis = backoffTimeMillis;
        this.getRecordsCache = getRecordsCache;
    }

    @Override
    public TaskResult call() {
        boolean applicationException = false;
        try {
            if (this.reason == ShutdownReason.TERMINATE) {
                this.recordProcessorCheckpointer.setSequenceNumberAtShardEnd(this.recordProcessorCheckpointer.getLargestPermittedCheckpointValue());
                this.recordProcessorCheckpointer.setLargestPermittedCheckpointValue(ExtendedSequenceNumber.SHARD_END);
            }
            LOG.debug("Invoking shutdown() for shard " + this.shardInfo.getShardId() + ", concurrencyToken " + this.shardInfo.getConcurrencyToken() + ". Shutdown reason: " + (Object)((Object)this.reason));
            ShutdownInput shutdownInput = new ShutdownInput().withShutdownReason(this.reason).withCheckpointer(this.recordProcessorCheckpointer);
            long recordProcessorStartTimeMillis = System.currentTimeMillis();
            try {
                this.recordProcessor.shutdown(shutdownInput);
                ExtendedSequenceNumber lastCheckpointValue = this.recordProcessorCheckpointer.getLastCheckpointValue();
                if (!(this.reason != ShutdownReason.TERMINATE || lastCheckpointValue != null && lastCheckpointValue.equals(ExtendedSequenceNumber.SHARD_END))) {
                    throw new IllegalArgumentException("Application didn't checkpoint at end of shard " + this.shardInfo.getShardId());
                }
                LOG.debug("Shutting down retrieval strategy.");
                this.getRecordsCache.shutdown();
                LOG.debug("Record processor completed shutdown() for shard " + this.shardInfo.getShardId());
            }
            catch (Exception e) {
                applicationException = true;
                throw e;
            }
            finally {
                MetricsHelper.addLatency(RECORD_PROCESSOR_SHUTDOWN_METRIC, recordProcessorStartTimeMillis, MetricsLevel.SUMMARY);
            }
            if (this.reason == ShutdownReason.TERMINATE) {
                LOG.debug("Looking for child shards of shard " + this.shardInfo.getShardId());
                ShardSyncer.checkAndCreateLeasesForNewShards(this.kinesisProxy, this.leaseManager, this.initialPositionInStream, this.cleanupLeasesOfCompletedShards, this.ignoreUnexpectedChildShards);
                LOG.debug("Finished checking for child shards of shard " + this.shardInfo.getShardId());
            }
            return new TaskResult(null);
        }
        catch (Exception e) {
            if (applicationException) {
                LOG.error("Application exception. ", e);
            } else {
                LOG.error("Caught exception: ", e);
            }
            Exception exception = e;
            try {
                Thread.sleep(this.backoffTimeMillis);
            }
            catch (InterruptedException ie) {
                LOG.debug("Interrupted sleep", ie);
            }
            return new TaskResult(exception);
        }
    }

    @Override
    public TaskType getTaskType() {
        return this.taskType;
    }

    @VisibleForTesting
    ShutdownReason getReason() {
        return this.reason;
    }
}

