/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.kinesis.shaded.com.amazonaws.AmazonServiceException;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.exceptions.KinesisClientLibDependencyException;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.exceptions.ThrottlingException;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.proxies.IKinesisProxy;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.types.ExtendedSequenceNumber;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.InvalidArgumentException;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.ProvisionedThroughputExceededException;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.ShardIteratorType;

public class SequenceNumberValidator {
    private static final Log LOG = LogFactory.getLog(SequenceNumberValidator.class);
    private IKinesisProxy proxy;
    private String shardId;
    private boolean validateWithGetIterator;
    private static final int SERVER_SIDE_ERROR_CODE = 500;

    SequenceNumberValidator(IKinesisProxy proxy, String shardId, boolean validateWithGetIterator) {
        this.proxy = proxy;
        this.shardId = shardId;
        this.validateWithGetIterator = validateWithGetIterator;
    }

    void validateSequenceNumber(String sequenceNumber) throws IllegalArgumentException, ThrottlingException, KinesisClientLibDependencyException {
        if (!SequenceNumberValidator.isDigits(sequenceNumber)) {
            LOG.info("Sequence number must be numeric, but was " + sequenceNumber);
            throw new IllegalArgumentException("Sequence number must be numeric, but was " + sequenceNumber);
        }
        try {
            if (this.validateWithGetIterator) {
                this.proxy.getIterator(this.shardId, ShardIteratorType.AFTER_SEQUENCE_NUMBER.toString(), sequenceNumber);
                LOG.info("Validated sequence number " + sequenceNumber + " with shard id " + this.shardId);
            }
        }
        catch (InvalidArgumentException e) {
            LOG.info("Sequence number " + sequenceNumber + " is invalid for shard " + this.shardId, e);
            throw new IllegalArgumentException("Sequence number " + sequenceNumber + " is invalid for shard " + this.shardId, e);
        }
        catch (ProvisionedThroughputExceededException e) {
            LOG.info("Exceeded throughput while getting an iterator for shard " + this.shardId, e);
            throw new ThrottlingException("Exceeded throughput while getting an iterator for shard " + this.shardId, e);
        }
        catch (AmazonServiceException e) {
            LOG.info("Encountered service exception while getting an iterator for shard " + this.shardId, e);
            if (e.getStatusCode() >= 500) {
                throw new KinesisClientLibDependencyException("Encountered service exception while getting an iterator for shard " + this.shardId, e);
            }
            throw e;
        }
    }

    void validateSequenceNumber(ExtendedSequenceNumber checkpoint) throws IllegalArgumentException, ThrottlingException, KinesisClientLibDependencyException {
        this.validateSequenceNumber(checkpoint.getSequenceNumber());
        if (checkpoint.getSubSequenceNumber() < 0L) {
            throw new IllegalArgumentException("SubSequence number must be non-negative, but was " + checkpoint.getSubSequenceNumber());
        }
    }

    static boolean isDigits(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (Character.isDigit(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }
}

