/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker;

import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import lombok.NonNull;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.flink.kinesis.shaded.com.amazonaws.SdkClientException;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.cloudwatch.model.StandardUnit;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.GetRecordsCache;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.GetRecordsRetrievalStrategy;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.lib.worker.KinesisDataFetcher;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.clientlibrary.types.ProcessRecordsInput;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.metrics.impl.MetricsHelper;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.metrics.impl.ThreadSafeMetricsDelegatingFactory;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.metrics.interfaces.IMetricsFactory;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.metrics.interfaces.MetricsLevel;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.ExpiredIteratorException;
import org.apache.flink.kinesis.shaded.com.amazonaws.services.kinesis.model.GetRecordsResult;

public class PrefetchGetRecordsCache
implements GetRecordsCache {
    private static final Log log = LogFactory.getLog(PrefetchGetRecordsCache.class);
    private static final String EXPIRED_ITERATOR_METRIC = "ExpiredIterator";
    LinkedBlockingQueue<ProcessRecordsInput> getRecordsResultQueue;
    private int maxPendingProcessRecordsInput;
    private int maxByteSize;
    private int maxRecordsCount;
    private final int maxRecordsPerCall;
    private final GetRecordsRetrievalStrategy getRecordsRetrievalStrategy;
    private final ExecutorService executorService;
    private final IMetricsFactory metricsFactory;
    private final long idleMillisBetweenCalls;
    private Instant lastSuccessfulCall;
    private final DefaultGetRecordsCacheDaemon defaultGetRecordsCacheDaemon;
    private PrefetchCounters prefetchCounters;
    private boolean started = false;
    private final String operation;
    private final KinesisDataFetcher dataFetcher;
    private final String shardId;

    public PrefetchGetRecordsCache(int maxPendingProcessRecordsInput, int maxByteSize, int maxRecordsCount, int maxRecordsPerCall, @NonNull GetRecordsRetrievalStrategy getRecordsRetrievalStrategy, @NonNull ExecutorService executorService, long idleMillisBetweenCalls, @NonNull IMetricsFactory metricsFactory, @NonNull String operation, @NonNull String shardId) {
        if (getRecordsRetrievalStrategy == null) {
            throw new NullPointerException("getRecordsRetrievalStrategy");
        }
        if (executorService == null) {
            throw new NullPointerException("executorService");
        }
        if (metricsFactory == null) {
            throw new NullPointerException("metricsFactory");
        }
        if (operation == null) {
            throw new NullPointerException("operation");
        }
        if (shardId == null) {
            throw new NullPointerException("shardId");
        }
        this.getRecordsRetrievalStrategy = getRecordsRetrievalStrategy;
        this.maxRecordsPerCall = maxRecordsPerCall;
        this.maxPendingProcessRecordsInput = maxPendingProcessRecordsInput;
        this.maxByteSize = maxByteSize;
        this.maxRecordsCount = maxRecordsCount;
        this.getRecordsResultQueue = new LinkedBlockingQueue(this.maxPendingProcessRecordsInput);
        this.prefetchCounters = new PrefetchCounters();
        this.executorService = executorService;
        this.metricsFactory = new ThreadSafeMetricsDelegatingFactory(metricsFactory);
        this.idleMillisBetweenCalls = idleMillisBetweenCalls;
        this.defaultGetRecordsCacheDaemon = new DefaultGetRecordsCacheDaemon();
        Validate.notEmpty(operation, "Operation cannot be empty");
        this.operation = operation;
        this.dataFetcher = this.getRecordsRetrievalStrategy.getDataFetcher();
        this.shardId = shardId;
    }

    @Override
    public void start() {
        if (this.executorService.isShutdown()) {
            throw new IllegalStateException("ExecutorService has been shutdown.");
        }
        if (!this.started) {
            log.info("Starting prefetching thread.");
            this.executorService.execute(this.defaultGetRecordsCacheDaemon);
        }
        this.started = true;
    }

    @Override
    public ProcessRecordsInput getNextResult() {
        if (this.executorService.isShutdown()) {
            throw new IllegalStateException("Shutdown has been called on the cache, can't accept new requests.");
        }
        if (!this.started) {
            throw new IllegalStateException("Cache has not been initialized, make sure to call start.");
        }
        ProcessRecordsInput result = null;
        try {
            result = this.getRecordsResultQueue.take().withCacheExitTime(Instant.now());
            this.prefetchCounters.removed(result);
        }
        catch (InterruptedException e) {
            log.error("Interrupted while getting records from the cache", e);
        }
        return result;
    }

    @Override
    public GetRecordsRetrievalStrategy getGetRecordsRetrievalStrategy() {
        return this.getRecordsRetrievalStrategy;
    }

    @Override
    public void shutdown() {
        this.defaultGetRecordsCacheDaemon.isShutdown = true;
        this.executorService.shutdownNow();
        this.started = false;
    }

    private class PrefetchCounters {
        private long size = 0L;
        private long byteSize = 0L;

        private PrefetchCounters() {
        }

        public synchronized void added(ProcessRecordsInput result) {
            this.size += this.getSize(result);
            this.byteSize += this.getByteSize(result);
        }

        public synchronized void removed(ProcessRecordsInput result) {
            this.size -= this.getSize(result);
            this.byteSize -= this.getByteSize(result);
            this.notifyAll();
        }

        private long getSize(ProcessRecordsInput result) {
            return result.getRecords().size();
        }

        private long getByteSize(ProcessRecordsInput result) {
            return result.getRecords().stream().mapToLong(record -> record.getData().array().length).sum();
        }

        public synchronized void waitForConsumer() throws InterruptedException {
            if (!this.shouldGetNewRecords()) {
                log.debug("Queue is full waiting for consumer for " + PrefetchGetRecordsCache.this.idleMillisBetweenCalls + " ms");
                this.wait(PrefetchGetRecordsCache.this.idleMillisBetweenCalls);
            }
        }

        public synchronized boolean shouldGetNewRecords() {
            if (log.isDebugEnabled()) {
                log.debug("Current Prefetch Counter States: " + this.toString());
            }
            return this.size < (long)PrefetchGetRecordsCache.this.maxRecordsCount && this.byteSize < (long)PrefetchGetRecordsCache.this.maxByteSize;
        }

        public String toString() {
            return String.format("{ Requests: %d, Records: %d, Bytes: %d }", PrefetchGetRecordsCache.this.getRecordsResultQueue.size(), this.size, this.byteSize);
        }
    }

    private class DefaultGetRecordsCacheDaemon
    implements Runnable {
        volatile boolean isShutdown = false;

        private DefaultGetRecordsCacheDaemon() {
        }

        @Override
        public void run() {
            while (!this.isShutdown) {
                if (Thread.currentThread().isInterrupted()) {
                    log.warn("Prefetch thread was interrupted.");
                    break;
                }
                MetricsHelper.startScope(PrefetchGetRecordsCache.this.metricsFactory, PrefetchGetRecordsCache.this.operation);
                if (PrefetchGetRecordsCache.this.prefetchCounters.shouldGetNewRecords()) {
                    try {
                        this.sleepBeforeNextCall();
                        GetRecordsResult getRecordsResult = PrefetchGetRecordsCache.this.getRecordsRetrievalStrategy.getRecords(PrefetchGetRecordsCache.this.maxRecordsPerCall);
                        PrefetchGetRecordsCache.this.lastSuccessfulCall = Instant.now();
                        ProcessRecordsInput processRecordsInput = new ProcessRecordsInput().withRecords(getRecordsResult.getRecords()).withMillisBehindLatest(getRecordsResult.getMillisBehindLatest()).withCacheEntryTime(PrefetchGetRecordsCache.this.lastSuccessfulCall);
                        PrefetchGetRecordsCache.this.getRecordsResultQueue.put(processRecordsInput);
                        PrefetchGetRecordsCache.this.prefetchCounters.added(processRecordsInput);
                        continue;
                    }
                    catch (InterruptedException e) {
                        log.info("Thread was interrupted, indicating shutdown was called on the cache.");
                        continue;
                    }
                    catch (ExpiredIteratorException e) {
                        log.info(String.format("ShardId %s: getRecords threw ExpiredIteratorException - restarting after greatest seqNum passed to customer", PrefetchGetRecordsCache.this.shardId), e);
                        MetricsHelper.getMetricsScope().addData(PrefetchGetRecordsCache.EXPIRED_ITERATOR_METRIC, 1.0, StandardUnit.Count, MetricsLevel.SUMMARY);
                        PrefetchGetRecordsCache.this.dataFetcher.restartIterator();
                        continue;
                    }
                    catch (SdkClientException e) {
                        log.error("Exception thrown while fetching records from Kinesis", e);
                        continue;
                    }
                    catch (Throwable e) {
                        log.error("Unexpected exception was thrown. This could probably be an issue or a bug. Please search for the exception/error online to check what is going on. If the issue persists or is a recurring problem, feel free to open an issue on, https://github.com/awslabs/amazon-kinesis-client.", e);
                        continue;
                    }
                    finally {
                        MetricsHelper.endScope();
                        continue;
                    }
                }
                try {
                    PrefetchGetRecordsCache.this.prefetchCounters.waitForConsumer();
                }
                catch (InterruptedException ie) {
                    log.info("Thread was interrupted while waiting for the consumer.  Shutdown has probably been started");
                }
            }
            this.callShutdownOnStrategy();
        }

        private void callShutdownOnStrategy() {
            if (!PrefetchGetRecordsCache.this.getRecordsRetrievalStrategy.isShutdown()) {
                PrefetchGetRecordsCache.this.getRecordsRetrievalStrategy.shutdown();
            }
        }

        private void sleepBeforeNextCall() throws InterruptedException {
            if (PrefetchGetRecordsCache.this.lastSuccessfulCall == null) {
                return;
            }
            long timeSinceLastCall = Duration.between(PrefetchGetRecordsCache.this.lastSuccessfulCall, Instant.now()).abs().toMillis();
            if (timeSinceLastCall < PrefetchGetRecordsCache.this.idleMillisBetweenCalls) {
                Thread.sleep(PrefetchGetRecordsCache.this.idleMillisBetweenCalls - timeSinceLastCall);
            }
        }
    }
}

